"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Groundtruthlabeling = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [groundtruthlabeling](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongroundtruthlabeling.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Groundtruthlabeling extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [groundtruthlabeling](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongroundtruthlabeling.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'groundtruthlabeling';
        this.accessLevelList = {
            Write: [
                'AssociatePatchToManifestJob',
                'RunFilterOrSampleDatasetJob',
                'RunGenerateManifestByCrawlingJob'
            ],
            Read: [
                'DescribeConsoleJob',
                'ListDatasetObjects'
            ]
        };
    }
    /**
     * Grants permission to associate a patch file with the manifest file to update the manifest file
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toAssociatePatchToManifestJob() {
        return this.to('AssociatePatchToManifestJob');
    }
    /**
     * Grants permission to get status of GroundTruthLabeling Jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toDescribeConsoleJob() {
        return this.to('DescribeConsoleJob');
    }
    /**
     * Grants permission to list dataset objects in a manifest file
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toListDatasetObjects() {
        return this.to('ListDatasetObjects');
    }
    /**
     * Grants permission to filter records from a manifest file using S3 select. Get sample entries based on random sampling
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-data-filtering
     */
    toRunFilterOrSampleDatasetJob() {
        return this.to('RunFilterOrSampleDatasetJob');
    }
    /**
     * Grants permission to list a S3 prefix and create manifest files from objects in that location
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toRunGenerateManifestByCrawlingJob() {
        return this.to('RunGenerateManifestByCrawlingJob');
    }
}
exports.Groundtruthlabeling = Groundtruthlabeling;
_a = JSII_RTTI_SYMBOL_1;
Groundtruthlabeling[_a] = { fqn: "cdk-iam-floyd.Groundtruthlabeling", version: "0.350.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ3JvdW5kdHJ1dGhsYWJlbGluZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImdyb3VuZHRydXRobGFiZWxpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFDQSxzQ0FBNEM7QUFHNUM7Ozs7R0FJRztBQUNILE1BQWEsbUJBQW9CLFNBQVEsd0JBQWU7SUFzRXREOzs7T0FHRztJQUNILFlBQVksS0FBZ0M7UUFDMUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBMUVSLGtCQUFhLEdBQUcscUJBQXFCLENBQUM7UUF5RG5DLG9CQUFlLEdBQW9CO1lBQzNDLEtBQUssRUFBRTtnQkFDTCw2QkFBNkI7Z0JBQzdCLDZCQUE2QjtnQkFDN0Isa0NBQWtDO2FBQ25DO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLG9CQUFvQjtnQkFDcEIsb0JBQW9CO2FBQ3JCO1NBQ0YsQ0FBQztJQVFGLENBQUM7SUF6RUQ7Ozs7OztPQU1HO0lBQ0ksNkJBQTZCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxvQkFBb0I7UUFDekIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9CQUFvQjtRQUN6QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksNkJBQTZCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQ0FBa0M7UUFDdkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtDQUFrQyxDQUFDLENBQUM7SUFDckQsQ0FBQzs7QUF4REgsa0RBNkVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQWNjZXNzTGV2ZWxMaXN0IH0gZnJvbSAnLi4vc2hhcmVkL2FjY2Vzcy1sZXZlbCc7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tICcuLi9zaGFyZWQnO1xuaW1wb3J0IHsgYXdzX2lhbSBhcyBpYW0gfSBmcm9tIFwiYXdzLWNkay1saWJcIjtcblxuLyoqXG4gKiBTdGF0ZW1lbnQgcHJvdmlkZXIgZm9yIHNlcnZpY2UgW2dyb3VuZHRydXRobGFiZWxpbmddKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zZXJ2aWNlLWF1dGhvcml6YXRpb24vbGF0ZXN0L3JlZmVyZW5jZS9saXN0X2FtYXpvbmdyb3VuZHRydXRobGFiZWxpbmcuaHRtbCkuXG4gKlxuICogQHBhcmFtIHNpZCBbU0lEXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX3NpZC5odG1sKSBvZiB0aGUgc3RhdGVtZW50XG4gKi9cbmV4cG9ydCBjbGFzcyBHcm91bmR0cnV0aGxhYmVsaW5nIGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAnZ3JvdW5kdHJ1dGhsYWJlbGluZyc7XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGFzc29jaWF0ZSBhIHBhdGNoIGZpbGUgd2l0aCB0aGUgbWFuaWZlc3QgZmlsZSB0byB1cGRhdGUgdGhlIG1hbmlmZXN0IGZpbGVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2FnZW1ha2VyL2xhdGVzdC9kZy9zbXMtZGF0YS1pbnB1dC5odG1sI3Ntcy1jb25zb2xlLWNyZWF0ZS1tYW5pZmVzdC1maWxlXG4gICAqL1xuICBwdWJsaWMgdG9Bc3NvY2lhdGVQYXRjaFRvTWFuaWZlc3RKb2IoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Fzc29jaWF0ZVBhdGNoVG9NYW5pZmVzdEpvYicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCBzdGF0dXMgb2YgR3JvdW5kVHJ1dGhMYWJlbGluZyBKb2JzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2FnZW1ha2VyL2xhdGVzdC9kZy9zbXMtZGF0YS1pbnB1dC5odG1sI3Ntcy1jb25zb2xlLWNyZWF0ZS1tYW5pZmVzdC1maWxlXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZUNvbnNvbGVKb2IoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlQ29uc29sZUpvYicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgZGF0YXNldCBvYmplY3RzIGluIGEgbWFuaWZlc3QgZmlsZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NhZ2VtYWtlci9sYXRlc3QvZGcvc21zLWRhdGEtaW5wdXQuaHRtbCNzbXMtY29uc29sZS1jcmVhdGUtbWFuaWZlc3QtZmlsZVxuICAgKi9cbiAgcHVibGljIHRvTGlzdERhdGFzZXRPYmplY3RzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0RGF0YXNldE9iamVjdHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBmaWx0ZXIgcmVjb3JkcyBmcm9tIGEgbWFuaWZlc3QgZmlsZSB1c2luZyBTMyBzZWxlY3QuIEdldCBzYW1wbGUgZW50cmllcyBiYXNlZCBvbiByYW5kb20gc2FtcGxpbmdcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2FnZW1ha2VyL2xhdGVzdC9kZy9zbXMtZGF0YS1pbnB1dC5odG1sI3Ntcy1kYXRhLWZpbHRlcmluZ1xuICAgKi9cbiAgcHVibGljIHRvUnVuRmlsdGVyT3JTYW1wbGVEYXRhc2V0Sm9iKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdSdW5GaWx0ZXJPclNhbXBsZURhdGFzZXRKb2InKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IGEgUzMgcHJlZml4IGFuZCBjcmVhdGUgbWFuaWZlc3QgZmlsZXMgZnJvbSBvYmplY3RzIGluIHRoYXQgbG9jYXRpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2FnZW1ha2VyL2xhdGVzdC9kZy9zbXMtZGF0YS1pbnB1dC5odG1sI3Ntcy1jb25zb2xlLWNyZWF0ZS1tYW5pZmVzdC1maWxlXG4gICAqL1xuICBwdWJsaWMgdG9SdW5HZW5lcmF0ZU1hbmlmZXN0QnlDcmF3bGluZ0pvYigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnUnVuR2VuZXJhdGVNYW5pZmVzdEJ5Q3Jhd2xpbmdKb2InKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBXcml0ZTogW1xuICAgICAgJ0Fzc29jaWF0ZVBhdGNoVG9NYW5pZmVzdEpvYicsXG4gICAgICAnUnVuRmlsdGVyT3JTYW1wbGVEYXRhc2V0Sm9iJyxcbiAgICAgICdSdW5HZW5lcmF0ZU1hbmlmZXN0QnlDcmF3bGluZ0pvYidcbiAgICBdLFxuICAgIFJlYWQ6IFtcbiAgICAgICdEZXNjcmliZUNvbnNvbGVKb2InLFxuICAgICAgJ0xpc3REYXRhc2V0T2JqZWN0cydcbiAgICBdXG4gIH07XG5cbiAgLyoqXG4gICAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbZ3JvdW5kdHJ1dGhsYWJlbGluZ10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYW1hem9uZ3JvdW5kdHJ1dGhsYWJlbGluZy5odG1sKS5cbiAgICpcbiAgICovXG4gIGNvbnN0cnVjdG9yKHByb3BzPzogaWFtLlBvbGljeVN0YXRlbWVudFByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuICB9XG59XG4iXX0=