"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lookoutmetrics = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [lookoutmetrics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlookoutformetrics.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Lookoutmetrics extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [lookoutmetrics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlookoutformetrics.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'lookoutmetrics';
        this.accessLevelList = {
            Write: [
                'ActivateAnomalyDetector',
                'BackTestAnomalyDetector',
                'CreateAlert',
                'CreateAnomalyDetector',
                'CreateMetricSet',
                'DeactivateAnomalyDetector',
                'DeleteAlert',
                'DeleteAnomalyDetector',
                'PutFeedback',
                'UpdateAnomalyDetector',
                'UpdateMetricSet'
            ],
            Read: [
                'DescribeAlert',
                'DescribeAnomalyDetectionExecutions',
                'DescribeAnomalyDetector',
                'DescribeMetricSet',
                'GetAnomalyGroup',
                'GetDataQualityMetrics',
                'GetFeedback',
                'GetSampleData',
                'ListTagsForResource'
            ],
            List: [
                'ListAlerts',
                'ListAnomalyDetectors',
                'ListAnomalyGroupRelatedMetrics',
                'ListAnomalyGroupSummaries',
                'ListAnomalyGroupTimeSeries',
                'ListMetricSets'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to activate an anomaly detector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ActivateAnomalyDetector.html
     */
    toActivateAnomalyDetector() {
        return this.to('ActivateAnomalyDetector');
    }
    /**
     * Grants permission to run a backtest with an anomaly detector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_BackTestAnomalyDetector.html
     */
    toBackTestAnomalyDetector() {
        return this.to('BackTestAnomalyDetector');
    }
    /**
     * Grants permission to create an alert for an anomaly detector
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_CreateAlert.html
     */
    toCreateAlert() {
        return this.to('CreateAlert');
    }
    /**
     * Grants permission to create an anomaly detector
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_CreateAnomalyDetector.html
     */
    toCreateAnomalyDetector() {
        return this.to('CreateAnomalyDetector');
    }
    /**
     * Grants permission to create a dataset
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_CreateMetricSet.html
     */
    toCreateMetricSet() {
        return this.to('CreateMetricSet');
    }
    /**
     * Grants permission to deactivate an anomaly detector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DeactivateAnomalyDetector.html
     */
    toDeactivateAnomalyDetector() {
        return this.to('DeactivateAnomalyDetector');
    }
    /**
     * Grants permission to delete an alert
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DeleteAlert.html
     */
    toDeleteAlert() {
        return this.to('DeleteAlert');
    }
    /**
     * Grants permission to delete an anomaly detector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DeleteAnomalyDetector.html
     */
    toDeleteAnomalyDetector() {
        return this.to('DeleteAnomalyDetector');
    }
    /**
     * Grants permission to get details about an alert
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DescribeAlert.html
     */
    toDescribeAlert() {
        return this.to('DescribeAlert');
    }
    /**
     * Grants permission to get information about an anomaly detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DescribeAnomalyDetectionExecutions.html
     */
    toDescribeAnomalyDetectionExecutions() {
        return this.to('DescribeAnomalyDetectionExecutions');
    }
    /**
     * Grants permission to get details about an anomaly detector
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DescribeAnomalyDetector.html
     */
    toDescribeAnomalyDetector() {
        return this.to('DescribeAnomalyDetector');
    }
    /**
     * Grants permission to get details about a dataset
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DescribeMetricSet.html
     */
    toDescribeMetricSet() {
        return this.to('DescribeMetricSet');
    }
    /**
     * Grants permission to get details about a group of affected metrics
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_GetAnomalyGroup.html
     */
    toGetAnomalyGroup() {
        return this.to('GetAnomalyGroup');
    }
    /**
     * Grants permission to get data quality metrics for an anomaly detector
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_GetDataQualityMetrics.html
     */
    toGetDataQualityMetrics() {
        return this.to('GetDataQualityMetrics');
    }
    /**
     * Grants permission to get feedback on affected metrics for an anomaly group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_GetFeedback.html
     */
    toGetFeedback() {
        return this.to('GetFeedback');
    }
    /**
     * Grants permission to get a selection of sample records from an Amazon S3 datasource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_GetSampleData.html
     */
    toGetSampleData() {
        return this.to('GetSampleData');
    }
    /**
     * Grants permission to get a list of alerts for a detector
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListAlerts.html
     */
    toListAlerts() {
        return this.to('ListAlerts');
    }
    /**
     * Grants permission to get a list of anomaly detectors
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListAnomalyDetectors.html
     */
    toListAnomalyDetectors() {
        return this.to('ListAnomalyDetectors');
    }
    /**
     * Grants permission to get a list of related measures in an anomaly group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListAnomalyGroupRelatedMetrics.html
     */
    toListAnomalyGroupRelatedMetrics() {
        return this.to('ListAnomalyGroupRelatedMetrics');
    }
    /**
     * Grants permission to get a list of anomaly groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListAnomalyGroupSummaries.html
     */
    toListAnomalyGroupSummaries() {
        return this.to('ListAnomalyGroupSummaries');
    }
    /**
     * Grants permission to get a list of affected metrics for a measure in an anomaly group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListAnomalyGroupTimeSeries.html
     */
    toListAnomalyGroupTimeSeries() {
        return this.to('ListAnomalyGroupTimeSeries');
    }
    /**
     * Grants permission to get a list of datasets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListMetricSets.html
     */
    toListMetricSets() {
        return this.to('ListMetricSets');
    }
    /**
     * Grants permission to get a list of tags for a detector, dataset, or alert
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to add feedback for an affected metric in an anomaly group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_PutFeedback.html
     */
    toPutFeedback() {
        return this.to('PutFeedback');
    }
    /**
     * Grants permission to add tags to a detector, dataset, or alert
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from a detector, dataset, or alert
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update an anomaly detector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_UpdateAnomalyDetector.html
     */
    toUpdateAnomalyDetector() {
        return this.to('UpdateAnomalyDetector');
    }
    /**
     * Grants permission to update a dataset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_UpdateMetricSet.html
     */
    toUpdateMetricSet() {
        return this.to('UpdateMetricSet');
    }
    /**
     * Adds a resource of type AnomalyDetector to the statement
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_AnomalyDetectorSummary.html
     *
     * @param anomalyDetectorName - Identifier for the anomalyDetectorName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAnomalyDetector(anomalyDetectorName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:lookoutmetrics:${region || '*'}:${account || '*'}:AnomalyDetector:${anomalyDetectorName}`);
    }
    /**
     * Adds a resource of type MetricSet to the statement
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_MetricSetSummary.html
     *
     * @param anomalyDetectorName - Identifier for the anomalyDetectorName.
     * @param metricSetName - Identifier for the metricSetName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMetricSet(anomalyDetectorName, metricSetName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:lookoutmetrics:${region || '*'}:${account || '*'}:MetricSet/${anomalyDetectorName}/${metricSetName}`);
    }
    /**
     * Adds a resource of type Alert to the statement
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_AlertSummary.html
     *
     * @param alertName - Identifier for the alertName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAlert(alertName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:lookoutmetrics:${region || '*'}:${account || '*'}:Alert:${alertName}`);
    }
}
exports.Lookoutmetrics = Lookoutmetrics;
_a = JSII_RTTI_SYMBOL_1;
Lookoutmetrics[_a] = { fqn: "cdk-iam-floyd.Lookoutmetrics", version: "0.350.0" };
//# sourceMappingURL=data:application/json;base64,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