import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [personalize](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpersonalize.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Personalize extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a batch inference job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateBatchInferenceJob.html
     */
    toCreateBatchInferenceJob(): this;
    /**
     * Grants permission to create a batch segment job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateBatchSegmentJob.html
     */
    toCreateBatchSegmentJob(): this;
    /**
     * Grants permission to create a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html
     */
    toCreateCampaign(): this;
    /**
     * Grants permission to create a dataset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html
     */
    toCreateDataset(): this;
    /**
     * Grants permission to create a dataset export job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html
     */
    toCreateDatasetExportJob(): this;
    /**
     * Grants permission to create a dataset group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html
     */
    toCreateDatasetGroup(): this;
    /**
     * Grants permission to create a dataset import job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html
     */
    toCreateDatasetImportJob(): this;
    /**
     * Grants permission to create an event tracker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html
     */
    toCreateEventTracker(): this;
    /**
     * Grants permission to create a filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateFilter.html
     */
    toCreateFilter(): this;
    /**
     * Grants permission to create a recommender
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html
     */
    toCreateRecommender(): this;
    /**
     * Grants permission to create a schema
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html
     */
    toCreateSchema(): this;
    /**
     * Grants permission to create a solution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html
     */
    toCreateSolution(): this;
    /**
     * Grants permission to create a solution version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html
     */
    toCreateSolutionVersion(): this;
    /**
     * Grants permission to delete a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteCampaign.html
     */
    toDeleteCampaign(): this;
    /**
     * Grants permission to delete a dataset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDataset.html
     */
    toDeleteDataset(): this;
    /**
     * Grants permission to delete a dataset group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDatasetGroup.html
     */
    toDeleteDatasetGroup(): this;
    /**
     * Grants permission to delete an event tracker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteEventTracker.html
     */
    toDeleteEventTracker(): this;
    /**
     * Grants permission to delete a filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteFilter.html
     */
    toDeleteFilter(): this;
    /**
     * Grants permission to delete a recommender
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteRecommender.html
     */
    toDeleteRecommender(): this;
    /**
     * Grants permission to delete a schema
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSchema.html
     */
    toDeleteSchema(): this;
    /**
     * Grants permission to delete a solution including all versions of the solution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html
     */
    toDeleteSolution(): this;
    /**
     * Grants permission to describe an algorithm
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeAlgorithm.html
     */
    toDescribeAlgorithm(): this;
    /**
     * Grants permission to describe a batch inference job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeBatchInferenceJob.html
     */
    toDescribeBatchInferenceJob(): this;
    /**
     * Grants permission to describe a batch segment job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeBatchSegmentJob.html
     */
    toDescribeBatchSegmentJob(): this;
    /**
     * Grants permission to describe a campaign
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html
     */
    toDescribeCampaign(): this;
    /**
     * Grants permission to describe a dataset
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html
     */
    toDescribeDataset(): this;
    /**
     * Grants permission to describe a dataset export job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetExportJob.html
     */
    toDescribeDatasetExportJob(): this;
    /**
     * Grants permission to describe a dataset group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html
     */
    toDescribeDatasetGroup(): this;
    /**
     * Grants permission to describe a dataset import job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html
     */
    toDescribeDatasetImportJob(): this;
    /**
     * Grants permission to describe an event tracker
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html
     */
    toDescribeEventTracker(): this;
    /**
     * Grants permission to describe a feature transformation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeFeatureTransformation.html
     */
    toDescribeFeatureTransformation(): this;
    /**
     * Grants permission to describe a filter
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeFilter.html
     */
    toDescribeFilter(): this;
    /**
     * Grants permission to describe a recipe
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecipe.html
     */
    toDescribeRecipe(): this;
    /**
     * Grants permission to describe a recommender
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html
     */
    toDescribeRecommender(): this;
    /**
     * Grants permission to describe a schema
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSchema.html
     */
    toDescribeSchema(): this;
    /**
     * Grants permission to describe a solution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html
     */
    toDescribeSolution(): this;
    /**
     * Grants permission to describe a version of a solution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html
     */
    toDescribeSolutionVersion(): this;
    /**
     * Grants permission to get a re-ranked list of recommendations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetPersonalizedRanking.html
     */
    toGetPersonalizedRanking(): this;
    /**
     * Grants permission to get a list of recommendations from a campaign
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html
     */
    toGetRecommendations(): this;
    /**
     * Grants permission to get metrics for a solution version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_GetSolutionMetrics.html
     */
    toGetSolutionMetrics(): this;
    /**
     * Grants permission to list batch inference jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListBatchInferenceJobs.html
     */
    toListBatchInferenceJobs(): this;
    /**
     * Grants permission to list batch segment jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListBatchSegmentJobs.html
     */
    toListBatchSegmentJobs(): this;
    /**
     * Grants permission to list campaigns
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html
     */
    toListCampaigns(): this;
    /**
     * Grants permission to list dataset export jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetExportJobs.html
     */
    toListDatasetExportJobs(): this;
    /**
     * Grants permission to list dataset groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetGroups.html
     */
    toListDatasetGroups(): this;
    /**
     * Grants permission to list dataset import jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetImportJobs.html
     */
    toListDatasetImportJobs(): this;
    /**
     * Grants permission to list datasets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasets.html
     */
    toListDatasets(): this;
    /**
     * Grants permission to list event trackers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListEventTrackers.html
     */
    toListEventTrackers(): this;
    /**
     * Grants permission to list filters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListFilters.html
     */
    toListFilters(): this;
    /**
     * Grants permission to list recipes
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListRecipes.html
     */
    toListRecipes(): this;
    /**
     * Grants permission to list recommenders
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListRecommenders.html
     */
    toListRecommenders(): this;
    /**
     * Grants permission to list schemas
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListSchemas.html
     */
    toListSchemas(): this;
    /**
     * Grants permission to list versions of a solution
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html
     */
    toListSolutionVersions(): this;
    /**
     * Grants permission to list solutions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html
     */
    toListSolutions(): this;
    /**
     * Grants permission to put real time event data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html
     */
    toPutEvents(): this;
    /**
     * Grants permission to ingest Items data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutItems.html
     */
    toPutItems(): this;
    /**
     * Grants permission to ingest Users data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutUsers.html
     */
    toPutUsers(): this;
    /**
     * Grants permission to stop a solution version creation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_StopSolutionVersionCreation.html
     */
    toStopSolutionVersionCreation(): this;
    /**
     * Grants permission to update a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateCampaign.html
     */
    toUpdateCampaign(): this;
    /**
     * Grants permission to update a recommender
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateRecommender.html
     */
    toUpdateRecommender(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type schema to the statement
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/how-it-works-dataset-schema.html#schema-examples
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSchema(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type featureTransformation to the statement
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_FeatureTransformation.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onFeatureTransformation(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type dataset to the statement
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_Dataset.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onDataset(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type datasetGroup to the statement
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DatasetGroup.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onDatasetGroup(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type datasetImportJob to the statement
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DatasetImportJob.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onDatasetImportJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type datasetExportJob to the statement
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DatasetExportJob.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onDatasetExportJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type solution to the statement
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_Solution.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSolution(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type campaign to the statement
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_Campaign.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onCampaign(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type eventTracker to the statement
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_EventTracker.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onEventTracker(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type recipe to the statement
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_Recipe.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onRecipe(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type algorithm to the statement
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_Algorithm.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onAlgorithm(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type batchInferenceJob to the statement
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_BatchInferenceJob.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onBatchInferenceJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type filter to the statement
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_Filter.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onFilter(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type recommender to the statement
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_Recommender.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onRecommender(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type batchSegmentJob to the statement
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_BatchSegmentJob.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onBatchSegmentJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Statement provider for service [personalize](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpersonalize.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
