import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [sms-voice-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpinpointsmsvoicev2.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class SmsVoiceV2 extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to associate an origination phone number or sender ID to a pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_AssociateOriginationIdentity.html
     */
    toAssociateOriginationIdentity(): this;
    /**
     * Grants permission to create a configuration set
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sms-voice:TagResource
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_CreateConfigurationSet.html
     */
    toCreateConfigurationSet(): this;
    /**
     * Grants permission to create an event destination within a configuration set
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_CreateEventDestination.html
     */
    toCreateEventDestination(): this;
    /**
     * Grants permission to create an opt-out list
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sms-voice:TagResource
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_CreateOptOutList.html
     */
    toCreateOptOutList(): this;
    /**
     * Grants permission to create a pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sms-voice:TagResource
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_CreatePool.html
     */
    toCreatePool(): this;
    /**
     * Grants permission to delete a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteConfigurationSet.html
     */
    toDeleteConfigurationSet(): this;
    /**
     * Grants permission to delete the default message type for a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteDefaultMessageType.html
     */
    toDeleteDefaultMessageType(): this;
    /**
     * Grants permission to delete the default sender ID for a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteDefaultSenderId.html
     */
    toDeleteDefaultSenderId(): this;
    /**
     * Grants permission to delete an event destination within a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteEventDestination.html
     */
    toDeleteEventDestination(): this;
    /**
     * Grants permission to delete a keyword for a pool or origination phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteKeyword.html
     */
    toDeleteKeyword(): this;
    /**
     * Grants permission to delete an opt-out list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteOptOutList.html
     */
    toDeleteOptOutList(): this;
    /**
     * Grants permission to delete a destination phone number from an opt-out list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteOptedOutNumber.html
     */
    toDeleteOptedOutNumber(): this;
    /**
     * Grants permission to delete a pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeletePool.html
     */
    toDeletePool(): this;
    /**
     * Grants permission to delete an override for your account's text messaging monthly spend limit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteTextMessageSpendLimitOverride.html
     */
    toDeleteTextMessageSpendLimitOverride(): this;
    /**
     * Grants permission to delete an override for your account's voice messaging monthly spend limit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DeleteVoiceMessageSpendLimitOverride.html
     */
    toDeleteVoiceMessageSpendLimitOverride(): this;
    /**
     * Grants permission to describe the attributes of your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeAccountAttributes.html
     */
    toDescribeAccountAttributes(): this;
    /**
     * Grants permission to describe the service quotas for your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeAccountLimits.html
     */
    toDescribeAccountLimits(): this;
    /**
     * Grants permission to describe the configuration sets in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeConfigurationSets.html
     */
    toDescribeConfigurationSets(): this;
    /**
     * Grants permission to describe the keywords for a pool or origination phone number
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeKeywords.html
     */
    toDescribeKeywords(): this;
    /**
     * Grants permission to describe the opt-out lists in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeOptOutLists.html
     */
    toDescribeOptOutLists(): this;
    /**
     * Grants permission to describe the destination phone numbers in an opt-out list
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeOptedOutNumbers.html
     */
    toDescribeOptedOutNumbers(): this;
    /**
     * Grants permission to describe the origination phone numbers in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribePhoneNumbers.html
     */
    toDescribePhoneNumbers(): this;
    /**
     * Grants permission to describe the pools in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribePools.html
     */
    toDescribePools(): this;
    /**
     * Grants permission to describe the sender IDs in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeSenderIds.html
     */
    toDescribeSenderIds(): this;
    /**
     * Grants permission to describe the monthly spend limits for your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeSpendLimits.html
     */
    toDescribeSpendLimits(): this;
    /**
     * Grants permission to disassociate an origination phone number or sender ID from a pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DisassociateOriginationIdentity.html
     */
    toDisassociateOriginationIdentity(): this;
    /**
     * Grants permission to list all origination phone numbers and sender IDs associated to a pool
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_ListPoolOriginationIdentities.html
     */
    toListPoolOriginationIdentities(): this;
    /**
     * Grants permission to list the tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to create or update a keyword for a pool or origination phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_PutKeyword.html
     */
    toPutKeyword(): this;
    /**
     * Grants permission to put a destination phone number into an opt-out list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_PutOptedOutNumber.html
     */
    toPutOptedOutNumber(): this;
    /**
     * Grants permission to release an origination phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_ReleasePhoneNumber.html
     */
    toReleasePhoneNumber(): this;
    /**
     * Grants permission to request an origination phone number
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sms-voice:AssociateOriginationIdentity
     * - sms-voice:TagResource
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_RequestPhoneNumber.html
     */
    toRequestPhoneNumber(): this;
    /**
     * Grants permission to send a text message to a destination phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_SendTextMessage.html
     */
    toSendTextMessage(): this;
    /**
     * Grants permission to send a voice message to a destination phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_SendVoiceMessage.html
     */
    toSendVoiceMessage(): this;
    /**
     * Grants permission to set the default message type for a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_SetDefaultMessageType.html
     */
    toSetDefaultMessageType(): this;
    /**
     * Grants permission to set the default sender ID for a configuration set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_SetDefaultSenderId.html
     */
    toSetDefaultSenderId(): this;
    /**
     * Grants permission to set an override for your account's text messaging monthly spend limit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_SetTextMessageSpendLimitOverride.html
     */
    toSetTextMessageSpendLimitOverride(): this;
    /**
     * Grants permission to set an override for your account's voice messaging monthly spend limit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_SetVoiceMessageSpendLimitOverride.html
     */
    toSetVoiceMessageSpendLimitOverride(): this;
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an event destination within a configuration set
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_UpdateEventDestination.html
     */
    toUpdateEventDestination(): this;
    /**
     * Grants permission to update an origination phone number's configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_UpdatePhoneNumber.html
     */
    toUpdatePhoneNumber(): this;
    /**
     * Grants permission to update a pool's configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_UpdatePool.html
     */
    toUpdatePool(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type ConfigurationSet to the statement
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_CreateConfigurationSet.html
     *
     * @param configurationSetName - Identifier for the configurationSetName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfigurationSet(configurationSetName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type OptOutList to the statement
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_CreateOptOutList.html
     *
     * @param optOutListName - Identifier for the optOutListName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOptOutList(optOutListName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type PhoneNumber to the statement
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_RequestPhoneNumber.html
     *
     * @param phoneNumberId - Identifier for the phoneNumberId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPhoneNumber(phoneNumberId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Pool to the statement
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_CreatePool.html
     *
     * @param poolId - Identifier for the poolId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPool(poolId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type SenderId to the statement
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice-v2/latest/apireference/API_DescribeSenderIds.html
     *
     * @param senderId - Identifier for the senderId.
     * @param isoCountryCode - Identifier for the isoCountryCode.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSenderId(senderId: string, isoCountryCode: string, account?: string, region?: string, partition?: string): this;
    /**
     * Statement provider for service [sms-voice-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpinpointsmsvoicev2.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
