"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Textract = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [textract](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontextract.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Textract extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [textract](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontextract.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'textract';
        this.accessLevelList = {
            Read: [
                'AnalyzeDocument',
                'AnalyzeExpense',
                'AnalyzeID',
                'DetectDocumentText',
                'GetDocumentAnalysis',
                'GetDocumentTextDetection',
                'GetExpenseAnalysis'
            ],
            Write: [
                'StartDocumentAnalysis',
                'StartDocumentTextDetection',
                'StartExpenseAnalysis'
            ]
        };
    }
    /**
     * Grants permission to detect instances of real-world document entities within an image provided as input
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeDocument.html
     */
    toAnalyzeDocument() {
        return this.to('AnalyzeDocument');
    }
    /**
     * Grants permission to detect instances of real-world document entities within an image provided as input
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeExpense.html
     */
    toAnalyzeExpense() {
        return this.to('AnalyzeExpense');
    }
    /**
     * Grants permission to detect relevant information from identity documents provided as input
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeID.html
     */
    toAnalyzeID() {
        return this.to('AnalyzeID');
    }
    /**
     * Grants permission to detect text in document images
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_DetectDocumentText.html
     */
    toDetectDocumentText() {
        return this.to('DetectDocumentText');
    }
    /**
     * Grants permission to return information about a document analysis job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentAnalysis.html
     */
    toGetDocumentAnalysis() {
        return this.to('GetDocumentAnalysis');
    }
    /**
     * Grants permission to return information about a document text detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentTextDetection.html
     */
    toGetDocumentTextDetection() {
        return this.to('GetDocumentTextDetection');
    }
    /**
     * Grants permission to return information about an expense analysis job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetExpenseAnalysis.html
     */
    toGetExpenseAnalysis() {
        return this.to('GetExpenseAnalysis');
    }
    /**
     * Grants permission to start an asynchronous job to detect instances of real-world document entities within an image or pdf provided as input
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentAnalysis.html
     */
    toStartDocumentAnalysis() {
        return this.to('StartDocumentAnalysis');
    }
    /**
     * Grants permission to start an asynchronous job to detect text in document images or pdfs
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentTextDetection.html
     */
    toStartDocumentTextDetection() {
        return this.to('StartDocumentTextDetection');
    }
    /**
     * Grants permission to start an asynchronous job to detect instances of invoices or receipts within an image or pdf provided as input
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartExpenseAnalysis.html
     */
    toStartExpenseAnalysis() {
        return this.to('StartExpenseAnalysis');
    }
}
exports.Textract = Textract;
_a = JSII_RTTI_SYMBOL_1;
Textract[_a] = { fqn: "cdk-iam-floyd.Textract", version: "0.350.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGV4dHJhY3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXh0cmFjdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLHNDQUE0QztBQUc1Qzs7OztHQUlHO0FBQ0gsTUFBYSxRQUFTLFNBQVEsd0JBQWU7SUF1SjNDOzs7T0FHRztJQUNILFlBQVksS0FBZ0M7UUFDMUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBM0pSLGtCQUFhLEdBQUcsVUFBVSxDQUFDO1FBcUl4QixvQkFBZSxHQUFvQjtZQUMzQyxJQUFJLEVBQUU7Z0JBQ0osaUJBQWlCO2dCQUNqQixnQkFBZ0I7Z0JBQ2hCLFdBQVc7Z0JBQ1gsb0JBQW9CO2dCQUNwQixxQkFBcUI7Z0JBQ3JCLDBCQUEwQjtnQkFDMUIsb0JBQW9CO2FBQ3JCO1lBQ0QsS0FBSyxFQUFFO2dCQUNMLHVCQUF1QjtnQkFDdkIsNEJBQTRCO2dCQUM1QixzQkFBc0I7YUFDdkI7U0FDRixDQUFDO0lBUUYsQ0FBQztJQTFKRDs7Ozs7Ozs7O09BU0c7SUFDSSxpQkFBaUI7UUFDdEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDcEMsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLGdCQUFnQjtRQUNyQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNuQyxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksV0FBVztRQUNoQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDOUIsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLG9CQUFvQjtRQUN6QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9CQUFvQjtRQUN6QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksdUJBQXVCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSw0QkFBNEI7UUFDakMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDOztBQXBJSCw0QkE4SkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBY2Nlc3NMZXZlbExpc3QgfSBmcm9tICcuLi9zaGFyZWQvYWNjZXNzLWxldmVsJztcbmltcG9ydCB7IFBvbGljeVN0YXRlbWVudCB9IGZyb20gJy4uL3NoYXJlZCc7XG5pbXBvcnQgeyBhd3NfaWFtIGFzIGlhbSB9IGZyb20gXCJhd3MtY2RrLWxpYlwiO1xuXG4vKipcbiAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbdGV4dHJhY3RdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zZXJ2aWNlLWF1dGhvcml6YXRpb24vbGF0ZXN0L3JlZmVyZW5jZS9saXN0X2FtYXpvbnRleHRyYWN0Lmh0bWwpLlxuICpcbiAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICovXG5leHBvcnQgY2xhc3MgVGV4dHJhY3QgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICd0ZXh0cmFjdCc7XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRldGVjdCBpbnN0YW5jZXMgb2YgcmVhbC13b3JsZCBkb2N1bWVudCBlbnRpdGllcyB3aXRoaW4gYW4gaW1hZ2UgcHJvdmlkZWQgYXMgaW5wdXRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIHMzOkdldE9iamVjdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vdGV4dHJhY3QvbGF0ZXN0L2RnL0FQSV9BbmFseXplRG9jdW1lbnQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQW5hbHl6ZURvY3VtZW50KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdBbmFseXplRG9jdW1lbnQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZXRlY3QgaW5zdGFuY2VzIG9mIHJlYWwtd29ybGQgZG9jdW1lbnQgZW50aXRpZXMgd2l0aGluIGFuIGltYWdlIHByb3ZpZGVkIGFzIGlucHV0XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBzMzpHZXRPYmplY3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3RleHRyYWN0L2xhdGVzdC9kZy9BUElfQW5hbHl6ZUV4cGVuc2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQW5hbHl6ZUV4cGVuc2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0FuYWx5emVFeHBlbnNlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGV0ZWN0IHJlbGV2YW50IGluZm9ybWF0aW9uIGZyb20gaWRlbnRpdHkgZG9jdW1lbnRzIHByb3ZpZGVkIGFzIGlucHV0XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBzMzpHZXRPYmplY3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3RleHRyYWN0L2xhdGVzdC9kZy9BUElfQW5hbHl6ZUlELmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0FuYWx5emVJRCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQW5hbHl6ZUlEJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGV0ZWN0IHRleHQgaW4gZG9jdW1lbnQgaW1hZ2VzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBzMzpHZXRPYmplY3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3RleHRyYWN0L2xhdGVzdC9kZy9BUElfRGV0ZWN0RG9jdW1lbnRUZXh0Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RldGVjdERvY3VtZW50VGV4dCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGV0ZWN0RG9jdW1lbnRUZXh0Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gcmV0dXJuIGluZm9ybWF0aW9uIGFib3V0IGEgZG9jdW1lbnQgYW5hbHlzaXMgam9iXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vdGV4dHJhY3QvbGF0ZXN0L2RnL0FQSV9HZXREb2N1bWVudEFuYWx5c2lzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldERvY3VtZW50QW5hbHlzaXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldERvY3VtZW50QW5hbHlzaXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byByZXR1cm4gaW5mb3JtYXRpb24gYWJvdXQgYSBkb2N1bWVudCB0ZXh0IGRldGVjdGlvbiBqb2JcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS90ZXh0cmFjdC9sYXRlc3QvZGcvQVBJX0dldERvY3VtZW50VGV4dERldGVjdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXREb2N1bWVudFRleHREZXRlY3Rpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldERvY3VtZW50VGV4dERldGVjdGlvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHJldHVybiBpbmZvcm1hdGlvbiBhYm91dCBhbiBleHBlbnNlIGFuYWx5c2lzIGpvYlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3RleHRyYWN0L2xhdGVzdC9kZy9BUElfR2V0RXhwZW5zZUFuYWx5c2lzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEV4cGVuc2VBbmFseXNpcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0RXhwZW5zZUFuYWx5c2lzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gc3RhcnQgYW4gYXN5bmNocm9ub3VzIGpvYiB0byBkZXRlY3QgaW5zdGFuY2VzIG9mIHJlYWwtd29ybGQgZG9jdW1lbnQgZW50aXRpZXMgd2l0aGluIGFuIGltYWdlIG9yIHBkZiBwcm92aWRlZCBhcyBpbnB1dFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIHMzOkdldE9iamVjdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vdGV4dHJhY3QvbGF0ZXN0L2RnL0FQSV9TdGFydERvY3VtZW50QW5hbHlzaXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvU3RhcnREb2N1bWVudEFuYWx5c2lzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTdGFydERvY3VtZW50QW5hbHlzaXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBzdGFydCBhbiBhc3luY2hyb25vdXMgam9iIHRvIGRldGVjdCB0ZXh0IGluIGRvY3VtZW50IGltYWdlcyBvciBwZGZzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogRGVwZW5kZW50IGFjdGlvbnM6XG4gICAqIC0gczM6R2V0T2JqZWN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS90ZXh0cmFjdC9sYXRlc3QvZGcvQVBJX1N0YXJ0RG9jdW1lbnRUZXh0RGV0ZWN0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1N0YXJ0RG9jdW1lbnRUZXh0RGV0ZWN0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTdGFydERvY3VtZW50VGV4dERldGVjdGlvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHN0YXJ0IGFuIGFzeW5jaHJvbm91cyBqb2IgdG8gZGV0ZWN0IGluc3RhbmNlcyBvZiBpbnZvaWNlcyBvciByZWNlaXB0cyB3aXRoaW4gYW4gaW1hZ2Ugb3IgcGRmIHByb3ZpZGVkIGFzIGlucHV0XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogRGVwZW5kZW50IGFjdGlvbnM6XG4gICAqIC0gczM6R2V0T2JqZWN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS90ZXh0cmFjdC9sYXRlc3QvZGcvQVBJX1N0YXJ0RXhwZW5zZUFuYWx5c2lzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1N0YXJ0RXhwZW5zZUFuYWx5c2lzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTdGFydEV4cGVuc2VBbmFseXNpcycpO1xuICB9XG5cbiAgcHJvdGVjdGVkIGFjY2Vzc0xldmVsTGlzdDogQWNjZXNzTGV2ZWxMaXN0ID0ge1xuICAgIFJlYWQ6IFtcbiAgICAgICdBbmFseXplRG9jdW1lbnQnLFxuICAgICAgJ0FuYWx5emVFeHBlbnNlJyxcbiAgICAgICdBbmFseXplSUQnLFxuICAgICAgJ0RldGVjdERvY3VtZW50VGV4dCcsXG4gICAgICAnR2V0RG9jdW1lbnRBbmFseXNpcycsXG4gICAgICAnR2V0RG9jdW1lbnRUZXh0RGV0ZWN0aW9uJyxcbiAgICAgICdHZXRFeHBlbnNlQW5hbHlzaXMnXG4gICAgXSxcbiAgICBXcml0ZTogW1xuICAgICAgJ1N0YXJ0RG9jdW1lbnRBbmFseXNpcycsXG4gICAgICAnU3RhcnREb2N1bWVudFRleHREZXRlY3Rpb24nLFxuICAgICAgJ1N0YXJ0RXhwZW5zZUFuYWx5c2lzJ1xuICAgIF1cbiAgfTtcblxuICAvKipcbiAgICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFt0ZXh0cmFjdF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYW1hem9udGV4dHJhY3QuaHRtbCkuXG4gICAqXG4gICAqL1xuICBjb25zdHJ1Y3Rvcihwcm9wcz86IGlhbS5Qb2xpY3lTdGF0ZW1lbnRQcm9wcykge1xuICAgIHN1cGVyKHByb3BzKTtcbiAgfVxufVxuIl19