# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins
import datetime
import typing
from enum import Enum, auto

class PyAgentType:
    r"""
    agent class
    """
    organization: builtins.str
    namespace: builtins.str
    agent_type: builtins.str
    def __new__(cls,agent_org:builtins.str, agent_ns:builtins.str, agent_class:builtins.str): ...

class PyFireAndForgetConfiguration:
    r"""
    fire and forget session config
    """
    def __new__(cls,): ...
    ...

class PyGatewayConfig:
    r"""
    gatewayconfig class
    """
    endpoint: builtins.str
    insecure: builtins.bool
    insecure_skip_verify: builtins.bool
    tls_ca_path: typing.Optional[builtins.str]
    tls_ca_pem: typing.Optional[builtins.str]
    tls_cert_path: typing.Optional[builtins.str]
    tls_key_path: typing.Optional[builtins.str]
    tls_cert_pem: typing.Optional[builtins.str]
    tls_key_pem: typing.Optional[builtins.str]
    basic_auth_username: typing.Optional[builtins.str]
    basic_auth_password: typing.Optional[builtins.str]
    def __new__(cls,endpoint:builtins.str, insecure:builtins.bool=False, insecure_skip_verify:builtins.bool=False, tls_ca_path:typing.Optional[builtins.str]=None, tls_ca_pem:typing.Optional[builtins.str]=None, tls_cert_path:typing.Optional[builtins.str]=None, tls_key_path:typing.Optional[builtins.str]=None, tls_cert_pem:typing.Optional[builtins.str]=None, tls_key_pem:typing.Optional[builtins.str]=None, basic_auth_username:typing.Optional[builtins.str]=None, basic_auth_password:typing.Optional[builtins.str]=None): ...

class PyRequestResponseConfiguration:
    r"""
    request response session config
    """
    max_retries: builtins.int
    timeout: builtins.int
    def __new__(cls,max_retries:builtins.int=0, timeout:builtins.int=1000): ...
    def set_max_retries(self, max_retries:builtins.int) -> None:
        ...

    def set_timeout(self, timeout:builtins.int) -> None:
        ...


class PyService:
    id: builtins.int
    def configure(self, config:PyGatewayConfig) -> None:
        ...


class PySessionInfo:
    id: builtins.int
    def __new__(cls,session_id:builtins.int): ...

class PyStreamingConfiguration:
    r"""
    streaming session config
    """
    direction: PySessionDirection
    topic: typing.Optional[PyAgentType]
    max_retries: builtins.int
    def __new__(cls,direction:PySessionDirection, topic:typing.Optional[PyAgentType], max_retries:typing.Optional[builtins.int]=None, timeout:typing.Optional[datetime.timedelta]=None): ...

class PySessionDirection(Enum):
    r"""
    session direction
    """
    SENDER = auto()
    RECEIVER = auto()
    BIDIRECTIONAL = auto()

def connect(svc:PyService) -> typing.Any:
    ...

def create_ff_session(svc:PyService, config:PyFireAndForgetConfiguration=...) -> typing.Any:
    ...

def create_rr_session(svc:PyService, config:PyRequestResponseConfiguration=...) -> typing.Any:
    ...

def create_streaming_session(svc:PyService, config:PyStreamingConfiguration) -> typing.Any:
    ...

def disconnect(svc:PyService, conn:builtins.int) -> typing.Any:
    ...

def publish(svc:PyService, session_info:PySessionInfo, fanout:builtins.int, blob:typing.Sequence[builtins.int], name:typing.Optional[PyAgentType]=None, id:typing.Optional[builtins.int]=None) -> typing.Any:
    ...

def receive(svc:PyService) -> typing.Any:
    ...

def remove_route(svc:PyService, conn:builtins.int, name:PyAgentType, id:typing.Optional[builtins.int]=None) -> typing.Any:
    ...

def serve(svc:PyService) -> typing.Any:
    ...

def set_route(svc:PyService, conn:builtins.int, name:PyAgentType, id:typing.Optional[builtins.int]=None) -> typing.Any:
    ...

def stop(svc:PyService) -> typing.Any:
    ...

def subscribe(svc:PyService, conn:builtins.int, name:PyAgentType, id:typing.Optional[builtins.int]=None) -> typing.Any:
    ...

def unsubscribe(svc:PyService, conn:builtins.int, name:PyAgentType, id:typing.Optional[builtins.int]=None) -> typing.Any:
    ...

