export declare class Statement {
    /**
     * Inline statement for policy
     * @returns `InlineStatement` with inline statement.
     * @param statement The actual statement
     */
    static fromInline(statement: string): string;
    /**
     * Loads the statement from a local disk path.
     * @returns `DirectoryStatement` with statement from file path.
     * @param path A path with the policy statement
     */
    static fromFile(path: string): string;
}
