"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Statement = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
/*
 * Represents the Policy Statement.
 */
class Statement {
    /**
     * Inline statement for policy
     * @returns `InlineStatement` with inline statement.
     * @param statement The actual statement
     */
    static fromInline(statement) {
        if (statement.length === 0) {
            throw new Error('Policies inline statement cannot be empty');
        }
        return statement;
    }
    /**
     * Loads the statement from a local disk path.
     * @returns `DirectoryStatement` with statement from file path.
     * @param path A path with the policy statement
     */
    static fromFile(path) {
        if (path.length === 0) {
            throw new Error('Policy path cannot be empty');
        }
        return (0, fs_1.readFileSync)(path, 'utf-8');
    }
}
exports.Statement = Statement;
_a = JSII_RTTI_SYMBOL_1;
Statement[_a] = { fqn: "@cdklabs/cdk-verified-permissions.Statement", version: "0.0.1-alpha.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhdGVtZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3N0YXRlbWVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDJCQUFrQztBQUNsQzs7R0FFRztBQUNILE1BQWEsU0FBUztJQUNwQjs7OztPQUlHO0lBQ0ksTUFBTSxDQUFDLFVBQVUsQ0FBQyxTQUFpQjtRQUN4QyxJQUFJLFNBQVMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO1lBQzFCLE1BQU0sSUFBSSxLQUFLLENBQUMsMkNBQTJDLENBQUMsQ0FBQztTQUM5RDtRQUNELE9BQU8sU0FBUyxDQUFDO0lBQ25CLENBQUM7SUFFRDs7OztPQUlHO0lBQ0ksTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFZO1FBQ2pDLElBQUksSUFBSSxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7WUFDckIsTUFBTSxJQUFJLEtBQUssQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO1NBQ2hEO1FBQ0QsT0FBTyxJQUFBLGlCQUFZLEVBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBQ3JDLENBQUM7O0FBdkJILDhCQXdCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IHJlYWRGaWxlU3luYyB9IGZyb20gJ2ZzJztcbi8qXG4gKiBSZXByZXNlbnRzIHRoZSBQb2xpY3kgU3RhdGVtZW50LlxuICovXG5leHBvcnQgY2xhc3MgU3RhdGVtZW50IHtcbiAgLyoqXG4gICAqIElubGluZSBzdGF0ZW1lbnQgZm9yIHBvbGljeVxuICAgKiBAcmV0dXJucyBgSW5saW5lU3RhdGVtZW50YCB3aXRoIGlubGluZSBzdGF0ZW1lbnQuXG4gICAqIEBwYXJhbSBzdGF0ZW1lbnQgVGhlIGFjdHVhbCBzdGF0ZW1lbnRcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUlubGluZShzdGF0ZW1lbnQ6IHN0cmluZyk6IHN0cmluZyB7XG4gICAgaWYgKHN0YXRlbWVudC5sZW5ndGggPT09IDApIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignUG9saWNpZXMgaW5saW5lIHN0YXRlbWVudCBjYW5ub3QgYmUgZW1wdHknKTtcbiAgICB9XG4gICAgcmV0dXJuIHN0YXRlbWVudDtcbiAgfVxuXG4gIC8qKlxuICAgKiBMb2FkcyB0aGUgc3RhdGVtZW50IGZyb20gYSBsb2NhbCBkaXNrIHBhdGguXG4gICAqIEByZXR1cm5zIGBEaXJlY3RvcnlTdGF0ZW1lbnRgIHdpdGggc3RhdGVtZW50IGZyb20gZmlsZSBwYXRoLlxuICAgKiBAcGFyYW0gcGF0aCBBIHBhdGggd2l0aCB0aGUgcG9saWN5IHN0YXRlbWVudFxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tRmlsZShwYXRoOiBzdHJpbmcpOiBzdHJpbmcge1xuICAgIGlmIChwYXRoLmxlbmd0aCA9PT0gMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdQb2xpY3kgcGF0aCBjYW5ub3QgYmUgZW1wdHknKTtcbiAgICB9XG4gICAgcmV0dXJuIHJlYWRGaWxlU3luYyhwYXRoLCAndXRmLTgnKTtcbiAgfVxufVxuIl19