import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermHealthcareServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/healthcare_service.html#location DataAzurermHealthcareService#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/healthcare_service.html#name DataAzurermHealthcareService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/healthcare_service.html#resource_group_name DataAzurermHealthcareService#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/healthcare_service.html#timeouts DataAzurermHealthcareService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermHealthcareServiceTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermHealthcareServiceAuthenticationConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get audience(): string;
    /**
     * @stability stable
     */
    get authority(): string;
    /**
     * @stability stable
     */
    get smartProxyEnabled(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermHealthcareServiceCorsConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get allowCredentials(): any;
    /**
     * @stability stable
     */
    get allowedHeaders(): string[];
    /**
     * @stability stable
     */
    get allowedMethods(): string[];
    /**
     * @stability stable
     */
    get allowedOrigins(): string[];
    /**
     * @stability stable
     */
    get maxAgeInSeconds(): number;
}
/**
 * @stability stable
 */
export interface DataAzurermHealthcareServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/healthcare_service.html#read DataAzurermHealthcareService#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermHealthcareServiceTimeoutsToTerraform(struct?: DataAzurermHealthcareServiceTimeoutsOutputReference | DataAzurermHealthcareServiceTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermHealthcareServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermHealthcareServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermHealthcareServiceTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/healthcare_service.html azurerm_healthcare_service}.
 *
 * @stability stable
 */
export declare class DataAzurermHealthcareService extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/healthcare_service.html azurerm_healthcare_service} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermHealthcareServiceConfig);
    /**
     * @stability stable
     */
    get accessPolicyObjectIds(): string[];
    /**
     * @stability stable
     */
    authenticationConfiguration(index: string): DataAzurermHealthcareServiceAuthenticationConfiguration;
    /**
     * @stability stable
     */
    corsConfiguration(index: string): DataAzurermHealthcareServiceCorsConfiguration;
    /**
     * @stability stable
     */
    get cosmosdbKeyVaultKeyVersionlessId(): string;
    /**
     * @stability stable
     */
    get cosmosdbThroughput(): number;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get kind(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermHealthcareServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermHealthcareServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermHealthcareServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
