"use strict";
/* istanbul ignore file */
Object.defineProperty(exports, "__esModule", { value: true });
// eslint-disable-next-line import/no-extraneous-dependencies
const aws = require("aws-sdk");
const tls = require("tls");
const url = require("url");
let client;
function iam() {
    if (!client) {
        client = new aws.IAM();
    }
    return client;
}
function defaultLogger(fmt, ...args) {
    // tslint:disable-next-line: no-console
    console.log(fmt, ...args);
}
/**
 * Downloads the CA thumbprint from the issuer URL
 */
async function downloadThumbprint(issuerUrl) {
    exports.external.log(`downloading certificate authority thumbprint for ${issuerUrl}`);
    return new Promise((ok, ko) => {
        const purl = url.parse(issuerUrl);
        const port = purl.port ? parseInt(purl.port, 10) : 443;
        if (!purl.host) {
            return ko(new Error(`unable to determine host from issuer url ${issuerUrl}`));
        }
        const socket = tls.connect(port, purl.host, { rejectUnauthorized: false });
        socket.once('error', ko);
        socket.once('secureConnect', () => {
            const cert = socket.getPeerCertificate();
            socket.end();
            const thumbprint = cert.fingerprint.split(':').join('');
            exports.external.log(`certificate authority thumbprint for ${issuerUrl} is ${thumbprint}`);
            ok(thumbprint);
        });
    });
}
// allows unit test to replace with mocks
// tslint:disable:max-line-length
exports.external = {
    downloadThumbprint,
    log: defaultLogger,
    createOpenIDConnectProvider: (req) => iam().createOpenIDConnectProvider(req).promise(),
    deleteOpenIDConnectProvider: (req) => iam().deleteOpenIDConnectProvider(req).promise(),
    updateOpenIDConnectProviderThumbprint: (req) => iam().updateOpenIDConnectProviderThumbprint(req).promise(),
    addClientIDToOpenIDConnectProvider: (req) => iam().addClientIDToOpenIDConnectProvider(req).promise(),
    removeClientIDFromOpenIDConnectProvider: (req) => iam().removeClientIDFromOpenIDConnectProvider(req).promise(),
};
//# sourceMappingURL=data:application/json;base64,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