"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineEditorFactory = exports.commandIDs = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const pipeline_editor_1 = require("@elyra/pipeline-editor");
const pipeline_services_1 = require("@elyra/pipeline-services");
const services_1 = require("@elyra/services");
const ui_components_1 = require("@elyra/ui-components");
const apputils_1 = require("@jupyterlab/apputils");
const coreutils_1 = require("@jupyterlab/coreutils");
const docregistry_1 = require("@jupyterlab/docregistry");
require("carbon-components/css/carbon-components.min.css");
const algorithm_1 = require("@lumino/algorithm");
const signaling_1 = require("@lumino/signaling");
const core_1 = require("@material-ui/core");
const Alert_1 = __importDefault(require("@material-ui/lab/Alert"));
const react_1 = __importStar(require("react"));
const EmptyPipelineContent_1 = require("./EmptyPipelineContent");
const formDialogWidget_1 = require("./formDialogWidget");
const pipeline_hooks_1 = require("./pipeline-hooks");
const PipelineExportDialog_1 = require("./PipelineExportDialog");
const pipelineProperties_1 = __importDefault(require("./pipelineProperties"));
const PipelineService_1 = require("./PipelineService");
const PipelineSubmissionDialog_1 = require("./PipelineSubmissionDialog");
const runtime_utils_1 = require("./runtime-utils");
const theme_1 = require("./theme");
const PIPELINE_CLASS = 'elyra-PipelineEditor';
exports.commandIDs = {
    openPipelineEditor: 'pipeline-editor:open',
    openMetadata: 'elyra-metadata:open',
    openDocManager: 'docmanager:open',
    newDocManager: 'docmanager:new-untitled',
    saveDocManager: 'docmanager:save',
    submitScript: 'script-editor:submit',
    submitNotebook: 'notebook:submit',
    addFileToPipeline: 'pipeline-editor:add-node'
};
const getAllPaletteNodes = (palette) => {
    if (palette.categories === undefined) {
        return [];
    }
    const nodes = [];
    for (const c of palette.categories) {
        if (c.node_types) {
            nodes.push(...c.node_types);
        }
    }
    return nodes;
};
const isRuntimeTypeAvailable = (data, type) => {
    for (const p of data.platforms) {
        if (type === undefined || p.id === type) {
            if (p.configs.length > 0) {
                return true;
            }
        }
    }
    return false;
};
const getDisplayName = (runtimesSchema, type) => {
    if (!type) {
        return undefined;
    }
    const schema = runtimesSchema === null || runtimesSchema === void 0 ? void 0 : runtimesSchema.find((s) => s.runtime_type === type);
    return schema === null || schema === void 0 ? void 0 : schema.title;
};
class PipelineEditorWidget extends apputils_1.ReactWidget {
    constructor(options) {
        super(options);
        this.browserFactory = options.browserFactory;
        this.shell = options.shell;
        this.commands = options.commands;
        this.addFileToPipelineSignal = options.addFileToPipelineSignal;
        this.context = options.context;
    }
    render() {
        var _a;
        return (jsx_runtime_1.jsx(PipelineWrapper, { context: this.context, browserFactory: this.browserFactory, shell: this.shell, commands: this.commands, addFileToPipelineSignal: this.addFileToPipelineSignal, widgetId: (_a = this.parent) === null || _a === void 0 ? void 0 : _a.id }, void 0));
    }
}
const PipelineWrapper = ({ context, browserFactory, shell, commands, addFileToPipelineSignal, widgetId }) => {
    var _a, _b, _c, _d;
    const ref = react_1.useRef(null);
    const [loading, setLoading] = react_1.useState(true);
    const [pipeline, setPipeline] = react_1.useState(null);
    const [panelOpen, setPanelOpen] = react_1.default.useState(false);
    const [alert, setAlert] = react_1.default.useState('');
    const type = (_c = (_b = (_a = pipeline === null || pipeline === void 0 ? void 0 : pipeline.pipelines) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.app_data) === null || _c === void 0 ? void 0 : _c.runtime_type;
    const { data: runtimesSchema, error: runtimesSchemaError } = pipeline_hooks_1.useRuntimesSchema();
    const runtimeDisplayName = (_d = getDisplayName(runtimesSchema, type)) !== null && _d !== void 0 ? _d : 'Generic';
    // TODO: DELETE THIS
    const __doNotUseInFutureMapTypeToRandomProcessor__ = (() => {
        const schema = runtimesSchema === null || runtimesSchema === void 0 ? void 0 : runtimesSchema.find((s) => s.runtime_type === type);
        return schema === null || schema === void 0 ? void 0 : schema.name;
    })();
    const { data: palette, error: paletteError } = pipeline_hooks_1.usePalette(__doNotUseInFutureMapTypeToRandomProcessor__);
    const { data: runtimeImages, error: runtimeImagesError } = pipeline_hooks_1.useRuntimeImages();
    react_1.useEffect(() => {
        if ((runtimeImages === null || runtimeImages === void 0 ? void 0 : runtimeImages.length) === 0) {
            ui_components_1.RequestErrors.noMetadataError('runtime image');
        }
    }, [runtimeImages === null || runtimeImages === void 0 ? void 0 : runtimeImages.length]);
    react_1.useEffect(() => {
        if (paletteError) {
            ui_components_1.RequestErrors.serverError(paletteError);
        }
    }, [paletteError]);
    react_1.useEffect(() => {
        if (runtimeImagesError) {
            ui_components_1.RequestErrors.serverError(runtimeImagesError);
        }
    }, [runtimeImagesError]);
    react_1.useEffect(() => {
        if (runtimesSchemaError) {
            ui_components_1.RequestErrors.serverError(runtimesSchemaError);
        }
    }, [runtimesSchemaError]);
    const contextRef = react_1.useRef(context);
    react_1.useEffect(() => {
        const currentContext = contextRef.current;
        const changeHandler = () => {
            var _a, _b, _c, _d, _e, _f, _g, _h;
            const pipelineJson = currentContext.model.toJSON();
            // map IDs to display names
            const nodes = (_b = (_a = pipelineJson === null || pipelineJson === void 0 ? void 0 : pipelineJson.pipelines) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.nodes;
            if ((nodes === null || nodes === void 0 ? void 0 : nodes.length) > 0) {
                for (const node of nodes) {
                    if ((_d = (_c = node === null || node === void 0 ? void 0 : node.app_data) === null || _c === void 0 ? void 0 : _c.component_parameters) === null || _d === void 0 ? void 0 : _d.runtime_image) {
                        const image = runtimeImages === null || runtimeImages === void 0 ? void 0 : runtimeImages.find(i => i.metadata.image_name ===
                            node.app_data.component_parameters.runtime_image);
                        if (image) {
                            node.app_data.component_parameters.runtime_image =
                                image.display_name;
                        }
                    }
                    if ((_e = node === null || node === void 0 ? void 0 : node.app_data) === null || _e === void 0 ? void 0 : _e.component_parameters) {
                        for (const [key, val] of Object.entries((_f = node === null || node === void 0 ? void 0 : node.app_data) === null || _f === void 0 ? void 0 : _f.component_parameters)) {
                            if (val === null) {
                                node.app_data.component_parameters[key] = undefined;
                            }
                        }
                    }
                }
            }
            // TODO: don't persist this, but this will break things right now
            if ((_h = (_g = pipelineJson === null || pipelineJson === void 0 ? void 0 : pipelineJson.pipelines) === null || _g === void 0 ? void 0 : _g[0]) === null || _h === void 0 ? void 0 : _h.app_data) {
                if (!pipelineJson.pipelines[0].app_data.properties) {
                    pipelineJson.pipelines[0].app_data.properties = {};
                }
                const pipeline_path = contextRef.current.path;
                const pipeline_name = coreutils_1.PathExt.basename(pipeline_path, coreutils_1.PathExt.extname(pipeline_path));
                pipelineJson.pipelines[0].app_data.properties.name = pipeline_name;
                pipelineJson.pipelines[0].app_data.properties.runtime = runtimeDisplayName;
            }
            setPipeline(pipelineJson);
            setLoading(false);
        };
        currentContext.ready.then(changeHandler);
        currentContext.model.contentChanged.connect(changeHandler);
        return () => {
            currentContext.model.contentChanged.disconnect(changeHandler);
        };
    }, [runtimeImages, runtimeDisplayName]);
    const onChange = react_1.useCallback((pipelineJson) => {
        var _a, _b, _c, _d, _e, _f;
        if (contextRef.current.isReady) {
            if ((_b = (_a = pipelineJson === null || pipelineJson === void 0 ? void 0 : pipelineJson.pipelines) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.nodes) {
                // map display names to IDs
                const nodes = (_d = (_c = pipelineJson === null || pipelineJson === void 0 ? void 0 : pipelineJson.pipelines) === null || _c === void 0 ? void 0 : _c[0]) === null || _d === void 0 ? void 0 : _d.nodes;
                if ((nodes === null || nodes === void 0 ? void 0 : nodes.length) > 0) {
                    for (const node of nodes) {
                        if ((_f = (_e = node === null || node === void 0 ? void 0 : node.app_data) === null || _e === void 0 ? void 0 : _e.component_parameters) === null || _f === void 0 ? void 0 : _f.runtime_image) {
                            const image = runtimeImages === null || runtimeImages === void 0 ? void 0 : runtimeImages.find(i => i.display_name ===
                                node.app_data.component_parameters.runtime_image);
                            if (image) {
                                node.app_data.component_parameters.runtime_image =
                                    image.metadata.image_name;
                            }
                        }
                    }
                }
            }
            contextRef.current.model.fromString(JSON.stringify(pipelineJson, null, 2));
        }
    }, [runtimeImages]);
    const isDialogAlreadyShowing = react_1.useRef(false);
    const onError = react_1.useCallback((error) => {
        if (isDialogAlreadyShowing.current) {
            return; // bail, we are already showing a dialog.
        }
        isDialogAlreadyShowing.current = true;
        if (error instanceof pipeline_editor_1.PipelineOutOfDateError) {
            apputils_1.showDialog({
                title: 'Migrate pipeline?',
                body: (jsx_runtime_1.jsxs("p", { children: ["This pipeline corresponds to an older version of Elyra and needs to be migrated.", jsx_runtime_1.jsx("br", {}, void 0), "Although the pipeline can be further edited and/or submitted after its update,", jsx_runtime_1.jsx("br", {}, void 0), "the migration will not be completed until the pipeline has been saved within the editor.", jsx_runtime_1.jsx("br", {}, void 0),
                        jsx_runtime_1.jsx("br", {}, void 0), "Proceed with migration?"] }, void 0)),
                buttons: [apputils_1.Dialog.cancelButton(), apputils_1.Dialog.okButton()]
            }).then((result) => __awaiter(void 0, void 0, void 0, function* () {
                var _a;
                isDialogAlreadyShowing.current = false;
                if (result.button.accept) {
                    // proceed with migration
                    console.log('migrating pipeline');
                    let migrationPalette = palette;
                    const pipelineJSON = contextRef.current.model.toJSON();
                    const oldRuntime = pipelineJSON === null || pipelineJSON === void 0 ? void 0 : pipelineJSON.pipelines[0].app_data.runtime;
                    if (oldRuntime === 'kfp' || oldRuntime === 'airflow') {
                        migrationPalette = yield pipeline_hooks_1.componentFetcher(oldRuntime);
                    }
                    try {
                        const migratedPipeline = pipeline_services_1.migrate(pipelineJSON, migrationPalette, pipeline => {
                            // function for updating to relative paths in v2
                            // uses location of filename as expected in v1
                            for (const node of pipeline.nodes) {
                                node.app_data.filename = PipelineService_1.PipelineService.getPipelineRelativeNodePath(contextRef.current.path, node.app_data.filename);
                            }
                            return pipeline;
                        });
                        contextRef.current.model.fromString(JSON.stringify(migratedPipeline, null, 2));
                    }
                    catch (migrationError) {
                        if (migrationError instanceof pipeline_services_1.ComponentNotFoundError) {
                            apputils_1.showDialog({
                                title: 'Pipeline migration aborted!',
                                body: (jsx_runtime_1.jsxs("p", { children: [' ', "The pipeline you are trying to migrate uses example components, which are not ", jsx_runtime_1.jsx("br", {}, void 0), "enabled in your environment. Complete the setup instructions in", ' ', jsx_runtime_1.jsx("a", Object.assign({ href: "https://elyra.readthedocs.io/en/latest/user_guide/pipeline-components.html#example-custom-components", target: "_blank", rel: "noreferrer" }, { children: "Example Custom Components" }), void 0), ' ', "and try again."] }, void 0)),
                                buttons: [apputils_1.Dialog.okButton({ label: 'Close' })]
                            }).then(() => {
                                var _a;
                                (_a = shell.currentWidget) === null || _a === void 0 ? void 0 : _a.close();
                            });
                        }
                        else {
                            apputils_1.showDialog({
                                title: 'Pipeline migration failed!',
                                body: jsx_runtime_1.jsxs("p", { children: [" ", (migrationError === null || migrationError === void 0 ? void 0 : migrationError.message) || '', " "] }, void 0),
                                buttons: [apputils_1.Dialog.okButton()]
                            }).then(() => {
                                var _a;
                                (_a = shell.currentWidget) === null || _a === void 0 ? void 0 : _a.close();
                            });
                        }
                    }
                }
                else {
                    (_a = shell.currentWidget) === null || _a === void 0 ? void 0 : _a.close();
                }
            }));
        }
        else {
            apputils_1.showDialog({
                title: 'Load pipeline failed!',
                body: jsx_runtime_1.jsxs("p", { children: [" ", (error === null || error === void 0 ? void 0 : error.message) || '', " "] }, void 0),
                buttons: [apputils_1.Dialog.okButton()]
            }).then(() => {
                var _a;
                isDialogAlreadyShowing.current = false;
                (_a = shell.currentWidget) === null || _a === void 0 ? void 0 : _a.close();
            });
        }
    }, [palette, shell.currentWidget]);
    const onFileRequested = (args) => __awaiter(void 0, void 0, void 0, function* () {
        var _e;
        const filename = PipelineService_1.PipelineService.getWorkspaceRelativeNodePath(contextRef.current.path, (_e = args.filename) !== null && _e !== void 0 ? _e : '');
        switch (args.propertyID) {
            case 'elyra_dependencies':
                {
                    const res = yield ui_components_1.showBrowseFileDialog(browserFactory.defaultBrowser.model.manager, {
                        multiselect: true,
                        includeDir: true,
                        rootPath: coreutils_1.PathExt.dirname(filename),
                        filter: (model) => {
                            return model.path !== filename;
                        }
                    });
                    if (res.button.accept && res.value.length) {
                        return res.value.map((v) => v.path);
                    }
                }
                break;
            default:
                {
                    const res = yield ui_components_1.showBrowseFileDialog(browserFactory.defaultBrowser.model.manager, {
                        startPath: coreutils_1.PathExt.dirname(filename),
                        filter: (model) => {
                            var _a;
                            if (((_a = args.filters) === null || _a === void 0 ? void 0 : _a.File) === undefined) {
                                return true;
                            }
                            const ext = coreutils_1.PathExt.extname(model.path);
                            return args.filters.File.includes(ext);
                        }
                    });
                    if (res.button.accept && res.value.length) {
                        const file = PipelineService_1.PipelineService.getPipelineRelativeNodePath(contextRef.current.path, res.value[0].path);
                        return [file];
                    }
                }
                break;
        }
        return undefined;
    });
    const onPropertiesUpdateRequested = (args) => __awaiter(void 0, void 0, void 0, function* () {
        var _f;
        const path = PipelineService_1.PipelineService.getWorkspaceRelativeNodePath(contextRef.current.path, args.elyra_filename);
        const new_env_vars = yield services_1.ContentParser.getEnvVars(path).then((response) => response.map((str) => (str = str + '=')));
        const env_vars = (_f = args.elyra_env_vars) !== null && _f !== void 0 ? _f : [];
        const merged_env_vars = [
            ...env_vars,
            ...new_env_vars.filter((new_var) => !env_vars.some((old_var) => old_var.startsWith(new_var)))
        ];
        return {
            elyra_env_vars: merged_env_vars.filter(Boolean)
        };
    });
    const handleOpenFile = (data) => {
        var _a, _b;
        for (let i = 0; i < data.selectedObjectIds.length; i++) {
            const node = pipeline.pipelines[0].nodes.find((node) => node.id === data.selectedObjectIds[i]);
            if (!((_b = (_a = node === null || node === void 0 ? void 0 : node.app_data) === null || _a === void 0 ? void 0 : _a.component_parameters) === null || _b === void 0 ? void 0 : _b.filename)) {
                continue;
            }
            const path = PipelineService_1.PipelineService.getWorkspaceRelativeNodePath(contextRef.current.path, node.app_data.component_parameters.filename);
            commands.execute(exports.commandIDs.openDocManager, { path });
        }
    };
    const handleSubmission = react_1.useCallback((actionType) => __awaiter(void 0, void 0, void 0, function* () {
        var _g, _h, _j;
        const pipelineJson = context.model.toJSON();
        // Check that all nodes are valid
        const errorMessages = pipeline_services_1.validate(JSON.stringify(pipelineJson), getAllPaletteNodes(palette));
        if (errorMessages && errorMessages.length > 0) {
            let errorMessage = '';
            for (const error of errorMessages) {
                errorMessage += error.message;
            }
            setAlert(`Failed ${actionType}: ${errorMessage}`);
            return;
        }
        if (contextRef.current.model.dirty) {
            const dialogResult = yield apputils_1.showDialog({
                title: 'This pipeline contains unsaved changes. To submit the pipeline the changes need to be saved.',
                buttons: [
                    apputils_1.Dialog.cancelButton(),
                    apputils_1.Dialog.okButton({ label: 'Save and Submit' })
                ]
            });
            if (dialogResult.button && dialogResult.button.accept === true) {
                yield contextRef.current.save();
            }
            else {
                // Don't proceed if cancel button pressed
                return;
            }
        }
        const pipelineName = coreutils_1.PathExt.basename(contextRef.current.path, coreutils_1.PathExt.extname(contextRef.current.path));
        // TODO: Parallelize this
        const runtimes = yield PipelineService_1.PipelineService.getRuntimes().catch(error => ui_components_1.RequestErrors.serverError(error));
        const schema = yield PipelineService_1.PipelineService.getRuntimesSchema().catch(error => ui_components_1.RequestErrors.serverError(error));
        const runtimeTypes = yield PipelineService_1.PipelineService.getRuntimeTypes();
        const runtimeData = runtime_utils_1.createRuntimeData({
            schema,
            runtimes,
            allowLocal: actionType === 'run'
        });
        let title = type !== undefined
            ? `${actionType} pipeline for ${runtimeDisplayName}`
            : `${actionType} pipeline`;
        if (actionType === 'export' || type !== undefined) {
            if (!isRuntimeTypeAvailable(runtimeData, type)) {
                const res = yield ui_components_1.RequestErrors.noMetadataError('runtime', `${actionType} pipeline.`, type !== undefined ? runtimeDisplayName : undefined);
                if (res.button.label.includes(PipelineService_1.RUNTIMES_SCHEMASPACE)) {
                    // Open the runtimes widget
                    shell.activateById(`elyra-metadata:${PipelineService_1.RUNTIMES_SCHEMASPACE}`);
                }
                return;
            }
        }
        // Capitalize
        title = title.charAt(0).toUpperCase() + title.slice(1);
        let dialogOptions;
        switch (actionType) {
            case 'run':
                dialogOptions = {
                    title,
                    body: formDialogWidget_1.formDialogWidget(jsx_runtime_1.jsx(PipelineSubmissionDialog_1.PipelineSubmissionDialog, { name: pipelineName, runtimeData: runtimeData, pipelineType: type }, void 0)),
                    buttons: [apputils_1.Dialog.cancelButton(), apputils_1.Dialog.okButton()],
                    defaultButton: 1,
                    focusNodeSelector: '#pipeline_name'
                };
                break;
            case 'export':
                dialogOptions = {
                    title,
                    body: formDialogWidget_1.formDialogWidget(jsx_runtime_1.jsx(PipelineExportDialog_1.PipelineExportDialog, { runtimeData: runtimeData, runtimeTypeInfo: runtimeTypes, pipelineType: type }, void 0)),
                    buttons: [apputils_1.Dialog.cancelButton(), apputils_1.Dialog.okButton()],
                    defaultButton: 1,
                    focusNodeSelector: '#runtime_config'
                };
                break;
        }
        const dialogResult = yield ui_components_1.showFormDialog(dialogOptions);
        if (dialogResult.value == null) {
            // When Cancel is clicked on the dialog, just return
            return;
        }
        // Clean null properties
        for (const node of pipelineJson.pipelines[0].nodes) {
            if (node.app_data.component_parameters.cpu === null) {
                delete node.app_data.component_parameters.cpu;
            }
            if (node.app_data.component_parameters.memory === null) {
                delete node.app_data.component_parameters.memory;
            }
            if (node.app_data.component_parameters.gpu === null) {
                delete node.app_data.component_parameters.gpu;
            }
        }
        const configDetails = runtime_utils_1.getConfigDetails(runtimeData, dialogResult.value.runtime_config);
        PipelineService_1.PipelineService.setNodePathsRelativeToWorkspace(pipelineJson.pipelines[0], contextRef.current.path);
        // Metadata
        pipelineJson.pipelines[0].app_data.name = (_g = dialogResult.value.pipeline_name) !== null && _g !== void 0 ? _g : pipelineName;
        pipelineJson.pipelines[0].app_data.source = coreutils_1.PathExt.basename(contextRef.current.path);
        // Runtime info
        pipelineJson.pipelines[0].app_data.runtime_config = (_h = configDetails === null || configDetails === void 0 ? void 0 : configDetails.id) !== null && _h !== void 0 ? _h : 'local';
        // Export info
        const pipeline_dir = coreutils_1.PathExt.dirname(contextRef.current.path);
        const basePath = pipeline_dir ? `${pipeline_dir}/` : '';
        const exportType = dialogResult.value.pipeline_filetype;
        const exportPath = `${basePath}${pipelineName}.${exportType}`;
        switch (actionType) {
            case 'run':
                PipelineService_1.PipelineService.submitPipeline(pipelineJson, (_j = configDetails === null || configDetails === void 0 ? void 0 : configDetails.platform.displayName) !== null && _j !== void 0 ? _j : '').catch(error => ui_components_1.RequestErrors.serverError(error));
                break;
            case 'export':
                PipelineService_1.PipelineService.exportPipeline(pipelineJson, exportType, exportPath, dialogResult.value.overwrite).catch(error => ui_components_1.RequestErrors.serverError(error));
                break;
        }
    }), [context.model, palette, runtimeDisplayName, type, shell]);
    const handleClearPipeline = react_1.useCallback((data) => __awaiter(void 0, void 0, void 0, function* () {
        return apputils_1.showDialog({
            title: 'Clear Pipeline',
            body: 'Are you sure you want to clear the pipeline?',
            buttons: [apputils_1.Dialog.cancelButton(), apputils_1.Dialog.okButton({ label: 'Clear' })]
        }).then(result => {
            var _a, _b, _c, _d, _e, _f;
            if (result.button.accept) {
                const newPipeline = contextRef.current.model.toJSON();
                if (((_c = (_b = (_a = newPipeline === null || newPipeline === void 0 ? void 0 : newPipeline.pipelines) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.nodes) === null || _c === void 0 ? void 0 : _c.length) > 0) {
                    newPipeline.pipelines[0].nodes = [];
                }
                const pipelineProperties = (_f = (_e = (_d = newPipeline === null || newPipeline === void 0 ? void 0 : newPipeline.pipelines) === null || _d === void 0 ? void 0 : _d[0]) === null || _e === void 0 ? void 0 : _e.app_data) === null || _f === void 0 ? void 0 : _f.properties;
                if (pipelineProperties) {
                    // Remove all fields of pipeline properties except for the name/runtime (readonly)
                    newPipeline.pipelines[0].app_data.properties = {
                        name: pipelineProperties.name,
                        runtime: pipelineProperties.runtime
                    };
                }
                contextRef.current.model.fromJSON(newPipeline);
            }
        });
    }), []);
    const onAction = react_1.useCallback((args) => {
        switch (args.type) {
            case 'save':
                contextRef.current.save();
                break;
            case 'run':
            case 'export':
                handleSubmission(args.type);
                break;
            case 'clear':
                handleClearPipeline(args.payload);
                break;
            case 'toggleOpenPanel':
                setPanelOpen(!panelOpen);
                break;
            case 'properties':
                setPanelOpen(true);
                break;
            case 'openRuntimes':
                shell.activateById(`elyra-metadata:${PipelineService_1.RUNTIMES_SCHEMASPACE}`);
                break;
            case 'openRuntimeImages':
                shell.activateById(`elyra-metadata:${PipelineService_1.RUNTIME_IMAGES_SCHEMASPACE}`);
                break;
            case 'openComponentCatalogs':
                shell.activateById(`elyra-metadata:${PipelineService_1.COMPONENT_CATALOGS_SCHEMASPACE}`);
                break;
            case 'openFile':
                commands.execute(exports.commandIDs.openDocManager, {
                    path: PipelineService_1.PipelineService.getWorkspaceRelativeNodePath(contextRef.current.path, args.payload)
                });
                break;
            default:
                break;
        }
    }, [handleSubmission, handleClearPipeline, panelOpen, shell, commands]);
    const toolbar = {
        leftBar: [
            {
                action: 'run',
                label: 'Run Pipeline',
                enable: true
            },
            {
                action: 'save',
                label: 'Save Pipeline',
                enable: true,
                iconEnabled: ui_components_1.IconUtil.encode(ui_components_1.savePipelineIcon),
                iconDisabled: ui_components_1.IconUtil.encode(ui_components_1.savePipelineIcon)
            },
            {
                action: 'export',
                label: 'Export Pipeline',
                enable: true,
                iconEnabled: ui_components_1.IconUtil.encode(ui_components_1.exportPipelineIcon),
                iconDisabled: ui_components_1.IconUtil.encode(ui_components_1.exportPipelineIcon)
            },
            {
                action: 'clear',
                label: 'Clear Pipeline',
                enable: true,
                iconEnabled: ui_components_1.IconUtil.encode(ui_components_1.clearPipelineIcon),
                iconDisabled: ui_components_1.IconUtil.encode(ui_components_1.clearPipelineIcon)
            },
            {
                action: 'openRuntimes',
                label: 'Open Runtimes',
                enable: true,
                iconEnabled: ui_components_1.IconUtil.encode(ui_components_1.runtimesIcon),
                iconDisabled: ui_components_1.IconUtil.encode(ui_components_1.runtimesIcon)
            },
            {
                action: 'openRuntimeImages',
                label: 'Open Runtime Images',
                enable: true,
                iconEnabled: ui_components_1.IconUtil.encode(ui_components_1.containerIcon),
                iconDisabled: ui_components_1.IconUtil.encode(ui_components_1.containerIcon)
            },
            {
                action: 'openComponentCatalogs',
                label: 'Open Component Catalogs',
                enable: true,
                iconEnabled: ui_components_1.IconUtil.encode(ui_components_1.componentCatalogIcon),
                iconDisabled: ui_components_1.IconUtil.encode(ui_components_1.componentCatalogIcon)
            },
            { action: 'undo', label: 'Undo' },
            { action: 'redo', label: 'Redo' },
            { action: 'cut', label: 'Cut' },
            { action: 'copy', label: 'Copy' },
            { action: 'paste', label: 'Paste' },
            { action: 'createAutoComment', label: 'Add Comment', enable: true },
            { action: 'deleteSelectedObjects', label: 'Delete' },
            {
                action: 'arrangeHorizontally',
                label: 'Arrange Horizontally',
                enable: true
            },
            {
                action: 'arrangeVertically',
                label: 'Arrange Vertically',
                enable: true
            }
        ],
        rightBar: [
            {
                action: '',
                label: `Runtime: ${runtimeDisplayName}`,
                incLabelWithIcon: 'before',
                enable: false,
                kind: 'tertiary'
                // TODO: re-add icon
                // iconEnabled: IconUtil.encode(ICON_MAP[type ?? ''] ?? pipelineIcon)
            },
            {
                action: 'toggleOpenPanel',
                label: panelOpen ? 'Close Panel' : 'Open Panel',
                enable: true,
                iconTypeOverride: panelOpen ? 'paletteOpen' : 'paletteClose'
            }
        ]
    };
    const [defaultPosition, setDefaultPosition] = react_1.useState(10);
    const handleAddFileToPipeline = react_1.useCallback((location) => {
        var _a;
        const fileBrowser = browserFactory.defaultBrowser;
        // Only add file to pipeline if it is currently in focus
        if (((_a = shell.currentWidget) === null || _a === void 0 ? void 0 : _a.id) !== widgetId) {
            return;
        }
        let failedAdd = 0;
        let position = 0;
        const missingXY = !location;
        // if either x or y is undefined use the default coordinates
        if (missingXY) {
            position = defaultPosition;
            location = {
                x: 75,
                y: 85
            };
        }
        algorithm_1.toArray(fileBrowser.selectedItems()).map((item) => {
            var _a, _b, _c;
            if (PipelineService_1.PipelineService.isSupportedNode(item)) {
                item.op = PipelineService_1.PipelineService.getNodeType(item.path);
                item.path = PipelineService_1.PipelineService.getPipelineRelativeNodePath(contextRef.current.path, item.path);
                item.x = ((_a = location === null || location === void 0 ? void 0 : location.x) !== null && _a !== void 0 ? _a : 0) + position;
                item.y = ((_b = location === null || location === void 0 ? void 0 : location.y) !== null && _b !== void 0 ? _b : 0) + position;
                const success = (_c = ref.current) === null || _c === void 0 ? void 0 : _c.addFile({
                    nodeTemplate: {
                        op: item.op
                    },
                    offsetX: item.x,
                    offsetY: item.y,
                    path: item.path
                });
                if (success) {
                    position += 20;
                }
                else {
                    // handle error
                }
            }
            else {
                failedAdd++;
            }
        });
        // update position if the default coordinates were used
        if (missingXY) {
            setDefaultPosition(position);
        }
        if (failedAdd) {
            return apputils_1.showDialog({
                title: 'Unsupported File(s)',
                body: 'Only supported files (Notebooks, Python scripts, and R scripts) can be added to a pipeline.',
                buttons: [apputils_1.Dialog.okButton()]
            });
        }
        return;
    }, [browserFactory.defaultBrowser, defaultPosition, shell, widgetId]);
    const handleDrop = (e) => __awaiter(void 0, void 0, void 0, function* () {
        handleAddFileToPipeline({ x: e.offsetX, y: e.offsetY });
    });
    react_1.useEffect(() => {
        const handleSignal = () => {
            handleAddFileToPipeline();
        };
        addFileToPipelineSignal.connect(handleSignal);
        return () => {
            addFileToPipelineSignal.disconnect(handleSignal);
        };
    }, [addFileToPipelineSignal, handleAddFileToPipeline]);
    const handleClose = (event, reason) => {
        if (reason === 'clickaway') {
            return;
        }
        setAlert('');
    };
    if (loading || palette === undefined) {
        return jsx_runtime_1.jsx("div", { className: "elyra-loader" }, void 0);
    }
    const handleOpenCatalog = () => {
        shell.activateById(`elyra-metadata:${PipelineService_1.COMPONENT_CATALOGS_SCHEMASPACE}`);
    };
    return (jsx_runtime_1.jsxs(pipeline_editor_1.ThemeProvider, Object.assign({ theme: theme_1.theme }, { children: [jsx_runtime_1.jsx(core_1.Snackbar, Object.assign({ open: alert !== '', autoHideDuration: 6000, onClose: handleClose }, { children: jsx_runtime_1.jsx(Alert_1.default, Object.assign({ severity: 'error', onClose: handleClose }, { children: alert }), void 0) }), void 0),
            jsx_runtime_1.jsx(ui_components_1.Dropzone, Object.assign({ onDrop: handleDrop }, { children: jsx_runtime_1.jsx(pipeline_editor_1.PipelineEditor, Object.assign({ ref: ref, palette: palette, pipelineProperties: pipelineProperties_1.default, toolbar: toolbar, pipeline: pipeline, onAction: onAction, onChange: onChange, onDoubleClickNode: handleOpenFile, onError: onError, onFileRequested: onFileRequested, onPropertiesUpdateRequested: onPropertiesUpdateRequested, leftPalette: true }, { children: type === undefined ? (jsx_runtime_1.jsx(EmptyPipelineContent_1.EmptyGenericPipeline, {}, void 0)) : (jsx_runtime_1.jsx(EmptyPipelineContent_1.EmptyPlatformSpecificPipeline, { onOpenCatalog: handleOpenCatalog }, void 0)) }), void 0) }), void 0)] }), void 0));
};
class PipelineEditorFactory extends docregistry_1.ABCWidgetFactory {
    constructor(options) {
        super(options);
        this.browserFactory = options.browserFactory;
        this.shell = options.shell;
        this.commands = options.commands;
        this.addFileToPipelineSignal = new signaling_1.Signal(this);
    }
    createNewWidget(context) {
        // Creates a blank widget with a DocumentWidget wrapper
        const props = {
            shell: this.shell,
            commands: this.commands,
            browserFactory: this.browserFactory,
            context: context,
            addFileToPipelineSignal: this.addFileToPipelineSignal
        };
        const content = new PipelineEditorWidget(props);
        const widget = new docregistry_1.DocumentWidget({ content, context });
        widget.addClass(PIPELINE_CLASS);
        widget.title.icon = ui_components_1.pipelineIcon;
        return widget;
    }
}
exports.PipelineEditorFactory = PipelineEditorFactory;
//# sourceMappingURL=PipelineEditorWidget.js.map