export declare const GENERIC_CATEGORY_ID = "Elyra";
interface IReturn<T> {
    data?: T | undefined;
    error?: any;
}
declare type IRuntimeImagesResponse = IRuntimeImage[];
interface IRuntimeImage {
    name: string;
    display_name: string;
    metadata: {
        image_name: string;
    };
}
export declare const useRuntimeImages: () => IReturn<IRuntimeImagesResponse>;
export declare const useRuntimesSchema: () => IReturn<any>;
export interface IRuntimeComponent {
    label: string;
    image: string;
    id: string;
    description: string;
    runtime?: string;
    node_types: {
        op: string;
        id: string;
        label: string;
        image: string;
        runtime_type?: string;
        type: 'execution_node';
        inputs: {
            app_data: any;
        }[];
        outputs: {
            app_data: any;
        }[];
        app_data: any;
    }[];
    extensions?: string[];
}
/**
 * Sort palette in place. Takes a list of categories each containing a list of
 * components.
 * - Categories: alphabetically by "label" (exception: "generic" always first)
 * - Components: alphabetically by "op" (where is component label stored?)
 */
export declare const sortPalette: (palette: {
    categories: IRuntimeComponent[];
}) => void;
export declare const componentFetcher: (type: string) => Promise<any>;
export declare const usePalette: (type?: string) => IReturn<any>;
export {};
