"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyTemplate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const aws_verifiedpermissions_1 = require("aws-cdk-lib/aws-verifiedpermissions");
const core_1 = require("aws-cdk-lib/core");
const cedar_helpers_1 = require("./cedar-helpers");
class PolicyTemplateBase extends core_1.Resource {
}
class PolicyTemplate extends PolicyTemplateBase {
    /**
     * Create a PolicyTemplate construct that represents an external policy template via policy template id.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param policyTemplateId The PolicyTemplate's id.
     */
    static fromPolicyTemplateId(scope, id, policyTemplateId) {
        return PolicyTemplate.fromPolicyTemplateAttributes(scope, id, {
            policyTemplateId,
        });
    }
    /**
     * Creates a PolicyTemplate construct that represents an external Policy Template.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs A `PolicyTemplateAttributes` object.
     */
    static fromPolicyTemplateAttributes(scope, id, attrs) {
        class Import extends PolicyTemplateBase {
            constructor(policyTemplateId) {
                super(scope, id);
                this.policyTemplateId = policyTemplateId;
            }
        }
        let policyTemplateId;
        policyTemplateId = attrs.policyTemplateId;
        return new Import(policyTemplateId);
    }
    static fromFile(scope, id, props) {
        const templateFileContents = fs.readFileSync(props.path).toString();
        (0, cedar_helpers_1.checkParseTemplate)(templateFileContents);
        return new PolicyTemplate(scope, id, {
            statement: templateFileContents,
            description: props.description,
            policyStore: props.policyStore,
        });
    }
    constructor(scope, id, props) {
        super(scope, id);
        (0, cedar_helpers_1.checkParseTemplate)(props.statement);
        this.policyTemplate = new aws_verifiedpermissions_1.CfnPolicyTemplate(this, id, {
            statement: props.statement,
            description: props.description,
            policyStoreId: props.policyStore.policyStoreId,
        });
        this.policyTemplateId = this.policyTemplate.attrPolicyTemplateId;
        this.statement = this.policyTemplate.statement;
        this.description = props.description;
        this.policyStore = props.policyStore;
    }
}
exports.PolicyTemplate = PolicyTemplate;
_a = JSII_RTTI_SYMBOL_1;
PolicyTemplate[_a] = { fqn: "@cdklabs/cdk-verified-permissions.PolicyTemplate", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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