from enum import Enum
from typing import List, Final

ASCII_CHARACTER_SET: Final[List[str]] = ["+", "x", "o", "*", "~", "."]
UNICODE_CHARACTER_SET: Final[List[str]] = [
    "",
    "▘",
    "▝",
    "▀",
    "▖",
    "▌",
    "▞",
    "▛",
    "▗",
    "▚",
    "▐",
    "▜",
    "▄",
    "▙",
    "▟",
    "█",
]
BRAILLE_CHARACTER_SET: Final[List[str]] = [
    "",
    "⠁",
    "⠈",
    "⠉",
    "⠂",
    "⠃",
    "⠊",
    "⠋",
    "⠐",
    "⠑",
    "⠘",
    "⠙",
    "⠒",
    "⠓",
    "⠚",
    "⠛",
    "⠄",
    "⠅",
    "⠌",
    "⠍",
    "⠆",
    "⠇",
    "⠎",
    "⠏",
    "⠔",
    "⠕",
    "⠜",
    "⠝",
    "⠖",
    "⠗",
    "⠞",
    "⠟",
    "⠠",
    "⠡",
    "⠨",
    "⠩",
    "⠢",
    "⠣",
    "⠪",
    "⠫",
    "⠰",
    "⠱",
    "⠸",
    "⠹",
    "⠲",
    "⠳",
    "⠺",
    "⠻",
    "⠤",
    "⠥",
    "⠬",
    "⠭",
    "⠦",
    "⠧",
    "⠮",
    "⠯",
    "⠴",
    "⠵",
    "⠼",
    "⠽",
    "⠶",
    "⠷",
    "⠾",
    "⠿",
    "⡀",
    "⡁",
    "⡈",
    "⡉",
    "⡂",
    "⡃",
    "⡊",
    "⡋",
    "⡐",
    "⡑",
    "⡘",
    "⡙",
    "⡒",
    "⡓",
    "⡚",
    "⡛",
    "⡄",
    "⡅",
    "⡌",
    "⡍",
    "⡆",
    "⡇",
    "⡎",
    "⡏",
    "⡔",
    "⡕",
    "⡜",
    "⡝",
    "⡖",
    "⡗",
    "⡞",
    "⡟",
    "⡠",
    "⡡",
    "⡨",
    "⡩",
    "⡢",
    "⡣",
    "⡪",
    "⡫",
    "⡰",
    "⡱",
    "⡸",
    "⡹",
    "⡲",
    "⡳",
    "⡺",
    "⡻",
    "⡤",
    "⡥",
    "⡬",
    "⡭",
    "⡦",
    "⡧",
    "⡮",
    "⡯",
    "⡴",
    "⡵",
    "⡼",
    "⡽",
    "⡶",
    "⡷",
    "⡾",
    "⡿",
    "⢀",
    "⢁",
    "⢈",
    "⢉",
    "⢂",
    "⢃",
    "⢊",
    "⢋",
    "⢐",
    "⢑",
    "⢘",
    "⢙",
    "⢒",
    "⢓",
    "⢚",
    "⢛",
    "⢄",
    "⢅",
    "⢌",
    "⢍",
    "⢆",
    "⢇",
    "⢎",
    "⢏",
    "⢔",
    "⢕",
    "⢜",
    "⢝",
    "⢖",
    "⢗",
    "⢞",
    "⢟",
    "⢠",
    "⢡",
    "⢨",
    "⢩",
    "⢢",
    "⢣",
    "⢪",
    "⢫",
    "⢰",
    "⢱",
    "⢸",
    "⢹",
    "⢲",
    "⢳",
    "⢺",
    "⢻",
    "⢤",
    "⢥",
    "⢬",
    "⢭",
    "⢦",
    "⢧",
    "⢮",
    "⢯",
    "⢴",
    "⢵",
    "⢼",
    "⢽",
    "⢶",
    "⢷",
    "⢾",
    "⢿",
    "⣀",
    "⣁",
    "⣈",
    "⣉",
    "⣂",
    "⣃",
    "⣊",
    "⣋",
    "⣐",
    "⣑",
    "⣘",
    "⣙",
    "⣒",
    "⣓",
    "⣚",
    "⣛",
    "⣄",
    "⣅",
    "⣌",
    "⣍",
    "⣆",
    "⣇",
    "⣎",
    "⣏",
    "⣔",
    "⣕",
    "⣜",
    "⣝",
    "⣖",
    "⣗",
    "⣞",
    "⣟",
    "⣠",
    "⣡",
    "⣨",
    "⣩",
    "⣢",
    "⣣",
    "⣪",
    "⣫",
    "⣰",
    "⣱",
    "⣸",
    "⣹",
    "⣲",
    "⣳",
    "⣺",
    "⣻",
    "⣤",
    "⣥",
    "⣬",
    "⣭",
    "⣦",
    "⣧",
    "⣮",
    "⣯",
    "⣴",
    "⣵",
    "⣼",
    "⣽",
    "⣶",
    "⣷",
    "⣾",
    "⣿",
]


class CharacterSet(Enum):
    ASCII = 1
    BLOCK = 2
    BRAILLE = 3
