# -*- coding: utf-8 -*-
import numpy as np
from scipy.special import spence


def li2(x):
    return spence(1 - x)


lnomx = -4.0


def omx(y):
    return -7.0 + 4.0 * np.log(1.0 - y)


def f2sv(y):
    return (
        -0.3333333333333333
        * (
            (-1 + y)
            * (15 + 4 * np.pi**2 - 12 * li2(y / (-1 + y)) - 9 * np.log(1 - y))
        )
        / y
    )


def flsv(y):
    return (15 + 4 * np.pi**2 - 12 * li2(y / (-1 + y)) - 3 * np.log(1 - y)) / (
        3.0 * y
    )


def f3sv(y):
    return (
        -5
        - (4 * np.pi**2) / 3.0
        + 4 * li2(y / (-1 + y))
        + (3 - 2 / y) * np.log(1 - y)
    )


def f2r(y, z):
    P1 = 1.0 / (1.0 - z)
    P2 = np.log(1.0 - z) * P1
    return (
        P1
        * (
            y**4 * (3 + y)
            - 2 * y**3 * (5 + y * (22 + y)) * z
            + 2 * y**3 * (54 + (41 - 3 * y) * y) * z**2
            - 6 * y**2 * (5 + y * (30 + y)) * z**3
            + 6 * y * (5 + y * (30 + y)) * z**5
            + 2 * y * (-54 + y * (-41 + 3 * y)) * z**6
            + 2 * (5 + y * (22 + y)) * z**7
            - (3 + y) * z**8
        )
        - 2
        * P2
        * (
            -(z**6 * (5 + (-4 + z) * z))
            + y**5 * (1 + z**2)
            + y**4 * (-1 + z * (8 - 21 * z + 4 * z**3))
            + y**2 * z**2 * (-5 - (-2 + z) * z * (34 + 7 * z * (-10 + 3 * z)))
            + y**3 * z * (4 + z * (-47 + z * (112 - 50 * z + z**3)))
            + y * z**4 * (-20 + z * (68 + z * (-47 + z * (8 + z))))
        )
        + 2
        * P1
        * (
            -(z**6 * (5 + (-4 + z) * z))
            + y**5 * (1 + z**2)
            + y**4 * (-1 + z * (8 - 21 * z + 4 * z**3))
            + y**2 * z**2 * (-5 - (-2 + z) * z * (34 + 7 * z * (-10 + 3 * z)))
            + y**3 * z * (4 + z * (-47 + z * (112 - 50 * z + z**3)))
            + y * z**4 * (-20 + z * (68 + z * (-47 + z * (8 + z))))
        )
        * np.log(1 - y / z)
    ) / (y * (y - z) * (y - z**2) ** 3)


def flr(y, z):
    P1 = 1.0 / (1.0 - z)
    P2 = np.log(1.0 - z) * P1
    return (
        -2
        * P2
        * (
            y**3
            - 2 * y**2 * (2 + 3 * y) * z
            + y * (5 + y * (25 + y)) * z**2
            + 2 * y * (-15 + (-8 + y) * y) * z**3
            + (5 + y * (25 + y)) * z**4
            - 2 * (2 + 3 * y) * z**5
            + z**6
        )
        * (-(z**2) + y * (-1 + 2 * z))
        + P1
        * (
            -4 * y**5 * (-1 + z) * z
            + (10 - 3 * z) * z**7
            + y**4 * (3 - 4 * (-2 + z) * z * (-4 + 5 * z))
            + 2 * y * z**5 * (5 + z * (-35 + 16 * z))
            + 2 * y**3 * z * (-5 + z * (35 - 56 * z + 10 * z**3 + 2 * z**4))
            - 2 * y**2 * z**3 * (5 + 2 * z**2 * (-28 + z * (14 + z)))
        )
        + 2
        * P1
        * (
            y**3
            - 2 * y**2 * (2 + 3 * y) * z
            + y * (5 + y * (25 + y)) * z**2
            + 2 * y * (-15 + (-8 + y) * y) * z**3
            + (5 + y * (25 + y)) * z**4
            - 2 * (2 + 3 * y) * z**5
            + z**6
        )
        * (-(z**2) + y * (-1 + 2 * z))
        * np.log(1 - y / z)
    ) / (y * (y - z) * (y - z**2) ** 3)


def f3r(y, z):
    P1 = 1.0 / (1.0 - z)
    P2 = np.log(1.0 - z) * P1
    return (
        -2
        * P2
        * (
            y**3
            + y * (-3 + (-7 + y) * y) * z**2
            + 16 * y * z**3
            + (-3 + (-7 + y) * y) * z**4
            + z**6
        )
        - P1
        * (y - z**2)
        * (
            z**3 * (6 + z)
            + 2 * y * z * (3 + (-11 + z) * z)
            + y**2 * (1 + 2 * z + 4 * z**2)
        )
        + 2
        * P1
        * (
            y**3
            + y * (-3 + (-7 + y) * y) * z**2
            + 16 * y * z**3
            + (-3 + (-7 + y) * y) * z**4
            + z**6
        )
        * np.log(1 - y / z)
    ) / ((y - z) * (y - z**2) ** 2)
