# #####################################################################
#  TARDIS - Transformer And Rapid Dimensionless Instance Segmentation #
#                                                                     #
#  New York Structural Biology Center                                 #
#  Simons Machine Learning Center                                     #
#                                                                     #
#  Robert Kiewisz, Tristan Bepler                                     #
#  MIT License 2021 - 2025                                            #
# #####################################################################

import numpy as np

from tardis_em.cnn.data_processing.draw_mask import (
    draw_circle,
    draw_sphere,
)


def test_draw_circle():
    # Test case 1: 2D circle
    r = 5
    c = (20, 20)
    shape = (40, 40)
    expected_output = (
        np.array(
            [
                16,
                16,
                16,
                16,
                16,
                17,
                17,
                17,
                17,
                17,
                17,
                17,
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                22,
                22,
                22,
                22,
                22,
                22,
                22,
                22,
                22,
                23,
                23,
                23,
                23,
                23,
                23,
                23,
                24,
                24,
                24,
                24,
                24,
            ]
        ),
        np.array(
            [
                18,
                19,
                20,
                21,
                22,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                16,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                24,
                17,
                18,
                19,
                20,
                21,
                22,
                23,
                18,
                19,
                20,
                21,
                22,
            ]
        ),
    )
    output = draw_circle(r, c, shape)
    assert np.array_equal(output, expected_output)


def test_draw_sphere():
    # Test case 1: 3D circle
    r = 3
    c = (20, 20, 20)
    shape = (40, 40, 40)
    expected_output = (
        np.array(
            [
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                18,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                19,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                20,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
                21,
            ]
        ),
        np.array(
            [
                18,
                18,
                18,
                19,
                19,
                19,
                19,
                19,
                20,
                20,
                20,
                20,
                20,
                21,
                21,
                21,
                21,
                21,
                22,
                22,
                22,
                18,
                18,
                18,
                18,
                18,
                19,
                19,
                19,
                19,
                19,
                20,
                20,
                20,
                20,
                20,
                21,
                21,
                21,
                21,
                21,
                22,
                22,
                22,
                22,
                22,
                17,
                18,
                18,
                18,
                18,
                18,
                19,
                19,
                19,
                19,
                19,
                20,
                20,
                20,
                20,
                20,
                20,
                21,
                21,
                21,
                21,
                21,
                22,
                22,
                22,
                22,
                22,
                18,
                18,
                18,
                18,
                18,
                19,
                19,
                19,
                19,
                19,
                20,
                20,
                20,
                20,
                20,
                21,
                21,
                21,
                21,
                21,
                22,
                22,
                22,
                22,
                22,
            ]
        ),
        np.array(
            [
                19,
                20,
                21,
                18,
                19,
                20,
                21,
                22,
                18,
                19,
                20,
                21,
                22,
                18,
                19,
                20,
                21,
                22,
                19,
                20,
                21,
                18,
                19,
                20,
                21,
                22,
                18,
                19,
                20,
                21,
                22,
                18,
                19,
                20,
                21,
                22,
                18,
                19,
                20,
                21,
                22,
                18,
                19,
                20,
                21,
                22,
                20,
                18,
                19,
                20,
                21,
                22,
                18,
                19,
                20,
                21,
                22,
                17,
                18,
                19,
                20,
                21,
                22,
                18,
                19,
                20,
                21,
                22,
                18,
                19,
                20,
                21,
                22,
                18,
                19,
                20,
                21,
                22,
                18,
                19,
                20,
                21,
                22,
                18,
                19,
                20,
                21,
                22,
                18,
                19,
                20,
                21,
                22,
                18,
                19,
                20,
                21,
                22,
            ]
        ),
    )
    output = draw_sphere(r, c, shape)
    assert np.array_equal(output, expected_output)
