# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ContainerRepositoryReadme',
    'GetContainerImageLayerResult',
    'GetContainerImageVersionResult',
    'GetContainerImagesContainerImageCollectionResult',
    'GetContainerImagesContainerImageCollectionItemResult',
    'GetContainerImagesContainerImageCollectionItemLayerResult',
    'GetContainerImagesContainerImageCollectionItemVersionResult',
    'GetContainerImagesFilterResult',
    'GetContainerRepositoriesContainerRepositoryCollectionResult',
    'GetContainerRepositoriesContainerRepositoryCollectionItemResult',
    'GetContainerRepositoriesContainerRepositoryCollectionItemReadmeResult',
    'GetContainerRepositoriesFilterResult',
    'GetContainerRepositoryReadmeResult',
    'GetContainerSignaturesContainerImageSignatureCollectionResult',
    'GetContainerSignaturesContainerImageSignatureCollectionItemResult',
    'GetContainerSignaturesFilterResult',
    'GetGenericArtifactsFilterResult',
    'GetGenericArtifactsGenericArtifactCollectionResult',
    'GetGenericArtifactsGenericArtifactCollectionItemResult',
    'GetRepositoriesFilterResult',
    'GetRepositoriesRepositoryCollectionResult',
    'GetRepositoriesRepositoryCollectionItemResult',
]

@pulumi.output_type
class ContainerRepositoryReadme(dict):
    def __init__(__self__, *,
                 content: builtins.str,
                 format: builtins.str):
        """
        :param builtins.str content: (Updatable) Readme content. Avoid entering confidential information.
        :param builtins.str format: (Updatable) Readme format. Supported formats are text/plain and text/markdown.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        (Updatable) Readme content. Avoid entering confidential information.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def format(self) -> builtins.str:
        """
        (Updatable) Readme format. Supported formats are text/plain and text/markdown.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class GetContainerImageLayerResult(dict):
    def __init__(__self__, *,
                 digest: builtins.str,
                 size_in_bytes: builtins.str,
                 time_created: builtins.str):
        """
        :param builtins.str digest: The sha256 digest of the image layer.
        :param builtins.str size_in_bytes: The size of the layer in bytes.
        :param builtins.str time_created: The creation time of the version.
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def digest(self) -> builtins.str:
        """
        The sha256 digest of the image layer.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> builtins.str:
        """
        The size of the layer in bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The creation time of the version.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetContainerImageVersionResult(dict):
    def __init__(__self__, *,
                 created_by: builtins.str,
                 time_created: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str created_by: The OCID of the user or principal that pushed the version.
        :param builtins.str time_created: The creation time of the version.
        :param builtins.str version: The version name.
        """
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> builtins.str:
        """
        The OCID of the user or principal that pushed the version.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The creation time of the version.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        The version name.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetContainerImagesContainerImageCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetContainerImagesContainerImageCollectionItemResult'],
                 remaining_items_count: builtins.int):
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "remaining_items_count", remaining_items_count)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetContainerImagesContainerImageCollectionItemResult']:
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="remainingItemsCount")
    def remaining_items_count(self) -> builtins.int:
        return pulumi.get(self, "remaining_items_count")


@pulumi.output_type
class GetContainerImagesContainerImageCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 created_by: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 digest: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 layers: Sequence['outputs.GetContainerImagesContainerImageCollectionItemLayerResult'],
                 layers_size_in_bytes: builtins.str,
                 manifest_size_in_bytes: builtins.int,
                 pull_count: builtins.str,
                 repository_id: builtins.str,
                 repository_name: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_last_pulled: builtins.str,
                 version: builtins.str,
                 versions: Sequence['outputs.GetContainerImagesContainerImageCollectionItemVersionResult']):
        """
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param builtins.str created_by: The OCID of the user or principal that pushed the version.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str digest: The sha256 digest of the image layer.
        :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container image.  Example: `ocid1.containerimage.oc1..exampleuniqueID`
        :param Sequence['GetContainerImagesContainerImageCollectionItemLayerArgs'] layers: Layers of which the image is composed, ordered by the layer digest.
        :param builtins.str layers_size_in_bytes: The total size of the container image layers in bytes.
        :param builtins.int manifest_size_in_bytes: The size of the container image manifest in bytes.
        :param builtins.str pull_count: Total number of pulls.
        :param builtins.str repository_id: A filter to return container images only for the specified container repository OCID.
        :param builtins.str repository_name: A filter to return container images or container image signatures that match the repository name.  Example: `foo` or `foo*`
        :param builtins.str state: A filter to return only resources that match the given lifecycle state name exactly.
        :param Mapping[str, builtins.str] system_tags: The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The creation time of the version.
        :param builtins.str time_last_pulled: An RFC 3339 timestamp indicating when the image was last pulled.
        :param builtins.str version: A filter to return container images that match the version.  Example: `foo` or `foo*`
        :param Sequence['GetContainerImagesContainerImageCollectionItemVersionArgs'] versions: The versions associated with this image.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "layers", layers)
        pulumi.set(__self__, "layers_size_in_bytes", layers_size_in_bytes)
        pulumi.set(__self__, "manifest_size_in_bytes", manifest_size_in_bytes)
        pulumi.set(__self__, "pull_count", pull_count)
        pulumi.set(__self__, "repository_id", repository_id)
        pulumi.set(__self__, "repository_name", repository_name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_last_pulled", time_last_pulled)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> builtins.str:
        """
        The OCID of the user or principal that pushed the version.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def digest(self) -> builtins.str:
        """
        The sha256 digest of the image layer.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container image.  Example: `ocid1.containerimage.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def layers(self) -> Sequence['outputs.GetContainerImagesContainerImageCollectionItemLayerResult']:
        """
        Layers of which the image is composed, ordered by the layer digest.
        """
        return pulumi.get(self, "layers")

    @property
    @pulumi.getter(name="layersSizeInBytes")
    def layers_size_in_bytes(self) -> builtins.str:
        """
        The total size of the container image layers in bytes.
        """
        return pulumi.get(self, "layers_size_in_bytes")

    @property
    @pulumi.getter(name="manifestSizeInBytes")
    def manifest_size_in_bytes(self) -> builtins.int:
        """
        The size of the container image manifest in bytes.
        """
        return pulumi.get(self, "manifest_size_in_bytes")

    @property
    @pulumi.getter(name="pullCount")
    def pull_count(self) -> builtins.str:
        """
        Total number of pulls.
        """
        return pulumi.get(self, "pull_count")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> builtins.str:
        """
        A filter to return container images only for the specified container repository OCID.
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> builtins.str:
        """
        A filter to return container images or container image signatures that match the repository name.  Example: `foo` or `foo*`
        """
        return pulumi.get(self, "repository_name")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources that match the given lifecycle state name exactly.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The creation time of the version.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastPulled")
    def time_last_pulled(self) -> builtins.str:
        """
        An RFC 3339 timestamp indicating when the image was last pulled.
        """
        return pulumi.get(self, "time_last_pulled")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        A filter to return container images that match the version.  Example: `foo` or `foo*`
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetContainerImagesContainerImageCollectionItemVersionResult']:
        """
        The versions associated with this image.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class GetContainerImagesContainerImageCollectionItemLayerResult(dict):
    def __init__(__self__, *,
                 digest: builtins.str,
                 size_in_bytes: builtins.str,
                 time_created: builtins.str):
        """
        :param builtins.str digest: The sha256 digest of the image layer.
        :param builtins.str size_in_bytes: The size of the layer in bytes.
        :param builtins.str time_created: The creation time of the version.
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def digest(self) -> builtins.str:
        """
        The sha256 digest of the image layer.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> builtins.str:
        """
        The size of the layer in bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The creation time of the version.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetContainerImagesContainerImageCollectionItemVersionResult(dict):
    def __init__(__self__, *,
                 created_by: builtins.str,
                 time_created: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str created_by: The OCID of the user or principal that pushed the version.
        :param builtins.str time_created: The creation time of the version.
        :param builtins.str version: A filter to return container images that match the version.  Example: `foo` or `foo*`
        """
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> builtins.str:
        """
        The OCID of the user or principal that pushed the version.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The creation time of the version.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        A filter to return container images that match the version.  Example: `foo` or `foo*`
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetContainerImagesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetContainerRepositoriesContainerRepositoryCollectionResult(dict):
    def __init__(__self__, *,
                 image_count: builtins.int,
                 items: Sequence['outputs.GetContainerRepositoriesContainerRepositoryCollectionItemResult'],
                 layer_count: builtins.int,
                 layers_size_in_bytes: builtins.str,
                 remaining_items_count: builtins.int,
                 repository_count: builtins.int):
        """
        :param builtins.int image_count: Total number of images.
        :param builtins.int layer_count: Total number of layers.
        :param builtins.str layers_size_in_bytes: Total storage in bytes consumed by layers.
        """
        pulumi.set(__self__, "image_count", image_count)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "layer_count", layer_count)
        pulumi.set(__self__, "layers_size_in_bytes", layers_size_in_bytes)
        pulumi.set(__self__, "remaining_items_count", remaining_items_count)
        pulumi.set(__self__, "repository_count", repository_count)

    @property
    @pulumi.getter(name="imageCount")
    def image_count(self) -> builtins.int:
        """
        Total number of images.
        """
        return pulumi.get(self, "image_count")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetContainerRepositoriesContainerRepositoryCollectionItemResult']:
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="layerCount")
    def layer_count(self) -> builtins.int:
        """
        Total number of layers.
        """
        return pulumi.get(self, "layer_count")

    @property
    @pulumi.getter(name="layersSizeInBytes")
    def layers_size_in_bytes(self) -> builtins.str:
        """
        Total storage in bytes consumed by layers.
        """
        return pulumi.get(self, "layers_size_in_bytes")

    @property
    @pulumi.getter(name="remainingItemsCount")
    def remaining_items_count(self) -> builtins.int:
        return pulumi.get(self, "remaining_items_count")

    @property
    @pulumi.getter(name="repositoryCount")
    def repository_count(self) -> builtins.int:
        return pulumi.get(self, "repository_count")


@pulumi.output_type
class GetContainerRepositoriesContainerRepositoryCollectionItemResult(dict):
    def __init__(__self__, *,
                 billable_size_in_gbs: builtins.str,
                 compartment_id: builtins.str,
                 created_by: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 image_count: builtins.int,
                 is_immutable: builtins.bool,
                 is_public: builtins.bool,
                 layer_count: builtins.int,
                 layers_size_in_bytes: builtins.str,
                 namespace: builtins.str,
                 readmes: Sequence['outputs.GetContainerRepositoriesContainerRepositoryCollectionItemReadmeResult'],
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_last_pushed: builtins.str):
        """
        :param builtins.str billable_size_in_gbs: Total storage size in GBs that will be charged.
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param builtins.str created_by: The id of the user or principal that created the resource.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container repository.  Example: `ocid1.containerrepo.oc1..exampleuniqueID`
        :param builtins.int image_count: Total number of images.
        :param builtins.bool is_immutable: Whether the repository is immutable. Images cannot be overwritten in an immutable repository.
        :param builtins.bool is_public: A filter to return resources that match the isPublic value.
        :param builtins.int layer_count: Total number of layers.
        :param builtins.str layers_size_in_bytes: Total storage in bytes consumed by layers.
        :param builtins.str namespace: The tenancy namespace used in the container repository path.
        :param Sequence['GetContainerRepositoriesContainerRepositoryCollectionItemReadmeArgs'] readmes: Container repository readme.
        :param builtins.str state: A filter to return only resources that match the given lifecycle state name exactly.
        :param Mapping[str, builtins.str] system_tags: The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: An RFC 3339 timestamp indicating when the repository was created.
        :param builtins.str time_last_pushed: An RFC 3339 timestamp indicating when an image was last pushed to the repository.
        """
        pulumi.set(__self__, "billable_size_in_gbs", billable_size_in_gbs)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_count", image_count)
        pulumi.set(__self__, "is_immutable", is_immutable)
        pulumi.set(__self__, "is_public", is_public)
        pulumi.set(__self__, "layer_count", layer_count)
        pulumi.set(__self__, "layers_size_in_bytes", layers_size_in_bytes)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "readmes", readmes)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_last_pushed", time_last_pushed)

    @property
    @pulumi.getter(name="billableSizeInGbs")
    def billable_size_in_gbs(self) -> builtins.str:
        """
        Total storage size in GBs that will be charged.
        """
        return pulumi.get(self, "billable_size_in_gbs")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> builtins.str:
        """
        The id of the user or principal that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container repository.  Example: `ocid1.containerrepo.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageCount")
    def image_count(self) -> builtins.int:
        """
        Total number of images.
        """
        return pulumi.get(self, "image_count")

    @property
    @pulumi.getter(name="isImmutable")
    def is_immutable(self) -> builtins.bool:
        """
        Whether the repository is immutable. Images cannot be overwritten in an immutable repository.
        """
        return pulumi.get(self, "is_immutable")

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> builtins.bool:
        """
        A filter to return resources that match the isPublic value.
        """
        return pulumi.get(self, "is_public")

    @property
    @pulumi.getter(name="layerCount")
    def layer_count(self) -> builtins.int:
        """
        Total number of layers.
        """
        return pulumi.get(self, "layer_count")

    @property
    @pulumi.getter(name="layersSizeInBytes")
    def layers_size_in_bytes(self) -> builtins.str:
        """
        Total storage in bytes consumed by layers.
        """
        return pulumi.get(self, "layers_size_in_bytes")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The tenancy namespace used in the container repository path.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def readmes(self) -> Sequence['outputs.GetContainerRepositoriesContainerRepositoryCollectionItemReadmeResult']:
        """
        Container repository readme.
        """
        return pulumi.get(self, "readmes")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources that match the given lifecycle state name exactly.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        An RFC 3339 timestamp indicating when the repository was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastPushed")
    def time_last_pushed(self) -> builtins.str:
        """
        An RFC 3339 timestamp indicating when an image was last pushed to the repository.
        """
        return pulumi.get(self, "time_last_pushed")


@pulumi.output_type
class GetContainerRepositoriesContainerRepositoryCollectionItemReadmeResult(dict):
    def __init__(__self__, *,
                 content: builtins.str,
                 format: builtins.str):
        """
        :param builtins.str content: Readme content. Avoid entering confidential information.
        :param builtins.str format: Readme format. Supported formats are text/plain and text/markdown.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        Readme content. Avoid entering confidential information.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def format(self) -> builtins.str:
        """
        Readme format. Supported formats are text/plain and text/markdown.
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class GetContainerRepositoriesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetContainerRepositoryReadmeResult(dict):
    def __init__(__self__, *,
                 content: builtins.str,
                 format: builtins.str):
        """
        :param builtins.str content: Readme content. Avoid entering confidential information.
        :param builtins.str format: Readme format. Supported formats are text/plain and text/markdown.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        Readme content. Avoid entering confidential information.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def format(self) -> builtins.str:
        """
        Readme format. Supported formats are text/plain and text/markdown.
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class GetContainerSignaturesContainerImageSignatureCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetContainerSignaturesContainerImageSignatureCollectionItemResult'],
                 remaining_items_count: builtins.int):
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "remaining_items_count", remaining_items_count)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetContainerSignaturesContainerImageSignatureCollectionItemResult']:
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="remainingItemsCount")
    def remaining_items_count(self) -> builtins.int:
        return pulumi.get(self, "remaining_items_count")


@pulumi.output_type
class GetContainerSignaturesContainerImageSignatureCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 created_by: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 image_id: builtins.str,
                 kms_key_id: builtins.str,
                 kms_key_version_id: builtins.str,
                 message: builtins.str,
                 signature: builtins.str,
                 signing_algorithm: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str):
        """
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param builtins.str created_by: The id of the user or principal that created the resource.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container image signature.  Example: `ocid1.containerimagesignature.oc1..exampleuniqueID`
        :param builtins.str image_id: A filter to return a container image summary only for the specified container image OCID.
        :param builtins.str kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyVersionId used to sign the container image.  Example: `ocid1.keyversion.oc1..exampleuniqueID`
        :param builtins.str kms_key_version_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyVersionId used to sign the container image.  Example: `ocid1.keyversion.oc1..exampleuniqueID`
        :param builtins.str message: The base64 encoded signature payload that was signed.
        :param builtins.str signature: The signature of the message field using the kmsKeyId, the kmsKeyVersionId, and the signingAlgorithm.
        :param builtins.str signing_algorithm: The algorithm to be used for signing. These are the only supported signing algorithms for container images.
        :param builtins.str state: The current state of the container image signature.
        :param Mapping[str, builtins.str] system_tags: The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: An RFC 3339 timestamp indicating when the image was created.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "signature", signature)
        pulumi.set(__self__, "signing_algorithm", signing_algorithm)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> builtins.str:
        """
        The id of the user or principal that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container image signature.  Example: `ocid1.containerimagesignature.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> builtins.str:
        """
        A filter to return a container image summary only for the specified container image OCID.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyVersionId used to sign the container image.  Example: `ocid1.keyversion.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyVersionId used to sign the container image.  Example: `ocid1.keyversion.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "kms_key_version_id")

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        The base64 encoded signature payload that was signed.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def signature(self) -> builtins.str:
        """
        The signature of the message field using the kmsKeyId, the kmsKeyVersionId, and the signingAlgorithm.
        """
        return pulumi.get(self, "signature")

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> builtins.str:
        """
        The algorithm to be used for signing. These are the only supported signing algorithms for container images.
        """
        return pulumi.get(self, "signing_algorithm")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the container image signature.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        An RFC 3339 timestamp indicating when the image was created.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetContainerSignaturesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetGenericArtifactsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetGenericArtifactsGenericArtifactCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetGenericArtifactsGenericArtifactCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetGenericArtifactsGenericArtifactCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetGenericArtifactsGenericArtifactCollectionItemResult(dict):
    def __init__(__self__, *,
                 artifact_id: builtins.str,
                 artifact_path: builtins.str,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 repository_id: builtins.str,
                 sha256: builtins.str,
                 size_in_bytes: builtins.str,
                 state: builtins.str,
                 time_created: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str artifact_path: Filter results by a prefix for the `artifactPath` and and return artifacts that begin with the specified prefix in their path.
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param builtins.str id: A filter to return the resources for the specified OCID.
        :param builtins.str repository_id: A filter to return the artifacts only for the specified repository OCID.
        :param builtins.str sha256: Filter results by a specified SHA256 digest for the artifact.
        :param builtins.str size_in_bytes: The size of the artifact in bytes.
        :param builtins.str state: A filter to return only resources that match the given lifecycle state name exactly.
        :param builtins.str time_created: An RFC 3339 timestamp indicating when the repository was created.
        :param builtins.str version: Filter results by a prefix for `version` and return artifacts that that begin with the specified prefix in their version.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "artifact_path", artifact_path)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "repository_id", repository_id)
        pulumi.set(__self__, "sha256", sha256)
        pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> builtins.str:
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter(name="artifactPath")
    def artifact_path(self) -> builtins.str:
        """
        Filter results by a prefix for the `artifactPath` and and return artifacts that begin with the specified prefix in their path.
        """
        return pulumi.get(self, "artifact_path")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        A filter to return the resources for the specified OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> builtins.str:
        """
        A filter to return the artifacts only for the specified repository OCID.
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter
    def sha256(self) -> builtins.str:
        """
        Filter results by a specified SHA256 digest for the artifact.
        """
        return pulumi.get(self, "sha256")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> builtins.str:
        """
        The size of the artifact in bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources that match the given lifecycle state name exactly.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        An RFC 3339 timestamp indicating when the repository was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Filter results by a prefix for `version` and return artifacts that that begin with the specified prefix in their version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetRepositoriesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRepositoriesRepositoryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRepositoriesRepositoryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRepositoriesRepositoryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRepositoriesRepositoryCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 is_immutable: builtins.bool,
                 repository_type: builtins.str,
                 state: builtins.str,
                 time_created: builtins.str):
        """
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str description: The repository description.
        :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param builtins.str id: A filter to return the resources for the specified OCID.
        :param builtins.bool is_immutable: A filter to return resources that match the isImmutable value.
        :param builtins.str repository_type: The repository's supported artifact type.
        :param builtins.str state: A filter to return only resources that match the given lifecycle state name exactly.
        :param builtins.str time_created: An RFC 3339 timestamp indicating when the repository was created.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_immutable", is_immutable)
        pulumi.set(__self__, "repository_type", repository_type)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The repository description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        A filter to return the resources for the specified OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isImmutable")
    def is_immutable(self) -> builtins.bool:
        """
        A filter to return resources that match the isImmutable value.
        """
        return pulumi.get(self, "is_immutable")

    @property
    @pulumi.getter(name="repositoryType")
    def repository_type(self) -> builtins.str:
        """
        The repository's supported artifact type.
        """
        return pulumi.get(self, "repository_type")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources that match the given lifecycle state name exactly.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        An RFC 3339 timestamp indicating when the repository was created.
        """
        return pulumi.get(self, "time_created")


