# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BdsInstanceIdentityConfigurationArgs', 'BdsInstanceIdentityConfiguration']

@pulumi.input_type
class BdsInstanceIdentityConfigurationArgs:
    def __init__(__self__, *,
                 bds_instance_id: pulumi.Input[builtins.str],
                 cluster_admin_password: pulumi.Input[builtins.str],
                 confidential_application_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 identity_domain_id: pulumi.Input[builtins.str],
                 activate_iam_user_sync_configuration_trigger: Optional[pulumi.Input[builtins.str]] = None,
                 activate_upst_configuration_trigger: Optional[pulumi.Input[builtins.str]] = None,
                 iam_user_sync_configuration_details: Optional[pulumi.Input['BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgs']] = None,
                 refresh_confidential_application_trigger: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_upst_token_exchange_keytab_trigger: Optional[pulumi.Input[builtins.str]] = None,
                 upst_configuration_details: Optional[pulumi.Input['BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgs']] = None):
        """
        The set of arguments for constructing a BdsInstanceIdentityConfiguration resource.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[builtins.str] cluster_admin_password: (Updatable) Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[builtins.str] confidential_application_id: Identity domain confidential application ID for the identity config, required for creating identity configuration
        :param pulumi.Input[builtins.str] display_name: Display name of the identity configuration, required for creating identity configuration.
        :param pulumi.Input[builtins.str] identity_domain_id: Identity domain OCID to use for identity config, required for creating identity configuration
        :param pulumi.Input[builtins.str] activate_iam_user_sync_configuration_trigger: (Updatable) An optional property when set to "true" triggers Activate Iam User Sync Configuration and when set to "false" triggers Deactivate Iam User Sync Configuration.
        :param pulumi.Input[builtins.str] activate_upst_configuration_trigger: (Updatable) An optional property when set to "true" triggers Activate Upst Configuration and when set to "false" triggers Deactivate Upst Configuration.
        :param pulumi.Input['BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgs'] iam_user_sync_configuration_details: (Updatable) Details for activating/updating an IAM user sync configuration
        :param pulumi.Input[builtins.str] refresh_confidential_application_trigger: (Updatable) An optional property when set to "true" triggers Refresh Confidential Application.
        :param pulumi.Input[builtins.str] refresh_upst_token_exchange_keytab_trigger: (Updatable) An optional property when set to "true"  triggers Refresh Upst Token Exchange Keytab.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgs'] upst_configuration_details: (Updatable) Details for activating/updating UPST config on the cluster
        """
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        pulumi.set(__self__, "confidential_application_id", confidential_application_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "identity_domain_id", identity_domain_id)
        if activate_iam_user_sync_configuration_trigger is not None:
            pulumi.set(__self__, "activate_iam_user_sync_configuration_trigger", activate_iam_user_sync_configuration_trigger)
        if activate_upst_configuration_trigger is not None:
            pulumi.set(__self__, "activate_upst_configuration_trigger", activate_upst_configuration_trigger)
        if iam_user_sync_configuration_details is not None:
            pulumi.set(__self__, "iam_user_sync_configuration_details", iam_user_sync_configuration_details)
        if refresh_confidential_application_trigger is not None:
            pulumi.set(__self__, "refresh_confidential_application_trigger", refresh_confidential_application_trigger)
        if refresh_upst_token_exchange_keytab_trigger is not None:
            pulumi.set(__self__, "refresh_upst_token_exchange_keytab_trigger", refresh_upst_token_exchange_keytab_trigger)
        if upst_configuration_details is not None:
            pulumi.set(__self__, "upst_configuration_details", upst_configuration_details)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_admin_password", value)

    @property
    @pulumi.getter(name="confidentialApplicationId")
    def confidential_application_id(self) -> pulumi.Input[builtins.str]:
        """
        Identity domain confidential application ID for the identity config, required for creating identity configuration
        """
        return pulumi.get(self, "confidential_application_id")

    @confidential_application_id.setter
    def confidential_application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "confidential_application_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        Display name of the identity configuration, required for creating identity configuration.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="identityDomainId")
    def identity_domain_id(self) -> pulumi.Input[builtins.str]:
        """
        Identity domain OCID to use for identity config, required for creating identity configuration
        """
        return pulumi.get(self, "identity_domain_id")

    @identity_domain_id.setter
    def identity_domain_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identity_domain_id", value)

    @property
    @pulumi.getter(name="activateIamUserSyncConfigurationTrigger")
    def activate_iam_user_sync_configuration_trigger(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An optional property when set to "true" triggers Activate Iam User Sync Configuration and when set to "false" triggers Deactivate Iam User Sync Configuration.
        """
        return pulumi.get(self, "activate_iam_user_sync_configuration_trigger")

    @activate_iam_user_sync_configuration_trigger.setter
    def activate_iam_user_sync_configuration_trigger(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "activate_iam_user_sync_configuration_trigger", value)

    @property
    @pulumi.getter(name="activateUpstConfigurationTrigger")
    def activate_upst_configuration_trigger(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An optional property when set to "true" triggers Activate Upst Configuration and when set to "false" triggers Deactivate Upst Configuration.
        """
        return pulumi.get(self, "activate_upst_configuration_trigger")

    @activate_upst_configuration_trigger.setter
    def activate_upst_configuration_trigger(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "activate_upst_configuration_trigger", value)

    @property
    @pulumi.getter(name="iamUserSyncConfigurationDetails")
    def iam_user_sync_configuration_details(self) -> Optional[pulumi.Input['BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgs']]:
        """
        (Updatable) Details for activating/updating an IAM user sync configuration
        """
        return pulumi.get(self, "iam_user_sync_configuration_details")

    @iam_user_sync_configuration_details.setter
    def iam_user_sync_configuration_details(self, value: Optional[pulumi.Input['BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgs']]):
        pulumi.set(self, "iam_user_sync_configuration_details", value)

    @property
    @pulumi.getter(name="refreshConfidentialApplicationTrigger")
    def refresh_confidential_application_trigger(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An optional property when set to "true" triggers Refresh Confidential Application.
        """
        return pulumi.get(self, "refresh_confidential_application_trigger")

    @refresh_confidential_application_trigger.setter
    def refresh_confidential_application_trigger(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "refresh_confidential_application_trigger", value)

    @property
    @pulumi.getter(name="refreshUpstTokenExchangeKeytabTrigger")
    def refresh_upst_token_exchange_keytab_trigger(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An optional property when set to "true"  triggers Refresh Upst Token Exchange Keytab.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "refresh_upst_token_exchange_keytab_trigger")

    @refresh_upst_token_exchange_keytab_trigger.setter
    def refresh_upst_token_exchange_keytab_trigger(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "refresh_upst_token_exchange_keytab_trigger", value)

    @property
    @pulumi.getter(name="upstConfigurationDetails")
    def upst_configuration_details(self) -> Optional[pulumi.Input['BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgs']]:
        """
        (Updatable) Details for activating/updating UPST config on the cluster
        """
        return pulumi.get(self, "upst_configuration_details")

    @upst_configuration_details.setter
    def upst_configuration_details(self, value: Optional[pulumi.Input['BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgs']]):
        pulumi.set(self, "upst_configuration_details", value)


@pulumi.input_type
class _BdsInstanceIdentityConfigurationState:
    def __init__(__self__, *,
                 activate_iam_user_sync_configuration_trigger: Optional[pulumi.Input[builtins.str]] = None,
                 activate_upst_configuration_trigger: Optional[pulumi.Input[builtins.str]] = None,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 confidential_application_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 iam_user_sync_configuration_details: Optional[pulumi.Input['BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgs']] = None,
                 iam_user_sync_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceIdentityConfigurationIamUserSyncConfigurationArgs']]]] = None,
                 identity_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_confidential_application_trigger: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_upst_token_exchange_keytab_trigger: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 upst_configuration_details: Optional[pulumi.Input['BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgs']] = None,
                 upst_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceIdentityConfigurationUpstConfigurationArgs']]]] = None):
        """
        Input properties used for looking up and filtering BdsInstanceIdentityConfiguration resources.
        :param pulumi.Input[builtins.str] activate_iam_user_sync_configuration_trigger: (Updatable) An optional property when set to "true" triggers Activate Iam User Sync Configuration and when set to "false" triggers Deactivate Iam User Sync Configuration.
        :param pulumi.Input[builtins.str] activate_upst_configuration_trigger: (Updatable) An optional property when set to "true" triggers Activate Upst Configuration and when set to "false" triggers Deactivate Upst Configuration.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[builtins.str] cluster_admin_password: (Updatable) Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[builtins.str] confidential_application_id: Identity domain confidential application ID for the identity config, required for creating identity configuration
        :param pulumi.Input[builtins.str] display_name: Display name of the identity configuration, required for creating identity configuration.
        :param pulumi.Input['BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgs'] iam_user_sync_configuration_details: (Updatable) Details for activating/updating an IAM user sync configuration
        :param pulumi.Input[Sequence[pulumi.Input['BdsInstanceIdentityConfigurationIamUserSyncConfigurationArgs']]] iam_user_sync_configurations: Information about the IAM user sync configuration.
        :param pulumi.Input[builtins.str] identity_domain_id: Identity domain OCID to use for identity config, required for creating identity configuration
        :param pulumi.Input[builtins.str] refresh_confidential_application_trigger: (Updatable) An optional property when set to "true" triggers Refresh Confidential Application.
        :param pulumi.Input[builtins.str] refresh_upst_token_exchange_keytab_trigger: (Updatable) An optional property when set to "true"  triggers Refresh Upst Token Exchange Keytab.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: Lifecycle state of the UPST config
        :param pulumi.Input[builtins.str] time_created: Time when this UPST config was created, shown as an RFC 3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: Time when this UPST config was updated, shown as an RFC 3339 formatted datetime string.
        :param pulumi.Input['BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgs'] upst_configuration_details: (Updatable) Details for activating/updating UPST config on the cluster
        :param pulumi.Input[Sequence[pulumi.Input['BdsInstanceIdentityConfigurationUpstConfigurationArgs']]] upst_configurations: Information about the UPST configuration.
        """
        if activate_iam_user_sync_configuration_trigger is not None:
            pulumi.set(__self__, "activate_iam_user_sync_configuration_trigger", activate_iam_user_sync_configuration_trigger)
        if activate_upst_configuration_trigger is not None:
            pulumi.set(__self__, "activate_upst_configuration_trigger", activate_upst_configuration_trigger)
        if bds_instance_id is not None:
            pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if cluster_admin_password is not None:
            pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        if confidential_application_id is not None:
            pulumi.set(__self__, "confidential_application_id", confidential_application_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if iam_user_sync_configuration_details is not None:
            pulumi.set(__self__, "iam_user_sync_configuration_details", iam_user_sync_configuration_details)
        if iam_user_sync_configurations is not None:
            pulumi.set(__self__, "iam_user_sync_configurations", iam_user_sync_configurations)
        if identity_domain_id is not None:
            pulumi.set(__self__, "identity_domain_id", identity_domain_id)
        if refresh_confidential_application_trigger is not None:
            pulumi.set(__self__, "refresh_confidential_application_trigger", refresh_confidential_application_trigger)
        if refresh_upst_token_exchange_keytab_trigger is not None:
            pulumi.set(__self__, "refresh_upst_token_exchange_keytab_trigger", refresh_upst_token_exchange_keytab_trigger)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if upst_configuration_details is not None:
            pulumi.set(__self__, "upst_configuration_details", upst_configuration_details)
        if upst_configurations is not None:
            pulumi.set(__self__, "upst_configurations", upst_configurations)

    @property
    @pulumi.getter(name="activateIamUserSyncConfigurationTrigger")
    def activate_iam_user_sync_configuration_trigger(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An optional property when set to "true" triggers Activate Iam User Sync Configuration and when set to "false" triggers Deactivate Iam User Sync Configuration.
        """
        return pulumi.get(self, "activate_iam_user_sync_configuration_trigger")

    @activate_iam_user_sync_configuration_trigger.setter
    def activate_iam_user_sync_configuration_trigger(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "activate_iam_user_sync_configuration_trigger", value)

    @property
    @pulumi.getter(name="activateUpstConfigurationTrigger")
    def activate_upst_configuration_trigger(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An optional property when set to "true" triggers Activate Upst Configuration and when set to "false" triggers Deactivate Upst Configuration.
        """
        return pulumi.get(self, "activate_upst_configuration_trigger")

    @activate_upst_configuration_trigger.setter
    def activate_upst_configuration_trigger(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "activate_upst_configuration_trigger", value)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_admin_password", value)

    @property
    @pulumi.getter(name="confidentialApplicationId")
    def confidential_application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identity domain confidential application ID for the identity config, required for creating identity configuration
        """
        return pulumi.get(self, "confidential_application_id")

    @confidential_application_id.setter
    def confidential_application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "confidential_application_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display name of the identity configuration, required for creating identity configuration.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="iamUserSyncConfigurationDetails")
    def iam_user_sync_configuration_details(self) -> Optional[pulumi.Input['BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgs']]:
        """
        (Updatable) Details for activating/updating an IAM user sync configuration
        """
        return pulumi.get(self, "iam_user_sync_configuration_details")

    @iam_user_sync_configuration_details.setter
    def iam_user_sync_configuration_details(self, value: Optional[pulumi.Input['BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgs']]):
        pulumi.set(self, "iam_user_sync_configuration_details", value)

    @property
    @pulumi.getter(name="iamUserSyncConfigurations")
    def iam_user_sync_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceIdentityConfigurationIamUserSyncConfigurationArgs']]]]:
        """
        Information about the IAM user sync configuration.
        """
        return pulumi.get(self, "iam_user_sync_configurations")

    @iam_user_sync_configurations.setter
    def iam_user_sync_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceIdentityConfigurationIamUserSyncConfigurationArgs']]]]):
        pulumi.set(self, "iam_user_sync_configurations", value)

    @property
    @pulumi.getter(name="identityDomainId")
    def identity_domain_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identity domain OCID to use for identity config, required for creating identity configuration
        """
        return pulumi.get(self, "identity_domain_id")

    @identity_domain_id.setter
    def identity_domain_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identity_domain_id", value)

    @property
    @pulumi.getter(name="refreshConfidentialApplicationTrigger")
    def refresh_confidential_application_trigger(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An optional property when set to "true" triggers Refresh Confidential Application.
        """
        return pulumi.get(self, "refresh_confidential_application_trigger")

    @refresh_confidential_application_trigger.setter
    def refresh_confidential_application_trigger(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "refresh_confidential_application_trigger", value)

    @property
    @pulumi.getter(name="refreshUpstTokenExchangeKeytabTrigger")
    def refresh_upst_token_exchange_keytab_trigger(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An optional property when set to "true"  triggers Refresh Upst Token Exchange Keytab.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "refresh_upst_token_exchange_keytab_trigger")

    @refresh_upst_token_exchange_keytab_trigger.setter
    def refresh_upst_token_exchange_keytab_trigger(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "refresh_upst_token_exchange_keytab_trigger", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lifecycle state of the UPST config
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time when this UPST config was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time when this UPST config was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="upstConfigurationDetails")
    def upst_configuration_details(self) -> Optional[pulumi.Input['BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgs']]:
        """
        (Updatable) Details for activating/updating UPST config on the cluster
        """
        return pulumi.get(self, "upst_configuration_details")

    @upst_configuration_details.setter
    def upst_configuration_details(self, value: Optional[pulumi.Input['BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgs']]):
        pulumi.set(self, "upst_configuration_details", value)

    @property
    @pulumi.getter(name="upstConfigurations")
    def upst_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceIdentityConfigurationUpstConfigurationArgs']]]]:
        """
        Information about the UPST configuration.
        """
        return pulumi.get(self, "upst_configurations")

    @upst_configurations.setter
    def upst_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceIdentityConfigurationUpstConfigurationArgs']]]]):
        pulumi.set(self, "upst_configurations", value)


@pulumi.type_token("oci:BigDataService/bdsInstanceIdentityConfiguration:BdsInstanceIdentityConfiguration")
class BdsInstanceIdentityConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activate_iam_user_sync_configuration_trigger: Optional[pulumi.Input[builtins.str]] = None,
                 activate_upst_configuration_trigger: Optional[pulumi.Input[builtins.str]] = None,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 confidential_application_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 iam_user_sync_configuration_details: Optional[pulumi.Input[Union['BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgs', 'BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgsDict']]] = None,
                 identity_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_confidential_application_trigger: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_upst_token_exchange_keytab_trigger: Optional[pulumi.Input[builtins.str]] = None,
                 upst_configuration_details: Optional[pulumi.Input[Union['BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgs', 'BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Bds Instance Identity Configuration resource in Oracle Cloud Infrastructure Big Data Service service.

        Create an identity configuration for the cluster

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_identity_configuration = oci.big_data_service.BdsInstanceIdentityConfiguration("test_bds_instance_identity_configuration",
            bds_instance_id=test_bds_instance["id"],
            cluster_admin_password=bds_instance_identity_configuration_cluster_admin_password,
            confidential_application_id=test_application["id"],
            display_name=bds_instance_identity_configuration_display_name,
            identity_domain_id=test_domain["id"],
            iam_user_sync_configuration_details={
                "is_posix_attributes_addition_required": bds_instance_identity_configuration_iam_user_sync_configuration_details_is_posix_attributes_addition_required,
            },
            upst_configuration_details={
                "master_encryption_key_id": test_key["id"],
                "vault_id": test_vault["id"],
            })
        ```

        ## Import

        BdsInstanceIdentityConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:BigDataService/bdsInstanceIdentityConfiguration:BdsInstanceIdentityConfiguration test_bds_instance_identity_configuration "bdsInstances/{bdsInstanceId}/identityConfigurations/{identityConfigurationId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] activate_iam_user_sync_configuration_trigger: (Updatable) An optional property when set to "true" triggers Activate Iam User Sync Configuration and when set to "false" triggers Deactivate Iam User Sync Configuration.
        :param pulumi.Input[builtins.str] activate_upst_configuration_trigger: (Updatable) An optional property when set to "true" triggers Activate Upst Configuration and when set to "false" triggers Deactivate Upst Configuration.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[builtins.str] cluster_admin_password: (Updatable) Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[builtins.str] confidential_application_id: Identity domain confidential application ID for the identity config, required for creating identity configuration
        :param pulumi.Input[builtins.str] display_name: Display name of the identity configuration, required for creating identity configuration.
        :param pulumi.Input[Union['BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgs', 'BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgsDict']] iam_user_sync_configuration_details: (Updatable) Details for activating/updating an IAM user sync configuration
        :param pulumi.Input[builtins.str] identity_domain_id: Identity domain OCID to use for identity config, required for creating identity configuration
        :param pulumi.Input[builtins.str] refresh_confidential_application_trigger: (Updatable) An optional property when set to "true" triggers Refresh Confidential Application.
        :param pulumi.Input[builtins.str] refresh_upst_token_exchange_keytab_trigger: (Updatable) An optional property when set to "true"  triggers Refresh Upst Token Exchange Keytab.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Union['BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgs', 'BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgsDict']] upst_configuration_details: (Updatable) Details for activating/updating UPST config on the cluster
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BdsInstanceIdentityConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Bds Instance Identity Configuration resource in Oracle Cloud Infrastructure Big Data Service service.

        Create an identity configuration for the cluster

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_identity_configuration = oci.big_data_service.BdsInstanceIdentityConfiguration("test_bds_instance_identity_configuration",
            bds_instance_id=test_bds_instance["id"],
            cluster_admin_password=bds_instance_identity_configuration_cluster_admin_password,
            confidential_application_id=test_application["id"],
            display_name=bds_instance_identity_configuration_display_name,
            identity_domain_id=test_domain["id"],
            iam_user_sync_configuration_details={
                "is_posix_attributes_addition_required": bds_instance_identity_configuration_iam_user_sync_configuration_details_is_posix_attributes_addition_required,
            },
            upst_configuration_details={
                "master_encryption_key_id": test_key["id"],
                "vault_id": test_vault["id"],
            })
        ```

        ## Import

        BdsInstanceIdentityConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:BigDataService/bdsInstanceIdentityConfiguration:BdsInstanceIdentityConfiguration test_bds_instance_identity_configuration "bdsInstances/{bdsInstanceId}/identityConfigurations/{identityConfigurationId}"
        ```

        :param str resource_name: The name of the resource.
        :param BdsInstanceIdentityConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BdsInstanceIdentityConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activate_iam_user_sync_configuration_trigger: Optional[pulumi.Input[builtins.str]] = None,
                 activate_upst_configuration_trigger: Optional[pulumi.Input[builtins.str]] = None,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 confidential_application_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 iam_user_sync_configuration_details: Optional[pulumi.Input[Union['BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgs', 'BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgsDict']]] = None,
                 identity_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_confidential_application_trigger: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_upst_token_exchange_keytab_trigger: Optional[pulumi.Input[builtins.str]] = None,
                 upst_configuration_details: Optional[pulumi.Input[Union['BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgs', 'BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BdsInstanceIdentityConfigurationArgs.__new__(BdsInstanceIdentityConfigurationArgs)

            __props__.__dict__["activate_iam_user_sync_configuration_trigger"] = activate_iam_user_sync_configuration_trigger
            __props__.__dict__["activate_upst_configuration_trigger"] = activate_upst_configuration_trigger
            if bds_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'bds_instance_id'")
            __props__.__dict__["bds_instance_id"] = bds_instance_id
            if cluster_admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_admin_password'")
            __props__.__dict__["cluster_admin_password"] = None if cluster_admin_password is None else pulumi.Output.secret(cluster_admin_password)
            if confidential_application_id is None and not opts.urn:
                raise TypeError("Missing required property 'confidential_application_id'")
            __props__.__dict__["confidential_application_id"] = confidential_application_id
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["iam_user_sync_configuration_details"] = iam_user_sync_configuration_details
            if identity_domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'identity_domain_id'")
            __props__.__dict__["identity_domain_id"] = identity_domain_id
            __props__.__dict__["refresh_confidential_application_trigger"] = refresh_confidential_application_trigger
            __props__.__dict__["refresh_upst_token_exchange_keytab_trigger"] = refresh_upst_token_exchange_keytab_trigger
            __props__.__dict__["upst_configuration_details"] = upst_configuration_details
            __props__.__dict__["iam_user_sync_configurations"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["upst_configurations"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clusterAdminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BdsInstanceIdentityConfiguration, __self__).__init__(
            'oci:BigDataService/bdsInstanceIdentityConfiguration:BdsInstanceIdentityConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activate_iam_user_sync_configuration_trigger: Optional[pulumi.Input[builtins.str]] = None,
            activate_upst_configuration_trigger: Optional[pulumi.Input[builtins.str]] = None,
            bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
            cluster_admin_password: Optional[pulumi.Input[builtins.str]] = None,
            confidential_application_id: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            iam_user_sync_configuration_details: Optional[pulumi.Input[Union['BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgs', 'BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgsDict']]] = None,
            iam_user_sync_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceIdentityConfigurationIamUserSyncConfigurationArgs', 'BdsInstanceIdentityConfigurationIamUserSyncConfigurationArgsDict']]]]] = None,
            identity_domain_id: Optional[pulumi.Input[builtins.str]] = None,
            refresh_confidential_application_trigger: Optional[pulumi.Input[builtins.str]] = None,
            refresh_upst_token_exchange_keytab_trigger: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            upst_configuration_details: Optional[pulumi.Input[Union['BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgs', 'BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgsDict']]] = None,
            upst_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceIdentityConfigurationUpstConfigurationArgs', 'BdsInstanceIdentityConfigurationUpstConfigurationArgsDict']]]]] = None) -> 'BdsInstanceIdentityConfiguration':
        """
        Get an existing BdsInstanceIdentityConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] activate_iam_user_sync_configuration_trigger: (Updatable) An optional property when set to "true" triggers Activate Iam User Sync Configuration and when set to "false" triggers Deactivate Iam User Sync Configuration.
        :param pulumi.Input[builtins.str] activate_upst_configuration_trigger: (Updatable) An optional property when set to "true" triggers Activate Upst Configuration and when set to "false" triggers Deactivate Upst Configuration.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[builtins.str] cluster_admin_password: (Updatable) Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[builtins.str] confidential_application_id: Identity domain confidential application ID for the identity config, required for creating identity configuration
        :param pulumi.Input[builtins.str] display_name: Display name of the identity configuration, required for creating identity configuration.
        :param pulumi.Input[Union['BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgs', 'BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetailsArgsDict']] iam_user_sync_configuration_details: (Updatable) Details for activating/updating an IAM user sync configuration
        :param pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceIdentityConfigurationIamUserSyncConfigurationArgs', 'BdsInstanceIdentityConfigurationIamUserSyncConfigurationArgsDict']]]] iam_user_sync_configurations: Information about the IAM user sync configuration.
        :param pulumi.Input[builtins.str] identity_domain_id: Identity domain OCID to use for identity config, required for creating identity configuration
        :param pulumi.Input[builtins.str] refresh_confidential_application_trigger: (Updatable) An optional property when set to "true" triggers Refresh Confidential Application.
        :param pulumi.Input[builtins.str] refresh_upst_token_exchange_keytab_trigger: (Updatable) An optional property when set to "true"  triggers Refresh Upst Token Exchange Keytab.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: Lifecycle state of the UPST config
        :param pulumi.Input[builtins.str] time_created: Time when this UPST config was created, shown as an RFC 3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: Time when this UPST config was updated, shown as an RFC 3339 formatted datetime string.
        :param pulumi.Input[Union['BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgs', 'BdsInstanceIdentityConfigurationUpstConfigurationDetailsArgsDict']] upst_configuration_details: (Updatable) Details for activating/updating UPST config on the cluster
        :param pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceIdentityConfigurationUpstConfigurationArgs', 'BdsInstanceIdentityConfigurationUpstConfigurationArgsDict']]]] upst_configurations: Information about the UPST configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BdsInstanceIdentityConfigurationState.__new__(_BdsInstanceIdentityConfigurationState)

        __props__.__dict__["activate_iam_user_sync_configuration_trigger"] = activate_iam_user_sync_configuration_trigger
        __props__.__dict__["activate_upst_configuration_trigger"] = activate_upst_configuration_trigger
        __props__.__dict__["bds_instance_id"] = bds_instance_id
        __props__.__dict__["cluster_admin_password"] = cluster_admin_password
        __props__.__dict__["confidential_application_id"] = confidential_application_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["iam_user_sync_configuration_details"] = iam_user_sync_configuration_details
        __props__.__dict__["iam_user_sync_configurations"] = iam_user_sync_configurations
        __props__.__dict__["identity_domain_id"] = identity_domain_id
        __props__.__dict__["refresh_confidential_application_trigger"] = refresh_confidential_application_trigger
        __props__.__dict__["refresh_upst_token_exchange_keytab_trigger"] = refresh_upst_token_exchange_keytab_trigger
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["upst_configuration_details"] = upst_configuration_details
        __props__.__dict__["upst_configurations"] = upst_configurations
        return BdsInstanceIdentityConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activateIamUserSyncConfigurationTrigger")
    def activate_iam_user_sync_configuration_trigger(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) An optional property when set to "true" triggers Activate Iam User Sync Configuration and when set to "false" triggers Deactivate Iam User Sync Configuration.
        """
        return pulumi.get(self, "activate_iam_user_sync_configuration_trigger")

    @property
    @pulumi.getter(name="activateUpstConfigurationTrigger")
    def activate_upst_configuration_trigger(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) An optional property when set to "true" triggers Activate Upst Configuration and when set to "false" triggers Deactivate Upst Configuration.
        """
        return pulumi.get(self, "activate_upst_configuration_trigger")

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @property
    @pulumi.getter(name="confidentialApplicationId")
    def confidential_application_id(self) -> pulumi.Output[builtins.str]:
        """
        Identity domain confidential application ID for the identity config, required for creating identity configuration
        """
        return pulumi.get(self, "confidential_application_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Display name of the identity configuration, required for creating identity configuration.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="iamUserSyncConfigurationDetails")
    def iam_user_sync_configuration_details(self) -> pulumi.Output['outputs.BdsInstanceIdentityConfigurationIamUserSyncConfigurationDetails']:
        """
        (Updatable) Details for activating/updating an IAM user sync configuration
        """
        return pulumi.get(self, "iam_user_sync_configuration_details")

    @property
    @pulumi.getter(name="iamUserSyncConfigurations")
    def iam_user_sync_configurations(self) -> pulumi.Output[Sequence['outputs.BdsInstanceIdentityConfigurationIamUserSyncConfiguration']]:
        """
        Information about the IAM user sync configuration.
        """
        return pulumi.get(self, "iam_user_sync_configurations")

    @property
    @pulumi.getter(name="identityDomainId")
    def identity_domain_id(self) -> pulumi.Output[builtins.str]:
        """
        Identity domain OCID to use for identity config, required for creating identity configuration
        """
        return pulumi.get(self, "identity_domain_id")

    @property
    @pulumi.getter(name="refreshConfidentialApplicationTrigger")
    def refresh_confidential_application_trigger(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) An optional property when set to "true" triggers Refresh Confidential Application.
        """
        return pulumi.get(self, "refresh_confidential_application_trigger")

    @property
    @pulumi.getter(name="refreshUpstTokenExchangeKeytabTrigger")
    def refresh_upst_token_exchange_keytab_trigger(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) An optional property when set to "true"  triggers Refresh Upst Token Exchange Keytab.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "refresh_upst_token_exchange_keytab_trigger")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Lifecycle state of the UPST config
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        Time when this UPST config was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        Time when this UPST config was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="upstConfigurationDetails")
    def upst_configuration_details(self) -> pulumi.Output['outputs.BdsInstanceIdentityConfigurationUpstConfigurationDetails']:
        """
        (Updatable) Details for activating/updating UPST config on the cluster
        """
        return pulumi.get(self, "upst_configuration_details")

    @property
    @pulumi.getter(name="upstConfigurations")
    def upst_configurations(self) -> pulumi.Output[Sequence['outputs.BdsInstanceIdentityConfigurationUpstConfiguration']]:
        """
        Information about the UPST configuration.
        """
        return pulumi.get(self, "upst_configurations")

