# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'OccAvailabilityCatalogDetailArgs',
    'OccAvailabilityCatalogDetailArgsDict',
    'OccAvailabilityCatalogMetadataDetailsArgs',
    'OccAvailabilityCatalogMetadataDetailsArgsDict',
    'OccCapacityRequestDetailArgs',
    'OccCapacityRequestDetailArgsDict',
    'OccCapacityRequestDetailAssociatedOccHandoverResourceBlockListArgs',
    'OccCapacityRequestDetailAssociatedOccHandoverResourceBlockListArgsDict',
    'OccCapacityRequestPatchOperationArgs',
    'OccCapacityRequestPatchOperationArgsDict',
    'OccCustomerGroupCustomersListArgs',
    'OccCustomerGroupCustomersListArgsDict',
    'GetInternalNamespaceOccOverviewsFilterArgs',
    'GetInternalNamespaceOccOverviewsFilterArgsDict',
    'GetInternalOccAvailabilityCatalogsFilterArgs',
    'GetInternalOccAvailabilityCatalogsFilterArgsDict',
    'GetInternalOccHandoverResourceBlockDetailsFilterArgs',
    'GetInternalOccHandoverResourceBlockDetailsFilterArgsDict',
    'GetInternalOccHandoverResourceBlocksFilterArgs',
    'GetInternalOccHandoverResourceBlocksFilterArgsDict',
    'GetNamespaceOccOverviewsFilterArgs',
    'GetNamespaceOccOverviewsFilterArgsDict',
    'GetOccAvailabilityCatalogOccAvailabilitiesFilterArgs',
    'GetOccAvailabilityCatalogOccAvailabilitiesFilterArgsDict',
    'GetOccAvailabilityCatalogsFilterArgs',
    'GetOccAvailabilityCatalogsFilterArgsDict',
    'GetOccCapacityRequestsFilterArgs',
    'GetOccCapacityRequestsFilterArgsDict',
    'GetOccCustomerGroupsFilterArgs',
    'GetOccCustomerGroupsFilterArgsDict',
    'GetOccHandoverResourceBlockDetailsFilterArgs',
    'GetOccHandoverResourceBlockDetailsFilterArgsDict',
    'GetOccHandoverResourceBlocksFilterArgs',
    'GetOccHandoverResourceBlocksFilterArgsDict',
]

MYPY = False

if not MYPY:
    class OccAvailabilityCatalogDetailArgsDict(TypedDict):
        available_quantity: NotRequired[pulumi.Input[builtins.str]]
        """
        The quantity of resource currently available that the customer can request.
        """
        catalog_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The OCID of the availability catalog.
        """
        date_expected_capacity_handover: NotRequired[pulumi.Input[builtins.str]]
        """
        The date by which the capacity requested by customers before dateFinalCustomerOrder needs to be fulfilled.
        """
        date_final_customer_order: NotRequired[pulumi.Input[builtins.str]]
        """
        The date by which the customer must place the order to have their capacity requirements met by the customer handover date.
        """
        demanded_quantity: NotRequired[pulumi.Input[builtins.str]]
        """
        The quantity of resource currently demanded by the customer.
        """
        namespace: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        """
        resource_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the resource that the customer can request.
        """
        resource_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The different types of resources against which customers can place capacity requests.
        """
        system_tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        total_available_quantity: NotRequired[pulumi.Input[builtins.str]]
        """
        The total quantity of resource that the customer can request.
        """
        unit: NotRequired[pulumi.Input[builtins.str]]
        """
        The unit in which the resource available is measured.
        """
        workload_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of workload (Generic/ROW).
        """
elif False:
    OccAvailabilityCatalogDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OccAvailabilityCatalogDetailArgs:
    def __init__(__self__, *,
                 available_quantity: Optional[pulumi.Input[builtins.str]] = None,
                 catalog_id: Optional[pulumi.Input[builtins.str]] = None,
                 date_expected_capacity_handover: Optional[pulumi.Input[builtins.str]] = None,
                 date_final_customer_order: Optional[pulumi.Input[builtins.str]] = None,
                 demanded_quantity: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 resource_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 total_available_quantity: Optional[pulumi.Input[builtins.str]] = None,
                 unit: Optional[pulumi.Input[builtins.str]] = None,
                 workload_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] available_quantity: The quantity of resource currently available that the customer can request.
        :param pulumi.Input[builtins.str] catalog_id: The OCID of the availability catalog.
        :param pulumi.Input[builtins.str] date_expected_capacity_handover: The date by which the capacity requested by customers before dateFinalCustomerOrder needs to be fulfilled.
        :param pulumi.Input[builtins.str] date_final_customer_order: The date by which the customer must place the order to have their capacity requirements met by the customer handover date.
        :param pulumi.Input[builtins.str] demanded_quantity: The quantity of resource currently demanded by the customer.
        :param pulumi.Input[builtins.str] namespace: The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        :param pulumi.Input[builtins.str] resource_name: The name of the resource that the customer can request.
        :param pulumi.Input[builtins.str] resource_type: The different types of resources against which customers can place capacity requests.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] total_available_quantity: The total quantity of resource that the customer can request.
        :param pulumi.Input[builtins.str] unit: The unit in which the resource available is measured.
        :param pulumi.Input[builtins.str] workload_type: The type of workload (Generic/ROW).
        """
        if available_quantity is not None:
            pulumi.set(__self__, "available_quantity", available_quantity)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if date_expected_capacity_handover is not None:
            pulumi.set(__self__, "date_expected_capacity_handover", date_expected_capacity_handover)
        if date_final_customer_order is not None:
            pulumi.set(__self__, "date_final_customer_order", date_final_customer_order)
        if demanded_quantity is not None:
            pulumi.set(__self__, "demanded_quantity", demanded_quantity)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if total_available_quantity is not None:
            pulumi.set(__self__, "total_available_quantity", total_available_quantity)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="availableQuantity")
    def available_quantity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The quantity of resource currently available that the customer can request.
        """
        return pulumi.get(self, "available_quantity")

    @available_quantity.setter
    def available_quantity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "available_quantity", value)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the availability catalog.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="dateExpectedCapacityHandover")
    def date_expected_capacity_handover(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date by which the capacity requested by customers before dateFinalCustomerOrder needs to be fulfilled.
        """
        return pulumi.get(self, "date_expected_capacity_handover")

    @date_expected_capacity_handover.setter
    def date_expected_capacity_handover(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "date_expected_capacity_handover", value)

    @property
    @pulumi.getter(name="dateFinalCustomerOrder")
    def date_final_customer_order(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date by which the customer must place the order to have their capacity requirements met by the customer handover date.
        """
        return pulumi.get(self, "date_final_customer_order")

    @date_final_customer_order.setter
    def date_final_customer_order(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "date_final_customer_order", value)

    @property
    @pulumi.getter(name="demandedQuantity")
    def demanded_quantity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The quantity of resource currently demanded by the customer.
        """
        return pulumi.get(self, "demanded_quantity")

    @demanded_quantity.setter
    def demanded_quantity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "demanded_quantity", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource that the customer can request.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The different types of resources against which customers can place capacity requests.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="totalAvailableQuantity")
    def total_available_quantity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The total quantity of resource that the customer can request.
        """
        return pulumi.get(self, "total_available_quantity")

    @total_available_quantity.setter
    def total_available_quantity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "total_available_quantity", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unit in which the resource available is measured.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unit", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of workload (Generic/ROW).
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workload_type", value)


if not MYPY:
    class OccAvailabilityCatalogMetadataDetailsArgsDict(TypedDict):
        format_version: pulumi.Input[builtins.str]
        """
        The version for the format of the catalog file being uploaded.
        """
elif False:
    OccAvailabilityCatalogMetadataDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OccAvailabilityCatalogMetadataDetailsArgs:
    def __init__(__self__, *,
                 format_version: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] format_version: The version for the format of the catalog file being uploaded.
        """
        pulumi.set(__self__, "format_version", format_version)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> pulumi.Input[builtins.str]:
        """
        The version for the format of the catalog file being uploaded.
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "format_version", value)


if not MYPY:
    class OccCapacityRequestDetailArgsDict(TypedDict):
        demand_quantity: pulumi.Input[builtins.str]
        """
        The number of compute server's with name <resourceName> required by the user.
        """
        resource_name: pulumi.Input[builtins.str]
        """
        The name of the COMPUTE server shape for which the request is made. Do not use CAPACITY_CONSTRAINT as the resource name.
        """
        resource_type: pulumi.Input[builtins.str]
        """
        The type of the resource against which the user wants to place a capacity request.
        """
        workload_type: pulumi.Input[builtins.str]
        """
        The type of the workload (Generic/ROW).
        """
        actual_handover_quantity: NotRequired[pulumi.Input[builtins.str]]
        """
        The actual handed over quantity of resources at the time of request resolution.
        """
        associated_occ_handover_resource_block_lists: NotRequired[pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestDetailAssociatedOccHandoverResourceBlockListArgsDict']]]]
        """
        A list containing details about occHandoverResourceBlocks which were handed over for the corresponding resource name.
        """
        availability_domain: NotRequired[pulumi.Input[builtins.str]]
        """
        The availability domain of the resource which is to be transferred. Note that this is only required for Capacity Request Transfer requests.
        """
        date_actual_handover: NotRequired[pulumi.Input[builtins.str]]
        """
        The date on which the actual handover quantity of resources is delivered.
        """
        date_expected_handover: NotRequired[pulumi.Input[builtins.str]]
        """
        The date on which the latest increment to supplied quantity of resources was delivered.
        """
        expected_handover_quantity: NotRequired[pulumi.Input[builtins.str]]
        """
        The incremental quantity of resources supplied as the provisioning is underway.
        """
        source_workload_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The WorkloadType from where capacity request are to be transferred.
        """
elif False:
    OccCapacityRequestDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OccCapacityRequestDetailArgs:
    def __init__(__self__, *,
                 demand_quantity: pulumi.Input[builtins.str],
                 resource_name: pulumi.Input[builtins.str],
                 resource_type: pulumi.Input[builtins.str],
                 workload_type: pulumi.Input[builtins.str],
                 actual_handover_quantity: Optional[pulumi.Input[builtins.str]] = None,
                 associated_occ_handover_resource_block_lists: Optional[pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestDetailAssociatedOccHandoverResourceBlockListArgs']]]] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 date_actual_handover: Optional[pulumi.Input[builtins.str]] = None,
                 date_expected_handover: Optional[pulumi.Input[builtins.str]] = None,
                 expected_handover_quantity: Optional[pulumi.Input[builtins.str]] = None,
                 source_workload_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] demand_quantity: The number of compute server's with name <resourceName> required by the user.
        :param pulumi.Input[builtins.str] resource_name: The name of the COMPUTE server shape for which the request is made. Do not use CAPACITY_CONSTRAINT as the resource name.
        :param pulumi.Input[builtins.str] resource_type: The type of the resource against which the user wants to place a capacity request.
        :param pulumi.Input[builtins.str] workload_type: The type of the workload (Generic/ROW).
        :param pulumi.Input[builtins.str] actual_handover_quantity: The actual handed over quantity of resources at the time of request resolution.
        :param pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestDetailAssociatedOccHandoverResourceBlockListArgs']]] associated_occ_handover_resource_block_lists: A list containing details about occHandoverResourceBlocks which were handed over for the corresponding resource name.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain of the resource which is to be transferred. Note that this is only required for Capacity Request Transfer requests.
        :param pulumi.Input[builtins.str] date_actual_handover: The date on which the actual handover quantity of resources is delivered.
        :param pulumi.Input[builtins.str] date_expected_handover: The date on which the latest increment to supplied quantity of resources was delivered.
        :param pulumi.Input[builtins.str] expected_handover_quantity: The incremental quantity of resources supplied as the provisioning is underway.
        :param pulumi.Input[builtins.str] source_workload_type: The WorkloadType from where capacity request are to be transferred.
        """
        pulumi.set(__self__, "demand_quantity", demand_quantity)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "workload_type", workload_type)
        if actual_handover_quantity is not None:
            pulumi.set(__self__, "actual_handover_quantity", actual_handover_quantity)
        if associated_occ_handover_resource_block_lists is not None:
            pulumi.set(__self__, "associated_occ_handover_resource_block_lists", associated_occ_handover_resource_block_lists)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if date_actual_handover is not None:
            pulumi.set(__self__, "date_actual_handover", date_actual_handover)
        if date_expected_handover is not None:
            pulumi.set(__self__, "date_expected_handover", date_expected_handover)
        if expected_handover_quantity is not None:
            pulumi.set(__self__, "expected_handover_quantity", expected_handover_quantity)
        if source_workload_type is not None:
            pulumi.set(__self__, "source_workload_type", source_workload_type)

    @property
    @pulumi.getter(name="demandQuantity")
    def demand_quantity(self) -> pulumi.Input[builtins.str]:
        """
        The number of compute server's with name <resourceName> required by the user.
        """
        return pulumi.get(self, "demand_quantity")

    @demand_quantity.setter
    def demand_quantity(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "demand_quantity", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the COMPUTE server shape for which the request is made. Do not use CAPACITY_CONSTRAINT as the resource name.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the resource against which the user wants to place a capacity request.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the workload (Generic/ROW).
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workload_type", value)

    @property
    @pulumi.getter(name="actualHandoverQuantity")
    def actual_handover_quantity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The actual handed over quantity of resources at the time of request resolution.
        """
        return pulumi.get(self, "actual_handover_quantity")

    @actual_handover_quantity.setter
    def actual_handover_quantity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "actual_handover_quantity", value)

    @property
    @pulumi.getter(name="associatedOccHandoverResourceBlockLists")
    def associated_occ_handover_resource_block_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestDetailAssociatedOccHandoverResourceBlockListArgs']]]]:
        """
        A list containing details about occHandoverResourceBlocks which were handed over for the corresponding resource name.
        """
        return pulumi.get(self, "associated_occ_handover_resource_block_lists")

    @associated_occ_handover_resource_block_lists.setter
    def associated_occ_handover_resource_block_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestDetailAssociatedOccHandoverResourceBlockListArgs']]]]):
        pulumi.set(self, "associated_occ_handover_resource_block_lists", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability domain of the resource which is to be transferred. Note that this is only required for Capacity Request Transfer requests.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="dateActualHandover")
    def date_actual_handover(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date on which the actual handover quantity of resources is delivered.
        """
        return pulumi.get(self, "date_actual_handover")

    @date_actual_handover.setter
    def date_actual_handover(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "date_actual_handover", value)

    @property
    @pulumi.getter(name="dateExpectedHandover")
    def date_expected_handover(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date on which the latest increment to supplied quantity of resources was delivered.
        """
        return pulumi.get(self, "date_expected_handover")

    @date_expected_handover.setter
    def date_expected_handover(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "date_expected_handover", value)

    @property
    @pulumi.getter(name="expectedHandoverQuantity")
    def expected_handover_quantity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The incremental quantity of resources supplied as the provisioning is underway.
        """
        return pulumi.get(self, "expected_handover_quantity")

    @expected_handover_quantity.setter
    def expected_handover_quantity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expected_handover_quantity", value)

    @property
    @pulumi.getter(name="sourceWorkloadType")
    def source_workload_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The WorkloadType from where capacity request are to be transferred.
        """
        return pulumi.get(self, "source_workload_type")

    @source_workload_type.setter
    def source_workload_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_workload_type", value)


if not MYPY:
    class OccCapacityRequestDetailAssociatedOccHandoverResourceBlockListArgsDict(TypedDict):
        handover_quantity: NotRequired[pulumi.Input[builtins.str]]
        """
        The total quantity of the resource that was made available to the customer as part of this resource block
        """
        occ_handover_resource_block_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The OCID of the handed over resource block.
        """
elif False:
    OccCapacityRequestDetailAssociatedOccHandoverResourceBlockListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OccCapacityRequestDetailAssociatedOccHandoverResourceBlockListArgs:
    def __init__(__self__, *,
                 handover_quantity: Optional[pulumi.Input[builtins.str]] = None,
                 occ_handover_resource_block_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] handover_quantity: The total quantity of the resource that was made available to the customer as part of this resource block
        :param pulumi.Input[builtins.str] occ_handover_resource_block_id: The OCID of the handed over resource block.
        """
        if handover_quantity is not None:
            pulumi.set(__self__, "handover_quantity", handover_quantity)
        if occ_handover_resource_block_id is not None:
            pulumi.set(__self__, "occ_handover_resource_block_id", occ_handover_resource_block_id)

    @property
    @pulumi.getter(name="handoverQuantity")
    def handover_quantity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The total quantity of the resource that was made available to the customer as part of this resource block
        """
        return pulumi.get(self, "handover_quantity")

    @handover_quantity.setter
    def handover_quantity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "handover_quantity", value)

    @property
    @pulumi.getter(name="occHandoverResourceBlockId")
    def occ_handover_resource_block_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the handed over resource block.
        """
        return pulumi.get(self, "occ_handover_resource_block_id")

    @occ_handover_resource_block_id.setter
    def occ_handover_resource_block_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "occ_handover_resource_block_id", value)


if not MYPY:
    class OccCapacityRequestPatchOperationArgsDict(TypedDict):
        from_: pulumi.Input[builtins.str]
        """
        (Updatable)
        """
        operation: pulumi.Input[builtins.str]
        """
        (Updatable) The operation can be one of these values: `INSERT`, `INSERT_MULTIPLE`, `MERGE`, `MOVE`, `PROHIBIT`, `REMOVE`, `REPLACE`, `REQUIRE`
        """
        selection: pulumi.Input[builtins.str]
        """
        (Updatable)
        """
        value: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]
        """
        (Updatable)
        """
        position: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable)
        """
        selected_item: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable)
        """
elif False:
    OccCapacityRequestPatchOperationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OccCapacityRequestPatchOperationArgs:
    def __init__(__self__, *,
                 from_: pulumi.Input[builtins.str],
                 operation: pulumi.Input[builtins.str],
                 selection: pulumi.Input[builtins.str],
                 value: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]],
                 position: Optional[pulumi.Input[builtins.str]] = None,
                 selected_item: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] from_: (Updatable)
        :param pulumi.Input[builtins.str] operation: (Updatable) The operation can be one of these values: `INSERT`, `INSERT_MULTIPLE`, `MERGE`, `MOVE`, `PROHIBIT`, `REMOVE`, `REPLACE`, `REQUIRE`
        :param pulumi.Input[builtins.str] selection: (Updatable)
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] value: (Updatable)
        :param pulumi.Input[builtins.str] position: (Updatable)
        :param pulumi.Input[builtins.str] selected_item: (Updatable)
        """
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "selection", selection)
        pulumi.set(__self__, "value", value)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if selected_item is not None:
            pulumi.set(__self__, "selected_item", selected_item)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable)
        """
        return pulumi.get(self, "from_")

    @from_.setter
    def from_(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "from_", value)

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The operation can be one of these values: `INSERT`, `INSERT_MULTIPLE`, `MERGE`, `MOVE`, `PROHIBIT`, `REMOVE`, `REPLACE`, `REQUIRE`
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def selection(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable)
        """
        return pulumi.get(self, "selection")

    @selection.setter
    def selection(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "selection", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter(name="selectedItem")
    def selected_item(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "selected_item")

    @selected_item.setter
    def selected_item(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "selected_item", value)


if not MYPY:
    class OccCustomerGroupCustomersListArgsDict(TypedDict):
        display_name: pulumi.Input[builtins.str]
        """
        The display name for the customer.
        """
        tenancy_id: pulumi.Input[builtins.str]
        """
        The OCID of the tenancy belonging to the customer.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        The description about the customer group.
        """
        occ_customer_group_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The OCID of the customer group.
        """
        status: NotRequired[pulumi.Input[builtins.str]]
        """
        To determine whether the customer is enabled/disabled.
        """
elif False:
    OccCustomerGroupCustomersListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OccCustomerGroupCustomersListArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 tenancy_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 occ_customer_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] display_name: The display name for the customer.
        :param pulumi.Input[builtins.str] tenancy_id: The OCID of the tenancy belonging to the customer.
        :param pulumi.Input[builtins.str] description: The description about the customer group.
        :param pulumi.Input[builtins.str] occ_customer_group_id: The OCID of the customer group.
        :param pulumi.Input[builtins.str] status: To determine whether the customer is enabled/disabled.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if occ_customer_group_id is not None:
            pulumi.set(__self__, "occ_customer_group_id", occ_customer_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The display name for the customer.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the tenancy belonging to the customer.
        """
        return pulumi.get(self, "tenancy_id")

    @tenancy_id.setter
    def tenancy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tenancy_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description about the customer group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="occCustomerGroupId")
    def occ_customer_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the customer group.
        """
        return pulumi.get(self, "occ_customer_group_id")

    @occ_customer_group_id.setter
    def occ_customer_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "occ_customer_group_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        To determine whether the customer is enabled/disabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)


if not MYPY:
    class GetInternalNamespaceOccOverviewsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetInternalNamespaceOccOverviewsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetInternalNamespaceOccOverviewsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetInternalOccAvailabilityCatalogsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetInternalOccAvailabilityCatalogsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetInternalOccAvailabilityCatalogsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetInternalOccHandoverResourceBlockDetailsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetInternalOccHandoverResourceBlockDetailsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetInternalOccHandoverResourceBlockDetailsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetInternalOccHandoverResourceBlocksFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetInternalOccHandoverResourceBlocksFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetInternalOccHandoverResourceBlocksFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetNamespaceOccOverviewsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetNamespaceOccOverviewsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetNamespaceOccOverviewsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetOccAvailabilityCatalogOccAvailabilitiesFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetOccAvailabilityCatalogOccAvailabilitiesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetOccAvailabilityCatalogOccAvailabilitiesFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetOccAvailabilityCatalogsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetOccAvailabilityCatalogsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetOccAvailabilityCatalogsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetOccCapacityRequestsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetOccCapacityRequestsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetOccCapacityRequestsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetOccCustomerGroupsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetOccCustomerGroupsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetOccCustomerGroupsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetOccHandoverResourceBlockDetailsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetOccHandoverResourceBlockDetailsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetOccHandoverResourceBlockDetailsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetOccHandoverResourceBlocksFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetOccHandoverResourceBlocksFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetOccHandoverResourceBlocksFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


