# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterResult',
    'AwaitableGetClusterResult',
    'get_cluster',
    'get_cluster_output',
]

@pulumi.output_type
class GetClusterResult:
    """
    A collection of values returned by getCluster.
    """
    def __init__(__self__, available_kubernetes_upgrades=None, cluster_id=None, cluster_pod_network_options=None, compartment_id=None, defined_tags=None, endpoint_configs=None, endpoints=None, freeform_tags=None, id=None, image_policy_configs=None, kms_key_id=None, kubernetes_version=None, lifecycle_details=None, metadatas=None, name=None, open_id_connect_discovery_endpoint=None, options=None, should_include_oidc_config_file=None, state=None, type=None, vcn_id=None):
        if available_kubernetes_upgrades and not isinstance(available_kubernetes_upgrades, list):
            raise TypeError("Expected argument 'available_kubernetes_upgrades' to be a list")
        pulumi.set(__self__, "available_kubernetes_upgrades", available_kubernetes_upgrades)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_pod_network_options and not isinstance(cluster_pod_network_options, list):
            raise TypeError("Expected argument 'cluster_pod_network_options' to be a list")
        pulumi.set(__self__, "cluster_pod_network_options", cluster_pod_network_options)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if endpoint_configs and not isinstance(endpoint_configs, list):
            raise TypeError("Expected argument 'endpoint_configs' to be a list")
        pulumi.set(__self__, "endpoint_configs", endpoint_configs)
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_policy_configs and not isinstance(image_policy_configs, list):
            raise TypeError("Expected argument 'image_policy_configs' to be a list")
        pulumi.set(__self__, "image_policy_configs", image_policy_configs)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kubernetes_version and not isinstance(kubernetes_version, str):
            raise TypeError("Expected argument 'kubernetes_version' to be a str")
        pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if open_id_connect_discovery_endpoint and not isinstance(open_id_connect_discovery_endpoint, str):
            raise TypeError("Expected argument 'open_id_connect_discovery_endpoint' to be a str")
        pulumi.set(__self__, "open_id_connect_discovery_endpoint", open_id_connect_discovery_endpoint)
        if options and not isinstance(options, list):
            raise TypeError("Expected argument 'options' to be a list")
        pulumi.set(__self__, "options", options)
        if should_include_oidc_config_file and not isinstance(should_include_oidc_config_file, str):
            raise TypeError("Expected argument 'should_include_oidc_config_file' to be a str")
        pulumi.set(__self__, "should_include_oidc_config_file", should_include_oidc_config_file)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vcn_id and not isinstance(vcn_id, str):
            raise TypeError("Expected argument 'vcn_id' to be a str")
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="availableKubernetesUpgrades")
    def available_kubernetes_upgrades(self) -> Sequence[builtins.str]:
        """
        Available Kubernetes versions to which the clusters masters may be upgraded.
        """
        return pulumi.get(self, "available_kubernetes_upgrades")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="clusterPodNetworkOptions")
    def cluster_pod_network_options(self) -> Sequence['outputs.GetClusterClusterPodNetworkOptionResult']:
        """
        Available CNIs and network options for existing and new node pools of the cluster
        """
        return pulumi.get(self, "cluster_pod_network_options")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment in which the cluster exists.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="endpointConfigs")
    def endpoint_configs(self) -> Sequence['outputs.GetClusterEndpointConfigResult']:
        """
        The network configuration for access to the Cluster control plane.
        """
        return pulumi.get(self, "endpoint_configs")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetClusterEndpointResult']:
        """
        Endpoints served up by the cluster masters.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imagePolicyConfigs")
    def image_policy_configs(self) -> Sequence['outputs.GetClusterImagePolicyConfigResult']:
        """
        The image verification policy for signature validation.
        """
        return pulumi.get(self, "image_policy_configs")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        """
        The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> builtins.str:
        """
        The version of Kubernetes running on the cluster masters.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Details about the state of the cluster masters.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetClusterMetadataResult']:
        """
        Metadata about the cluster.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="openIdConnectDiscoveryEndpoint")
    def open_id_connect_discovery_endpoint(self) -> builtins.str:
        return pulumi.get(self, "open_id_connect_discovery_endpoint")

    @property
    @pulumi.getter
    def options(self) -> Sequence['outputs.GetClusterOptionResult']:
        """
        Optional attributes for the cluster.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="shouldIncludeOidcConfigFile")
    def should_include_oidc_config_file(self) -> Optional[builtins.str]:
        return pulumi.get(self, "should_include_oidc_config_file")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The state of the cluster masters.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of cluster. Values can be BASIC_CLUSTER or ENHANCED_CLUSTER. For more information, see [Cluster Types](https://docs.cloud.oracle.com/iaas/Content/ContEng/Tasks/contengcomparingenhancedwithbasicclusters_topic.htm)
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> builtins.str:
        """
        The OCID of the virtual cloud network (VCN) in which the cluster exists.
        """
        return pulumi.get(self, "vcn_id")


class AwaitableGetClusterResult(GetClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterResult(
            available_kubernetes_upgrades=self.available_kubernetes_upgrades,
            cluster_id=self.cluster_id,
            cluster_pod_network_options=self.cluster_pod_network_options,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            endpoint_configs=self.endpoint_configs,
            endpoints=self.endpoints,
            freeform_tags=self.freeform_tags,
            id=self.id,
            image_policy_configs=self.image_policy_configs,
            kms_key_id=self.kms_key_id,
            kubernetes_version=self.kubernetes_version,
            lifecycle_details=self.lifecycle_details,
            metadatas=self.metadatas,
            name=self.name,
            open_id_connect_discovery_endpoint=self.open_id_connect_discovery_endpoint,
            options=self.options,
            should_include_oidc_config_file=self.should_include_oidc_config_file,
            state=self.state,
            type=self.type,
            vcn_id=self.vcn_id)


def get_cluster(cluster_id: Optional[builtins.str] = None,
                should_include_oidc_config_file: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterResult:
    """
    This data source provides details about a specific Cluster resource in Oracle Cloud Infrastructure Container Engine service.

    Get the details of a cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster = oci.ContainerEngine.get_cluster(cluster_id=test_cluster_oci_containerengine_cluster["id"],
        should_include_oidc_config_file=cluster_should_include_oidc_config_file)
    ```


    :param builtins.str cluster_id: The OCID of the cluster.
    :param builtins.str should_include_oidc_config_file: Boolean value to determine if the OpenIdConnectAuth configuration file should be displayed for the provided cluster.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['shouldIncludeOidcConfigFile'] = should_include_oidc_config_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ContainerEngine/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult).value

    return AwaitableGetClusterResult(
        available_kubernetes_upgrades=pulumi.get(__ret__, 'available_kubernetes_upgrades'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        cluster_pod_network_options=pulumi.get(__ret__, 'cluster_pod_network_options'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        endpoint_configs=pulumi.get(__ret__, 'endpoint_configs'),
        endpoints=pulumi.get(__ret__, 'endpoints'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        image_policy_configs=pulumi.get(__ret__, 'image_policy_configs'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        kubernetes_version=pulumi.get(__ret__, 'kubernetes_version'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        metadatas=pulumi.get(__ret__, 'metadatas'),
        name=pulumi.get(__ret__, 'name'),
        open_id_connect_discovery_endpoint=pulumi.get(__ret__, 'open_id_connect_discovery_endpoint'),
        options=pulumi.get(__ret__, 'options'),
        should_include_oidc_config_file=pulumi.get(__ret__, 'should_include_oidc_config_file'),
        state=pulumi.get(__ret__, 'state'),
        type=pulumi.get(__ret__, 'type'),
        vcn_id=pulumi.get(__ret__, 'vcn_id'))
def get_cluster_output(cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                       should_include_oidc_config_file: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterResult]:
    """
    This data source provides details about a specific Cluster resource in Oracle Cloud Infrastructure Container Engine service.

    Get the details of a cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster = oci.ContainerEngine.get_cluster(cluster_id=test_cluster_oci_containerengine_cluster["id"],
        should_include_oidc_config_file=cluster_should_include_oidc_config_file)
    ```


    :param builtins.str cluster_id: The OCID of the cluster.
    :param builtins.str should_include_oidc_config_file: Boolean value to determine if the OpenIdConnectAuth configuration file should be displayed for the provided cluster.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['shouldIncludeOidcConfigFile'] = should_include_oidc_config_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ContainerEngine/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult)
    return __ret__.apply(lambda __response__: GetClusterResult(
        available_kubernetes_upgrades=pulumi.get(__response__, 'available_kubernetes_upgrades'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        cluster_pod_network_options=pulumi.get(__response__, 'cluster_pod_network_options'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        endpoint_configs=pulumi.get(__response__, 'endpoint_configs'),
        endpoints=pulumi.get(__response__, 'endpoints'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        image_policy_configs=pulumi.get(__response__, 'image_policy_configs'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        kubernetes_version=pulumi.get(__response__, 'kubernetes_version'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        metadatas=pulumi.get(__response__, 'metadatas'),
        name=pulumi.get(__response__, 'name'),
        open_id_connect_discovery_endpoint=pulumi.get(__response__, 'open_id_connect_discovery_endpoint'),
        options=pulumi.get(__response__, 'options'),
        should_include_oidc_config_file=pulumi.get(__response__, 'should_include_oidc_config_file'),
        state=pulumi.get(__response__, 'state'),
        type=pulumi.get(__response__, 'type'),
        vcn_id=pulumi.get(__response__, 'vcn_id')))
