# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetByoasnResult',
    'AwaitableGetByoasnResult',
    'get_byoasn',
    'get_byoasn_output',
]

@pulumi.output_type
class GetByoasnResult:
    """
    A collection of values returned by getByoasn.
    """
    def __init__(__self__, asn=None, byoasn_id=None, byoip_ranges=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, state=None, time_created=None, time_updated=None, time_validated=None, validation_token=None):
        if asn and not isinstance(asn, str):
            raise TypeError("Expected argument 'asn' to be a str")
        pulumi.set(__self__, "asn", asn)
        if byoasn_id and not isinstance(byoasn_id, str):
            raise TypeError("Expected argument 'byoasn_id' to be a str")
        pulumi.set(__self__, "byoasn_id", byoasn_id)
        if byoip_ranges and not isinstance(byoip_ranges, list):
            raise TypeError("Expected argument 'byoip_ranges' to be a list")
        pulumi.set(__self__, "byoip_ranges", byoip_ranges)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if time_validated and not isinstance(time_validated, str):
            raise TypeError("Expected argument 'time_validated' to be a str")
        pulumi.set(__self__, "time_validated", time_validated)
        if validation_token and not isinstance(validation_token, str):
            raise TypeError("Expected argument 'validation_token' to be a str")
        pulumi.set(__self__, "validation_token", validation_token)

    @property
    @pulumi.getter
    def asn(self) -> builtins.str:
        """
        The Autonomous System Number (ASN) you are importing to the Oracle cloud.
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter(name="byoasnId")
    def byoasn_id(self) -> builtins.str:
        return pulumi.get(self, "byoasn_id")

    @property
    @pulumi.getter(name="byoipRanges")
    def byoip_ranges(self) -> Sequence['outputs.GetByoasnByoipRangeResult']:
        """
        The BYOIP Ranges that has the `Byoasn` as origin.
        """
        return pulumi.get(self, "byoip_ranges")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the `Byoasn` resource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `Byoasn` resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The `Byoasn` resource's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the `Byoasn` resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the `Byoasn` resource was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="timeValidated")
    def time_validated(self) -> builtins.str:
        """
        The date and time the `Byoasn` resource was validated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_validated")

    @property
    @pulumi.getter(name="validationToken")
    def validation_token(self) -> builtins.str:
        """
        The validation token is an internally-generated ASCII string used in the validation process. See [Importing a Byoasn](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/BYOASN.htm) for details.
        """
        return pulumi.get(self, "validation_token")


class AwaitableGetByoasnResult(GetByoasnResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetByoasnResult(
            asn=self.asn,
            byoasn_id=self.byoasn_id,
            byoip_ranges=self.byoip_ranges,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated,
            time_validated=self.time_validated,
            validation_token=self.validation_token)


def get_byoasn(byoasn_id: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetByoasnResult:
    """
    This data source provides details about a specific Byoasn resource in Oracle Cloud Infrastructure Core service.

    Gets the `Byoasn` resource. You must specify the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_byoasn = oci.Core.get_byoasn(byoasn_id=test_byoasn_oci_core_byoasn["id"])
    ```


    :param builtins.str byoasn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `Byoasn` resource.
    """
    __args__ = dict()
    __args__['byoasnId'] = byoasn_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getByoasn:getByoasn', __args__, opts=opts, typ=GetByoasnResult).value

    return AwaitableGetByoasnResult(
        asn=pulumi.get(__ret__, 'asn'),
        byoasn_id=pulumi.get(__ret__, 'byoasn_id'),
        byoip_ranges=pulumi.get(__ret__, 'byoip_ranges'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        time_validated=pulumi.get(__ret__, 'time_validated'),
        validation_token=pulumi.get(__ret__, 'validation_token'))
def get_byoasn_output(byoasn_id: Optional[pulumi.Input[builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetByoasnResult]:
    """
    This data source provides details about a specific Byoasn resource in Oracle Cloud Infrastructure Core service.

    Gets the `Byoasn` resource. You must specify the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_byoasn = oci.Core.get_byoasn(byoasn_id=test_byoasn_oci_core_byoasn["id"])
    ```


    :param builtins.str byoasn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `Byoasn` resource.
    """
    __args__ = dict()
    __args__['byoasnId'] = byoasn_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getByoasn:getByoasn', __args__, opts=opts, typ=GetByoasnResult)
    return __ret__.apply(lambda __response__: GetByoasnResult(
        asn=pulumi.get(__response__, 'asn'),
        byoasn_id=pulumi.get(__response__, 'byoasn_id'),
        byoip_ranges=pulumi.get(__response__, 'byoip_ranges'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        time_validated=pulumi.get(__response__, 'time_validated'),
        validation_token=pulumi.get(__response__, 'validation_token')))
