# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalDbSystemArgs', 'ExternalDbSystem']

@pulumi.input_type
class ExternalDbSystemArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 db_system_discovery_id: pulumi.Input[builtins.str],
                 database_management_config: Optional[pulumi.Input['ExternalDbSystemDatabaseManagementConfigArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 stack_monitoring_config: Optional[pulumi.Input['ExternalDbSystemStackMonitoringConfigArgs']] = None):
        """
        The set of arguments for constructing a ExternalDbSystem resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the external DB system resides.
        :param pulumi.Input[builtins.str] db_system_discovery_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system discovery.
        :param pulumi.Input['ExternalDbSystemDatabaseManagementConfigArgs'] database_management_config: The details required to enable Database Management for an external DB system.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) The user-friendly name for the DB system. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['ExternalDbSystemStackMonitoringConfigArgs'] stack_monitoring_config: The details of the associated service that will be enabled or disabled for an external DB System.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "db_system_discovery_id", db_system_discovery_id)
        if database_management_config is not None:
            pulumi.set(__self__, "database_management_config", database_management_config)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if stack_monitoring_config is not None:
            pulumi.set(__self__, "stack_monitoring_config", stack_monitoring_config)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the external DB system resides.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dbSystemDiscoveryId")
    def db_system_discovery_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system discovery.
        """
        return pulumi.get(self, "db_system_discovery_id")

    @db_system_discovery_id.setter
    def db_system_discovery_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "db_system_discovery_id", value)

    @property
    @pulumi.getter(name="databaseManagementConfig")
    def database_management_config(self) -> Optional[pulumi.Input['ExternalDbSystemDatabaseManagementConfigArgs']]:
        """
        The details required to enable Database Management for an external DB system.
        """
        return pulumi.get(self, "database_management_config")

    @database_management_config.setter
    def database_management_config(self, value: Optional[pulumi.Input['ExternalDbSystemDatabaseManagementConfigArgs']]):
        pulumi.set(self, "database_management_config", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The user-friendly name for the DB system. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="stackMonitoringConfig")
    def stack_monitoring_config(self) -> Optional[pulumi.Input['ExternalDbSystemStackMonitoringConfigArgs']]:
        """
        The details of the associated service that will be enabled or disabled for an external DB System.
        """
        return pulumi.get(self, "stack_monitoring_config")

    @stack_monitoring_config.setter
    def stack_monitoring_config(self, value: Optional[pulumi.Input['ExternalDbSystemStackMonitoringConfigArgs']]):
        pulumi.set(self, "stack_monitoring_config", value)


@pulumi.input_type
class _ExternalDbSystemState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_management_config: Optional[pulumi.Input['ExternalDbSystemDatabaseManagementConfigArgs']] = None,
                 db_system_discovery_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 discovery_agent_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 home_directory: Optional[pulumi.Input[builtins.str]] = None,
                 is_cluster: Optional[pulumi.Input[builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 stack_monitoring_config: Optional[pulumi.Input['ExternalDbSystemStackMonitoringConfigArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ExternalDbSystem resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the external DB system resides.
        :param pulumi.Input['ExternalDbSystemDatabaseManagementConfigArgs'] database_management_config: The details required to enable Database Management for an external DB system.
        :param pulumi.Input[builtins.str] db_system_discovery_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system discovery.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] discovery_agent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management agent used during the discovery of the DB system.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The user-friendly name for the DB system. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] home_directory: The Oracle Grid home directory in case of cluster-based DB system and Oracle home directory in case of single instance-based DB system.
        :param pulumi.Input[builtins.bool] is_cluster: Indicates whether the DB system is a cluster DB system or not.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input['ExternalDbSystemStackMonitoringConfigArgs'] stack_monitoring_config: The details of the associated service that will be enabled or disabled for an external DB System.
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the external DB system resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the external DB system was created.
        :param pulumi.Input[builtins.str] time_updated: The date and time the external DB system was last updated.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if database_management_config is not None:
            pulumi.set(__self__, "database_management_config", database_management_config)
        if db_system_discovery_id is not None:
            pulumi.set(__self__, "db_system_discovery_id", db_system_discovery_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if discovery_agent_id is not None:
            pulumi.set(__self__, "discovery_agent_id", discovery_agent_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if home_directory is not None:
            pulumi.set(__self__, "home_directory", home_directory)
        if is_cluster is not None:
            pulumi.set(__self__, "is_cluster", is_cluster)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if stack_monitoring_config is not None:
            pulumi.set(__self__, "stack_monitoring_config", stack_monitoring_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the external DB system resides.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="databaseManagementConfig")
    def database_management_config(self) -> Optional[pulumi.Input['ExternalDbSystemDatabaseManagementConfigArgs']]:
        """
        The details required to enable Database Management for an external DB system.
        """
        return pulumi.get(self, "database_management_config")

    @database_management_config.setter
    def database_management_config(self, value: Optional[pulumi.Input['ExternalDbSystemDatabaseManagementConfigArgs']]):
        pulumi.set(self, "database_management_config", value)

    @property
    @pulumi.getter(name="dbSystemDiscoveryId")
    def db_system_discovery_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system discovery.
        """
        return pulumi.get(self, "db_system_discovery_id")

    @db_system_discovery_id.setter
    def db_system_discovery_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_system_discovery_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="discoveryAgentId")
    def discovery_agent_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management agent used during the discovery of the DB system.
        """
        return pulumi.get(self, "discovery_agent_id")

    @discovery_agent_id.setter
    def discovery_agent_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "discovery_agent_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The user-friendly name for the DB system. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="homeDirectory")
    def home_directory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Oracle Grid home directory in case of cluster-based DB system and Oracle home directory in case of single instance-based DB system.
        """
        return pulumi.get(self, "home_directory")

    @home_directory.setter
    def home_directory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "home_directory", value)

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the DB system is a cluster DB system or not.
        """
        return pulumi.get(self, "is_cluster")

    @is_cluster.setter
    def is_cluster(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_cluster", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="stackMonitoringConfig")
    def stack_monitoring_config(self) -> Optional[pulumi.Input['ExternalDbSystemStackMonitoringConfigArgs']]:
        """
        The details of the associated service that will be enabled or disabled for an external DB System.
        """
        return pulumi.get(self, "stack_monitoring_config")

    @stack_monitoring_config.setter
    def stack_monitoring_config(self, value: Optional[pulumi.Input['ExternalDbSystemStackMonitoringConfigArgs']]):
        pulumi.set(self, "stack_monitoring_config", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current lifecycle state of the external DB system resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the external DB system was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the external DB system was last updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:DatabaseManagement/externalDbSystem:ExternalDbSystem")
class ExternalDbSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_management_config: Optional[pulumi.Input[Union['ExternalDbSystemDatabaseManagementConfigArgs', 'ExternalDbSystemDatabaseManagementConfigArgsDict']]] = None,
                 db_system_discovery_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 stack_monitoring_config: Optional[pulumi.Input[Union['ExternalDbSystemStackMonitoringConfigArgs', 'ExternalDbSystemStackMonitoringConfigArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the External Db System resource in Oracle Cloud Infrastructure Database Management service.

        Creates an external DB system and its related resources.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_db_system = oci.database_management.ExternalDbSystem("test_external_db_system",
            compartment_id=compartment_id,
            db_system_discovery_id=test_db_system_discovery["id"],
            database_management_config={
                "license_model": external_db_system_database_management_config_license_model,
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=external_db_system_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            stack_monitoring_config={
                "is_enabled": external_db_system_stack_monitoring_config_is_enabled,
                "metadata": external_db_system_stack_monitoring_config_metadata,
            })
        ```

        ## Import

        ExternalDbSystems can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseManagement/externalDbSystem:ExternalDbSystem test_external_db_system "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the external DB system resides.
        :param pulumi.Input[Union['ExternalDbSystemDatabaseManagementConfigArgs', 'ExternalDbSystemDatabaseManagementConfigArgsDict']] database_management_config: The details required to enable Database Management for an external DB system.
        :param pulumi.Input[builtins.str] db_system_discovery_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system discovery.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) The user-friendly name for the DB system. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['ExternalDbSystemStackMonitoringConfigArgs', 'ExternalDbSystemStackMonitoringConfigArgsDict']] stack_monitoring_config: The details of the associated service that will be enabled or disabled for an external DB System.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalDbSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the External Db System resource in Oracle Cloud Infrastructure Database Management service.

        Creates an external DB system and its related resources.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_db_system = oci.database_management.ExternalDbSystem("test_external_db_system",
            compartment_id=compartment_id,
            db_system_discovery_id=test_db_system_discovery["id"],
            database_management_config={
                "license_model": external_db_system_database_management_config_license_model,
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=external_db_system_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            stack_monitoring_config={
                "is_enabled": external_db_system_stack_monitoring_config_is_enabled,
                "metadata": external_db_system_stack_monitoring_config_metadata,
            })
        ```

        ## Import

        ExternalDbSystems can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseManagement/externalDbSystem:ExternalDbSystem test_external_db_system "id"
        ```

        :param str resource_name: The name of the resource.
        :param ExternalDbSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalDbSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_management_config: Optional[pulumi.Input[Union['ExternalDbSystemDatabaseManagementConfigArgs', 'ExternalDbSystemDatabaseManagementConfigArgsDict']]] = None,
                 db_system_discovery_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 stack_monitoring_config: Optional[pulumi.Input[Union['ExternalDbSystemStackMonitoringConfigArgs', 'ExternalDbSystemStackMonitoringConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalDbSystemArgs.__new__(ExternalDbSystemArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["database_management_config"] = database_management_config
            if db_system_discovery_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_system_discovery_id'")
            __props__.__dict__["db_system_discovery_id"] = db_system_discovery_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["stack_monitoring_config"] = stack_monitoring_config
            __props__.__dict__["discovery_agent_id"] = None
            __props__.__dict__["home_directory"] = None
            __props__.__dict__["is_cluster"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(ExternalDbSystem, __self__).__init__(
            'oci:DatabaseManagement/externalDbSystem:ExternalDbSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            database_management_config: Optional[pulumi.Input[Union['ExternalDbSystemDatabaseManagementConfigArgs', 'ExternalDbSystemDatabaseManagementConfigArgsDict']]] = None,
            db_system_discovery_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            discovery_agent_id: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            home_directory: Optional[pulumi.Input[builtins.str]] = None,
            is_cluster: Optional[pulumi.Input[builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            stack_monitoring_config: Optional[pulumi.Input[Union['ExternalDbSystemStackMonitoringConfigArgs', 'ExternalDbSystemStackMonitoringConfigArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'ExternalDbSystem':
        """
        Get an existing ExternalDbSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the external DB system resides.
        :param pulumi.Input[Union['ExternalDbSystemDatabaseManagementConfigArgs', 'ExternalDbSystemDatabaseManagementConfigArgsDict']] database_management_config: The details required to enable Database Management for an external DB system.
        :param pulumi.Input[builtins.str] db_system_discovery_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system discovery.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] discovery_agent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management agent used during the discovery of the DB system.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The user-friendly name for the DB system. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] home_directory: The Oracle Grid home directory in case of cluster-based DB system and Oracle home directory in case of single instance-based DB system.
        :param pulumi.Input[builtins.bool] is_cluster: Indicates whether the DB system is a cluster DB system or not.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[Union['ExternalDbSystemStackMonitoringConfigArgs', 'ExternalDbSystemStackMonitoringConfigArgsDict']] stack_monitoring_config: The details of the associated service that will be enabled or disabled for an external DB System.
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the external DB system resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the external DB system was created.
        :param pulumi.Input[builtins.str] time_updated: The date and time the external DB system was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalDbSystemState.__new__(_ExternalDbSystemState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["database_management_config"] = database_management_config
        __props__.__dict__["db_system_discovery_id"] = db_system_discovery_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["discovery_agent_id"] = discovery_agent_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["home_directory"] = home_directory
        __props__.__dict__["is_cluster"] = is_cluster
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["stack_monitoring_config"] = stack_monitoring_config
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return ExternalDbSystem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the external DB system resides.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseManagementConfig")
    def database_management_config(self) -> pulumi.Output['outputs.ExternalDbSystemDatabaseManagementConfig']:
        """
        The details required to enable Database Management for an external DB system.
        """
        return pulumi.get(self, "database_management_config")

    @property
    @pulumi.getter(name="dbSystemDiscoveryId")
    def db_system_discovery_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system discovery.
        """
        return pulumi.get(self, "db_system_discovery_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="discoveryAgentId")
    def discovery_agent_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management agent used during the discovery of the DB system.
        """
        return pulumi.get(self, "discovery_agent_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The user-friendly name for the DB system. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="homeDirectory")
    def home_directory(self) -> pulumi.Output[builtins.str]:
        """
        The Oracle Grid home directory in case of cluster-based DB system and Oracle home directory in case of single instance-based DB system.
        """
        return pulumi.get(self, "home_directory")

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether the DB system is a cluster DB system or not.
        """
        return pulumi.get(self, "is_cluster")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="stackMonitoringConfig")
    def stack_monitoring_config(self) -> pulumi.Output['outputs.ExternalDbSystemStackMonitoringConfig']:
        """
        The details of the associated service that will be enabled or disabled for an external DB System.
        """
        return pulumi.get(self, "stack_monitoring_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current lifecycle state of the external DB system resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the external DB system was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the external DB system was last updated.
        """
        return pulumi.get(self, "time_updated")

