# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMaskingReportsMaskedColumnResult',
    'AwaitableGetMaskingReportsMaskedColumnResult',
    'get_masking_reports_masked_column',
    'get_masking_reports_masked_column_output',
]

@pulumi.output_type
class GetMaskingReportsMaskedColumnResult:
    """
    A collection of values returned by getMaskingReportsMaskedColumn.
    """
    def __init__(__self__, column_names=None, id=None, items=None, masking_column_groups=None, masking_report_id=None, object_types=None, objects=None, schema_names=None, sensitive_type_id=None):
        if column_names and not isinstance(column_names, list):
            raise TypeError("Expected argument 'column_names' to be a list")
        pulumi.set(__self__, "column_names", column_names)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if masking_column_groups and not isinstance(masking_column_groups, list):
            raise TypeError("Expected argument 'masking_column_groups' to be a list")
        pulumi.set(__self__, "masking_column_groups", masking_column_groups)
        if masking_report_id and not isinstance(masking_report_id, str):
            raise TypeError("Expected argument 'masking_report_id' to be a str")
        pulumi.set(__self__, "masking_report_id", masking_report_id)
        if object_types and not isinstance(object_types, list):
            raise TypeError("Expected argument 'object_types' to be a list")
        pulumi.set(__self__, "object_types", object_types)
        if objects and not isinstance(objects, list):
            raise TypeError("Expected argument 'objects' to be a list")
        pulumi.set(__self__, "objects", objects)
        if schema_names and not isinstance(schema_names, list):
            raise TypeError("Expected argument 'schema_names' to be a list")
        pulumi.set(__self__, "schema_names", schema_names)
        if sensitive_type_id and not isinstance(sensitive_type_id, str):
            raise TypeError("Expected argument 'sensitive_type_id' to be a str")
        pulumi.set(__self__, "sensitive_type_id", sensitive_type_id)

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[Sequence[builtins.str]]:
        """
        The name of the masked column.
        """
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetMaskingReportsMaskedColumnItemResult']:
        """
        An array of masking column summary objects.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="maskingColumnGroups")
    def masking_column_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        The masking group of the masked column.
        """
        return pulumi.get(self, "masking_column_groups")

    @property
    @pulumi.getter(name="maskingReportId")
    def masking_report_id(self) -> builtins.str:
        return pulumi.get(self, "masking_report_id")

    @property
    @pulumi.getter(name="objectTypes")
    def object_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The type of the object (table or editioning view) that contains the masked column.
        """
        return pulumi.get(self, "object_types")

    @property
    @pulumi.getter
    def objects(self) -> Optional[Sequence[builtins.str]]:
        """
        The name of the object (table or editioning view) that contains the masked column.
        """
        return pulumi.get(self, "objects")

    @property
    @pulumi.getter(name="schemaNames")
    def schema_names(self) -> Optional[Sequence[builtins.str]]:
        """
        The name of the schema that contains the masked column.
        """
        return pulumi.get(self, "schema_names")

    @property
    @pulumi.getter(name="sensitiveTypeId")
    def sensitive_type_id(self) -> Optional[builtins.str]:
        """
        The OCID of the sensitive type associated with the masked column.
        """
        return pulumi.get(self, "sensitive_type_id")


class AwaitableGetMaskingReportsMaskedColumnResult(GetMaskingReportsMaskedColumnResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMaskingReportsMaskedColumnResult(
            column_names=self.column_names,
            id=self.id,
            items=self.items,
            masking_column_groups=self.masking_column_groups,
            masking_report_id=self.masking_report_id,
            object_types=self.object_types,
            objects=self.objects,
            schema_names=self.schema_names,
            sensitive_type_id=self.sensitive_type_id)


def get_masking_reports_masked_column(column_names: Optional[Sequence[builtins.str]] = None,
                                      masking_column_groups: Optional[Sequence[builtins.str]] = None,
                                      masking_report_id: Optional[builtins.str] = None,
                                      object_types: Optional[Sequence[builtins.str]] = None,
                                      objects: Optional[Sequence[builtins.str]] = None,
                                      schema_names: Optional[Sequence[builtins.str]] = None,
                                      sensitive_type_id: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMaskingReportsMaskedColumnResult:
    """
    This data source provides details about a specific Masking Reports Masked Column resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of masked columns present in the specified masking report and based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_masking_reports_masked_column = oci.DataSafe.get_masking_reports_masked_column(masking_report_id=test_masking_report["id"],
        column_names=masking_reports_masked_column_column_name,
        masking_column_groups=masking_reports_masked_column_masking_column_group,
        objects=masking_reports_masked_column_object,
        object_types=masking_reports_masked_column_object_type,
        schema_names=masking_reports_masked_column_schema_name,
        sensitive_type_id=test_sensitive_type["id"])
    ```


    :param Sequence[builtins.str] column_names: A filter to return only a specific column based on column name.
    :param Sequence[builtins.str] masking_column_groups: A filter to return only the resources that match the specified masking column group.
    :param builtins.str masking_report_id: The OCID of the masking report.
    :param Sequence[builtins.str] object_types: A filter to return only items related to a specific object type.
    :param Sequence[builtins.str] objects: A filter to return only items related to a specific object name.
    :param Sequence[builtins.str] schema_names: A filter to return only items related to specific schema name.
    :param builtins.str sensitive_type_id: A filter to return only items related to a specific sensitive type OCID.
    """
    __args__ = dict()
    __args__['columnNames'] = column_names
    __args__['maskingColumnGroups'] = masking_column_groups
    __args__['maskingReportId'] = masking_report_id
    __args__['objectTypes'] = object_types
    __args__['objects'] = objects
    __args__['schemaNames'] = schema_names
    __args__['sensitiveTypeId'] = sensitive_type_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getMaskingReportsMaskedColumn:getMaskingReportsMaskedColumn', __args__, opts=opts, typ=GetMaskingReportsMaskedColumnResult).value

    return AwaitableGetMaskingReportsMaskedColumnResult(
        column_names=pulumi.get(__ret__, 'column_names'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        masking_column_groups=pulumi.get(__ret__, 'masking_column_groups'),
        masking_report_id=pulumi.get(__ret__, 'masking_report_id'),
        object_types=pulumi.get(__ret__, 'object_types'),
        objects=pulumi.get(__ret__, 'objects'),
        schema_names=pulumi.get(__ret__, 'schema_names'),
        sensitive_type_id=pulumi.get(__ret__, 'sensitive_type_id'))
def get_masking_reports_masked_column_output(column_names: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                             masking_column_groups: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                             masking_report_id: Optional[pulumi.Input[builtins.str]] = None,
                                             object_types: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                             objects: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                             schema_names: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                             sensitive_type_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMaskingReportsMaskedColumnResult]:
    """
    This data source provides details about a specific Masking Reports Masked Column resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of masked columns present in the specified masking report and based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_masking_reports_masked_column = oci.DataSafe.get_masking_reports_masked_column(masking_report_id=test_masking_report["id"],
        column_names=masking_reports_masked_column_column_name,
        masking_column_groups=masking_reports_masked_column_masking_column_group,
        objects=masking_reports_masked_column_object,
        object_types=masking_reports_masked_column_object_type,
        schema_names=masking_reports_masked_column_schema_name,
        sensitive_type_id=test_sensitive_type["id"])
    ```


    :param Sequence[builtins.str] column_names: A filter to return only a specific column based on column name.
    :param Sequence[builtins.str] masking_column_groups: A filter to return only the resources that match the specified masking column group.
    :param builtins.str masking_report_id: The OCID of the masking report.
    :param Sequence[builtins.str] object_types: A filter to return only items related to a specific object type.
    :param Sequence[builtins.str] objects: A filter to return only items related to a specific object name.
    :param Sequence[builtins.str] schema_names: A filter to return only items related to specific schema name.
    :param builtins.str sensitive_type_id: A filter to return only items related to a specific sensitive type OCID.
    """
    __args__ = dict()
    __args__['columnNames'] = column_names
    __args__['maskingColumnGroups'] = masking_column_groups
    __args__['maskingReportId'] = masking_report_id
    __args__['objectTypes'] = object_types
    __args__['objects'] = objects
    __args__['schemaNames'] = schema_names
    __args__['sensitiveTypeId'] = sensitive_type_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getMaskingReportsMaskedColumn:getMaskingReportsMaskedColumn', __args__, opts=opts, typ=GetMaskingReportsMaskedColumnResult)
    return __ret__.apply(lambda __response__: GetMaskingReportsMaskedColumnResult(
        column_names=pulumi.get(__response__, 'column_names'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        masking_column_groups=pulumi.get(__response__, 'masking_column_groups'),
        masking_report_id=pulumi.get(__response__, 'masking_report_id'),
        object_types=pulumi.get(__response__, 'object_types'),
        objects=pulumi.get(__response__, 'objects'),
        schema_names=pulumi.get(__response__, 'schema_names'),
        sensitive_type_id=pulumi.get(__response__, 'sensitive_type_id')))
