# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 job_configuration_details: pulumi.Input['JobJobConfigurationDetailsArgs'],
                 job_infrastructure_configuration_details: pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs'],
                 project_id: pulumi.Input[builtins.str],
                 artifact_content_disposition: Optional[pulumi.Input[builtins.str]] = None,
                 artifact_content_length: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 delete_related_job_runs: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 job_artifact: Optional[pulumi.Input[builtins.str]] = None,
                 job_environment_configuration_details: Optional[pulumi.Input['JobJobEnvironmentConfigurationDetailsArgs']] = None,
                 job_log_configuration_details: Optional[pulumi.Input['JobJobLogConfigurationDetailsArgs']] = None,
                 job_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        :param pulumi.Input['JobJobConfigurationDetailsArgs'] job_configuration_details: The job configuration details
        :param pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs'] job_infrastructure_configuration_details: (Updatable) The job infrastructure configuration details (shape, block storage, etc.)
        :param pulumi.Input[builtins.str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
        :param pulumi.Input[builtins.str] artifact_content_disposition: This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=job-artifact.py`
        :param pulumi.Input[builtins.str] artifact_content_length: The content length of the body.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.bool] delete_related_job_runs: (Updatable) Delete all related JobRuns upon deletion of the Job.
        :param pulumi.Input[builtins.str] description: (Updatable) A short description of the job.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] job_artifact: The job artifact to upload. This can be done in a separate step or from cli/sdk. The Job will remain in "Creating" state until its artifact is uploaded.
        :param pulumi.Input['JobJobEnvironmentConfigurationDetailsArgs'] job_environment_configuration_details: Environment configuration to capture job runtime dependencies.
        :param pulumi.Input['JobJobLogConfigurationDetailsArgs'] job_log_configuration_details: Logging configuration for resource.
        :param pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]] job_storage_mount_configuration_details_lists: (Updatable) Collection of JobStorageMountConfigurationDetails.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "job_configuration_details", job_configuration_details)
        pulumi.set(__self__, "job_infrastructure_configuration_details", job_infrastructure_configuration_details)
        pulumi.set(__self__, "project_id", project_id)
        if artifact_content_disposition is not None:
            pulumi.set(__self__, "artifact_content_disposition", artifact_content_disposition)
        if artifact_content_length is not None:
            pulumi.set(__self__, "artifact_content_length", artifact_content_length)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if delete_related_job_runs is not None:
            pulumi.set(__self__, "delete_related_job_runs", delete_related_job_runs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if job_artifact is not None:
            pulumi.set(__self__, "job_artifact", job_artifact)
        if job_environment_configuration_details is not None:
            pulumi.set(__self__, "job_environment_configuration_details", job_environment_configuration_details)
        if job_log_configuration_details is not None:
            pulumi.set(__self__, "job_log_configuration_details", job_log_configuration_details)
        if job_storage_mount_configuration_details_lists is not None:
            pulumi.set(__self__, "job_storage_mount_configuration_details_lists", job_storage_mount_configuration_details_lists)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="jobConfigurationDetails")
    def job_configuration_details(self) -> pulumi.Input['JobJobConfigurationDetailsArgs']:
        """
        The job configuration details
        """
        return pulumi.get(self, "job_configuration_details")

    @job_configuration_details.setter
    def job_configuration_details(self, value: pulumi.Input['JobJobConfigurationDetailsArgs']):
        pulumi.set(self, "job_configuration_details", value)

    @property
    @pulumi.getter(name="jobInfrastructureConfigurationDetails")
    def job_infrastructure_configuration_details(self) -> pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs']:
        """
        (Updatable) The job infrastructure configuration details (shape, block storage, etc.)
        """
        return pulumi.get(self, "job_infrastructure_configuration_details")

    @job_infrastructure_configuration_details.setter
    def job_infrastructure_configuration_details(self, value: pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs']):
        pulumi.set(self, "job_infrastructure_configuration_details", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="artifactContentDisposition")
    def artifact_content_disposition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=job-artifact.py`
        """
        return pulumi.get(self, "artifact_content_disposition")

    @artifact_content_disposition.setter
    def artifact_content_disposition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "artifact_content_disposition", value)

    @property
    @pulumi.getter(name="artifactContentLength")
    def artifact_content_length(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The content length of the body.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "artifact_content_length")

    @artifact_content_length.setter
    def artifact_content_length(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "artifact_content_length", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deleteRelatedJobRuns")
    def delete_related_job_runs(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Delete all related JobRuns upon deletion of the Job.
        """
        return pulumi.get(self, "delete_related_job_runs")

    @delete_related_job_runs.setter
    def delete_related_job_runs(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_related_job_runs", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A short description of the job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="jobArtifact")
    def job_artifact(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The job artifact to upload. This can be done in a separate step or from cli/sdk. The Job will remain in "Creating" state until its artifact is uploaded.
        """
        return pulumi.get(self, "job_artifact")

    @job_artifact.setter
    def job_artifact(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_artifact", value)

    @property
    @pulumi.getter(name="jobEnvironmentConfigurationDetails")
    def job_environment_configuration_details(self) -> Optional[pulumi.Input['JobJobEnvironmentConfigurationDetailsArgs']]:
        """
        Environment configuration to capture job runtime dependencies.
        """
        return pulumi.get(self, "job_environment_configuration_details")

    @job_environment_configuration_details.setter
    def job_environment_configuration_details(self, value: Optional[pulumi.Input['JobJobEnvironmentConfigurationDetailsArgs']]):
        pulumi.set(self, "job_environment_configuration_details", value)

    @property
    @pulumi.getter(name="jobLogConfigurationDetails")
    def job_log_configuration_details(self) -> Optional[pulumi.Input['JobJobLogConfigurationDetailsArgs']]:
        """
        Logging configuration for resource.
        """
        return pulumi.get(self, "job_log_configuration_details")

    @job_log_configuration_details.setter
    def job_log_configuration_details(self, value: Optional[pulumi.Input['JobJobLogConfigurationDetailsArgs']]):
        pulumi.set(self, "job_log_configuration_details", value)

    @property
    @pulumi.getter(name="jobStorageMountConfigurationDetailsLists")
    def job_storage_mount_configuration_details_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]]]:
        """
        (Updatable) Collection of JobStorageMountConfigurationDetails.
        """
        return pulumi.get(self, "job_storage_mount_configuration_details_lists")

    @job_storage_mount_configuration_details_lists.setter
    def job_storage_mount_configuration_details_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]]]):
        pulumi.set(self, "job_storage_mount_configuration_details_lists", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 artifact_content_disposition: Optional[pulumi.Input[builtins.str]] = None,
                 artifact_content_length: Optional[pulumi.Input[builtins.str]] = None,
                 artifact_content_md5: Optional[pulumi.Input[builtins.str]] = None,
                 artifact_last_modified: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 delete_related_job_runs: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 empty_artifact: Optional[pulumi.Input[builtins.bool]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 job_artifact: Optional[pulumi.Input[builtins.str]] = None,
                 job_configuration_details: Optional[pulumi.Input['JobJobConfigurationDetailsArgs']] = None,
                 job_environment_configuration_details: Optional[pulumi.Input['JobJobEnvironmentConfigurationDetailsArgs']] = None,
                 job_infrastructure_configuration_details: Optional[pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs']] = None,
                 job_log_configuration_details: Optional[pulumi.Input['JobJobLogConfigurationDetailsArgs']] = None,
                 job_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[builtins.str] artifact_content_disposition: This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=job-artifact.py`
        :param pulumi.Input[builtins.str] artifact_content_length: The content length of the body.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        :param pulumi.Input[builtins.str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the project.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.bool] delete_related_job_runs: (Updatable) Delete all related JobRuns upon deletion of the Job.
        :param pulumi.Input[builtins.str] description: (Updatable) A short description of the job.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] job_artifact: The job artifact to upload. This can be done in a separate step or from cli/sdk. The Job will remain in "Creating" state until its artifact is uploaded.
        :param pulumi.Input['JobJobConfigurationDetailsArgs'] job_configuration_details: The job configuration details
        :param pulumi.Input['JobJobEnvironmentConfigurationDetailsArgs'] job_environment_configuration_details: Environment configuration to capture job runtime dependencies.
        :param pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs'] job_infrastructure_configuration_details: (Updatable) The job infrastructure configuration details (shape, block storage, etc.)
        :param pulumi.Input['JobJobLogConfigurationDetailsArgs'] job_log_configuration_details: Logging configuration for resource.
        :param pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]] job_storage_mount_configuration_details_lists: (Updatable) Collection of JobStorageMountConfigurationDetails.
        :param pulumi.Input[builtins.str] lifecycle_details: The state of the job.
        :param pulumi.Input[builtins.str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
        :param pulumi.Input[builtins.str] state: The state of the job.
        :param pulumi.Input[builtins.str] time_created: The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2020-08-06T21:10:29.41Z
        """
        if artifact_content_disposition is not None:
            pulumi.set(__self__, "artifact_content_disposition", artifact_content_disposition)
        if artifact_content_length is not None:
            pulumi.set(__self__, "artifact_content_length", artifact_content_length)
        if artifact_content_md5 is not None:
            pulumi.set(__self__, "artifact_content_md5", artifact_content_md5)
        if artifact_last_modified is not None:
            pulumi.set(__self__, "artifact_last_modified", artifact_last_modified)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if delete_related_job_runs is not None:
            pulumi.set(__self__, "delete_related_job_runs", delete_related_job_runs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if empty_artifact is not None:
            pulumi.set(__self__, "empty_artifact", empty_artifact)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if job_artifact is not None:
            pulumi.set(__self__, "job_artifact", job_artifact)
        if job_configuration_details is not None:
            pulumi.set(__self__, "job_configuration_details", job_configuration_details)
        if job_environment_configuration_details is not None:
            pulumi.set(__self__, "job_environment_configuration_details", job_environment_configuration_details)
        if job_infrastructure_configuration_details is not None:
            pulumi.set(__self__, "job_infrastructure_configuration_details", job_infrastructure_configuration_details)
        if job_log_configuration_details is not None:
            pulumi.set(__self__, "job_log_configuration_details", job_log_configuration_details)
        if job_storage_mount_configuration_details_lists is not None:
            pulumi.set(__self__, "job_storage_mount_configuration_details_lists", job_storage_mount_configuration_details_lists)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="artifactContentDisposition")
    def artifact_content_disposition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=job-artifact.py`
        """
        return pulumi.get(self, "artifact_content_disposition")

    @artifact_content_disposition.setter
    def artifact_content_disposition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "artifact_content_disposition", value)

    @property
    @pulumi.getter(name="artifactContentLength")
    def artifact_content_length(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The content length of the body.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "artifact_content_length")

    @artifact_content_length.setter
    def artifact_content_length(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "artifact_content_length", value)

    @property
    @pulumi.getter(name="artifactContentMd5")
    def artifact_content_md5(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "artifact_content_md5")

    @artifact_content_md5.setter
    def artifact_content_md5(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "artifact_content_md5", value)

    @property
    @pulumi.getter(name="artifactLastModified")
    def artifact_last_modified(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "artifact_last_modified")

    @artifact_last_modified.setter
    def artifact_last_modified(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "artifact_last_modified", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the project.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deleteRelatedJobRuns")
    def delete_related_job_runs(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Delete all related JobRuns upon deletion of the Job.
        """
        return pulumi.get(self, "delete_related_job_runs")

    @delete_related_job_runs.setter
    def delete_related_job_runs(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_related_job_runs", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A short description of the job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="emptyArtifact")
    def empty_artifact(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "empty_artifact")

    @empty_artifact.setter
    def empty_artifact(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "empty_artifact", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="jobArtifact")
    def job_artifact(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The job artifact to upload. This can be done in a separate step or from cli/sdk. The Job will remain in "Creating" state until its artifact is uploaded.
        """
        return pulumi.get(self, "job_artifact")

    @job_artifact.setter
    def job_artifact(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_artifact", value)

    @property
    @pulumi.getter(name="jobConfigurationDetails")
    def job_configuration_details(self) -> Optional[pulumi.Input['JobJobConfigurationDetailsArgs']]:
        """
        The job configuration details
        """
        return pulumi.get(self, "job_configuration_details")

    @job_configuration_details.setter
    def job_configuration_details(self, value: Optional[pulumi.Input['JobJobConfigurationDetailsArgs']]):
        pulumi.set(self, "job_configuration_details", value)

    @property
    @pulumi.getter(name="jobEnvironmentConfigurationDetails")
    def job_environment_configuration_details(self) -> Optional[pulumi.Input['JobJobEnvironmentConfigurationDetailsArgs']]:
        """
        Environment configuration to capture job runtime dependencies.
        """
        return pulumi.get(self, "job_environment_configuration_details")

    @job_environment_configuration_details.setter
    def job_environment_configuration_details(self, value: Optional[pulumi.Input['JobJobEnvironmentConfigurationDetailsArgs']]):
        pulumi.set(self, "job_environment_configuration_details", value)

    @property
    @pulumi.getter(name="jobInfrastructureConfigurationDetails")
    def job_infrastructure_configuration_details(self) -> Optional[pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs']]:
        """
        (Updatable) The job infrastructure configuration details (shape, block storage, etc.)
        """
        return pulumi.get(self, "job_infrastructure_configuration_details")

    @job_infrastructure_configuration_details.setter
    def job_infrastructure_configuration_details(self, value: Optional[pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs']]):
        pulumi.set(self, "job_infrastructure_configuration_details", value)

    @property
    @pulumi.getter(name="jobLogConfigurationDetails")
    def job_log_configuration_details(self) -> Optional[pulumi.Input['JobJobLogConfigurationDetailsArgs']]:
        """
        Logging configuration for resource.
        """
        return pulumi.get(self, "job_log_configuration_details")

    @job_log_configuration_details.setter
    def job_log_configuration_details(self, value: Optional[pulumi.Input['JobJobLogConfigurationDetailsArgs']]):
        pulumi.set(self, "job_log_configuration_details", value)

    @property
    @pulumi.getter(name="jobStorageMountConfigurationDetailsLists")
    def job_storage_mount_configuration_details_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]]]:
        """
        (Updatable) Collection of JobStorageMountConfigurationDetails.
        """
        return pulumi.get(self, "job_storage_mount_configuration_details_lists")

    @job_storage_mount_configuration_details_lists.setter
    def job_storage_mount_configuration_details_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]]]):
        pulumi.set(self, "job_storage_mount_configuration_details_lists", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the job.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the job.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2020-08-06T21:10:29.41Z
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)


@pulumi.type_token("oci:DataScience/job:Job")
class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_content_disposition: Optional[pulumi.Input[builtins.str]] = None,
                 artifact_content_length: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 delete_related_job_runs: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 job_artifact: Optional[pulumi.Input[builtins.str]] = None,
                 job_configuration_details: Optional[pulumi.Input[Union['JobJobConfigurationDetailsArgs', 'JobJobConfigurationDetailsArgsDict']]] = None,
                 job_environment_configuration_details: Optional[pulumi.Input[Union['JobJobEnvironmentConfigurationDetailsArgs', 'JobJobEnvironmentConfigurationDetailsArgsDict']]] = None,
                 job_infrastructure_configuration_details: Optional[pulumi.Input[Union['JobJobInfrastructureConfigurationDetailsArgs', 'JobJobInfrastructureConfigurationDetailsArgsDict']]] = None,
                 job_log_configuration_details: Optional[pulumi.Input[Union['JobJobLogConfigurationDetailsArgs', 'JobJobLogConfigurationDetailsArgsDict']]] = None,
                 job_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobJobStorageMountConfigurationDetailsListArgs', 'JobJobStorageMountConfigurationDetailsListArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Job resource in Oracle Cloud Infrastructure Data Science service.

        Creates a job.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_job = oci.data_science.Job("test_job",
            compartment_id=compartment_id,
            job_configuration_details={
                "job_type": job_job_configuration_details_job_type,
                "command_line_arguments": job_job_configuration_details_command_line_arguments,
                "environment_variables": job_job_configuration_details_environment_variables,
                "maximum_runtime_in_minutes": job_job_configuration_details_maximum_runtime_in_minutes,
            },
            job_infrastructure_configuration_details={
                "block_storage_size_in_gbs": job_job_infrastructure_configuration_details_block_storage_size_in_gbs,
                "job_infrastructure_type": job_job_infrastructure_configuration_details_job_infrastructure_type,
                "shape_name": test_shape["name"],
                "job_shape_config_details": {
                    "memory_in_gbs": job_job_infrastructure_configuration_details_job_shape_config_details_memory_in_gbs,
                    "ocpus": job_job_infrastructure_configuration_details_job_shape_config_details_ocpus,
                },
                "subnet_id": test_subnet["id"],
            },
            project_id=test_project["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=job_description,
            display_name=job_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            job_environment_configuration_details={
                "image": job_job_environment_configuration_details_image,
                "job_environment_type": job_job_environment_configuration_details_job_environment_type,
                "cmds": job_job_environment_configuration_details_cmd,
                "entrypoints": job_job_environment_configuration_details_entrypoint,
                "image_digest": job_job_environment_configuration_details_image_digest,
                "image_signature_id": test_image_signature["id"],
            },
            job_log_configuration_details={
                "enable_auto_log_creation": job_job_log_configuration_details_enable_auto_log_creation,
                "enable_logging": job_job_log_configuration_details_enable_logging,
                "log_group_id": test_log_group["id"],
                "log_id": test_log["id"],
            },
            job_storage_mount_configuration_details_lists=[{
                "destination_directory_name": job_job_storage_mount_configuration_details_list_destination_directory_name,
                "storage_type": job_job_storage_mount_configuration_details_list_storage_type,
                "bucket": job_job_storage_mount_configuration_details_list_bucket,
                "destination_path": job_job_storage_mount_configuration_details_list_destination_path,
                "export_id": test_export["id"],
                "mount_target_id": test_mount_target["id"],
                "namespace": job_job_storage_mount_configuration_details_list_namespace,
                "prefix": job_job_storage_mount_configuration_details_list_prefix,
            }])
        ```

        ## Import

        Jobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/job:Job test_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] artifact_content_disposition: This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=job-artifact.py`
        :param pulumi.Input[builtins.str] artifact_content_length: The content length of the body.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.bool] delete_related_job_runs: (Updatable) Delete all related JobRuns upon deletion of the Job.
        :param pulumi.Input[builtins.str] description: (Updatable) A short description of the job.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] job_artifact: The job artifact to upload. This can be done in a separate step or from cli/sdk. The Job will remain in "Creating" state until its artifact is uploaded.
        :param pulumi.Input[Union['JobJobConfigurationDetailsArgs', 'JobJobConfigurationDetailsArgsDict']] job_configuration_details: The job configuration details
        :param pulumi.Input[Union['JobJobEnvironmentConfigurationDetailsArgs', 'JobJobEnvironmentConfigurationDetailsArgsDict']] job_environment_configuration_details: Environment configuration to capture job runtime dependencies.
        :param pulumi.Input[Union['JobJobInfrastructureConfigurationDetailsArgs', 'JobJobInfrastructureConfigurationDetailsArgsDict']] job_infrastructure_configuration_details: (Updatable) The job infrastructure configuration details (shape, block storage, etc.)
        :param pulumi.Input[Union['JobJobLogConfigurationDetailsArgs', 'JobJobLogConfigurationDetailsArgsDict']] job_log_configuration_details: Logging configuration for resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobJobStorageMountConfigurationDetailsListArgs', 'JobJobStorageMountConfigurationDetailsListArgsDict']]]] job_storage_mount_configuration_details_lists: (Updatable) Collection of JobStorageMountConfigurationDetails.
        :param pulumi.Input[builtins.str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Job resource in Oracle Cloud Infrastructure Data Science service.

        Creates a job.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_job = oci.data_science.Job("test_job",
            compartment_id=compartment_id,
            job_configuration_details={
                "job_type": job_job_configuration_details_job_type,
                "command_line_arguments": job_job_configuration_details_command_line_arguments,
                "environment_variables": job_job_configuration_details_environment_variables,
                "maximum_runtime_in_minutes": job_job_configuration_details_maximum_runtime_in_minutes,
            },
            job_infrastructure_configuration_details={
                "block_storage_size_in_gbs": job_job_infrastructure_configuration_details_block_storage_size_in_gbs,
                "job_infrastructure_type": job_job_infrastructure_configuration_details_job_infrastructure_type,
                "shape_name": test_shape["name"],
                "job_shape_config_details": {
                    "memory_in_gbs": job_job_infrastructure_configuration_details_job_shape_config_details_memory_in_gbs,
                    "ocpus": job_job_infrastructure_configuration_details_job_shape_config_details_ocpus,
                },
                "subnet_id": test_subnet["id"],
            },
            project_id=test_project["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=job_description,
            display_name=job_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            job_environment_configuration_details={
                "image": job_job_environment_configuration_details_image,
                "job_environment_type": job_job_environment_configuration_details_job_environment_type,
                "cmds": job_job_environment_configuration_details_cmd,
                "entrypoints": job_job_environment_configuration_details_entrypoint,
                "image_digest": job_job_environment_configuration_details_image_digest,
                "image_signature_id": test_image_signature["id"],
            },
            job_log_configuration_details={
                "enable_auto_log_creation": job_job_log_configuration_details_enable_auto_log_creation,
                "enable_logging": job_job_log_configuration_details_enable_logging,
                "log_group_id": test_log_group["id"],
                "log_id": test_log["id"],
            },
            job_storage_mount_configuration_details_lists=[{
                "destination_directory_name": job_job_storage_mount_configuration_details_list_destination_directory_name,
                "storage_type": job_job_storage_mount_configuration_details_list_storage_type,
                "bucket": job_job_storage_mount_configuration_details_list_bucket,
                "destination_path": job_job_storage_mount_configuration_details_list_destination_path,
                "export_id": test_export["id"],
                "mount_target_id": test_mount_target["id"],
                "namespace": job_job_storage_mount_configuration_details_list_namespace,
                "prefix": job_job_storage_mount_configuration_details_list_prefix,
            }])
        ```

        ## Import

        Jobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/job:Job test_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_content_disposition: Optional[pulumi.Input[builtins.str]] = None,
                 artifact_content_length: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 delete_related_job_runs: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 job_artifact: Optional[pulumi.Input[builtins.str]] = None,
                 job_configuration_details: Optional[pulumi.Input[Union['JobJobConfigurationDetailsArgs', 'JobJobConfigurationDetailsArgsDict']]] = None,
                 job_environment_configuration_details: Optional[pulumi.Input[Union['JobJobEnvironmentConfigurationDetailsArgs', 'JobJobEnvironmentConfigurationDetailsArgsDict']]] = None,
                 job_infrastructure_configuration_details: Optional[pulumi.Input[Union['JobJobInfrastructureConfigurationDetailsArgs', 'JobJobInfrastructureConfigurationDetailsArgsDict']]] = None,
                 job_log_configuration_details: Optional[pulumi.Input[Union['JobJobLogConfigurationDetailsArgs', 'JobJobLogConfigurationDetailsArgsDict']]] = None,
                 job_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobJobStorageMountConfigurationDetailsListArgs', 'JobJobStorageMountConfigurationDetailsListArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["artifact_content_disposition"] = artifact_content_disposition
            __props__.__dict__["artifact_content_length"] = artifact_content_length
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["delete_related_job_runs"] = delete_related_job_runs
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["job_artifact"] = job_artifact
            if job_configuration_details is None and not opts.urn:
                raise TypeError("Missing required property 'job_configuration_details'")
            __props__.__dict__["job_configuration_details"] = job_configuration_details
            __props__.__dict__["job_environment_configuration_details"] = job_environment_configuration_details
            if job_infrastructure_configuration_details is None and not opts.urn:
                raise TypeError("Missing required property 'job_infrastructure_configuration_details'")
            __props__.__dict__["job_infrastructure_configuration_details"] = job_infrastructure_configuration_details
            __props__.__dict__["job_log_configuration_details"] = job_log_configuration_details
            __props__.__dict__["job_storage_mount_configuration_details_lists"] = job_storage_mount_configuration_details_lists
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["artifact_content_md5"] = None
            __props__.__dict__["artifact_last_modified"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["empty_artifact"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(Job, __self__).__init__(
            'oci:DataScience/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            artifact_content_disposition: Optional[pulumi.Input[builtins.str]] = None,
            artifact_content_length: Optional[pulumi.Input[builtins.str]] = None,
            artifact_content_md5: Optional[pulumi.Input[builtins.str]] = None,
            artifact_last_modified: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            created_by: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            delete_related_job_runs: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            empty_artifact: Optional[pulumi.Input[builtins.bool]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            job_artifact: Optional[pulumi.Input[builtins.str]] = None,
            job_configuration_details: Optional[pulumi.Input[Union['JobJobConfigurationDetailsArgs', 'JobJobConfigurationDetailsArgsDict']]] = None,
            job_environment_configuration_details: Optional[pulumi.Input[Union['JobJobEnvironmentConfigurationDetailsArgs', 'JobJobEnvironmentConfigurationDetailsArgsDict']]] = None,
            job_infrastructure_configuration_details: Optional[pulumi.Input[Union['JobJobInfrastructureConfigurationDetailsArgs', 'JobJobInfrastructureConfigurationDetailsArgsDict']]] = None,
            job_log_configuration_details: Optional[pulumi.Input[Union['JobJobLogConfigurationDetailsArgs', 'JobJobLogConfigurationDetailsArgsDict']]] = None,
            job_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobJobStorageMountConfigurationDetailsListArgs', 'JobJobStorageMountConfigurationDetailsListArgsDict']]]]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] artifact_content_disposition: This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=job-artifact.py`
        :param pulumi.Input[builtins.str] artifact_content_length: The content length of the body.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        :param pulumi.Input[builtins.str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the project.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.bool] delete_related_job_runs: (Updatable) Delete all related JobRuns upon deletion of the Job.
        :param pulumi.Input[builtins.str] description: (Updatable) A short description of the job.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] job_artifact: The job artifact to upload. This can be done in a separate step or from cli/sdk. The Job will remain in "Creating" state until its artifact is uploaded.
        :param pulumi.Input[Union['JobJobConfigurationDetailsArgs', 'JobJobConfigurationDetailsArgsDict']] job_configuration_details: The job configuration details
        :param pulumi.Input[Union['JobJobEnvironmentConfigurationDetailsArgs', 'JobJobEnvironmentConfigurationDetailsArgsDict']] job_environment_configuration_details: Environment configuration to capture job runtime dependencies.
        :param pulumi.Input[Union['JobJobInfrastructureConfigurationDetailsArgs', 'JobJobInfrastructureConfigurationDetailsArgsDict']] job_infrastructure_configuration_details: (Updatable) The job infrastructure configuration details (shape, block storage, etc.)
        :param pulumi.Input[Union['JobJobLogConfigurationDetailsArgs', 'JobJobLogConfigurationDetailsArgsDict']] job_log_configuration_details: Logging configuration for resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobJobStorageMountConfigurationDetailsListArgs', 'JobJobStorageMountConfigurationDetailsListArgsDict']]]] job_storage_mount_configuration_details_lists: (Updatable) Collection of JobStorageMountConfigurationDetails.
        :param pulumi.Input[builtins.str] lifecycle_details: The state of the job.
        :param pulumi.Input[builtins.str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
        :param pulumi.Input[builtins.str] state: The state of the job.
        :param pulumi.Input[builtins.str] time_created: The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2020-08-06T21:10:29.41Z
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["artifact_content_disposition"] = artifact_content_disposition
        __props__.__dict__["artifact_content_length"] = artifact_content_length
        __props__.__dict__["artifact_content_md5"] = artifact_content_md5
        __props__.__dict__["artifact_last_modified"] = artifact_last_modified
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["delete_related_job_runs"] = delete_related_job_runs
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["empty_artifact"] = empty_artifact
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["job_artifact"] = job_artifact
        __props__.__dict__["job_configuration_details"] = job_configuration_details
        __props__.__dict__["job_environment_configuration_details"] = job_environment_configuration_details
        __props__.__dict__["job_infrastructure_configuration_details"] = job_infrastructure_configuration_details
        __props__.__dict__["job_log_configuration_details"] = job_log_configuration_details
        __props__.__dict__["job_storage_mount_configuration_details_lists"] = job_storage_mount_configuration_details_lists
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="artifactContentDisposition")
    def artifact_content_disposition(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=job-artifact.py`
        """
        return pulumi.get(self, "artifact_content_disposition")

    @property
    @pulumi.getter(name="artifactContentLength")
    def artifact_content_length(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The content length of the body.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "artifact_content_length")

    @property
    @pulumi.getter(name="artifactContentMd5")
    def artifact_content_md5(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "artifact_content_md5")

    @property
    @pulumi.getter(name="artifactLastModified")
    def artifact_last_modified(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "artifact_last_modified")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the project.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deleteRelatedJobRuns")
    def delete_related_job_runs(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        (Updatable) Delete all related JobRuns upon deletion of the Job.
        """
        return pulumi.get(self, "delete_related_job_runs")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A short description of the job.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="emptyArtifact")
    def empty_artifact(self) -> pulumi.Output[builtins.bool]:
        return pulumi.get(self, "empty_artifact")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="jobArtifact")
    def job_artifact(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The job artifact to upload. This can be done in a separate step or from cli/sdk. The Job will remain in "Creating" state until its artifact is uploaded.
        """
        return pulumi.get(self, "job_artifact")

    @property
    @pulumi.getter(name="jobConfigurationDetails")
    def job_configuration_details(self) -> pulumi.Output['outputs.JobJobConfigurationDetails']:
        """
        The job configuration details
        """
        return pulumi.get(self, "job_configuration_details")

    @property
    @pulumi.getter(name="jobEnvironmentConfigurationDetails")
    def job_environment_configuration_details(self) -> pulumi.Output['outputs.JobJobEnvironmentConfigurationDetails']:
        """
        Environment configuration to capture job runtime dependencies.
        """
        return pulumi.get(self, "job_environment_configuration_details")

    @property
    @pulumi.getter(name="jobInfrastructureConfigurationDetails")
    def job_infrastructure_configuration_details(self) -> pulumi.Output['outputs.JobJobInfrastructureConfigurationDetails']:
        """
        (Updatable) The job infrastructure configuration details (shape, block storage, etc.)
        """
        return pulumi.get(self, "job_infrastructure_configuration_details")

    @property
    @pulumi.getter(name="jobLogConfigurationDetails")
    def job_log_configuration_details(self) -> pulumi.Output['outputs.JobJobLogConfigurationDetails']:
        """
        Logging configuration for resource.
        """
        return pulumi.get(self, "job_log_configuration_details")

    @property
    @pulumi.getter(name="jobStorageMountConfigurationDetailsLists")
    def job_storage_mount_configuration_details_lists(self) -> pulumi.Output[Sequence['outputs.JobJobStorageMountConfigurationDetailsList']]:
        """
        (Updatable) Collection of JobStorageMountConfigurationDetails.
        """
        return pulumi.get(self, "job_storage_mount_configuration_details_lists")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        The state of the job.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The state of the job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2020-08-06T21:10:29.41Z
        """
        return pulumi.get(self, "time_created")

