# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VulnerabilityScanArgs', 'VulnerabilityScan']

@pulumi.input_type
class VulnerabilityScanArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 vulnerability_scan_type: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a VulnerabilityScan resource.
        :param pulumi.Input[builtins.str] compartment_id: Compartment Identifier
        :param pulumi.Input[builtins.str] vulnerability_scan_type: Vulnerability Scan type is CVE, PATCH or IMAGE_PATCH
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "vulnerability_scan_type", vulnerability_scan_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="vulnerabilityScanType")
    def vulnerability_scan_type(self) -> pulumi.Input[builtins.str]:
        """
        Vulnerability Scan type is CVE, PATCH or IMAGE_PATCH


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vulnerability_scan_type")

    @vulnerability_scan_type.setter
    def vulnerability_scan_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vulnerability_scan_type", value)


@pulumi.input_type
class _VulnerabilityScanState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_ended: Optional[pulumi.Input[builtins.str]] = None,
                 vulnerability_scan_message: Optional[pulumi.Input[builtins.str]] = None,
                 vulnerability_scan_status: Optional[pulumi.Input[builtins.str]] = None,
                 vulnerability_scan_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering VulnerabilityScan resources.
        :param pulumi.Input[builtins.str] compartment_id: Compartment Identifier
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: A user-friendly name. It does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] state: The current state of the VulnerabilityScan.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the VulnerabilityScan was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_ended: The date and time the VulnerabilityScan was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] vulnerability_scan_message: The message of the vulnerability scan status.
        :param pulumi.Input[builtins.str] vulnerability_scan_status: The status of the vulnerability scan.
        :param pulumi.Input[builtins.str] vulnerability_scan_type: Vulnerability Scan type is CVE, PATCH or IMAGE_PATCH
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_ended is not None:
            pulumi.set(__self__, "time_ended", time_ended)
        if vulnerability_scan_message is not None:
            pulumi.set(__self__, "vulnerability_scan_message", vulnerability_scan_message)
        if vulnerability_scan_status is not None:
            pulumi.set(__self__, "vulnerability_scan_status", vulnerability_scan_status)
        if vulnerability_scan_type is not None:
            pulumi.set(__self__, "vulnerability_scan_type", vulnerability_scan_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-friendly name. It does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the VulnerabilityScan.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the VulnerabilityScan was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the VulnerabilityScan was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_ended")

    @time_ended.setter
    def time_ended(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_ended", value)

    @property
    @pulumi.getter(name="vulnerabilityScanMessage")
    def vulnerability_scan_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The message of the vulnerability scan status.
        """
        return pulumi.get(self, "vulnerability_scan_message")

    @vulnerability_scan_message.setter
    def vulnerability_scan_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vulnerability_scan_message", value)

    @property
    @pulumi.getter(name="vulnerabilityScanStatus")
    def vulnerability_scan_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the vulnerability scan.
        """
        return pulumi.get(self, "vulnerability_scan_status")

    @vulnerability_scan_status.setter
    def vulnerability_scan_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vulnerability_scan_status", value)

    @property
    @pulumi.getter(name="vulnerabilityScanType")
    def vulnerability_scan_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Vulnerability Scan type is CVE, PATCH or IMAGE_PATCH


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vulnerability_scan_type")

    @vulnerability_scan_type.setter
    def vulnerability_scan_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vulnerability_scan_type", value)


@pulumi.type_token("oci:Dblm/vulnerabilityScan:VulnerabilityScan")
class VulnerabilityScan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 vulnerability_scan_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Vulnerability Scan resource in Oracle Cloud Infrastructure Dblm service.

        Creates a VulnerabilityScan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vulnerability_scan = oci.dblm.VulnerabilityScan("test_vulnerability_scan",
            compartment_id=compartment_id,
            vulnerability_scan_type=vulnerability_scan_vulnerability_scan_type)
        ```

        ## Import

        VulnerabilityScans can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Dblm/vulnerabilityScan:VulnerabilityScan test_vulnerability_scan "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: Compartment Identifier
        :param pulumi.Input[builtins.str] vulnerability_scan_type: Vulnerability Scan type is CVE, PATCH or IMAGE_PATCH
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VulnerabilityScanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Vulnerability Scan resource in Oracle Cloud Infrastructure Dblm service.

        Creates a VulnerabilityScan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vulnerability_scan = oci.dblm.VulnerabilityScan("test_vulnerability_scan",
            compartment_id=compartment_id,
            vulnerability_scan_type=vulnerability_scan_vulnerability_scan_type)
        ```

        ## Import

        VulnerabilityScans can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Dblm/vulnerabilityScan:VulnerabilityScan test_vulnerability_scan "id"
        ```

        :param str resource_name: The name of the resource.
        :param VulnerabilityScanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VulnerabilityScanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 vulnerability_scan_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VulnerabilityScanArgs.__new__(VulnerabilityScanArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if vulnerability_scan_type is None and not opts.urn:
                raise TypeError("Missing required property 'vulnerability_scan_type'")
            __props__.__dict__["vulnerability_scan_type"] = vulnerability_scan_type
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_ended"] = None
            __props__.__dict__["vulnerability_scan_message"] = None
            __props__.__dict__["vulnerability_scan_status"] = None
        super(VulnerabilityScan, __self__).__init__(
            'oci:Dblm/vulnerabilityScan:VulnerabilityScan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_ended: Optional[pulumi.Input[builtins.str]] = None,
            vulnerability_scan_message: Optional[pulumi.Input[builtins.str]] = None,
            vulnerability_scan_status: Optional[pulumi.Input[builtins.str]] = None,
            vulnerability_scan_type: Optional[pulumi.Input[builtins.str]] = None) -> 'VulnerabilityScan':
        """
        Get an existing VulnerabilityScan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: Compartment Identifier
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: A user-friendly name. It does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] state: The current state of the VulnerabilityScan.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the VulnerabilityScan was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_ended: The date and time the VulnerabilityScan was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] vulnerability_scan_message: The message of the vulnerability scan status.
        :param pulumi.Input[builtins.str] vulnerability_scan_status: The status of the vulnerability scan.
        :param pulumi.Input[builtins.str] vulnerability_scan_type: Vulnerability Scan type is CVE, PATCH or IMAGE_PATCH
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VulnerabilityScanState.__new__(_VulnerabilityScanState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_ended"] = time_ended
        __props__.__dict__["vulnerability_scan_message"] = vulnerability_scan_message
        __props__.__dict__["vulnerability_scan_status"] = vulnerability_scan_status
        __props__.__dict__["vulnerability_scan_type"] = vulnerability_scan_type
        return VulnerabilityScan(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        A user-friendly name. It does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the VulnerabilityScan.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the VulnerabilityScan was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the VulnerabilityScan was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="vulnerabilityScanMessage")
    def vulnerability_scan_message(self) -> pulumi.Output[builtins.str]:
        """
        The message of the vulnerability scan status.
        """
        return pulumi.get(self, "vulnerability_scan_message")

    @property
    @pulumi.getter(name="vulnerabilityScanStatus")
    def vulnerability_scan_status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the vulnerability scan.
        """
        return pulumi.get(self, "vulnerability_scan_status")

    @property
    @pulumi.getter(name="vulnerabilityScanType")
    def vulnerability_scan_type(self) -> pulumi.Output[builtins.str]:
        """
        Vulnerability Scan type is CVE, PATCH or IMAGE_PATCH


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vulnerability_scan_type")

