# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OccDemandSignalArgs', 'OccDemandSignal']

@pulumi.input_type
class OccDemandSignalArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 is_active: pulumi.Input[builtins.bool],
                 occ_demand_signals: pulumi.Input[Sequence[pulumi.Input['OccDemandSignalOccDemandSignalArgs']]],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 occ_demand_signal_id: Optional[pulumi.Input[builtins.str]] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input['OccDemandSignalPatchOperationArgs']]]] = None):
        """
        The set of arguments for constructing a OccDemandSignal resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the OccDemandSignal in.
        :param pulumi.Input[builtins.bool] is_active: (Updatable) Indicator of whether to share the data with Oracle.
        :param pulumi.Input[Sequence[pulumi.Input['OccDemandSignalOccDemandSignalArgs']]] occ_demand_signals: The OccDemandSignal data.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['OccDemandSignalPatchOperationArgs']]] patch_operations: (Updatable)
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "is_active", is_active)
        pulumi.set(__self__, "occ_demand_signals", occ_demand_signals)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if occ_demand_signal_id is not None:
            pulumi.set(__self__, "occ_demand_signal_id", occ_demand_signal_id)
        if patch_operations is not None:
            pulumi.set(__self__, "patch_operations", patch_operations)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the OccDemandSignal in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> pulumi.Input[builtins.bool]:
        """
        (Updatable) Indicator of whether to share the data with Oracle.
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter(name="occDemandSignals")
    def occ_demand_signals(self) -> pulumi.Input[Sequence[pulumi.Input['OccDemandSignalOccDemandSignalArgs']]]:
        """
        The OccDemandSignal data.
        """
        return pulumi.get(self, "occ_demand_signals")

    @occ_demand_signals.setter
    def occ_demand_signals(self, value: pulumi.Input[Sequence[pulumi.Input['OccDemandSignalOccDemandSignalArgs']]]):
        pulumi.set(self, "occ_demand_signals", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="occDemandSignalId")
    def occ_demand_signal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "occ_demand_signal_id")

    @occ_demand_signal_id.setter
    def occ_demand_signal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "occ_demand_signal_id", value)

    @property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OccDemandSignalPatchOperationArgs']]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @patch_operations.setter
    def patch_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OccDemandSignalPatchOperationArgs']]]]):
        pulumi.set(self, "patch_operations", value)


@pulumi.input_type
class _OccDemandSignalState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_active: Optional[pulumi.Input[builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 occ_demand_signal_id: Optional[pulumi.Input[builtins.str]] = None,
                 occ_demand_signals: Optional[pulumi.Input[Sequence[pulumi.Input['OccDemandSignalOccDemandSignalArgs']]]] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input['OccDemandSignalPatchOperationArgs']]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering OccDemandSignal resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the OccDemandSignal in.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_active: (Updatable) Indicator of whether to share the data with Oracle.
        :param pulumi.Input[builtins.str] lifecycle_details: A message that describes the current state of the OccDemandSignal in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[Sequence[pulumi.Input['OccDemandSignalOccDemandSignalArgs']]] occ_demand_signals: The OccDemandSignal data.
        :param pulumi.Input[Sequence[pulumi.Input['OccDemandSignalPatchOperationArgs']]] patch_operations: (Updatable)
        :param pulumi.Input[builtins.str] state: The current state of the OccDemandSignal.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the OccDemandSignal was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_updated: The date and time the OccDemandSignal was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if occ_demand_signal_id is not None:
            pulumi.set(__self__, "occ_demand_signal_id", occ_demand_signal_id)
        if occ_demand_signals is not None:
            pulumi.set(__self__, "occ_demand_signals", occ_demand_signals)
        if patch_operations is not None:
            pulumi.set(__self__, "patch_operations", patch_operations)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the OccDemandSignal in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Indicator of whether to share the data with Oracle.
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message that describes the current state of the OccDemandSignal in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="occDemandSignalId")
    def occ_demand_signal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "occ_demand_signal_id")

    @occ_demand_signal_id.setter
    def occ_demand_signal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "occ_demand_signal_id", value)

    @property
    @pulumi.getter(name="occDemandSignals")
    def occ_demand_signals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OccDemandSignalOccDemandSignalArgs']]]]:
        """
        The OccDemandSignal data.
        """
        return pulumi.get(self, "occ_demand_signals")

    @occ_demand_signals.setter
    def occ_demand_signals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OccDemandSignalOccDemandSignalArgs']]]]):
        pulumi.set(self, "occ_demand_signals", value)

    @property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OccDemandSignalPatchOperationArgs']]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @patch_operations.setter
    def patch_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OccDemandSignalPatchOperationArgs']]]]):
        pulumi.set(self, "patch_operations", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the OccDemandSignal.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the OccDemandSignal was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the OccDemandSignal was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:DemandSignal/occDemandSignal:OccDemandSignal")
class OccDemandSignal(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_active: Optional[pulumi.Input[builtins.bool]] = None,
                 occ_demand_signal_id: Optional[pulumi.Input[builtins.str]] = None,
                 occ_demand_signals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OccDemandSignalOccDemandSignalArgs', 'OccDemandSignalOccDemandSignalArgsDict']]]]] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OccDemandSignalPatchOperationArgs', 'OccDemandSignalPatchOperationArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource provides the Occ Demand Signal resource in Oracle Cloud Infrastructure Demand Signal service.

        Creates a OccDemandSignal.

          Updates the data of an OccDemandSignal.

        ## Import

        OccDemandSignals can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DemandSignal/occDemandSignal:OccDemandSignal test_occ_demand_signal "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the OccDemandSignal in.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_active: (Updatable) Indicator of whether to share the data with Oracle.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OccDemandSignalOccDemandSignalArgs', 'OccDemandSignalOccDemandSignalArgsDict']]]] occ_demand_signals: The OccDemandSignal data.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OccDemandSignalPatchOperationArgs', 'OccDemandSignalPatchOperationArgsDict']]]] patch_operations: (Updatable)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OccDemandSignalArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Occ Demand Signal resource in Oracle Cloud Infrastructure Demand Signal service.

        Creates a OccDemandSignal.

          Updates the data of an OccDemandSignal.

        ## Import

        OccDemandSignals can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DemandSignal/occDemandSignal:OccDemandSignal test_occ_demand_signal "id"
        ```

        :param str resource_name: The name of the resource.
        :param OccDemandSignalArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OccDemandSignalArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_active: Optional[pulumi.Input[builtins.bool]] = None,
                 occ_demand_signal_id: Optional[pulumi.Input[builtins.str]] = None,
                 occ_demand_signals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OccDemandSignalOccDemandSignalArgs', 'OccDemandSignalOccDemandSignalArgsDict']]]]] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OccDemandSignalPatchOperationArgs', 'OccDemandSignalPatchOperationArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OccDemandSignalArgs.__new__(OccDemandSignalArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if is_active is None and not opts.urn:
                raise TypeError("Missing required property 'is_active'")
            __props__.__dict__["is_active"] = is_active
            __props__.__dict__["occ_demand_signal_id"] = occ_demand_signal_id
            if occ_demand_signals is None and not opts.urn:
                raise TypeError("Missing required property 'occ_demand_signals'")
            __props__.__dict__["occ_demand_signals"] = occ_demand_signals
            __props__.__dict__["patch_operations"] = patch_operations
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(OccDemandSignal, __self__).__init__(
            'oci:DemandSignal/occDemandSignal:OccDemandSignal',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_active: Optional[pulumi.Input[builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            occ_demand_signal_id: Optional[pulumi.Input[builtins.str]] = None,
            occ_demand_signals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OccDemandSignalOccDemandSignalArgs', 'OccDemandSignalOccDemandSignalArgsDict']]]]] = None,
            patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OccDemandSignalPatchOperationArgs', 'OccDemandSignalPatchOperationArgsDict']]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'OccDemandSignal':
        """
        Get an existing OccDemandSignal resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the OccDemandSignal in.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_active: (Updatable) Indicator of whether to share the data with Oracle.
        :param pulumi.Input[builtins.str] lifecycle_details: A message that describes the current state of the OccDemandSignal in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OccDemandSignalOccDemandSignalArgs', 'OccDemandSignalOccDemandSignalArgsDict']]]] occ_demand_signals: The OccDemandSignal data.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OccDemandSignalPatchOperationArgs', 'OccDemandSignalPatchOperationArgsDict']]]] patch_operations: (Updatable)
        :param pulumi.Input[builtins.str] state: The current state of the OccDemandSignal.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the OccDemandSignal was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_updated: The date and time the OccDemandSignal was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OccDemandSignalState.__new__(_OccDemandSignalState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_active"] = is_active
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["occ_demand_signal_id"] = occ_demand_signal_id
        __props__.__dict__["occ_demand_signals"] = occ_demand_signals
        __props__.__dict__["patch_operations"] = patch_operations
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return OccDemandSignal(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the OccDemandSignal in.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Indicator of whether to share the data with Oracle.
        """
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        A message that describes the current state of the OccDemandSignal in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="occDemandSignalId")
    def occ_demand_signal_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "occ_demand_signal_id")

    @property
    @pulumi.getter(name="occDemandSignals")
    def occ_demand_signals(self) -> pulumi.Output[Sequence['outputs.OccDemandSignalOccDemandSignal']]:
        """
        The OccDemandSignal data.
        """
        return pulumi.get(self, "occ_demand_signals")

    @property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> pulumi.Output[Optional[Sequence['outputs.OccDemandSignalPatchOperation']]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the OccDemandSignal.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the OccDemandSignal was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the OccDemandSignal was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

