# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSteeringPolicyAttachmentResult',
    'AwaitableGetSteeringPolicyAttachmentResult',
    'get_steering_policy_attachment',
    'get_steering_policy_attachment_output',
]

@pulumi.output_type
class GetSteeringPolicyAttachmentResult:
    """
    A collection of values returned by getSteeringPolicyAttachment.
    """
    def __init__(__self__, compartment_id=None, display_name=None, domain_name=None, id=None, rtypes=None, self=None, state=None, steering_policy_attachment_id=None, steering_policy_id=None, time_created=None, zone_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if rtypes and not isinstance(rtypes, list):
            raise TypeError("Expected argument 'rtypes' to be a list")
        pulumi.set(__self__, "rtypes", rtypes)
        if self and not isinstance(self, str):
            raise TypeError("Expected argument 'self' to be a str")
        pulumi.set(__self__, "self", self)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if steering_policy_attachment_id and not isinstance(steering_policy_attachment_id, str):
            raise TypeError("Expected argument 'steering_policy_attachment_id' to be a str")
        pulumi.set(__self__, "steering_policy_attachment_id", steering_policy_attachment_id)
        if steering_policy_id and not isinstance(steering_policy_id, str):
            raise TypeError("Expected argument 'steering_policy_id' to be a str")
        pulumi.set(__self__, "steering_policy_id", steering_policy_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment containing the steering policy attachment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name for the steering policy attachment. Does not have to be unique and can be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> builtins.str:
        """
        The attached domain within the attached zone.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rtypes(self) -> Sequence[builtins.str]:
        """
        The record types covered by the attachment at the domain. The set of record types is determined by aggregating the record types from the answers defined in the steering policy.
        """
        return pulumi.get(self, "rtypes")

    @property
    @pulumi.getter
    def self(self) -> builtins.str:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="steeringPolicyAttachmentId")
    def steering_policy_attachment_id(self) -> builtins.str:
        return pulumi.get(self, "steering_policy_attachment_id")

    @property
    @pulumi.getter(name="steeringPolicyId")
    def steering_policy_id(self) -> builtins.str:
        """
        The OCID of the attached steering policy.
        """
        return pulumi.get(self, "steering_policy_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the resource was created, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        The OCID of the attached zone.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetSteeringPolicyAttachmentResult(GetSteeringPolicyAttachmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSteeringPolicyAttachmentResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            domain_name=self.domain_name,
            id=self.id,
            rtypes=self.rtypes,
            self=self.self,
            state=self.state,
            steering_policy_attachment_id=self.steering_policy_attachment_id,
            steering_policy_id=self.steering_policy_id,
            time_created=self.time_created,
            zone_id=self.zone_id)


def get_steering_policy_attachment(steering_policy_attachment_id: Optional[builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSteeringPolicyAttachmentResult:
    """
    This data source provides details about a specific Steering Policy Attachment resource in Oracle Cloud Infrastructure DNS service.

    Gets information about the specified steering policy attachment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_steering_policy_attachment = oci.Dns.get_steering_policy_attachment(steering_policy_attachment_id=test_steering_policy_attachment_oci_dns_steering_policy_attachment["id"])
    ```


    :param builtins.str steering_policy_attachment_id: The OCID of the target steering policy attachment.
    """
    __args__ = dict()
    __args__['steeringPolicyAttachmentId'] = steering_policy_attachment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Dns/getSteeringPolicyAttachment:getSteeringPolicyAttachment', __args__, opts=opts, typ=GetSteeringPolicyAttachmentResult).value

    return AwaitableGetSteeringPolicyAttachmentResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        domain_name=pulumi.get(__ret__, 'domain_name'),
        id=pulumi.get(__ret__, 'id'),
        rtypes=pulumi.get(__ret__, 'rtypes'),
        self=pulumi.get(__ret__, 'self'),
        state=pulumi.get(__ret__, 'state'),
        steering_policy_attachment_id=pulumi.get(__ret__, 'steering_policy_attachment_id'),
        steering_policy_id=pulumi.get(__ret__, 'steering_policy_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_steering_policy_attachment_output(steering_policy_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSteeringPolicyAttachmentResult]:
    """
    This data source provides details about a specific Steering Policy Attachment resource in Oracle Cloud Infrastructure DNS service.

    Gets information about the specified steering policy attachment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_steering_policy_attachment = oci.Dns.get_steering_policy_attachment(steering_policy_attachment_id=test_steering_policy_attachment_oci_dns_steering_policy_attachment["id"])
    ```


    :param builtins.str steering_policy_attachment_id: The OCID of the target steering policy attachment.
    """
    __args__ = dict()
    __args__['steeringPolicyAttachmentId'] = steering_policy_attachment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Dns/getSteeringPolicyAttachment:getSteeringPolicyAttachment', __args__, opts=opts, typ=GetSteeringPolicyAttachmentResult)
    return __ret__.apply(lambda __response__: GetSteeringPolicyAttachmentResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        domain_name=pulumi.get(__response__, 'domain_name'),
        id=pulumi.get(__response__, 'id'),
        rtypes=pulumi.get(__response__, 'rtypes'),
        self=pulumi.get(__response__, 'self'),
        state=pulumi.get(__response__, 'state'),
        steering_policy_attachment_id=pulumi.get(__response__, 'steering_policy_attachment_id'),
        steering_policy_id=pulumi.get(__response__, 'steering_policy_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        zone_id=pulumi.get(__response__, 'zone_id')))
