# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ResolverEndpointInitArgs', 'ResolverEndpoint']

@pulumi.input_type
class ResolverEndpointInitArgs:
    def __init__(__self__, *,
                 is_forwarding: pulumi.Input[builtins.bool],
                 is_listening: pulumi.Input[builtins.bool],
                 resolver_id: pulumi.Input[builtins.str],
                 subnet_id: pulumi.Input[builtins.str],
                 endpoint_type: Optional[pulumi.Input[builtins.str]] = None,
                 forwarding_address: Optional[pulumi.Input[builtins.str]] = None,
                 listening_address: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ResolverEndpoint resource.
        :param pulumi.Input[builtins.bool] is_forwarding: A Boolean flag indicating whether or not the resolver endpoint is for forwarding.
        :param pulumi.Input[builtins.bool] is_listening: A Boolean flag indicating whether or not the resolver endpoint is for listening.
        :param pulumi.Input[builtins.str] resolver_id: The OCID of the target resolver.
        :param pulumi.Input[builtins.str] subnet_id: The OCID of a subnet. Must be part of the VCN that the resolver is attached to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] endpoint_type: (Updatable) The type of resolver endpoint. VNIC is currently the only supported type.
        :param pulumi.Input[builtins.str] forwarding_address: An IP address from which forwarded queries may be sent. For VNIC endpoints, this IP address must be part of the subnet and will be assigned by the system if unspecified when isForwarding is true.
        :param pulumi.Input[builtins.str] listening_address: An IP address to listen to queries on. For VNIC endpoints this IP address must be part of the subnet and will be assigned by the system if unspecified when isListening is true.
        :param pulumi.Input[builtins.str] name: The name of the resolver endpoint. Must be unique, case-insensitive, within the resolver.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: An array of network security group OCIDs for the resolver endpoint. These must be part of the VCN that the resolver endpoint is a part of.
        :param pulumi.Input[builtins.str] scope: Value must be `PRIVATE` when creating private name resolver endpoints.
        """
        pulumi.set(__self__, "is_forwarding", is_forwarding)
        pulumi.set(__self__, "is_listening", is_listening)
        pulumi.set(__self__, "resolver_id", resolver_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if forwarding_address is not None:
            pulumi.set(__self__, "forwarding_address", forwarding_address)
        if listening_address is not None:
            pulumi.set(__self__, "listening_address", listening_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="isForwarding")
    def is_forwarding(self) -> pulumi.Input[builtins.bool]:
        """
        A Boolean flag indicating whether or not the resolver endpoint is for forwarding.
        """
        return pulumi.get(self, "is_forwarding")

    @is_forwarding.setter
    def is_forwarding(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "is_forwarding", value)

    @property
    @pulumi.getter(name="isListening")
    def is_listening(self) -> pulumi.Input[builtins.bool]:
        """
        A Boolean flag indicating whether or not the resolver endpoint is for listening.
        """
        return pulumi.get(self, "is_listening")

    @is_listening.setter
    def is_listening(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "is_listening", value)

    @property
    @pulumi.getter(name="resolverId")
    def resolver_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the target resolver.
        """
        return pulumi.get(self, "resolver_id")

    @resolver_id.setter
    def resolver_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resolver_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of a subnet. Must be part of the VCN that the resolver is attached to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The type of resolver endpoint. VNIC is currently the only supported type.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="forwardingAddress")
    def forwarding_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An IP address from which forwarded queries may be sent. For VNIC endpoints, this IP address must be part of the subnet and will be assigned by the system if unspecified when isForwarding is true.
        """
        return pulumi.get(self, "forwarding_address")

    @forwarding_address.setter
    def forwarding_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "forwarding_address", value)

    @property
    @pulumi.getter(name="listeningAddress")
    def listening_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An IP address to listen to queries on. For VNIC endpoints this IP address must be part of the subnet and will be assigned by the system if unspecified when isListening is true.
        """
        return pulumi.get(self, "listening_address")

    @listening_address.setter
    def listening_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "listening_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resolver endpoint. Must be unique, case-insensitive, within the resolver.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of network security group OCIDs for the resolver endpoint. These must be part of the VCN that the resolver endpoint is a part of.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Value must be `PRIVATE` when creating private name resolver endpoints.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _ResolverEndpointState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_type: Optional[pulumi.Input[builtins.str]] = None,
                 forwarding_address: Optional[pulumi.Input[builtins.str]] = None,
                 is_forwarding: Optional[pulumi.Input[builtins.bool]] = None,
                 is_listening: Optional[pulumi.Input[builtins.bool]] = None,
                 listening_address: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resolver_id: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 self: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ResolverEndpoint resources.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the owning compartment. This will match the resolver that the resolver endpoint is under and will be updated if the resolver's compartment is changed.
        :param pulumi.Input[builtins.str] endpoint_type: (Updatable) The type of resolver endpoint. VNIC is currently the only supported type.
        :param pulumi.Input[builtins.str] forwarding_address: An IP address from which forwarded queries may be sent. For VNIC endpoints, this IP address must be part of the subnet and will be assigned by the system if unspecified when isForwarding is true.
        :param pulumi.Input[builtins.bool] is_forwarding: A Boolean flag indicating whether or not the resolver endpoint is for forwarding.
        :param pulumi.Input[builtins.bool] is_listening: A Boolean flag indicating whether or not the resolver endpoint is for listening.
        :param pulumi.Input[builtins.str] listening_address: An IP address to listen to queries on. For VNIC endpoints this IP address must be part of the subnet and will be assigned by the system if unspecified when isListening is true.
        :param pulumi.Input[builtins.str] name: The name of the resolver endpoint. Must be unique, case-insensitive, within the resolver.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: An array of network security group OCIDs for the resolver endpoint. These must be part of the VCN that the resolver endpoint is a part of.
        :param pulumi.Input[builtins.str] resolver_id: The OCID of the target resolver.
        :param pulumi.Input[builtins.str] scope: Value must be `PRIVATE` when creating private name resolver endpoints.
        :param pulumi.Input[builtins.str] self: The canonical absolute URL of the resource.
        :param pulumi.Input[builtins.str] state: The current state of the resource.
        :param pulumi.Input[builtins.str] subnet_id: The OCID of a subnet. Must be part of the VCN that the resolver is attached to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        :param pulumi.Input[builtins.str] time_updated: The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if forwarding_address is not None:
            pulumi.set(__self__, "forwarding_address", forwarding_address)
        if is_forwarding is not None:
            pulumi.set(__self__, "is_forwarding", is_forwarding)
        if is_listening is not None:
            pulumi.set(__self__, "is_listening", is_listening)
        if listening_address is not None:
            pulumi.set(__self__, "listening_address", listening_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if resolver_id is not None:
            pulumi.set(__self__, "resolver_id", resolver_id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if self is not None:
            pulumi.set(__self__, "self", self)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the owning compartment. This will match the resolver that the resolver endpoint is under and will be updated if the resolver's compartment is changed.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The type of resolver endpoint. VNIC is currently the only supported type.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="forwardingAddress")
    def forwarding_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An IP address from which forwarded queries may be sent. For VNIC endpoints, this IP address must be part of the subnet and will be assigned by the system if unspecified when isForwarding is true.
        """
        return pulumi.get(self, "forwarding_address")

    @forwarding_address.setter
    def forwarding_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "forwarding_address", value)

    @property
    @pulumi.getter(name="isForwarding")
    def is_forwarding(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A Boolean flag indicating whether or not the resolver endpoint is for forwarding.
        """
        return pulumi.get(self, "is_forwarding")

    @is_forwarding.setter
    def is_forwarding(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_forwarding", value)

    @property
    @pulumi.getter(name="isListening")
    def is_listening(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A Boolean flag indicating whether or not the resolver endpoint is for listening.
        """
        return pulumi.get(self, "is_listening")

    @is_listening.setter
    def is_listening(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_listening", value)

    @property
    @pulumi.getter(name="listeningAddress")
    def listening_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An IP address to listen to queries on. For VNIC endpoints this IP address must be part of the subnet and will be assigned by the system if unspecified when isListening is true.
        """
        return pulumi.get(self, "listening_address")

    @listening_address.setter
    def listening_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "listening_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resolver endpoint. Must be unique, case-insensitive, within the resolver.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of network security group OCIDs for the resolver endpoint. These must be part of the VCN that the resolver endpoint is a part of.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="resolverId")
    def resolver_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the target resolver.
        """
        return pulumi.get(self, "resolver_id")

    @resolver_id.setter
    def resolver_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resolver_id", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Value must be `PRIVATE` when creating private name resolver endpoints.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def self(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @self.setter
    def self(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of a subnet. Must be part of the VCN that the resolver is attached to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:Dns/resolverEndpoint:ResolverEndpoint")
class ResolverEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint_type: Optional[pulumi.Input[builtins.str]] = None,
                 forwarding_address: Optional[pulumi.Input[builtins.str]] = None,
                 is_forwarding: Optional[pulumi.Input[builtins.bool]] = None,
                 is_listening: Optional[pulumi.Input[builtins.bool]] = None,
                 listening_address: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resolver_id: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Resolver Endpoint resource in Oracle Cloud Infrastructure DNS service.

        Creates a new resolver endpoint in the same compartment as the resolver.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_resolver_endpoint = oci.dns.ResolverEndpoint("test_resolver_endpoint",
            is_forwarding=resolver_endpoint_is_forwarding,
            is_listening=resolver_endpoint_is_listening,
            name=resolver_endpoint_name,
            resolver_id=test_resolver["id"],
            subnet_id=test_subnet["id"],
            scope="PRIVATE",
            endpoint_type=resolver_endpoint_endpoint_type,
            forwarding_address=resolver_endpoint_forwarding_address,
            listening_address=resolver_endpoint_listening_address,
            nsg_ids=resolver_endpoint_nsg_ids)
        ```

        ## Import

        For legacy ResolverEndpoints created without `scope`, these ResolverEndpoints can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Dns/resolverEndpoint:ResolverEndpoint test_resolver_endpoint "resolverId/{resolverId}/name/{resolverEndpointName}"
        ```
        For ResolverEndpoints created using `scope`, these ResolverEndpoints can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Dns/resolverEndpoint:ResolverEndpoint test_resolver_endpoint "resolverId/{resolverId}/name/{name}/scope/{scope}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] endpoint_type: (Updatable) The type of resolver endpoint. VNIC is currently the only supported type.
        :param pulumi.Input[builtins.str] forwarding_address: An IP address from which forwarded queries may be sent. For VNIC endpoints, this IP address must be part of the subnet and will be assigned by the system if unspecified when isForwarding is true.
        :param pulumi.Input[builtins.bool] is_forwarding: A Boolean flag indicating whether or not the resolver endpoint is for forwarding.
        :param pulumi.Input[builtins.bool] is_listening: A Boolean flag indicating whether or not the resolver endpoint is for listening.
        :param pulumi.Input[builtins.str] listening_address: An IP address to listen to queries on. For VNIC endpoints this IP address must be part of the subnet and will be assigned by the system if unspecified when isListening is true.
        :param pulumi.Input[builtins.str] name: The name of the resolver endpoint. Must be unique, case-insensitive, within the resolver.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: An array of network security group OCIDs for the resolver endpoint. These must be part of the VCN that the resolver endpoint is a part of.
        :param pulumi.Input[builtins.str] resolver_id: The OCID of the target resolver.
        :param pulumi.Input[builtins.str] scope: Value must be `PRIVATE` when creating private name resolver endpoints.
        :param pulumi.Input[builtins.str] subnet_id: The OCID of a subnet. Must be part of the VCN that the resolver is attached to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResolverEndpointInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Resolver Endpoint resource in Oracle Cloud Infrastructure DNS service.

        Creates a new resolver endpoint in the same compartment as the resolver.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_resolver_endpoint = oci.dns.ResolverEndpoint("test_resolver_endpoint",
            is_forwarding=resolver_endpoint_is_forwarding,
            is_listening=resolver_endpoint_is_listening,
            name=resolver_endpoint_name,
            resolver_id=test_resolver["id"],
            subnet_id=test_subnet["id"],
            scope="PRIVATE",
            endpoint_type=resolver_endpoint_endpoint_type,
            forwarding_address=resolver_endpoint_forwarding_address,
            listening_address=resolver_endpoint_listening_address,
            nsg_ids=resolver_endpoint_nsg_ids)
        ```

        ## Import

        For legacy ResolverEndpoints created without `scope`, these ResolverEndpoints can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Dns/resolverEndpoint:ResolverEndpoint test_resolver_endpoint "resolverId/{resolverId}/name/{resolverEndpointName}"
        ```
        For ResolverEndpoints created using `scope`, these ResolverEndpoints can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Dns/resolverEndpoint:ResolverEndpoint test_resolver_endpoint "resolverId/{resolverId}/name/{name}/scope/{scope}"
        ```

        :param str resource_name: The name of the resource.
        :param ResolverEndpointInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResolverEndpointInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint_type: Optional[pulumi.Input[builtins.str]] = None,
                 forwarding_address: Optional[pulumi.Input[builtins.str]] = None,
                 is_forwarding: Optional[pulumi.Input[builtins.bool]] = None,
                 is_listening: Optional[pulumi.Input[builtins.bool]] = None,
                 listening_address: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resolver_id: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResolverEndpointInitArgs.__new__(ResolverEndpointInitArgs)

            __props__.__dict__["endpoint_type"] = endpoint_type
            __props__.__dict__["forwarding_address"] = forwarding_address
            if is_forwarding is None and not opts.urn:
                raise TypeError("Missing required property 'is_forwarding'")
            __props__.__dict__["is_forwarding"] = is_forwarding
            if is_listening is None and not opts.urn:
                raise TypeError("Missing required property 'is_listening'")
            __props__.__dict__["is_listening"] = is_listening
            __props__.__dict__["listening_address"] = listening_address
            __props__.__dict__["name"] = name
            __props__.__dict__["nsg_ids"] = nsg_ids
            if resolver_id is None and not opts.urn:
                raise TypeError("Missing required property 'resolver_id'")
            __props__.__dict__["resolver_id"] = resolver_id
            __props__.__dict__["scope"] = scope
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["self"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(ResolverEndpoint, __self__).__init__(
            'oci:Dns/resolverEndpoint:ResolverEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_type: Optional[pulumi.Input[builtins.str]] = None,
            forwarding_address: Optional[pulumi.Input[builtins.str]] = None,
            is_forwarding: Optional[pulumi.Input[builtins.bool]] = None,
            is_listening: Optional[pulumi.Input[builtins.bool]] = None,
            listening_address: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            resolver_id: Optional[pulumi.Input[builtins.str]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None,
            self: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'ResolverEndpoint':
        """
        Get an existing ResolverEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the owning compartment. This will match the resolver that the resolver endpoint is under and will be updated if the resolver's compartment is changed.
        :param pulumi.Input[builtins.str] endpoint_type: (Updatable) The type of resolver endpoint. VNIC is currently the only supported type.
        :param pulumi.Input[builtins.str] forwarding_address: An IP address from which forwarded queries may be sent. For VNIC endpoints, this IP address must be part of the subnet and will be assigned by the system if unspecified when isForwarding is true.
        :param pulumi.Input[builtins.bool] is_forwarding: A Boolean flag indicating whether or not the resolver endpoint is for forwarding.
        :param pulumi.Input[builtins.bool] is_listening: A Boolean flag indicating whether or not the resolver endpoint is for listening.
        :param pulumi.Input[builtins.str] listening_address: An IP address to listen to queries on. For VNIC endpoints this IP address must be part of the subnet and will be assigned by the system if unspecified when isListening is true.
        :param pulumi.Input[builtins.str] name: The name of the resolver endpoint. Must be unique, case-insensitive, within the resolver.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: An array of network security group OCIDs for the resolver endpoint. These must be part of the VCN that the resolver endpoint is a part of.
        :param pulumi.Input[builtins.str] resolver_id: The OCID of the target resolver.
        :param pulumi.Input[builtins.str] scope: Value must be `PRIVATE` when creating private name resolver endpoints.
        :param pulumi.Input[builtins.str] self: The canonical absolute URL of the resource.
        :param pulumi.Input[builtins.str] state: The current state of the resource.
        :param pulumi.Input[builtins.str] subnet_id: The OCID of a subnet. Must be part of the VCN that the resolver is attached to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        :param pulumi.Input[builtins.str] time_updated: The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResolverEndpointState.__new__(_ResolverEndpointState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["endpoint_type"] = endpoint_type
        __props__.__dict__["forwarding_address"] = forwarding_address
        __props__.__dict__["is_forwarding"] = is_forwarding
        __props__.__dict__["is_listening"] = is_listening
        __props__.__dict__["listening_address"] = listening_address
        __props__.__dict__["name"] = name
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["resolver_id"] = resolver_id
        __props__.__dict__["scope"] = scope
        __props__.__dict__["self"] = self
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return ResolverEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the owning compartment. This will match the resolver that the resolver endpoint is under and will be updated if the resolver's compartment is changed.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The type of resolver endpoint. VNIC is currently the only supported type.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="forwardingAddress")
    def forwarding_address(self) -> pulumi.Output[builtins.str]:
        """
        An IP address from which forwarded queries may be sent. For VNIC endpoints, this IP address must be part of the subnet and will be assigned by the system if unspecified when isForwarding is true.
        """
        return pulumi.get(self, "forwarding_address")

    @property
    @pulumi.getter(name="isForwarding")
    def is_forwarding(self) -> pulumi.Output[builtins.bool]:
        """
        A Boolean flag indicating whether or not the resolver endpoint is for forwarding.
        """
        return pulumi.get(self, "is_forwarding")

    @property
    @pulumi.getter(name="isListening")
    def is_listening(self) -> pulumi.Output[builtins.bool]:
        """
        A Boolean flag indicating whether or not the resolver endpoint is for listening.
        """
        return pulumi.get(self, "is_listening")

    @property
    @pulumi.getter(name="listeningAddress")
    def listening_address(self) -> pulumi.Output[builtins.str]:
        """
        An IP address to listen to queries on. For VNIC endpoints this IP address must be part of the subnet and will be assigned by the system if unspecified when isListening is true.
        """
        return pulumi.get(self, "listening_address")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resolver endpoint. Must be unique, case-insensitive, within the resolver.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        An array of network security group OCIDs for the resolver endpoint. These must be part of the VCN that the resolver endpoint is a part of.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="resolverId")
    def resolver_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the target resolver.
        """
        return pulumi.get(self, "resolver_id")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Value must be `PRIVATE` when creating private name resolver endpoints.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def self(self) -> pulumi.Output[builtins.str]:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of a subnet. Must be part of the VCN that the resolver is attached to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_updated")

