# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HttpMonitorArgs', 'HttpMonitor']

@pulumi.input_type
class HttpMonitorArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 interval_in_seconds: pulumi.Input[builtins.int],
                 protocol: pulumi.Input[builtins.str],
                 targets: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 method: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 vantage_point_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a HttpMonitor resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly and mutable name suitable for display in a user interface.
        :param pulumi.Input[builtins.int] interval_in_seconds: (Updatable) The monitor interval in seconds. Valid values: 10, 30, and 60.
        :param pulumi.Input[builtins.str] protocol: (Updatable) The supported protocols available for HTTP probes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] targets: (Updatable) A list of targets (hostnames or IP addresses) of the probe.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] headers: (Updatable) A dictionary of HTTP request headers.
               
               *Note:* Monitors and probes do not support the use of the `Authorization` HTTP header.
        :param pulumi.Input[builtins.bool] is_enabled: (Updatable) Enables or disables the monitor. Set to 'true' to launch monitoring.
        :param pulumi.Input[builtins.str] method: (Updatable) The supported HTTP methods available for probes.
        :param pulumi.Input[builtins.str] path: (Updatable) The optional URL path to probe, including query parameters.
        :param pulumi.Input[builtins.int] port: (Updatable) The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        :param pulumi.Input[builtins.int] timeout_in_seconds: (Updatable) The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vantage_point_names: (Updatable) A list of names of vantage points from which to execute the probe.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "targets", targets)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if vantage_point_names is not None:
            pulumi.set(__self__, "vantage_point_names", vantage_point_names)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) A user-friendly and mutable name suitable for display in a user interface.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) The monitor interval in seconds. Valid values: 10, 30, and 60.
        """
        return pulumi.get(self, "interval_in_seconds")

    @interval_in_seconds.setter
    def interval_in_seconds(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "interval_in_seconds", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The supported protocols available for HTTP probes.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def targets(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        (Updatable) A list of targets (hostnames or IP addresses) of the probe.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A dictionary of HTTP request headers.

        *Note:* Monitors and probes do not support the use of the `Authorization` HTTP header.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Enables or disables the monitor. Set to 'true' to launch monitoring.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The supported HTTP methods available for probes.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The optional URL path to probe, including query parameters.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @property
    @pulumi.getter(name="vantagePointNames")
    def vantage_point_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A list of names of vantage points from which to execute the probe.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vantage_point_names")

    @vantage_point_names.setter
    def vantage_point_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vantage_point_names", value)


@pulumi.input_type
class _HttpMonitorState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 home_region: Optional[pulumi.Input[builtins.str]] = None,
                 interval_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 method: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 results_url: Optional[pulumi.Input[builtins.str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 vantage_point_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering HttpMonitor resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly and mutable name suitable for display in a user interface.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] headers: (Updatable) A dictionary of HTTP request headers.
               
               *Note:* Monitors and probes do not support the use of the `Authorization` HTTP header.
        :param pulumi.Input[builtins.str] home_region: The region where updates must be made and where results must be fetched from.
        :param pulumi.Input[builtins.int] interval_in_seconds: (Updatable) The monitor interval in seconds. Valid values: 10, 30, and 60.
        :param pulumi.Input[builtins.bool] is_enabled: (Updatable) Enables or disables the monitor. Set to 'true' to launch monitoring.
        :param pulumi.Input[builtins.str] method: (Updatable) The supported HTTP methods available for probes.
        :param pulumi.Input[builtins.str] path: (Updatable) The optional URL path to probe, including query parameters.
        :param pulumi.Input[builtins.int] port: (Updatable) The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        :param pulumi.Input[builtins.str] protocol: (Updatable) The supported protocols available for HTTP probes.
        :param pulumi.Input[builtins.str] results_url: A URL for fetching the probe results.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] targets: (Updatable) A list of targets (hostnames or IP addresses) of the probe.
        :param pulumi.Input[builtins.str] time_created: The RFC 3339-formatted creation date and time of the probe.
        :param pulumi.Input[builtins.int] timeout_in_seconds: (Updatable) The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vantage_point_names: (Updatable) A list of names of vantage points from which to execute the probe.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if home_region is not None:
            pulumi.set(__self__, "home_region", home_region)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if results_url is not None:
            pulumi.set(__self__, "results_url", results_url)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if vantage_point_names is not None:
            pulumi.set(__self__, "vantage_point_names", vantage_point_names)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly and mutable name suitable for display in a user interface.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A dictionary of HTTP request headers.

        *Note:* Monitors and probes do not support the use of the `Authorization` HTTP header.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="homeRegion")
    def home_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region where updates must be made and where results must be fetched from.
        """
        return pulumi.get(self, "home_region")

    @home_region.setter
    def home_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "home_region", value)

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The monitor interval in seconds. Valid values: 10, 30, and 60.
        """
        return pulumi.get(self, "interval_in_seconds")

    @interval_in_seconds.setter
    def interval_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval_in_seconds", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Enables or disables the monitor. Set to 'true' to launch monitoring.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The supported HTTP methods available for probes.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The optional URL path to probe, including query parameters.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The supported protocols available for HTTP probes.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="resultsUrl")
    def results_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A URL for fetching the probe results.
        """
        return pulumi.get(self, "results_url")

    @results_url.setter
    def results_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "results_url", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A list of targets (hostnames or IP addresses) of the probe.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The RFC 3339-formatted creation date and time of the probe.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @property
    @pulumi.getter(name="vantagePointNames")
    def vantage_point_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A list of names of vantage points from which to execute the probe.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vantage_point_names")

    @vantage_point_names.setter
    def vantage_point_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vantage_point_names", value)


@pulumi.type_token("oci:HealthChecks/httpMonitor:HttpMonitor")
class HttpMonitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 interval_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 method: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 vantage_point_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Http Monitor resource in Oracle Cloud Infrastructure Health Checks service.

        Creates an HTTP monitor. Vantage points will be automatically selected if not specified,
        and probes will be initiated from each vantage point to each of the targets at the frequency
        specified by `intervalInSeconds`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_http_monitor = oci.health_checks.HttpMonitor("test_http_monitor",
            compartment_id=compartment_id,
            display_name=http_monitor_display_name,
            interval_in_seconds=http_monitor_interval_in_seconds,
            protocol=http_monitor_protocol,
            targets=http_monitor_targets,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            headers=http_monitor_headers,
            is_enabled=http_monitor_is_enabled,
            method=http_monitor_method,
            path=http_monitor_path,
            port=http_monitor_port,
            timeout_in_seconds=http_monitor_timeout_in_seconds,
            vantage_point_names=http_monitor_vantage_point_names)
        ```

        ## Import

        HttpMonitors can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:HealthChecks/httpMonitor:HttpMonitor test_http_monitor "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly and mutable name suitable for display in a user interface.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] headers: (Updatable) A dictionary of HTTP request headers.
               
               *Note:* Monitors and probes do not support the use of the `Authorization` HTTP header.
        :param pulumi.Input[builtins.int] interval_in_seconds: (Updatable) The monitor interval in seconds. Valid values: 10, 30, and 60.
        :param pulumi.Input[builtins.bool] is_enabled: (Updatable) Enables or disables the monitor. Set to 'true' to launch monitoring.
        :param pulumi.Input[builtins.str] method: (Updatable) The supported HTTP methods available for probes.
        :param pulumi.Input[builtins.str] path: (Updatable) The optional URL path to probe, including query parameters.
        :param pulumi.Input[builtins.int] port: (Updatable) The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        :param pulumi.Input[builtins.str] protocol: (Updatable) The supported protocols available for HTTP probes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] targets: (Updatable) A list of targets (hostnames or IP addresses) of the probe.
        :param pulumi.Input[builtins.int] timeout_in_seconds: (Updatable) The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vantage_point_names: (Updatable) A list of names of vantage points from which to execute the probe.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HttpMonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Http Monitor resource in Oracle Cloud Infrastructure Health Checks service.

        Creates an HTTP monitor. Vantage points will be automatically selected if not specified,
        and probes will be initiated from each vantage point to each of the targets at the frequency
        specified by `intervalInSeconds`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_http_monitor = oci.health_checks.HttpMonitor("test_http_monitor",
            compartment_id=compartment_id,
            display_name=http_monitor_display_name,
            interval_in_seconds=http_monitor_interval_in_seconds,
            protocol=http_monitor_protocol,
            targets=http_monitor_targets,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            headers=http_monitor_headers,
            is_enabled=http_monitor_is_enabled,
            method=http_monitor_method,
            path=http_monitor_path,
            port=http_monitor_port,
            timeout_in_seconds=http_monitor_timeout_in_seconds,
            vantage_point_names=http_monitor_vantage_point_names)
        ```

        ## Import

        HttpMonitors can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:HealthChecks/httpMonitor:HttpMonitor test_http_monitor "id"
        ```

        :param str resource_name: The name of the resource.
        :param HttpMonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HttpMonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 interval_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 method: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 vantage_point_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HttpMonitorArgs.__new__(HttpMonitorArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["headers"] = headers
            if interval_in_seconds is None and not opts.urn:
                raise TypeError("Missing required property 'interval_in_seconds'")
            __props__.__dict__["interval_in_seconds"] = interval_in_seconds
            __props__.__dict__["is_enabled"] = is_enabled
            __props__.__dict__["method"] = method
            __props__.__dict__["path"] = path
            __props__.__dict__["port"] = port
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            if targets is None and not opts.urn:
                raise TypeError("Missing required property 'targets'")
            __props__.__dict__["targets"] = targets
            __props__.__dict__["timeout_in_seconds"] = timeout_in_seconds
            __props__.__dict__["vantage_point_names"] = vantage_point_names
            __props__.__dict__["home_region"] = None
            __props__.__dict__["results_url"] = None
            __props__.__dict__["time_created"] = None
        super(HttpMonitor, __self__).__init__(
            'oci:HealthChecks/httpMonitor:HttpMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            home_region: Optional[pulumi.Input[builtins.str]] = None,
            interval_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
            is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            method: Optional[pulumi.Input[builtins.str]] = None,
            path: Optional[pulumi.Input[builtins.str]] = None,
            port: Optional[pulumi.Input[builtins.int]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None,
            results_url: Optional[pulumi.Input[builtins.str]] = None,
            targets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            timeout_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
            vantage_point_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'HttpMonitor':
        """
        Get an existing HttpMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly and mutable name suitable for display in a user interface.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] headers: (Updatable) A dictionary of HTTP request headers.
               
               *Note:* Monitors and probes do not support the use of the `Authorization` HTTP header.
        :param pulumi.Input[builtins.str] home_region: The region where updates must be made and where results must be fetched from.
        :param pulumi.Input[builtins.int] interval_in_seconds: (Updatable) The monitor interval in seconds. Valid values: 10, 30, and 60.
        :param pulumi.Input[builtins.bool] is_enabled: (Updatable) Enables or disables the monitor. Set to 'true' to launch monitoring.
        :param pulumi.Input[builtins.str] method: (Updatable) The supported HTTP methods available for probes.
        :param pulumi.Input[builtins.str] path: (Updatable) The optional URL path to probe, including query parameters.
        :param pulumi.Input[builtins.int] port: (Updatable) The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        :param pulumi.Input[builtins.str] protocol: (Updatable) The supported protocols available for HTTP probes.
        :param pulumi.Input[builtins.str] results_url: A URL for fetching the probe results.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] targets: (Updatable) A list of targets (hostnames or IP addresses) of the probe.
        :param pulumi.Input[builtins.str] time_created: The RFC 3339-formatted creation date and time of the probe.
        :param pulumi.Input[builtins.int] timeout_in_seconds: (Updatable) The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vantage_point_names: (Updatable) A list of names of vantage points from which to execute the probe.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HttpMonitorState.__new__(_HttpMonitorState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["headers"] = headers
        __props__.__dict__["home_region"] = home_region
        __props__.__dict__["interval_in_seconds"] = interval_in_seconds
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["method"] = method
        __props__.__dict__["path"] = path
        __props__.__dict__["port"] = port
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["results_url"] = results_url
        __props__.__dict__["targets"] = targets
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["timeout_in_seconds"] = timeout_in_seconds
        __props__.__dict__["vantage_point_names"] = vantage_point_names
        return HttpMonitor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly and mutable name suitable for display in a user interface.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def headers(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) A dictionary of HTTP request headers.

        *Note:* Monitors and probes do not support the use of the `Authorization` HTTP header.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="homeRegion")
    def home_region(self) -> pulumi.Output[builtins.str]:
        """
        The region where updates must be made and where results must be fetched from.
        """
        return pulumi.get(self, "home_region")

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The monitor interval in seconds. Valid values: 10, 30, and 60.
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Enables or disables the monitor. Set to 'true' to launch monitoring.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def method(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The supported HTTP methods available for probes.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The optional URL path to probe, including query parameters.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The supported protocols available for HTTP probes.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="resultsUrl")
    def results_url(self) -> pulumi.Output[builtins.str]:
        """
        A URL for fetching the probe results.
        """
        return pulumi.get(self, "results_url")

    @property
    @pulumi.getter
    def targets(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) A list of targets (hostnames or IP addresses) of the probe.
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The RFC 3339-formatted creation date and time of the probe.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @property
    @pulumi.getter(name="vantagePointNames")
    def vantage_point_names(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) A list of names of vantage points from which to execute the probe.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vantage_point_names")

