# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DbCredentialArgs', 'DbCredential']

@pulumi.input_type
class DbCredentialArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str],
                 user_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a DbCredential resource.
        :param pulumi.Input[builtins.str] description: The description you assign to the DB credentials during creation.
        :param pulumi.Input[builtins.str] password: The password for the DB credentials during creation.
        :param pulumi.Input[builtins.str] user_id: The OCID of the user.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description you assign to the DB credentials during creation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        The password for the DB credentials during creation.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the user.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _DbCredentialState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_expires: Optional[pulumi.Input[builtins.str]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DbCredential resources.
        :param pulumi.Input[builtins.str] description: The description you assign to the DB credentials during creation.
        :param pulumi.Input[builtins.str] lifecycle_details: The detailed status of INACTIVE lifecycleState.
        :param pulumi.Input[builtins.str] password: The password for the DB credentials during creation.
        :param pulumi.Input[builtins.str] state: The credential's current state. After creating a DB credential, make sure its `lifecycleState` changes from CREATING to ACTIVE before using it.
        :param pulumi.Input[builtins.str] time_created: Date and time the `DbCredential` object was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_expires: Date and time when this credential will expire, in the format defined by RFC3339. Null if it never expires.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] user_id: The OCID of the user.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_expires is not None:
            pulumi.set(__self__, "time_expires", time_expires)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description you assign to the DB credentials during creation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The detailed status of INACTIVE lifecycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password for the DB credentials during creation.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The credential's current state. After creating a DB credential, make sure its `lifecycleState` changes from CREATING to ACTIVE before using it.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time the `DbCredential` object was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeExpires")
    def time_expires(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time when this credential will expire, in the format defined by RFC3339. Null if it never expires.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_expires")

    @time_expires.setter
    def time_expires(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_expires", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the user.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("oci:Identity/dbCredential:DbCredential")
class DbCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Db Credential resource in Oracle Cloud Infrastructure Identity service.

        Creates a new DB credential for the specified user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_db_credential = oci.identity.DbCredential("test_db_credential",
            description=db_credential_description,
            password=db_credential_password,
            user_id=test_user["id"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description you assign to the DB credentials during creation.
        :param pulumi.Input[builtins.str] password: The password for the DB credentials during creation.
        :param pulumi.Input[builtins.str] user_id: The OCID of the user.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Db Credential resource in Oracle Cloud Infrastructure Identity service.

        Creates a new DB credential for the specified user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_db_credential = oci.identity.DbCredential("test_db_credential",
            description=db_credential_description,
            password=db_credential_password,
            user_id=test_user["id"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param DbCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbCredentialArgs.__new__(DbCredentialArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_expires"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DbCredential, __self__).__init__(
            'oci:Identity/dbCredential:DbCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_expires: Optional[pulumi.Input[builtins.str]] = None,
            user_id: Optional[pulumi.Input[builtins.str]] = None) -> 'DbCredential':
        """
        Get an existing DbCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description you assign to the DB credentials during creation.
        :param pulumi.Input[builtins.str] lifecycle_details: The detailed status of INACTIVE lifecycleState.
        :param pulumi.Input[builtins.str] password: The password for the DB credentials during creation.
        :param pulumi.Input[builtins.str] state: The credential's current state. After creating a DB credential, make sure its `lifecycleState` changes from CREATING to ACTIVE before using it.
        :param pulumi.Input[builtins.str] time_created: Date and time the `DbCredential` object was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_expires: Date and time when this credential will expire, in the format defined by RFC3339. Null if it never expires.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] user_id: The OCID of the user.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbCredentialState.__new__(_DbCredentialState)

        __props__.__dict__["description"] = description
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["password"] = password
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_expires"] = time_expires
        __props__.__dict__["user_id"] = user_id
        return DbCredential(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description you assign to the DB credentials during creation.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        The detailed status of INACTIVE lifecycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        The password for the DB credentials during creation.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The credential's current state. After creating a DB credential, make sure its `lifecycleState` changes from CREATING to ACTIVE before using it.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        Date and time the `DbCredential` object was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeExpires")
    def time_expires(self) -> pulumi.Output[builtins.str]:
        """
        Date and time when this credential will expire, in the format defined by RFC3339. Null if it never expires.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_expires")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the user.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "user_id")

