# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDomainsMyPendingApprovalResult',
    'AwaitableGetDomainsMyPendingApprovalResult',
    'get_domains_my_pending_approval',
    'get_domains_my_pending_approval_output',
]

@pulumi.output_type
class GetDomainsMyPendingApprovalResult:
    """
    A collection of values returned by getDomainsMyPendingApproval.
    """
    def __init__(__self__, authorization=None, compartment_ocid=None, delete_in_progress=None, domain_ocid=None, expires=None, id=None, idcs_created_bies=None, idcs_endpoint=None, idcs_last_modified_bies=None, idcs_last_upgraded_in_release=None, idcs_prevented_operations=None, justification=None, metas=None, my_pending_approval_id=None, ocid=None, request_created_time=None, request_details=None, request_id=None, request_ocid=None, resource_display_name=None, resource_type=None, resource_type_schema_version=None, response_time=None, schemas=None, status=None, tags=None, tenancy_ocid=None):
        if authorization and not isinstance(authorization, str):
            raise TypeError("Expected argument 'authorization' to be a str")
        pulumi.set(__self__, "authorization", authorization)
        if compartment_ocid and not isinstance(compartment_ocid, str):
            raise TypeError("Expected argument 'compartment_ocid' to be a str")
        pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if delete_in_progress and not isinstance(delete_in_progress, bool):
            raise TypeError("Expected argument 'delete_in_progress' to be a bool")
        pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if domain_ocid and not isinstance(domain_ocid, str):
            raise TypeError("Expected argument 'domain_ocid' to be a str")
        pulumi.set(__self__, "domain_ocid", domain_ocid)
        if expires and not isinstance(expires, str):
            raise TypeError("Expected argument 'expires' to be a str")
        pulumi.set(__self__, "expires", expires)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idcs_created_bies and not isinstance(idcs_created_bies, list):
            raise TypeError("Expected argument 'idcs_created_bies' to be a list")
        pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint and not isinstance(idcs_endpoint, str):
            raise TypeError("Expected argument 'idcs_endpoint' to be a str")
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies and not isinstance(idcs_last_modified_bies, list):
            raise TypeError("Expected argument 'idcs_last_modified_bies' to be a list")
        pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release and not isinstance(idcs_last_upgraded_in_release, str):
            raise TypeError("Expected argument 'idcs_last_upgraded_in_release' to be a str")
        pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations and not isinstance(idcs_prevented_operations, list):
            raise TypeError("Expected argument 'idcs_prevented_operations' to be a list")
        pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if justification and not isinstance(justification, str):
            raise TypeError("Expected argument 'justification' to be a str")
        pulumi.set(__self__, "justification", justification)
        if metas and not isinstance(metas, list):
            raise TypeError("Expected argument 'metas' to be a list")
        pulumi.set(__self__, "metas", metas)
        if my_pending_approval_id and not isinstance(my_pending_approval_id, str):
            raise TypeError("Expected argument 'my_pending_approval_id' to be a str")
        pulumi.set(__self__, "my_pending_approval_id", my_pending_approval_id)
        if ocid and not isinstance(ocid, str):
            raise TypeError("Expected argument 'ocid' to be a str")
        pulumi.set(__self__, "ocid", ocid)
        if request_created_time and not isinstance(request_created_time, str):
            raise TypeError("Expected argument 'request_created_time' to be a str")
        pulumi.set(__self__, "request_created_time", request_created_time)
        if request_details and not isinstance(request_details, str):
            raise TypeError("Expected argument 'request_details' to be a str")
        pulumi.set(__self__, "request_details", request_details)
        if request_id and not isinstance(request_id, str):
            raise TypeError("Expected argument 'request_id' to be a str")
        pulumi.set(__self__, "request_id", request_id)
        if request_ocid and not isinstance(request_ocid, str):
            raise TypeError("Expected argument 'request_ocid' to be a str")
        pulumi.set(__self__, "request_ocid", request_ocid)
        if resource_display_name and not isinstance(resource_display_name, str):
            raise TypeError("Expected argument 'resource_display_name' to be a str")
        pulumi.set(__self__, "resource_display_name", resource_display_name)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if resource_type_schema_version and not isinstance(resource_type_schema_version, str):
            raise TypeError("Expected argument 'resource_type_schema_version' to be a str")
        pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if response_time and not isinstance(response_time, str):
            raise TypeError("Expected argument 'response_time' to be a str")
        pulumi.set(__self__, "response_time", response_time)
        if schemas and not isinstance(schemas, list):
            raise TypeError("Expected argument 'schemas' to be a list")
        pulumi.set(__self__, "schemas", schemas)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tenancy_ocid and not isinstance(tenancy_ocid, str):
            raise TypeError("Expected argument 'tenancy_ocid' to be a str")
        pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[builtins.str]:
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> builtins.str:
        """
        Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> builtins.bool:
        """
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> builtins.str:
        """
        Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter
    def expires(self) -> builtins.str:
        """
        Time by when ApprovalWorkflowInstance expires
        """
        return pulumi.get(self, "expires")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Sequence['outputs.GetDomainsMyPendingApprovalIdcsCreatedByResult']:
        """
        The User or App who created the Resource
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> builtins.str:
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Sequence['outputs.GetDomainsMyPendingApprovalIdcsLastModifiedByResult']:
        """
        The User or App who modified the Resource
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> builtins.str:
        """
        The release number when the resource was upgraded.
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Sequence[builtins.str]:
        """
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter
    def justification(self) -> builtins.str:
        """
        Justification for approval
        """
        return pulumi.get(self, "justification")

    @property
    @pulumi.getter
    def metas(self) -> Sequence['outputs.GetDomainsMyPendingApprovalMetaResult']:
        """
        A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter(name="myPendingApprovalId")
    def my_pending_approval_id(self) -> builtins.str:
        return pulumi.get(self, "my_pending_approval_id")

    @property
    @pulumi.getter
    def ocid(self) -> builtins.str:
        """
        Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="requestCreatedTime")
    def request_created_time(self) -> builtins.str:
        """
        The time that the Request was created
        """
        return pulumi.get(self, "request_created_time")

    @property
    @pulumi.getter(name="requestDetails")
    def request_details(self) -> builtins.str:
        """
        Request Details
        """
        return pulumi.get(self, "request_details")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> builtins.str:
        """
        The Unique Identifier of the request.
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter(name="requestOcid")
    def request_ocid(self) -> builtins.str:
        """
        The Oracle Cloud Infrastructure Unique Identifier of the request.
        """
        return pulumi.get(self, "request_ocid")

    @property
    @pulumi.getter(name="resourceDisplayName")
    def resource_display_name(self) -> builtins.str:
        """
        Requested Resource display name
        """
        return pulumi.get(self, "resource_display_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        Requested Resource type
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[builtins.str]:
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter(name="responseTime")
    def response_time(self) -> builtins.str:
        """
        The time that the user responded to the Approval
        """
        return pulumi.get(self, "response_time")

    @property
    @pulumi.getter
    def schemas(self) -> Sequence[builtins.str]:
        """
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Status of the approver's response on the approval
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetDomainsMyPendingApprovalTagResult']:
        """
        A list of tags on this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> builtins.str:
        """
        Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
        """
        return pulumi.get(self, "tenancy_ocid")


class AwaitableGetDomainsMyPendingApprovalResult(GetDomainsMyPendingApprovalResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainsMyPendingApprovalResult(
            authorization=self.authorization,
            compartment_ocid=self.compartment_ocid,
            delete_in_progress=self.delete_in_progress,
            domain_ocid=self.domain_ocid,
            expires=self.expires,
            id=self.id,
            idcs_created_bies=self.idcs_created_bies,
            idcs_endpoint=self.idcs_endpoint,
            idcs_last_modified_bies=self.idcs_last_modified_bies,
            idcs_last_upgraded_in_release=self.idcs_last_upgraded_in_release,
            idcs_prevented_operations=self.idcs_prevented_operations,
            justification=self.justification,
            metas=self.metas,
            my_pending_approval_id=self.my_pending_approval_id,
            ocid=self.ocid,
            request_created_time=self.request_created_time,
            request_details=self.request_details,
            request_id=self.request_id,
            request_ocid=self.request_ocid,
            resource_display_name=self.resource_display_name,
            resource_type=self.resource_type,
            resource_type_schema_version=self.resource_type_schema_version,
            response_time=self.response_time,
            schemas=self.schemas,
            status=self.status,
            tags=self.tags,
            tenancy_ocid=self.tenancy_ocid)


def get_domains_my_pending_approval(authorization: Optional[builtins.str] = None,
                                    idcs_endpoint: Optional[builtins.str] = None,
                                    my_pending_approval_id: Optional[builtins.str] = None,
                                    resource_type_schema_version: Optional[builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainsMyPendingApprovalResult:
    """
    This data source provides details about a specific My Pending Approval resource in Oracle Cloud Infrastructure Identity Domains service.

    Get My MyPendingApproval

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_my_pending_approval = oci.Identity.get_domains_my_pending_approval(idcs_endpoint=test_domain["url"],
        my_pending_approval_id=test_my_pending_approval_oci_identity_domains_my_pending_approval["id"],
        authorization=my_pending_approval_authorization,
        resource_type_schema_version=my_pending_approval_resource_type_schema_version)
    ```


    :param builtins.str authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
    :param builtins.str idcs_endpoint: The basic endpoint for the identity domain
    :param builtins.str my_pending_approval_id: ID of the resource
    :param builtins.str resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
    """
    __args__ = dict()
    __args__['authorization'] = authorization
    __args__['idcsEndpoint'] = idcs_endpoint
    __args__['myPendingApprovalId'] = my_pending_approval_id
    __args__['resourceTypeSchemaVersion'] = resource_type_schema_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getDomainsMyPendingApproval:getDomainsMyPendingApproval', __args__, opts=opts, typ=GetDomainsMyPendingApprovalResult).value

    return AwaitableGetDomainsMyPendingApprovalResult(
        authorization=pulumi.get(__ret__, 'authorization'),
        compartment_ocid=pulumi.get(__ret__, 'compartment_ocid'),
        delete_in_progress=pulumi.get(__ret__, 'delete_in_progress'),
        domain_ocid=pulumi.get(__ret__, 'domain_ocid'),
        expires=pulumi.get(__ret__, 'expires'),
        id=pulumi.get(__ret__, 'id'),
        idcs_created_bies=pulumi.get(__ret__, 'idcs_created_bies'),
        idcs_endpoint=pulumi.get(__ret__, 'idcs_endpoint'),
        idcs_last_modified_bies=pulumi.get(__ret__, 'idcs_last_modified_bies'),
        idcs_last_upgraded_in_release=pulumi.get(__ret__, 'idcs_last_upgraded_in_release'),
        idcs_prevented_operations=pulumi.get(__ret__, 'idcs_prevented_operations'),
        justification=pulumi.get(__ret__, 'justification'),
        metas=pulumi.get(__ret__, 'metas'),
        my_pending_approval_id=pulumi.get(__ret__, 'my_pending_approval_id'),
        ocid=pulumi.get(__ret__, 'ocid'),
        request_created_time=pulumi.get(__ret__, 'request_created_time'),
        request_details=pulumi.get(__ret__, 'request_details'),
        request_id=pulumi.get(__ret__, 'request_id'),
        request_ocid=pulumi.get(__ret__, 'request_ocid'),
        resource_display_name=pulumi.get(__ret__, 'resource_display_name'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        resource_type_schema_version=pulumi.get(__ret__, 'resource_type_schema_version'),
        response_time=pulumi.get(__ret__, 'response_time'),
        schemas=pulumi.get(__ret__, 'schemas'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        tenancy_ocid=pulumi.get(__ret__, 'tenancy_ocid'))
def get_domains_my_pending_approval_output(authorization: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                           idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                                           my_pending_approval_id: Optional[pulumi.Input[builtins.str]] = None,
                                           resource_type_schema_version: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainsMyPendingApprovalResult]:
    """
    This data source provides details about a specific My Pending Approval resource in Oracle Cloud Infrastructure Identity Domains service.

    Get My MyPendingApproval

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_my_pending_approval = oci.Identity.get_domains_my_pending_approval(idcs_endpoint=test_domain["url"],
        my_pending_approval_id=test_my_pending_approval_oci_identity_domains_my_pending_approval["id"],
        authorization=my_pending_approval_authorization,
        resource_type_schema_version=my_pending_approval_resource_type_schema_version)
    ```


    :param builtins.str authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
    :param builtins.str idcs_endpoint: The basic endpoint for the identity domain
    :param builtins.str my_pending_approval_id: ID of the resource
    :param builtins.str resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
    """
    __args__ = dict()
    __args__['authorization'] = authorization
    __args__['idcsEndpoint'] = idcs_endpoint
    __args__['myPendingApprovalId'] = my_pending_approval_id
    __args__['resourceTypeSchemaVersion'] = resource_type_schema_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Identity/getDomainsMyPendingApproval:getDomainsMyPendingApproval', __args__, opts=opts, typ=GetDomainsMyPendingApprovalResult)
    return __ret__.apply(lambda __response__: GetDomainsMyPendingApprovalResult(
        authorization=pulumi.get(__response__, 'authorization'),
        compartment_ocid=pulumi.get(__response__, 'compartment_ocid'),
        delete_in_progress=pulumi.get(__response__, 'delete_in_progress'),
        domain_ocid=pulumi.get(__response__, 'domain_ocid'),
        expires=pulumi.get(__response__, 'expires'),
        id=pulumi.get(__response__, 'id'),
        idcs_created_bies=pulumi.get(__response__, 'idcs_created_bies'),
        idcs_endpoint=pulumi.get(__response__, 'idcs_endpoint'),
        idcs_last_modified_bies=pulumi.get(__response__, 'idcs_last_modified_bies'),
        idcs_last_upgraded_in_release=pulumi.get(__response__, 'idcs_last_upgraded_in_release'),
        idcs_prevented_operations=pulumi.get(__response__, 'idcs_prevented_operations'),
        justification=pulumi.get(__response__, 'justification'),
        metas=pulumi.get(__response__, 'metas'),
        my_pending_approval_id=pulumi.get(__response__, 'my_pending_approval_id'),
        ocid=pulumi.get(__response__, 'ocid'),
        request_created_time=pulumi.get(__response__, 'request_created_time'),
        request_details=pulumi.get(__response__, 'request_details'),
        request_id=pulumi.get(__response__, 'request_id'),
        request_ocid=pulumi.get(__response__, 'request_ocid'),
        resource_display_name=pulumi.get(__response__, 'resource_display_name'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        resource_type_schema_version=pulumi.get(__response__, 'resource_type_schema_version'),
        response_time=pulumi.get(__response__, 'response_time'),
        schemas=pulumi.get(__response__, 'schemas'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        tenancy_ocid=pulumi.get(__response__, 'tenancy_ocid')))
