# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['JmsPluginArgs', 'JmsPlugin']

@pulumi.input_type
class JmsPluginArgs:
    def __init__(__self__, *,
                 agent_id: pulumi.Input[builtins.str],
                 compartment_id: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 fleet_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a JmsPlugin resource.
        :param pulumi.Input[builtins.str] agent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent (OMA) or the Oracle Cloud Agent (OCA) instance where the JMS plugin is deployed.
        :param pulumi.Input[builtins.str] compartment_id: The OMA/OCA agent's compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[builtins.str] fleet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).) 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if fleet_id is not None:
            pulumi.set(__self__, "fleet_id", fleet_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent (OMA) or the Oracle Cloud Agent (OCA) instance where the JMS plugin is deployed.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "agent_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        The OMA/OCA agent's compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the fleet.
        """
        return pulumi.get(self, "fleet_id")

    @fleet_id.setter
    def fleet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fleet_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).) 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _JmsPluginState:
    def __init__(__self__, *,
                 agent_id: Optional[pulumi.Input[builtins.str]] = None,
                 agent_type: Optional[pulumi.Input[builtins.str]] = None,
                 availability_status: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 fleet_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 os_architecture: Optional[pulumi.Input[builtins.str]] = None,
                 os_distribution: Optional[pulumi.Input[builtins.str]] = None,
                 os_family: Optional[pulumi.Input[builtins.str]] = None,
                 plugin_version: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_last_seen: Optional[pulumi.Input[builtins.str]] = None,
                 time_registered: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering JmsPlugin resources.
        :param pulumi.Input[builtins.str] agent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent (OMA) or the Oracle Cloud Agent (OCA) instance where the JMS plugin is deployed.
        :param pulumi.Input[builtins.str] agent_type: The agent type.
        :param pulumi.Input[builtins.str] availability_status: The availability status.
        :param pulumi.Input[builtins.str] compartment_id: The OMA/OCA agent's compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[builtins.str] fleet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).) 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] hostname: The hostname of the agent.
        :param pulumi.Input[builtins.str] os_architecture: The architecture of the operating system of the plugin.
        :param pulumi.Input[builtins.str] os_distribution: The distribution of the operating system of the plugin.
        :param pulumi.Input[builtins.str] os_family: The operating system family for the plugin.
        :param pulumi.Input[builtins.str] plugin_version: The version of the plugin.
        :param pulumi.Input[builtins.str] state: The lifecycle state.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_last_seen: The date and time the resource was _last_ reported to JMS. This is potentially _after_ the specified time period provided by the filters. For example, a resource can be last reported to JMS before the start of a specified time period, if it is also reported during the time period.
        :param pulumi.Input[builtins.str] time_registered: The date and time the plugin was registered.
        """
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if agent_type is not None:
            pulumi.set(__self__, "agent_type", agent_type)
        if availability_status is not None:
            pulumi.set(__self__, "availability_status", availability_status)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if fleet_id is not None:
            pulumi.set(__self__, "fleet_id", fleet_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if os_architecture is not None:
            pulumi.set(__self__, "os_architecture", os_architecture)
        if os_distribution is not None:
            pulumi.set(__self__, "os_distribution", os_distribution)
        if os_family is not None:
            pulumi.set(__self__, "os_family", os_family)
        if plugin_version is not None:
            pulumi.set(__self__, "plugin_version", plugin_version)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_last_seen is not None:
            pulumi.set(__self__, "time_last_seen", time_last_seen)
        if time_registered is not None:
            pulumi.set(__self__, "time_registered", time_registered)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent (OMA) or the Oracle Cloud Agent (OCA) instance where the JMS plugin is deployed.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "agent_id", value)

    @property
    @pulumi.getter(name="agentType")
    def agent_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The agent type.
        """
        return pulumi.get(self, "agent_type")

    @agent_type.setter
    def agent_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "agent_type", value)

    @property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability status.
        """
        return pulumi.get(self, "availability_status")

    @availability_status.setter
    def availability_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_status", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OMA/OCA agent's compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the fleet.
        """
        return pulumi.get(self, "fleet_id")

    @fleet_id.setter
    def fleet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fleet_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).) 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname of the agent.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="osArchitecture")
    def os_architecture(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The architecture of the operating system of the plugin.
        """
        return pulumi.get(self, "os_architecture")

    @os_architecture.setter
    def os_architecture(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_architecture", value)

    @property
    @pulumi.getter(name="osDistribution")
    def os_distribution(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The distribution of the operating system of the plugin.
        """
        return pulumi.get(self, "os_distribution")

    @os_distribution.setter
    def os_distribution(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_distribution", value)

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The operating system family for the plugin.
        """
        return pulumi.get(self, "os_family")

    @os_family.setter
    def os_family(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_family", value)

    @property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the plugin.
        """
        return pulumi.get(self, "plugin_version")

    @plugin_version.setter
    def plugin_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "plugin_version", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The lifecycle state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeLastSeen")
    def time_last_seen(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the resource was _last_ reported to JMS. This is potentially _after_ the specified time period provided by the filters. For example, a resource can be last reported to JMS before the start of a specified time period, if it is also reported during the time period.
        """
        return pulumi.get(self, "time_last_seen")

    @time_last_seen.setter
    def time_last_seen(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_last_seen", value)

    @property
    @pulumi.getter(name="timeRegistered")
    def time_registered(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the plugin was registered.
        """
        return pulumi.get(self, "time_registered")

    @time_registered.setter
    def time_registered(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_registered", value)


@pulumi.type_token("oci:Jms/jmsPlugin:JmsPlugin")
class JmsPlugin(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 fleet_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Jms Plugin resource in Oracle Cloud Infrastructure Jms service.

        Registers an agent's JmsPlugin, optionally attaching to an existing fleet of the tenancy.
        JmsPlugins registered fleet-less are created with lifecycle state INACTIVE.
        For the operation to be authorized, the agent must exist, and the authorized user requires JMS_PLUGIN_CREATE permission for the agent's compartment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_jms_plugin = oci.jms.JmsPlugin("test_jms_plugin",
            agent_id=jms_plugin_agent_id,
            compartment_id=compartment_id,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            fleet_id=test_fleet["id"],
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        JmsPlugins can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Jms/jmsPlugin:JmsPlugin test_jms_plugin "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] agent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent (OMA) or the Oracle Cloud Agent (OCA) instance where the JMS plugin is deployed.
        :param pulumi.Input[builtins.str] compartment_id: The OMA/OCA agent's compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[builtins.str] fleet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).) 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JmsPluginArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Jms Plugin resource in Oracle Cloud Infrastructure Jms service.

        Registers an agent's JmsPlugin, optionally attaching to an existing fleet of the tenancy.
        JmsPlugins registered fleet-less are created with lifecycle state INACTIVE.
        For the operation to be authorized, the agent must exist, and the authorized user requires JMS_PLUGIN_CREATE permission for the agent's compartment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_jms_plugin = oci.jms.JmsPlugin("test_jms_plugin",
            agent_id=jms_plugin_agent_id,
            compartment_id=compartment_id,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            fleet_id=test_fleet["id"],
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        JmsPlugins can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Jms/jmsPlugin:JmsPlugin test_jms_plugin "id"
        ```

        :param str resource_name: The name of the resource.
        :param JmsPluginArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JmsPluginArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 fleet_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JmsPluginArgs.__new__(JmsPluginArgs)

            if agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'agent_id'")
            __props__.__dict__["agent_id"] = agent_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["fleet_id"] = fleet_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["agent_type"] = None
            __props__.__dict__["availability_status"] = None
            __props__.__dict__["hostname"] = None
            __props__.__dict__["os_architecture"] = None
            __props__.__dict__["os_distribution"] = None
            __props__.__dict__["os_family"] = None
            __props__.__dict__["plugin_version"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_last_seen"] = None
            __props__.__dict__["time_registered"] = None
        super(JmsPlugin, __self__).__init__(
            'oci:Jms/jmsPlugin:JmsPlugin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_id: Optional[pulumi.Input[builtins.str]] = None,
            agent_type: Optional[pulumi.Input[builtins.str]] = None,
            availability_status: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            fleet_id: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            hostname: Optional[pulumi.Input[builtins.str]] = None,
            os_architecture: Optional[pulumi.Input[builtins.str]] = None,
            os_distribution: Optional[pulumi.Input[builtins.str]] = None,
            os_family: Optional[pulumi.Input[builtins.str]] = None,
            plugin_version: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_last_seen: Optional[pulumi.Input[builtins.str]] = None,
            time_registered: Optional[pulumi.Input[builtins.str]] = None) -> 'JmsPlugin':
        """
        Get an existing JmsPlugin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] agent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent (OMA) or the Oracle Cloud Agent (OCA) instance where the JMS plugin is deployed.
        :param pulumi.Input[builtins.str] agent_type: The agent type.
        :param pulumi.Input[builtins.str] availability_status: The availability status.
        :param pulumi.Input[builtins.str] compartment_id: The OMA/OCA agent's compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[builtins.str] fleet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).) 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] hostname: The hostname of the agent.
        :param pulumi.Input[builtins.str] os_architecture: The architecture of the operating system of the plugin.
        :param pulumi.Input[builtins.str] os_distribution: The distribution of the operating system of the plugin.
        :param pulumi.Input[builtins.str] os_family: The operating system family for the plugin.
        :param pulumi.Input[builtins.str] plugin_version: The version of the plugin.
        :param pulumi.Input[builtins.str] state: The lifecycle state.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_last_seen: The date and time the resource was _last_ reported to JMS. This is potentially _after_ the specified time period provided by the filters. For example, a resource can be last reported to JMS before the start of a specified time period, if it is also reported during the time period.
        :param pulumi.Input[builtins.str] time_registered: The date and time the plugin was registered.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JmsPluginState.__new__(_JmsPluginState)

        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["agent_type"] = agent_type
        __props__.__dict__["availability_status"] = availability_status
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["fleet_id"] = fleet_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["os_architecture"] = os_architecture
        __props__.__dict__["os_distribution"] = os_distribution
        __props__.__dict__["os_family"] = os_family
        __props__.__dict__["plugin_version"] = plugin_version
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_last_seen"] = time_last_seen
        __props__.__dict__["time_registered"] = time_registered
        return JmsPlugin(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent (OMA) or the Oracle Cloud Agent (OCA) instance where the JMS plugin is deployed.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="agentType")
    def agent_type(self) -> pulumi.Output[builtins.str]:
        """
        The agent type.
        """
        return pulumi.get(self, "agent_type")

    @property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> pulumi.Output[builtins.str]:
        """
        The availability status.
        """
        return pulumi.get(self, "availability_status")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The OMA/OCA agent's compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the fleet.
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).) 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[builtins.str]:
        """
        The hostname of the agent.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="osArchitecture")
    def os_architecture(self) -> pulumi.Output[builtins.str]:
        """
        The architecture of the operating system of the plugin.
        """
        return pulumi.get(self, "os_architecture")

    @property
    @pulumi.getter(name="osDistribution")
    def os_distribution(self) -> pulumi.Output[builtins.str]:
        """
        The distribution of the operating system of the plugin.
        """
        return pulumi.get(self, "os_distribution")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> pulumi.Output[builtins.str]:
        """
        The operating system family for the plugin.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> pulumi.Output[builtins.str]:
        """
        The version of the plugin.
        """
        return pulumi.get(self, "plugin_version")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeLastSeen")
    def time_last_seen(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the resource was _last_ reported to JMS. This is potentially _after_ the specified time period provided by the filters. For example, a resource can be last reported to JMS before the start of a specified time period, if it is also reported during the time period.
        """
        return pulumi.get(self, "time_last_seen")

    @property
    @pulumi.getter(name="timeRegistered")
    def time_registered(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the plugin was registered.
        """
        return pulumi.get(self, "time_registered")

