# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPathRouteSetsResult',
    'AwaitableGetPathRouteSetsResult',
    'get_path_route_sets',
    'get_path_route_sets_output',
]

@pulumi.output_type
class GetPathRouteSetsResult:
    """
    A collection of values returned by getPathRouteSets.
    """
    def __init__(__self__, filters=None, id=None, load_balancer_id=None, path_route_sets=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if load_balancer_id and not isinstance(load_balancer_id, str):
            raise TypeError("Expected argument 'load_balancer_id' to be a str")
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if path_route_sets and not isinstance(path_route_sets, list):
            raise TypeError("Expected argument 'path_route_sets' to be a list")
        pulumi.set(__self__, "path_route_sets", path_route_sets)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPathRouteSetsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> builtins.str:
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="pathRouteSets")
    def path_route_sets(self) -> Sequence['outputs.GetPathRouteSetsPathRouteSetResult']:
        """
        The list of path_route_sets.
        """
        return pulumi.get(self, "path_route_sets")


class AwaitableGetPathRouteSetsResult(GetPathRouteSetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPathRouteSetsResult(
            filters=self.filters,
            id=self.id,
            load_balancer_id=self.load_balancer_id,
            path_route_sets=self.path_route_sets)


def get_path_route_sets(filters: Optional[Sequence[Union['GetPathRouteSetsFilterArgs', 'GetPathRouteSetsFilterArgsDict']]] = None,
                        load_balancer_id: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPathRouteSetsResult:
    """
    This data source provides the list of Path Route Sets in Oracle Cloud Infrastructure Load Balancer service.

    Lists all path route sets associated with the specified load balancer.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_path_route_sets = oci.LoadBalancer.get_path_route_sets(load_balancer_id=test_load_balancer["id"])
    ```


    :param builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the path route sets to retrieve.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['loadBalancerId'] = load_balancer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LoadBalancer/getPathRouteSets:getPathRouteSets', __args__, opts=opts, typ=GetPathRouteSetsResult).value

    return AwaitableGetPathRouteSetsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        load_balancer_id=pulumi.get(__ret__, 'load_balancer_id'),
        path_route_sets=pulumi.get(__ret__, 'path_route_sets'))
def get_path_route_sets_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPathRouteSetsFilterArgs', 'GetPathRouteSetsFilterArgsDict']]]]] = None,
                               load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPathRouteSetsResult]:
    """
    This data source provides the list of Path Route Sets in Oracle Cloud Infrastructure Load Balancer service.

    Lists all path route sets associated with the specified load balancer.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_path_route_sets = oci.LoadBalancer.get_path_route_sets(load_balancer_id=test_load_balancer["id"])
    ```


    :param builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the path route sets to retrieve.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['loadBalancerId'] = load_balancer_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LoadBalancer/getPathRouteSets:getPathRouteSets', __args__, opts=opts, typ=GetPathRouteSetsResult)
    return __ret__.apply(lambda __response__: GetPathRouteSetsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        load_balancer_id=pulumi.get(__response__, 'load_balancer_id'),
        path_route_sets=pulumi.get(__response__, 'path_route_sets')))
