# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ListenerArgs', 'Listener']

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 default_backend_set_name: pulumi.Input[builtins.str],
                 load_balancer_id: pulumi.Input[builtins.str],
                 port: pulumi.Input[builtins.int],
                 protocol: pulumi.Input[builtins.str],
                 connection_configuration: Optional[pulumi.Input['ListenerConnectionConfigurationArgs']] = None,
                 hostname_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path_route_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_set_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ssl_configuration: Optional[pulumi.Input['ListenerSslConfigurationArgs']] = None):
        """
        The set of arguments for constructing a Listener resource.
        :param pulumi.Input[builtins.str] default_backend_set_name: (Updatable) The name of the associated backend set.  Example: `example_backend_set`
        :param pulumi.Input[builtins.str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer on which to add a listener.
        :param pulumi.Input[builtins.int] port: (Updatable) The communication port for the listener.  Example: `80`
        :param pulumi.Input[builtins.str] protocol: (Updatable) The protocol on which the listener accepts connection requests. The supported protocols are HTTP, HTTP2, TCP, and GRPC. You can also use the [ListProtocols](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerProtocol/ListProtocols) operation to get a list of valid protocols.  Example: `HTTP`
        :param pulumi.Input['ListenerConnectionConfigurationArgs'] connection_configuration: (Updatable) Configuration details for the connection between the client and backend servers.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hostname_names: (Updatable) An array of hostname resource names.
        :param pulumi.Input[builtins.str] name: A friendly name for the listener. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_listener`
        :param pulumi.Input[builtins.str] path_route_set_name: (Updatable) Deprecated. Please use `routingPolicies` instead.
               
               The name of the set of path-based routing rules, [PathRouteSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/PathRouteSet/), applied to this listener's traffic.
               
               Example: `example_path_route_set`
        :param pulumi.Input[builtins.str] routing_policy_name: (Updatable) The name of the routing policy applied to this listener's traffic.  Example: `example_routing_policy`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] rule_set_names: (Updatable) The names of the [rule sets](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/RuleSet/) to apply to the listener.  Example: ["example_rule_set"]
        :param pulumi.Input['ListenerSslConfigurationArgs'] ssl_configuration: (Updatable) The load balancer's SSL handling configuration details.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        pulumi.set(__self__, "default_backend_set_name", default_backend_set_name)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if connection_configuration is not None:
            pulumi.set(__self__, "connection_configuration", connection_configuration)
        if hostname_names is not None:
            pulumi.set(__self__, "hostname_names", hostname_names)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_route_set_name is not None:
            pulumi.set(__self__, "path_route_set_name", path_route_set_name)
        if routing_policy_name is not None:
            pulumi.set(__self__, "routing_policy_name", routing_policy_name)
        if rule_set_names is not None:
            pulumi.set(__self__, "rule_set_names", rule_set_names)
        if ssl_configuration is not None:
            pulumi.set(__self__, "ssl_configuration", ssl_configuration)

    @property
    @pulumi.getter(name="defaultBackendSetName")
    def default_backend_set_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The name of the associated backend set.  Example: `example_backend_set`
        """
        return pulumi.get(self, "default_backend_set_name")

    @default_backend_set_name.setter
    def default_backend_set_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "default_backend_set_name", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer on which to add a listener.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) The communication port for the listener.  Example: `80`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The protocol on which the listener accepts connection requests. The supported protocols are HTTP, HTTP2, TCP, and GRPC. You can also use the [ListProtocols](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerProtocol/ListProtocols) operation to get a list of valid protocols.  Example: `HTTP`
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="connectionConfiguration")
    def connection_configuration(self) -> Optional[pulumi.Input['ListenerConnectionConfigurationArgs']]:
        """
        (Updatable) Configuration details for the connection between the client and backend servers.
        """
        return pulumi.get(self, "connection_configuration")

    @connection_configuration.setter
    def connection_configuration(self, value: Optional[pulumi.Input['ListenerConnectionConfigurationArgs']]):
        pulumi.set(self, "connection_configuration", value)

    @property
    @pulumi.getter(name="hostnameNames")
    def hostname_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) An array of hostname resource names.
        """
        return pulumi.get(self, "hostname_names")

    @hostname_names.setter
    def hostname_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "hostname_names", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A friendly name for the listener. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_listener`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pathRouteSetName")
    def path_route_set_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Deprecated. Please use `routingPolicies` instead.

        The name of the set of path-based routing rules, [PathRouteSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/PathRouteSet/), applied to this listener's traffic.

        Example: `example_path_route_set`
        """
        return pulumi.get(self, "path_route_set_name")

    @path_route_set_name.setter
    def path_route_set_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path_route_set_name", value)

    @property
    @pulumi.getter(name="routingPolicyName")
    def routing_policy_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The name of the routing policy applied to this listener's traffic.  Example: `example_routing_policy`
        """
        return pulumi.get(self, "routing_policy_name")

    @routing_policy_name.setter
    def routing_policy_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_policy_name", value)

    @property
    @pulumi.getter(name="ruleSetNames")
    def rule_set_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The names of the [rule sets](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/RuleSet/) to apply to the listener.  Example: ["example_rule_set"]
        """
        return pulumi.get(self, "rule_set_names")

    @rule_set_names.setter
    def rule_set_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "rule_set_names", value)

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> Optional[pulumi.Input['ListenerSslConfigurationArgs']]:
        """
        (Updatable) The load balancer's SSL handling configuration details.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "ssl_configuration")

    @ssl_configuration.setter
    def ssl_configuration(self, value: Optional[pulumi.Input['ListenerSslConfigurationArgs']]):
        pulumi.set(self, "ssl_configuration", value)


@pulumi.input_type
class _ListenerState:
    def __init__(__self__, *,
                 connection_configuration: Optional[pulumi.Input['ListenerConnectionConfigurationArgs']] = None,
                 default_backend_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 hostname_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path_route_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 routing_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_set_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ssl_configuration: Optional[pulumi.Input['ListenerSslConfigurationArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Listener resources.
        :param pulumi.Input['ListenerConnectionConfigurationArgs'] connection_configuration: (Updatable) Configuration details for the connection between the client and backend servers.
        :param pulumi.Input[builtins.str] default_backend_set_name: (Updatable) The name of the associated backend set.  Example: `example_backend_set`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hostname_names: (Updatable) An array of hostname resource names.
        :param pulumi.Input[builtins.str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer on which to add a listener.
        :param pulumi.Input[builtins.str] name: A friendly name for the listener. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_listener`
        :param pulumi.Input[builtins.str] path_route_set_name: (Updatable) Deprecated. Please use `routingPolicies` instead.
               
               The name of the set of path-based routing rules, [PathRouteSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/PathRouteSet/), applied to this listener's traffic.
               
               Example: `example_path_route_set`
        :param pulumi.Input[builtins.int] port: (Updatable) The communication port for the listener.  Example: `80`
        :param pulumi.Input[builtins.str] protocol: (Updatable) The protocol on which the listener accepts connection requests. The supported protocols are HTTP, HTTP2, TCP, and GRPC. You can also use the [ListProtocols](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerProtocol/ListProtocols) operation to get a list of valid protocols.  Example: `HTTP`
        :param pulumi.Input[builtins.str] routing_policy_name: (Updatable) The name of the routing policy applied to this listener's traffic.  Example: `example_routing_policy`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] rule_set_names: (Updatable) The names of the [rule sets](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/RuleSet/) to apply to the listener.  Example: ["example_rule_set"]
        :param pulumi.Input['ListenerSslConfigurationArgs'] ssl_configuration: (Updatable) The load balancer's SSL handling configuration details.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        if connection_configuration is not None:
            pulumi.set(__self__, "connection_configuration", connection_configuration)
        if default_backend_set_name is not None:
            pulumi.set(__self__, "default_backend_set_name", default_backend_set_name)
        if hostname_names is not None:
            pulumi.set(__self__, "hostname_names", hostname_names)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_route_set_name is not None:
            pulumi.set(__self__, "path_route_set_name", path_route_set_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if routing_policy_name is not None:
            pulumi.set(__self__, "routing_policy_name", routing_policy_name)
        if rule_set_names is not None:
            pulumi.set(__self__, "rule_set_names", rule_set_names)
        if ssl_configuration is not None:
            pulumi.set(__self__, "ssl_configuration", ssl_configuration)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="connectionConfiguration")
    def connection_configuration(self) -> Optional[pulumi.Input['ListenerConnectionConfigurationArgs']]:
        """
        (Updatable) Configuration details for the connection between the client and backend servers.
        """
        return pulumi.get(self, "connection_configuration")

    @connection_configuration.setter
    def connection_configuration(self, value: Optional[pulumi.Input['ListenerConnectionConfigurationArgs']]):
        pulumi.set(self, "connection_configuration", value)

    @property
    @pulumi.getter(name="defaultBackendSetName")
    def default_backend_set_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The name of the associated backend set.  Example: `example_backend_set`
        """
        return pulumi.get(self, "default_backend_set_name")

    @default_backend_set_name.setter
    def default_backend_set_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_backend_set_name", value)

    @property
    @pulumi.getter(name="hostnameNames")
    def hostname_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) An array of hostname resource names.
        """
        return pulumi.get(self, "hostname_names")

    @hostname_names.setter
    def hostname_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "hostname_names", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer on which to add a listener.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A friendly name for the listener. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_listener`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pathRouteSetName")
    def path_route_set_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Deprecated. Please use `routingPolicies` instead.

        The name of the set of path-based routing rules, [PathRouteSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/PathRouteSet/), applied to this listener's traffic.

        Example: `example_path_route_set`
        """
        return pulumi.get(self, "path_route_set_name")

    @path_route_set_name.setter
    def path_route_set_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path_route_set_name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The communication port for the listener.  Example: `80`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The protocol on which the listener accepts connection requests. The supported protocols are HTTP, HTTP2, TCP, and GRPC. You can also use the [ListProtocols](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerProtocol/ListProtocols) operation to get a list of valid protocols.  Example: `HTTP`
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="routingPolicyName")
    def routing_policy_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The name of the routing policy applied to this listener's traffic.  Example: `example_routing_policy`
        """
        return pulumi.get(self, "routing_policy_name")

    @routing_policy_name.setter
    def routing_policy_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_policy_name", value)

    @property
    @pulumi.getter(name="ruleSetNames")
    def rule_set_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The names of the [rule sets](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/RuleSet/) to apply to the listener.  Example: ["example_rule_set"]
        """
        return pulumi.get(self, "rule_set_names")

    @rule_set_names.setter
    def rule_set_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "rule_set_names", value)

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> Optional[pulumi.Input['ListenerSslConfigurationArgs']]:
        """
        (Updatable) The load balancer's SSL handling configuration details.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "ssl_configuration")

    @ssl_configuration.setter
    def ssl_configuration(self, value: Optional[pulumi.Input['ListenerSslConfigurationArgs']]):
        pulumi.set(self, "ssl_configuration", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("oci:LoadBalancer/listener:Listener")
class Listener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_configuration: Optional[pulumi.Input[Union['ListenerConnectionConfigurationArgs', 'ListenerConnectionConfigurationArgsDict']]] = None,
                 default_backend_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 hostname_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path_route_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 routing_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_set_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ssl_configuration: Optional[pulumi.Input[Union['ListenerSslConfigurationArgs', 'ListenerSslConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Listener resource in Oracle Cloud Infrastructure Load Balancer service.

        Adds a listener to a load balancer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_listener = oci.load_balancer.Listener("test_listener",
            default_backend_set_name=test_backend_set["name"],
            load_balancer_id=test_load_balancer["id"],
            name=listener_name,
            port=listener_port,
            protocol=listener_protocol,
            connection_configuration={
                "idle_timeout_in_seconds": listener_connection_configuration_idle_timeout_in_seconds,
                "backend_tcp_proxy_protocol_options": listener_connection_configuration_backend_tcp_proxy_protocol_options,
                "backend_tcp_proxy_protocol_version": listener_connection_configuration_backend_tcp_proxy_protocol_version,
            },
            hostname_names=[test_hostname["name"]],
            path_route_set_name=test_path_route_set["name"],
            routing_policy_name=test_load_balancer_routing_policy["name"],
            rule_set_names=[test_rule_set["name"]],
            ssl_configuration={
                "certificate_name": test_certificate["name"],
                "has_session_resumption": listener_ssl_configuration_has_session_resumption,
                "certificate_ids": listener_ssl_configuration_certificate_ids,
                "cipher_suite_name": listener_ssl_configuration_cipher_suite_name,
                "protocols": listener_ssl_configuration_protocols,
                "server_order_preference": listener_ssl_configuration_server_order_preference,
                "trusted_certificate_authority_ids": listener_ssl_configuration_trusted_certificate_authority_ids,
                "verify_depth": listener_ssl_configuration_verify_depth,
                "verify_peer_certificate": listener_ssl_configuration_verify_peer_certificate,
            })
        ```

        ## Import

        Listeners can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LoadBalancer/listener:Listener test_listener "loadBalancers/{loadBalancerId}/listeners/{listenerName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ListenerConnectionConfigurationArgs', 'ListenerConnectionConfigurationArgsDict']] connection_configuration: (Updatable) Configuration details for the connection between the client and backend servers.
        :param pulumi.Input[builtins.str] default_backend_set_name: (Updatable) The name of the associated backend set.  Example: `example_backend_set`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hostname_names: (Updatable) An array of hostname resource names.
        :param pulumi.Input[builtins.str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer on which to add a listener.
        :param pulumi.Input[builtins.str] name: A friendly name for the listener. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_listener`
        :param pulumi.Input[builtins.str] path_route_set_name: (Updatable) Deprecated. Please use `routingPolicies` instead.
               
               The name of the set of path-based routing rules, [PathRouteSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/PathRouteSet/), applied to this listener's traffic.
               
               Example: `example_path_route_set`
        :param pulumi.Input[builtins.int] port: (Updatable) The communication port for the listener.  Example: `80`
        :param pulumi.Input[builtins.str] protocol: (Updatable) The protocol on which the listener accepts connection requests. The supported protocols are HTTP, HTTP2, TCP, and GRPC. You can also use the [ListProtocols](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerProtocol/ListProtocols) operation to get a list of valid protocols.  Example: `HTTP`
        :param pulumi.Input[builtins.str] routing_policy_name: (Updatable) The name of the routing policy applied to this listener's traffic.  Example: `example_routing_policy`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] rule_set_names: (Updatable) The names of the [rule sets](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/RuleSet/) to apply to the listener.  Example: ["example_rule_set"]
        :param pulumi.Input[Union['ListenerSslConfigurationArgs', 'ListenerSslConfigurationArgsDict']] ssl_configuration: (Updatable) The load balancer's SSL handling configuration details.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Listener resource in Oracle Cloud Infrastructure Load Balancer service.

        Adds a listener to a load balancer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_listener = oci.load_balancer.Listener("test_listener",
            default_backend_set_name=test_backend_set["name"],
            load_balancer_id=test_load_balancer["id"],
            name=listener_name,
            port=listener_port,
            protocol=listener_protocol,
            connection_configuration={
                "idle_timeout_in_seconds": listener_connection_configuration_idle_timeout_in_seconds,
                "backend_tcp_proxy_protocol_options": listener_connection_configuration_backend_tcp_proxy_protocol_options,
                "backend_tcp_proxy_protocol_version": listener_connection_configuration_backend_tcp_proxy_protocol_version,
            },
            hostname_names=[test_hostname["name"]],
            path_route_set_name=test_path_route_set["name"],
            routing_policy_name=test_load_balancer_routing_policy["name"],
            rule_set_names=[test_rule_set["name"]],
            ssl_configuration={
                "certificate_name": test_certificate["name"],
                "has_session_resumption": listener_ssl_configuration_has_session_resumption,
                "certificate_ids": listener_ssl_configuration_certificate_ids,
                "cipher_suite_name": listener_ssl_configuration_cipher_suite_name,
                "protocols": listener_ssl_configuration_protocols,
                "server_order_preference": listener_ssl_configuration_server_order_preference,
                "trusted_certificate_authority_ids": listener_ssl_configuration_trusted_certificate_authority_ids,
                "verify_depth": listener_ssl_configuration_verify_depth,
                "verify_peer_certificate": listener_ssl_configuration_verify_peer_certificate,
            })
        ```

        ## Import

        Listeners can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LoadBalancer/listener:Listener test_listener "loadBalancers/{loadBalancerId}/listeners/{listenerName}"
        ```

        :param str resource_name: The name of the resource.
        :param ListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_configuration: Optional[pulumi.Input[Union['ListenerConnectionConfigurationArgs', 'ListenerConnectionConfigurationArgsDict']]] = None,
                 default_backend_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 hostname_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path_route_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 routing_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_set_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ssl_configuration: Optional[pulumi.Input[Union['ListenerSslConfigurationArgs', 'ListenerSslConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerArgs.__new__(ListenerArgs)

            __props__.__dict__["connection_configuration"] = connection_configuration
            if default_backend_set_name is None and not opts.urn:
                raise TypeError("Missing required property 'default_backend_set_name'")
            __props__.__dict__["default_backend_set_name"] = default_backend_set_name
            __props__.__dict__["hostname_names"] = hostname_names
            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            __props__.__dict__["name"] = name
            __props__.__dict__["path_route_set_name"] = path_route_set_name
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["routing_policy_name"] = routing_policy_name
            __props__.__dict__["rule_set_names"] = rule_set_names
            __props__.__dict__["ssl_configuration"] = ssl_configuration
            __props__.__dict__["state"] = None
        super(Listener, __self__).__init__(
            'oci:LoadBalancer/listener:Listener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_configuration: Optional[pulumi.Input[Union['ListenerConnectionConfigurationArgs', 'ListenerConnectionConfigurationArgsDict']]] = None,
            default_backend_set_name: Optional[pulumi.Input[builtins.str]] = None,
            hostname_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            path_route_set_name: Optional[pulumi.Input[builtins.str]] = None,
            port: Optional[pulumi.Input[builtins.int]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None,
            routing_policy_name: Optional[pulumi.Input[builtins.str]] = None,
            rule_set_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ssl_configuration: Optional[pulumi.Input[Union['ListenerSslConfigurationArgs', 'ListenerSslConfigurationArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None) -> 'Listener':
        """
        Get an existing Listener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ListenerConnectionConfigurationArgs', 'ListenerConnectionConfigurationArgsDict']] connection_configuration: (Updatable) Configuration details for the connection between the client and backend servers.
        :param pulumi.Input[builtins.str] default_backend_set_name: (Updatable) The name of the associated backend set.  Example: `example_backend_set`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hostname_names: (Updatable) An array of hostname resource names.
        :param pulumi.Input[builtins.str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer on which to add a listener.
        :param pulumi.Input[builtins.str] name: A friendly name for the listener. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_listener`
        :param pulumi.Input[builtins.str] path_route_set_name: (Updatable) Deprecated. Please use `routingPolicies` instead.
               
               The name of the set of path-based routing rules, [PathRouteSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/PathRouteSet/), applied to this listener's traffic.
               
               Example: `example_path_route_set`
        :param pulumi.Input[builtins.int] port: (Updatable) The communication port for the listener.  Example: `80`
        :param pulumi.Input[builtins.str] protocol: (Updatable) The protocol on which the listener accepts connection requests. The supported protocols are HTTP, HTTP2, TCP, and GRPC. You can also use the [ListProtocols](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerProtocol/ListProtocols) operation to get a list of valid protocols.  Example: `HTTP`
        :param pulumi.Input[builtins.str] routing_policy_name: (Updatable) The name of the routing policy applied to this listener's traffic.  Example: `example_routing_policy`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] rule_set_names: (Updatable) The names of the [rule sets](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/RuleSet/) to apply to the listener.  Example: ["example_rule_set"]
        :param pulumi.Input[Union['ListenerSslConfigurationArgs', 'ListenerSslConfigurationArgsDict']] ssl_configuration: (Updatable) The load balancer's SSL handling configuration details.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerState.__new__(_ListenerState)

        __props__.__dict__["connection_configuration"] = connection_configuration
        __props__.__dict__["default_backend_set_name"] = default_backend_set_name
        __props__.__dict__["hostname_names"] = hostname_names
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["path_route_set_name"] = path_route_set_name
        __props__.__dict__["port"] = port
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["routing_policy_name"] = routing_policy_name
        __props__.__dict__["rule_set_names"] = rule_set_names
        __props__.__dict__["ssl_configuration"] = ssl_configuration
        __props__.__dict__["state"] = state
        return Listener(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectionConfiguration")
    def connection_configuration(self) -> pulumi.Output['outputs.ListenerConnectionConfiguration']:
        """
        (Updatable) Configuration details for the connection between the client and backend servers.
        """
        return pulumi.get(self, "connection_configuration")

    @property
    @pulumi.getter(name="defaultBackendSetName")
    def default_backend_set_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The name of the associated backend set.  Example: `example_backend_set`
        """
        return pulumi.get(self, "default_backend_set_name")

    @property
    @pulumi.getter(name="hostnameNames")
    def hostname_names(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) An array of hostname resource names.
        """
        return pulumi.get(self, "hostname_names")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer on which to add a listener.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A friendly name for the listener. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_listener`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pathRouteSetName")
    def path_route_set_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) Deprecated. Please use `routingPolicies` instead.

        The name of the set of path-based routing rules, [PathRouteSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/PathRouteSet/), applied to this listener's traffic.

        Example: `example_path_route_set`
        """
        return pulumi.get(self, "path_route_set_name")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The communication port for the listener.  Example: `80`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The protocol on which the listener accepts connection requests. The supported protocols are HTTP, HTTP2, TCP, and GRPC. You can also use the [ListProtocols](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerProtocol/ListProtocols) operation to get a list of valid protocols.  Example: `HTTP`
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="routingPolicyName")
    def routing_policy_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) The name of the routing policy applied to this listener's traffic.  Example: `example_routing_policy`
        """
        return pulumi.get(self, "routing_policy_name")

    @property
    @pulumi.getter(name="ruleSetNames")
    def rule_set_names(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) The names of the [rule sets](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/RuleSet/) to apply to the listener.  Example: ["example_rule_set"]
        """
        return pulumi.get(self, "rule_set_names")

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> pulumi.Output[Optional['outputs.ListenerSslConfiguration']]:
        """
        (Updatable) The load balancer's SSL handling configuration details.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "ssl_configuration")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "state")

