# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UsageCarbonEmissionsQueryArgs', 'UsageCarbonEmissionsQuery']

@pulumi.input_type
class UsageCarbonEmissionsQueryArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 query_definition: pulumi.Input['UsageCarbonEmissionsQueryQueryDefinitionArgs']):
        """
        The set of arguments for constructing a UsageCarbonEmissionsQuery resource.
        :param pulumi.Input[builtins.str] compartment_id: The compartment OCID.
        :param pulumi.Input['UsageCarbonEmissionsQueryQueryDefinitionArgs'] query_definition: (Updatable) The common fields for queries.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "query_definition", query_definition)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="queryDefinition")
    def query_definition(self) -> pulumi.Input['UsageCarbonEmissionsQueryQueryDefinitionArgs']:
        """
        (Updatable) The common fields for queries.
        """
        return pulumi.get(self, "query_definition")

    @query_definition.setter
    def query_definition(self, value: pulumi.Input['UsageCarbonEmissionsQueryQueryDefinitionArgs']):
        pulumi.set(self, "query_definition", value)


@pulumi.input_type
class _UsageCarbonEmissionsQueryState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 query_definition: Optional[pulumi.Input['UsageCarbonEmissionsQueryQueryDefinitionArgs']] = None):
        """
        Input properties used for looking up and filtering UsageCarbonEmissionsQuery resources.
        :param pulumi.Input[builtins.str] compartment_id: The compartment OCID.
        :param pulumi.Input['UsageCarbonEmissionsQueryQueryDefinitionArgs'] query_definition: (Updatable) The common fields for queries.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if query_definition is not None:
            pulumi.set(__self__, "query_definition", query_definition)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="queryDefinition")
    def query_definition(self) -> Optional[pulumi.Input['UsageCarbonEmissionsQueryQueryDefinitionArgs']]:
        """
        (Updatable) The common fields for queries.
        """
        return pulumi.get(self, "query_definition")

    @query_definition.setter
    def query_definition(self, value: Optional[pulumi.Input['UsageCarbonEmissionsQueryQueryDefinitionArgs']]):
        pulumi.set(self, "query_definition", value)


@pulumi.type_token("oci:MeteringComputation/usageCarbonEmissionsQuery:UsageCarbonEmissionsQuery")
class UsageCarbonEmissionsQuery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 query_definition: Optional[pulumi.Input[Union['UsageCarbonEmissionsQueryQueryDefinitionArgs', 'UsageCarbonEmissionsQueryQueryDefinitionArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Usage Carbon Emissions Query resource in Oracle Cloud Infrastructure Metering Computation service.

        Returns the created usage carbon emissions query.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_usage_carbon_emissions_query = oci.metering_computation.UsageCarbonEmissionsQuery("test_usage_carbon_emissions_query",
            compartment_id=compartment_id,
            query_definition={
                "cost_analysis_ui": {
                    "graph": usage_carbon_emissions_query_query_definition_cost_analysis_ui_graph,
                    "is_cumulative_graph": usage_carbon_emissions_query_query_definition_cost_analysis_ui_is_cumulative_graph,
                },
                "display_name": usage_carbon_emissions_query_query_definition_display_name,
                "report_query": {
                    "tenant_id": test_tenant["id"],
                    "compartment_depth": usage_carbon_emissions_query_query_definition_report_query_compartment_depth,
                    "date_range_name": usage_carbon_emissions_query_query_definition_report_query_date_range_name,
                    "group_bies": usage_carbon_emissions_query_query_definition_report_query_group_by,
                    "group_by_tags": [{
                        "key": usage_carbon_emissions_query_query_definition_report_query_group_by_tag_key,
                        "namespace": usage_carbon_emissions_query_query_definition_report_query_group_by_tag_namespace,
                        "value": usage_carbon_emissions_query_query_definition_report_query_group_by_tag_value,
                    }],
                    "is_aggregate_by_time": usage_carbon_emissions_query_query_definition_report_query_is_aggregate_by_time,
                    "time_usage_ended": usage_carbon_emissions_query_query_definition_report_query_time_usage_ended,
                    "time_usage_started": usage_carbon_emissions_query_query_definition_report_query_time_usage_started,
                    "usage_carbon_emissions_query_filter": usage_carbon_emissions_query_query_definition_report_query_usage_carbon_emissions_query_filter,
                },
                "version": usage_carbon_emissions_query_query_definition_version,
            })
        ```

        ## Import

        UsageCarbonEmissionsQueries can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:MeteringComputation/usageCarbonEmissionsQuery:UsageCarbonEmissionsQuery test_usage_carbon_emissions_query "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The compartment OCID.
        :param pulumi.Input[Union['UsageCarbonEmissionsQueryQueryDefinitionArgs', 'UsageCarbonEmissionsQueryQueryDefinitionArgsDict']] query_definition: (Updatable) The common fields for queries.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UsageCarbonEmissionsQueryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Usage Carbon Emissions Query resource in Oracle Cloud Infrastructure Metering Computation service.

        Returns the created usage carbon emissions query.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_usage_carbon_emissions_query = oci.metering_computation.UsageCarbonEmissionsQuery("test_usage_carbon_emissions_query",
            compartment_id=compartment_id,
            query_definition={
                "cost_analysis_ui": {
                    "graph": usage_carbon_emissions_query_query_definition_cost_analysis_ui_graph,
                    "is_cumulative_graph": usage_carbon_emissions_query_query_definition_cost_analysis_ui_is_cumulative_graph,
                },
                "display_name": usage_carbon_emissions_query_query_definition_display_name,
                "report_query": {
                    "tenant_id": test_tenant["id"],
                    "compartment_depth": usage_carbon_emissions_query_query_definition_report_query_compartment_depth,
                    "date_range_name": usage_carbon_emissions_query_query_definition_report_query_date_range_name,
                    "group_bies": usage_carbon_emissions_query_query_definition_report_query_group_by,
                    "group_by_tags": [{
                        "key": usage_carbon_emissions_query_query_definition_report_query_group_by_tag_key,
                        "namespace": usage_carbon_emissions_query_query_definition_report_query_group_by_tag_namespace,
                        "value": usage_carbon_emissions_query_query_definition_report_query_group_by_tag_value,
                    }],
                    "is_aggregate_by_time": usage_carbon_emissions_query_query_definition_report_query_is_aggregate_by_time,
                    "time_usage_ended": usage_carbon_emissions_query_query_definition_report_query_time_usage_ended,
                    "time_usage_started": usage_carbon_emissions_query_query_definition_report_query_time_usage_started,
                    "usage_carbon_emissions_query_filter": usage_carbon_emissions_query_query_definition_report_query_usage_carbon_emissions_query_filter,
                },
                "version": usage_carbon_emissions_query_query_definition_version,
            })
        ```

        ## Import

        UsageCarbonEmissionsQueries can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:MeteringComputation/usageCarbonEmissionsQuery:UsageCarbonEmissionsQuery test_usage_carbon_emissions_query "id"
        ```

        :param str resource_name: The name of the resource.
        :param UsageCarbonEmissionsQueryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UsageCarbonEmissionsQueryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 query_definition: Optional[pulumi.Input[Union['UsageCarbonEmissionsQueryQueryDefinitionArgs', 'UsageCarbonEmissionsQueryQueryDefinitionArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UsageCarbonEmissionsQueryArgs.__new__(UsageCarbonEmissionsQueryArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if query_definition is None and not opts.urn:
                raise TypeError("Missing required property 'query_definition'")
            __props__.__dict__["query_definition"] = query_definition
        super(UsageCarbonEmissionsQuery, __self__).__init__(
            'oci:MeteringComputation/usageCarbonEmissionsQuery:UsageCarbonEmissionsQuery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            query_definition: Optional[pulumi.Input[Union['UsageCarbonEmissionsQueryQueryDefinitionArgs', 'UsageCarbonEmissionsQueryQueryDefinitionArgsDict']]] = None) -> 'UsageCarbonEmissionsQuery':
        """
        Get an existing UsageCarbonEmissionsQuery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The compartment OCID.
        :param pulumi.Input[Union['UsageCarbonEmissionsQueryQueryDefinitionArgs', 'UsageCarbonEmissionsQueryQueryDefinitionArgsDict']] query_definition: (Updatable) The common fields for queries.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UsageCarbonEmissionsQueryState.__new__(_UsageCarbonEmissionsQueryState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["query_definition"] = query_definition
        return UsageCarbonEmissionsQuery(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="queryDefinition")
    def query_definition(self) -> pulumi.Output['outputs.UsageCarbonEmissionsQueryQueryDefinition']:
        """
        (Updatable) The common fields for queries.
        """
        return pulumi.get(self, "query_definition")

