# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UsageStatementEmailRecipientsGroupArgs', 'UsageStatementEmailRecipientsGroup']

@pulumi.input_type
class UsageStatementEmailRecipientsGroupArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 recipients_lists: pulumi.Input[Sequence[pulumi.Input['UsageStatementEmailRecipientsGroupRecipientsListArgs']]],
                 subscription_id: pulumi.Input[builtins.str],
                 email_recipients_group_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a UsageStatementEmailRecipientsGroup resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The customer tenancy.
        :param pulumi.Input[Sequence[pulumi.Input['UsageStatementEmailRecipientsGroupRecipientsListArgs']]] recipients_lists: (Updatable) The list of recipient will receive the usage statement email.
        :param pulumi.Input[builtins.str] subscription_id: The UsageStatement Subscription unique OCID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "recipients_lists", recipients_lists)
        pulumi.set(__self__, "subscription_id", subscription_id)
        if email_recipients_group_id is not None:
            pulumi.set(__self__, "email_recipients_group_id", email_recipients_group_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The customer tenancy.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="recipientsLists")
    def recipients_lists(self) -> pulumi.Input[Sequence[pulumi.Input['UsageStatementEmailRecipientsGroupRecipientsListArgs']]]:
        """
        (Updatable) The list of recipient will receive the usage statement email.
        """
        return pulumi.get(self, "recipients_lists")

    @recipients_lists.setter
    def recipients_lists(self, value: pulumi.Input[Sequence[pulumi.Input['UsageStatementEmailRecipientsGroupRecipientsListArgs']]]):
        pulumi.set(self, "recipients_lists", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Input[builtins.str]:
        """
        The UsageStatement Subscription unique OCID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="emailRecipientsGroupId")
    def email_recipients_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "email_recipients_group_id")

    @email_recipients_group_id.setter
    def email_recipients_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email_recipients_group_id", value)


@pulumi.input_type
class _UsageStatementEmailRecipientsGroupState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 email_recipients_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 recipients_lists: Optional[pulumi.Input[Sequence[pulumi.Input['UsageStatementEmailRecipientsGroupRecipientsListArgs']]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering UsageStatementEmailRecipientsGroup resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The customer tenancy.
        :param pulumi.Input[Sequence[pulumi.Input['UsageStatementEmailRecipientsGroupRecipientsListArgs']]] recipients_lists: (Updatable) The list of recipient will receive the usage statement email.
        :param pulumi.Input[builtins.str] state: The email recipient group lifecycle state.
        :param pulumi.Input[builtins.str] subscription_id: The UsageStatement Subscription unique OCID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if email_recipients_group_id is not None:
            pulumi.set(__self__, "email_recipients_group_id", email_recipients_group_id)
        if recipients_lists is not None:
            pulumi.set(__self__, "recipients_lists", recipients_lists)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The customer tenancy.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="emailRecipientsGroupId")
    def email_recipients_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "email_recipients_group_id")

    @email_recipients_group_id.setter
    def email_recipients_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email_recipients_group_id", value)

    @property
    @pulumi.getter(name="recipientsLists")
    def recipients_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UsageStatementEmailRecipientsGroupRecipientsListArgs']]]]:
        """
        (Updatable) The list of recipient will receive the usage statement email.
        """
        return pulumi.get(self, "recipients_lists")

    @recipients_lists.setter
    def recipients_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UsageStatementEmailRecipientsGroupRecipientsListArgs']]]]):
        pulumi.set(self, "recipients_lists", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email recipient group lifecycle state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UsageStatement Subscription unique OCID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.type_token("oci:MeteringComputation/usageStatementEmailRecipientsGroup:UsageStatementEmailRecipientsGroup")
class UsageStatementEmailRecipientsGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 email_recipients_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 recipients_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UsageStatementEmailRecipientsGroupRecipientsListArgs', 'UsageStatementEmailRecipientsGroupRecipientsListArgsDict']]]]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Usage Statement Email Recipients Group resource in Oracle Cloud Infrastructure Metering Computation service.

        Add a list of email recipients that can receive usage statements for the subscription.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_usage_statement_email_recipients_group = oci.metering_computation.UsageStatementEmailRecipientsGroup("test_usage_statement_email_recipients_group",
            compartment_id=compartment_id,
            recipients_lists=[{
                "email_id": test_email["id"],
                "state": usage_statement_email_recipients_group_recipients_list_state,
                "first_name": usage_statement_email_recipients_group_recipients_list_first_name,
                "last_name": usage_statement_email_recipients_group_recipients_list_last_name,
            }],
            subscription_id=test_subscription["id"])
        ```

        ## Import

        UsageStatementEmailRecipientsGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:MeteringComputation/usageStatementEmailRecipientsGroup:UsageStatementEmailRecipientsGroup test_usage_statement_email_recipients_group "usageStatements/{subscriptionId}/emailRecipientsGroups/{emailRecipientsGroupId}/compartmentId/{compartmentId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The customer tenancy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UsageStatementEmailRecipientsGroupRecipientsListArgs', 'UsageStatementEmailRecipientsGroupRecipientsListArgsDict']]]] recipients_lists: (Updatable) The list of recipient will receive the usage statement email.
        :param pulumi.Input[builtins.str] subscription_id: The UsageStatement Subscription unique OCID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UsageStatementEmailRecipientsGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Usage Statement Email Recipients Group resource in Oracle Cloud Infrastructure Metering Computation service.

        Add a list of email recipients that can receive usage statements for the subscription.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_usage_statement_email_recipients_group = oci.metering_computation.UsageStatementEmailRecipientsGroup("test_usage_statement_email_recipients_group",
            compartment_id=compartment_id,
            recipients_lists=[{
                "email_id": test_email["id"],
                "state": usage_statement_email_recipients_group_recipients_list_state,
                "first_name": usage_statement_email_recipients_group_recipients_list_first_name,
                "last_name": usage_statement_email_recipients_group_recipients_list_last_name,
            }],
            subscription_id=test_subscription["id"])
        ```

        ## Import

        UsageStatementEmailRecipientsGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:MeteringComputation/usageStatementEmailRecipientsGroup:UsageStatementEmailRecipientsGroup test_usage_statement_email_recipients_group "usageStatements/{subscriptionId}/emailRecipientsGroups/{emailRecipientsGroupId}/compartmentId/{compartmentId}"
        ```

        :param str resource_name: The name of the resource.
        :param UsageStatementEmailRecipientsGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UsageStatementEmailRecipientsGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 email_recipients_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 recipients_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UsageStatementEmailRecipientsGroupRecipientsListArgs', 'UsageStatementEmailRecipientsGroupRecipientsListArgsDict']]]]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UsageStatementEmailRecipientsGroupArgs.__new__(UsageStatementEmailRecipientsGroupArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["email_recipients_group_id"] = email_recipients_group_id
            if recipients_lists is None and not opts.urn:
                raise TypeError("Missing required property 'recipients_lists'")
            __props__.__dict__["recipients_lists"] = recipients_lists
            if subscription_id is None and not opts.urn:
                raise TypeError("Missing required property 'subscription_id'")
            __props__.__dict__["subscription_id"] = subscription_id
            __props__.__dict__["state"] = None
        super(UsageStatementEmailRecipientsGroup, __self__).__init__(
            'oci:MeteringComputation/usageStatementEmailRecipientsGroup:UsageStatementEmailRecipientsGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            email_recipients_group_id: Optional[pulumi.Input[builtins.str]] = None,
            recipients_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UsageStatementEmailRecipientsGroupRecipientsListArgs', 'UsageStatementEmailRecipientsGroupRecipientsListArgsDict']]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            subscription_id: Optional[pulumi.Input[builtins.str]] = None) -> 'UsageStatementEmailRecipientsGroup':
        """
        Get an existing UsageStatementEmailRecipientsGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The customer tenancy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UsageStatementEmailRecipientsGroupRecipientsListArgs', 'UsageStatementEmailRecipientsGroupRecipientsListArgsDict']]]] recipients_lists: (Updatable) The list of recipient will receive the usage statement email.
        :param pulumi.Input[builtins.str] state: The email recipient group lifecycle state.
        :param pulumi.Input[builtins.str] subscription_id: The UsageStatement Subscription unique OCID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UsageStatementEmailRecipientsGroupState.__new__(_UsageStatementEmailRecipientsGroupState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["email_recipients_group_id"] = email_recipients_group_id
        __props__.__dict__["recipients_lists"] = recipients_lists
        __props__.__dict__["state"] = state
        __props__.__dict__["subscription_id"] = subscription_id
        return UsageStatementEmailRecipientsGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The customer tenancy.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="emailRecipientsGroupId")
    def email_recipients_group_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "email_recipients_group_id")

    @property
    @pulumi.getter(name="recipientsLists")
    def recipients_lists(self) -> pulumi.Output[Sequence['outputs.UsageStatementEmailRecipientsGroupRecipientsList']]:
        """
        (Updatable) The list of recipient will receive the usage statement email.
        """
        return pulumi.get(self, "recipients_lists")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The email recipient group lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[builtins.str]:
        """
        The UsageStatement Subscription unique OCID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subscription_id")

