# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SoftwareSourceArgs', 'SoftwareSource']

@pulumi.input_type
class SoftwareSourceArgs:
    def __init__(__self__, *,
                 arch_type: pulumi.Input[builtins.str],
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 checksum_type: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 maintainer_email: Optional[pulumi.Input[builtins.str]] = None,
                 maintainer_name: Optional[pulumi.Input[builtins.str]] = None,
                 maintainer_phone: Optional[pulumi.Input[builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SoftwareSource resource.
        :param pulumi.Input[builtins.str] arch_type: The architecture type supported by the Software Source
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) OCID for the Compartment
        :param pulumi.Input[builtins.str] display_name: (Updatable) User friendly name for the software source
        :param pulumi.Input[builtins.str] checksum_type: (Updatable) The yum repository checksum type used by this software source
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Information specified by the user about the software source
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] maintainer_email: (Updatable) Email address of the person maintaining this software source
        :param pulumi.Input[builtins.str] maintainer_name: (Updatable) Name of the person maintaining this software source
        :param pulumi.Input[builtins.str] maintainer_phone: (Updatable) Phone number of the person maintaining this software source
        :param pulumi.Input[builtins.str] parent_id: OCID for the parent software source, if there is one
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "arch_type", arch_type)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        if checksum_type is not None:
            pulumi.set(__self__, "checksum_type", checksum_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if maintainer_email is not None:
            pulumi.set(__self__, "maintainer_email", maintainer_email)
        if maintainer_name is not None:
            pulumi.set(__self__, "maintainer_name", maintainer_name)
        if maintainer_phone is not None:
            pulumi.set(__self__, "maintainer_phone", maintainer_phone)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> pulumi.Input[builtins.str]:
        """
        The architecture type supported by the Software Source
        """
        return pulumi.get(self, "arch_type")

    @arch_type.setter
    def arch_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "arch_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) OCID for the Compartment
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) User friendly name for the software source
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="checksumType")
    def checksum_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The yum repository checksum type used by this software source
        """
        return pulumi.get(self, "checksum_type")

    @checksum_type.setter
    def checksum_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "checksum_type", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Information specified by the user about the software source
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="maintainerEmail")
    def maintainer_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Email address of the person maintaining this software source
        """
        return pulumi.get(self, "maintainer_email")

    @maintainer_email.setter
    def maintainer_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintainer_email", value)

    @property
    @pulumi.getter(name="maintainerName")
    def maintainer_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Name of the person maintaining this software source
        """
        return pulumi.get(self, "maintainer_name")

    @maintainer_name.setter
    def maintainer_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintainer_name", value)

    @property
    @pulumi.getter(name="maintainerPhone")
    def maintainer_phone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Phone number of the person maintaining this software source
        """
        return pulumi.get(self, "maintainer_phone")

    @maintainer_phone.setter
    def maintainer_phone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintainer_phone", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID for the parent software source, if there is one


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_id", value)


@pulumi.input_type
class _SoftwareSourceState:
    def __init__(__self__, *,
                 arch_type: Optional[pulumi.Input[builtins.str]] = None,
                 associated_managed_instances: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareSourceAssociatedManagedInstanceArgs']]]] = None,
                 checksum_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 gpg_key_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 gpg_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 gpg_key_url: Optional[pulumi.Input[builtins.str]] = None,
                 maintainer_email: Optional[pulumi.Input[builtins.str]] = None,
                 maintainer_name: Optional[pulumi.Input[builtins.str]] = None,
                 maintainer_phone: Optional[pulumi.Input[builtins.str]] = None,
                 packages: Optional[pulumi.Input[builtins.int]] = None,
                 parent_id: Optional[pulumi.Input[builtins.str]] = None,
                 parent_name: Optional[pulumi.Input[builtins.str]] = None,
                 repo_type: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SoftwareSource resources.
        :param pulumi.Input[builtins.str] arch_type: The architecture type supported by the Software Source
        :param pulumi.Input[Sequence[pulumi.Input['SoftwareSourceAssociatedManagedInstanceArgs']]] associated_managed_instances: list of the Managed Instances associated with this Software Sources
        :param pulumi.Input[builtins.str] checksum_type: (Updatable) The yum repository checksum type used by this software source
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) OCID for the Compartment
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Information specified by the user about the software source
        :param pulumi.Input[builtins.str] display_name: (Updatable) User friendly name for the software source
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] gpg_key_fingerprint: Fingerprint of the GPG key for this software source
        :param pulumi.Input[builtins.str] gpg_key_id: ID of the GPG key for this software source
        :param pulumi.Input[builtins.str] gpg_key_url: URL of the GPG key for this software source
        :param pulumi.Input[builtins.str] maintainer_email: (Updatable) Email address of the person maintaining this software source
        :param pulumi.Input[builtins.str] maintainer_name: (Updatable) Name of the person maintaining this software source
        :param pulumi.Input[builtins.str] maintainer_phone: (Updatable) Phone number of the person maintaining this software source
        :param pulumi.Input[builtins.int] packages: Number of packages
        :param pulumi.Input[builtins.str] parent_id: OCID for the parent software source, if there is one
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] parent_name: Display name the parent software source, if there is one
        :param pulumi.Input[builtins.str] repo_type: Type of the Software Source
        :param pulumi.Input[builtins.str] state: The current state of the Software Source.
        :param pulumi.Input[builtins.str] status: status of the software source.
        :param pulumi.Input[builtins.str] url: URL for the repostiory
        """
        if arch_type is not None:
            pulumi.set(__self__, "arch_type", arch_type)
        if associated_managed_instances is not None:
            pulumi.set(__self__, "associated_managed_instances", associated_managed_instances)
        if checksum_type is not None:
            pulumi.set(__self__, "checksum_type", checksum_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gpg_key_fingerprint is not None:
            pulumi.set(__self__, "gpg_key_fingerprint", gpg_key_fingerprint)
        if gpg_key_id is not None:
            pulumi.set(__self__, "gpg_key_id", gpg_key_id)
        if gpg_key_url is not None:
            pulumi.set(__self__, "gpg_key_url", gpg_key_url)
        if maintainer_email is not None:
            pulumi.set(__self__, "maintainer_email", maintainer_email)
        if maintainer_name is not None:
            pulumi.set(__self__, "maintainer_name", maintainer_name)
        if maintainer_phone is not None:
            pulumi.set(__self__, "maintainer_phone", maintainer_phone)
        if packages is not None:
            pulumi.set(__self__, "packages", packages)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if repo_type is not None:
            pulumi.set(__self__, "repo_type", repo_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The architecture type supported by the Software Source
        """
        return pulumi.get(self, "arch_type")

    @arch_type.setter
    def arch_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arch_type", value)

    @property
    @pulumi.getter(name="associatedManagedInstances")
    def associated_managed_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareSourceAssociatedManagedInstanceArgs']]]]:
        """
        list of the Managed Instances associated with this Software Sources
        """
        return pulumi.get(self, "associated_managed_instances")

    @associated_managed_instances.setter
    def associated_managed_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareSourceAssociatedManagedInstanceArgs']]]]):
        pulumi.set(self, "associated_managed_instances", value)

    @property
    @pulumi.getter(name="checksumType")
    def checksum_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The yum repository checksum type used by this software source
        """
        return pulumi.get(self, "checksum_type")

    @checksum_type.setter
    def checksum_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "checksum_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) OCID for the Compartment
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Information specified by the user about the software source
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) User friendly name for the software source
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="gpgKeyFingerprint")
    def gpg_key_fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fingerprint of the GPG key for this software source
        """
        return pulumi.get(self, "gpg_key_fingerprint")

    @gpg_key_fingerprint.setter
    def gpg_key_fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gpg_key_fingerprint", value)

    @property
    @pulumi.getter(name="gpgKeyId")
    def gpg_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the GPG key for this software source
        """
        return pulumi.get(self, "gpg_key_id")

    @gpg_key_id.setter
    def gpg_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gpg_key_id", value)

    @property
    @pulumi.getter(name="gpgKeyUrl")
    def gpg_key_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the GPG key for this software source
        """
        return pulumi.get(self, "gpg_key_url")

    @gpg_key_url.setter
    def gpg_key_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gpg_key_url", value)

    @property
    @pulumi.getter(name="maintainerEmail")
    def maintainer_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Email address of the person maintaining this software source
        """
        return pulumi.get(self, "maintainer_email")

    @maintainer_email.setter
    def maintainer_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintainer_email", value)

    @property
    @pulumi.getter(name="maintainerName")
    def maintainer_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Name of the person maintaining this software source
        """
        return pulumi.get(self, "maintainer_name")

    @maintainer_name.setter
    def maintainer_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintainer_name", value)

    @property
    @pulumi.getter(name="maintainerPhone")
    def maintainer_phone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Phone number of the person maintaining this software source
        """
        return pulumi.get(self, "maintainer_phone")

    @maintainer_phone.setter
    def maintainer_phone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintainer_phone", value)

    @property
    @pulumi.getter
    def packages(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of packages
        """
        return pulumi.get(self, "packages")

    @packages.setter
    def packages(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "packages", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID for the parent software source, if there is one


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display name the parent software source, if there is one
        """
        return pulumi.get(self, "parent_name")

    @parent_name.setter
    def parent_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_name", value)

    @property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the Software Source
        """
        return pulumi.get(self, "repo_type")

    @repo_type.setter
    def repo_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repo_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the Software Source.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        status of the software source.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL for the repostiory
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("oci:OsManagement/softwareSource:SoftwareSource")
class SoftwareSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arch_type: Optional[pulumi.Input[builtins.str]] = None,
                 checksum_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 maintainer_email: Optional[pulumi.Input[builtins.str]] = None,
                 maintainer_name: Optional[pulumi.Input[builtins.str]] = None,
                 maintainer_phone: Optional[pulumi.Input[builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Software Source resource in Oracle Cloud Infrastructure OS Management service.

        Creates a new custom Software Source on the management system.
        This will not contain any packages after it is first created,
        and they must be added later.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_software_source = oci.os_management.SoftwareSource("test_software_source",
            arch_type=software_source_arch_type,
            compartment_id=compartment_id,
            display_name=software_source_display_name,
            checksum_type=software_source_checksum_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=software_source_description,
            freeform_tags={
                "bar-key": "value",
            },
            maintainer_email=software_source_maintainer_email,
            maintainer_name=software_source_maintainer_name,
            maintainer_phone=software_source_maintainer_phone,
            parent_id=test_parent["id"])
        ```

        ## Import

        SoftwareSources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagement/softwareSource:SoftwareSource test_software_source "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arch_type: The architecture type supported by the Software Source
        :param pulumi.Input[builtins.str] checksum_type: (Updatable) The yum repository checksum type used by this software source
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) OCID for the Compartment
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Information specified by the user about the software source
        :param pulumi.Input[builtins.str] display_name: (Updatable) User friendly name for the software source
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] maintainer_email: (Updatable) Email address of the person maintaining this software source
        :param pulumi.Input[builtins.str] maintainer_name: (Updatable) Name of the person maintaining this software source
        :param pulumi.Input[builtins.str] maintainer_phone: (Updatable) Phone number of the person maintaining this software source
        :param pulumi.Input[builtins.str] parent_id: OCID for the parent software source, if there is one
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SoftwareSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Software Source resource in Oracle Cloud Infrastructure OS Management service.

        Creates a new custom Software Source on the management system.
        This will not contain any packages after it is first created,
        and they must be added later.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_software_source = oci.os_management.SoftwareSource("test_software_source",
            arch_type=software_source_arch_type,
            compartment_id=compartment_id,
            display_name=software_source_display_name,
            checksum_type=software_source_checksum_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=software_source_description,
            freeform_tags={
                "bar-key": "value",
            },
            maintainer_email=software_source_maintainer_email,
            maintainer_name=software_source_maintainer_name,
            maintainer_phone=software_source_maintainer_phone,
            parent_id=test_parent["id"])
        ```

        ## Import

        SoftwareSources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagement/softwareSource:SoftwareSource test_software_source "id"
        ```

        :param str resource_name: The name of the resource.
        :param SoftwareSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SoftwareSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arch_type: Optional[pulumi.Input[builtins.str]] = None,
                 checksum_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 maintainer_email: Optional[pulumi.Input[builtins.str]] = None,
                 maintainer_name: Optional[pulumi.Input[builtins.str]] = None,
                 maintainer_phone: Optional[pulumi.Input[builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SoftwareSourceArgs.__new__(SoftwareSourceArgs)

            if arch_type is None and not opts.urn:
                raise TypeError("Missing required property 'arch_type'")
            __props__.__dict__["arch_type"] = arch_type
            __props__.__dict__["checksum_type"] = checksum_type
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["maintainer_email"] = maintainer_email
            __props__.__dict__["maintainer_name"] = maintainer_name
            __props__.__dict__["maintainer_phone"] = maintainer_phone
            __props__.__dict__["parent_id"] = parent_id
            __props__.__dict__["associated_managed_instances"] = None
            __props__.__dict__["gpg_key_fingerprint"] = None
            __props__.__dict__["gpg_key_id"] = None
            __props__.__dict__["gpg_key_url"] = None
            __props__.__dict__["packages"] = None
            __props__.__dict__["parent_name"] = None
            __props__.__dict__["repo_type"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["url"] = None
        super(SoftwareSource, __self__).__init__(
            'oci:OsManagement/softwareSource:SoftwareSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arch_type: Optional[pulumi.Input[builtins.str]] = None,
            associated_managed_instances: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SoftwareSourceAssociatedManagedInstanceArgs', 'SoftwareSourceAssociatedManagedInstanceArgsDict']]]]] = None,
            checksum_type: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            gpg_key_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
            gpg_key_id: Optional[pulumi.Input[builtins.str]] = None,
            gpg_key_url: Optional[pulumi.Input[builtins.str]] = None,
            maintainer_email: Optional[pulumi.Input[builtins.str]] = None,
            maintainer_name: Optional[pulumi.Input[builtins.str]] = None,
            maintainer_phone: Optional[pulumi.Input[builtins.str]] = None,
            packages: Optional[pulumi.Input[builtins.int]] = None,
            parent_id: Optional[pulumi.Input[builtins.str]] = None,
            parent_name: Optional[pulumi.Input[builtins.str]] = None,
            repo_type: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None) -> 'SoftwareSource':
        """
        Get an existing SoftwareSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arch_type: The architecture type supported by the Software Source
        :param pulumi.Input[Sequence[pulumi.Input[Union['SoftwareSourceAssociatedManagedInstanceArgs', 'SoftwareSourceAssociatedManagedInstanceArgsDict']]]] associated_managed_instances: list of the Managed Instances associated with this Software Sources
        :param pulumi.Input[builtins.str] checksum_type: (Updatable) The yum repository checksum type used by this software source
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) OCID for the Compartment
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Information specified by the user about the software source
        :param pulumi.Input[builtins.str] display_name: (Updatable) User friendly name for the software source
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] gpg_key_fingerprint: Fingerprint of the GPG key for this software source
        :param pulumi.Input[builtins.str] gpg_key_id: ID of the GPG key for this software source
        :param pulumi.Input[builtins.str] gpg_key_url: URL of the GPG key for this software source
        :param pulumi.Input[builtins.str] maintainer_email: (Updatable) Email address of the person maintaining this software source
        :param pulumi.Input[builtins.str] maintainer_name: (Updatable) Name of the person maintaining this software source
        :param pulumi.Input[builtins.str] maintainer_phone: (Updatable) Phone number of the person maintaining this software source
        :param pulumi.Input[builtins.int] packages: Number of packages
        :param pulumi.Input[builtins.str] parent_id: OCID for the parent software source, if there is one
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] parent_name: Display name the parent software source, if there is one
        :param pulumi.Input[builtins.str] repo_type: Type of the Software Source
        :param pulumi.Input[builtins.str] state: The current state of the Software Source.
        :param pulumi.Input[builtins.str] status: status of the software source.
        :param pulumi.Input[builtins.str] url: URL for the repostiory
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SoftwareSourceState.__new__(_SoftwareSourceState)

        __props__.__dict__["arch_type"] = arch_type
        __props__.__dict__["associated_managed_instances"] = associated_managed_instances
        __props__.__dict__["checksum_type"] = checksum_type
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["gpg_key_fingerprint"] = gpg_key_fingerprint
        __props__.__dict__["gpg_key_id"] = gpg_key_id
        __props__.__dict__["gpg_key_url"] = gpg_key_url
        __props__.__dict__["maintainer_email"] = maintainer_email
        __props__.__dict__["maintainer_name"] = maintainer_name
        __props__.__dict__["maintainer_phone"] = maintainer_phone
        __props__.__dict__["packages"] = packages
        __props__.__dict__["parent_id"] = parent_id
        __props__.__dict__["parent_name"] = parent_name
        __props__.__dict__["repo_type"] = repo_type
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["url"] = url
        return SoftwareSource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> pulumi.Output[builtins.str]:
        """
        The architecture type supported by the Software Source
        """
        return pulumi.get(self, "arch_type")

    @property
    @pulumi.getter(name="associatedManagedInstances")
    def associated_managed_instances(self) -> pulumi.Output[Sequence['outputs.SoftwareSourceAssociatedManagedInstance']]:
        """
        list of the Managed Instances associated with this Software Sources
        """
        return pulumi.get(self, "associated_managed_instances")

    @property
    @pulumi.getter(name="checksumType")
    def checksum_type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The yum repository checksum type used by this software source
        """
        return pulumi.get(self, "checksum_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) OCID for the Compartment
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Information specified by the user about the software source
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) User friendly name for the software source
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="gpgKeyFingerprint")
    def gpg_key_fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        Fingerprint of the GPG key for this software source
        """
        return pulumi.get(self, "gpg_key_fingerprint")

    @property
    @pulumi.getter(name="gpgKeyId")
    def gpg_key_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the GPG key for this software source
        """
        return pulumi.get(self, "gpg_key_id")

    @property
    @pulumi.getter(name="gpgKeyUrl")
    def gpg_key_url(self) -> pulumi.Output[builtins.str]:
        """
        URL of the GPG key for this software source
        """
        return pulumi.get(self, "gpg_key_url")

    @property
    @pulumi.getter(name="maintainerEmail")
    def maintainer_email(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Email address of the person maintaining this software source
        """
        return pulumi.get(self, "maintainer_email")

    @property
    @pulumi.getter(name="maintainerName")
    def maintainer_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Name of the person maintaining this software source
        """
        return pulumi.get(self, "maintainer_name")

    @property
    @pulumi.getter(name="maintainerPhone")
    def maintainer_phone(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Phone number of the person maintaining this software source
        """
        return pulumi.get(self, "maintainer_phone")

    @property
    @pulumi.getter
    def packages(self) -> pulumi.Output[builtins.int]:
        """
        Number of packages
        """
        return pulumi.get(self, "packages")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[builtins.str]:
        """
        OCID for the parent software source, if there is one


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> pulumi.Output[builtins.str]:
        """
        Display name the parent software source, if there is one
        """
        return pulumi.get(self, "parent_name")

    @property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of the Software Source
        """
        return pulumi.get(self, "repo_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the Software Source.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        status of the software source.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        """
        URL for the repostiory
        """
        return pulumi.get(self, "url")

