# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedInstanceArgs', 'ManagedInstance']

@pulumi.input_type
class ManagedInstanceArgs:
    def __init__(__self__, *,
                 managed_instance_id: pulumi.Input[builtins.str],
                 autonomous_settings: Optional[pulumi.Input['ManagedInstanceAutonomousSettingsArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 notification_topic_id: Optional[pulumi.Input[builtins.str]] = None,
                 primary_management_station_id: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_management_station_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedInstance resource.
        :param pulumi.Input[builtins.str] managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
        :param pulumi.Input['ManagedInstanceAutonomousSettingsArgs'] autonomous_settings: (Updatable) Updatable settings for the Autonomous Linux service.
        :param pulumi.Input[builtins.str] description: (Updatable) User-specified description of the managed instance. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] notification_topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Oracle Notifications service (ONS) topic. ONS is the channel used to send notifications to the customer.
        :param pulumi.Input[builtins.str] primary_management_station_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station for the instance to use as primary management station.
        :param pulumi.Input[builtins.str] secondary_management_station_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station for the instance to use as secondary management station. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if autonomous_settings is not None:
            pulumi.set(__self__, "autonomous_settings", autonomous_settings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if notification_topic_id is not None:
            pulumi.set(__self__, "notification_topic_id", notification_topic_id)
        if primary_management_station_id is not None:
            pulumi.set(__self__, "primary_management_station_id", primary_management_station_id)
        if secondary_management_station_id is not None:
            pulumi.set(__self__, "secondary_management_station_id", secondary_management_station_id)

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "managed_instance_id", value)

    @property
    @pulumi.getter(name="autonomousSettings")
    def autonomous_settings(self) -> Optional[pulumi.Input['ManagedInstanceAutonomousSettingsArgs']]:
        """
        (Updatable) Updatable settings for the Autonomous Linux service.
        """
        return pulumi.get(self, "autonomous_settings")

    @autonomous_settings.setter
    def autonomous_settings(self, value: Optional[pulumi.Input['ManagedInstanceAutonomousSettingsArgs']]):
        pulumi.set(self, "autonomous_settings", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) User-specified description of the managed instance. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Oracle Notifications service (ONS) topic. ONS is the channel used to send notifications to the customer.
        """
        return pulumi.get(self, "notification_topic_id")

    @notification_topic_id.setter
    def notification_topic_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notification_topic_id", value)

    @property
    @pulumi.getter(name="primaryManagementStationId")
    def primary_management_station_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station for the instance to use as primary management station.
        """
        return pulumi.get(self, "primary_management_station_id")

    @primary_management_station_id.setter
    def primary_management_station_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_management_station_id", value)

    @property
    @pulumi.getter(name="secondaryManagementStationId")
    def secondary_management_station_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station for the instance to use as secondary management station. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "secondary_management_station_id")

    @secondary_management_station_id.setter
    def secondary_management_station_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_management_station_id", value)


@pulumi.input_type
class _ManagedInstanceState:
    def __init__(__self__, *,
                 agent_version: Optional[pulumi.Input[builtins.str]] = None,
                 architecture: Optional[pulumi.Input[builtins.str]] = None,
                 autonomous_settings: Optional[pulumi.Input['ManagedInstanceAutonomousSettingsArgs']] = None,
                 bug_updates_available: Optional[pulumi.Input[builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enhancement_updates_available: Optional[pulumi.Input[builtins.int]] = None,
                 installed_packages: Optional[pulumi.Input[builtins.int]] = None,
                 installed_windows_updates: Optional[pulumi.Input[builtins.int]] = None,
                 is_managed_by_autonomous_linux: Optional[pulumi.Input[builtins.bool]] = None,
                 is_management_station: Optional[pulumi.Input[builtins.bool]] = None,
                 is_reboot_required: Optional[pulumi.Input[builtins.bool]] = None,
                 ksplice_effective_kernel_version: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_environments: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceLifecycleEnvironmentArgs']]]] = None,
                 lifecycle_stages: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceLifecycleStageArgs']]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instance_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagedInstanceGroupArgs']]]] = None,
                 managed_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 notification_topic_id: Optional[pulumi.Input[builtins.str]] = None,
                 os_family: Optional[pulumi.Input[builtins.str]] = None,
                 os_kernel_version: Optional[pulumi.Input[builtins.str]] = None,
                 os_name: Optional[pulumi.Input[builtins.str]] = None,
                 os_version: Optional[pulumi.Input[builtins.str]] = None,
                 other_updates_available: Optional[pulumi.Input[builtins.int]] = None,
                 primary_management_station_id: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input[builtins.str]] = None,
                 profile_version: Optional[pulumi.Input[builtins.str]] = None,
                 scheduled_job_count: Optional[pulumi.Input[builtins.int]] = None,
                 secondary_management_station_id: Optional[pulumi.Input[builtins.str]] = None,
                 security_updates_available: Optional[pulumi.Input[builtins.int]] = None,
                 software_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceSoftwareSourceArgs']]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tenancy_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_last_boot: Optional[pulumi.Input[builtins.str]] = None,
                 time_last_checkin: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 updates_available: Optional[pulumi.Input[builtins.int]] = None,
                 work_request_count: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering ManagedInstance resources.
        :param pulumi.Input[builtins.str] agent_version: The version of osmh-agent running on the managed instance
        :param pulumi.Input[builtins.str] architecture: The CPU architecture type of the managed instance.
        :param pulumi.Input['ManagedInstanceAutonomousSettingsArgs'] autonomous_settings: (Updatable) Updatable settings for the Autonomous Linux service.
        :param pulumi.Input[builtins.int] bug_updates_available: Number of bug fix type updates available for installation.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the managed instance.
        :param pulumi.Input[builtins.str] description: (Updatable) User-specified description of the managed instance. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: Software source name.
        :param pulumi.Input[builtins.int] enhancement_updates_available: Number of enhancement type updates available for installation.
        :param pulumi.Input[builtins.int] installed_packages: Number of packages installed on the instance.
        :param pulumi.Input[builtins.int] installed_windows_updates: Number of Windows updates installed on the instance.
        :param pulumi.Input[builtins.bool] is_managed_by_autonomous_linux: Indicates whether the Autonomous Linux service manages the instance.
        :param pulumi.Input[builtins.bool] is_management_station: Indicates whether this managed instance is acting as an on-premises management station.
        :param pulumi.Input[builtins.bool] is_reboot_required: Indicates whether a reboot is required to complete installation of updates.
        :param pulumi.Input[builtins.str] ksplice_effective_kernel_version: The ksplice effective kernel version.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceLifecycleEnvironmentArgs']]] lifecycle_environments: Id and name of a resource to simplify the display for the user.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceLifecycleStageArgs']]] lifecycle_stages: Id and name of a resource to simplify the display for the user.
        :param pulumi.Input[builtins.str] location: The location of the managed instance.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagedInstanceGroupArgs']]] managed_instance_groups: Id and name of a resource to simplify the display for the user.
        :param pulumi.Input[builtins.str] managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
        :param pulumi.Input[builtins.str] notification_topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Oracle Notifications service (ONS) topic. ONS is the channel used to send notifications to the customer.
        :param pulumi.Input[builtins.str] os_family: The operating system type of the managed instance.
        :param pulumi.Input[builtins.str] os_kernel_version: Operating system kernel version.
        :param pulumi.Input[builtins.str] os_name: Operating system name.
        :param pulumi.Input[builtins.str] os_version: Operating system version.
        :param pulumi.Input[builtins.int] other_updates_available: Number of non-classified (other) updates available for installation.
        :param pulumi.Input[builtins.str] primary_management_station_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station for the instance to use as primary management station.
        :param pulumi.Input[builtins.str] profile: The profile that was used to register this instance with the service.
        :param pulumi.Input[builtins.str] profile_version: The version of the profile that was used to register this instance with the service.
        :param pulumi.Input[builtins.int] scheduled_job_count: Number of scheduled jobs associated with this instance.
        :param pulumi.Input[builtins.str] secondary_management_station_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station for the instance to use as secondary management station. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.int] security_updates_available: Number of security type updates available for installation.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceSoftwareSourceArgs']]] software_sources: The list of software sources currently attached to the managed instance.
        :param pulumi.Input[builtins.str] status: Current status of the managed instance.
        :param pulumi.Input[builtins.str] tenancy_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy that the managed instance resides in.
        :param pulumi.Input[builtins.str] time_created: The date and time the instance was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] time_last_boot: Time that the instance last booted (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] time_last_checkin: Time that the instance last checked in with the service (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] time_updated: The date and time the instance was last updated (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.int] updates_available: Number of updates available for installation.
        :param pulumi.Input[builtins.int] work_request_count: Number of work requests associated with this instance.
        """
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if autonomous_settings is not None:
            pulumi.set(__self__, "autonomous_settings", autonomous_settings)
        if bug_updates_available is not None:
            pulumi.set(__self__, "bug_updates_available", bug_updates_available)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enhancement_updates_available is not None:
            pulumi.set(__self__, "enhancement_updates_available", enhancement_updates_available)
        if installed_packages is not None:
            pulumi.set(__self__, "installed_packages", installed_packages)
        if installed_windows_updates is not None:
            pulumi.set(__self__, "installed_windows_updates", installed_windows_updates)
        if is_managed_by_autonomous_linux is not None:
            pulumi.set(__self__, "is_managed_by_autonomous_linux", is_managed_by_autonomous_linux)
        if is_management_station is not None:
            pulumi.set(__self__, "is_management_station", is_management_station)
        if is_reboot_required is not None:
            pulumi.set(__self__, "is_reboot_required", is_reboot_required)
        if ksplice_effective_kernel_version is not None:
            pulumi.set(__self__, "ksplice_effective_kernel_version", ksplice_effective_kernel_version)
        if lifecycle_environments is not None:
            pulumi.set(__self__, "lifecycle_environments", lifecycle_environments)
        if lifecycle_stages is not None:
            pulumi.set(__self__, "lifecycle_stages", lifecycle_stages)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_instance_groups is not None:
            pulumi.set(__self__, "managed_instance_groups", managed_instance_groups)
        if managed_instance_id is not None:
            pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if notification_topic_id is not None:
            pulumi.set(__self__, "notification_topic_id", notification_topic_id)
        if os_family is not None:
            pulumi.set(__self__, "os_family", os_family)
        if os_kernel_version is not None:
            pulumi.set(__self__, "os_kernel_version", os_kernel_version)
        if os_name is not None:
            pulumi.set(__self__, "os_name", os_name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if other_updates_available is not None:
            pulumi.set(__self__, "other_updates_available", other_updates_available)
        if primary_management_station_id is not None:
            pulumi.set(__self__, "primary_management_station_id", primary_management_station_id)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if profile_version is not None:
            pulumi.set(__self__, "profile_version", profile_version)
        if scheduled_job_count is not None:
            pulumi.set(__self__, "scheduled_job_count", scheduled_job_count)
        if secondary_management_station_id is not None:
            pulumi.set(__self__, "secondary_management_station_id", secondary_management_station_id)
        if security_updates_available is not None:
            pulumi.set(__self__, "security_updates_available", security_updates_available)
        if software_sources is not None:
            pulumi.set(__self__, "software_sources", software_sources)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tenancy_id is not None:
            pulumi.set(__self__, "tenancy_id", tenancy_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_boot is not None:
            pulumi.set(__self__, "time_last_boot", time_last_boot)
        if time_last_checkin is not None:
            pulumi.set(__self__, "time_last_checkin", time_last_checkin)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if updates_available is not None:
            pulumi.set(__self__, "updates_available", updates_available)
        if work_request_count is not None:
            pulumi.set(__self__, "work_request_count", work_request_count)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of osmh-agent running on the managed instance
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "agent_version", value)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CPU architecture type of the managed instance.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter(name="autonomousSettings")
    def autonomous_settings(self) -> Optional[pulumi.Input['ManagedInstanceAutonomousSettingsArgs']]:
        """
        (Updatable) Updatable settings for the Autonomous Linux service.
        """
        return pulumi.get(self, "autonomous_settings")

    @autonomous_settings.setter
    def autonomous_settings(self, value: Optional[pulumi.Input['ManagedInstanceAutonomousSettingsArgs']]):
        pulumi.set(self, "autonomous_settings", value)

    @property
    @pulumi.getter(name="bugUpdatesAvailable")
    def bug_updates_available(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of bug fix type updates available for installation.
        """
        return pulumi.get(self, "bug_updates_available")

    @bug_updates_available.setter
    def bug_updates_available(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "bug_updates_available", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the managed instance.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) User-specified description of the managed instance. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Software source name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="enhancementUpdatesAvailable")
    def enhancement_updates_available(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of enhancement type updates available for installation.
        """
        return pulumi.get(self, "enhancement_updates_available")

    @enhancement_updates_available.setter
    def enhancement_updates_available(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "enhancement_updates_available", value)

    @property
    @pulumi.getter(name="installedPackages")
    def installed_packages(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of packages installed on the instance.
        """
        return pulumi.get(self, "installed_packages")

    @installed_packages.setter
    def installed_packages(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "installed_packages", value)

    @property
    @pulumi.getter(name="installedWindowsUpdates")
    def installed_windows_updates(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of Windows updates installed on the instance.
        """
        return pulumi.get(self, "installed_windows_updates")

    @installed_windows_updates.setter
    def installed_windows_updates(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "installed_windows_updates", value)

    @property
    @pulumi.getter(name="isManagedByAutonomousLinux")
    def is_managed_by_autonomous_linux(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the Autonomous Linux service manages the instance.
        """
        return pulumi.get(self, "is_managed_by_autonomous_linux")

    @is_managed_by_autonomous_linux.setter
    def is_managed_by_autonomous_linux(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_managed_by_autonomous_linux", value)

    @property
    @pulumi.getter(name="isManagementStation")
    def is_management_station(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether this managed instance is acting as an on-premises management station.
        """
        return pulumi.get(self, "is_management_station")

    @is_management_station.setter
    def is_management_station(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_management_station", value)

    @property
    @pulumi.getter(name="isRebootRequired")
    def is_reboot_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether a reboot is required to complete installation of updates.
        """
        return pulumi.get(self, "is_reboot_required")

    @is_reboot_required.setter
    def is_reboot_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_reboot_required", value)

    @property
    @pulumi.getter(name="kspliceEffectiveKernelVersion")
    def ksplice_effective_kernel_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ksplice effective kernel version.
        """
        return pulumi.get(self, "ksplice_effective_kernel_version")

    @ksplice_effective_kernel_version.setter
    def ksplice_effective_kernel_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ksplice_effective_kernel_version", value)

    @property
    @pulumi.getter(name="lifecycleEnvironments")
    def lifecycle_environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceLifecycleEnvironmentArgs']]]]:
        """
        Id and name of a resource to simplify the display for the user.
        """
        return pulumi.get(self, "lifecycle_environments")

    @lifecycle_environments.setter
    def lifecycle_environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceLifecycleEnvironmentArgs']]]]):
        pulumi.set(self, "lifecycle_environments", value)

    @property
    @pulumi.getter(name="lifecycleStages")
    def lifecycle_stages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceLifecycleStageArgs']]]]:
        """
        Id and name of a resource to simplify the display for the user.
        """
        return pulumi.get(self, "lifecycle_stages")

    @lifecycle_stages.setter
    def lifecycle_stages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceLifecycleStageArgs']]]]):
        pulumi.set(self, "lifecycle_stages", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the managed instance.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="managedInstanceGroups")
    def managed_instance_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagedInstanceGroupArgs']]]]:
        """
        Id and name of a resource to simplify the display for the user.
        """
        return pulumi.get(self, "managed_instance_groups")

    @managed_instance_groups.setter
    def managed_instance_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagedInstanceGroupArgs']]]]):
        pulumi.set(self, "managed_instance_groups", value)

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_instance_id", value)

    @property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Oracle Notifications service (ONS) topic. ONS is the channel used to send notifications to the customer.
        """
        return pulumi.get(self, "notification_topic_id")

    @notification_topic_id.setter
    def notification_topic_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notification_topic_id", value)

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The operating system type of the managed instance.
        """
        return pulumi.get(self, "os_family")

    @os_family.setter
    def os_family(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_family", value)

    @property
    @pulumi.getter(name="osKernelVersion")
    def os_kernel_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Operating system kernel version.
        """
        return pulumi.get(self, "os_kernel_version")

    @os_kernel_version.setter
    def os_kernel_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_kernel_version", value)

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Operating system name.
        """
        return pulumi.get(self, "os_name")

    @os_name.setter
    def os_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_name", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Operating system version.
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_version", value)

    @property
    @pulumi.getter(name="otherUpdatesAvailable")
    def other_updates_available(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of non-classified (other) updates available for installation.
        """
        return pulumi.get(self, "other_updates_available")

    @other_updates_available.setter
    def other_updates_available(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "other_updates_available", value)

    @property
    @pulumi.getter(name="primaryManagementStationId")
    def primary_management_station_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station for the instance to use as primary management station.
        """
        return pulumi.get(self, "primary_management_station_id")

    @primary_management_station_id.setter
    def primary_management_station_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_management_station_id", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The profile that was used to register this instance with the service.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="profileVersion")
    def profile_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the profile that was used to register this instance with the service.
        """
        return pulumi.get(self, "profile_version")

    @profile_version.setter
    def profile_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_version", value)

    @property
    @pulumi.getter(name="scheduledJobCount")
    def scheduled_job_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of scheduled jobs associated with this instance.
        """
        return pulumi.get(self, "scheduled_job_count")

    @scheduled_job_count.setter
    def scheduled_job_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "scheduled_job_count", value)

    @property
    @pulumi.getter(name="secondaryManagementStationId")
    def secondary_management_station_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station for the instance to use as secondary management station. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "secondary_management_station_id")

    @secondary_management_station_id.setter
    def secondary_management_station_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_management_station_id", value)

    @property
    @pulumi.getter(name="securityUpdatesAvailable")
    def security_updates_available(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of security type updates available for installation.
        """
        return pulumi.get(self, "security_updates_available")

    @security_updates_available.setter
    def security_updates_available(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "security_updates_available", value)

    @property
    @pulumi.getter(name="softwareSources")
    def software_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceSoftwareSourceArgs']]]]:
        """
        The list of software sources currently attached to the managed instance.
        """
        return pulumi.get(self, "software_sources")

    @software_sources.setter
    def software_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceSoftwareSourceArgs']]]]):
        pulumi.set(self, "software_sources", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Current status of the managed instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy that the managed instance resides in.
        """
        return pulumi.get(self, "tenancy_id")

    @tenancy_id.setter
    def tenancy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenancy_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the instance was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeLastBoot")
    def time_last_boot(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time that the instance last booted (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_last_boot")

    @time_last_boot.setter
    def time_last_boot(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_last_boot", value)

    @property
    @pulumi.getter(name="timeLastCheckin")
    def time_last_checkin(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time that the instance last checked in with the service (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_last_checkin")

    @time_last_checkin.setter
    def time_last_checkin(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_last_checkin", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the instance was last updated (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="updatesAvailable")
    def updates_available(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of updates available for installation.
        """
        return pulumi.get(self, "updates_available")

    @updates_available.setter
    def updates_available(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "updates_available", value)

    @property
    @pulumi.getter(name="workRequestCount")
    def work_request_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of work requests associated with this instance.
        """
        return pulumi.get(self, "work_request_count")

    @work_request_count.setter
    def work_request_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "work_request_count", value)


@pulumi.type_token("oci:OsManagementHub/managedInstance:ManagedInstance")
class ManagedInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_settings: Optional[pulumi.Input[Union['ManagedInstanceAutonomousSettingsArgs', 'ManagedInstanceAutonomousSettingsArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 notification_topic_id: Optional[pulumi.Input[builtins.str]] = None,
                 primary_management_station_id: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_management_station_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Managed Instance resource in Oracle Cloud Infrastructure Os Management Hub service.

        Updates the specified managed instance information, such as description, ONS topic, and associated management station.

        ## Import

        ManagedInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstance:ManagedInstance test_managed_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ManagedInstanceAutonomousSettingsArgs', 'ManagedInstanceAutonomousSettingsArgsDict']] autonomous_settings: (Updatable) Updatable settings for the Autonomous Linux service.
        :param pulumi.Input[builtins.str] description: (Updatable) User-specified description of the managed instance. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
        :param pulumi.Input[builtins.str] notification_topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Oracle Notifications service (ONS) topic. ONS is the channel used to send notifications to the customer.
        :param pulumi.Input[builtins.str] primary_management_station_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station for the instance to use as primary management station.
        :param pulumi.Input[builtins.str] secondary_management_station_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station for the instance to use as secondary management station. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Managed Instance resource in Oracle Cloud Infrastructure Os Management Hub service.

        Updates the specified managed instance information, such as description, ONS topic, and associated management station.

        ## Import

        ManagedInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstance:ManagedInstance test_managed_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_settings: Optional[pulumi.Input[Union['ManagedInstanceAutonomousSettingsArgs', 'ManagedInstanceAutonomousSettingsArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 notification_topic_id: Optional[pulumi.Input[builtins.str]] = None,
                 primary_management_station_id: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_management_station_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceArgs.__new__(ManagedInstanceArgs)

            __props__.__dict__["autonomous_settings"] = autonomous_settings
            __props__.__dict__["description"] = description
            if managed_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_id'")
            __props__.__dict__["managed_instance_id"] = managed_instance_id
            __props__.__dict__["notification_topic_id"] = notification_topic_id
            __props__.__dict__["primary_management_station_id"] = primary_management_station_id
            __props__.__dict__["secondary_management_station_id"] = secondary_management_station_id
            __props__.__dict__["agent_version"] = None
            __props__.__dict__["architecture"] = None
            __props__.__dict__["bug_updates_available"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["enhancement_updates_available"] = None
            __props__.__dict__["installed_packages"] = None
            __props__.__dict__["installed_windows_updates"] = None
            __props__.__dict__["is_managed_by_autonomous_linux"] = None
            __props__.__dict__["is_management_station"] = None
            __props__.__dict__["is_reboot_required"] = None
            __props__.__dict__["ksplice_effective_kernel_version"] = None
            __props__.__dict__["lifecycle_environments"] = None
            __props__.__dict__["lifecycle_stages"] = None
            __props__.__dict__["location"] = None
            __props__.__dict__["managed_instance_groups"] = None
            __props__.__dict__["os_family"] = None
            __props__.__dict__["os_kernel_version"] = None
            __props__.__dict__["os_name"] = None
            __props__.__dict__["os_version"] = None
            __props__.__dict__["other_updates_available"] = None
            __props__.__dict__["profile"] = None
            __props__.__dict__["profile_version"] = None
            __props__.__dict__["scheduled_job_count"] = None
            __props__.__dict__["security_updates_available"] = None
            __props__.__dict__["software_sources"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tenancy_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_boot"] = None
            __props__.__dict__["time_last_checkin"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["updates_available"] = None
            __props__.__dict__["work_request_count"] = None
        super(ManagedInstance, __self__).__init__(
            'oci:OsManagementHub/managedInstance:ManagedInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_version: Optional[pulumi.Input[builtins.str]] = None,
            architecture: Optional[pulumi.Input[builtins.str]] = None,
            autonomous_settings: Optional[pulumi.Input[Union['ManagedInstanceAutonomousSettingsArgs', 'ManagedInstanceAutonomousSettingsArgsDict']]] = None,
            bug_updates_available: Optional[pulumi.Input[builtins.int]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            enhancement_updates_available: Optional[pulumi.Input[builtins.int]] = None,
            installed_packages: Optional[pulumi.Input[builtins.int]] = None,
            installed_windows_updates: Optional[pulumi.Input[builtins.int]] = None,
            is_managed_by_autonomous_linux: Optional[pulumi.Input[builtins.bool]] = None,
            is_management_station: Optional[pulumi.Input[builtins.bool]] = None,
            is_reboot_required: Optional[pulumi.Input[builtins.bool]] = None,
            ksplice_effective_kernel_version: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_environments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceLifecycleEnvironmentArgs', 'ManagedInstanceLifecycleEnvironmentArgsDict']]]]] = None,
            lifecycle_stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceLifecycleStageArgs', 'ManagedInstanceLifecycleStageArgsDict']]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            managed_instance_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceManagedInstanceGroupArgs', 'ManagedInstanceManagedInstanceGroupArgsDict']]]]] = None,
            managed_instance_id: Optional[pulumi.Input[builtins.str]] = None,
            notification_topic_id: Optional[pulumi.Input[builtins.str]] = None,
            os_family: Optional[pulumi.Input[builtins.str]] = None,
            os_kernel_version: Optional[pulumi.Input[builtins.str]] = None,
            os_name: Optional[pulumi.Input[builtins.str]] = None,
            os_version: Optional[pulumi.Input[builtins.str]] = None,
            other_updates_available: Optional[pulumi.Input[builtins.int]] = None,
            primary_management_station_id: Optional[pulumi.Input[builtins.str]] = None,
            profile: Optional[pulumi.Input[builtins.str]] = None,
            profile_version: Optional[pulumi.Input[builtins.str]] = None,
            scheduled_job_count: Optional[pulumi.Input[builtins.int]] = None,
            secondary_management_station_id: Optional[pulumi.Input[builtins.str]] = None,
            security_updates_available: Optional[pulumi.Input[builtins.int]] = None,
            software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceSoftwareSourceArgs', 'ManagedInstanceSoftwareSourceArgsDict']]]]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            tenancy_id: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_last_boot: Optional[pulumi.Input[builtins.str]] = None,
            time_last_checkin: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            updates_available: Optional[pulumi.Input[builtins.int]] = None,
            work_request_count: Optional[pulumi.Input[builtins.int]] = None) -> 'ManagedInstance':
        """
        Get an existing ManagedInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] agent_version: The version of osmh-agent running on the managed instance
        :param pulumi.Input[builtins.str] architecture: The CPU architecture type of the managed instance.
        :param pulumi.Input[Union['ManagedInstanceAutonomousSettingsArgs', 'ManagedInstanceAutonomousSettingsArgsDict']] autonomous_settings: (Updatable) Updatable settings for the Autonomous Linux service.
        :param pulumi.Input[builtins.int] bug_updates_available: Number of bug fix type updates available for installation.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the managed instance.
        :param pulumi.Input[builtins.str] description: (Updatable) User-specified description of the managed instance. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: Software source name.
        :param pulumi.Input[builtins.int] enhancement_updates_available: Number of enhancement type updates available for installation.
        :param pulumi.Input[builtins.int] installed_packages: Number of packages installed on the instance.
        :param pulumi.Input[builtins.int] installed_windows_updates: Number of Windows updates installed on the instance.
        :param pulumi.Input[builtins.bool] is_managed_by_autonomous_linux: Indicates whether the Autonomous Linux service manages the instance.
        :param pulumi.Input[builtins.bool] is_management_station: Indicates whether this managed instance is acting as an on-premises management station.
        :param pulumi.Input[builtins.bool] is_reboot_required: Indicates whether a reboot is required to complete installation of updates.
        :param pulumi.Input[builtins.str] ksplice_effective_kernel_version: The ksplice effective kernel version.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceLifecycleEnvironmentArgs', 'ManagedInstanceLifecycleEnvironmentArgsDict']]]] lifecycle_environments: Id and name of a resource to simplify the display for the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceLifecycleStageArgs', 'ManagedInstanceLifecycleStageArgsDict']]]] lifecycle_stages: Id and name of a resource to simplify the display for the user.
        :param pulumi.Input[builtins.str] location: The location of the managed instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceManagedInstanceGroupArgs', 'ManagedInstanceManagedInstanceGroupArgsDict']]]] managed_instance_groups: Id and name of a resource to simplify the display for the user.
        :param pulumi.Input[builtins.str] managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
        :param pulumi.Input[builtins.str] notification_topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Oracle Notifications service (ONS) topic. ONS is the channel used to send notifications to the customer.
        :param pulumi.Input[builtins.str] os_family: The operating system type of the managed instance.
        :param pulumi.Input[builtins.str] os_kernel_version: Operating system kernel version.
        :param pulumi.Input[builtins.str] os_name: Operating system name.
        :param pulumi.Input[builtins.str] os_version: Operating system version.
        :param pulumi.Input[builtins.int] other_updates_available: Number of non-classified (other) updates available for installation.
        :param pulumi.Input[builtins.str] primary_management_station_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station for the instance to use as primary management station.
        :param pulumi.Input[builtins.str] profile: The profile that was used to register this instance with the service.
        :param pulumi.Input[builtins.str] profile_version: The version of the profile that was used to register this instance with the service.
        :param pulumi.Input[builtins.int] scheduled_job_count: Number of scheduled jobs associated with this instance.
        :param pulumi.Input[builtins.str] secondary_management_station_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station for the instance to use as secondary management station. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.int] security_updates_available: Number of security type updates available for installation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceSoftwareSourceArgs', 'ManagedInstanceSoftwareSourceArgsDict']]]] software_sources: The list of software sources currently attached to the managed instance.
        :param pulumi.Input[builtins.str] status: Current status of the managed instance.
        :param pulumi.Input[builtins.str] tenancy_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy that the managed instance resides in.
        :param pulumi.Input[builtins.str] time_created: The date and time the instance was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] time_last_boot: Time that the instance last booted (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] time_last_checkin: Time that the instance last checked in with the service (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] time_updated: The date and time the instance was last updated (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.int] updates_available: Number of updates available for installation.
        :param pulumi.Input[builtins.int] work_request_count: Number of work requests associated with this instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceState.__new__(_ManagedInstanceState)

        __props__.__dict__["agent_version"] = agent_version
        __props__.__dict__["architecture"] = architecture
        __props__.__dict__["autonomous_settings"] = autonomous_settings
        __props__.__dict__["bug_updates_available"] = bug_updates_available
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enhancement_updates_available"] = enhancement_updates_available
        __props__.__dict__["installed_packages"] = installed_packages
        __props__.__dict__["installed_windows_updates"] = installed_windows_updates
        __props__.__dict__["is_managed_by_autonomous_linux"] = is_managed_by_autonomous_linux
        __props__.__dict__["is_management_station"] = is_management_station
        __props__.__dict__["is_reboot_required"] = is_reboot_required
        __props__.__dict__["ksplice_effective_kernel_version"] = ksplice_effective_kernel_version
        __props__.__dict__["lifecycle_environments"] = lifecycle_environments
        __props__.__dict__["lifecycle_stages"] = lifecycle_stages
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_instance_groups"] = managed_instance_groups
        __props__.__dict__["managed_instance_id"] = managed_instance_id
        __props__.__dict__["notification_topic_id"] = notification_topic_id
        __props__.__dict__["os_family"] = os_family
        __props__.__dict__["os_kernel_version"] = os_kernel_version
        __props__.__dict__["os_name"] = os_name
        __props__.__dict__["os_version"] = os_version
        __props__.__dict__["other_updates_available"] = other_updates_available
        __props__.__dict__["primary_management_station_id"] = primary_management_station_id
        __props__.__dict__["profile"] = profile
        __props__.__dict__["profile_version"] = profile_version
        __props__.__dict__["scheduled_job_count"] = scheduled_job_count
        __props__.__dict__["secondary_management_station_id"] = secondary_management_station_id
        __props__.__dict__["security_updates_available"] = security_updates_available
        __props__.__dict__["software_sources"] = software_sources
        __props__.__dict__["status"] = status
        __props__.__dict__["tenancy_id"] = tenancy_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_boot"] = time_last_boot
        __props__.__dict__["time_last_checkin"] = time_last_checkin
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["updates_available"] = updates_available
        __props__.__dict__["work_request_count"] = work_request_count
        return ManagedInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> pulumi.Output[builtins.str]:
        """
        The version of osmh-agent running on the managed instance
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter
    def architecture(self) -> pulumi.Output[builtins.str]:
        """
        The CPU architecture type of the managed instance.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="autonomousSettings")
    def autonomous_settings(self) -> pulumi.Output['outputs.ManagedInstanceAutonomousSettings']:
        """
        (Updatable) Updatable settings for the Autonomous Linux service.
        """
        return pulumi.get(self, "autonomous_settings")

    @property
    @pulumi.getter(name="bugUpdatesAvailable")
    def bug_updates_available(self) -> pulumi.Output[builtins.int]:
        """
        Number of bug fix type updates available for installation.
        """
        return pulumi.get(self, "bug_updates_available")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the managed instance.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) User-specified description of the managed instance. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Software source name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enhancementUpdatesAvailable")
    def enhancement_updates_available(self) -> pulumi.Output[builtins.int]:
        """
        Number of enhancement type updates available for installation.
        """
        return pulumi.get(self, "enhancement_updates_available")

    @property
    @pulumi.getter(name="installedPackages")
    def installed_packages(self) -> pulumi.Output[builtins.int]:
        """
        Number of packages installed on the instance.
        """
        return pulumi.get(self, "installed_packages")

    @property
    @pulumi.getter(name="installedWindowsUpdates")
    def installed_windows_updates(self) -> pulumi.Output[builtins.int]:
        """
        Number of Windows updates installed on the instance.
        """
        return pulumi.get(self, "installed_windows_updates")

    @property
    @pulumi.getter(name="isManagedByAutonomousLinux")
    def is_managed_by_autonomous_linux(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether the Autonomous Linux service manages the instance.
        """
        return pulumi.get(self, "is_managed_by_autonomous_linux")

    @property
    @pulumi.getter(name="isManagementStation")
    def is_management_station(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether this managed instance is acting as an on-premises management station.
        """
        return pulumi.get(self, "is_management_station")

    @property
    @pulumi.getter(name="isRebootRequired")
    def is_reboot_required(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether a reboot is required to complete installation of updates.
        """
        return pulumi.get(self, "is_reboot_required")

    @property
    @pulumi.getter(name="kspliceEffectiveKernelVersion")
    def ksplice_effective_kernel_version(self) -> pulumi.Output[builtins.str]:
        """
        The ksplice effective kernel version.
        """
        return pulumi.get(self, "ksplice_effective_kernel_version")

    @property
    @pulumi.getter(name="lifecycleEnvironments")
    def lifecycle_environments(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceLifecycleEnvironment']]:
        """
        Id and name of a resource to simplify the display for the user.
        """
        return pulumi.get(self, "lifecycle_environments")

    @property
    @pulumi.getter(name="lifecycleStages")
    def lifecycle_stages(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceLifecycleStage']]:
        """
        Id and name of a resource to simplify the display for the user.
        """
        return pulumi.get(self, "lifecycle_stages")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the managed instance.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="managedInstanceGroups")
    def managed_instance_groups(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceManagedInstanceGroup']]:
        """
        Id and name of a resource to simplify the display for the user.
        """
        return pulumi.get(self, "managed_instance_groups")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Oracle Notifications service (ONS) topic. ONS is the channel used to send notifications to the customer.
        """
        return pulumi.get(self, "notification_topic_id")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> pulumi.Output[builtins.str]:
        """
        The operating system type of the managed instance.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="osKernelVersion")
    def os_kernel_version(self) -> pulumi.Output[builtins.str]:
        """
        Operating system kernel version.
        """
        return pulumi.get(self, "os_kernel_version")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> pulumi.Output[builtins.str]:
        """
        Operating system name.
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> pulumi.Output[builtins.str]:
        """
        Operating system version.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="otherUpdatesAvailable")
    def other_updates_available(self) -> pulumi.Output[builtins.int]:
        """
        Number of non-classified (other) updates available for installation.
        """
        return pulumi.get(self, "other_updates_available")

    @property
    @pulumi.getter(name="primaryManagementStationId")
    def primary_management_station_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station for the instance to use as primary management station.
        """
        return pulumi.get(self, "primary_management_station_id")

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Output[builtins.str]:
        """
        The profile that was used to register this instance with the service.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="profileVersion")
    def profile_version(self) -> pulumi.Output[builtins.str]:
        """
        The version of the profile that was used to register this instance with the service.
        """
        return pulumi.get(self, "profile_version")

    @property
    @pulumi.getter(name="scheduledJobCount")
    def scheduled_job_count(self) -> pulumi.Output[builtins.int]:
        """
        Number of scheduled jobs associated with this instance.
        """
        return pulumi.get(self, "scheduled_job_count")

    @property
    @pulumi.getter(name="secondaryManagementStationId")
    def secondary_management_station_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station for the instance to use as secondary management station. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "secondary_management_station_id")

    @property
    @pulumi.getter(name="securityUpdatesAvailable")
    def security_updates_available(self) -> pulumi.Output[builtins.int]:
        """
        Number of security type updates available for installation.
        """
        return pulumi.get(self, "security_updates_available")

    @property
    @pulumi.getter(name="softwareSources")
    def software_sources(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceSoftwareSource']]:
        """
        The list of software sources currently attached to the managed instance.
        """
        return pulumi.get(self, "software_sources")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Current status of the managed instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy that the managed instance resides in.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the instance was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastBoot")
    def time_last_boot(self) -> pulumi.Output[builtins.str]:
        """
        Time that the instance last booted (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_last_boot")

    @property
    @pulumi.getter(name="timeLastCheckin")
    def time_last_checkin(self) -> pulumi.Output[builtins.str]:
        """
        Time that the instance last checked in with the service (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_last_checkin")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the instance was last updated (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="updatesAvailable")
    def updates_available(self) -> pulumi.Output[builtins.int]:
        """
        Number of updates available for installation.
        """
        return pulumi.get(self, "updates_available")

    @property
    @pulumi.getter(name="workRequestCount")
    def work_request_count(self) -> pulumi.Output[builtins.int]:
        """
        Number of work requests associated with this instance.
        """
        return pulumi.get(self, "work_request_count")

