# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedInstanceGroupAttachManagedInstancesManagementArgs', 'ManagedInstanceGroupAttachManagedInstancesManagement']

@pulumi.input_type
class ManagedInstanceGroupAttachManagedInstancesManagementArgs:
    def __init__(__self__, *,
                 managed_instance_group_id: pulumi.Input[builtins.str],
                 managed_instances: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 work_request_details: Optional[pulumi.Input['ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgs']] = None):
        """
        The set of arguments for constructing a ManagedInstanceGroupAttachManagedInstancesManagement resource.
        :param pulumi.Input[builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instances: List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to attach to the group.
        :param pulumi.Input['ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        pulumi.set(__self__, "managed_instances", managed_instances)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @managed_instance_group_id.setter
    def managed_instance_group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "managed_instance_group_id", value)

    @property
    @pulumi.getter(name="managedInstances")
    def managed_instances(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to attach to the group.
        """
        return pulumi.get(self, "managed_instances")

    @managed_instances.setter
    def managed_instances(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "managed_instances", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


@pulumi.input_type
class _ManagedInstanceGroupAttachManagedInstancesManagementState:
    def __init__(__self__, *,
                 managed_instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 work_request_details: Optional[pulumi.Input['ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgs']] = None):
        """
        Input properties used for looking up and filtering ManagedInstanceGroupAttachManagedInstancesManagement resources.
        :param pulumi.Input[builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instances: List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to attach to the group.
        :param pulumi.Input['ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        if managed_instance_group_id is not None:
            pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        if managed_instances is not None:
            pulumi.set(__self__, "managed_instances", managed_instances)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @managed_instance_group_id.setter
    def managed_instance_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_instance_group_id", value)

    @property
    @pulumi.getter(name="managedInstances")
    def managed_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to attach to the group.
        """
        return pulumi.get(self, "managed_instances")

    @managed_instances.setter
    def managed_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "managed_instances", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


@pulumi.type_token("oci:OsManagementHub/managedInstanceGroupAttachManagedInstancesManagement:ManagedInstanceGroupAttachManagedInstancesManagement")
class ManagedInstanceGroupAttachManagedInstancesManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Managed Instance Group Attach Managed Instances Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Adds managed instances to the specified managed instance group. After adding instances to the group, any operation applied to the group will be applied to all instances in the group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group_attach_managed_instances_management = oci.os_management_hub.ManagedInstanceGroupAttachManagedInstancesManagement("test_managed_instance_group_attach_managed_instances_management",
            managed_instance_group_id=test_managed_instance_group["id"],
            managed_instances=managed_instance_group_attach_managed_instances_management_managed_instances,
            work_request_details={
                "description": managed_instance_group_attach_managed_instances_management_work_request_details_description,
                "display_name": managed_instance_group_attach_managed_instances_management_work_request_details_display_name,
            })
        ```

        ## Import

        ManagedInstanceGroupAttachManagedInstancesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceGroupAttachManagedInstancesManagement:ManagedInstanceGroupAttachManagedInstancesManagement test_managed_instance_group_attach_managed_instances_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instances: List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to attach to the group.
        :param pulumi.Input[Union['ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceGroupAttachManagedInstancesManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Managed Instance Group Attach Managed Instances Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Adds managed instances to the specified managed instance group. After adding instances to the group, any operation applied to the group will be applied to all instances in the group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group_attach_managed_instances_management = oci.os_management_hub.ManagedInstanceGroupAttachManagedInstancesManagement("test_managed_instance_group_attach_managed_instances_management",
            managed_instance_group_id=test_managed_instance_group["id"],
            managed_instances=managed_instance_group_attach_managed_instances_management_managed_instances,
            work_request_details={
                "description": managed_instance_group_attach_managed_instances_management_work_request_details_description,
                "display_name": managed_instance_group_attach_managed_instances_management_work_request_details_display_name,
            })
        ```

        ## Import

        ManagedInstanceGroupAttachManagedInstancesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceGroupAttachManagedInstancesManagement:ManagedInstanceGroupAttachManagedInstancesManagement test_managed_instance_group_attach_managed_instances_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceGroupAttachManagedInstancesManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceGroupAttachManagedInstancesManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceGroupAttachManagedInstancesManagementArgs.__new__(ManagedInstanceGroupAttachManagedInstancesManagementArgs)

            if managed_instance_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_group_id'")
            __props__.__dict__["managed_instance_group_id"] = managed_instance_group_id
            if managed_instances is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instances'")
            __props__.__dict__["managed_instances"] = managed_instances
            __props__.__dict__["work_request_details"] = work_request_details
        super(ManagedInstanceGroupAttachManagedInstancesManagement, __self__).__init__(
            'oci:OsManagementHub/managedInstanceGroupAttachManagedInstancesManagement:ManagedInstanceGroupAttachManagedInstancesManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            managed_instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
            managed_instances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgsDict']]] = None) -> 'ManagedInstanceGroupAttachManagedInstancesManagement':
        """
        Get an existing ManagedInstanceGroupAttachManagedInstancesManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instances: List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to attach to the group.
        :param pulumi.Input[Union['ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceGroupAttachManagedInstancesManagementState.__new__(_ManagedInstanceGroupAttachManagedInstancesManagementState)

        __props__.__dict__["managed_instance_group_id"] = managed_instance_group_id
        __props__.__dict__["managed_instances"] = managed_instances
        __props__.__dict__["work_request_details"] = work_request_details
        return ManagedInstanceGroupAttachManagedInstancesManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @property
    @pulumi.getter(name="managedInstances")
    def managed_instances(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to attach to the group.
        """
        return pulumi.get(self, "managed_instances")

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> pulumi.Output['outputs.ManagedInstanceGroupAttachManagedInstancesManagementWorkRequestDetails']:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

