# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedInstanceGroupManageModuleStreamsManagementArgs', 'ManagedInstanceGroupManageModuleStreamsManagement']

@pulumi.input_type
class ManagedInstanceGroupManageModuleStreamsManagementArgs:
    def __init__(__self__, *,
                 managed_instance_group_id: pulumi.Input[builtins.str],
                 disables: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementDisableArgs']]]] = None,
                 enables: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementEnableArgs']]]] = None,
                 installs: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementInstallArgs']]]] = None,
                 is_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 removes: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementRemoveArgs']]]] = None,
                 work_request_details: Optional[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgs']] = None):
        """
        The set of arguments for constructing a ManagedInstanceGroupManageModuleStreamsManagement resource.
        :param pulumi.Input[builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementDisableArgs']]] disables: The set of module streams to disable.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementEnableArgs']]] enables: The set of module streams to enable.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementInstallArgs']]] installs: The set of module stream profiles to install.
        :param pulumi.Input[builtins.bool] is_dry_run: Indicates if this operation is a dry run or if the operation should be committed.  If set to true, the result of the operation will be evaluated but not committed.  If set to false, the operation is committed to the managed instance(s).  The default is false.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementRemoveArgs']]] removes: The set of module stream profiles to remove.
        :param pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        if disables is not None:
            pulumi.set(__self__, "disables", disables)
        if enables is not None:
            pulumi.set(__self__, "enables", enables)
        if installs is not None:
            pulumi.set(__self__, "installs", installs)
        if is_dry_run is not None:
            pulumi.set(__self__, "is_dry_run", is_dry_run)
        if removes is not None:
            pulumi.set(__self__, "removes", removes)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @managed_instance_group_id.setter
    def managed_instance_group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "managed_instance_group_id", value)

    @property
    @pulumi.getter
    def disables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementDisableArgs']]]]:
        """
        The set of module streams to disable.
        """
        return pulumi.get(self, "disables")

    @disables.setter
    def disables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementDisableArgs']]]]):
        pulumi.set(self, "disables", value)

    @property
    @pulumi.getter
    def enables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementEnableArgs']]]]:
        """
        The set of module streams to enable.
        """
        return pulumi.get(self, "enables")

    @enables.setter
    def enables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementEnableArgs']]]]):
        pulumi.set(self, "enables", value)

    @property
    @pulumi.getter
    def installs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementInstallArgs']]]]:
        """
        The set of module stream profiles to install.
        """
        return pulumi.get(self, "installs")

    @installs.setter
    def installs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementInstallArgs']]]]):
        pulumi.set(self, "installs", value)

    @property
    @pulumi.getter(name="isDryRun")
    def is_dry_run(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if this operation is a dry run or if the operation should be committed.  If set to true, the result of the operation will be evaluated but not committed.  If set to false, the operation is committed to the managed instance(s).  The default is false.
        """
        return pulumi.get(self, "is_dry_run")

    @is_dry_run.setter
    def is_dry_run(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_dry_run", value)

    @property
    @pulumi.getter
    def removes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementRemoveArgs']]]]:
        """
        The set of module stream profiles to remove.
        """
        return pulumi.get(self, "removes")

    @removes.setter
    def removes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementRemoveArgs']]]]):
        pulumi.set(self, "removes", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


@pulumi.input_type
class _ManagedInstanceGroupManageModuleStreamsManagementState:
    def __init__(__self__, *,
                 disables: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementDisableArgs']]]] = None,
                 enables: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementEnableArgs']]]] = None,
                 installs: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementInstallArgs']]]] = None,
                 is_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 managed_instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 removes: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementRemoveArgs']]]] = None,
                 work_request_details: Optional[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgs']] = None):
        """
        Input properties used for looking up and filtering ManagedInstanceGroupManageModuleStreamsManagement resources.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementDisableArgs']]] disables: The set of module streams to disable.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementEnableArgs']]] enables: The set of module streams to enable.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementInstallArgs']]] installs: The set of module stream profiles to install.
        :param pulumi.Input[builtins.bool] is_dry_run: Indicates if this operation is a dry run or if the operation should be committed.  If set to true, the result of the operation will be evaluated but not committed.  If set to false, the operation is committed to the managed instance(s).  The default is false.
        :param pulumi.Input[builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementRemoveArgs']]] removes: The set of module stream profiles to remove.
        :param pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        if disables is not None:
            pulumi.set(__self__, "disables", disables)
        if enables is not None:
            pulumi.set(__self__, "enables", enables)
        if installs is not None:
            pulumi.set(__self__, "installs", installs)
        if is_dry_run is not None:
            pulumi.set(__self__, "is_dry_run", is_dry_run)
        if managed_instance_group_id is not None:
            pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        if removes is not None:
            pulumi.set(__self__, "removes", removes)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @property
    @pulumi.getter
    def disables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementDisableArgs']]]]:
        """
        The set of module streams to disable.
        """
        return pulumi.get(self, "disables")

    @disables.setter
    def disables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementDisableArgs']]]]):
        pulumi.set(self, "disables", value)

    @property
    @pulumi.getter
    def enables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementEnableArgs']]]]:
        """
        The set of module streams to enable.
        """
        return pulumi.get(self, "enables")

    @enables.setter
    def enables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementEnableArgs']]]]):
        pulumi.set(self, "enables", value)

    @property
    @pulumi.getter
    def installs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementInstallArgs']]]]:
        """
        The set of module stream profiles to install.
        """
        return pulumi.get(self, "installs")

    @installs.setter
    def installs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementInstallArgs']]]]):
        pulumi.set(self, "installs", value)

    @property
    @pulumi.getter(name="isDryRun")
    def is_dry_run(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if this operation is a dry run or if the operation should be committed.  If set to true, the result of the operation will be evaluated but not committed.  If set to false, the operation is committed to the managed instance(s).  The default is false.
        """
        return pulumi.get(self, "is_dry_run")

    @is_dry_run.setter
    def is_dry_run(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_dry_run", value)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @managed_instance_group_id.setter
    def managed_instance_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_instance_group_id", value)

    @property
    @pulumi.getter
    def removes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementRemoveArgs']]]]:
        """
        The set of module stream profiles to remove.
        """
        return pulumi.get(self, "removes")

    @removes.setter
    def removes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementRemoveArgs']]]]):
        pulumi.set(self, "removes", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


@pulumi.type_token("oci:OsManagementHub/managedInstanceGroupManageModuleStreamsManagement:ManagedInstanceGroupManageModuleStreamsManagement")
class ManagedInstanceGroupManageModuleStreamsManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementDisableArgs', 'ManagedInstanceGroupManageModuleStreamsManagementDisableArgsDict']]]]] = None,
                 enables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementEnableArgs', 'ManagedInstanceGroupManageModuleStreamsManagementEnableArgsDict']]]]] = None,
                 installs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementInstallArgs', 'ManagedInstanceGroupManageModuleStreamsManagementInstallArgsDict']]]]] = None,
                 is_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 managed_instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 removes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementRemoveArgs', 'ManagedInstanceGroupManageModuleStreamsManagementRemoveArgsDict']]]]] = None,
                 work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Managed Instance Group Manage Module Streams Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Enables or disables module streams and installs or removes module stream profiles. Once complete, the state of the modules, streams, and profiles will match the state indicated in the operation. See [ManageModuleStreamsOnManagedInstanceGroupDetails](https://docs.cloud.oracle.com/iaas/api/#/en/osmh/latest/datatypes/ManageModuleStreamsOnManagedInstanceGroupDetails) for more information.
        You can preform this operation as a dry run. For a dry run, the service evaluates the operation against the current module, stream, and profile state on the managed instance, but does not commit the changes. Instead, the service returns work request log or error entries indicating the impact of the operation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group_manage_module_streams_management = oci.os_management_hub.ManagedInstanceGroupManageModuleStreamsManagement("test_managed_instance_group_manage_module_streams_management",
            managed_instance_group_id=test_managed_instance_group["id"],
            disables=[{
                "module_name": managed_instance_group_manage_module_streams_management_disable_module_name,
                "stream_name": test_stream["name"],
                "software_source_id": test_software_source["id"],
            }],
            enables=[{
                "module_name": managed_instance_group_manage_module_streams_management_enable_module_name,
                "stream_name": test_stream["name"],
                "software_source_id": test_software_source["id"],
            }],
            installs=[{
                "module_name": managed_instance_group_manage_module_streams_management_install_module_name,
                "profile_name": test_profile["name"],
                "stream_name": test_stream["name"],
                "software_source_id": test_software_source["id"],
            }],
            is_dry_run=managed_instance_group_manage_module_streams_management_is_dry_run,
            removes=[{
                "module_name": managed_instance_group_manage_module_streams_management_remove_module_name,
                "profile_name": test_profile["name"],
                "stream_name": test_stream["name"],
                "software_source_id": test_software_source["id"],
            }],
            work_request_details={
                "description": managed_instance_group_manage_module_streams_management_work_request_details_description,
                "display_name": managed_instance_group_manage_module_streams_management_work_request_details_display_name,
            })
        ```

        ## Import

        ManagedInstanceGroupManageModuleStreamsManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceGroupManageModuleStreamsManagement:ManagedInstanceGroupManageModuleStreamsManagement test_managed_instance_group_manage_module_streams_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementDisableArgs', 'ManagedInstanceGroupManageModuleStreamsManagementDisableArgsDict']]]] disables: The set of module streams to disable.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementEnableArgs', 'ManagedInstanceGroupManageModuleStreamsManagementEnableArgsDict']]]] enables: The set of module streams to enable.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementInstallArgs', 'ManagedInstanceGroupManageModuleStreamsManagementInstallArgsDict']]]] installs: The set of module stream profiles to install.
        :param pulumi.Input[builtins.bool] is_dry_run: Indicates if this operation is a dry run or if the operation should be committed.  If set to true, the result of the operation will be evaluated but not committed.  If set to false, the operation is committed to the managed instance(s).  The default is false.
        :param pulumi.Input[builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementRemoveArgs', 'ManagedInstanceGroupManageModuleStreamsManagementRemoveArgsDict']]]] removes: The set of module stream profiles to remove.
        :param pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceGroupManageModuleStreamsManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Managed Instance Group Manage Module Streams Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Enables or disables module streams and installs or removes module stream profiles. Once complete, the state of the modules, streams, and profiles will match the state indicated in the operation. See [ManageModuleStreamsOnManagedInstanceGroupDetails](https://docs.cloud.oracle.com/iaas/api/#/en/osmh/latest/datatypes/ManageModuleStreamsOnManagedInstanceGroupDetails) for more information.
        You can preform this operation as a dry run. For a dry run, the service evaluates the operation against the current module, stream, and profile state on the managed instance, but does not commit the changes. Instead, the service returns work request log or error entries indicating the impact of the operation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group_manage_module_streams_management = oci.os_management_hub.ManagedInstanceGroupManageModuleStreamsManagement("test_managed_instance_group_manage_module_streams_management",
            managed_instance_group_id=test_managed_instance_group["id"],
            disables=[{
                "module_name": managed_instance_group_manage_module_streams_management_disable_module_name,
                "stream_name": test_stream["name"],
                "software_source_id": test_software_source["id"],
            }],
            enables=[{
                "module_name": managed_instance_group_manage_module_streams_management_enable_module_name,
                "stream_name": test_stream["name"],
                "software_source_id": test_software_source["id"],
            }],
            installs=[{
                "module_name": managed_instance_group_manage_module_streams_management_install_module_name,
                "profile_name": test_profile["name"],
                "stream_name": test_stream["name"],
                "software_source_id": test_software_source["id"],
            }],
            is_dry_run=managed_instance_group_manage_module_streams_management_is_dry_run,
            removes=[{
                "module_name": managed_instance_group_manage_module_streams_management_remove_module_name,
                "profile_name": test_profile["name"],
                "stream_name": test_stream["name"],
                "software_source_id": test_software_source["id"],
            }],
            work_request_details={
                "description": managed_instance_group_manage_module_streams_management_work_request_details_description,
                "display_name": managed_instance_group_manage_module_streams_management_work_request_details_display_name,
            })
        ```

        ## Import

        ManagedInstanceGroupManageModuleStreamsManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceGroupManageModuleStreamsManagement:ManagedInstanceGroupManageModuleStreamsManagement test_managed_instance_group_manage_module_streams_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceGroupManageModuleStreamsManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceGroupManageModuleStreamsManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementDisableArgs', 'ManagedInstanceGroupManageModuleStreamsManagementDisableArgsDict']]]]] = None,
                 enables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementEnableArgs', 'ManagedInstanceGroupManageModuleStreamsManagementEnableArgsDict']]]]] = None,
                 installs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementInstallArgs', 'ManagedInstanceGroupManageModuleStreamsManagementInstallArgsDict']]]]] = None,
                 is_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 managed_instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 removes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementRemoveArgs', 'ManagedInstanceGroupManageModuleStreamsManagementRemoveArgsDict']]]]] = None,
                 work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceGroupManageModuleStreamsManagementArgs.__new__(ManagedInstanceGroupManageModuleStreamsManagementArgs)

            __props__.__dict__["disables"] = disables
            __props__.__dict__["enables"] = enables
            __props__.__dict__["installs"] = installs
            __props__.__dict__["is_dry_run"] = is_dry_run
            if managed_instance_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_group_id'")
            __props__.__dict__["managed_instance_group_id"] = managed_instance_group_id
            __props__.__dict__["removes"] = removes
            __props__.__dict__["work_request_details"] = work_request_details
        super(ManagedInstanceGroupManageModuleStreamsManagement, __self__).__init__(
            'oci:OsManagementHub/managedInstanceGroupManageModuleStreamsManagement:ManagedInstanceGroupManageModuleStreamsManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            disables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementDisableArgs', 'ManagedInstanceGroupManageModuleStreamsManagementDisableArgsDict']]]]] = None,
            enables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementEnableArgs', 'ManagedInstanceGroupManageModuleStreamsManagementEnableArgsDict']]]]] = None,
            installs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementInstallArgs', 'ManagedInstanceGroupManageModuleStreamsManagementInstallArgsDict']]]]] = None,
            is_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
            managed_instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
            removes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementRemoveArgs', 'ManagedInstanceGroupManageModuleStreamsManagementRemoveArgsDict']]]]] = None,
            work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgsDict']]] = None) -> 'ManagedInstanceGroupManageModuleStreamsManagement':
        """
        Get an existing ManagedInstanceGroupManageModuleStreamsManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementDisableArgs', 'ManagedInstanceGroupManageModuleStreamsManagementDisableArgsDict']]]] disables: The set of module streams to disable.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementEnableArgs', 'ManagedInstanceGroupManageModuleStreamsManagementEnableArgsDict']]]] enables: The set of module streams to enable.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementInstallArgs', 'ManagedInstanceGroupManageModuleStreamsManagementInstallArgsDict']]]] installs: The set of module stream profiles to install.
        :param pulumi.Input[builtins.bool] is_dry_run: Indicates if this operation is a dry run or if the operation should be committed.  If set to true, the result of the operation will be evaluated but not committed.  If set to false, the operation is committed to the managed instance(s).  The default is false.
        :param pulumi.Input[builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementRemoveArgs', 'ManagedInstanceGroupManageModuleStreamsManagementRemoveArgsDict']]]] removes: The set of module stream profiles to remove.
        :param pulumi.Input[Union['ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceGroupManageModuleStreamsManagementState.__new__(_ManagedInstanceGroupManageModuleStreamsManagementState)

        __props__.__dict__["disables"] = disables
        __props__.__dict__["enables"] = enables
        __props__.__dict__["installs"] = installs
        __props__.__dict__["is_dry_run"] = is_dry_run
        __props__.__dict__["managed_instance_group_id"] = managed_instance_group_id
        __props__.__dict__["removes"] = removes
        __props__.__dict__["work_request_details"] = work_request_details
        return ManagedInstanceGroupManageModuleStreamsManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def disables(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceGroupManageModuleStreamsManagementDisable']]:
        """
        The set of module streams to disable.
        """
        return pulumi.get(self, "disables")

    @property
    @pulumi.getter
    def enables(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceGroupManageModuleStreamsManagementEnable']]:
        """
        The set of module streams to enable.
        """
        return pulumi.get(self, "enables")

    @property
    @pulumi.getter
    def installs(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceGroupManageModuleStreamsManagementInstall']]:
        """
        The set of module stream profiles to install.
        """
        return pulumi.get(self, "installs")

    @property
    @pulumi.getter(name="isDryRun")
    def is_dry_run(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates if this operation is a dry run or if the operation should be committed.  If set to true, the result of the operation will be evaluated but not committed.  If set to false, the operation is committed to the managed instance(s).  The default is false.
        """
        return pulumi.get(self, "is_dry_run")

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @property
    @pulumi.getter
    def removes(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceGroupManageModuleStreamsManagementRemove']]:
        """
        The set of module stream profiles to remove.
        """
        return pulumi.get(self, "removes")

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> pulumi.Output['outputs.ManagedInstanceGroupManageModuleStreamsManagementWorkRequestDetails']:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

