# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitoredResourcesListMemberArgs', 'MonitoredResourcesListMember']

@pulumi.input_type
class MonitoredResourcesListMemberArgs:
    def __init__(__self__, *,
                 monitored_resource_id: pulumi.Input[builtins.str],
                 destination_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 limit_level: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a MonitoredResourcesListMember resource.
        :param pulumi.Input[builtins.str] monitored_resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of monitored resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] destination_resource_id: Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.int] limit_level: The field which determines the depth of hierarchy while searching for members.
        """
        pulumi.set(__self__, "monitored_resource_id", monitored_resource_id)
        if destination_resource_id is not None:
            pulumi.set(__self__, "destination_resource_id", destination_resource_id)
        if limit_level is not None:
            pulumi.set(__self__, "limit_level", limit_level)

    @property
    @pulumi.getter(name="monitoredResourceId")
    def monitored_resource_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of monitored resource.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "monitored_resource_id")

    @monitored_resource_id.setter
    def monitored_resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "monitored_resource_id", value)

    @property
    @pulumi.getter(name="destinationResourceId")
    def destination_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "destination_resource_id")

    @destination_resource_id.setter
    def destination_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_resource_id", value)

    @property
    @pulumi.getter(name="limitLevel")
    def limit_level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The field which determines the depth of hierarchy while searching for members.
        """
        return pulumi.get(self, "limit_level")

    @limit_level.setter
    def limit_level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "limit_level", value)


@pulumi.input_type
class _MonitoredResourcesListMemberState:
    def __init__(__self__, *,
                 destination_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesListMemberItemArgs']]]] = None,
                 limit_level: Optional[pulumi.Input[builtins.int]] = None,
                 monitored_resource_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MonitoredResourcesListMember resources.
        :param pulumi.Input[builtins.str] destination_resource_id: Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesListMemberItemArgs']]] items: List of member resources.
        :param pulumi.Input[builtins.int] limit_level: The field which determines the depth of hierarchy while searching for members.
        :param pulumi.Input[builtins.str] monitored_resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of monitored resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if destination_resource_id is not None:
            pulumi.set(__self__, "destination_resource_id", destination_resource_id)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if limit_level is not None:
            pulumi.set(__self__, "limit_level", limit_level)
        if monitored_resource_id is not None:
            pulumi.set(__self__, "monitored_resource_id", monitored_resource_id)

    @property
    @pulumi.getter(name="destinationResourceId")
    def destination_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "destination_resource_id")

    @destination_resource_id.setter
    def destination_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_resource_id", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesListMemberItemArgs']]]]:
        """
        List of member resources.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesListMemberItemArgs']]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter(name="limitLevel")
    def limit_level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The field which determines the depth of hierarchy while searching for members.
        """
        return pulumi.get(self, "limit_level")

    @limit_level.setter
    def limit_level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "limit_level", value)

    @property
    @pulumi.getter(name="monitoredResourceId")
    def monitored_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of monitored resource.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "monitored_resource_id")

    @monitored_resource_id.setter
    def monitored_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "monitored_resource_id", value)


@pulumi.type_token("oci:StackMonitoring/monitoredResourcesListMember:MonitoredResourcesListMember")
class MonitoredResourcesListMember(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 limit_level: Optional[pulumi.Input[builtins.int]] = None,
                 monitored_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Monitored Resources List Member resource in Oracle Cloud Infrastructure Stack Monitoring service.

        List the member resources for the given monitored resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitored_resources_list_member = oci.stack_monitoring.MonitoredResourcesListMember("test_monitored_resources_list_member",
            monitored_resource_id=test_monitored_resource["id"],
            destination_resource_id=test_destination_resource["id"],
            limit_level=monitored_resources_list_member_limit_level)
        ```

        ## Import

        MonitoredResourcesListMembers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoredResourcesListMember:MonitoredResourcesListMember test_monitored_resources_list_member "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] destination_resource_id: Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.int] limit_level: The field which determines the depth of hierarchy while searching for members.
        :param pulumi.Input[builtins.str] monitored_resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of monitored resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitoredResourcesListMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Monitored Resources List Member resource in Oracle Cloud Infrastructure Stack Monitoring service.

        List the member resources for the given monitored resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitored_resources_list_member = oci.stack_monitoring.MonitoredResourcesListMember("test_monitored_resources_list_member",
            monitored_resource_id=test_monitored_resource["id"],
            destination_resource_id=test_destination_resource["id"],
            limit_level=monitored_resources_list_member_limit_level)
        ```

        ## Import

        MonitoredResourcesListMembers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoredResourcesListMember:MonitoredResourcesListMember test_monitored_resources_list_member "id"
        ```

        :param str resource_name: The name of the resource.
        :param MonitoredResourcesListMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitoredResourcesListMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 limit_level: Optional[pulumi.Input[builtins.int]] = None,
                 monitored_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitoredResourcesListMemberArgs.__new__(MonitoredResourcesListMemberArgs)

            __props__.__dict__["destination_resource_id"] = destination_resource_id
            __props__.__dict__["limit_level"] = limit_level
            if monitored_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'monitored_resource_id'")
            __props__.__dict__["monitored_resource_id"] = monitored_resource_id
            __props__.__dict__["items"] = None
        super(MonitoredResourcesListMember, __self__).__init__(
            'oci:StackMonitoring/monitoredResourcesListMember:MonitoredResourcesListMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            destination_resource_id: Optional[pulumi.Input[builtins.str]] = None,
            items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourcesListMemberItemArgs', 'MonitoredResourcesListMemberItemArgsDict']]]]] = None,
            limit_level: Optional[pulumi.Input[builtins.int]] = None,
            monitored_resource_id: Optional[pulumi.Input[builtins.str]] = None) -> 'MonitoredResourcesListMember':
        """
        Get an existing MonitoredResourcesListMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] destination_resource_id: Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourcesListMemberItemArgs', 'MonitoredResourcesListMemberItemArgsDict']]]] items: List of member resources.
        :param pulumi.Input[builtins.int] limit_level: The field which determines the depth of hierarchy while searching for members.
        :param pulumi.Input[builtins.str] monitored_resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of monitored resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitoredResourcesListMemberState.__new__(_MonitoredResourcesListMemberState)

        __props__.__dict__["destination_resource_id"] = destination_resource_id
        __props__.__dict__["items"] = items
        __props__.__dict__["limit_level"] = limit_level
        __props__.__dict__["monitored_resource_id"] = monitored_resource_id
        return MonitoredResourcesListMember(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="destinationResourceId")
    def destination_resource_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "destination_resource_id")

    @property
    @pulumi.getter
    def items(self) -> pulumi.Output[Sequence['outputs.MonitoredResourcesListMemberItem']]:
        """
        List of member resources.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="limitLevel")
    def limit_level(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The field which determines the depth of hierarchy while searching for members.
        """
        return pulumi.get(self, "limit_level")

    @property
    @pulumi.getter(name="monitoredResourceId")
    def monitored_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of monitored resource.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "monitored_resource_id")

