# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppAccelerationPolicyArgs', 'AppAccelerationPolicy']

@pulumi.input_type
class AppAccelerationPolicyArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 response_caching_policy: Optional[pulumi.Input['AppAccelerationPolicyResponseCachingPolicyArgs']] = None,
                 response_compression_policy: Optional[pulumi.Input['AppAccelerationPolicyResponseCompressionPolicyArgs']] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a AppAccelerationPolicy resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) WebAppAccelerationPolicy display name, can be renamed.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input['AppAccelerationPolicyResponseCachingPolicyArgs'] response_caching_policy: (Updatable) An object that specifies an HTTP response caching policy.
        :param pulumi.Input['AppAccelerationPolicyResponseCompressionPolicyArgs'] response_compression_policy: (Updatable) An object that specifies a compression policy for HTTP response from ENABLEMENT POINT to the client.
               
               This compression policy can be used to enable support for HTTP response compression algorithms like gzip and configure the conditions of when a compression algorithm will be used.
               
               HTTP responses will only be compressed if the client indicates support for one of the enabled compression algorithms via the "Accept-Encoding" request header.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: (Updatable) Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if response_caching_policy is not None:
            pulumi.set(__self__, "response_caching_policy", response_caching_policy)
        if response_compression_policy is not None:
            pulumi.set(__self__, "response_compression_policy", response_compression_policy)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) WebAppAccelerationPolicy display name, can be renamed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="responseCachingPolicy")
    def response_caching_policy(self) -> Optional[pulumi.Input['AppAccelerationPolicyResponseCachingPolicyArgs']]:
        """
        (Updatable) An object that specifies an HTTP response caching policy.
        """
        return pulumi.get(self, "response_caching_policy")

    @response_caching_policy.setter
    def response_caching_policy(self, value: Optional[pulumi.Input['AppAccelerationPolicyResponseCachingPolicyArgs']]):
        pulumi.set(self, "response_caching_policy", value)

    @property
    @pulumi.getter(name="responseCompressionPolicy")
    def response_compression_policy(self) -> Optional[pulumi.Input['AppAccelerationPolicyResponseCompressionPolicyArgs']]:
        """
        (Updatable) An object that specifies a compression policy for HTTP response from ENABLEMENT POINT to the client.

        This compression policy can be used to enable support for HTTP response compression algorithms like gzip and configure the conditions of when a compression algorithm will be used.

        HTTP responses will only be compressed if the client indicates support for one of the enabled compression algorithms via the "Accept-Encoding" request header.
        """
        return pulumi.get(self, "response_compression_policy")

    @response_compression_policy.setter
    def response_compression_policy(self, value: Optional[pulumi.Input['AppAccelerationPolicyResponseCompressionPolicyArgs']]):
        pulumi.set(self, "response_compression_policy", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)


@pulumi.input_type
class _AppAccelerationPolicyState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 response_caching_policy: Optional[pulumi.Input['AppAccelerationPolicyResponseCachingPolicyArgs']] = None,
                 response_compression_policy: Optional[pulumi.Input['AppAccelerationPolicyResponseCompressionPolicyArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppAccelerationPolicy resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) WebAppAccelerationPolicy display name, can be renamed.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in FAILED state.
        :param pulumi.Input['AppAccelerationPolicyResponseCachingPolicyArgs'] response_caching_policy: (Updatable) An object that specifies an HTTP response caching policy.
        :param pulumi.Input['AppAccelerationPolicyResponseCompressionPolicyArgs'] response_compression_policy: (Updatable) An object that specifies a compression policy for HTTP response from ENABLEMENT POINT to the client.
               
               This compression policy can be used to enable support for HTTP response compression algorithms like gzip and configure the conditions of when a compression algorithm will be used.
               
               HTTP responses will only be compressed if the client indicates support for one of the enabled compression algorithms via the "Accept-Encoding" request header.
        :param pulumi.Input[builtins.str] state: The current state of the WebAppAccelerationPolicy.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: (Updatable) Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The time the WebAppAccelerationPolicy was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: The time the WebAppAccelerationPolicy was updated. An RFC3339 formatted datetime string.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if response_caching_policy is not None:
            pulumi.set(__self__, "response_caching_policy", response_caching_policy)
        if response_compression_policy is not None:
            pulumi.set(__self__, "response_compression_policy", response_compression_policy)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) WebAppAccelerationPolicy display name, can be renamed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in FAILED state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="responseCachingPolicy")
    def response_caching_policy(self) -> Optional[pulumi.Input['AppAccelerationPolicyResponseCachingPolicyArgs']]:
        """
        (Updatable) An object that specifies an HTTP response caching policy.
        """
        return pulumi.get(self, "response_caching_policy")

    @response_caching_policy.setter
    def response_caching_policy(self, value: Optional[pulumi.Input['AppAccelerationPolicyResponseCachingPolicyArgs']]):
        pulumi.set(self, "response_caching_policy", value)

    @property
    @pulumi.getter(name="responseCompressionPolicy")
    def response_compression_policy(self) -> Optional[pulumi.Input['AppAccelerationPolicyResponseCompressionPolicyArgs']]:
        """
        (Updatable) An object that specifies a compression policy for HTTP response from ENABLEMENT POINT to the client.

        This compression policy can be used to enable support for HTTP response compression algorithms like gzip and configure the conditions of when a compression algorithm will be used.

        HTTP responses will only be compressed if the client indicates support for one of the enabled compression algorithms via the "Accept-Encoding" request header.
        """
        return pulumi.get(self, "response_compression_policy")

    @response_compression_policy.setter
    def response_compression_policy(self, value: Optional[pulumi.Input['AppAccelerationPolicyResponseCompressionPolicyArgs']]):
        pulumi.set(self, "response_compression_policy", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the WebAppAccelerationPolicy.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the WebAppAccelerationPolicy was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the WebAppAccelerationPolicy was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:Waa/appAccelerationPolicy:AppAccelerationPolicy")
class AppAccelerationPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 response_caching_policy: Optional[pulumi.Input[Union['AppAccelerationPolicyResponseCachingPolicyArgs', 'AppAccelerationPolicyResponseCachingPolicyArgsDict']]] = None,
                 response_compression_policy: Optional[pulumi.Input[Union['AppAccelerationPolicyResponseCompressionPolicyArgs', 'AppAccelerationPolicyResponseCompressionPolicyArgsDict']]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Web App Acceleration Policy resource in Oracle Cloud Infrastructure Waa service.

        Creates a new WebAppAccelerationPolicy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_web_app_acceleration_policy = oci.waa.AppAccelerationPolicy("test_web_app_acceleration_policy",
            compartment_id=compartment_id,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=web_app_acceleration_policy_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            response_caching_policy={
                "is_response_header_based_caching_enabled": web_app_acceleration_policy_response_caching_policy_is_response_header_based_caching_enabled,
            },
            response_compression_policy={
                "gzip_compression": {
                    "is_enabled": web_app_acceleration_policy_response_compression_policy_gzip_compression_is_enabled,
                },
            },
            system_tags=web_app_acceleration_policy_system_tags)
        ```

        ## Import

        WebAppAccelerationPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Waa/appAccelerationPolicy:AppAccelerationPolicy test_web_app_acceleration_policy "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) WebAppAccelerationPolicy display name, can be renamed.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Union['AppAccelerationPolicyResponseCachingPolicyArgs', 'AppAccelerationPolicyResponseCachingPolicyArgsDict']] response_caching_policy: (Updatable) An object that specifies an HTTP response caching policy.
        :param pulumi.Input[Union['AppAccelerationPolicyResponseCompressionPolicyArgs', 'AppAccelerationPolicyResponseCompressionPolicyArgsDict']] response_compression_policy: (Updatable) An object that specifies a compression policy for HTTP response from ENABLEMENT POINT to the client.
               
               This compression policy can be used to enable support for HTTP response compression algorithms like gzip and configure the conditions of when a compression algorithm will be used.
               
               HTTP responses will only be compressed if the client indicates support for one of the enabled compression algorithms via the "Accept-Encoding" request header.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: (Updatable) Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppAccelerationPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Web App Acceleration Policy resource in Oracle Cloud Infrastructure Waa service.

        Creates a new WebAppAccelerationPolicy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_web_app_acceleration_policy = oci.waa.AppAccelerationPolicy("test_web_app_acceleration_policy",
            compartment_id=compartment_id,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=web_app_acceleration_policy_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            response_caching_policy={
                "is_response_header_based_caching_enabled": web_app_acceleration_policy_response_caching_policy_is_response_header_based_caching_enabled,
            },
            response_compression_policy={
                "gzip_compression": {
                    "is_enabled": web_app_acceleration_policy_response_compression_policy_gzip_compression_is_enabled,
                },
            },
            system_tags=web_app_acceleration_policy_system_tags)
        ```

        ## Import

        WebAppAccelerationPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Waa/appAccelerationPolicy:AppAccelerationPolicy test_web_app_acceleration_policy "id"
        ```

        :param str resource_name: The name of the resource.
        :param AppAccelerationPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppAccelerationPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 response_caching_policy: Optional[pulumi.Input[Union['AppAccelerationPolicyResponseCachingPolicyArgs', 'AppAccelerationPolicyResponseCachingPolicyArgsDict']]] = None,
                 response_compression_policy: Optional[pulumi.Input[Union['AppAccelerationPolicyResponseCompressionPolicyArgs', 'AppAccelerationPolicyResponseCompressionPolicyArgsDict']]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppAccelerationPolicyArgs.__new__(AppAccelerationPolicyArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["response_caching_policy"] = response_caching_policy
            __props__.__dict__["response_compression_policy"] = response_compression_policy
            __props__.__dict__["system_tags"] = system_tags
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(AppAccelerationPolicy, __self__).__init__(
            'oci:Waa/appAccelerationPolicy:AppAccelerationPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            response_caching_policy: Optional[pulumi.Input[Union['AppAccelerationPolicyResponseCachingPolicyArgs', 'AppAccelerationPolicyResponseCachingPolicyArgsDict']]] = None,
            response_compression_policy: Optional[pulumi.Input[Union['AppAccelerationPolicyResponseCompressionPolicyArgs', 'AppAccelerationPolicyResponseCompressionPolicyArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'AppAccelerationPolicy':
        """
        Get an existing AppAccelerationPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) WebAppAccelerationPolicy display name, can be renamed.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in FAILED state.
        :param pulumi.Input[Union['AppAccelerationPolicyResponseCachingPolicyArgs', 'AppAccelerationPolicyResponseCachingPolicyArgsDict']] response_caching_policy: (Updatable) An object that specifies an HTTP response caching policy.
        :param pulumi.Input[Union['AppAccelerationPolicyResponseCompressionPolicyArgs', 'AppAccelerationPolicyResponseCompressionPolicyArgsDict']] response_compression_policy: (Updatable) An object that specifies a compression policy for HTTP response from ENABLEMENT POINT to the client.
               
               This compression policy can be used to enable support for HTTP response compression algorithms like gzip and configure the conditions of when a compression algorithm will be used.
               
               HTTP responses will only be compressed if the client indicates support for one of the enabled compression algorithms via the "Accept-Encoding" request header.
        :param pulumi.Input[builtins.str] state: The current state of the WebAppAccelerationPolicy.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: (Updatable) Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The time the WebAppAccelerationPolicy was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: The time the WebAppAccelerationPolicy was updated. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppAccelerationPolicyState.__new__(_AppAccelerationPolicyState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["response_caching_policy"] = response_caching_policy
        __props__.__dict__["response_compression_policy"] = response_compression_policy
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return AppAccelerationPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) WebAppAccelerationPolicy display name, can be renamed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in FAILED state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="responseCachingPolicy")
    def response_caching_policy(self) -> pulumi.Output['outputs.AppAccelerationPolicyResponseCachingPolicy']:
        """
        (Updatable) An object that specifies an HTTP response caching policy.
        """
        return pulumi.get(self, "response_caching_policy")

    @property
    @pulumi.getter(name="responseCompressionPolicy")
    def response_compression_policy(self) -> pulumi.Output['outputs.AppAccelerationPolicyResponseCompressionPolicy']:
        """
        (Updatable) An object that specifies a compression policy for HTTP response from ENABLEMENT POINT to the client.

        This compression policy can be used to enable support for HTTP response compression algorithms like gzip and configure the conditions of when a compression algorithm will be used.

        HTTP responses will only be compressed if the client indicates support for one of the enabled compression algorithms via the "Accept-Encoding" request header.
        """
        return pulumi.get(self, "response_compression_policy")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the WebAppAccelerationPolicy.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time the WebAppAccelerationPolicy was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time the WebAppAccelerationPolicy was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

