/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Definitions                                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_OP_LIST
#undef GET_OP_LIST

spirv::AccessChainOp,
spirv::AddressOfOp,
spirv::AtomicAndOp,
spirv::AtomicCompareExchangeWeakOp,
spirv::AtomicIAddOp,
spirv::AtomicIDecrementOp,
spirv::AtomicIIncrementOp,
spirv::AtomicISubOp,
spirv::AtomicOrOp,
spirv::AtomicSMaxOp,
spirv::AtomicSMinOp,
spirv::AtomicUMaxOp,
spirv::AtomicUMinOp,
spirv::AtomicXorOp,
spirv::BitCountOp,
spirv::BitFieldInsertOp,
spirv::BitFieldSExtractOp,
spirv::BitFieldUExtractOp,
spirv::BitReverseOp,
spirv::BitcastOp,
spirv::BitwiseAndOp,
spirv::BitwiseOrOp,
spirv::BitwiseXorOp,
spirv::BranchConditionalOp,
spirv::BranchOp,
spirv::CompositeConstructOp,
spirv::CompositeExtractOp,
spirv::CompositeInsertOp,
spirv::ConstantOp,
spirv::ControlBarrierOp,
spirv::ConvertFToSOp,
spirv::ConvertFToUOp,
spirv::ConvertSToFOp,
spirv::ConvertUToFOp,
spirv::CooperativeMatrixLengthNVOp,
spirv::CooperativeMatrixLoadNVOp,
spirv::CooperativeMatrixMulAddNVOp,
spirv::CooperativeMatrixStoreNVOp,
spirv::EntryPointOp,
spirv::ExecutionModeOp,
spirv::FAddOp,
spirv::FConvertOp,
spirv::FDivOp,
spirv::FModOp,
spirv::FMulOp,
spirv::FNegateOp,
spirv::FOrdEqualOp,
spirv::FOrdGreaterThanEqualOp,
spirv::FOrdGreaterThanOp,
spirv::FOrdLessThanEqualOp,
spirv::FOrdLessThanOp,
spirv::FOrdNotEqualOp,
spirv::FRemOp,
spirv::FSubOp,
spirv::FUnordEqualOp,
spirv::FUnordGreaterThanEqualOp,
spirv::FUnordGreaterThanOp,
spirv::FUnordLessThanEqualOp,
spirv::FUnordLessThanOp,
spirv::FUnordNotEqualOp,
spirv::FuncOp,
spirv::FunctionCallOp,
spirv::GLSLCeilOp,
spirv::GLSLCosOp,
spirv::GLSLExpOp,
spirv::GLSLFAbsOp,
spirv::GLSLFMaxOp,
spirv::GLSLFMinOp,
spirv::GLSLFSignOp,
spirv::GLSLFloorOp,
spirv::GLSLInverseSqrtOp,
spirv::GLSLLogOp,
spirv::GLSLSAbsOp,
spirv::GLSLSMaxOp,
spirv::GLSLSMinOp,
spirv::GLSLSSignOp,
spirv::GLSLSinOp,
spirv::GLSLSqrtOp,
spirv::GLSLTanOp,
spirv::GLSLTanhOp,
spirv::GlobalVariableOp,
spirv::GroupNonUniformBallotOp,
spirv::GroupNonUniformElectOp,
spirv::GroupNonUniformFAddOp,
spirv::GroupNonUniformFMaxOp,
spirv::GroupNonUniformFMinOp,
spirv::GroupNonUniformFMulOp,
spirv::GroupNonUniformIAddOp,
spirv::GroupNonUniformIMulOp,
spirv::GroupNonUniformSMaxOp,
spirv::GroupNonUniformSMinOp,
spirv::GroupNonUniformUMaxOp,
spirv::GroupNonUniformUMinOp,
spirv::IAddOp,
spirv::IEqualOp,
spirv::IMulOp,
spirv::INotEqualOp,
spirv::ISubOp,
spirv::LoadOp,
spirv::LogicalAndOp,
spirv::LogicalEqualOp,
spirv::LogicalNotEqualOp,
spirv::LogicalNotOp,
spirv::LogicalOrOp,
spirv::LoopOp,
spirv::MatrixTimesScalarOp,
spirv::MemoryBarrierOp,
spirv::MergeOp,
spirv::ModuleEndOp,
spirv::ModuleOp,
spirv::NotOp,
spirv::ReferenceOfOp,
spirv::ReturnOp,
spirv::ReturnValueOp,
spirv::SConvertOp,
spirv::SDivOp,
spirv::SGreaterThanEqualOp,
spirv::SGreaterThanOp,
spirv::SLessThanEqualOp,
spirv::SLessThanOp,
spirv::SModOp,
spirv::SRemOp,
spirv::SelectOp,
spirv::SelectionOp,
spirv::ShiftLeftLogicalOp,
spirv::ShiftRightArithmeticOp,
spirv::ShiftRightLogicalOp,
spirv::SpecConstantOp,
spirv::StoreOp,
spirv::SubgroupBallotKHROp,
spirv::UConvertOp,
spirv::UDivOp,
spirv::UGreaterThanEqualOp,
spirv::UGreaterThanOp,
spirv::ULessThanEqualOp,
spirv::ULessThanOp,
spirv::UModOp,
spirv::UndefOp,
spirv::UnreachableOp,
spirv::VariableOp
#endif  // GET_OP_LIST

#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES


//===----------------------------------------------------------------------===//
// spirv::AccessChainOp definitions
//===----------------------------------------------------------------------===//

AccessChainOpAdaptor::AccessChainOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

AccessChainOpAdaptor::AccessChainOpAdaptor(AccessChainOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> AccessChainOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

ValueRange AccessChainOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value AccessChainOpAdaptor::base_ptr() {
  return *getODSOperands(0).begin();
}

ValueRange AccessChainOpAdaptor::indices() {
  return getODSOperands(1);
}

LogicalResult AccessChainOpAdaptor::verify(Location loc) {
  return success();
}

StringRef AccessChainOp::getOperationName() {
  return "spv.AccessChain";
}

std::pair<unsigned, unsigned> AccessChainOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

Operation::operand_range AccessChainOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value AccessChainOp::base_ptr() {
  return *getODSOperands(0).begin();
}

Operation::operand_range AccessChainOp::indices() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange AccessChainOp::base_ptrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange AccessChainOp::indicesMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> AccessChainOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range AccessChainOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value AccessChainOp::component_ptr() {
  return *getODSResults(0).begin();
}



void AccessChainOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type component_ptr, Value base_ptr, ValueRange indices) {
  odsState.addOperands(base_ptr);
  odsState.addOperands(indices);
  odsState.addTypes(component_ptr);
}

void AccessChainOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value base_ptr, ValueRange indices) {
  odsState.addOperands(base_ptr);
  odsState.addOperands(indices);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AccessChainOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult AccessChainOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseAccessChainOp(parser, result);
}

void AccessChainOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult AccessChainOp::verify() {
  if (failed(AccessChainOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("result #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verify(*this);
}











void AccessChainOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::AddressOfOp definitions
//===----------------------------------------------------------------------===//

AddressOfOpAdaptor::AddressOfOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

AddressOfOpAdaptor::AddressOfOpAdaptor(AddressOfOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> AddressOfOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange AddressOfOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

FlatSymbolRefAttr AddressOfOpAdaptor::variable() {
  assert(odsAttrs && "no attributes when constructing adapter");
  FlatSymbolRefAttr attr = odsAttrs.get("variable").cast<FlatSymbolRefAttr>();
  return attr;
}

LogicalResult AddressOfOpAdaptor::verify(Location loc) {
  {
  auto tblgen_variable = odsAttrs.get("variable");
  if (!tblgen_variable) return emitError(loc, "'spv._address_of' op ""requires attribute 'variable'");
    if (!((tblgen_variable.isa<FlatSymbolRefAttr>()))) return emitError(loc, "'spv._address_of' op ""attribute 'variable' failed to satisfy constraint: flat symbol reference attribute");
  }
  return success();
}

StringRef AddressOfOp::getOperationName() {
  return "spv._address_of";
}

std::pair<unsigned, unsigned> AddressOfOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range AddressOfOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> AddressOfOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range AddressOfOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value AddressOfOp::pointer() {
  return *getODSResults(0).begin();
}

FlatSymbolRefAttr AddressOfOp::variableAttr() {
  return this->getAttr("variable").cast<FlatSymbolRefAttr>();
}

StringRef AddressOfOp::variable() {
  auto attr = variableAttr();
  return attr.getValue();
}

void AddressOfOp::variableAttr(FlatSymbolRefAttr attr) {
  this->getOperation()->setAttr("variable", attr);
}



void AddressOfOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type pointer, FlatSymbolRefAttr variable) {
  odsState.addAttribute("variable", variable);
  odsState.addTypes(pointer);
}

void AddressOfOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, FlatSymbolRefAttr variable) {
  odsState.addAttribute("variable", variable);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AddressOfOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type pointer, StringRef variable) {
  odsState.addAttribute("variable", odsBuilder.getSymbolRefAttr(variable));
  odsState.addTypes(pointer);
}

void AddressOfOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, StringRef variable) {
  odsState.addAttribute("variable", odsBuilder.getSymbolRefAttr(variable));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AddressOfOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LogicalResult AddressOfOp::verify() {
  if (failed(AddressOfOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("result #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
  }
  if (!((isNestedInFunctionLikeOp((*this->getOperation()).getParentOp()))))
    return emitOpError("failed to verify that op must appear in a function-like op's block");
  return ::verify(*this);
}









ParseResult AddressOfOp::parse(OpAsmParser &parser, OperationState &result) {
  Type pointerRawTypes[1];
  ArrayRef<Type> pointerTypes(pointerRawTypes);

  FlatSymbolRefAttr variableAttr;
  if (parser.parseAttribute(variableAttr, parser.getBuilder().getType<NoneType>(), "variable", result.attributes))
    return failure();
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  if (parser.parseColon())
    return failure();

  if (parser.parseType(pointerRawTypes[0]))
    return failure();
  result.addTypes(pointerTypes);
  return success();
}

void AddressOfOp::print(OpAsmPrinter &p) {
  p << "spv._address_of";
  p << " ";
  p.printAttributeWithoutType(variableAttr());
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{"variable"});
  p << " " << ":";
  p << " ";
  p << ArrayRef<Type>(pointer().getType());
}

void AddressOfOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::AtomicAndOp definitions
//===----------------------------------------------------------------------===//

AtomicAndOpAdaptor::AtomicAndOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

AtomicAndOpAdaptor::AtomicAndOpAdaptor(AtomicAndOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> AtomicAndOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange AtomicAndOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value AtomicAndOpAdaptor::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicAndOpAdaptor::value() {
  return *getODSOperands(1).begin();
}

IntegerAttr AtomicAndOpAdaptor::memory_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr AtomicAndOpAdaptor::semantics() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("semantics").cast<IntegerAttr>();
  return attr;
}

LogicalResult AtomicAndOpAdaptor::verify(Location loc) {
  {
  auto tblgen_memory_scope = odsAttrs.get("memory_scope");
  if (!tblgen_memory_scope) return emitError(loc, "'spv.AtomicAnd' op ""requires attribute 'memory_scope'");
    if (!((((tblgen_memory_scope.isa<IntegerAttr>())) && ((tblgen_memory_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_memory_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicAnd' op ""attribute 'memory_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_semantics = odsAttrs.get("semantics");
  if (!tblgen_semantics) return emitError(loc, "'spv.AtomicAnd' op ""requires attribute 'semantics'");
    if (!((((tblgen_semantics.isa<IntegerAttr>())) && ((tblgen_semantics.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemorySemantics(tblgen_semantics.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicAnd' op ""attribute 'semantics' failed to satisfy constraint: valid SPIR-V MemorySemantics");
  }
  return success();
}

StringRef AtomicAndOp::getOperationName() {
  return "spv.AtomicAnd";
}

std::pair<unsigned, unsigned> AtomicAndOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range AtomicAndOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value AtomicAndOp::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicAndOp::value() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange AtomicAndOp::pointerMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange AtomicAndOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> AtomicAndOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range AtomicAndOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value AtomicAndOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr AtomicAndOp::memory_scopeAttr() {
  return this->getAttr("memory_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope AtomicAndOp::memory_scope() {
  auto attr = memory_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr AtomicAndOp::semanticsAttr() {
  return this->getAttr("semantics").cast<IntegerAttr>();
}

::mlir::spirv::MemorySemantics AtomicAndOp::semantics() {
  auto attr = semanticsAttr();
  return static_cast<::mlir::spirv::MemorySemantics>(attr.getInt());
}

void AtomicAndOp::memory_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_scope", attr);
}

void AtomicAndOp::semanticsAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("semantics", attr);
}

void AtomicAndOp::build(OpBuilder &builder, OperationState &state, Value pointer,
        ::mlir::spirv::Scope scope, ::mlir::spirv::MemorySemantics memory,
        Value value) {
build(builder, state, value.getType(), pointer, scope, memory, value);
}

void AtomicAndOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  odsState.addTypes(result);
}

void AtomicAndOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicAndOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  odsState.addTypes(result);
}

void AtomicAndOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicAndOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult AtomicAndOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseAtomicUpdateOp(parser, result, true);
}

void AtomicAndOp::print(OpAsmPrinter &p) {
  return ::printAtomicUpdateOp(getOperation(), p);
}

LogicalResult AtomicAndOp::verify() {
  if (failed(AtomicAndOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyAtomicUpdateOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::AtomicCompareExchangeWeakOp definitions
//===----------------------------------------------------------------------===//

AtomicCompareExchangeWeakOpAdaptor::AtomicCompareExchangeWeakOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

AtomicCompareExchangeWeakOpAdaptor::AtomicCompareExchangeWeakOpAdaptor(AtomicCompareExchangeWeakOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> AtomicCompareExchangeWeakOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange AtomicCompareExchangeWeakOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value AtomicCompareExchangeWeakOpAdaptor::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicCompareExchangeWeakOpAdaptor::value() {
  return *getODSOperands(1).begin();
}

Value AtomicCompareExchangeWeakOpAdaptor::comparator() {
  return *getODSOperands(2).begin();
}

IntegerAttr AtomicCompareExchangeWeakOpAdaptor::memory_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr AtomicCompareExchangeWeakOpAdaptor::equal_semantics() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("equal_semantics").cast<IntegerAttr>();
  return attr;
}

IntegerAttr AtomicCompareExchangeWeakOpAdaptor::unequal_semantics() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("unequal_semantics").cast<IntegerAttr>();
  return attr;
}

LogicalResult AtomicCompareExchangeWeakOpAdaptor::verify(Location loc) {
  {
  auto tblgen_memory_scope = odsAttrs.get("memory_scope");
  if (!tblgen_memory_scope) return emitError(loc, "'spv.AtomicCompareExchangeWeak' op ""requires attribute 'memory_scope'");
    if (!((((tblgen_memory_scope.isa<IntegerAttr>())) && ((tblgen_memory_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_memory_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicCompareExchangeWeak' op ""attribute 'memory_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_equal_semantics = odsAttrs.get("equal_semantics");
  if (!tblgen_equal_semantics) return emitError(loc, "'spv.AtomicCompareExchangeWeak' op ""requires attribute 'equal_semantics'");
    if (!((((tblgen_equal_semantics.isa<IntegerAttr>())) && ((tblgen_equal_semantics.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemorySemantics(tblgen_equal_semantics.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicCompareExchangeWeak' op ""attribute 'equal_semantics' failed to satisfy constraint: valid SPIR-V MemorySemantics");
  }
  {
  auto tblgen_unequal_semantics = odsAttrs.get("unequal_semantics");
  if (!tblgen_unequal_semantics) return emitError(loc, "'spv.AtomicCompareExchangeWeak' op ""requires attribute 'unequal_semantics'");
    if (!((((tblgen_unequal_semantics.isa<IntegerAttr>())) && ((tblgen_unequal_semantics.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemorySemantics(tblgen_unequal_semantics.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicCompareExchangeWeak' op ""attribute 'unequal_semantics' failed to satisfy constraint: valid SPIR-V MemorySemantics");
  }
  return success();
}

StringRef AtomicCompareExchangeWeakOp::getOperationName() {
  return "spv.AtomicCompareExchangeWeak";
}

std::pair<unsigned, unsigned> AtomicCompareExchangeWeakOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range AtomicCompareExchangeWeakOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value AtomicCompareExchangeWeakOp::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicCompareExchangeWeakOp::value() {
  return *getODSOperands(1).begin();
}

Value AtomicCompareExchangeWeakOp::comparator() {
  return *getODSOperands(2).begin();
}

::mlir::MutableOperandRange AtomicCompareExchangeWeakOp::pointerMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange AtomicCompareExchangeWeakOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange AtomicCompareExchangeWeakOp::comparatorMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> AtomicCompareExchangeWeakOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range AtomicCompareExchangeWeakOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value AtomicCompareExchangeWeakOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr AtomicCompareExchangeWeakOp::memory_scopeAttr() {
  return this->getAttr("memory_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope AtomicCompareExchangeWeakOp::memory_scope() {
  auto attr = memory_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr AtomicCompareExchangeWeakOp::equal_semanticsAttr() {
  return this->getAttr("equal_semantics").cast<IntegerAttr>();
}

::mlir::spirv::MemorySemantics AtomicCompareExchangeWeakOp::equal_semantics() {
  auto attr = equal_semanticsAttr();
  return static_cast<::mlir::spirv::MemorySemantics>(attr.getInt());
}

IntegerAttr AtomicCompareExchangeWeakOp::unequal_semanticsAttr() {
  return this->getAttr("unequal_semantics").cast<IntegerAttr>();
}

::mlir::spirv::MemorySemantics AtomicCompareExchangeWeakOp::unequal_semantics() {
  auto attr = unequal_semanticsAttr();
  return static_cast<::mlir::spirv::MemorySemantics>(attr.getInt());
}

void AtomicCompareExchangeWeakOp::memory_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_scope", attr);
}

void AtomicCompareExchangeWeakOp::equal_semanticsAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("equal_semantics", attr);
}

void AtomicCompareExchangeWeakOp::unequal_semanticsAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("unequal_semantics", attr);
}

void AtomicCompareExchangeWeakOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, IntegerAttr memory_scope, IntegerAttr equal_semantics, IntegerAttr unequal_semantics, Value value, Value comparator) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addOperands(comparator);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("equal_semantics", equal_semantics);
  odsState.addAttribute("unequal_semantics", unequal_semantics);
  odsState.addTypes(result);
}

void AtomicCompareExchangeWeakOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, IntegerAttr memory_scope, IntegerAttr equal_semantics, IntegerAttr unequal_semantics, Value value, Value comparator) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addOperands(comparator);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("equal_semantics", equal_semantics);
  odsState.addAttribute("unequal_semantics", unequal_semantics);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicCompareExchangeWeakOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, Value value, Value comparator) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addOperands(comparator);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("equal_semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(equal_semantics)));
  odsState.addAttribute("unequal_semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(unequal_semantics)));
  odsState.addTypes(result);
}

void AtomicCompareExchangeWeakOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics equal_semantics, ::mlir::spirv::MemorySemantics unequal_semantics, Value value, Value comparator) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addOperands(comparator);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("equal_semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(equal_semantics)));
  odsState.addAttribute("unequal_semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(unequal_semantics)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicCompareExchangeWeakOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult AtomicCompareExchangeWeakOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseAtomicCompareExchangeWeakOp(parser, result);
}

void AtomicCompareExchangeWeakOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult AtomicCompareExchangeWeakOp::verify() {
  if (failed(AtomicCompareExchangeWeakOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup2 = getODSOperands(2);
    for (Value v : valueGroup2) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verify(*this);
}










//===----------------------------------------------------------------------===//
// spirv::AtomicIAddOp definitions
//===----------------------------------------------------------------------===//

AtomicIAddOpAdaptor::AtomicIAddOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

AtomicIAddOpAdaptor::AtomicIAddOpAdaptor(AtomicIAddOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> AtomicIAddOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange AtomicIAddOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value AtomicIAddOpAdaptor::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicIAddOpAdaptor::value() {
  return *getODSOperands(1).begin();
}

IntegerAttr AtomicIAddOpAdaptor::memory_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr AtomicIAddOpAdaptor::semantics() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("semantics").cast<IntegerAttr>();
  return attr;
}

LogicalResult AtomicIAddOpAdaptor::verify(Location loc) {
  {
  auto tblgen_memory_scope = odsAttrs.get("memory_scope");
  if (!tblgen_memory_scope) return emitError(loc, "'spv.AtomicIAdd' op ""requires attribute 'memory_scope'");
    if (!((((tblgen_memory_scope.isa<IntegerAttr>())) && ((tblgen_memory_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_memory_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicIAdd' op ""attribute 'memory_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_semantics = odsAttrs.get("semantics");
  if (!tblgen_semantics) return emitError(loc, "'spv.AtomicIAdd' op ""requires attribute 'semantics'");
    if (!((((tblgen_semantics.isa<IntegerAttr>())) && ((tblgen_semantics.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemorySemantics(tblgen_semantics.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicIAdd' op ""attribute 'semantics' failed to satisfy constraint: valid SPIR-V MemorySemantics");
  }
  return success();
}

StringRef AtomicIAddOp::getOperationName() {
  return "spv.AtomicIAdd";
}

std::pair<unsigned, unsigned> AtomicIAddOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range AtomicIAddOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value AtomicIAddOp::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicIAddOp::value() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange AtomicIAddOp::pointerMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange AtomicIAddOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> AtomicIAddOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range AtomicIAddOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value AtomicIAddOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr AtomicIAddOp::memory_scopeAttr() {
  return this->getAttr("memory_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope AtomicIAddOp::memory_scope() {
  auto attr = memory_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr AtomicIAddOp::semanticsAttr() {
  return this->getAttr("semantics").cast<IntegerAttr>();
}

::mlir::spirv::MemorySemantics AtomicIAddOp::semantics() {
  auto attr = semanticsAttr();
  return static_cast<::mlir::spirv::MemorySemantics>(attr.getInt());
}

void AtomicIAddOp::memory_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_scope", attr);
}

void AtomicIAddOp::semanticsAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("semantics", attr);
}

void AtomicIAddOp::build(OpBuilder &builder, OperationState &state, Value pointer,
        ::mlir::spirv::Scope scope, ::mlir::spirv::MemorySemantics memory,
        Value value) {
build(builder, state, value.getType(), pointer, scope, memory, value);
}

void AtomicIAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  odsState.addTypes(result);
}

void AtomicIAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicIAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  odsState.addTypes(result);
}

void AtomicIAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicIAddOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult AtomicIAddOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseAtomicUpdateOp(parser, result, true);
}

void AtomicIAddOp::print(OpAsmPrinter &p) {
  return ::printAtomicUpdateOp(getOperation(), p);
}

LogicalResult AtomicIAddOp::verify() {
  if (failed(AtomicIAddOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyAtomicUpdateOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::AtomicIDecrementOp definitions
//===----------------------------------------------------------------------===//

AtomicIDecrementOpAdaptor::AtomicIDecrementOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

AtomicIDecrementOpAdaptor::AtomicIDecrementOpAdaptor(AtomicIDecrementOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> AtomicIDecrementOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange AtomicIDecrementOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value AtomicIDecrementOpAdaptor::pointer() {
  return *getODSOperands(0).begin();
}

IntegerAttr AtomicIDecrementOpAdaptor::memory_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr AtomicIDecrementOpAdaptor::semantics() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("semantics").cast<IntegerAttr>();
  return attr;
}

LogicalResult AtomicIDecrementOpAdaptor::verify(Location loc) {
  {
  auto tblgen_memory_scope = odsAttrs.get("memory_scope");
  if (!tblgen_memory_scope) return emitError(loc, "'spv.AtomicIDecrement' op ""requires attribute 'memory_scope'");
    if (!((((tblgen_memory_scope.isa<IntegerAttr>())) && ((tblgen_memory_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_memory_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicIDecrement' op ""attribute 'memory_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_semantics = odsAttrs.get("semantics");
  if (!tblgen_semantics) return emitError(loc, "'spv.AtomicIDecrement' op ""requires attribute 'semantics'");
    if (!((((tblgen_semantics.isa<IntegerAttr>())) && ((tblgen_semantics.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemorySemantics(tblgen_semantics.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicIDecrement' op ""attribute 'semantics' failed to satisfy constraint: valid SPIR-V MemorySemantics");
  }
  return success();
}

StringRef AtomicIDecrementOp::getOperationName() {
  return "spv.AtomicIDecrement";
}

std::pair<unsigned, unsigned> AtomicIDecrementOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range AtomicIDecrementOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value AtomicIDecrementOp::pointer() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange AtomicIDecrementOp::pointerMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> AtomicIDecrementOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range AtomicIDecrementOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value AtomicIDecrementOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr AtomicIDecrementOp::memory_scopeAttr() {
  return this->getAttr("memory_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope AtomicIDecrementOp::memory_scope() {
  auto attr = memory_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr AtomicIDecrementOp::semanticsAttr() {
  return this->getAttr("semantics").cast<IntegerAttr>();
}

::mlir::spirv::MemorySemantics AtomicIDecrementOp::semantics() {
  auto attr = semanticsAttr();
  return static_cast<::mlir::spirv::MemorySemantics>(attr.getInt());
}

void AtomicIDecrementOp::memory_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_scope", attr);
}

void AtomicIDecrementOp::semanticsAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("semantics", attr);
}

void AtomicIDecrementOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics) {
  odsState.addOperands(pointer);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  odsState.addTypes(result);
}

void AtomicIDecrementOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics) {
  odsState.addOperands(pointer);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicIDecrementOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics) {
  odsState.addOperands(pointer);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  odsState.addTypes(result);
}

void AtomicIDecrementOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics) {
  odsState.addOperands(pointer);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicIDecrementOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult AtomicIDecrementOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseAtomicUpdateOp(parser, result, false);
}

void AtomicIDecrementOp::print(OpAsmPrinter &p) {
  return ::printAtomicUpdateOp(getOperation(), p);
}

LogicalResult AtomicIDecrementOp::verify() {
  if (failed(AtomicIDecrementOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyAtomicUpdateOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::AtomicIIncrementOp definitions
//===----------------------------------------------------------------------===//

AtomicIIncrementOpAdaptor::AtomicIIncrementOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

AtomicIIncrementOpAdaptor::AtomicIIncrementOpAdaptor(AtomicIIncrementOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> AtomicIIncrementOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange AtomicIIncrementOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value AtomicIIncrementOpAdaptor::pointer() {
  return *getODSOperands(0).begin();
}

IntegerAttr AtomicIIncrementOpAdaptor::memory_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr AtomicIIncrementOpAdaptor::semantics() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("semantics").cast<IntegerAttr>();
  return attr;
}

LogicalResult AtomicIIncrementOpAdaptor::verify(Location loc) {
  {
  auto tblgen_memory_scope = odsAttrs.get("memory_scope");
  if (!tblgen_memory_scope) return emitError(loc, "'spv.AtomicIIncrement' op ""requires attribute 'memory_scope'");
    if (!((((tblgen_memory_scope.isa<IntegerAttr>())) && ((tblgen_memory_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_memory_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicIIncrement' op ""attribute 'memory_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_semantics = odsAttrs.get("semantics");
  if (!tblgen_semantics) return emitError(loc, "'spv.AtomicIIncrement' op ""requires attribute 'semantics'");
    if (!((((tblgen_semantics.isa<IntegerAttr>())) && ((tblgen_semantics.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemorySemantics(tblgen_semantics.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicIIncrement' op ""attribute 'semantics' failed to satisfy constraint: valid SPIR-V MemorySemantics");
  }
  return success();
}

StringRef AtomicIIncrementOp::getOperationName() {
  return "spv.AtomicIIncrement";
}

std::pair<unsigned, unsigned> AtomicIIncrementOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range AtomicIIncrementOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value AtomicIIncrementOp::pointer() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange AtomicIIncrementOp::pointerMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> AtomicIIncrementOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range AtomicIIncrementOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value AtomicIIncrementOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr AtomicIIncrementOp::memory_scopeAttr() {
  return this->getAttr("memory_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope AtomicIIncrementOp::memory_scope() {
  auto attr = memory_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr AtomicIIncrementOp::semanticsAttr() {
  return this->getAttr("semantics").cast<IntegerAttr>();
}

::mlir::spirv::MemorySemantics AtomicIIncrementOp::semantics() {
  auto attr = semanticsAttr();
  return static_cast<::mlir::spirv::MemorySemantics>(attr.getInt());
}

void AtomicIIncrementOp::memory_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_scope", attr);
}

void AtomicIIncrementOp::semanticsAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("semantics", attr);
}

void AtomicIIncrementOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics) {
  odsState.addOperands(pointer);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  odsState.addTypes(result);
}

void AtomicIIncrementOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics) {
  odsState.addOperands(pointer);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicIIncrementOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics) {
  odsState.addOperands(pointer);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  odsState.addTypes(result);
}

void AtomicIIncrementOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics) {
  odsState.addOperands(pointer);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicIIncrementOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult AtomicIIncrementOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseAtomicUpdateOp(parser, result, false);
}

void AtomicIIncrementOp::print(OpAsmPrinter &p) {
  return ::printAtomicUpdateOp(getOperation(), p);
}

LogicalResult AtomicIIncrementOp::verify() {
  if (failed(AtomicIIncrementOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyAtomicUpdateOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::AtomicISubOp definitions
//===----------------------------------------------------------------------===//

AtomicISubOpAdaptor::AtomicISubOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

AtomicISubOpAdaptor::AtomicISubOpAdaptor(AtomicISubOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> AtomicISubOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange AtomicISubOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value AtomicISubOpAdaptor::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicISubOpAdaptor::value() {
  return *getODSOperands(1).begin();
}

IntegerAttr AtomicISubOpAdaptor::memory_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr AtomicISubOpAdaptor::semantics() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("semantics").cast<IntegerAttr>();
  return attr;
}

LogicalResult AtomicISubOpAdaptor::verify(Location loc) {
  {
  auto tblgen_memory_scope = odsAttrs.get("memory_scope");
  if (!tblgen_memory_scope) return emitError(loc, "'spv.AtomicISub' op ""requires attribute 'memory_scope'");
    if (!((((tblgen_memory_scope.isa<IntegerAttr>())) && ((tblgen_memory_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_memory_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicISub' op ""attribute 'memory_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_semantics = odsAttrs.get("semantics");
  if (!tblgen_semantics) return emitError(loc, "'spv.AtomicISub' op ""requires attribute 'semantics'");
    if (!((((tblgen_semantics.isa<IntegerAttr>())) && ((tblgen_semantics.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemorySemantics(tblgen_semantics.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicISub' op ""attribute 'semantics' failed to satisfy constraint: valid SPIR-V MemorySemantics");
  }
  return success();
}

StringRef AtomicISubOp::getOperationName() {
  return "spv.AtomicISub";
}

std::pair<unsigned, unsigned> AtomicISubOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range AtomicISubOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value AtomicISubOp::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicISubOp::value() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange AtomicISubOp::pointerMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange AtomicISubOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> AtomicISubOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range AtomicISubOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value AtomicISubOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr AtomicISubOp::memory_scopeAttr() {
  return this->getAttr("memory_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope AtomicISubOp::memory_scope() {
  auto attr = memory_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr AtomicISubOp::semanticsAttr() {
  return this->getAttr("semantics").cast<IntegerAttr>();
}

::mlir::spirv::MemorySemantics AtomicISubOp::semantics() {
  auto attr = semanticsAttr();
  return static_cast<::mlir::spirv::MemorySemantics>(attr.getInt());
}

void AtomicISubOp::memory_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_scope", attr);
}

void AtomicISubOp::semanticsAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("semantics", attr);
}

void AtomicISubOp::build(OpBuilder &builder, OperationState &state, Value pointer,
        ::mlir::spirv::Scope scope, ::mlir::spirv::MemorySemantics memory,
        Value value) {
build(builder, state, value.getType(), pointer, scope, memory, value);
}

void AtomicISubOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  odsState.addTypes(result);
}

void AtomicISubOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicISubOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  odsState.addTypes(result);
}

void AtomicISubOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicISubOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult AtomicISubOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseAtomicUpdateOp(parser, result, true);
}

void AtomicISubOp::print(OpAsmPrinter &p) {
  return ::printAtomicUpdateOp(getOperation(), p);
}

LogicalResult AtomicISubOp::verify() {
  if (failed(AtomicISubOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyAtomicUpdateOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::AtomicOrOp definitions
//===----------------------------------------------------------------------===//

AtomicOrOpAdaptor::AtomicOrOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

AtomicOrOpAdaptor::AtomicOrOpAdaptor(AtomicOrOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> AtomicOrOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange AtomicOrOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value AtomicOrOpAdaptor::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicOrOpAdaptor::value() {
  return *getODSOperands(1).begin();
}

IntegerAttr AtomicOrOpAdaptor::memory_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr AtomicOrOpAdaptor::semantics() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("semantics").cast<IntegerAttr>();
  return attr;
}

LogicalResult AtomicOrOpAdaptor::verify(Location loc) {
  {
  auto tblgen_memory_scope = odsAttrs.get("memory_scope");
  if (!tblgen_memory_scope) return emitError(loc, "'spv.AtomicOr' op ""requires attribute 'memory_scope'");
    if (!((((tblgen_memory_scope.isa<IntegerAttr>())) && ((tblgen_memory_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_memory_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicOr' op ""attribute 'memory_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_semantics = odsAttrs.get("semantics");
  if (!tblgen_semantics) return emitError(loc, "'spv.AtomicOr' op ""requires attribute 'semantics'");
    if (!((((tblgen_semantics.isa<IntegerAttr>())) && ((tblgen_semantics.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemorySemantics(tblgen_semantics.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicOr' op ""attribute 'semantics' failed to satisfy constraint: valid SPIR-V MemorySemantics");
  }
  return success();
}

StringRef AtomicOrOp::getOperationName() {
  return "spv.AtomicOr";
}

std::pair<unsigned, unsigned> AtomicOrOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range AtomicOrOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value AtomicOrOp::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicOrOp::value() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange AtomicOrOp::pointerMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange AtomicOrOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> AtomicOrOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range AtomicOrOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value AtomicOrOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr AtomicOrOp::memory_scopeAttr() {
  return this->getAttr("memory_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope AtomicOrOp::memory_scope() {
  auto attr = memory_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr AtomicOrOp::semanticsAttr() {
  return this->getAttr("semantics").cast<IntegerAttr>();
}

::mlir::spirv::MemorySemantics AtomicOrOp::semantics() {
  auto attr = semanticsAttr();
  return static_cast<::mlir::spirv::MemorySemantics>(attr.getInt());
}

void AtomicOrOp::memory_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_scope", attr);
}

void AtomicOrOp::semanticsAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("semantics", attr);
}

void AtomicOrOp::build(OpBuilder &builder, OperationState &state, Value pointer,
        ::mlir::spirv::Scope scope, ::mlir::spirv::MemorySemantics memory,
        Value value) {
build(builder, state, value.getType(), pointer, scope, memory, value);
}

void AtomicOrOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  odsState.addTypes(result);
}

void AtomicOrOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicOrOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  odsState.addTypes(result);
}

void AtomicOrOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicOrOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult AtomicOrOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseAtomicUpdateOp(parser, result, true);
}

void AtomicOrOp::print(OpAsmPrinter &p) {
  return ::printAtomicUpdateOp(getOperation(), p);
}

LogicalResult AtomicOrOp::verify() {
  if (failed(AtomicOrOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyAtomicUpdateOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::AtomicSMaxOp definitions
//===----------------------------------------------------------------------===//

AtomicSMaxOpAdaptor::AtomicSMaxOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

AtomicSMaxOpAdaptor::AtomicSMaxOpAdaptor(AtomicSMaxOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> AtomicSMaxOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange AtomicSMaxOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value AtomicSMaxOpAdaptor::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicSMaxOpAdaptor::value() {
  return *getODSOperands(1).begin();
}

IntegerAttr AtomicSMaxOpAdaptor::memory_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr AtomicSMaxOpAdaptor::semantics() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("semantics").cast<IntegerAttr>();
  return attr;
}

LogicalResult AtomicSMaxOpAdaptor::verify(Location loc) {
  {
  auto tblgen_memory_scope = odsAttrs.get("memory_scope");
  if (!tblgen_memory_scope) return emitError(loc, "'spv.AtomicSMax' op ""requires attribute 'memory_scope'");
    if (!((((tblgen_memory_scope.isa<IntegerAttr>())) && ((tblgen_memory_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_memory_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicSMax' op ""attribute 'memory_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_semantics = odsAttrs.get("semantics");
  if (!tblgen_semantics) return emitError(loc, "'spv.AtomicSMax' op ""requires attribute 'semantics'");
    if (!((((tblgen_semantics.isa<IntegerAttr>())) && ((tblgen_semantics.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemorySemantics(tblgen_semantics.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicSMax' op ""attribute 'semantics' failed to satisfy constraint: valid SPIR-V MemorySemantics");
  }
  return success();
}

StringRef AtomicSMaxOp::getOperationName() {
  return "spv.AtomicSMax";
}

std::pair<unsigned, unsigned> AtomicSMaxOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range AtomicSMaxOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value AtomicSMaxOp::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicSMaxOp::value() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange AtomicSMaxOp::pointerMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange AtomicSMaxOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> AtomicSMaxOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range AtomicSMaxOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value AtomicSMaxOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr AtomicSMaxOp::memory_scopeAttr() {
  return this->getAttr("memory_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope AtomicSMaxOp::memory_scope() {
  auto attr = memory_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr AtomicSMaxOp::semanticsAttr() {
  return this->getAttr("semantics").cast<IntegerAttr>();
}

::mlir::spirv::MemorySemantics AtomicSMaxOp::semantics() {
  auto attr = semanticsAttr();
  return static_cast<::mlir::spirv::MemorySemantics>(attr.getInt());
}

void AtomicSMaxOp::memory_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_scope", attr);
}

void AtomicSMaxOp::semanticsAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("semantics", attr);
}

void AtomicSMaxOp::build(OpBuilder &builder, OperationState &state, Value pointer,
        ::mlir::spirv::Scope scope, ::mlir::spirv::MemorySemantics memory,
        Value value) {
build(builder, state, value.getType(), pointer, scope, memory, value);
}

void AtomicSMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  odsState.addTypes(result);
}

void AtomicSMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicSMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  odsState.addTypes(result);
}

void AtomicSMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicSMaxOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult AtomicSMaxOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseAtomicUpdateOp(parser, result, true);
}

void AtomicSMaxOp::print(OpAsmPrinter &p) {
  return ::printAtomicUpdateOp(getOperation(), p);
}

LogicalResult AtomicSMaxOp::verify() {
  if (failed(AtomicSMaxOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyAtomicUpdateOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::AtomicSMinOp definitions
//===----------------------------------------------------------------------===//

AtomicSMinOpAdaptor::AtomicSMinOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

AtomicSMinOpAdaptor::AtomicSMinOpAdaptor(AtomicSMinOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> AtomicSMinOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange AtomicSMinOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value AtomicSMinOpAdaptor::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicSMinOpAdaptor::value() {
  return *getODSOperands(1).begin();
}

IntegerAttr AtomicSMinOpAdaptor::memory_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr AtomicSMinOpAdaptor::semantics() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("semantics").cast<IntegerAttr>();
  return attr;
}

LogicalResult AtomicSMinOpAdaptor::verify(Location loc) {
  {
  auto tblgen_memory_scope = odsAttrs.get("memory_scope");
  if (!tblgen_memory_scope) return emitError(loc, "'spv.AtomicSMin' op ""requires attribute 'memory_scope'");
    if (!((((tblgen_memory_scope.isa<IntegerAttr>())) && ((tblgen_memory_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_memory_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicSMin' op ""attribute 'memory_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_semantics = odsAttrs.get("semantics");
  if (!tblgen_semantics) return emitError(loc, "'spv.AtomicSMin' op ""requires attribute 'semantics'");
    if (!((((tblgen_semantics.isa<IntegerAttr>())) && ((tblgen_semantics.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemorySemantics(tblgen_semantics.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicSMin' op ""attribute 'semantics' failed to satisfy constraint: valid SPIR-V MemorySemantics");
  }
  return success();
}

StringRef AtomicSMinOp::getOperationName() {
  return "spv.AtomicSMin";
}

std::pair<unsigned, unsigned> AtomicSMinOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range AtomicSMinOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value AtomicSMinOp::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicSMinOp::value() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange AtomicSMinOp::pointerMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange AtomicSMinOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> AtomicSMinOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range AtomicSMinOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value AtomicSMinOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr AtomicSMinOp::memory_scopeAttr() {
  return this->getAttr("memory_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope AtomicSMinOp::memory_scope() {
  auto attr = memory_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr AtomicSMinOp::semanticsAttr() {
  return this->getAttr("semantics").cast<IntegerAttr>();
}

::mlir::spirv::MemorySemantics AtomicSMinOp::semantics() {
  auto attr = semanticsAttr();
  return static_cast<::mlir::spirv::MemorySemantics>(attr.getInt());
}

void AtomicSMinOp::memory_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_scope", attr);
}

void AtomicSMinOp::semanticsAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("semantics", attr);
}

void AtomicSMinOp::build(OpBuilder &builder, OperationState &state, Value pointer,
        ::mlir::spirv::Scope scope, ::mlir::spirv::MemorySemantics memory,
        Value value) {
build(builder, state, value.getType(), pointer, scope, memory, value);
}

void AtomicSMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  odsState.addTypes(result);
}

void AtomicSMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicSMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  odsState.addTypes(result);
}

void AtomicSMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicSMinOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult AtomicSMinOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseAtomicUpdateOp(parser, result, true);
}

void AtomicSMinOp::print(OpAsmPrinter &p) {
  return ::printAtomicUpdateOp(getOperation(), p);
}

LogicalResult AtomicSMinOp::verify() {
  if (failed(AtomicSMinOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyAtomicUpdateOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::AtomicUMaxOp definitions
//===----------------------------------------------------------------------===//

AtomicUMaxOpAdaptor::AtomicUMaxOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

AtomicUMaxOpAdaptor::AtomicUMaxOpAdaptor(AtomicUMaxOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> AtomicUMaxOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange AtomicUMaxOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value AtomicUMaxOpAdaptor::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicUMaxOpAdaptor::value() {
  return *getODSOperands(1).begin();
}

IntegerAttr AtomicUMaxOpAdaptor::memory_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr AtomicUMaxOpAdaptor::semantics() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("semantics").cast<IntegerAttr>();
  return attr;
}

LogicalResult AtomicUMaxOpAdaptor::verify(Location loc) {
  {
  auto tblgen_memory_scope = odsAttrs.get("memory_scope");
  if (!tblgen_memory_scope) return emitError(loc, "'spv.AtomicUMax' op ""requires attribute 'memory_scope'");
    if (!((((tblgen_memory_scope.isa<IntegerAttr>())) && ((tblgen_memory_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_memory_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicUMax' op ""attribute 'memory_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_semantics = odsAttrs.get("semantics");
  if (!tblgen_semantics) return emitError(loc, "'spv.AtomicUMax' op ""requires attribute 'semantics'");
    if (!((((tblgen_semantics.isa<IntegerAttr>())) && ((tblgen_semantics.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemorySemantics(tblgen_semantics.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicUMax' op ""attribute 'semantics' failed to satisfy constraint: valid SPIR-V MemorySemantics");
  }
  return success();
}

StringRef AtomicUMaxOp::getOperationName() {
  return "spv.AtomicUMax";
}

std::pair<unsigned, unsigned> AtomicUMaxOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range AtomicUMaxOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value AtomicUMaxOp::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicUMaxOp::value() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange AtomicUMaxOp::pointerMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange AtomicUMaxOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> AtomicUMaxOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range AtomicUMaxOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value AtomicUMaxOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr AtomicUMaxOp::memory_scopeAttr() {
  return this->getAttr("memory_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope AtomicUMaxOp::memory_scope() {
  auto attr = memory_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr AtomicUMaxOp::semanticsAttr() {
  return this->getAttr("semantics").cast<IntegerAttr>();
}

::mlir::spirv::MemorySemantics AtomicUMaxOp::semantics() {
  auto attr = semanticsAttr();
  return static_cast<::mlir::spirv::MemorySemantics>(attr.getInt());
}

void AtomicUMaxOp::memory_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_scope", attr);
}

void AtomicUMaxOp::semanticsAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("semantics", attr);
}

void AtomicUMaxOp::build(OpBuilder &builder, OperationState &state, Value pointer,
        ::mlir::spirv::Scope scope, ::mlir::spirv::MemorySemantics memory,
        Value value) {
build(builder, state, value.getType(), pointer, scope, memory, value);
}

void AtomicUMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  odsState.addTypes(result);
}

void AtomicUMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicUMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  odsState.addTypes(result);
}

void AtomicUMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicUMaxOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult AtomicUMaxOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseAtomicUpdateOp(parser, result, true);
}

void AtomicUMaxOp::print(OpAsmPrinter &p) {
  return ::printAtomicUpdateOp(getOperation(), p);
}

LogicalResult AtomicUMaxOp::verify() {
  if (failed(AtomicUMaxOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyAtomicUpdateOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::AtomicUMinOp definitions
//===----------------------------------------------------------------------===//

AtomicUMinOpAdaptor::AtomicUMinOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

AtomicUMinOpAdaptor::AtomicUMinOpAdaptor(AtomicUMinOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> AtomicUMinOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange AtomicUMinOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value AtomicUMinOpAdaptor::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicUMinOpAdaptor::value() {
  return *getODSOperands(1).begin();
}

IntegerAttr AtomicUMinOpAdaptor::memory_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr AtomicUMinOpAdaptor::semantics() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("semantics").cast<IntegerAttr>();
  return attr;
}

LogicalResult AtomicUMinOpAdaptor::verify(Location loc) {
  {
  auto tblgen_memory_scope = odsAttrs.get("memory_scope");
  if (!tblgen_memory_scope) return emitError(loc, "'spv.AtomicUMin' op ""requires attribute 'memory_scope'");
    if (!((((tblgen_memory_scope.isa<IntegerAttr>())) && ((tblgen_memory_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_memory_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicUMin' op ""attribute 'memory_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_semantics = odsAttrs.get("semantics");
  if (!tblgen_semantics) return emitError(loc, "'spv.AtomicUMin' op ""requires attribute 'semantics'");
    if (!((((tblgen_semantics.isa<IntegerAttr>())) && ((tblgen_semantics.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemorySemantics(tblgen_semantics.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicUMin' op ""attribute 'semantics' failed to satisfy constraint: valid SPIR-V MemorySemantics");
  }
  return success();
}

StringRef AtomicUMinOp::getOperationName() {
  return "spv.AtomicUMin";
}

std::pair<unsigned, unsigned> AtomicUMinOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range AtomicUMinOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value AtomicUMinOp::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicUMinOp::value() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange AtomicUMinOp::pointerMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange AtomicUMinOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> AtomicUMinOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range AtomicUMinOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value AtomicUMinOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr AtomicUMinOp::memory_scopeAttr() {
  return this->getAttr("memory_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope AtomicUMinOp::memory_scope() {
  auto attr = memory_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr AtomicUMinOp::semanticsAttr() {
  return this->getAttr("semantics").cast<IntegerAttr>();
}

::mlir::spirv::MemorySemantics AtomicUMinOp::semantics() {
  auto attr = semanticsAttr();
  return static_cast<::mlir::spirv::MemorySemantics>(attr.getInt());
}

void AtomicUMinOp::memory_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_scope", attr);
}

void AtomicUMinOp::semanticsAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("semantics", attr);
}

void AtomicUMinOp::build(OpBuilder &builder, OperationState &state, Value pointer,
        ::mlir::spirv::Scope scope, ::mlir::spirv::MemorySemantics memory,
        Value value) {
build(builder, state, value.getType(), pointer, scope, memory, value);
}

void AtomicUMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  odsState.addTypes(result);
}

void AtomicUMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicUMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  odsState.addTypes(result);
}

void AtomicUMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicUMinOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult AtomicUMinOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseAtomicUpdateOp(parser, result, true);
}

void AtomicUMinOp::print(OpAsmPrinter &p) {
  return ::printAtomicUpdateOp(getOperation(), p);
}

LogicalResult AtomicUMinOp::verify() {
  if (failed(AtomicUMinOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyAtomicUpdateOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::AtomicXorOp definitions
//===----------------------------------------------------------------------===//

AtomicXorOpAdaptor::AtomicXorOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

AtomicXorOpAdaptor::AtomicXorOpAdaptor(AtomicXorOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> AtomicXorOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange AtomicXorOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value AtomicXorOpAdaptor::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicXorOpAdaptor::value() {
  return *getODSOperands(1).begin();
}

IntegerAttr AtomicXorOpAdaptor::memory_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr AtomicXorOpAdaptor::semantics() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("semantics").cast<IntegerAttr>();
  return attr;
}

LogicalResult AtomicXorOpAdaptor::verify(Location loc) {
  {
  auto tblgen_memory_scope = odsAttrs.get("memory_scope");
  if (!tblgen_memory_scope) return emitError(loc, "'spv.AtomicXor' op ""requires attribute 'memory_scope'");
    if (!((((tblgen_memory_scope.isa<IntegerAttr>())) && ((tblgen_memory_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_memory_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicXor' op ""attribute 'memory_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_semantics = odsAttrs.get("semantics");
  if (!tblgen_semantics) return emitError(loc, "'spv.AtomicXor' op ""requires attribute 'semantics'");
    if (!((((tblgen_semantics.isa<IntegerAttr>())) && ((tblgen_semantics.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemorySemantics(tblgen_semantics.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.AtomicXor' op ""attribute 'semantics' failed to satisfy constraint: valid SPIR-V MemorySemantics");
  }
  return success();
}

StringRef AtomicXorOp::getOperationName() {
  return "spv.AtomicXor";
}

std::pair<unsigned, unsigned> AtomicXorOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range AtomicXorOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value AtomicXorOp::pointer() {
  return *getODSOperands(0).begin();
}

Value AtomicXorOp::value() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange AtomicXorOp::pointerMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange AtomicXorOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> AtomicXorOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range AtomicXorOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value AtomicXorOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr AtomicXorOp::memory_scopeAttr() {
  return this->getAttr("memory_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope AtomicXorOp::memory_scope() {
  auto attr = memory_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr AtomicXorOp::semanticsAttr() {
  return this->getAttr("semantics").cast<IntegerAttr>();
}

::mlir::spirv::MemorySemantics AtomicXorOp::semantics() {
  auto attr = semanticsAttr();
  return static_cast<::mlir::spirv::MemorySemantics>(attr.getInt());
}

void AtomicXorOp::memory_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_scope", attr);
}

void AtomicXorOp::semanticsAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("semantics", attr);
}

void AtomicXorOp::build(OpBuilder &builder, OperationState &state, Value pointer,
        ::mlir::spirv::Scope scope, ::mlir::spirv::MemorySemantics memory,
        Value value) {
build(builder, state, value.getType(), pointer, scope, memory, value);
}

void AtomicXorOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  odsState.addTypes(result);
}

void AtomicXorOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, IntegerAttr memory_scope, IntegerAttr semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("semantics", semantics);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicXorOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  odsState.addTypes(result);
}

void AtomicXorOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics semantics, Value value) {
  odsState.addOperands(pointer);
  odsState.addOperands(value);
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(semantics)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicXorOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult AtomicXorOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseAtomicUpdateOp(parser, result, true);
}

void AtomicXorOp::print(OpAsmPrinter &p) {
  return ::printAtomicUpdateOp(getOperation(), p);
}

LogicalResult AtomicXorOp::verify() {
  if (failed(AtomicXorOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyAtomicUpdateOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::BitCountOp definitions
//===----------------------------------------------------------------------===//

BitCountOpAdaptor::BitCountOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

BitCountOpAdaptor::BitCountOpAdaptor(BitCountOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> BitCountOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange BitCountOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value BitCountOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult BitCountOpAdaptor::verify(Location loc) {
  return success();
}

StringRef BitCountOp::getOperationName() {
  return "spv.BitCount";
}

std::pair<unsigned, unsigned> BitCountOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range BitCountOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value BitCountOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange BitCountOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> BitCountOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range BitCountOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value BitCountOp::result() {
  return *getODSResults(0).begin();
}

void BitCountOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void BitCountOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void BitCountOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void BitCountOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes({operand.getType()});

}

void BitCountOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult BitCountOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseUnaryOp(parser, result);
}

void BitCountOp::print(OpAsmPrinter &p) {
  return ::printUnaryOp(getOperation(), p);
}

LogicalResult BitCountOp::verify() {
  if (failed(BitCountOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void BitCountOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::BitFieldInsertOp definitions
//===----------------------------------------------------------------------===//

BitFieldInsertOpAdaptor::BitFieldInsertOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

BitFieldInsertOpAdaptor::BitFieldInsertOpAdaptor(BitFieldInsertOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> BitFieldInsertOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange BitFieldInsertOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value BitFieldInsertOpAdaptor::base() {
  return *getODSOperands(0).begin();
}

Value BitFieldInsertOpAdaptor::insert() {
  return *getODSOperands(1).begin();
}

Value BitFieldInsertOpAdaptor::offset() {
  return *getODSOperands(2).begin();
}

Value BitFieldInsertOpAdaptor::count() {
  return *getODSOperands(3).begin();
}

LogicalResult BitFieldInsertOpAdaptor::verify(Location loc) {
  return success();
}

StringRef BitFieldInsertOp::getOperationName() {
  return "spv.BitFieldInsert";
}

std::pair<unsigned, unsigned> BitFieldInsertOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range BitFieldInsertOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value BitFieldInsertOp::base() {
  return *getODSOperands(0).begin();
}

Value BitFieldInsertOp::insert() {
  return *getODSOperands(1).begin();
}

Value BitFieldInsertOp::offset() {
  return *getODSOperands(2).begin();
}

Value BitFieldInsertOp::count() {
  return *getODSOperands(3).begin();
}

::mlir::MutableOperandRange BitFieldInsertOp::baseMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange BitFieldInsertOp::insertMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange BitFieldInsertOp::offsetMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange BitFieldInsertOp::countMutable() {
  auto range = getODSOperandIndexAndLength(3);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> BitFieldInsertOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range BitFieldInsertOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value BitFieldInsertOp::result() {
  return *getODSResults(0).begin();
}

void BitFieldInsertOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value base, Value insert, Value offset, Value count) {
  odsState.addOperands(base);
  odsState.addOperands(insert);
  odsState.addOperands(offset);
  odsState.addOperands(count);
  odsState.addTypes(result);
}

void BitFieldInsertOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value base, Value insert, Value offset, Value count) {
  odsState.addOperands(base);
  odsState.addOperands(insert);
  odsState.addOperands(offset);
  odsState.addOperands(count);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void BitFieldInsertOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 4u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LogicalResult BitFieldInsertOp::verify() {
  if (failed(BitFieldInsertOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup2 = getODSOperands(2);
    for (Value v : valueGroup2) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup3 = getODSOperands(3);
    for (Value v : valueGroup3) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  if (!((llvm::is_splat(llvm::makeArrayRef({(*this->getODSOperands(0).begin()).getType(), (*this->getODSOperands(1).begin()).getType(), (*this->getODSResults(0).begin()).getType()})))))
    return emitOpError("failed to verify that all of {base, insert, result} have same type");
  return success();
}









ParseResult BitFieldInsertOp::parse(OpAsmParser &parser, OperationState &result) {
  Type baseRawTypes[1];
  ArrayRef<Type> baseTypes(baseRawTypes);
  Type offsetRawTypes[1];
  ArrayRef<Type> offsetTypes(offsetRawTypes);
  Type countRawTypes[1];
  ArrayRef<Type> countTypes(countRawTypes);
  llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  SmallVector<OpAsmParser::OperandType, 4> allOperands;
  if (parser.parseOperandList(allOperands))
    return failure();
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  if (parser.parseColon())
    return failure();

  if (parser.parseType(baseRawTypes[0]))
    return failure();
  if (parser.parseComma())
    return failure();

  if (parser.parseType(offsetRawTypes[0]))
    return failure();
  if (parser.parseComma())
    return failure();

  if (parser.parseType(countRawTypes[0]))
    return failure();
  result.addTypes(baseTypes);
  if (parser.resolveOperands(allOperands, llvm::concat<const Type>(ArrayRef<Type>(baseTypes), ArrayRef<Type>(baseTypes), ArrayRef<Type>(offsetTypes), ArrayRef<Type>(countTypes)), allOperandLoc, result.operands))
    return failure();
  return success();
}

void BitFieldInsertOp::print(OpAsmPrinter &p) {
  p << "spv.BitFieldInsert";
  p << " ";
  p << getOperation()->getOperands();
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{});
  p << " " << ":";
  p << " ";
  p << ArrayRef<Type>(base().getType());
  p << ",";
  p << " ";
  p << ArrayRef<Type>(offset().getType());
  p << ",";
  p << " ";
  p << ArrayRef<Type>(count().getType());
}

void BitFieldInsertOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::BitFieldSExtractOp definitions
//===----------------------------------------------------------------------===//

BitFieldSExtractOpAdaptor::BitFieldSExtractOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

BitFieldSExtractOpAdaptor::BitFieldSExtractOpAdaptor(BitFieldSExtractOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> BitFieldSExtractOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange BitFieldSExtractOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value BitFieldSExtractOpAdaptor::base() {
  return *getODSOperands(0).begin();
}

Value BitFieldSExtractOpAdaptor::offset() {
  return *getODSOperands(1).begin();
}

Value BitFieldSExtractOpAdaptor::count() {
  return *getODSOperands(2).begin();
}

LogicalResult BitFieldSExtractOpAdaptor::verify(Location loc) {
  return success();
}

StringRef BitFieldSExtractOp::getOperationName() {
  return "spv.BitFieldSExtract";
}

std::pair<unsigned, unsigned> BitFieldSExtractOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range BitFieldSExtractOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value BitFieldSExtractOp::base() {
  return *getODSOperands(0).begin();
}

Value BitFieldSExtractOp::offset() {
  return *getODSOperands(1).begin();
}

Value BitFieldSExtractOp::count() {
  return *getODSOperands(2).begin();
}

::mlir::MutableOperandRange BitFieldSExtractOp::baseMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange BitFieldSExtractOp::offsetMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange BitFieldSExtractOp::countMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> BitFieldSExtractOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range BitFieldSExtractOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value BitFieldSExtractOp::result() {
  return *getODSResults(0).begin();
}

void BitFieldSExtractOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value base, Value offset, Value count) {
  odsState.addOperands(base);
  odsState.addOperands(offset);
  odsState.addOperands(count);
  odsState.addTypes(result);
}

void BitFieldSExtractOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value base, Value offset, Value count) {
  odsState.addOperands(base);
  odsState.addOperands(offset);
  odsState.addOperands(count);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void BitFieldSExtractOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LogicalResult BitFieldSExtractOp::verify() {
  if (failed(BitFieldSExtractOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup2 = getODSOperands(2);
    for (Value v : valueGroup2) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  if (!((llvm::is_splat(llvm::makeArrayRef({(*this->getODSOperands(0).begin()).getType(), (*this->getODSResults(0).begin()).getType()})))))
    return emitOpError("failed to verify that all of {base, result} have same type");
  return success();
}









ParseResult BitFieldSExtractOp::parse(OpAsmParser &parser, OperationState &result) {
  Type baseRawTypes[1];
  ArrayRef<Type> baseTypes(baseRawTypes);
  Type offsetRawTypes[1];
  ArrayRef<Type> offsetTypes(offsetRawTypes);
  Type countRawTypes[1];
  ArrayRef<Type> countTypes(countRawTypes);
  llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  SmallVector<OpAsmParser::OperandType, 4> allOperands;
  if (parser.parseOperandList(allOperands))
    return failure();
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  if (parser.parseColon())
    return failure();

  if (parser.parseType(baseRawTypes[0]))
    return failure();
  if (parser.parseComma())
    return failure();

  if (parser.parseType(offsetRawTypes[0]))
    return failure();
  if (parser.parseComma())
    return failure();

  if (parser.parseType(countRawTypes[0]))
    return failure();
  result.addTypes(baseTypes);
  if (parser.resolveOperands(allOperands, llvm::concat<const Type>(ArrayRef<Type>(baseTypes), ArrayRef<Type>(offsetTypes), ArrayRef<Type>(countTypes)), allOperandLoc, result.operands))
    return failure();
  return success();
}

void BitFieldSExtractOp::print(OpAsmPrinter &p) {
  p << "spv.BitFieldSExtract";
  p << " ";
  p << getOperation()->getOperands();
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{});
  p << " " << ":";
  p << " ";
  p << ArrayRef<Type>(base().getType());
  p << ",";
  p << " ";
  p << ArrayRef<Type>(offset().getType());
  p << ",";
  p << " ";
  p << ArrayRef<Type>(count().getType());
}

void BitFieldSExtractOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::BitFieldUExtractOp definitions
//===----------------------------------------------------------------------===//

BitFieldUExtractOpAdaptor::BitFieldUExtractOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

BitFieldUExtractOpAdaptor::BitFieldUExtractOpAdaptor(BitFieldUExtractOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> BitFieldUExtractOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange BitFieldUExtractOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value BitFieldUExtractOpAdaptor::base() {
  return *getODSOperands(0).begin();
}

Value BitFieldUExtractOpAdaptor::offset() {
  return *getODSOperands(1).begin();
}

Value BitFieldUExtractOpAdaptor::count() {
  return *getODSOperands(2).begin();
}

LogicalResult BitFieldUExtractOpAdaptor::verify(Location loc) {
  return success();
}

StringRef BitFieldUExtractOp::getOperationName() {
  return "spv.BitFieldUExtract";
}

std::pair<unsigned, unsigned> BitFieldUExtractOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range BitFieldUExtractOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value BitFieldUExtractOp::base() {
  return *getODSOperands(0).begin();
}

Value BitFieldUExtractOp::offset() {
  return *getODSOperands(1).begin();
}

Value BitFieldUExtractOp::count() {
  return *getODSOperands(2).begin();
}

::mlir::MutableOperandRange BitFieldUExtractOp::baseMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange BitFieldUExtractOp::offsetMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange BitFieldUExtractOp::countMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> BitFieldUExtractOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range BitFieldUExtractOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value BitFieldUExtractOp::result() {
  return *getODSResults(0).begin();
}

void BitFieldUExtractOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value base, Value offset, Value count) {
  odsState.addOperands(base);
  odsState.addOperands(offset);
  odsState.addOperands(count);
  odsState.addTypes(result);
}

void BitFieldUExtractOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value base, Value offset, Value count) {
  odsState.addOperands(base);
  odsState.addOperands(offset);
  odsState.addOperands(count);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void BitFieldUExtractOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LogicalResult BitFieldUExtractOp::verify() {
  if (failed(BitFieldUExtractOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup2 = getODSOperands(2);
    for (Value v : valueGroup2) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  if (!((llvm::is_splat(llvm::makeArrayRef({(*this->getODSOperands(0).begin()).getType(), (*this->getODSResults(0).begin()).getType()})))))
    return emitOpError("failed to verify that all of {base, result} have same type");
  return success();
}









ParseResult BitFieldUExtractOp::parse(OpAsmParser &parser, OperationState &result) {
  Type baseRawTypes[1];
  ArrayRef<Type> baseTypes(baseRawTypes);
  Type offsetRawTypes[1];
  ArrayRef<Type> offsetTypes(offsetRawTypes);
  Type countRawTypes[1];
  ArrayRef<Type> countTypes(countRawTypes);
  llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  SmallVector<OpAsmParser::OperandType, 4> allOperands;
  if (parser.parseOperandList(allOperands))
    return failure();
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  if (parser.parseColon())
    return failure();

  if (parser.parseType(baseRawTypes[0]))
    return failure();
  if (parser.parseComma())
    return failure();

  if (parser.parseType(offsetRawTypes[0]))
    return failure();
  if (parser.parseComma())
    return failure();

  if (parser.parseType(countRawTypes[0]))
    return failure();
  result.addTypes(baseTypes);
  if (parser.resolveOperands(allOperands, llvm::concat<const Type>(ArrayRef<Type>(baseTypes), ArrayRef<Type>(offsetTypes), ArrayRef<Type>(countTypes)), allOperandLoc, result.operands))
    return failure();
  return success();
}

void BitFieldUExtractOp::print(OpAsmPrinter &p) {
  p << "spv.BitFieldUExtract";
  p << " ";
  p << getOperation()->getOperands();
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{});
  p << " " << ":";
  p << " ";
  p << ArrayRef<Type>(base().getType());
  p << ",";
  p << " ";
  p << ArrayRef<Type>(offset().getType());
  p << ",";
  p << " ";
  p << ArrayRef<Type>(count().getType());
}

void BitFieldUExtractOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::BitReverseOp definitions
//===----------------------------------------------------------------------===//

BitReverseOpAdaptor::BitReverseOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

BitReverseOpAdaptor::BitReverseOpAdaptor(BitReverseOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> BitReverseOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange BitReverseOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value BitReverseOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult BitReverseOpAdaptor::verify(Location loc) {
  return success();
}

StringRef BitReverseOp::getOperationName() {
  return "spv.BitReverse";
}

std::pair<unsigned, unsigned> BitReverseOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range BitReverseOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value BitReverseOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange BitReverseOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> BitReverseOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range BitReverseOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value BitReverseOp::result() {
  return *getODSResults(0).begin();
}

void BitReverseOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void BitReverseOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void BitReverseOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void BitReverseOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes({operand.getType()});

}

void BitReverseOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult BitReverseOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseUnaryOp(parser, result);
}

void BitReverseOp::print(OpAsmPrinter &p) {
  return ::printUnaryOp(getOperation(), p);
}

LogicalResult BitReverseOp::verify() {
  if (failed(BitReverseOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void BitReverseOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::BitcastOp definitions
//===----------------------------------------------------------------------===//

BitcastOpAdaptor::BitcastOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

BitcastOpAdaptor::BitcastOpAdaptor(BitcastOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> BitcastOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange BitcastOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value BitcastOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult BitcastOpAdaptor::verify(Location loc) {
  return success();
}

StringRef BitcastOp::getOperationName() {
  return "spv.Bitcast";
}

std::pair<unsigned, unsigned> BitcastOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range BitcastOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value BitcastOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange BitcastOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> BitcastOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range BitcastOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value BitcastOp::result() {
  return *getODSResults(0).begin();
}

void BitcastOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void BitcastOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void BitcastOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult BitcastOp::parse(OpAsmParser &parser, OperationState &result) {
  return mlir::impl::parseCastOp(parser, result);
}

void BitcastOp::print(OpAsmPrinter &p) {
  mlir::impl::printCastOp(this->getOperation(), p);
}

LogicalResult BitcastOp::verify() {
  if (failed(BitcastOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || (((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64())))) || ((v.getType().isSignlessInteger(1)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4)))))) || ((v.getType().isa<::mlir::spirv::PointerType>())))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or 16/32/64-bit float or bool or vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || (((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64())))) || ((v.getType().isSignlessInteger(1)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4)))))) || ((v.getType().isa<::mlir::spirv::PointerType>())))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or 16/32/64-bit float or bool or vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verify(*this);
}











void BitcastOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::BitwiseAndOp definitions
//===----------------------------------------------------------------------===//

BitwiseAndOpAdaptor::BitwiseAndOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

BitwiseAndOpAdaptor::BitwiseAndOpAdaptor(BitwiseAndOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> BitwiseAndOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange BitwiseAndOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value BitwiseAndOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value BitwiseAndOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult BitwiseAndOpAdaptor::verify(Location loc) {
  return success();
}

StringRef BitwiseAndOp::getOperationName() {
  return "spv.BitwiseAnd";
}

std::pair<unsigned, unsigned> BitwiseAndOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range BitwiseAndOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value BitwiseAndOp::operand1() {
  return *getODSOperands(0).begin();
}

Value BitwiseAndOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange BitwiseAndOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange BitwiseAndOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> BitwiseAndOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range BitwiseAndOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value BitwiseAndOp::result() {
  return *getODSResults(0).begin();
}

void BitwiseAndOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void BitwiseAndOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void BitwiseAndOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void BitwiseAndOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes({operand1.getType()});

}

void BitwiseAndOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult BitwiseAndOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void BitwiseAndOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult BitwiseAndOp::verify() {
  if (failed(BitwiseAndOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void BitwiseAndOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::BitwiseOrOp definitions
//===----------------------------------------------------------------------===//

BitwiseOrOpAdaptor::BitwiseOrOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

BitwiseOrOpAdaptor::BitwiseOrOpAdaptor(BitwiseOrOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> BitwiseOrOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange BitwiseOrOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value BitwiseOrOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value BitwiseOrOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult BitwiseOrOpAdaptor::verify(Location loc) {
  return success();
}

StringRef BitwiseOrOp::getOperationName() {
  return "spv.BitwiseOr";
}

std::pair<unsigned, unsigned> BitwiseOrOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range BitwiseOrOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value BitwiseOrOp::operand1() {
  return *getODSOperands(0).begin();
}

Value BitwiseOrOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange BitwiseOrOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange BitwiseOrOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> BitwiseOrOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range BitwiseOrOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value BitwiseOrOp::result() {
  return *getODSResults(0).begin();
}

void BitwiseOrOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void BitwiseOrOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void BitwiseOrOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void BitwiseOrOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes({operand1.getType()});

}

void BitwiseOrOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult BitwiseOrOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void BitwiseOrOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult BitwiseOrOp::verify() {
  if (failed(BitwiseOrOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void BitwiseOrOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::BitwiseXorOp definitions
//===----------------------------------------------------------------------===//

BitwiseXorOpAdaptor::BitwiseXorOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

BitwiseXorOpAdaptor::BitwiseXorOpAdaptor(BitwiseXorOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> BitwiseXorOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange BitwiseXorOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value BitwiseXorOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value BitwiseXorOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult BitwiseXorOpAdaptor::verify(Location loc) {
  return success();
}

StringRef BitwiseXorOp::getOperationName() {
  return "spv.BitwiseXor";
}

std::pair<unsigned, unsigned> BitwiseXorOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range BitwiseXorOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value BitwiseXorOp::operand1() {
  return *getODSOperands(0).begin();
}

Value BitwiseXorOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange BitwiseXorOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange BitwiseXorOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> BitwiseXorOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range BitwiseXorOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value BitwiseXorOp::result() {
  return *getODSResults(0).begin();
}

void BitwiseXorOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void BitwiseXorOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void BitwiseXorOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void BitwiseXorOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes({operand1.getType()});

}

void BitwiseXorOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult BitwiseXorOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void BitwiseXorOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult BitwiseXorOp::verify() {
  if (failed(BitwiseXorOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void BitwiseXorOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::BranchConditionalOp definitions
//===----------------------------------------------------------------------===//

BranchConditionalOpAdaptor::BranchConditionalOpAdaptor(ValueRange values, DictionaryAttr attrs)  : odsOperands(values), odsAttrs(attrs) {

}

BranchConditionalOpAdaptor::BranchConditionalOpAdaptor(BranchConditionalOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> BranchConditionalOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  assert(odsAttrs && "missing segment size attribute for op");
  auto sizeAttr = odsAttrs.get("operand_segment_sizes").cast<DenseIntElementsAttr>();

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += (*(sizeAttr.begin() + i)).getZExtValue();
  unsigned size = (*(sizeAttr.begin() + index)).getZExtValue();
  return {start, size};
}

ValueRange BranchConditionalOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value BranchConditionalOpAdaptor::condition() {
  return *getODSOperands(0).begin();
}

ValueRange BranchConditionalOpAdaptor::trueTargetOperands() {
  return getODSOperands(1);
}

ValueRange BranchConditionalOpAdaptor::falseTargetOperands() {
  return getODSOperands(2);
}

ArrayAttr BranchConditionalOpAdaptor::branch_weights() {
  assert(odsAttrs && "no attributes when constructing adapter");
  ArrayAttr attr = odsAttrs.get("branch_weights").dyn_cast_or_null<ArrayAttr>();
  return attr;
}

LogicalResult BranchConditionalOpAdaptor::verify(Location loc) {
  {
    auto sizeAttr = odsAttrs.get("operand_segment_sizes").cast<DenseIntElementsAttr>();
    auto numElements = sizeAttr.getType().cast<ShapedType>().getNumElements();
    if (numElements != 3)
      return emitError(loc, "'operand_segment_sizes' attribute for specifying operand segments "
                       "must have 3 elements");
  }
    {
  auto tblgen_branch_weights = odsAttrs.get("branch_weights");
  if (tblgen_branch_weights) {
    if (!(((tblgen_branch_weights.isa<ArrayAttr>())) && (llvm::all_of(tblgen_branch_weights.cast<ArrayAttr>(), [](Attribute attr) { return ((attr.isa<IntegerAttr>())) && ((attr.cast<IntegerAttr>().getType().isSignlessInteger(32))); })))) return emitError(loc, "'spv.BranchConditional' op ""attribute 'branch_weights' failed to satisfy constraint: 32-bit integer array attribute");
  }
  }
  return success();
}

StringRef BranchConditionalOp::getOperationName() {
  return "spv.BranchConditional";
}

std::pair<unsigned, unsigned> BranchConditionalOp::getODSOperandIndexAndLength(unsigned index) {
  auto sizeAttr = getAttrOfType<DenseIntElementsAttr>("operand_segment_sizes");

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += (*(sizeAttr.begin() + i)).getZExtValue();
  unsigned size = (*(sizeAttr.begin() + index)).getZExtValue();
  return {start, size};
}

Operation::operand_range BranchConditionalOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value BranchConditionalOp::condition() {
  return *getODSOperands(0).begin();
}

Operation::operand_range BranchConditionalOp::trueTargetOperands() {
  return getODSOperands(1);
}

Operation::operand_range BranchConditionalOp::falseTargetOperands() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange BranchConditionalOp::conditionMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, *getOperation()->getMutableAttrDict().getNamed("operand_segment_sizes")));
}

::mlir::MutableOperandRange BranchConditionalOp::trueTargetOperandsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, *getOperation()->getMutableAttrDict().getNamed("operand_segment_sizes")));
}

::mlir::MutableOperandRange BranchConditionalOp::falseTargetOperandsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, *getOperation()->getMutableAttrDict().getNamed("operand_segment_sizes")));
}

std::pair<unsigned, unsigned> BranchConditionalOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range BranchConditionalOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Block *BranchConditionalOp::trueTarget() {
  return this->getOperation()->getSuccessor(0);
}

Block *BranchConditionalOp::falseTarget() {
  return this->getOperation()->getSuccessor(1);
}

ArrayAttr BranchConditionalOp::branch_weightsAttr() {
  return this->getAttr("branch_weights").dyn_cast_or_null<ArrayAttr>();
}

Optional< ArrayAttr > BranchConditionalOp::branch_weights() {
  auto attr = branch_weightsAttr();
  return attr ? Optional< ArrayAttr >(attr) : (llvm::None);
}

void BranchConditionalOp::branch_weightsAttr(ArrayAttr attr) {
  this->getOperation()->setAttr("branch_weights", attr);
}

void BranchConditionalOp::build(OpBuilder &builder, OperationState &state, Value condition, Block *trueBlock, ValueRange trueArguments, Block *falseBlock, ValueRange falseArguments, Optional<std::pair<uint32_t, uint32_t>> weights ) {
        ArrayAttr weightsAttr;
        if (weights) {
          weightsAttr =
              builder.getI32ArrayAttr({static_cast<int32_t>(weights->first),
                                       static_cast<int32_t>(weights->second)});
        }
        build(builder, state, condition, trueArguments, falseArguments,
              weightsAttr, trueBlock, falseBlock);
      
}

void BranchConditionalOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value condition, ValueRange trueTargetOperands, ValueRange falseTargetOperands, /*optional*/ArrayAttr branch_weights, Block *trueTarget, Block *falseTarget) {
  odsState.addOperands(condition);
  odsState.addOperands(trueTargetOperands);
  odsState.addOperands(falseTargetOperands);
  odsState.addAttribute("operand_segment_sizes", odsBuilder.getI32VectorAttr({1, static_cast<int32_t>(trueTargetOperands.size()), static_cast<int32_t>(falseTargetOperands.size())}));
  if (branch_weights) {
  odsState.addAttribute("branch_weights", branch_weights);
  }
  odsState.addSuccessors(trueTarget);
  odsState.addSuccessors(falseTarget);
}

void BranchConditionalOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value condition, ValueRange trueTargetOperands, ValueRange falseTargetOperands, /*optional*/ArrayAttr branch_weights, Block *trueTarget, Block *falseTarget) {
  odsState.addOperands(condition);
  odsState.addOperands(trueTargetOperands);
  odsState.addOperands(falseTargetOperands);
  odsState.addAttribute("operand_segment_sizes", odsBuilder.getI32VectorAttr({1, static_cast<int32_t>(trueTargetOperands.size()), static_cast<int32_t>(falseTargetOperands.size())}));
  if (branch_weights) {
  odsState.addAttribute("branch_weights", branch_weights);
  }
  odsState.addSuccessors(trueTarget);
  odsState.addSuccessors(falseTarget);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void BranchConditionalOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult BranchConditionalOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseBranchConditionalOp(parser, result);
}

void BranchConditionalOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult BranchConditionalOp::verify() {
  if (failed(BranchConditionalOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isSignlessInteger(1)))) {
        return emitOpError("operand #") << index << " must be bool, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isa<NoneType>())) || ((v.getType().isSignlessInteger(1))) || (((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || (((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::PointerType>())) || ((v.getType().isa<::mlir::spirv::ArrayType>())) || ((v.getType().isa<::mlir::spirv::RuntimeArrayType>())) || ((v.getType().isa<::mlir::spirv::StructType>())) || ((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) || ((v.getType().isa<::mlir::spirv::MatrixType>())))) {
        return emitOpError("operand #") << index << " must be void or bool or 8/16/32/64-bit integer or 16/32/64-bit float or vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V pointer type or any SPIR-V array type or any SPIR-V runtime array type or any SPIR-V struct type or any SPIR-V cooperative matrix type or any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup2 = getODSOperands(2);
    for (Value v : valueGroup2) {
      (void)v;
      if (!(((v.getType().isa<NoneType>())) || ((v.getType().isSignlessInteger(1))) || (((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || (((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::PointerType>())) || ((v.getType().isa<::mlir::spirv::ArrayType>())) || ((v.getType().isa<::mlir::spirv::RuntimeArrayType>())) || ((v.getType().isa<::mlir::spirv::StructType>())) || ((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) || ((v.getType().isa<::mlir::spirv::MatrixType>())))) {
        return emitOpError("operand #") << index << " must be void or bool or 8/16/32/64-bit integer or 16/32/64-bit float or vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V pointer type or any SPIR-V array type or any SPIR-V runtime array type or any SPIR-V struct type or any SPIR-V cooperative matrix type or any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
  }
  if (!((isNestedInFunctionLikeOp((*this->getOperation()).getParentOp()))))
    return emitOpError("failed to verify that op must appear in a function-like op's block");
{
    unsigned index = 0; (void)index;
  }
  return ::verify(*this);
}











void BranchConditionalOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::BranchOp definitions
//===----------------------------------------------------------------------===//

BranchOpAdaptor::BranchOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

BranchOpAdaptor::BranchOpAdaptor(BranchOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> BranchOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

ValueRange BranchOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

ValueRange BranchOpAdaptor::targetOperands() {
  return getODSOperands(0);
}

LogicalResult BranchOpAdaptor::verify(Location loc) {
  return success();
}

StringRef BranchOp::getOperationName() {
  return "spv.Branch";
}

std::pair<unsigned, unsigned> BranchOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

Operation::operand_range BranchOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Operation::operand_range BranchOp::targetOperands() {
  return getODSOperands(0);
}

::mlir::MutableOperandRange BranchOp::targetOperandsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> BranchOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range BranchOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Block *BranchOp::target() {
  return this->getOperation()->getSuccessor(0);
}

void BranchOp::build(OpBuilder &, OperationState &state, Block *successor, ValueRange arguments ) {
        state.addSuccessors(successor);
        state.addOperands(arguments);
      
}

LogicalResult BranchOp::verify() {
  if (failed(BranchOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isa<NoneType>())) || ((v.getType().isSignlessInteger(1))) || (((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || (((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::PointerType>())) || ((v.getType().isa<::mlir::spirv::ArrayType>())) || ((v.getType().isa<::mlir::spirv::RuntimeArrayType>())) || ((v.getType().isa<::mlir::spirv::StructType>())) || ((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) || ((v.getType().isa<::mlir::spirv::MatrixType>())))) {
        return emitOpError("operand #") << index << " must be void or bool or 8/16/32/64-bit integer or 16/32/64-bit float or vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V pointer type or any SPIR-V array type or any SPIR-V runtime array type or any SPIR-V struct type or any SPIR-V cooperative matrix type or any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
  }
  if (!((isNestedInFunctionLikeOp((*this->getOperation()).getParentOp()))))
    return emitOpError("failed to verify that op must appear in a function-like op's block");
{
    unsigned index = 0; (void)index;
  }
  return success();
}











ParseResult BranchOp::parse(OpAsmParser &parser, OperationState &result) {
  SmallVector<OpAsmParser::OperandType, 4> targetOperandsOperands;
  llvm::SMLoc targetOperandsOperandsLoc = parser.getCurrentLocation();
  (void)targetOperandsOperandsLoc;
  SmallVector<Type, 1> targetOperandsTypes;

  Block *targetSuccessor = nullptr;
  if (parser.parseSuccessor(targetSuccessor))
    return failure();
  if (succeeded(parser.parseOptionalLParen())) {

  if (parser.parseOperandList(targetOperandsOperands))
    return failure();
  if (parser.parseColon())
    return failure();

  if (parser.parseTypeList(targetOperandsTypes))
    return failure();
  if (parser.parseRParen())
    return failure();
  }
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  if (parser.resolveOperands(targetOperandsOperands, targetOperandsTypes, targetOperandsOperandsLoc, result.operands))
    return failure();
  result.addSuccessors(targetSuccessor);
  return success();
}

void BranchOp::print(OpAsmPrinter &p) {
  p << "spv.Branch";
  p << " ";
  p << target();
  if (!targetOperands().empty()) {
  p << "(";
  p << targetOperands();
  p << " " << ":";
  p << " ";
  p << targetOperands().getTypes();
  p << ")";
  }
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{});
}

void BranchOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::CompositeConstructOp definitions
//===----------------------------------------------------------------------===//

CompositeConstructOpAdaptor::CompositeConstructOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

CompositeConstructOpAdaptor::CompositeConstructOpAdaptor(CompositeConstructOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> CompositeConstructOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

ValueRange CompositeConstructOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

ValueRange CompositeConstructOpAdaptor::constituents() {
  return getODSOperands(0);
}

LogicalResult CompositeConstructOpAdaptor::verify(Location loc) {
  return success();
}

StringRef CompositeConstructOp::getOperationName() {
  return "spv.CompositeConstruct";
}

std::pair<unsigned, unsigned> CompositeConstructOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

Operation::operand_range CompositeConstructOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Operation::operand_range CompositeConstructOp::constituents() {
  return getODSOperands(0);
}

::mlir::MutableOperandRange CompositeConstructOp::constituentsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> CompositeConstructOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range CompositeConstructOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value CompositeConstructOp::result() {
  return *getODSResults(0).begin();
}

void CompositeConstructOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, ValueRange constituents) {
  odsState.addOperands(constituents);
  odsState.addTypes(result);
}

void CompositeConstructOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange constituents) {
  odsState.addOperands(constituents);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CompositeConstructOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult CompositeConstructOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseCompositeConstructOp(parser, result);
}

void CompositeConstructOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult CompositeConstructOp::verify() {
  if (failed(CompositeConstructOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isa<NoneType>())) || ((v.getType().isSignlessInteger(1))) || (((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || (((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::PointerType>())) || ((v.getType().isa<::mlir::spirv::ArrayType>())) || ((v.getType().isa<::mlir::spirv::RuntimeArrayType>())) || ((v.getType().isa<::mlir::spirv::StructType>())) || ((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) || ((v.getType().isa<::mlir::spirv::MatrixType>())))) {
        return emitOpError("operand #") << index << " must be void or bool or 8/16/32/64-bit integer or 16/32/64-bit float or vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V pointer type or any SPIR-V array type or any SPIR-V runtime array type or any SPIR-V struct type or any SPIR-V cooperative matrix type or any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::ArrayType>())) || ((v.getType().isa<::mlir::spirv::RuntimeArrayType>())) || ((v.getType().isa<::mlir::spirv::StructType>())) || ((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) || ((v.getType().isa<::mlir::spirv::MatrixType>())))) {
        return emitOpError("result #") << index << " must be vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V array type or any SPIR-V runtime array type or any SPIR-V struct type or any SPIR-V cooperative matrix type or any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verify(*this);
}









void CompositeConstructOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::CompositeExtractOp definitions
//===----------------------------------------------------------------------===//

CompositeExtractOpAdaptor::CompositeExtractOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

CompositeExtractOpAdaptor::CompositeExtractOpAdaptor(CompositeExtractOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> CompositeExtractOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange CompositeExtractOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value CompositeExtractOpAdaptor::composite() {
  return *getODSOperands(0).begin();
}

ArrayAttr CompositeExtractOpAdaptor::indices() {
  assert(odsAttrs && "no attributes when constructing adapter");
  ArrayAttr attr = odsAttrs.get("indices").cast<ArrayAttr>();
  return attr;
}

LogicalResult CompositeExtractOpAdaptor::verify(Location loc) {
  {
  auto tblgen_indices = odsAttrs.get("indices");
  if (!tblgen_indices) return emitError(loc, "'spv.CompositeExtract' op ""requires attribute 'indices'");
    if (!(((tblgen_indices.isa<ArrayAttr>())) && (llvm::all_of(tblgen_indices.cast<ArrayAttr>(), [](Attribute attr) { return ((attr.isa<IntegerAttr>())) && ((attr.cast<IntegerAttr>().getType().isSignlessInteger(32))); })))) return emitError(loc, "'spv.CompositeExtract' op ""attribute 'indices' failed to satisfy constraint: 32-bit integer array attribute");
  }
  return success();
}

StringRef CompositeExtractOp::getOperationName() {
  return "spv.CompositeExtract";
}

std::pair<unsigned, unsigned> CompositeExtractOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range CompositeExtractOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value CompositeExtractOp::composite() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange CompositeExtractOp::compositeMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> CompositeExtractOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range CompositeExtractOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value CompositeExtractOp::component() {
  return *getODSResults(0).begin();
}

ArrayAttr CompositeExtractOp::indicesAttr() {
  return this->getAttr("indices").cast<ArrayAttr>();
}

ArrayAttr CompositeExtractOp::indices() {
  auto attr = indicesAttr();
  return attr;
}

void CompositeExtractOp::indicesAttr(ArrayAttr attr) {
  this->getOperation()->setAttr("indices", attr);
}



void CompositeExtractOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type component, Value composite, ArrayAttr indices) {
  odsState.addOperands(composite);
  odsState.addAttribute("indices", indices);
  odsState.addTypes(component);
}

void CompositeExtractOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value composite, ArrayAttr indices) {
  odsState.addOperands(composite);
  odsState.addAttribute("indices", indices);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CompositeExtractOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult CompositeExtractOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseCompositeExtractOp(parser, result);
}

void CompositeExtractOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult CompositeExtractOp::verify() {
  if (failed(CompositeExtractOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::ArrayType>())) || ((v.getType().isa<::mlir::spirv::RuntimeArrayType>())) || ((v.getType().isa<::mlir::spirv::StructType>())) || ((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) || ((v.getType().isa<::mlir::spirv::MatrixType>())))) {
        return emitOpError("operand #") << index << " must be vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V array type or any SPIR-V runtime array type or any SPIR-V struct type or any SPIR-V cooperative matrix type or any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isa<NoneType>())) || ((v.getType().isSignlessInteger(1))) || (((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || (((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::PointerType>())) || ((v.getType().isa<::mlir::spirv::ArrayType>())) || ((v.getType().isa<::mlir::spirv::RuntimeArrayType>())) || ((v.getType().isa<::mlir::spirv::StructType>())) || ((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) || ((v.getType().isa<::mlir::spirv::MatrixType>())))) {
        return emitOpError("result #") << index << " must be void or bool or 8/16/32/64-bit integer or 16/32/64-bit float or vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V pointer type or any SPIR-V array type or any SPIR-V runtime array type or any SPIR-V struct type or any SPIR-V cooperative matrix type or any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verify(*this);
}











void CompositeExtractOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::CompositeInsertOp definitions
//===----------------------------------------------------------------------===//

CompositeInsertOpAdaptor::CompositeInsertOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

CompositeInsertOpAdaptor::CompositeInsertOpAdaptor(CompositeInsertOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> CompositeInsertOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange CompositeInsertOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value CompositeInsertOpAdaptor::object() {
  return *getODSOperands(0).begin();
}

Value CompositeInsertOpAdaptor::composite() {
  return *getODSOperands(1).begin();
}

ArrayAttr CompositeInsertOpAdaptor::indices() {
  assert(odsAttrs && "no attributes when constructing adapter");
  ArrayAttr attr = odsAttrs.get("indices").cast<ArrayAttr>();
  return attr;
}

LogicalResult CompositeInsertOpAdaptor::verify(Location loc) {
  {
  auto tblgen_indices = odsAttrs.get("indices");
  if (!tblgen_indices) return emitError(loc, "'spv.CompositeInsert' op ""requires attribute 'indices'");
    if (!(((tblgen_indices.isa<ArrayAttr>())) && (llvm::all_of(tblgen_indices.cast<ArrayAttr>(), [](Attribute attr) { return ((attr.isa<IntegerAttr>())) && ((attr.cast<IntegerAttr>().getType().isSignlessInteger(32))); })))) return emitError(loc, "'spv.CompositeInsert' op ""attribute 'indices' failed to satisfy constraint: 32-bit integer array attribute");
  }
  return success();
}

StringRef CompositeInsertOp::getOperationName() {
  return "spv.CompositeInsert";
}

std::pair<unsigned, unsigned> CompositeInsertOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range CompositeInsertOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value CompositeInsertOp::object() {
  return *getODSOperands(0).begin();
}

Value CompositeInsertOp::composite() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange CompositeInsertOp::objectMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange CompositeInsertOp::compositeMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> CompositeInsertOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range CompositeInsertOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value CompositeInsertOp::result() {
  return *getODSResults(0).begin();
}

ArrayAttr CompositeInsertOp::indicesAttr() {
  return this->getAttr("indices").cast<ArrayAttr>();
}

ArrayAttr CompositeInsertOp::indices() {
  auto attr = indicesAttr();
  return attr;
}

void CompositeInsertOp::indicesAttr(ArrayAttr attr) {
  this->getOperation()->setAttr("indices", attr);
}

void CompositeInsertOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value object, Value composite, ArrayAttr indices) {
  odsState.addOperands(object);
  odsState.addOperands(composite);
  odsState.addAttribute("indices", indices);
  odsState.addTypes(result);
}

void CompositeInsertOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value object, Value composite, ArrayAttr indices) {
  odsState.addOperands(object);
  odsState.addOperands(composite);
  odsState.addAttribute("indices", indices);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CompositeInsertOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult CompositeInsertOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseCompositeInsertOp(parser, result);
}

void CompositeInsertOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult CompositeInsertOp::verify() {
  if (failed(CompositeInsertOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isa<NoneType>())) || ((v.getType().isSignlessInteger(1))) || (((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || (((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::PointerType>())) || ((v.getType().isa<::mlir::spirv::ArrayType>())) || ((v.getType().isa<::mlir::spirv::RuntimeArrayType>())) || ((v.getType().isa<::mlir::spirv::StructType>())) || ((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) || ((v.getType().isa<::mlir::spirv::MatrixType>())))) {
        return emitOpError("operand #") << index << " must be void or bool or 8/16/32/64-bit integer or 16/32/64-bit float or vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V pointer type or any SPIR-V array type or any SPIR-V runtime array type or any SPIR-V struct type or any SPIR-V cooperative matrix type or any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::ArrayType>())) || ((v.getType().isa<::mlir::spirv::RuntimeArrayType>())) || ((v.getType().isa<::mlir::spirv::StructType>())) || ((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) || ((v.getType().isa<::mlir::spirv::MatrixType>())))) {
        return emitOpError("operand #") << index << " must be vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V array type or any SPIR-V runtime array type or any SPIR-V struct type or any SPIR-V cooperative matrix type or any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::ArrayType>())) || ((v.getType().isa<::mlir::spirv::RuntimeArrayType>())) || ((v.getType().isa<::mlir::spirv::StructType>())) || ((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) || ((v.getType().isa<::mlir::spirv::MatrixType>())))) {
        return emitOpError("result #") << index << " must be vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V array type or any SPIR-V runtime array type or any SPIR-V struct type or any SPIR-V cooperative matrix type or any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verify(*this);
}









void CompositeInsertOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::ConstantOp definitions
//===----------------------------------------------------------------------===//

ConstantOpAdaptor::ConstantOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

ConstantOpAdaptor::ConstantOpAdaptor(ConstantOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> ConstantOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange ConstantOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Attribute ConstantOpAdaptor::value() {
  assert(odsAttrs && "no attributes when constructing adapter");
  Attribute attr = odsAttrs.get("value").cast<Attribute>();
  return attr;
}

LogicalResult ConstantOpAdaptor::verify(Location loc) {
  {
  auto tblgen_value = odsAttrs.get("value");
  if (!tblgen_value) return emitError(loc, "'spv.constant' op ""requires attribute 'value'");
    if (!((true))) return emitError(loc, "'spv.constant' op ""attribute 'value' failed to satisfy constraint: any attribute");
  }
  return success();
}

StringRef ConstantOp::getOperationName() {
  return "spv.constant";
}

std::pair<unsigned, unsigned> ConstantOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range ConstantOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> ConstantOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range ConstantOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value ConstantOp::constant() {
  return *getODSResults(0).begin();
}

Attribute ConstantOp::valueAttr() {
  return this->getAttr("value").cast<Attribute>();
}

Attribute ConstantOp::value() {
  auto attr = valueAttr();
  return attr;
}

void ConstantOp::valueAttr(Attribute attr) {
  this->getOperation()->setAttr("value", attr);
}

void ConstantOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type constant, Attribute value) {
  odsState.addAttribute("value", value);
  odsState.addTypes(constant);
}

void ConstantOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Attribute value) {
  odsState.addAttribute("value", value);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ConstantOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult ConstantOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseConstantOp(parser, result);
}

void ConstantOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult ConstantOp::verify() {
  if (failed(ConstantOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isa<NoneType>())) || ((v.getType().isSignlessInteger(1))) || (((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || (((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::PointerType>())) || ((v.getType().isa<::mlir::spirv::ArrayType>())) || ((v.getType().isa<::mlir::spirv::RuntimeArrayType>())) || ((v.getType().isa<::mlir::spirv::StructType>())) || ((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) || ((v.getType().isa<::mlir::spirv::MatrixType>())))) {
        return emitOpError("result #") << index << " must be void or bool or 8/16/32/64-bit integer or 16/32/64-bit float or vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V pointer type or any SPIR-V array type or any SPIR-V runtime array type or any SPIR-V struct type or any SPIR-V cooperative matrix type or any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verify(*this);
}











void ConstantOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::ControlBarrierOp definitions
//===----------------------------------------------------------------------===//

ControlBarrierOpAdaptor::ControlBarrierOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

ControlBarrierOpAdaptor::ControlBarrierOpAdaptor(ControlBarrierOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> ControlBarrierOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange ControlBarrierOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

IntegerAttr ControlBarrierOpAdaptor::execution_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("execution_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr ControlBarrierOpAdaptor::memory_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr ControlBarrierOpAdaptor::memory_semantics() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_semantics").cast<IntegerAttr>();
  return attr;
}

LogicalResult ControlBarrierOpAdaptor::verify(Location loc) {
  {
  auto tblgen_execution_scope = odsAttrs.get("execution_scope");
  if (!tblgen_execution_scope) return emitError(loc, "'spv.ControlBarrier' op ""requires attribute 'execution_scope'");
    if (!((((tblgen_execution_scope.isa<IntegerAttr>())) && ((tblgen_execution_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_execution_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.ControlBarrier' op ""attribute 'execution_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_memory_scope = odsAttrs.get("memory_scope");
  if (!tblgen_memory_scope) return emitError(loc, "'spv.ControlBarrier' op ""requires attribute 'memory_scope'");
    if (!((((tblgen_memory_scope.isa<IntegerAttr>())) && ((tblgen_memory_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_memory_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.ControlBarrier' op ""attribute 'memory_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_memory_semantics = odsAttrs.get("memory_semantics");
  if (!tblgen_memory_semantics) return emitError(loc, "'spv.ControlBarrier' op ""requires attribute 'memory_semantics'");
    if (!((((tblgen_memory_semantics.isa<IntegerAttr>())) && ((tblgen_memory_semantics.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemorySemantics(tblgen_memory_semantics.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.ControlBarrier' op ""attribute 'memory_semantics' failed to satisfy constraint: valid SPIR-V MemorySemantics");
  }
  return success();
}

StringRef ControlBarrierOp::getOperationName() {
  return "spv.ControlBarrier";
}

std::pair<unsigned, unsigned> ControlBarrierOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range ControlBarrierOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> ControlBarrierOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range ControlBarrierOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

IntegerAttr ControlBarrierOp::execution_scopeAttr() {
  return this->getAttr("execution_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope ControlBarrierOp::execution_scope() {
  auto attr = execution_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr ControlBarrierOp::memory_scopeAttr() {
  return this->getAttr("memory_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope ControlBarrierOp::memory_scope() {
  auto attr = memory_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr ControlBarrierOp::memory_semanticsAttr() {
  return this->getAttr("memory_semantics").cast<IntegerAttr>();
}

::mlir::spirv::MemorySemantics ControlBarrierOp::memory_semantics() {
  auto attr = memory_semanticsAttr();
  return static_cast<::mlir::spirv::MemorySemantics>(attr.getInt());
}

void ControlBarrierOp::execution_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("execution_scope", attr);
}

void ControlBarrierOp::memory_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_scope", attr);
}

void ControlBarrierOp::memory_semanticsAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_semantics", attr);
}

void ControlBarrierOp::build(OpBuilder &odsBuilder, OperationState &odsState, IntegerAttr execution_scope, IntegerAttr memory_scope, IntegerAttr memory_semantics) {
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("memory_semantics", memory_semantics);
}

void ControlBarrierOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, IntegerAttr execution_scope, IntegerAttr memory_scope, IntegerAttr memory_semantics) {
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("memory_semantics", memory_semantics);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ControlBarrierOp::build(OpBuilder &odsBuilder, OperationState &odsState, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics memory_semantics) {
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("memory_semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_semantics)));
}

void ControlBarrierOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics memory_semantics) {
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("memory_semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_semantics)));
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ControlBarrierOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LogicalResult ControlBarrierOp::verify() {
  if (failed(ControlBarrierOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
  }
  return verifyMemorySemantics(*this);
}









ParseResult ControlBarrierOp::parse(OpAsmParser &parser, OperationState &result) {
  {
    StringAttr attrVal;
    NamedAttrList attrStorage;
    auto loc = parser.getCurrentLocation();
    if (parser.parseAttribute(attrVal, parser.getBuilder().getNoneType(),
                              "execution_scope", attrStorage))
      return failure();

    auto attrOptional = ::mlir::spirv::symbolizeScope(attrVal.getValue());
    if (!attrOptional)
      return parser.emitError(loc, "invalid ")
             << "execution_scope attribute specification: " << attrVal;

    result.addAttribute("execution_scope", parser.getBuilder().getI32IntegerAttr(static_cast<int32_t>(attrOptional.getValue())));
  }
  if (parser.parseComma())
    return failure();

  {
    StringAttr attrVal;
    NamedAttrList attrStorage;
    auto loc = parser.getCurrentLocation();
    if (parser.parseAttribute(attrVal, parser.getBuilder().getNoneType(),
                              "memory_scope", attrStorage))
      return failure();

    auto attrOptional = ::mlir::spirv::symbolizeScope(attrVal.getValue());
    if (!attrOptional)
      return parser.emitError(loc, "invalid ")
             << "memory_scope attribute specification: " << attrVal;

    result.addAttribute("memory_scope", parser.getBuilder().getI32IntegerAttr(static_cast<int32_t>(attrOptional.getValue())));
  }
  if (parser.parseComma())
    return failure();

  {
    StringAttr attrVal;
    NamedAttrList attrStorage;
    auto loc = parser.getCurrentLocation();
    if (parser.parseAttribute(attrVal, parser.getBuilder().getNoneType(),
                              "memory_semantics", attrStorage))
      return failure();

    auto attrOptional = ::mlir::spirv::symbolizeMemorySemantics(attrVal.getValue());
    if (!attrOptional)
      return parser.emitError(loc, "invalid ")
             << "memory_semantics attribute specification: " << attrVal;

    result.addAttribute("memory_semantics", parser.getBuilder().getI32IntegerAttr(static_cast<int32_t>(attrOptional.getValue())));
  }
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  return success();
}

void ControlBarrierOp::print(OpAsmPrinter &p) {
  p << "spv.ControlBarrier";
  p << " ";
  p << "\"" << stringifyScope(execution_scope()) << "\"";
  p << ",";
  p << " ";
  p << "\"" << stringifyScope(memory_scope()) << "\"";
  p << ",";
  p << " ";
  p << "\"" << stringifyMemorySemantics(memory_semantics()) << "\"";
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{"execution_scope", "memory_scope", "memory_semantics"});
}


//===----------------------------------------------------------------------===//
// spirv::ConvertFToSOp definitions
//===----------------------------------------------------------------------===//

ConvertFToSOpAdaptor::ConvertFToSOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

ConvertFToSOpAdaptor::ConvertFToSOpAdaptor(ConvertFToSOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> ConvertFToSOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange ConvertFToSOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value ConvertFToSOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult ConvertFToSOpAdaptor::verify(Location loc) {
  return success();
}

StringRef ConvertFToSOp::getOperationName() {
  return "spv.ConvertFToS";
}

std::pair<unsigned, unsigned> ConvertFToSOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range ConvertFToSOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value ConvertFToSOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange ConvertFToSOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> ConvertFToSOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range ConvertFToSOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value ConvertFToSOp::result() {
  return *getODSResults(0).begin();
}

void ConvertFToSOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void ConvertFToSOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ConvertFToSOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult ConvertFToSOp::parse(OpAsmParser &parser, OperationState &result) {
  return mlir::impl::parseCastOp(parser, result);
}

void ConvertFToSOp::print(OpAsmPrinter &p) {
  mlir::impl::printCastOp(this->getOperation(), p);
}

LogicalResult ConvertFToSOp::verify() {
  if (failed(ConvertFToSOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  return verifyCastOp(this->getOperation());
}









void ConvertFToSOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::ConvertFToUOp definitions
//===----------------------------------------------------------------------===//

ConvertFToUOpAdaptor::ConvertFToUOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

ConvertFToUOpAdaptor::ConvertFToUOpAdaptor(ConvertFToUOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> ConvertFToUOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange ConvertFToUOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value ConvertFToUOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult ConvertFToUOpAdaptor::verify(Location loc) {
  return success();
}

StringRef ConvertFToUOp::getOperationName() {
  return "spv.ConvertFToU";
}

std::pair<unsigned, unsigned> ConvertFToUOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range ConvertFToUOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value ConvertFToUOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange ConvertFToUOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> ConvertFToUOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range ConvertFToUOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value ConvertFToUOp::result() {
  return *getODSResults(0).begin();
}

void ConvertFToUOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void ConvertFToUOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ConvertFToUOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult ConvertFToUOp::parse(OpAsmParser &parser, OperationState &result) {
  return mlir::impl::parseCastOp(parser, result);
}

void ConvertFToUOp::print(OpAsmPrinter &p) {
  mlir::impl::printCastOp(this->getOperation(), p);
}

LogicalResult ConvertFToUOp::verify() {
  if (failed(ConvertFToUOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  return verifyCastOp(this->getOperation());
}









void ConvertFToUOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::ConvertSToFOp definitions
//===----------------------------------------------------------------------===//

ConvertSToFOpAdaptor::ConvertSToFOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

ConvertSToFOpAdaptor::ConvertSToFOpAdaptor(ConvertSToFOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> ConvertSToFOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange ConvertSToFOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value ConvertSToFOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult ConvertSToFOpAdaptor::verify(Location loc) {
  return success();
}

StringRef ConvertSToFOp::getOperationName() {
  return "spv.ConvertSToF";
}

std::pair<unsigned, unsigned> ConvertSToFOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range ConvertSToFOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value ConvertSToFOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange ConvertSToFOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> ConvertSToFOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range ConvertSToFOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value ConvertSToFOp::result() {
  return *getODSResults(0).begin();
}

void ConvertSToFOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void ConvertSToFOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ConvertSToFOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult ConvertSToFOp::parse(OpAsmParser &parser, OperationState &result) {
  return mlir::impl::parseCastOp(parser, result);
}

void ConvertSToFOp::print(OpAsmPrinter &p) {
  mlir::impl::printCastOp(this->getOperation(), p);
}

LogicalResult ConvertSToFOp::verify() {
  if (failed(ConvertSToFOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  return verifyCastOp(this->getOperation());
}









void ConvertSToFOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::ConvertUToFOp definitions
//===----------------------------------------------------------------------===//

ConvertUToFOpAdaptor::ConvertUToFOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

ConvertUToFOpAdaptor::ConvertUToFOpAdaptor(ConvertUToFOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> ConvertUToFOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange ConvertUToFOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value ConvertUToFOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult ConvertUToFOpAdaptor::verify(Location loc) {
  return success();
}

StringRef ConvertUToFOp::getOperationName() {
  return "spv.ConvertUToF";
}

std::pair<unsigned, unsigned> ConvertUToFOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range ConvertUToFOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value ConvertUToFOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange ConvertUToFOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> ConvertUToFOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range ConvertUToFOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value ConvertUToFOp::result() {
  return *getODSResults(0).begin();
}

void ConvertUToFOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void ConvertUToFOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ConvertUToFOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult ConvertUToFOp::parse(OpAsmParser &parser, OperationState &result) {
  return mlir::impl::parseCastOp(parser, result);
}

void ConvertUToFOp::print(OpAsmPrinter &p) {
  mlir::impl::printCastOp(this->getOperation(), p);
}

LogicalResult ConvertUToFOp::verify() {
  if (failed(ConvertUToFOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  return verifyCastOp(this->getOperation());
}









void ConvertUToFOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::CooperativeMatrixLengthNVOp definitions
//===----------------------------------------------------------------------===//

CooperativeMatrixLengthNVOpAdaptor::CooperativeMatrixLengthNVOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

CooperativeMatrixLengthNVOpAdaptor::CooperativeMatrixLengthNVOpAdaptor(CooperativeMatrixLengthNVOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> CooperativeMatrixLengthNVOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange CooperativeMatrixLengthNVOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

TypeAttr CooperativeMatrixLengthNVOpAdaptor::type() {
  assert(odsAttrs && "no attributes when constructing adapter");
  TypeAttr attr = odsAttrs.get("type").cast<TypeAttr>();
  return attr;
}

LogicalResult CooperativeMatrixLengthNVOpAdaptor::verify(Location loc) {
  {
  auto tblgen_type = odsAttrs.get("type");
  if (!tblgen_type) return emitError(loc, "'spv.CooperativeMatrixLengthNV' op ""requires attribute 'type'");
    if (!(((tblgen_type.isa<TypeAttr>())) && ((tblgen_type.cast<TypeAttr>().getValue().isa<Type>())))) return emitError(loc, "'spv.CooperativeMatrixLengthNV' op ""attribute 'type' failed to satisfy constraint: any type attribute");
  }
  return success();
}

StringRef CooperativeMatrixLengthNVOp::getOperationName() {
  return "spv.CooperativeMatrixLengthNV";
}

std::pair<unsigned, unsigned> CooperativeMatrixLengthNVOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range CooperativeMatrixLengthNVOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> CooperativeMatrixLengthNVOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range CooperativeMatrixLengthNVOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value CooperativeMatrixLengthNVOp::result() {
  return *getODSResults(0).begin();
}

TypeAttr CooperativeMatrixLengthNVOp::typeAttr() {
  return this->getAttr("type").cast<TypeAttr>();
}

Type CooperativeMatrixLengthNVOp::type() {
  auto attr = typeAttr();
  return attr.getValue().cast<Type>();
}

void CooperativeMatrixLengthNVOp::typeAttr(TypeAttr attr) {
  this->getOperation()->setAttr("type", attr);
}

void CooperativeMatrixLengthNVOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, TypeAttr type) {
  odsState.addAttribute("type", type);
  odsState.addTypes(result);
}

void CooperativeMatrixLengthNVOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, TypeAttr type) {
  odsState.addAttribute("type", type);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CooperativeMatrixLengthNVOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LogicalResult CooperativeMatrixLengthNVOp::verify() {
  if (failed(CooperativeMatrixLengthNVOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isSignlessInteger(32)))) {
        return emitOpError("result #") << index << " must be Int32, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









ParseResult CooperativeMatrixLengthNVOp::parse(OpAsmParser &parser, OperationState &result) {
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  if (parser.parseColon())
    return failure();

  TypeAttr typeAttr;
  if (parser.parseAttribute(typeAttr, parser.getBuilder().getType<NoneType>(), "type", result.attributes))
    return failure();
  Type odsBuildableType0 = parser.getBuilder().getIntegerType(32);
  result.addTypes(odsBuildableType0);
  return success();
}

void CooperativeMatrixLengthNVOp::print(OpAsmPrinter &p) {
  p << "spv.CooperativeMatrixLengthNV";
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{"type"});
  p << " " << ":";
  p << " ";
  p.printAttributeWithoutType(typeAttr());
}

void CooperativeMatrixLengthNVOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::CooperativeMatrixLoadNVOp definitions
//===----------------------------------------------------------------------===//

CooperativeMatrixLoadNVOpAdaptor::CooperativeMatrixLoadNVOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

CooperativeMatrixLoadNVOpAdaptor::CooperativeMatrixLoadNVOpAdaptor(CooperativeMatrixLoadNVOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> CooperativeMatrixLoadNVOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange CooperativeMatrixLoadNVOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value CooperativeMatrixLoadNVOpAdaptor::pointer() {
  return *getODSOperands(0).begin();
}

Value CooperativeMatrixLoadNVOpAdaptor::stride() {
  return *getODSOperands(1).begin();
}

Value CooperativeMatrixLoadNVOpAdaptor::columnmajor() {
  return *getODSOperands(2).begin();
}

IntegerAttr CooperativeMatrixLoadNVOpAdaptor::memory_access() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_access").dyn_cast_or_null<IntegerAttr>();
  return attr;
}

LogicalResult CooperativeMatrixLoadNVOpAdaptor::verify(Location loc) {
  {
  auto tblgen_memory_access = odsAttrs.get("memory_access");
  if (tblgen_memory_access) {
    if (!((((tblgen_memory_access.isa<IntegerAttr>())) && ((tblgen_memory_access.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemoryAccess(tblgen_memory_access.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.CooperativeMatrixLoadNV' op ""attribute 'memory_access' failed to satisfy constraint: valid SPIR-V MemoryAccess");
  }
  }
  return success();
}

StringRef CooperativeMatrixLoadNVOp::getOperationName() {
  return "spv.CooperativeMatrixLoadNV";
}

std::pair<unsigned, unsigned> CooperativeMatrixLoadNVOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range CooperativeMatrixLoadNVOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value CooperativeMatrixLoadNVOp::pointer() {
  return *getODSOperands(0).begin();
}

Value CooperativeMatrixLoadNVOp::stride() {
  return *getODSOperands(1).begin();
}

Value CooperativeMatrixLoadNVOp::columnmajor() {
  return *getODSOperands(2).begin();
}

::mlir::MutableOperandRange CooperativeMatrixLoadNVOp::pointerMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange CooperativeMatrixLoadNVOp::strideMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange CooperativeMatrixLoadNVOp::columnmajorMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> CooperativeMatrixLoadNVOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range CooperativeMatrixLoadNVOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value CooperativeMatrixLoadNVOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr CooperativeMatrixLoadNVOp::memory_accessAttr() {
  return this->getAttr("memory_access").dyn_cast_or_null<IntegerAttr>();
}

Optional<::mlir::spirv::MemoryAccess> CooperativeMatrixLoadNVOp::memory_access() {
  auto attr = memory_accessAttr();
  return attr ? Optional<::mlir::spirv::MemoryAccess>(static_cast<::mlir::spirv::MemoryAccess>(attr.getInt())) : (llvm::None);
}

void CooperativeMatrixLoadNVOp::memory_accessAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_access", attr);
}

void CooperativeMatrixLoadNVOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value pointer, Value stride, Value columnmajor, /*optional*/IntegerAttr memory_access) {
  odsState.addOperands(pointer);
  odsState.addOperands(stride);
  odsState.addOperands(columnmajor);
  if (memory_access) {
  odsState.addAttribute("memory_access", memory_access);
  }
  odsState.addTypes(result);
}

void CooperativeMatrixLoadNVOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, Value stride, Value columnmajor, /*optional*/IntegerAttr memory_access) {
  odsState.addOperands(pointer);
  odsState.addOperands(stride);
  odsState.addOperands(columnmajor);
  if (memory_access) {
  odsState.addAttribute("memory_access", memory_access);
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CooperativeMatrixLoadNVOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult CooperativeMatrixLoadNVOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseCooperativeMatrixLoadNVOp(parser, result);
}

void CooperativeMatrixLoadNVOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult CooperativeMatrixLoadNVOp::verify() {
  if (failed(CooperativeMatrixLoadNVOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup2 = getODSOperands(2);
    for (Value v : valueGroup2) {
      (void)v;
      if (!((v.getType().isSignlessInteger(1)))) {
        return emitOpError("operand #") << index << " must be bool, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>()))) {
        return emitOpError("result #") << index << " must be any SPIR-V cooperative matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  return verifyPointerAndCoopMatrixType(*this, pointer().getType(),
                                          result().getType());
}










//===----------------------------------------------------------------------===//
// spirv::CooperativeMatrixMulAddNVOp definitions
//===----------------------------------------------------------------------===//

CooperativeMatrixMulAddNVOpAdaptor::CooperativeMatrixMulAddNVOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

CooperativeMatrixMulAddNVOpAdaptor::CooperativeMatrixMulAddNVOpAdaptor(CooperativeMatrixMulAddNVOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> CooperativeMatrixMulAddNVOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange CooperativeMatrixMulAddNVOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value CooperativeMatrixMulAddNVOpAdaptor::a() {
  return *getODSOperands(0).begin();
}

Value CooperativeMatrixMulAddNVOpAdaptor::b() {
  return *getODSOperands(1).begin();
}

Value CooperativeMatrixMulAddNVOpAdaptor::c() {
  return *getODSOperands(2).begin();
}

LogicalResult CooperativeMatrixMulAddNVOpAdaptor::verify(Location loc) {
  return success();
}

StringRef CooperativeMatrixMulAddNVOp::getOperationName() {
  return "spv.CooperativeMatrixMulAddNV";
}

std::pair<unsigned, unsigned> CooperativeMatrixMulAddNVOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range CooperativeMatrixMulAddNVOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value CooperativeMatrixMulAddNVOp::a() {
  return *getODSOperands(0).begin();
}

Value CooperativeMatrixMulAddNVOp::b() {
  return *getODSOperands(1).begin();
}

Value CooperativeMatrixMulAddNVOp::c() {
  return *getODSOperands(2).begin();
}

::mlir::MutableOperandRange CooperativeMatrixMulAddNVOp::aMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange CooperativeMatrixMulAddNVOp::bMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange CooperativeMatrixMulAddNVOp::cMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> CooperativeMatrixMulAddNVOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range CooperativeMatrixMulAddNVOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value CooperativeMatrixMulAddNVOp::result() {
  return *getODSResults(0).begin();
}

void CooperativeMatrixMulAddNVOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value a, Value b, Value c) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  odsState.addTypes(result);
}

void CooperativeMatrixMulAddNVOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value a, Value b, Value c) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CooperativeMatrixMulAddNVOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LogicalResult CooperativeMatrixMulAddNVOp::verify() {
  if (failed(CooperativeMatrixMulAddNVOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V cooperative matrix type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V cooperative matrix type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup2 = getODSOperands(2);
    for (Value v : valueGroup2) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V cooperative matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>()))) {
        return emitOpError("result #") << index << " must be any SPIR-V cooperative matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  if (!((llvm::is_splat(llvm::makeArrayRef({(*this->getODSOperands(2).begin()).getType(), (*this->getODSResults(0).begin()).getType()})))))
    return emitOpError("failed to verify that all of {c, result} have same type");
  return verifyCoopMatrixMulAdd(*this);
}









ParseResult CooperativeMatrixMulAddNVOp::parse(OpAsmParser &parser, OperationState &result) {
  Type aRawTypes[1];
  ArrayRef<Type> aTypes(aRawTypes);
  Type bRawTypes[1];
  ArrayRef<Type> bTypes(bRawTypes);
  Type cRawTypes[1];
  ArrayRef<Type> cTypes(cRawTypes);
  llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  SmallVector<OpAsmParser::OperandType, 4> allOperands;
  if (parser.parseOperandList(allOperands))
    return failure();
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  if (parser.parseColon())
    return failure();

  if (parser.parseType(aRawTypes[0]))
    return failure();
  if (parser.parseComma())
    return failure();

  if (parser.parseType(bRawTypes[0]))
    return failure();
  if (parser.parseArrow())
    return failure();

  if (parser.parseType(cRawTypes[0]))
    return failure();
  result.addTypes(cTypes);
  if (parser.resolveOperands(allOperands, llvm::concat<const Type>(ArrayRef<Type>(aTypes), ArrayRef<Type>(bTypes), ArrayRef<Type>(cTypes)), allOperandLoc, result.operands))
    return failure();
  return success();
}

void CooperativeMatrixMulAddNVOp::print(OpAsmPrinter &p) {
  p << "spv.CooperativeMatrixMulAddNV";
  p << " ";
  p << getOperation()->getOperands();
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{});
  p << " " << ":";
  p << " ";
  p << ArrayRef<Type>(a().getType());
  p << ",";
  p << " ";
  p << ArrayRef<Type>(b().getType());
  p << " " << "->";
  p << " ";
  p << ArrayRef<Type>(c().getType());
}

void CooperativeMatrixMulAddNVOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::CooperativeMatrixStoreNVOp definitions
//===----------------------------------------------------------------------===//

CooperativeMatrixStoreNVOpAdaptor::CooperativeMatrixStoreNVOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

CooperativeMatrixStoreNVOpAdaptor::CooperativeMatrixStoreNVOpAdaptor(CooperativeMatrixStoreNVOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> CooperativeMatrixStoreNVOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange CooperativeMatrixStoreNVOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value CooperativeMatrixStoreNVOpAdaptor::pointer() {
  return *getODSOperands(0).begin();
}

Value CooperativeMatrixStoreNVOpAdaptor::object() {
  return *getODSOperands(1).begin();
}

Value CooperativeMatrixStoreNVOpAdaptor::stride() {
  return *getODSOperands(2).begin();
}

Value CooperativeMatrixStoreNVOpAdaptor::columnmajor() {
  return *getODSOperands(3).begin();
}

IntegerAttr CooperativeMatrixStoreNVOpAdaptor::memory_access() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_access").dyn_cast_or_null<IntegerAttr>();
  return attr;
}

LogicalResult CooperativeMatrixStoreNVOpAdaptor::verify(Location loc) {
  {
  auto tblgen_memory_access = odsAttrs.get("memory_access");
  if (tblgen_memory_access) {
    if (!((((tblgen_memory_access.isa<IntegerAttr>())) && ((tblgen_memory_access.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemoryAccess(tblgen_memory_access.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.CooperativeMatrixStoreNV' op ""attribute 'memory_access' failed to satisfy constraint: valid SPIR-V MemoryAccess");
  }
  }
  return success();
}

StringRef CooperativeMatrixStoreNVOp::getOperationName() {
  return "spv.CooperativeMatrixStoreNV";
}

std::pair<unsigned, unsigned> CooperativeMatrixStoreNVOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range CooperativeMatrixStoreNVOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value CooperativeMatrixStoreNVOp::pointer() {
  return *getODSOperands(0).begin();
}

Value CooperativeMatrixStoreNVOp::object() {
  return *getODSOperands(1).begin();
}

Value CooperativeMatrixStoreNVOp::stride() {
  return *getODSOperands(2).begin();
}

Value CooperativeMatrixStoreNVOp::columnmajor() {
  return *getODSOperands(3).begin();
}

::mlir::MutableOperandRange CooperativeMatrixStoreNVOp::pointerMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange CooperativeMatrixStoreNVOp::objectMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange CooperativeMatrixStoreNVOp::strideMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange CooperativeMatrixStoreNVOp::columnmajorMutable() {
  auto range = getODSOperandIndexAndLength(3);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> CooperativeMatrixStoreNVOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range CooperativeMatrixStoreNVOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

IntegerAttr CooperativeMatrixStoreNVOp::memory_accessAttr() {
  return this->getAttr("memory_access").dyn_cast_or_null<IntegerAttr>();
}

Optional<::mlir::spirv::MemoryAccess> CooperativeMatrixStoreNVOp::memory_access() {
  auto attr = memory_accessAttr();
  return attr ? Optional<::mlir::spirv::MemoryAccess>(static_cast<::mlir::spirv::MemoryAccess>(attr.getInt())) : (llvm::None);
}

void CooperativeMatrixStoreNVOp::memory_accessAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_access", attr);
}

void CooperativeMatrixStoreNVOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value pointer, Value object, Value stride, Value columnmajor, /*optional*/IntegerAttr memory_access) {
  odsState.addOperands(pointer);
  odsState.addOperands(object);
  odsState.addOperands(stride);
  odsState.addOperands(columnmajor);
  if (memory_access) {
  odsState.addAttribute("memory_access", memory_access);
  }
}

void CooperativeMatrixStoreNVOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value pointer, Value object, Value stride, Value columnmajor, /*optional*/IntegerAttr memory_access) {
  odsState.addOperands(pointer);
  odsState.addOperands(object);
  odsState.addOperands(stride);
  odsState.addOperands(columnmajor);
  if (memory_access) {
  odsState.addAttribute("memory_access", memory_access);
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CooperativeMatrixStoreNVOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 4u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult CooperativeMatrixStoreNVOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseCooperativeMatrixStoreNVOp(parser, result);
}

void CooperativeMatrixStoreNVOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult CooperativeMatrixStoreNVOp::verify() {
  if (failed(CooperativeMatrixStoreNVOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V cooperative matrix type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup2 = getODSOperands(2);
    for (Value v : valueGroup2) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup3 = getODSOperands(3);
    for (Value v : valueGroup3) {
      (void)v;
      if (!((v.getType().isSignlessInteger(1)))) {
        return emitOpError("operand #") << index << " must be bool, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
  }
  return verifyPointerAndCoopMatrixType(*this, pointer().getType(),
                                          object().getType());
}










//===----------------------------------------------------------------------===//
// spirv::EntryPointOp definitions
//===----------------------------------------------------------------------===//

EntryPointOpAdaptor::EntryPointOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

EntryPointOpAdaptor::EntryPointOpAdaptor(EntryPointOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> EntryPointOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange EntryPointOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

IntegerAttr EntryPointOpAdaptor::execution_model() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("execution_model").cast<IntegerAttr>();
  return attr;
}

FlatSymbolRefAttr EntryPointOpAdaptor::fn() {
  assert(odsAttrs && "no attributes when constructing adapter");
  FlatSymbolRefAttr attr = odsAttrs.get("fn").cast<FlatSymbolRefAttr>();
  return attr;
}

ArrayAttr EntryPointOpAdaptor::interface() {
  assert(odsAttrs && "no attributes when constructing adapter");
  ArrayAttr attr = odsAttrs.get("interface").cast<ArrayAttr>();
  return attr;
}

LogicalResult EntryPointOpAdaptor::verify(Location loc) {
  {
  auto tblgen_execution_model = odsAttrs.get("execution_model");
  if (!tblgen_execution_model) return emitError(loc, "'spv.EntryPoint' op ""requires attribute 'execution_model'");
    if (!((((tblgen_execution_model.isa<IntegerAttr>())) && ((tblgen_execution_model.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeExecutionModel(tblgen_execution_model.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.EntryPoint' op ""attribute 'execution_model' failed to satisfy constraint: valid SPIR-V ExecutionModel");
  }
  {
  auto tblgen_fn = odsAttrs.get("fn");
  if (!tblgen_fn) return emitError(loc, "'spv.EntryPoint' op ""requires attribute 'fn'");
    if (!((tblgen_fn.isa<FlatSymbolRefAttr>()))) return emitError(loc, "'spv.EntryPoint' op ""attribute 'fn' failed to satisfy constraint: flat symbol reference attribute");
  }
  {
  auto tblgen_interface = odsAttrs.get("interface");
  if (!tblgen_interface) return emitError(loc, "'spv.EntryPoint' op ""requires attribute 'interface'");
    if (!(((tblgen_interface.isa<ArrayAttr>())) && (llvm::all_of(tblgen_interface.cast<ArrayAttr>(), [](Attribute attr) { return (attr.isa<SymbolRefAttr>()); })))) return emitError(loc, "'spv.EntryPoint' op ""attribute 'interface' failed to satisfy constraint: symbol ref array attribute");
  }
  return success();
}

StringRef EntryPointOp::getOperationName() {
  return "spv.EntryPoint";
}

std::pair<unsigned, unsigned> EntryPointOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range EntryPointOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> EntryPointOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range EntryPointOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

IntegerAttr EntryPointOp::execution_modelAttr() {
  return this->getAttr("execution_model").cast<IntegerAttr>();
}

::mlir::spirv::ExecutionModel EntryPointOp::execution_model() {
  auto attr = execution_modelAttr();
  return static_cast<::mlir::spirv::ExecutionModel>(attr.getInt());
}

FlatSymbolRefAttr EntryPointOp::fnAttr() {
  return this->getAttr("fn").cast<FlatSymbolRefAttr>();
}

StringRef EntryPointOp::fn() {
  auto attr = fnAttr();
  return attr.getValue();
}

ArrayAttr EntryPointOp::interfaceAttr() {
  return this->getAttr("interface").cast<ArrayAttr>();
}

ArrayAttr EntryPointOp::interface() {
  auto attr = interfaceAttr();
  return attr;
}

void EntryPointOp::execution_modelAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("execution_model", attr);
}

void EntryPointOp::fnAttr(FlatSymbolRefAttr attr) {
  this->getOperation()->setAttr("fn", attr);
}

void EntryPointOp::interfaceAttr(ArrayAttr attr) {
  this->getOperation()->setAttr("interface", attr);
}



void EntryPointOp::build(OpBuilder &odsBuilder, OperationState &odsState, IntegerAttr execution_model, FlatSymbolRefAttr fn, ArrayAttr interface) {
  odsState.addAttribute("execution_model", execution_model);
  odsState.addAttribute("fn", fn);
  odsState.addAttribute("interface", interface);
}

void EntryPointOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, IntegerAttr execution_model, FlatSymbolRefAttr fn, ArrayAttr interface) {
  odsState.addAttribute("execution_model", execution_model);
  odsState.addAttribute("fn", fn);
  odsState.addAttribute("interface", interface);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void EntryPointOp::build(OpBuilder &odsBuilder, OperationState &odsState, ::mlir::spirv::ExecutionModel execution_model, StringRef fn, ArrayAttr interface) {
  odsState.addAttribute("execution_model", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_model)));
  odsState.addAttribute("fn", odsBuilder.getSymbolRefAttr(fn));
  odsState.addAttribute("interface", interface);
}

void EntryPointOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ::mlir::spirv::ExecutionModel execution_model, StringRef fn, ArrayAttr interface) {
  odsState.addAttribute("execution_model", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_model)));
  odsState.addAttribute("fn", odsBuilder.getSymbolRefAttr(fn));
  odsState.addAttribute("interface", interface);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void EntryPointOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult EntryPointOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseEntryPointOp(parser, result);
}

void EntryPointOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult EntryPointOp::verify() {
  if (failed(EntryPointOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
  }
  if (!((isDirectInModuleLikeOp((*this->getOperation()).getParentOp()))))
    return emitOpError("failed to verify that op must appear in a module-like op's block");
  return ::verify(*this);
}










//===----------------------------------------------------------------------===//
// spirv::ExecutionModeOp definitions
//===----------------------------------------------------------------------===//

ExecutionModeOpAdaptor::ExecutionModeOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

ExecutionModeOpAdaptor::ExecutionModeOpAdaptor(ExecutionModeOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> ExecutionModeOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange ExecutionModeOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

FlatSymbolRefAttr ExecutionModeOpAdaptor::fn() {
  assert(odsAttrs && "no attributes when constructing adapter");
  FlatSymbolRefAttr attr = odsAttrs.get("fn").cast<FlatSymbolRefAttr>();
  return attr;
}

IntegerAttr ExecutionModeOpAdaptor::execution_mode() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("execution_mode").cast<IntegerAttr>();
  return attr;
}

ArrayAttr ExecutionModeOpAdaptor::values() {
  assert(odsAttrs && "no attributes when constructing adapter");
  ArrayAttr attr = odsAttrs.get("values").cast<ArrayAttr>();
  return attr;
}

LogicalResult ExecutionModeOpAdaptor::verify(Location loc) {
  {
  auto tblgen_fn = odsAttrs.get("fn");
  if (!tblgen_fn) return emitError(loc, "'spv.ExecutionMode' op ""requires attribute 'fn'");
    if (!((tblgen_fn.isa<FlatSymbolRefAttr>()))) return emitError(loc, "'spv.ExecutionMode' op ""attribute 'fn' failed to satisfy constraint: flat symbol reference attribute");
  }
  {
  auto tblgen_execution_mode = odsAttrs.get("execution_mode");
  if (!tblgen_execution_mode) return emitError(loc, "'spv.ExecutionMode' op ""requires attribute 'execution_mode'");
    if (!((((tblgen_execution_mode.isa<IntegerAttr>())) && ((tblgen_execution_mode.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeExecutionMode(tblgen_execution_mode.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.ExecutionMode' op ""attribute 'execution_mode' failed to satisfy constraint: valid SPIR-V ExecutionMode");
  }
  {
  auto tblgen_values = odsAttrs.get("values");
  if (!tblgen_values) return emitError(loc, "'spv.ExecutionMode' op ""requires attribute 'values'");
    if (!(((tblgen_values.isa<ArrayAttr>())) && (llvm::all_of(tblgen_values.cast<ArrayAttr>(), [](Attribute attr) { return ((attr.isa<IntegerAttr>())) && ((attr.cast<IntegerAttr>().getType().isSignlessInteger(32))); })))) return emitError(loc, "'spv.ExecutionMode' op ""attribute 'values' failed to satisfy constraint: 32-bit integer array attribute");
  }
  return success();
}

StringRef ExecutionModeOp::getOperationName() {
  return "spv.ExecutionMode";
}

std::pair<unsigned, unsigned> ExecutionModeOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range ExecutionModeOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> ExecutionModeOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range ExecutionModeOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

FlatSymbolRefAttr ExecutionModeOp::fnAttr() {
  return this->getAttr("fn").cast<FlatSymbolRefAttr>();
}

StringRef ExecutionModeOp::fn() {
  auto attr = fnAttr();
  return attr.getValue();
}

IntegerAttr ExecutionModeOp::execution_modeAttr() {
  return this->getAttr("execution_mode").cast<IntegerAttr>();
}

::mlir::spirv::ExecutionMode ExecutionModeOp::execution_mode() {
  auto attr = execution_modeAttr();
  return static_cast<::mlir::spirv::ExecutionMode>(attr.getInt());
}

ArrayAttr ExecutionModeOp::valuesAttr() {
  return this->getAttr("values").cast<ArrayAttr>();
}

ArrayAttr ExecutionModeOp::values() {
  auto attr = valuesAttr();
  return attr;
}

void ExecutionModeOp::fnAttr(FlatSymbolRefAttr attr) {
  this->getOperation()->setAttr("fn", attr);
}

void ExecutionModeOp::execution_modeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("execution_mode", attr);
}

void ExecutionModeOp::valuesAttr(ArrayAttr attr) {
  this->getOperation()->setAttr("values", attr);
}



void ExecutionModeOp::build(OpBuilder &odsBuilder, OperationState &odsState, FlatSymbolRefAttr fn, IntegerAttr execution_mode, ArrayAttr values) {
  odsState.addAttribute("fn", fn);
  odsState.addAttribute("execution_mode", execution_mode);
  odsState.addAttribute("values", values);
}

void ExecutionModeOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, FlatSymbolRefAttr fn, IntegerAttr execution_mode, ArrayAttr values) {
  odsState.addAttribute("fn", fn);
  odsState.addAttribute("execution_mode", execution_mode);
  odsState.addAttribute("values", values);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ExecutionModeOp::build(OpBuilder &odsBuilder, OperationState &odsState, StringRef fn, ::mlir::spirv::ExecutionMode execution_mode, ArrayAttr values) {
  odsState.addAttribute("fn", odsBuilder.getSymbolRefAttr(fn));
  odsState.addAttribute("execution_mode", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_mode)));
  odsState.addAttribute("values", values);
}

void ExecutionModeOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, StringRef fn, ::mlir::spirv::ExecutionMode execution_mode, ArrayAttr values) {
  odsState.addAttribute("fn", odsBuilder.getSymbolRefAttr(fn));
  odsState.addAttribute("execution_mode", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_mode)));
  odsState.addAttribute("values", values);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ExecutionModeOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult ExecutionModeOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseExecutionModeOp(parser, result);
}

void ExecutionModeOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult ExecutionModeOp::verify() {
  if (failed(ExecutionModeOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
  }
  if (!((isDirectInModuleLikeOp((*this->getOperation()).getParentOp()))))
    return emitOpError("failed to verify that op must appear in a module-like op's block");
  return success();
}










//===----------------------------------------------------------------------===//
// spirv::FAddOp definitions
//===----------------------------------------------------------------------===//

FAddOpAdaptor::FAddOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FAddOpAdaptor::FAddOpAdaptor(FAddOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FAddOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FAddOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FAddOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FAddOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FAddOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FAddOp::getOperationName() {
  return "spv.FAdd";
}

std::pair<unsigned, unsigned> FAddOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FAddOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FAddOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FAddOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FAddOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FAddOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FAddOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FAddOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FAddOp::result() {
  return *getODSResults(0).begin();
}

void FAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FAddOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void FAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes({operand1.getType()});

}

void FAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult FAddOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void FAddOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult FAddOp::verify() {
  if (failed(FAddOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FAddOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FConvertOp definitions
//===----------------------------------------------------------------------===//

FConvertOpAdaptor::FConvertOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FConvertOpAdaptor::FConvertOpAdaptor(FConvertOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FConvertOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FConvertOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FConvertOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult FConvertOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FConvertOp::getOperationName() {
  return "spv.FConvert";
}

std::pair<unsigned, unsigned> FConvertOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FConvertOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FConvertOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange FConvertOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FConvertOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FConvertOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FConvertOp::result() {
  return *getODSResults(0).begin();
}

void FConvertOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void FConvertOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FConvertOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult FConvertOp::parse(OpAsmParser &parser, OperationState &result) {
  return mlir::impl::parseCastOp(parser, result);
}

void FConvertOp::print(OpAsmPrinter &p) {
  mlir::impl::printCastOp(this->getOperation(), p);
}

LogicalResult FConvertOp::verify() {
  if (failed(FConvertOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  return verifyCastOp(this->getOperation(), false);
}









void FConvertOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FDivOp definitions
//===----------------------------------------------------------------------===//

FDivOpAdaptor::FDivOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FDivOpAdaptor::FDivOpAdaptor(FDivOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FDivOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FDivOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FDivOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FDivOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FDivOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FDivOp::getOperationName() {
  return "spv.FDiv";
}

std::pair<unsigned, unsigned> FDivOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FDivOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FDivOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FDivOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FDivOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FDivOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FDivOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FDivOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FDivOp::result() {
  return *getODSResults(0).begin();
}

void FDivOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FDivOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FDivOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void FDivOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes({operand1.getType()});

}

void FDivOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult FDivOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void FDivOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult FDivOp::verify() {
  if (failed(FDivOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FDivOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FModOp definitions
//===----------------------------------------------------------------------===//

FModOpAdaptor::FModOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FModOpAdaptor::FModOpAdaptor(FModOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FModOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FModOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FModOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FModOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FModOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FModOp::getOperationName() {
  return "spv.FMod";
}

std::pair<unsigned, unsigned> FModOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FModOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FModOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FModOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FModOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FModOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FModOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FModOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FModOp::result() {
  return *getODSResults(0).begin();
}

void FModOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FModOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FModOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void FModOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes({operand1.getType()});

}

void FModOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult FModOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void FModOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult FModOp::verify() {
  if (failed(FModOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FModOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FMulOp definitions
//===----------------------------------------------------------------------===//

FMulOpAdaptor::FMulOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FMulOpAdaptor::FMulOpAdaptor(FMulOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FMulOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FMulOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FMulOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FMulOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FMulOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FMulOp::getOperationName() {
  return "spv.FMul";
}

std::pair<unsigned, unsigned> FMulOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FMulOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FMulOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FMulOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FMulOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FMulOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FMulOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FMulOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FMulOp::result() {
  return *getODSResults(0).begin();
}

void FMulOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FMulOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FMulOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void FMulOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes({operand1.getType()});

}

void FMulOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult FMulOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void FMulOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult FMulOp::verify() {
  if (failed(FMulOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FMulOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FNegateOp definitions
//===----------------------------------------------------------------------===//

FNegateOpAdaptor::FNegateOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FNegateOpAdaptor::FNegateOpAdaptor(FNegateOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FNegateOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FNegateOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FNegateOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult FNegateOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FNegateOp::getOperationName() {
  return "spv.FNegate";
}

std::pair<unsigned, unsigned> FNegateOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FNegateOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FNegateOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange FNegateOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FNegateOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FNegateOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FNegateOp::result() {
  return *getODSResults(0).begin();
}

void FNegateOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void FNegateOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FNegateOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void FNegateOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes({operand.getType()});

}

void FNegateOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult FNegateOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseUnaryOp(parser, result);
}

void FNegateOp::print(OpAsmPrinter &p) {
  return ::printUnaryOp(getOperation(), p);
}

LogicalResult FNegateOp::verify() {
  if (failed(FNegateOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FNegateOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FOrdEqualOp definitions
//===----------------------------------------------------------------------===//

FOrdEqualOpAdaptor::FOrdEqualOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FOrdEqualOpAdaptor::FOrdEqualOpAdaptor(FOrdEqualOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FOrdEqualOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FOrdEqualOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FOrdEqualOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FOrdEqualOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FOrdEqualOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FOrdEqualOp::getOperationName() {
  return "spv.FOrdEqual";
}

std::pair<unsigned, unsigned> FOrdEqualOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FOrdEqualOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FOrdEqualOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FOrdEqualOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FOrdEqualOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FOrdEqualOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FOrdEqualOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FOrdEqualOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FOrdEqualOp::result() {
  return *getODSResults(0).begin();
}

void FOrdEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FOrdEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FOrdEqualOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult FOrdEqualOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void FOrdEqualOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult FOrdEqualOp::verify() {
  if (failed(FOrdEqualOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FOrdEqualOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FOrdGreaterThanEqualOp definitions
//===----------------------------------------------------------------------===//

FOrdGreaterThanEqualOpAdaptor::FOrdGreaterThanEqualOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FOrdGreaterThanEqualOpAdaptor::FOrdGreaterThanEqualOpAdaptor(FOrdGreaterThanEqualOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FOrdGreaterThanEqualOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FOrdGreaterThanEqualOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FOrdGreaterThanEqualOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FOrdGreaterThanEqualOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FOrdGreaterThanEqualOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FOrdGreaterThanEqualOp::getOperationName() {
  return "spv.FOrdGreaterThanEqual";
}

std::pair<unsigned, unsigned> FOrdGreaterThanEqualOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FOrdGreaterThanEqualOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FOrdGreaterThanEqualOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FOrdGreaterThanEqualOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FOrdGreaterThanEqualOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FOrdGreaterThanEqualOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FOrdGreaterThanEqualOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FOrdGreaterThanEqualOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FOrdGreaterThanEqualOp::result() {
  return *getODSResults(0).begin();
}

void FOrdGreaterThanEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FOrdGreaterThanEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FOrdGreaterThanEqualOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult FOrdGreaterThanEqualOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void FOrdGreaterThanEqualOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult FOrdGreaterThanEqualOp::verify() {
  if (failed(FOrdGreaterThanEqualOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FOrdGreaterThanEqualOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FOrdGreaterThanOp definitions
//===----------------------------------------------------------------------===//

FOrdGreaterThanOpAdaptor::FOrdGreaterThanOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FOrdGreaterThanOpAdaptor::FOrdGreaterThanOpAdaptor(FOrdGreaterThanOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FOrdGreaterThanOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FOrdGreaterThanOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FOrdGreaterThanOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FOrdGreaterThanOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FOrdGreaterThanOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FOrdGreaterThanOp::getOperationName() {
  return "spv.FOrdGreaterThan";
}

std::pair<unsigned, unsigned> FOrdGreaterThanOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FOrdGreaterThanOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FOrdGreaterThanOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FOrdGreaterThanOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FOrdGreaterThanOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FOrdGreaterThanOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FOrdGreaterThanOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FOrdGreaterThanOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FOrdGreaterThanOp::result() {
  return *getODSResults(0).begin();
}

void FOrdGreaterThanOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FOrdGreaterThanOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FOrdGreaterThanOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult FOrdGreaterThanOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void FOrdGreaterThanOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult FOrdGreaterThanOp::verify() {
  if (failed(FOrdGreaterThanOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FOrdGreaterThanOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FOrdLessThanEqualOp definitions
//===----------------------------------------------------------------------===//

FOrdLessThanEqualOpAdaptor::FOrdLessThanEqualOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FOrdLessThanEqualOpAdaptor::FOrdLessThanEqualOpAdaptor(FOrdLessThanEqualOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FOrdLessThanEqualOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FOrdLessThanEqualOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FOrdLessThanEqualOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FOrdLessThanEqualOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FOrdLessThanEqualOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FOrdLessThanEqualOp::getOperationName() {
  return "spv.FOrdLessThanEqual";
}

std::pair<unsigned, unsigned> FOrdLessThanEqualOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FOrdLessThanEqualOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FOrdLessThanEqualOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FOrdLessThanEqualOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FOrdLessThanEqualOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FOrdLessThanEqualOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FOrdLessThanEqualOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FOrdLessThanEqualOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FOrdLessThanEqualOp::result() {
  return *getODSResults(0).begin();
}

void FOrdLessThanEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FOrdLessThanEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FOrdLessThanEqualOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult FOrdLessThanEqualOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void FOrdLessThanEqualOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult FOrdLessThanEqualOp::verify() {
  if (failed(FOrdLessThanEqualOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FOrdLessThanEqualOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FOrdLessThanOp definitions
//===----------------------------------------------------------------------===//

FOrdLessThanOpAdaptor::FOrdLessThanOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FOrdLessThanOpAdaptor::FOrdLessThanOpAdaptor(FOrdLessThanOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FOrdLessThanOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FOrdLessThanOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FOrdLessThanOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FOrdLessThanOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FOrdLessThanOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FOrdLessThanOp::getOperationName() {
  return "spv.FOrdLessThan";
}

std::pair<unsigned, unsigned> FOrdLessThanOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FOrdLessThanOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FOrdLessThanOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FOrdLessThanOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FOrdLessThanOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FOrdLessThanOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FOrdLessThanOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FOrdLessThanOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FOrdLessThanOp::result() {
  return *getODSResults(0).begin();
}

void FOrdLessThanOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FOrdLessThanOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FOrdLessThanOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult FOrdLessThanOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void FOrdLessThanOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult FOrdLessThanOp::verify() {
  if (failed(FOrdLessThanOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FOrdLessThanOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FOrdNotEqualOp definitions
//===----------------------------------------------------------------------===//

FOrdNotEqualOpAdaptor::FOrdNotEqualOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FOrdNotEqualOpAdaptor::FOrdNotEqualOpAdaptor(FOrdNotEqualOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FOrdNotEqualOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FOrdNotEqualOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FOrdNotEqualOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FOrdNotEqualOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FOrdNotEqualOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FOrdNotEqualOp::getOperationName() {
  return "spv.FOrdNotEqual";
}

std::pair<unsigned, unsigned> FOrdNotEqualOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FOrdNotEqualOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FOrdNotEqualOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FOrdNotEqualOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FOrdNotEqualOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FOrdNotEqualOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FOrdNotEqualOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FOrdNotEqualOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FOrdNotEqualOp::result() {
  return *getODSResults(0).begin();
}

void FOrdNotEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FOrdNotEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FOrdNotEqualOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult FOrdNotEqualOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void FOrdNotEqualOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult FOrdNotEqualOp::verify() {
  if (failed(FOrdNotEqualOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FOrdNotEqualOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FRemOp definitions
//===----------------------------------------------------------------------===//

FRemOpAdaptor::FRemOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FRemOpAdaptor::FRemOpAdaptor(FRemOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FRemOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FRemOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FRemOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FRemOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FRemOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FRemOp::getOperationName() {
  return "spv.FRem";
}

std::pair<unsigned, unsigned> FRemOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FRemOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FRemOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FRemOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FRemOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FRemOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FRemOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FRemOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FRemOp::result() {
  return *getODSResults(0).begin();
}

void FRemOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FRemOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FRemOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void FRemOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes({operand1.getType()});

}

void FRemOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult FRemOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void FRemOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult FRemOp::verify() {
  if (failed(FRemOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FRemOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FSubOp definitions
//===----------------------------------------------------------------------===//

FSubOpAdaptor::FSubOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FSubOpAdaptor::FSubOpAdaptor(FSubOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FSubOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FSubOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FSubOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FSubOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FSubOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FSubOp::getOperationName() {
  return "spv.FSub";
}

std::pair<unsigned, unsigned> FSubOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FSubOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FSubOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FSubOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FSubOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FSubOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FSubOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FSubOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FSubOp::result() {
  return *getODSResults(0).begin();
}

void FSubOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FSubOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FSubOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void FSubOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes({operand1.getType()});

}

void FSubOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult FSubOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void FSubOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult FSubOp::verify() {
  if (failed(FSubOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF16())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF32())) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isF64())))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4 or Cooperative Matrix of 16/32/64-bit float values, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FSubOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FUnordEqualOp definitions
//===----------------------------------------------------------------------===//

FUnordEqualOpAdaptor::FUnordEqualOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FUnordEqualOpAdaptor::FUnordEqualOpAdaptor(FUnordEqualOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FUnordEqualOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FUnordEqualOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FUnordEqualOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FUnordEqualOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FUnordEqualOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FUnordEqualOp::getOperationName() {
  return "spv.FUnordEqual";
}

std::pair<unsigned, unsigned> FUnordEqualOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FUnordEqualOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FUnordEqualOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FUnordEqualOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FUnordEqualOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FUnordEqualOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FUnordEqualOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FUnordEqualOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FUnordEqualOp::result() {
  return *getODSResults(0).begin();
}

void FUnordEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FUnordEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FUnordEqualOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult FUnordEqualOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void FUnordEqualOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult FUnordEqualOp::verify() {
  if (failed(FUnordEqualOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FUnordEqualOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FUnordGreaterThanEqualOp definitions
//===----------------------------------------------------------------------===//

FUnordGreaterThanEqualOpAdaptor::FUnordGreaterThanEqualOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FUnordGreaterThanEqualOpAdaptor::FUnordGreaterThanEqualOpAdaptor(FUnordGreaterThanEqualOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FUnordGreaterThanEqualOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FUnordGreaterThanEqualOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FUnordGreaterThanEqualOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FUnordGreaterThanEqualOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FUnordGreaterThanEqualOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FUnordGreaterThanEqualOp::getOperationName() {
  return "spv.FUnordGreaterThanEqual";
}

std::pair<unsigned, unsigned> FUnordGreaterThanEqualOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FUnordGreaterThanEqualOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FUnordGreaterThanEqualOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FUnordGreaterThanEqualOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FUnordGreaterThanEqualOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FUnordGreaterThanEqualOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FUnordGreaterThanEqualOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FUnordGreaterThanEqualOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FUnordGreaterThanEqualOp::result() {
  return *getODSResults(0).begin();
}

void FUnordGreaterThanEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FUnordGreaterThanEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FUnordGreaterThanEqualOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult FUnordGreaterThanEqualOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void FUnordGreaterThanEqualOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult FUnordGreaterThanEqualOp::verify() {
  if (failed(FUnordGreaterThanEqualOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FUnordGreaterThanEqualOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FUnordGreaterThanOp definitions
//===----------------------------------------------------------------------===//

FUnordGreaterThanOpAdaptor::FUnordGreaterThanOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FUnordGreaterThanOpAdaptor::FUnordGreaterThanOpAdaptor(FUnordGreaterThanOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FUnordGreaterThanOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FUnordGreaterThanOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FUnordGreaterThanOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FUnordGreaterThanOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FUnordGreaterThanOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FUnordGreaterThanOp::getOperationName() {
  return "spv.FUnordGreaterThan";
}

std::pair<unsigned, unsigned> FUnordGreaterThanOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FUnordGreaterThanOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FUnordGreaterThanOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FUnordGreaterThanOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FUnordGreaterThanOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FUnordGreaterThanOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FUnordGreaterThanOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FUnordGreaterThanOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FUnordGreaterThanOp::result() {
  return *getODSResults(0).begin();
}

void FUnordGreaterThanOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FUnordGreaterThanOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FUnordGreaterThanOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult FUnordGreaterThanOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void FUnordGreaterThanOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult FUnordGreaterThanOp::verify() {
  if (failed(FUnordGreaterThanOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FUnordGreaterThanOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FUnordLessThanEqualOp definitions
//===----------------------------------------------------------------------===//

FUnordLessThanEqualOpAdaptor::FUnordLessThanEqualOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FUnordLessThanEqualOpAdaptor::FUnordLessThanEqualOpAdaptor(FUnordLessThanEqualOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FUnordLessThanEqualOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FUnordLessThanEqualOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FUnordLessThanEqualOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FUnordLessThanEqualOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FUnordLessThanEqualOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FUnordLessThanEqualOp::getOperationName() {
  return "spv.FUnordLessThanEqual";
}

std::pair<unsigned, unsigned> FUnordLessThanEqualOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FUnordLessThanEqualOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FUnordLessThanEqualOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FUnordLessThanEqualOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FUnordLessThanEqualOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FUnordLessThanEqualOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FUnordLessThanEqualOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FUnordLessThanEqualOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FUnordLessThanEqualOp::result() {
  return *getODSResults(0).begin();
}

void FUnordLessThanEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FUnordLessThanEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FUnordLessThanEqualOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult FUnordLessThanEqualOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void FUnordLessThanEqualOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult FUnordLessThanEqualOp::verify() {
  if (failed(FUnordLessThanEqualOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FUnordLessThanEqualOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FUnordLessThanOp definitions
//===----------------------------------------------------------------------===//

FUnordLessThanOpAdaptor::FUnordLessThanOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FUnordLessThanOpAdaptor::FUnordLessThanOpAdaptor(FUnordLessThanOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FUnordLessThanOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FUnordLessThanOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FUnordLessThanOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FUnordLessThanOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FUnordLessThanOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FUnordLessThanOp::getOperationName() {
  return "spv.FUnordLessThan";
}

std::pair<unsigned, unsigned> FUnordLessThanOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FUnordLessThanOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FUnordLessThanOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FUnordLessThanOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FUnordLessThanOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FUnordLessThanOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FUnordLessThanOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FUnordLessThanOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FUnordLessThanOp::result() {
  return *getODSResults(0).begin();
}

void FUnordLessThanOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FUnordLessThanOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FUnordLessThanOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult FUnordLessThanOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void FUnordLessThanOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult FUnordLessThanOp::verify() {
  if (failed(FUnordLessThanOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FUnordLessThanOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FUnordNotEqualOp definitions
//===----------------------------------------------------------------------===//

FUnordNotEqualOpAdaptor::FUnordNotEqualOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FUnordNotEqualOpAdaptor::FUnordNotEqualOpAdaptor(FUnordNotEqualOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FUnordNotEqualOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FUnordNotEqualOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value FUnordNotEqualOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value FUnordNotEqualOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult FUnordNotEqualOpAdaptor::verify(Location loc) {
  return success();
}

StringRef FUnordNotEqualOp::getOperationName() {
  return "spv.FUnordNotEqual";
}

std::pair<unsigned, unsigned> FUnordNotEqualOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FUnordNotEqualOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value FUnordNotEqualOp::operand1() {
  return *getODSOperands(0).begin();
}

Value FUnordNotEqualOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange FUnordNotEqualOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange FUnordNotEqualOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FUnordNotEqualOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FUnordNotEqualOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FUnordNotEqualOp::result() {
  return *getODSResults(0).begin();
}

void FUnordNotEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void FUnordNotEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FUnordNotEqualOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult FUnordNotEqualOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void FUnordNotEqualOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult FUnordNotEqualOp::verify() {
  if (failed(FUnordNotEqualOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void FUnordNotEqualOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::FuncOp definitions
//===----------------------------------------------------------------------===//

FuncOpAdaptor::FuncOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FuncOpAdaptor::FuncOpAdaptor(FuncOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FuncOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange FuncOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

TypeAttr FuncOpAdaptor::type() {
  assert(odsAttrs && "no attributes when constructing adapter");
  TypeAttr attr = odsAttrs.get("type").cast<TypeAttr>();
  return attr;
}

StringAttr FuncOpAdaptor::sym_name() {
  assert(odsAttrs && "no attributes when constructing adapter");
  StringAttr attr = odsAttrs.get("sym_name").cast<StringAttr>();
  return attr;
}

IntegerAttr FuncOpAdaptor::function_control() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("function_control").cast<IntegerAttr>();
  return attr;
}

LogicalResult FuncOpAdaptor::verify(Location loc) {
  {
  auto tblgen_type = odsAttrs.get("type");
  if (!tblgen_type) return emitError(loc, "'spv.func' op ""requires attribute 'type'");
    if (!(((tblgen_type.isa<TypeAttr>())) && ((tblgen_type.cast<TypeAttr>().getValue().isa<Type>())))) return emitError(loc, "'spv.func' op ""attribute 'type' failed to satisfy constraint: any type attribute");
  }
  {
  auto tblgen_sym_name = odsAttrs.get("sym_name");
  if (!tblgen_sym_name) return emitError(loc, "'spv.func' op ""requires attribute 'sym_name'");
    if (!((tblgen_sym_name.isa<StringAttr>()))) return emitError(loc, "'spv.func' op ""attribute 'sym_name' failed to satisfy constraint: string attribute");
  }
  {
  auto tblgen_function_control = odsAttrs.get("function_control");
  if (!tblgen_function_control) return emitError(loc, "'spv.func' op ""requires attribute 'function_control'");
    if (!((((tblgen_function_control.isa<IntegerAttr>())) && ((tblgen_function_control.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeFunctionControl(tblgen_function_control.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.func' op ""attribute 'function_control' failed to satisfy constraint: valid SPIR-V FunctionControl");
  }
  return success();
}

StringRef FuncOp::getOperationName() {
  return "spv.func";
}

std::pair<unsigned, unsigned> FuncOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range FuncOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> FuncOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range FuncOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Region &FuncOp::body() {
  return this->getOperation()->getRegion(0);
}

TypeAttr FuncOp::typeAttr() {
  return this->getAttr("type").cast<TypeAttr>();
}

Type FuncOp::type() {
  auto attr = typeAttr();
  return attr.getValue().cast<Type>();
}

StringAttr FuncOp::sym_nameAttr() {
  return this->getAttr("sym_name").cast<StringAttr>();
}

StringRef FuncOp::sym_name() {
  auto attr = sym_nameAttr();
  return attr.getValue();
}

IntegerAttr FuncOp::function_controlAttr() {
  return this->getAttr("function_control").cast<IntegerAttr>();
}

::mlir::spirv::FunctionControl FuncOp::function_control() {
  auto attr = function_controlAttr();
  return static_cast<::mlir::spirv::FunctionControl>(attr.getInt());
}

void FuncOp::typeAttr(TypeAttr attr) {
  this->getOperation()->setAttr("type", attr);
}

void FuncOp::sym_nameAttr(StringAttr attr) {
  this->getOperation()->setAttr("sym_name", attr);
}

void FuncOp::function_controlAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("function_control", attr);
}



void FuncOp::build(OpBuilder &odsBuilder, OperationState &odsState, TypeAttr type, StringAttr sym_name, IntegerAttr function_control) {
  odsState.addAttribute("type", type);
  odsState.addAttribute("sym_name", sym_name);
  odsState.addAttribute("function_control", function_control);
  (void)odsState.addRegion();
}

void FuncOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, TypeAttr type, StringAttr sym_name, IntegerAttr function_control) {
  odsState.addAttribute("type", type);
  odsState.addAttribute("sym_name", sym_name);
  odsState.addAttribute("function_control", function_control);
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FuncOp::build(OpBuilder &odsBuilder, OperationState &odsState, TypeAttr type, StringRef sym_name, ::mlir::spirv::FunctionControl function_control) {
  odsState.addAttribute("type", type);
  odsState.addAttribute("sym_name", odsBuilder.getStringAttr(sym_name));
  odsState.addAttribute("function_control", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(function_control)));
  (void)odsState.addRegion();
}

void FuncOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, TypeAttr type, StringRef sym_name, ::mlir::spirv::FunctionControl function_control) {
  odsState.addAttribute("type", type);
  odsState.addAttribute("sym_name", odsBuilder.getStringAttr(sym_name));
  odsState.addAttribute("function_control", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(function_control)));
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FuncOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult FuncOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseFuncOp(parser, result);
}

void FuncOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult FuncOp::verify() {
  if (failed(FuncOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
  }
  if (!((isDirectInModuleLikeOp((*this->getOperation()).getParentOp()))))
    return emitOpError("failed to verify that op must appear in a module-like op's block");
{
    unsigned index = 0; (void)index;
    for (Region &region : MutableArrayRef<Region>(this->getOperation()->getRegion(0))) {
      (void)region;
      if (!((true))) {
        return emitOpError("region #") << index << " ('body') failed to verify constraint: any region";
      }
      ++index;
    }
  }
  return success();
}














//===----------------------------------------------------------------------===//
// spirv::FunctionCallOp definitions
//===----------------------------------------------------------------------===//

FunctionCallOpAdaptor::FunctionCallOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

FunctionCallOpAdaptor::FunctionCallOpAdaptor(FunctionCallOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> FunctionCallOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

ValueRange FunctionCallOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

ValueRange FunctionCallOpAdaptor::arguments() {
  return getODSOperands(0);
}

FlatSymbolRefAttr FunctionCallOpAdaptor::callee() {
  assert(odsAttrs && "no attributes when constructing adapter");
  FlatSymbolRefAttr attr = odsAttrs.get("callee").cast<FlatSymbolRefAttr>();
  return attr;
}

LogicalResult FunctionCallOpAdaptor::verify(Location loc) {
  {
  auto tblgen_callee = odsAttrs.get("callee");
  if (!tblgen_callee) return emitError(loc, "'spv.FunctionCall' op ""requires attribute 'callee'");
    if (!((tblgen_callee.isa<FlatSymbolRefAttr>()))) return emitError(loc, "'spv.FunctionCall' op ""attribute 'callee' failed to satisfy constraint: flat symbol reference attribute");
  }
  return success();
}

StringRef FunctionCallOp::getOperationName() {
  return "spv.FunctionCall";
}

std::pair<unsigned, unsigned> FunctionCallOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

Operation::operand_range FunctionCallOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Operation::operand_range FunctionCallOp::arguments() {
  return getODSOperands(0);
}

::mlir::MutableOperandRange FunctionCallOp::argumentsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> FunctionCallOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

Operation::result_range FunctionCallOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value FunctionCallOp::result() {
  auto results = getODSResults(0);
  return results.empty() ? Value() : *results.begin();
}

FlatSymbolRefAttr FunctionCallOp::calleeAttr() {
  return this->getAttr("callee").cast<FlatSymbolRefAttr>();
}

StringRef FunctionCallOp::callee() {
  auto attr = calleeAttr();
  return attr.getValue();
}

void FunctionCallOp::calleeAttr(FlatSymbolRefAttr attr) {
  this->getOperation()->setAttr("callee", attr);
}

void FunctionCallOp::build(OpBuilder &odsBuilder, OperationState &odsState, /*optional*/Type result, FlatSymbolRefAttr callee, ValueRange arguments) {
  odsState.addOperands(arguments);
  odsState.addAttribute("callee", callee);
  if (result)
    odsState.addTypes(result);
}

void FunctionCallOp::build(OpBuilder &odsBuilder, OperationState &odsState, /*optional*/Type result, StringRef callee, ValueRange arguments) {
  odsState.addOperands(arguments);
  odsState.addAttribute("callee", odsBuilder.getSymbolRefAttr(callee));
  if (result)
    odsState.addTypes(result);
}

void FunctionCallOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes(resultTypes);
}

LogicalResult FunctionCallOp::verify() {
  if (failed(FunctionCallOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isa<NoneType>())) || ((v.getType().isSignlessInteger(1))) || (((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || (((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::PointerType>())) || ((v.getType().isa<::mlir::spirv::ArrayType>())) || ((v.getType().isa<::mlir::spirv::RuntimeArrayType>())) || ((v.getType().isa<::mlir::spirv::StructType>())) || ((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) || ((v.getType().isa<::mlir::spirv::MatrixType>())))) {
        return emitOpError("operand #") << index << " must be void or bool or 8/16/32/64-bit integer or 16/32/64-bit float or vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V pointer type or any SPIR-V array type or any SPIR-V runtime array type or any SPIR-V struct type or any SPIR-V cooperative matrix type or any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    if (valueGroup0.size() > 1)
      return emitOpError("result group starting at #") << index << " requires 0 or 1 element, but found " << valueGroup0.size();
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isa<NoneType>())) || ((v.getType().isSignlessInteger(1))) || (((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || (((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::PointerType>())) || ((v.getType().isa<::mlir::spirv::ArrayType>())) || ((v.getType().isa<::mlir::spirv::RuntimeArrayType>())) || ((v.getType().isa<::mlir::spirv::StructType>())) || ((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) || ((v.getType().isa<::mlir::spirv::MatrixType>())))) {
        return emitOpError("result #") << index << " must be void or bool or 8/16/32/64-bit integer or 16/32/64-bit float or vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V pointer type or any SPIR-V array type or any SPIR-V runtime array type or any SPIR-V struct type or any SPIR-V cooperative matrix type or any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  if (!((isNestedInFunctionLikeOp((*this->getOperation()).getParentOp()))))
    return emitOpError("failed to verify that op must appear in a function-like op's block");
  return ::verify(*this);
}













ParseResult FunctionCallOp::parse(OpAsmParser &parser, OperationState &result) {
  SmallVector<OpAsmParser::OperandType, 4> argumentsOperands;
  llvm::SMLoc argumentsOperandsLoc = parser.getCurrentLocation();
  (void)argumentsOperandsLoc;
  ArrayRef<Type> argumentsTypes;
  ArrayRef<Type> allResultTypes;

  FlatSymbolRefAttr calleeAttr;
  if (parser.parseAttribute(calleeAttr, parser.getBuilder().getType<NoneType>(), "callee", result.attributes))
    return failure();
  if (parser.parseLParen())
    return failure();

  if (parser.parseOperandList(argumentsOperands))
    return failure();
  if (parser.parseRParen())
    return failure();
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  if (parser.parseColon())
    return failure();

  FunctionType arguments__allResult_functionType;
  if (parser.parseType(arguments__allResult_functionType))
    return failure();
  argumentsTypes = arguments__allResult_functionType.getInputs();
  allResultTypes = arguments__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(argumentsOperands, argumentsTypes, argumentsOperandsLoc, result.operands))
    return failure();
  return success();
}

void FunctionCallOp::print(OpAsmPrinter &p) {
  p << "spv.FunctionCall";
  p << " ";
  p.printAttributeWithoutType(calleeAttr());
  p << "(";
  p << arguments();
  p << ")";
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{"callee"});
  p << " " << ":";
  p << " ";
  p.printFunctionalType(arguments().getTypes(), getOperation()->getResultTypes());
}


//===----------------------------------------------------------------------===//
// spirv::GLSLCeilOp definitions
//===----------------------------------------------------------------------===//

GLSLCeilOpAdaptor::GLSLCeilOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLCeilOpAdaptor::GLSLCeilOpAdaptor(GLSLCeilOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLCeilOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLCeilOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLCeilOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult GLSLCeilOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLCeilOp::getOperationName() {
  return "spv.GLSL.Ceil";
}

std::pair<unsigned, unsigned> GLSLCeilOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLCeilOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLCeilOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange GLSLCeilOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLCeilOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLCeilOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLCeilOp::result() {
  return *getODSResults(0).begin();
}

void GLSLCeilOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void GLSLCeilOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLCeilOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLCeilOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseUnaryOp(parser, result);
}

void GLSLCeilOp::print(OpAsmPrinter &p) {
  return printUnaryOp(getOperation(), p);
}

LogicalResult GLSLCeilOp::verify() {
  if (failed(GLSLCeilOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLCeilOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GLSLCosOp definitions
//===----------------------------------------------------------------------===//

GLSLCosOpAdaptor::GLSLCosOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLCosOpAdaptor::GLSLCosOpAdaptor(GLSLCosOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLCosOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLCosOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLCosOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult GLSLCosOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLCosOp::getOperationName() {
  return "spv.GLSL.Cos";
}

std::pair<unsigned, unsigned> GLSLCosOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLCosOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLCosOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange GLSLCosOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLCosOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLCosOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLCosOp::result() {
  return *getODSResults(0).begin();
}

void GLSLCosOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void GLSLCosOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLCosOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLCosOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseUnaryOp(parser, result);
}

void GLSLCosOp::print(OpAsmPrinter &p) {
  return printUnaryOp(getOperation(), p);
}

LogicalResult GLSLCosOp::verify() {
  if (failed(GLSLCosOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32-bit float or vector of 16/32-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32-bit float or vector of 16/32-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLCosOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GLSLExpOp definitions
//===----------------------------------------------------------------------===//

GLSLExpOpAdaptor::GLSLExpOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLExpOpAdaptor::GLSLExpOpAdaptor(GLSLExpOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLExpOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLExpOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLExpOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult GLSLExpOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLExpOp::getOperationName() {
  return "spv.GLSL.Exp";
}

std::pair<unsigned, unsigned> GLSLExpOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLExpOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLExpOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange GLSLExpOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLExpOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLExpOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLExpOp::result() {
  return *getODSResults(0).begin();
}

void GLSLExpOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void GLSLExpOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLExpOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLExpOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseUnaryOp(parser, result);
}

void GLSLExpOp::print(OpAsmPrinter &p) {
  return printUnaryOp(getOperation(), p);
}

LogicalResult GLSLExpOp::verify() {
  if (failed(GLSLExpOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32-bit float or vector of 16/32-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32-bit float or vector of 16/32-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLExpOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GLSLFAbsOp definitions
//===----------------------------------------------------------------------===//

GLSLFAbsOpAdaptor::GLSLFAbsOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLFAbsOpAdaptor::GLSLFAbsOpAdaptor(GLSLFAbsOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLFAbsOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLFAbsOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLFAbsOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult GLSLFAbsOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLFAbsOp::getOperationName() {
  return "spv.GLSL.FAbs";
}

std::pair<unsigned, unsigned> GLSLFAbsOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLFAbsOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLFAbsOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange GLSLFAbsOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLFAbsOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLFAbsOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLFAbsOp::result() {
  return *getODSResults(0).begin();
}

void GLSLFAbsOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void GLSLFAbsOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLFAbsOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLFAbsOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseUnaryOp(parser, result);
}

void GLSLFAbsOp::print(OpAsmPrinter &p) {
  return printUnaryOp(getOperation(), p);
}

LogicalResult GLSLFAbsOp::verify() {
  if (failed(GLSLFAbsOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLFAbsOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GLSLFMaxOp definitions
//===----------------------------------------------------------------------===//

GLSLFMaxOpAdaptor::GLSLFMaxOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLFMaxOpAdaptor::GLSLFMaxOpAdaptor(GLSLFMaxOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLFMaxOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLFMaxOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLFMaxOpAdaptor::lhs() {
  return *getODSOperands(0).begin();
}

Value GLSLFMaxOpAdaptor::rhs() {
  return *getODSOperands(1).begin();
}

LogicalResult GLSLFMaxOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLFMaxOp::getOperationName() {
  return "spv.GLSL.FMax";
}

std::pair<unsigned, unsigned> GLSLFMaxOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLFMaxOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLFMaxOp::lhs() {
  return *getODSOperands(0).begin();
}

Value GLSLFMaxOp::rhs() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange GLSLFMaxOp::lhsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange GLSLFMaxOp::rhsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLFMaxOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLFMaxOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLFMaxOp::result() {
  return *getODSResults(0).begin();
}

void GLSLFMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value lhs, Value rhs) {
  odsState.addOperands(lhs);
  odsState.addOperands(rhs);
  odsState.addTypes(result);
}

void GLSLFMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value lhs, Value rhs) {
  odsState.addOperands(lhs);
  odsState.addOperands(rhs);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLFMaxOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLFMaxOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void GLSLFMaxOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult GLSLFMaxOp::verify() {
  if (failed(GLSLFMaxOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLFMaxOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GLSLFMinOp definitions
//===----------------------------------------------------------------------===//

GLSLFMinOpAdaptor::GLSLFMinOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLFMinOpAdaptor::GLSLFMinOpAdaptor(GLSLFMinOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLFMinOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLFMinOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLFMinOpAdaptor::lhs() {
  return *getODSOperands(0).begin();
}

Value GLSLFMinOpAdaptor::rhs() {
  return *getODSOperands(1).begin();
}

LogicalResult GLSLFMinOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLFMinOp::getOperationName() {
  return "spv.GLSL.FMin";
}

std::pair<unsigned, unsigned> GLSLFMinOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLFMinOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLFMinOp::lhs() {
  return *getODSOperands(0).begin();
}

Value GLSLFMinOp::rhs() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange GLSLFMinOp::lhsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange GLSLFMinOp::rhsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLFMinOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLFMinOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLFMinOp::result() {
  return *getODSResults(0).begin();
}

void GLSLFMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value lhs, Value rhs) {
  odsState.addOperands(lhs);
  odsState.addOperands(rhs);
  odsState.addTypes(result);
}

void GLSLFMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value lhs, Value rhs) {
  odsState.addOperands(lhs);
  odsState.addOperands(rhs);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLFMinOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLFMinOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void GLSLFMinOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult GLSLFMinOp::verify() {
  if (failed(GLSLFMinOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLFMinOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GLSLFSignOp definitions
//===----------------------------------------------------------------------===//

GLSLFSignOpAdaptor::GLSLFSignOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLFSignOpAdaptor::GLSLFSignOpAdaptor(GLSLFSignOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLFSignOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLFSignOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLFSignOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult GLSLFSignOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLFSignOp::getOperationName() {
  return "spv.GLSL.FSign";
}

std::pair<unsigned, unsigned> GLSLFSignOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLFSignOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLFSignOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange GLSLFSignOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLFSignOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLFSignOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLFSignOp::result() {
  return *getODSResults(0).begin();
}

void GLSLFSignOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void GLSLFSignOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLFSignOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLFSignOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseUnaryOp(parser, result);
}

void GLSLFSignOp::print(OpAsmPrinter &p) {
  return printUnaryOp(getOperation(), p);
}

LogicalResult GLSLFSignOp::verify() {
  if (failed(GLSLFSignOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLFSignOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GLSLFloorOp definitions
//===----------------------------------------------------------------------===//

GLSLFloorOpAdaptor::GLSLFloorOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLFloorOpAdaptor::GLSLFloorOpAdaptor(GLSLFloorOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLFloorOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLFloorOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLFloorOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult GLSLFloorOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLFloorOp::getOperationName() {
  return "spv.GLSL.Floor";
}

std::pair<unsigned, unsigned> GLSLFloorOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLFloorOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLFloorOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange GLSLFloorOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLFloorOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLFloorOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLFloorOp::result() {
  return *getODSResults(0).begin();
}

void GLSLFloorOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void GLSLFloorOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLFloorOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLFloorOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseUnaryOp(parser, result);
}

void GLSLFloorOp::print(OpAsmPrinter &p) {
  return printUnaryOp(getOperation(), p);
}

LogicalResult GLSLFloorOp::verify() {
  if (failed(GLSLFloorOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLFloorOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GLSLInverseSqrtOp definitions
//===----------------------------------------------------------------------===//

GLSLInverseSqrtOpAdaptor::GLSLInverseSqrtOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLInverseSqrtOpAdaptor::GLSLInverseSqrtOpAdaptor(GLSLInverseSqrtOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLInverseSqrtOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLInverseSqrtOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLInverseSqrtOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult GLSLInverseSqrtOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLInverseSqrtOp::getOperationName() {
  return "spv.GLSL.InverseSqrt";
}

std::pair<unsigned, unsigned> GLSLInverseSqrtOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLInverseSqrtOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLInverseSqrtOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange GLSLInverseSqrtOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLInverseSqrtOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLInverseSqrtOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLInverseSqrtOp::result() {
  return *getODSResults(0).begin();
}

void GLSLInverseSqrtOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void GLSLInverseSqrtOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLInverseSqrtOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLInverseSqrtOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseUnaryOp(parser, result);
}

void GLSLInverseSqrtOp::print(OpAsmPrinter &p) {
  return printUnaryOp(getOperation(), p);
}

LogicalResult GLSLInverseSqrtOp::verify() {
  if (failed(GLSLInverseSqrtOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLInverseSqrtOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GLSLLogOp definitions
//===----------------------------------------------------------------------===//

GLSLLogOpAdaptor::GLSLLogOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLLogOpAdaptor::GLSLLogOpAdaptor(GLSLLogOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLLogOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLLogOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLLogOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult GLSLLogOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLLogOp::getOperationName() {
  return "spv.GLSL.Log";
}

std::pair<unsigned, unsigned> GLSLLogOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLLogOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLLogOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange GLSLLogOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLLogOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLLogOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLLogOp::result() {
  return *getODSResults(0).begin();
}

void GLSLLogOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void GLSLLogOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLLogOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLLogOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseUnaryOp(parser, result);
}

void GLSLLogOp::print(OpAsmPrinter &p) {
  return printUnaryOp(getOperation(), p);
}

LogicalResult GLSLLogOp::verify() {
  if (failed(GLSLLogOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32-bit float or vector of 16/32-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32-bit float or vector of 16/32-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLLogOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GLSLSAbsOp definitions
//===----------------------------------------------------------------------===//

GLSLSAbsOpAdaptor::GLSLSAbsOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLSAbsOpAdaptor::GLSLSAbsOpAdaptor(GLSLSAbsOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLSAbsOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLSAbsOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLSAbsOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult GLSLSAbsOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLSAbsOp::getOperationName() {
  return "spv.GLSL.SAbs";
}

std::pair<unsigned, unsigned> GLSLSAbsOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLSAbsOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLSAbsOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange GLSLSAbsOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLSAbsOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLSAbsOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLSAbsOp::result() {
  return *getODSResults(0).begin();
}

void GLSLSAbsOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void GLSLSAbsOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLSAbsOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLSAbsOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseUnaryOp(parser, result);
}

void GLSLSAbsOp::print(OpAsmPrinter &p) {
  return printUnaryOp(getOperation(), p);
}

LogicalResult GLSLSAbsOp::verify() {
  if (failed(GLSLSAbsOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLSAbsOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GLSLSMaxOp definitions
//===----------------------------------------------------------------------===//

GLSLSMaxOpAdaptor::GLSLSMaxOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLSMaxOpAdaptor::GLSLSMaxOpAdaptor(GLSLSMaxOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLSMaxOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLSMaxOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLSMaxOpAdaptor::lhs() {
  return *getODSOperands(0).begin();
}

Value GLSLSMaxOpAdaptor::rhs() {
  return *getODSOperands(1).begin();
}

LogicalResult GLSLSMaxOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLSMaxOp::getOperationName() {
  return "spv.GLSL.SMax";
}

std::pair<unsigned, unsigned> GLSLSMaxOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLSMaxOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLSMaxOp::lhs() {
  return *getODSOperands(0).begin();
}

Value GLSLSMaxOp::rhs() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange GLSLSMaxOp::lhsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange GLSLSMaxOp::rhsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLSMaxOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLSMaxOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLSMaxOp::result() {
  return *getODSResults(0).begin();
}

void GLSLSMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value lhs, Value rhs) {
  odsState.addOperands(lhs);
  odsState.addOperands(rhs);
  odsState.addTypes(result);
}

void GLSLSMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value lhs, Value rhs) {
  odsState.addOperands(lhs);
  odsState.addOperands(rhs);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLSMaxOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLSMaxOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void GLSLSMaxOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult GLSLSMaxOp::verify() {
  if (failed(GLSLSMaxOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLSMaxOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GLSLSMinOp definitions
//===----------------------------------------------------------------------===//

GLSLSMinOpAdaptor::GLSLSMinOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLSMinOpAdaptor::GLSLSMinOpAdaptor(GLSLSMinOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLSMinOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLSMinOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLSMinOpAdaptor::lhs() {
  return *getODSOperands(0).begin();
}

Value GLSLSMinOpAdaptor::rhs() {
  return *getODSOperands(1).begin();
}

LogicalResult GLSLSMinOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLSMinOp::getOperationName() {
  return "spv.GLSL.SMin";
}

std::pair<unsigned, unsigned> GLSLSMinOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLSMinOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLSMinOp::lhs() {
  return *getODSOperands(0).begin();
}

Value GLSLSMinOp::rhs() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange GLSLSMinOp::lhsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange GLSLSMinOp::rhsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLSMinOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLSMinOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLSMinOp::result() {
  return *getODSResults(0).begin();
}

void GLSLSMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value lhs, Value rhs) {
  odsState.addOperands(lhs);
  odsState.addOperands(rhs);
  odsState.addTypes(result);
}

void GLSLSMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value lhs, Value rhs) {
  odsState.addOperands(lhs);
  odsState.addOperands(rhs);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLSMinOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLSMinOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void GLSLSMinOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult GLSLSMinOp::verify() {
  if (failed(GLSLSMinOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLSMinOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GLSLSSignOp definitions
//===----------------------------------------------------------------------===//

GLSLSSignOpAdaptor::GLSLSSignOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLSSignOpAdaptor::GLSLSSignOpAdaptor(GLSLSSignOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLSSignOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLSSignOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLSSignOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult GLSLSSignOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLSSignOp::getOperationName() {
  return "spv.GLSL.SSign";
}

std::pair<unsigned, unsigned> GLSLSSignOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLSSignOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLSSignOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange GLSLSSignOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLSSignOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLSSignOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLSSignOp::result() {
  return *getODSResults(0).begin();
}

void GLSLSSignOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void GLSLSSignOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLSSignOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLSSignOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseUnaryOp(parser, result);
}

void GLSLSSignOp::print(OpAsmPrinter &p) {
  return printUnaryOp(getOperation(), p);
}

LogicalResult GLSLSSignOp::verify() {
  if (failed(GLSLSSignOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLSSignOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GLSLSinOp definitions
//===----------------------------------------------------------------------===//

GLSLSinOpAdaptor::GLSLSinOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLSinOpAdaptor::GLSLSinOpAdaptor(GLSLSinOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLSinOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLSinOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLSinOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult GLSLSinOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLSinOp::getOperationName() {
  return "spv.GLSL.Sin";
}

std::pair<unsigned, unsigned> GLSLSinOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLSinOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLSinOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange GLSLSinOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLSinOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLSinOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLSinOp::result() {
  return *getODSResults(0).begin();
}

void GLSLSinOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void GLSLSinOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLSinOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLSinOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseUnaryOp(parser, result);
}

void GLSLSinOp::print(OpAsmPrinter &p) {
  return printUnaryOp(getOperation(), p);
}

LogicalResult GLSLSinOp::verify() {
  if (failed(GLSLSinOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32-bit float or vector of 16/32-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32-bit float or vector of 16/32-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLSinOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GLSLSqrtOp definitions
//===----------------------------------------------------------------------===//

GLSLSqrtOpAdaptor::GLSLSqrtOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLSqrtOpAdaptor::GLSLSqrtOpAdaptor(GLSLSqrtOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLSqrtOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLSqrtOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLSqrtOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult GLSLSqrtOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLSqrtOp::getOperationName() {
  return "spv.GLSL.Sqrt";
}

std::pair<unsigned, unsigned> GLSLSqrtOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLSqrtOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLSqrtOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange GLSLSqrtOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLSqrtOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLSqrtOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLSqrtOp::result() {
  return *getODSResults(0).begin();
}

void GLSLSqrtOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void GLSLSqrtOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLSqrtOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLSqrtOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseUnaryOp(parser, result);
}

void GLSLSqrtOp::print(OpAsmPrinter &p) {
  return printUnaryOp(getOperation(), p);
}

LogicalResult GLSLSqrtOp::verify() {
  if (failed(GLSLSqrtOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLSqrtOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GLSLTanOp definitions
//===----------------------------------------------------------------------===//

GLSLTanOpAdaptor::GLSLTanOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLTanOpAdaptor::GLSLTanOpAdaptor(GLSLTanOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLTanOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLTanOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLTanOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult GLSLTanOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLTanOp::getOperationName() {
  return "spv.GLSL.Tan";
}

std::pair<unsigned, unsigned> GLSLTanOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLTanOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLTanOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange GLSLTanOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLTanOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLTanOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLTanOp::result() {
  return *getODSResults(0).begin();
}

void GLSLTanOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void GLSLTanOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLTanOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLTanOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseUnaryOp(parser, result);
}

void GLSLTanOp::print(OpAsmPrinter &p) {
  return printUnaryOp(getOperation(), p);
}

LogicalResult GLSLTanOp::verify() {
  if (failed(GLSLTanOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32-bit float or vector of 16/32-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32-bit float or vector of 16/32-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLTanOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GLSLTanhOp definitions
//===----------------------------------------------------------------------===//

GLSLTanhOpAdaptor::GLSLTanhOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GLSLTanhOpAdaptor::GLSLTanhOpAdaptor(GLSLTanhOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GLSLTanhOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GLSLTanhOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GLSLTanhOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult GLSLTanhOpAdaptor::verify(Location loc) {
  return success();
}

StringRef GLSLTanhOp::getOperationName() {
  return "spv.GLSL.Tanh";
}

std::pair<unsigned, unsigned> GLSLTanhOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GLSLTanhOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GLSLTanhOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange GLSLTanhOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GLSLTanhOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GLSLTanhOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GLSLTanhOp::result() {
  return *getODSResults(0).begin();
}

void GLSLTanhOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void GLSLTanhOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GLSLTanhOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GLSLTanhOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseUnaryOp(parser, result);
}

void GLSLTanhOp::print(OpAsmPrinter &p) {
  return printUnaryOp(getOperation(), p);
}

LogicalResult GLSLTanhOp::verify() {
  if (failed(GLSLTanhOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32-bit float or vector of 16/32-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32-bit float or vector of 16/32-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void GLSLTanhOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::GlobalVariableOp definitions
//===----------------------------------------------------------------------===//

GlobalVariableOpAdaptor::GlobalVariableOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GlobalVariableOpAdaptor::GlobalVariableOpAdaptor(GlobalVariableOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GlobalVariableOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GlobalVariableOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

TypeAttr GlobalVariableOpAdaptor::type() {
  assert(odsAttrs && "no attributes when constructing adapter");
  TypeAttr attr = odsAttrs.get("type").cast<TypeAttr>();
  return attr;
}

StringAttr GlobalVariableOpAdaptor::sym_name() {
  assert(odsAttrs && "no attributes when constructing adapter");
  StringAttr attr = odsAttrs.get("sym_name").cast<StringAttr>();
  return attr;
}

FlatSymbolRefAttr GlobalVariableOpAdaptor::initializer() {
  assert(odsAttrs && "no attributes when constructing adapter");
  FlatSymbolRefAttr attr = odsAttrs.get("initializer").dyn_cast_or_null<FlatSymbolRefAttr>();
  return attr;
}

LogicalResult GlobalVariableOpAdaptor::verify(Location loc) {
  {
  auto tblgen_type = odsAttrs.get("type");
  if (!tblgen_type) return emitError(loc, "'spv.globalVariable' op ""requires attribute 'type'");
    if (!(((tblgen_type.isa<TypeAttr>())) && ((tblgen_type.cast<TypeAttr>().getValue().isa<Type>())))) return emitError(loc, "'spv.globalVariable' op ""attribute 'type' failed to satisfy constraint: any type attribute");
  }
  {
  auto tblgen_sym_name = odsAttrs.get("sym_name");
  if (!tblgen_sym_name) return emitError(loc, "'spv.globalVariable' op ""requires attribute 'sym_name'");
    if (!((tblgen_sym_name.isa<StringAttr>()))) return emitError(loc, "'spv.globalVariable' op ""attribute 'sym_name' failed to satisfy constraint: string attribute");
  }
  {
  auto tblgen_initializer = odsAttrs.get("initializer");
  if (tblgen_initializer) {
    if (!((tblgen_initializer.isa<FlatSymbolRefAttr>()))) return emitError(loc, "'spv.globalVariable' op ""attribute 'initializer' failed to satisfy constraint: flat symbol reference attribute");
  }
  }
  return success();
}

StringRef GlobalVariableOp::getOperationName() {
  return "spv.globalVariable";
}

std::pair<unsigned, unsigned> GlobalVariableOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GlobalVariableOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> GlobalVariableOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GlobalVariableOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

TypeAttr GlobalVariableOp::typeAttr() {
  return this->getAttr("type").cast<TypeAttr>();
}

Type GlobalVariableOp::type() {
  auto attr = typeAttr();
  return attr.getValue().cast<Type>();
}

StringAttr GlobalVariableOp::sym_nameAttr() {
  return this->getAttr("sym_name").cast<StringAttr>();
}

StringRef GlobalVariableOp::sym_name() {
  auto attr = sym_nameAttr();
  return attr.getValue();
}

FlatSymbolRefAttr GlobalVariableOp::initializerAttr() {
  return this->getAttr("initializer").dyn_cast_or_null<FlatSymbolRefAttr>();
}

Optional< StringRef > GlobalVariableOp::initializer() {
  auto attr = initializerAttr();
  return attr ? Optional< StringRef >(attr.getValue()) : (llvm::None);
}

void GlobalVariableOp::typeAttr(TypeAttr attr) {
  this->getOperation()->setAttr("type", attr);
}

void GlobalVariableOp::sym_nameAttr(StringAttr attr) {
  this->getOperation()->setAttr("sym_name", attr);
}

void GlobalVariableOp::initializerAttr(FlatSymbolRefAttr attr) {
  this->getOperation()->setAttr("initializer", attr);
}

void GlobalVariableOp::build(OpBuilder &builder, OperationState &state, TypeAttr type, ArrayRef<NamedAttribute> namedAttrs) {
      state.addAttribute("type", type);
      state.addAttributes(namedAttrs);
    
}





void GlobalVariableOp::build(OpBuilder &odsBuilder, OperationState &odsState, TypeAttr type, StringAttr sym_name, /*optional*/FlatSymbolRefAttr initializer) {
  odsState.addAttribute("type", type);
  odsState.addAttribute("sym_name", sym_name);
  if (initializer) {
  odsState.addAttribute("initializer", initializer);
  }
}

void GlobalVariableOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, TypeAttr type, StringAttr sym_name, /*optional*/FlatSymbolRefAttr initializer) {
  odsState.addAttribute("type", type);
  odsState.addAttribute("sym_name", sym_name);
  if (initializer) {
  odsState.addAttribute("initializer", initializer);
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GlobalVariableOp::build(OpBuilder &odsBuilder, OperationState &odsState, TypeAttr type, StringRef sym_name, /*optional*/FlatSymbolRefAttr initializer) {
  odsState.addAttribute("type", type);
  odsState.addAttribute("sym_name", odsBuilder.getStringAttr(sym_name));
  if (initializer) {
  odsState.addAttribute("initializer", initializer);
  }
}

void GlobalVariableOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, TypeAttr type, StringRef sym_name, /*optional*/FlatSymbolRefAttr initializer) {
  odsState.addAttribute("type", type);
  odsState.addAttribute("sym_name", odsBuilder.getStringAttr(sym_name));
  if (initializer) {
  odsState.addAttribute("initializer", initializer);
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GlobalVariableOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GlobalVariableOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseGlobalVariableOp(parser, result);
}

void GlobalVariableOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult GlobalVariableOp::verify() {
  if (failed(GlobalVariableOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
  }
  if (!((isDirectInModuleLikeOp((*this->getOperation()).getParentOp()))))
    return emitOpError("failed to verify that op must appear in a module-like op's block");
  return ::verify(*this);
}










//===----------------------------------------------------------------------===//
// spirv::GroupNonUniformBallotOp definitions
//===----------------------------------------------------------------------===//

GroupNonUniformBallotOpAdaptor::GroupNonUniformBallotOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GroupNonUniformBallotOpAdaptor::GroupNonUniformBallotOpAdaptor(GroupNonUniformBallotOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GroupNonUniformBallotOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GroupNonUniformBallotOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformBallotOpAdaptor::predicate() {
  return *getODSOperands(0).begin();
}

IntegerAttr GroupNonUniformBallotOpAdaptor::execution_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("execution_scope").cast<IntegerAttr>();
  return attr;
}

LogicalResult GroupNonUniformBallotOpAdaptor::verify(Location loc) {
  {
  auto tblgen_execution_scope = odsAttrs.get("execution_scope");
  if (!tblgen_execution_scope) return emitError(loc, "'spv.GroupNonUniformBallot' op ""requires attribute 'execution_scope'");
    if (!((((tblgen_execution_scope.isa<IntegerAttr>())) && ((tblgen_execution_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_execution_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformBallot' op ""attribute 'execution_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  return success();
}

StringRef GroupNonUniformBallotOp::getOperationName() {
  return "spv.GroupNonUniformBallot";
}

std::pair<unsigned, unsigned> GroupNonUniformBallotOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GroupNonUniformBallotOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformBallotOp::predicate() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange GroupNonUniformBallotOp::predicateMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GroupNonUniformBallotOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GroupNonUniformBallotOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformBallotOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr GroupNonUniformBallotOp::execution_scopeAttr() {
  return this->getAttr("execution_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope GroupNonUniformBallotOp::execution_scope() {
  auto attr = execution_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

void GroupNonUniformBallotOp::execution_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("execution_scope", attr);
}

void GroupNonUniformBallotOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, IntegerAttr execution_scope, Value predicate) {
  odsState.addOperands(predicate);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addTypes(result);
}

void GroupNonUniformBallotOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, IntegerAttr execution_scope, Value predicate) {
  odsState.addOperands(predicate);
  odsState.addAttribute("execution_scope", execution_scope);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformBallotOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, ::mlir::spirv::Scope execution_scope, Value predicate) {
  odsState.addOperands(predicate);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addTypes(result);
}

void GroupNonUniformBallotOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ::mlir::spirv::Scope execution_scope, Value predicate) {
  odsState.addOperands(predicate);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformBallotOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LogicalResult GroupNonUniformBallotOp::verify() {
  if (failed(GroupNonUniformBallotOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isSignlessInteger(1)))) {
        return emitOpError("operand #") << index << " must be bool, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isa<VectorType>())) && ((((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isUnsignedInteger(8)))) || (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isUnsignedInteger(16)))) || (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isUnsignedInteger(32)))) || (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(64))) || ((v.getType().cast<ShapedType>().getElementType().isUnsignedInteger(64)))))) && (((v.getType().isa<VectorType>())) && ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) {
        return emitOpError("result #") << index << " must be vector of 8/16/32/64-bit signless/unsigned integer values of length 4, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verify(*this);
}









ParseResult GroupNonUniformBallotOp::parse(OpAsmParser &parser, OperationState &result) {
  OpAsmParser::OperandType predicateRawOperands[1];
  ArrayRef<OpAsmParser::OperandType> predicateOperands(predicateRawOperands);  llvm::SMLoc predicateOperandsLoc = parser.getCurrentLocation();
  (void)predicateOperandsLoc;
  Type resultRawTypes[1];
  ArrayRef<Type> resultTypes(resultRawTypes);

  {
    StringAttr attrVal;
    NamedAttrList attrStorage;
    auto loc = parser.getCurrentLocation();
    if (parser.parseAttribute(attrVal, parser.getBuilder().getNoneType(),
                              "execution_scope", attrStorage))
      return failure();

    auto attrOptional = ::mlir::spirv::symbolizeScope(attrVal.getValue());
    if (!attrOptional)
      return parser.emitError(loc, "invalid ")
             << "execution_scope attribute specification: " << attrVal;

    result.addAttribute("execution_scope", parser.getBuilder().getI32IntegerAttr(static_cast<int32_t>(attrOptional.getValue())));
  }

  if (parser.parseOperand(predicateRawOperands[0]))
    return failure();
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  if (parser.parseColon())
    return failure();

  if (parser.parseType(resultRawTypes[0]))
    return failure();
  Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  result.addTypes(resultTypes);
  if (parser.resolveOperands(predicateOperands, odsBuildableType0, result.operands))
    return failure();
  return success();
}

void GroupNonUniformBallotOp::print(OpAsmPrinter &p) {
  p << "spv.GroupNonUniformBallot";
  p << " ";
  p << "\"" << stringifyScope(execution_scope()) << "\"";
  p << " ";
  p << predicate();
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{"execution_scope"});
  p << " " << ":";
  p << " ";
  p << ArrayRef<Type>(result().getType());
}


//===----------------------------------------------------------------------===//
// spirv::GroupNonUniformElectOp definitions
//===----------------------------------------------------------------------===//

GroupNonUniformElectOpAdaptor::GroupNonUniformElectOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GroupNonUniformElectOpAdaptor::GroupNonUniformElectOpAdaptor(GroupNonUniformElectOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GroupNonUniformElectOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange GroupNonUniformElectOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

IntegerAttr GroupNonUniformElectOpAdaptor::execution_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("execution_scope").cast<IntegerAttr>();
  return attr;
}

LogicalResult GroupNonUniformElectOpAdaptor::verify(Location loc) {
  {
  auto tblgen_execution_scope = odsAttrs.get("execution_scope");
  if (!tblgen_execution_scope) return emitError(loc, "'spv.GroupNonUniformElect' op ""requires attribute 'execution_scope'");
    if (!((((tblgen_execution_scope.isa<IntegerAttr>())) && ((tblgen_execution_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_execution_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformElect' op ""attribute 'execution_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  return success();
}

StringRef GroupNonUniformElectOp::getOperationName() {
  return "spv.GroupNonUniformElect";
}

std::pair<unsigned, unsigned> GroupNonUniformElectOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range GroupNonUniformElectOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> GroupNonUniformElectOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GroupNonUniformElectOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformElectOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr GroupNonUniformElectOp::execution_scopeAttr() {
  return this->getAttr("execution_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope GroupNonUniformElectOp::execution_scope() {
  auto attr = execution_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

void GroupNonUniformElectOp::execution_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("execution_scope", attr);
}



void GroupNonUniformElectOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, IntegerAttr execution_scope) {
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addTypes(result);
}

void GroupNonUniformElectOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, IntegerAttr execution_scope) {
  odsState.addAttribute("execution_scope", execution_scope);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformElectOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, ::mlir::spirv::Scope execution_scope) {
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addTypes(result);
}

void GroupNonUniformElectOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ::mlir::spirv::Scope execution_scope) {
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformElectOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LogicalResult GroupNonUniformElectOp::verify() {
  if (failed(GroupNonUniformElectOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isSignlessInteger(1)))) {
        return emitOpError("result #") << index << " must be bool, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verify(*this);
}









ParseResult GroupNonUniformElectOp::parse(OpAsmParser &parser, OperationState &result) {
  Type resultRawTypes[1];
  ArrayRef<Type> resultTypes(resultRawTypes);

  {
    StringAttr attrVal;
    NamedAttrList attrStorage;
    auto loc = parser.getCurrentLocation();
    if (parser.parseAttribute(attrVal, parser.getBuilder().getNoneType(),
                              "execution_scope", attrStorage))
      return failure();

    auto attrOptional = ::mlir::spirv::symbolizeScope(attrVal.getValue());
    if (!attrOptional)
      return parser.emitError(loc, "invalid ")
             << "execution_scope attribute specification: " << attrVal;

    result.addAttribute("execution_scope", parser.getBuilder().getI32IntegerAttr(static_cast<int32_t>(attrOptional.getValue())));
  }
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  if (parser.parseColon())
    return failure();

  if (parser.parseType(resultRawTypes[0]))
    return failure();
  result.addTypes(resultTypes);
  return success();
}

void GroupNonUniformElectOp::print(OpAsmPrinter &p) {
  p << "spv.GroupNonUniformElect";
  p << " ";
  p << "\"" << stringifyScope(execution_scope()) << "\"";
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{"execution_scope"});
  p << " " << ":";
  p << " ";
  p << ArrayRef<Type>(result().getType());
}


//===----------------------------------------------------------------------===//
// spirv::GroupNonUniformFAddOp definitions
//===----------------------------------------------------------------------===//

GroupNonUniformFAddOpAdaptor::GroupNonUniformFAddOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GroupNonUniformFAddOpAdaptor::GroupNonUniformFAddOpAdaptor(GroupNonUniformFAddOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GroupNonUniformFAddOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

ValueRange GroupNonUniformFAddOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformFAddOpAdaptor::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformFAddOpAdaptor::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

IntegerAttr GroupNonUniformFAddOpAdaptor::execution_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("execution_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr GroupNonUniformFAddOpAdaptor::group_operation() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("group_operation").cast<IntegerAttr>();
  return attr;
}

LogicalResult GroupNonUniformFAddOpAdaptor::verify(Location loc) {
  {
  auto tblgen_execution_scope = odsAttrs.get("execution_scope");
  if (!tblgen_execution_scope) return emitError(loc, "'spv.GroupNonUniformFAdd' op ""requires attribute 'execution_scope'");
    if (!((((tblgen_execution_scope.isa<IntegerAttr>())) && ((tblgen_execution_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_execution_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformFAdd' op ""attribute 'execution_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_group_operation = odsAttrs.get("group_operation");
  if (!tblgen_group_operation) return emitError(loc, "'spv.GroupNonUniformFAdd' op ""requires attribute 'group_operation'");
    if (!((((tblgen_group_operation.isa<IntegerAttr>())) && ((tblgen_group_operation.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeGroupOperation(tblgen_group_operation.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformFAdd' op ""attribute 'group_operation' failed to satisfy constraint: valid SPIR-V GroupOperation");
  }
  return success();
}

StringRef GroupNonUniformFAddOp::getOperationName() {
  return "spv.GroupNonUniformFAdd";
}

std::pair<unsigned, unsigned> GroupNonUniformFAddOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

Operation::operand_range GroupNonUniformFAddOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformFAddOp::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformFAddOp::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

::mlir::MutableOperandRange GroupNonUniformFAddOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange GroupNonUniformFAddOp::cluster_sizeMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GroupNonUniformFAddOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GroupNonUniformFAddOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformFAddOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr GroupNonUniformFAddOp::execution_scopeAttr() {
  return this->getAttr("execution_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope GroupNonUniformFAddOp::execution_scope() {
  auto attr = execution_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr GroupNonUniformFAddOp::group_operationAttr() {
  return this->getAttr("group_operation").cast<IntegerAttr>();
}

::mlir::spirv::GroupOperation GroupNonUniformFAddOp::group_operation() {
  auto attr = group_operationAttr();
  return static_cast<::mlir::spirv::GroupOperation>(attr.getInt());
}

void GroupNonUniformFAddOp::execution_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("execution_scope", attr);
}

void GroupNonUniformFAddOp::group_operationAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("group_operation", attr);
}

void GroupNonUniformFAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  odsState.addTypes(result);
}

void GroupNonUniformFAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformFAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  odsState.addTypes(result);
}

void GroupNonUniformFAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformFAddOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GroupNonUniformFAddOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseGroupNonUniformArithmeticOp(parser, result);
}

void GroupNonUniformFAddOp::print(OpAsmPrinter &p) {
  printGroupNonUniformArithmeticOp(getOperation(), p);
}

LogicalResult GroupNonUniformFAddOp::verify() {
  if (failed(GroupNonUniformFAddOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    if (valueGroup1.size() > 1)
      return emitOpError("operand group starting at #") << index << " requires 0 or 1 element, but found " << valueGroup1.size();
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyGroupNonUniformArithmeticOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::GroupNonUniformFMaxOp definitions
//===----------------------------------------------------------------------===//

GroupNonUniformFMaxOpAdaptor::GroupNonUniformFMaxOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GroupNonUniformFMaxOpAdaptor::GroupNonUniformFMaxOpAdaptor(GroupNonUniformFMaxOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GroupNonUniformFMaxOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

ValueRange GroupNonUniformFMaxOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformFMaxOpAdaptor::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformFMaxOpAdaptor::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

IntegerAttr GroupNonUniformFMaxOpAdaptor::execution_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("execution_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr GroupNonUniformFMaxOpAdaptor::group_operation() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("group_operation").cast<IntegerAttr>();
  return attr;
}

LogicalResult GroupNonUniformFMaxOpAdaptor::verify(Location loc) {
  {
  auto tblgen_execution_scope = odsAttrs.get("execution_scope");
  if (!tblgen_execution_scope) return emitError(loc, "'spv.GroupNonUniformFMax' op ""requires attribute 'execution_scope'");
    if (!((((tblgen_execution_scope.isa<IntegerAttr>())) && ((tblgen_execution_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_execution_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformFMax' op ""attribute 'execution_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_group_operation = odsAttrs.get("group_operation");
  if (!tblgen_group_operation) return emitError(loc, "'spv.GroupNonUniformFMax' op ""requires attribute 'group_operation'");
    if (!((((tblgen_group_operation.isa<IntegerAttr>())) && ((tblgen_group_operation.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeGroupOperation(tblgen_group_operation.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformFMax' op ""attribute 'group_operation' failed to satisfy constraint: valid SPIR-V GroupOperation");
  }
  return success();
}

StringRef GroupNonUniformFMaxOp::getOperationName() {
  return "spv.GroupNonUniformFMax";
}

std::pair<unsigned, unsigned> GroupNonUniformFMaxOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

Operation::operand_range GroupNonUniformFMaxOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformFMaxOp::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformFMaxOp::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

::mlir::MutableOperandRange GroupNonUniformFMaxOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange GroupNonUniformFMaxOp::cluster_sizeMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GroupNonUniformFMaxOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GroupNonUniformFMaxOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformFMaxOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr GroupNonUniformFMaxOp::execution_scopeAttr() {
  return this->getAttr("execution_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope GroupNonUniformFMaxOp::execution_scope() {
  auto attr = execution_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr GroupNonUniformFMaxOp::group_operationAttr() {
  return this->getAttr("group_operation").cast<IntegerAttr>();
}

::mlir::spirv::GroupOperation GroupNonUniformFMaxOp::group_operation() {
  auto attr = group_operationAttr();
  return static_cast<::mlir::spirv::GroupOperation>(attr.getInt());
}

void GroupNonUniformFMaxOp::execution_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("execution_scope", attr);
}

void GroupNonUniformFMaxOp::group_operationAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("group_operation", attr);
}

void GroupNonUniformFMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  odsState.addTypes(result);
}

void GroupNonUniformFMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformFMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  odsState.addTypes(result);
}

void GroupNonUniformFMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformFMaxOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GroupNonUniformFMaxOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseGroupNonUniformArithmeticOp(parser, result);
}

void GroupNonUniformFMaxOp::print(OpAsmPrinter &p) {
  printGroupNonUniformArithmeticOp(getOperation(), p);
}

LogicalResult GroupNonUniformFMaxOp::verify() {
  if (failed(GroupNonUniformFMaxOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    if (valueGroup1.size() > 1)
      return emitOpError("operand group starting at #") << index << " requires 0 or 1 element, but found " << valueGroup1.size();
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyGroupNonUniformArithmeticOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::GroupNonUniformFMinOp definitions
//===----------------------------------------------------------------------===//

GroupNonUniformFMinOpAdaptor::GroupNonUniformFMinOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GroupNonUniformFMinOpAdaptor::GroupNonUniformFMinOpAdaptor(GroupNonUniformFMinOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GroupNonUniformFMinOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

ValueRange GroupNonUniformFMinOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformFMinOpAdaptor::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformFMinOpAdaptor::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

IntegerAttr GroupNonUniformFMinOpAdaptor::execution_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("execution_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr GroupNonUniformFMinOpAdaptor::group_operation() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("group_operation").cast<IntegerAttr>();
  return attr;
}

LogicalResult GroupNonUniformFMinOpAdaptor::verify(Location loc) {
  {
  auto tblgen_execution_scope = odsAttrs.get("execution_scope");
  if (!tblgen_execution_scope) return emitError(loc, "'spv.GroupNonUniformFMin' op ""requires attribute 'execution_scope'");
    if (!((((tblgen_execution_scope.isa<IntegerAttr>())) && ((tblgen_execution_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_execution_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformFMin' op ""attribute 'execution_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_group_operation = odsAttrs.get("group_operation");
  if (!tblgen_group_operation) return emitError(loc, "'spv.GroupNonUniformFMin' op ""requires attribute 'group_operation'");
    if (!((((tblgen_group_operation.isa<IntegerAttr>())) && ((tblgen_group_operation.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeGroupOperation(tblgen_group_operation.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformFMin' op ""attribute 'group_operation' failed to satisfy constraint: valid SPIR-V GroupOperation");
  }
  return success();
}

StringRef GroupNonUniformFMinOp::getOperationName() {
  return "spv.GroupNonUniformFMin";
}

std::pair<unsigned, unsigned> GroupNonUniformFMinOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

Operation::operand_range GroupNonUniformFMinOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformFMinOp::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformFMinOp::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

::mlir::MutableOperandRange GroupNonUniformFMinOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange GroupNonUniformFMinOp::cluster_sizeMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GroupNonUniformFMinOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GroupNonUniformFMinOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformFMinOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr GroupNonUniformFMinOp::execution_scopeAttr() {
  return this->getAttr("execution_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope GroupNonUniformFMinOp::execution_scope() {
  auto attr = execution_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr GroupNonUniformFMinOp::group_operationAttr() {
  return this->getAttr("group_operation").cast<IntegerAttr>();
}

::mlir::spirv::GroupOperation GroupNonUniformFMinOp::group_operation() {
  auto attr = group_operationAttr();
  return static_cast<::mlir::spirv::GroupOperation>(attr.getInt());
}

void GroupNonUniformFMinOp::execution_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("execution_scope", attr);
}

void GroupNonUniformFMinOp::group_operationAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("group_operation", attr);
}

void GroupNonUniformFMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  odsState.addTypes(result);
}

void GroupNonUniformFMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformFMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  odsState.addTypes(result);
}

void GroupNonUniformFMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformFMinOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GroupNonUniformFMinOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseGroupNonUniformArithmeticOp(parser, result);
}

void GroupNonUniformFMinOp::print(OpAsmPrinter &p) {
  printGroupNonUniformArithmeticOp(getOperation(), p);
}

LogicalResult GroupNonUniformFMinOp::verify() {
  if (failed(GroupNonUniformFMinOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    if (valueGroup1.size() > 1)
      return emitOpError("operand group starting at #") << index << " requires 0 or 1 element, but found " << valueGroup1.size();
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyGroupNonUniformArithmeticOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::GroupNonUniformFMulOp definitions
//===----------------------------------------------------------------------===//

GroupNonUniformFMulOpAdaptor::GroupNonUniformFMulOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GroupNonUniformFMulOpAdaptor::GroupNonUniformFMulOpAdaptor(GroupNonUniformFMulOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GroupNonUniformFMulOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

ValueRange GroupNonUniformFMulOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformFMulOpAdaptor::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformFMulOpAdaptor::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

IntegerAttr GroupNonUniformFMulOpAdaptor::execution_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("execution_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr GroupNonUniformFMulOpAdaptor::group_operation() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("group_operation").cast<IntegerAttr>();
  return attr;
}

LogicalResult GroupNonUniformFMulOpAdaptor::verify(Location loc) {
  {
  auto tblgen_execution_scope = odsAttrs.get("execution_scope");
  if (!tblgen_execution_scope) return emitError(loc, "'spv.GroupNonUniformFMul' op ""requires attribute 'execution_scope'");
    if (!((((tblgen_execution_scope.isa<IntegerAttr>())) && ((tblgen_execution_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_execution_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformFMul' op ""attribute 'execution_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_group_operation = odsAttrs.get("group_operation");
  if (!tblgen_group_operation) return emitError(loc, "'spv.GroupNonUniformFMul' op ""requires attribute 'group_operation'");
    if (!((((tblgen_group_operation.isa<IntegerAttr>())) && ((tblgen_group_operation.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeGroupOperation(tblgen_group_operation.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformFMul' op ""attribute 'group_operation' failed to satisfy constraint: valid SPIR-V GroupOperation");
  }
  return success();
}

StringRef GroupNonUniformFMulOp::getOperationName() {
  return "spv.GroupNonUniformFMul";
}

std::pair<unsigned, unsigned> GroupNonUniformFMulOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

Operation::operand_range GroupNonUniformFMulOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformFMulOp::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformFMulOp::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

::mlir::MutableOperandRange GroupNonUniformFMulOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange GroupNonUniformFMulOp::cluster_sizeMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GroupNonUniformFMulOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GroupNonUniformFMulOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformFMulOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr GroupNonUniformFMulOp::execution_scopeAttr() {
  return this->getAttr("execution_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope GroupNonUniformFMulOp::execution_scope() {
  auto attr = execution_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr GroupNonUniformFMulOp::group_operationAttr() {
  return this->getAttr("group_operation").cast<IntegerAttr>();
}

::mlir::spirv::GroupOperation GroupNonUniformFMulOp::group_operation() {
  auto attr = group_operationAttr();
  return static_cast<::mlir::spirv::GroupOperation>(attr.getInt());
}

void GroupNonUniformFMulOp::execution_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("execution_scope", attr);
}

void GroupNonUniformFMulOp::group_operationAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("group_operation", attr);
}

void GroupNonUniformFMulOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  odsState.addTypes(result);
}

void GroupNonUniformFMulOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformFMulOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  odsState.addTypes(result);
}

void GroupNonUniformFMulOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformFMulOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GroupNonUniformFMulOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseGroupNonUniformArithmeticOp(parser, result);
}

void GroupNonUniformFMulOp::print(OpAsmPrinter &p) {
  printGroupNonUniformArithmeticOp(getOperation(), p);
}

LogicalResult GroupNonUniformFMulOp::verify() {
  if (failed(GroupNonUniformFMulOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    if (valueGroup1.size() > 1)
      return emitOpError("operand group starting at #") << index << " requires 0 or 1 element, but found " << valueGroup1.size();
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64())))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 16/32/64-bit float or vector of 16/32/64-bit float values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyGroupNonUniformArithmeticOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::GroupNonUniformIAddOp definitions
//===----------------------------------------------------------------------===//

GroupNonUniformIAddOpAdaptor::GroupNonUniformIAddOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GroupNonUniformIAddOpAdaptor::GroupNonUniformIAddOpAdaptor(GroupNonUniformIAddOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GroupNonUniformIAddOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

ValueRange GroupNonUniformIAddOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformIAddOpAdaptor::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformIAddOpAdaptor::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

IntegerAttr GroupNonUniformIAddOpAdaptor::execution_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("execution_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr GroupNonUniformIAddOpAdaptor::group_operation() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("group_operation").cast<IntegerAttr>();
  return attr;
}

LogicalResult GroupNonUniformIAddOpAdaptor::verify(Location loc) {
  {
  auto tblgen_execution_scope = odsAttrs.get("execution_scope");
  if (!tblgen_execution_scope) return emitError(loc, "'spv.GroupNonUniformIAdd' op ""requires attribute 'execution_scope'");
    if (!((((tblgen_execution_scope.isa<IntegerAttr>())) && ((tblgen_execution_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_execution_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformIAdd' op ""attribute 'execution_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_group_operation = odsAttrs.get("group_operation");
  if (!tblgen_group_operation) return emitError(loc, "'spv.GroupNonUniformIAdd' op ""requires attribute 'group_operation'");
    if (!((((tblgen_group_operation.isa<IntegerAttr>())) && ((tblgen_group_operation.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeGroupOperation(tblgen_group_operation.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformIAdd' op ""attribute 'group_operation' failed to satisfy constraint: valid SPIR-V GroupOperation");
  }
  return success();
}

StringRef GroupNonUniformIAddOp::getOperationName() {
  return "spv.GroupNonUniformIAdd";
}

std::pair<unsigned, unsigned> GroupNonUniformIAddOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

Operation::operand_range GroupNonUniformIAddOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformIAddOp::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformIAddOp::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

::mlir::MutableOperandRange GroupNonUniformIAddOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange GroupNonUniformIAddOp::cluster_sizeMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GroupNonUniformIAddOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GroupNonUniformIAddOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformIAddOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr GroupNonUniformIAddOp::execution_scopeAttr() {
  return this->getAttr("execution_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope GroupNonUniformIAddOp::execution_scope() {
  auto attr = execution_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr GroupNonUniformIAddOp::group_operationAttr() {
  return this->getAttr("group_operation").cast<IntegerAttr>();
}

::mlir::spirv::GroupOperation GroupNonUniformIAddOp::group_operation() {
  auto attr = group_operationAttr();
  return static_cast<::mlir::spirv::GroupOperation>(attr.getInt());
}

void GroupNonUniformIAddOp::execution_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("execution_scope", attr);
}

void GroupNonUniformIAddOp::group_operationAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("group_operation", attr);
}

void GroupNonUniformIAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  odsState.addTypes(result);
}

void GroupNonUniformIAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformIAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  odsState.addTypes(result);
}

void GroupNonUniformIAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformIAddOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GroupNonUniformIAddOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseGroupNonUniformArithmeticOp(parser, result);
}

void GroupNonUniformIAddOp::print(OpAsmPrinter &p) {
  printGroupNonUniformArithmeticOp(getOperation(), p);
}

LogicalResult GroupNonUniformIAddOp::verify() {
  if (failed(GroupNonUniformIAddOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    if (valueGroup1.size() > 1)
      return emitOpError("operand group starting at #") << index << " requires 0 or 1 element, but found " << valueGroup1.size();
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyGroupNonUniformArithmeticOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::GroupNonUniformIMulOp definitions
//===----------------------------------------------------------------------===//

GroupNonUniformIMulOpAdaptor::GroupNonUniformIMulOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GroupNonUniformIMulOpAdaptor::GroupNonUniformIMulOpAdaptor(GroupNonUniformIMulOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GroupNonUniformIMulOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

ValueRange GroupNonUniformIMulOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformIMulOpAdaptor::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformIMulOpAdaptor::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

IntegerAttr GroupNonUniformIMulOpAdaptor::execution_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("execution_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr GroupNonUniformIMulOpAdaptor::group_operation() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("group_operation").cast<IntegerAttr>();
  return attr;
}

LogicalResult GroupNonUniformIMulOpAdaptor::verify(Location loc) {
  {
  auto tblgen_execution_scope = odsAttrs.get("execution_scope");
  if (!tblgen_execution_scope) return emitError(loc, "'spv.GroupNonUniformIMul' op ""requires attribute 'execution_scope'");
    if (!((((tblgen_execution_scope.isa<IntegerAttr>())) && ((tblgen_execution_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_execution_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformIMul' op ""attribute 'execution_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_group_operation = odsAttrs.get("group_operation");
  if (!tblgen_group_operation) return emitError(loc, "'spv.GroupNonUniformIMul' op ""requires attribute 'group_operation'");
    if (!((((tblgen_group_operation.isa<IntegerAttr>())) && ((tblgen_group_operation.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeGroupOperation(tblgen_group_operation.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformIMul' op ""attribute 'group_operation' failed to satisfy constraint: valid SPIR-V GroupOperation");
  }
  return success();
}

StringRef GroupNonUniformIMulOp::getOperationName() {
  return "spv.GroupNonUniformIMul";
}

std::pair<unsigned, unsigned> GroupNonUniformIMulOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

Operation::operand_range GroupNonUniformIMulOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformIMulOp::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformIMulOp::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

::mlir::MutableOperandRange GroupNonUniformIMulOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange GroupNonUniformIMulOp::cluster_sizeMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GroupNonUniformIMulOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GroupNonUniformIMulOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformIMulOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr GroupNonUniformIMulOp::execution_scopeAttr() {
  return this->getAttr("execution_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope GroupNonUniformIMulOp::execution_scope() {
  auto attr = execution_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr GroupNonUniformIMulOp::group_operationAttr() {
  return this->getAttr("group_operation").cast<IntegerAttr>();
}

::mlir::spirv::GroupOperation GroupNonUniformIMulOp::group_operation() {
  auto attr = group_operationAttr();
  return static_cast<::mlir::spirv::GroupOperation>(attr.getInt());
}

void GroupNonUniformIMulOp::execution_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("execution_scope", attr);
}

void GroupNonUniformIMulOp::group_operationAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("group_operation", attr);
}

void GroupNonUniformIMulOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  odsState.addTypes(result);
}

void GroupNonUniformIMulOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformIMulOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  odsState.addTypes(result);
}

void GroupNonUniformIMulOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformIMulOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GroupNonUniformIMulOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseGroupNonUniformArithmeticOp(parser, result);
}

void GroupNonUniformIMulOp::print(OpAsmPrinter &p) {
  printGroupNonUniformArithmeticOp(getOperation(), p);
}

LogicalResult GroupNonUniformIMulOp::verify() {
  if (failed(GroupNonUniformIMulOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    if (valueGroup1.size() > 1)
      return emitOpError("operand group starting at #") << index << " requires 0 or 1 element, but found " << valueGroup1.size();
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyGroupNonUniformArithmeticOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::GroupNonUniformSMaxOp definitions
//===----------------------------------------------------------------------===//

GroupNonUniformSMaxOpAdaptor::GroupNonUniformSMaxOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GroupNonUniformSMaxOpAdaptor::GroupNonUniformSMaxOpAdaptor(GroupNonUniformSMaxOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GroupNonUniformSMaxOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

ValueRange GroupNonUniformSMaxOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformSMaxOpAdaptor::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformSMaxOpAdaptor::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

IntegerAttr GroupNonUniformSMaxOpAdaptor::execution_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("execution_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr GroupNonUniformSMaxOpAdaptor::group_operation() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("group_operation").cast<IntegerAttr>();
  return attr;
}

LogicalResult GroupNonUniformSMaxOpAdaptor::verify(Location loc) {
  {
  auto tblgen_execution_scope = odsAttrs.get("execution_scope");
  if (!tblgen_execution_scope) return emitError(loc, "'spv.GroupNonUniformSMax' op ""requires attribute 'execution_scope'");
    if (!((((tblgen_execution_scope.isa<IntegerAttr>())) && ((tblgen_execution_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_execution_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformSMax' op ""attribute 'execution_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_group_operation = odsAttrs.get("group_operation");
  if (!tblgen_group_operation) return emitError(loc, "'spv.GroupNonUniformSMax' op ""requires attribute 'group_operation'");
    if (!((((tblgen_group_operation.isa<IntegerAttr>())) && ((tblgen_group_operation.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeGroupOperation(tblgen_group_operation.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformSMax' op ""attribute 'group_operation' failed to satisfy constraint: valid SPIR-V GroupOperation");
  }
  return success();
}

StringRef GroupNonUniformSMaxOp::getOperationName() {
  return "spv.GroupNonUniformSMax";
}

std::pair<unsigned, unsigned> GroupNonUniformSMaxOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

Operation::operand_range GroupNonUniformSMaxOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformSMaxOp::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformSMaxOp::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

::mlir::MutableOperandRange GroupNonUniformSMaxOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange GroupNonUniformSMaxOp::cluster_sizeMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GroupNonUniformSMaxOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GroupNonUniformSMaxOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformSMaxOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr GroupNonUniformSMaxOp::execution_scopeAttr() {
  return this->getAttr("execution_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope GroupNonUniformSMaxOp::execution_scope() {
  auto attr = execution_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr GroupNonUniformSMaxOp::group_operationAttr() {
  return this->getAttr("group_operation").cast<IntegerAttr>();
}

::mlir::spirv::GroupOperation GroupNonUniformSMaxOp::group_operation() {
  auto attr = group_operationAttr();
  return static_cast<::mlir::spirv::GroupOperation>(attr.getInt());
}

void GroupNonUniformSMaxOp::execution_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("execution_scope", attr);
}

void GroupNonUniformSMaxOp::group_operationAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("group_operation", attr);
}

void GroupNonUniformSMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  odsState.addTypes(result);
}

void GroupNonUniformSMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformSMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  odsState.addTypes(result);
}

void GroupNonUniformSMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformSMaxOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GroupNonUniformSMaxOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseGroupNonUniformArithmeticOp(parser, result);
}

void GroupNonUniformSMaxOp::print(OpAsmPrinter &p) {
  printGroupNonUniformArithmeticOp(getOperation(), p);
}

LogicalResult GroupNonUniformSMaxOp::verify() {
  if (failed(GroupNonUniformSMaxOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    if (valueGroup1.size() > 1)
      return emitOpError("operand group starting at #") << index << " requires 0 or 1 element, but found " << valueGroup1.size();
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyGroupNonUniformArithmeticOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::GroupNonUniformSMinOp definitions
//===----------------------------------------------------------------------===//

GroupNonUniformSMinOpAdaptor::GroupNonUniformSMinOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GroupNonUniformSMinOpAdaptor::GroupNonUniformSMinOpAdaptor(GroupNonUniformSMinOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GroupNonUniformSMinOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

ValueRange GroupNonUniformSMinOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformSMinOpAdaptor::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformSMinOpAdaptor::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

IntegerAttr GroupNonUniformSMinOpAdaptor::execution_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("execution_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr GroupNonUniformSMinOpAdaptor::group_operation() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("group_operation").cast<IntegerAttr>();
  return attr;
}

LogicalResult GroupNonUniformSMinOpAdaptor::verify(Location loc) {
  {
  auto tblgen_execution_scope = odsAttrs.get("execution_scope");
  if (!tblgen_execution_scope) return emitError(loc, "'spv.GroupNonUniformSMin' op ""requires attribute 'execution_scope'");
    if (!((((tblgen_execution_scope.isa<IntegerAttr>())) && ((tblgen_execution_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_execution_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformSMin' op ""attribute 'execution_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_group_operation = odsAttrs.get("group_operation");
  if (!tblgen_group_operation) return emitError(loc, "'spv.GroupNonUniformSMin' op ""requires attribute 'group_operation'");
    if (!((((tblgen_group_operation.isa<IntegerAttr>())) && ((tblgen_group_operation.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeGroupOperation(tblgen_group_operation.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformSMin' op ""attribute 'group_operation' failed to satisfy constraint: valid SPIR-V GroupOperation");
  }
  return success();
}

StringRef GroupNonUniformSMinOp::getOperationName() {
  return "spv.GroupNonUniformSMin";
}

std::pair<unsigned, unsigned> GroupNonUniformSMinOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

Operation::operand_range GroupNonUniformSMinOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformSMinOp::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformSMinOp::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

::mlir::MutableOperandRange GroupNonUniformSMinOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange GroupNonUniformSMinOp::cluster_sizeMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GroupNonUniformSMinOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GroupNonUniformSMinOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformSMinOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr GroupNonUniformSMinOp::execution_scopeAttr() {
  return this->getAttr("execution_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope GroupNonUniformSMinOp::execution_scope() {
  auto attr = execution_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr GroupNonUniformSMinOp::group_operationAttr() {
  return this->getAttr("group_operation").cast<IntegerAttr>();
}

::mlir::spirv::GroupOperation GroupNonUniformSMinOp::group_operation() {
  auto attr = group_operationAttr();
  return static_cast<::mlir::spirv::GroupOperation>(attr.getInt());
}

void GroupNonUniformSMinOp::execution_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("execution_scope", attr);
}

void GroupNonUniformSMinOp::group_operationAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("group_operation", attr);
}

void GroupNonUniformSMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  odsState.addTypes(result);
}

void GroupNonUniformSMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformSMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  odsState.addTypes(result);
}

void GroupNonUniformSMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformSMinOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GroupNonUniformSMinOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseGroupNonUniformArithmeticOp(parser, result);
}

void GroupNonUniformSMinOp::print(OpAsmPrinter &p) {
  printGroupNonUniformArithmeticOp(getOperation(), p);
}

LogicalResult GroupNonUniformSMinOp::verify() {
  if (failed(GroupNonUniformSMinOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    if (valueGroup1.size() > 1)
      return emitOpError("operand group starting at #") << index << " requires 0 or 1 element, but found " << valueGroup1.size();
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyGroupNonUniformArithmeticOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::GroupNonUniformUMaxOp definitions
//===----------------------------------------------------------------------===//

GroupNonUniformUMaxOpAdaptor::GroupNonUniformUMaxOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GroupNonUniformUMaxOpAdaptor::GroupNonUniformUMaxOpAdaptor(GroupNonUniformUMaxOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GroupNonUniformUMaxOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

ValueRange GroupNonUniformUMaxOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformUMaxOpAdaptor::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformUMaxOpAdaptor::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

IntegerAttr GroupNonUniformUMaxOpAdaptor::execution_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("execution_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr GroupNonUniformUMaxOpAdaptor::group_operation() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("group_operation").cast<IntegerAttr>();
  return attr;
}

LogicalResult GroupNonUniformUMaxOpAdaptor::verify(Location loc) {
  {
  auto tblgen_execution_scope = odsAttrs.get("execution_scope");
  if (!tblgen_execution_scope) return emitError(loc, "'spv.GroupNonUniformUMax' op ""requires attribute 'execution_scope'");
    if (!((((tblgen_execution_scope.isa<IntegerAttr>())) && ((tblgen_execution_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_execution_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformUMax' op ""attribute 'execution_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_group_operation = odsAttrs.get("group_operation");
  if (!tblgen_group_operation) return emitError(loc, "'spv.GroupNonUniformUMax' op ""requires attribute 'group_operation'");
    if (!((((tblgen_group_operation.isa<IntegerAttr>())) && ((tblgen_group_operation.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeGroupOperation(tblgen_group_operation.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformUMax' op ""attribute 'group_operation' failed to satisfy constraint: valid SPIR-V GroupOperation");
  }
  return success();
}

StringRef GroupNonUniformUMaxOp::getOperationName() {
  return "spv.GroupNonUniformUMax";
}

std::pair<unsigned, unsigned> GroupNonUniformUMaxOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

Operation::operand_range GroupNonUniformUMaxOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformUMaxOp::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformUMaxOp::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

::mlir::MutableOperandRange GroupNonUniformUMaxOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange GroupNonUniformUMaxOp::cluster_sizeMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GroupNonUniformUMaxOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GroupNonUniformUMaxOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformUMaxOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr GroupNonUniformUMaxOp::execution_scopeAttr() {
  return this->getAttr("execution_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope GroupNonUniformUMaxOp::execution_scope() {
  auto attr = execution_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr GroupNonUniformUMaxOp::group_operationAttr() {
  return this->getAttr("group_operation").cast<IntegerAttr>();
}

::mlir::spirv::GroupOperation GroupNonUniformUMaxOp::group_operation() {
  auto attr = group_operationAttr();
  return static_cast<::mlir::spirv::GroupOperation>(attr.getInt());
}

void GroupNonUniformUMaxOp::execution_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("execution_scope", attr);
}

void GroupNonUniformUMaxOp::group_operationAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("group_operation", attr);
}

void GroupNonUniformUMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  odsState.addTypes(result);
}

void GroupNonUniformUMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformUMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  odsState.addTypes(result);
}

void GroupNonUniformUMaxOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformUMaxOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GroupNonUniformUMaxOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseGroupNonUniformArithmeticOp(parser, result);
}

void GroupNonUniformUMaxOp::print(OpAsmPrinter &p) {
  printGroupNonUniformArithmeticOp(getOperation(), p);
}

LogicalResult GroupNonUniformUMaxOp::verify() {
  if (failed(GroupNonUniformUMaxOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    if (valueGroup1.size() > 1)
      return emitOpError("operand group starting at #") << index << " requires 0 or 1 element, but found " << valueGroup1.size();
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyGroupNonUniformArithmeticOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::GroupNonUniformUMinOp definitions
//===----------------------------------------------------------------------===//

GroupNonUniformUMinOpAdaptor::GroupNonUniformUMinOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

GroupNonUniformUMinOpAdaptor::GroupNonUniformUMinOpAdaptor(GroupNonUniformUMinOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> GroupNonUniformUMinOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

ValueRange GroupNonUniformUMinOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformUMinOpAdaptor::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformUMinOpAdaptor::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

IntegerAttr GroupNonUniformUMinOpAdaptor::execution_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("execution_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr GroupNonUniformUMinOpAdaptor::group_operation() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("group_operation").cast<IntegerAttr>();
  return attr;
}

LogicalResult GroupNonUniformUMinOpAdaptor::verify(Location loc) {
  {
  auto tblgen_execution_scope = odsAttrs.get("execution_scope");
  if (!tblgen_execution_scope) return emitError(loc, "'spv.GroupNonUniformUMin' op ""requires attribute 'execution_scope'");
    if (!((((tblgen_execution_scope.isa<IntegerAttr>())) && ((tblgen_execution_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_execution_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformUMin' op ""attribute 'execution_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_group_operation = odsAttrs.get("group_operation");
  if (!tblgen_group_operation) return emitError(loc, "'spv.GroupNonUniformUMin' op ""requires attribute 'group_operation'");
    if (!((((tblgen_group_operation.isa<IntegerAttr>())) && ((tblgen_group_operation.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeGroupOperation(tblgen_group_operation.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.GroupNonUniformUMin' op ""attribute 'group_operation' failed to satisfy constraint: valid SPIR-V GroupOperation");
  }
  return success();
}

StringRef GroupNonUniformUMinOp::getOperationName() {
  return "spv.GroupNonUniformUMin";
}

std::pair<unsigned, unsigned> GroupNonUniformUMinOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

Operation::operand_range GroupNonUniformUMinOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformUMinOp::value() {
  return *getODSOperands(0).begin();
}

Value GroupNonUniformUMinOp::cluster_size() {
  auto operands = getODSOperands(1);
  return operands.empty() ? Value() : *operands.begin();
}

::mlir::MutableOperandRange GroupNonUniformUMinOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange GroupNonUniformUMinOp::cluster_sizeMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> GroupNonUniformUMinOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range GroupNonUniformUMinOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value GroupNonUniformUMinOp::result() {
  return *getODSResults(0).begin();
}

IntegerAttr GroupNonUniformUMinOp::execution_scopeAttr() {
  return this->getAttr("execution_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope GroupNonUniformUMinOp::execution_scope() {
  auto attr = execution_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr GroupNonUniformUMinOp::group_operationAttr() {
  return this->getAttr("group_operation").cast<IntegerAttr>();
}

::mlir::spirv::GroupOperation GroupNonUniformUMinOp::group_operation() {
  auto attr = group_operationAttr();
  return static_cast<::mlir::spirv::GroupOperation>(attr.getInt());
}

void GroupNonUniformUMinOp::execution_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("execution_scope", attr);
}

void GroupNonUniformUMinOp::group_operationAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("group_operation", attr);
}

void GroupNonUniformUMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  odsState.addTypes(result);
}

void GroupNonUniformUMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, IntegerAttr execution_scope, IntegerAttr group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", execution_scope);
  odsState.addAttribute("group_operation", group_operation);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformUMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  odsState.addTypes(result);
}

void GroupNonUniformUMinOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ::mlir::spirv::Scope execution_scope, ::mlir::spirv::GroupOperation group_operation, Value value, /*optional*/Value cluster_size) {
  odsState.addOperands(value);
  if (cluster_size)
    odsState.addOperands(cluster_size);
  odsState.addAttribute("execution_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(execution_scope)));
  odsState.addAttribute("group_operation", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(group_operation)));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GroupNonUniformUMinOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult GroupNonUniformUMinOp::parse(OpAsmParser &parser, OperationState &result) {
  return parseGroupNonUniformArithmeticOp(parser, result);
}

void GroupNonUniformUMinOp::print(OpAsmPrinter &p) {
  printGroupNonUniformArithmeticOp(getOperation(), p);
}

LogicalResult GroupNonUniformUMinOp::verify() {
  if (failed(GroupNonUniformUMinOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    if (valueGroup1.size() > 1)
      return emitOpError("operand group starting at #") << index << " requires 0 or 1 element, but found " << valueGroup1.size();
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyGroupNonUniformArithmeticOp(getOperation());
}










//===----------------------------------------------------------------------===//
// spirv::IAddOp definitions
//===----------------------------------------------------------------------===//

IAddOpAdaptor::IAddOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

IAddOpAdaptor::IAddOpAdaptor(IAddOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> IAddOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange IAddOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value IAddOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value IAddOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult IAddOpAdaptor::verify(Location loc) {
  return success();
}

StringRef IAddOp::getOperationName() {
  return "spv.IAdd";
}

std::pair<unsigned, unsigned> IAddOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range IAddOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value IAddOp::operand1() {
  return *getODSOperands(0).begin();
}

Value IAddOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange IAddOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange IAddOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> IAddOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range IAddOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value IAddOp::result() {
  return *getODSResults(0).begin();
}

void IAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void IAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void IAddOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void IAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes({operand1.getType()});

}

void IAddOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult IAddOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void IAddOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult IAddOp::verify() {
  if (failed(IAddOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}











void IAddOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::IEqualOp definitions
//===----------------------------------------------------------------------===//

IEqualOpAdaptor::IEqualOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

IEqualOpAdaptor::IEqualOpAdaptor(IEqualOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> IEqualOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange IEqualOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value IEqualOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value IEqualOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult IEqualOpAdaptor::verify(Location loc) {
  return success();
}

StringRef IEqualOp::getOperationName() {
  return "spv.IEqual";
}

std::pair<unsigned, unsigned> IEqualOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range IEqualOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value IEqualOp::operand1() {
  return *getODSOperands(0).begin();
}

Value IEqualOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange IEqualOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange IEqualOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> IEqualOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range IEqualOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value IEqualOp::result() {
  return *getODSResults(0).begin();
}

void IEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void IEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void IEqualOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult IEqualOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void IEqualOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult IEqualOp::verify() {
  if (failed(IEqualOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void IEqualOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::IMulOp definitions
//===----------------------------------------------------------------------===//

IMulOpAdaptor::IMulOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

IMulOpAdaptor::IMulOpAdaptor(IMulOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> IMulOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange IMulOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value IMulOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value IMulOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult IMulOpAdaptor::verify(Location loc) {
  return success();
}

StringRef IMulOp::getOperationName() {
  return "spv.IMul";
}

std::pair<unsigned, unsigned> IMulOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range IMulOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value IMulOp::operand1() {
  return *getODSOperands(0).begin();
}

Value IMulOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange IMulOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange IMulOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> IMulOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range IMulOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value IMulOp::result() {
  return *getODSResults(0).begin();
}

void IMulOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void IMulOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void IMulOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void IMulOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes({operand1.getType()});

}

void IMulOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult IMulOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void IMulOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult IMulOp::verify() {
  if (failed(IMulOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}











void IMulOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::INotEqualOp definitions
//===----------------------------------------------------------------------===//

INotEqualOpAdaptor::INotEqualOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

INotEqualOpAdaptor::INotEqualOpAdaptor(INotEqualOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> INotEqualOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange INotEqualOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value INotEqualOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value INotEqualOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult INotEqualOpAdaptor::verify(Location loc) {
  return success();
}

StringRef INotEqualOp::getOperationName() {
  return "spv.INotEqual";
}

std::pair<unsigned, unsigned> INotEqualOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range INotEqualOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value INotEqualOp::operand1() {
  return *getODSOperands(0).begin();
}

Value INotEqualOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange INotEqualOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange INotEqualOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> INotEqualOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range INotEqualOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value INotEqualOp::result() {
  return *getODSResults(0).begin();
}

void INotEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void INotEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void INotEqualOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult INotEqualOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void INotEqualOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult INotEqualOp::verify() {
  if (failed(INotEqualOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void INotEqualOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::ISubOp definitions
//===----------------------------------------------------------------------===//

ISubOpAdaptor::ISubOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

ISubOpAdaptor::ISubOpAdaptor(ISubOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> ISubOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange ISubOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value ISubOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value ISubOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult ISubOpAdaptor::verify(Location loc) {
  return success();
}

StringRef ISubOp::getOperationName() {
  return "spv.ISub";
}

std::pair<unsigned, unsigned> ISubOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range ISubOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value ISubOp::operand1() {
  return *getODSOperands(0).begin();
}

Value ISubOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange ISubOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange ISubOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> ISubOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range ISubOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value ISubOp::result() {
  return *getODSResults(0).begin();
}

void ISubOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void ISubOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ISubOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void ISubOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes({operand1.getType()});

}

void ISubOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult ISubOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void ISubOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult ISubOp::verify() {
  if (failed(ISubOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}











void ISubOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::LoadOp definitions
//===----------------------------------------------------------------------===//

LoadOpAdaptor::LoadOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

LoadOpAdaptor::LoadOpAdaptor(LoadOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> LoadOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange LoadOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value LoadOpAdaptor::ptr() {
  return *getODSOperands(0).begin();
}

IntegerAttr LoadOpAdaptor::memory_access() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_access").dyn_cast_or_null<IntegerAttr>();
  return attr;
}

IntegerAttr LoadOpAdaptor::alignment() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("alignment").dyn_cast_or_null<IntegerAttr>();
  return attr;
}

LogicalResult LoadOpAdaptor::verify(Location loc) {
  {
  auto tblgen_memory_access = odsAttrs.get("memory_access");
  if (tblgen_memory_access) {
    if (!((((tblgen_memory_access.isa<IntegerAttr>())) && ((tblgen_memory_access.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemoryAccess(tblgen_memory_access.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.Load' op ""attribute 'memory_access' failed to satisfy constraint: valid SPIR-V MemoryAccess");
  }
  }
  {
  auto tblgen_alignment = odsAttrs.get("alignment");
  if (tblgen_alignment) {
    if (!(((tblgen_alignment.isa<IntegerAttr>())) && ((tblgen_alignment.cast<IntegerAttr>().getType().isSignlessInteger(32))))) return emitError(loc, "'spv.Load' op ""attribute 'alignment' failed to satisfy constraint: 32-bit signless integer attribute");
  }
  }
  return success();
}

StringRef LoadOp::getOperationName() {
  return "spv.Load";
}

std::pair<unsigned, unsigned> LoadOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range LoadOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value LoadOp::ptr() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange LoadOp::ptrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> LoadOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range LoadOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value LoadOp::value() {
  return *getODSResults(0).begin();
}

IntegerAttr LoadOp::memory_accessAttr() {
  return this->getAttr("memory_access").dyn_cast_or_null<IntegerAttr>();
}

Optional<::mlir::spirv::MemoryAccess> LoadOp::memory_access() {
  auto attr = memory_accessAttr();
  return attr ? Optional<::mlir::spirv::MemoryAccess>(static_cast<::mlir::spirv::MemoryAccess>(attr.getInt())) : (llvm::None);
}

IntegerAttr LoadOp::alignmentAttr() {
  return this->getAttr("alignment").dyn_cast_or_null<IntegerAttr>();
}

Optional< APInt > LoadOp::alignment() {
  auto attr = alignmentAttr();
  return attr ? Optional< APInt >(attr.getValue()) : (llvm::None);
}

void LoadOp::memory_accessAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_access", attr);
}

void LoadOp::alignmentAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("alignment", attr);
}



void LoadOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type value, Value ptr, /*optional*/IntegerAttr memory_access, /*optional*/IntegerAttr alignment) {
  odsState.addOperands(ptr);
  if (memory_access) {
  odsState.addAttribute("memory_access", memory_access);
  }
  if (alignment) {
  odsState.addAttribute("alignment", alignment);
  }
  odsState.addTypes(value);
}

void LoadOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value ptr, /*optional*/IntegerAttr memory_access, /*optional*/IntegerAttr alignment) {
  odsState.addOperands(ptr);
  if (memory_access) {
  odsState.addAttribute("memory_access", memory_access);
  }
  if (alignment) {
  odsState.addAttribute("alignment", alignment);
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LoadOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult LoadOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLoadOp(parser, result);
}

void LoadOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult LoadOp::verify() {
  if (failed(LoadOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::PointerType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isa<NoneType>())) || ((v.getType().isSignlessInteger(1))) || (((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || (((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::PointerType>())) || ((v.getType().isa<::mlir::spirv::ArrayType>())) || ((v.getType().isa<::mlir::spirv::RuntimeArrayType>())) || ((v.getType().isa<::mlir::spirv::StructType>())) || ((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) || ((v.getType().isa<::mlir::spirv::MatrixType>())))) {
        return emitOpError("result #") << index << " must be void or bool or 8/16/32/64-bit integer or 16/32/64-bit float or vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V pointer type or any SPIR-V array type or any SPIR-V runtime array type or any SPIR-V struct type or any SPIR-V cooperative matrix type or any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verify(*this);
}










//===----------------------------------------------------------------------===//
// spirv::LogicalAndOp definitions
//===----------------------------------------------------------------------===//

LogicalAndOpAdaptor::LogicalAndOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

LogicalAndOpAdaptor::LogicalAndOpAdaptor(LogicalAndOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> LogicalAndOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange LogicalAndOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value LogicalAndOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value LogicalAndOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult LogicalAndOpAdaptor::verify(Location loc) {
  return success();
}

StringRef LogicalAndOp::getOperationName() {
  return "spv.LogicalAnd";
}

std::pair<unsigned, unsigned> LogicalAndOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range LogicalAndOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value LogicalAndOp::operand1() {
  return *getODSOperands(0).begin();
}

Value LogicalAndOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange LogicalAndOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange LogicalAndOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> LogicalAndOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range LogicalAndOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value LogicalAndOp::result() {
  return *getODSResults(0).begin();
}

void LogicalAndOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void LogicalAndOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LogicalAndOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult LogicalAndOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void LogicalAndOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult LogicalAndOp::verify() {
  if (failed(LogicalAndOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}











void LogicalAndOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::LogicalEqualOp definitions
//===----------------------------------------------------------------------===//

LogicalEqualOpAdaptor::LogicalEqualOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

LogicalEqualOpAdaptor::LogicalEqualOpAdaptor(LogicalEqualOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> LogicalEqualOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange LogicalEqualOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value LogicalEqualOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value LogicalEqualOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult LogicalEqualOpAdaptor::verify(Location loc) {
  return success();
}

StringRef LogicalEqualOp::getOperationName() {
  return "spv.LogicalEqual";
}

std::pair<unsigned, unsigned> LogicalEqualOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range LogicalEqualOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value LogicalEqualOp::operand1() {
  return *getODSOperands(0).begin();
}

Value LogicalEqualOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange LogicalEqualOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange LogicalEqualOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> LogicalEqualOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range LogicalEqualOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value LogicalEqualOp::result() {
  return *getODSResults(0).begin();
}

void LogicalEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void LogicalEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LogicalEqualOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult LogicalEqualOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void LogicalEqualOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult LogicalEqualOp::verify() {
  if (failed(LogicalEqualOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void LogicalEqualOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::LogicalNotEqualOp definitions
//===----------------------------------------------------------------------===//

LogicalNotEqualOpAdaptor::LogicalNotEqualOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

LogicalNotEqualOpAdaptor::LogicalNotEqualOpAdaptor(LogicalNotEqualOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> LogicalNotEqualOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange LogicalNotEqualOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value LogicalNotEqualOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value LogicalNotEqualOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult LogicalNotEqualOpAdaptor::verify(Location loc) {
  return success();
}

StringRef LogicalNotEqualOp::getOperationName() {
  return "spv.LogicalNotEqual";
}

std::pair<unsigned, unsigned> LogicalNotEqualOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range LogicalNotEqualOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value LogicalNotEqualOp::operand1() {
  return *getODSOperands(0).begin();
}

Value LogicalNotEqualOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange LogicalNotEqualOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange LogicalNotEqualOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> LogicalNotEqualOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range LogicalNotEqualOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value LogicalNotEqualOp::result() {
  return *getODSResults(0).begin();
}

void LogicalNotEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void LogicalNotEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LogicalNotEqualOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult LogicalNotEqualOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void LogicalNotEqualOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult LogicalNotEqualOp::verify() {
  if (failed(LogicalNotEqualOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void LogicalNotEqualOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::LogicalNotOp definitions
//===----------------------------------------------------------------------===//

LogicalNotOpAdaptor::LogicalNotOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

LogicalNotOpAdaptor::LogicalNotOpAdaptor(LogicalNotOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> LogicalNotOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange LogicalNotOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value LogicalNotOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult LogicalNotOpAdaptor::verify(Location loc) {
  return success();
}

StringRef LogicalNotOp::getOperationName() {
  return "spv.LogicalNot";
}

std::pair<unsigned, unsigned> LogicalNotOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range LogicalNotOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value LogicalNotOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange LogicalNotOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> LogicalNotOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range LogicalNotOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value LogicalNotOp::result() {
  return *getODSResults(0).begin();
}

void LogicalNotOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void LogicalNotOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LogicalNotOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult LogicalNotOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalUnaryOp(parser, result);
}

void LogicalNotOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult LogicalNotOp::verify() {
  if (failed(LogicalNotOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}











void LogicalNotOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::LogicalOrOp definitions
//===----------------------------------------------------------------------===//

LogicalOrOpAdaptor::LogicalOrOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

LogicalOrOpAdaptor::LogicalOrOpAdaptor(LogicalOrOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> LogicalOrOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange LogicalOrOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value LogicalOrOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value LogicalOrOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult LogicalOrOpAdaptor::verify(Location loc) {
  return success();
}

StringRef LogicalOrOp::getOperationName() {
  return "spv.LogicalOr";
}

std::pair<unsigned, unsigned> LogicalOrOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range LogicalOrOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value LogicalOrOp::operand1() {
  return *getODSOperands(0).begin();
}

Value LogicalOrOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange LogicalOrOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange LogicalOrOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> LogicalOrOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range LogicalOrOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value LogicalOrOp::result() {
  return *getODSResults(0).begin();
}

void LogicalOrOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void LogicalOrOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LogicalOrOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult LogicalOrOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void LogicalOrOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult LogicalOrOp::verify() {
  if (failed(LogicalOrOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}











void LogicalOrOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::LoopOp definitions
//===----------------------------------------------------------------------===//

LoopOpAdaptor::LoopOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

LoopOpAdaptor::LoopOpAdaptor(LoopOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> LoopOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange LoopOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

IntegerAttr LoopOpAdaptor::loop_control() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("loop_control").cast<IntegerAttr>();
  return attr;
}

LogicalResult LoopOpAdaptor::verify(Location loc) {
  {
  auto tblgen_loop_control = odsAttrs.get("loop_control");
  if (!tblgen_loop_control) return emitError(loc, "'spv.loop' op ""requires attribute 'loop_control'");
    if (!((((tblgen_loop_control.isa<IntegerAttr>())) && ((tblgen_loop_control.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeLoopControl(tblgen_loop_control.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.loop' op ""attribute 'loop_control' failed to satisfy constraint: valid SPIR-V LoopControl");
  }
  return success();
}

StringRef LoopOp::getOperationName() {
  return "spv.loop";
}

std::pair<unsigned, unsigned> LoopOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range LoopOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> LoopOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range LoopOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Region &LoopOp::body() {
  return this->getOperation()->getRegion(0);
}

IntegerAttr LoopOp::loop_controlAttr() {
  return this->getAttr("loop_control").cast<IntegerAttr>();
}

::mlir::spirv::LoopControl LoopOp::loop_control() {
  auto attr = loop_controlAttr();
  return static_cast<::mlir::spirv::LoopControl>(attr.getInt());
}

void LoopOp::loop_controlAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("loop_control", attr);
}



void LoopOp::build(OpBuilder &odsBuilder, OperationState &odsState, IntegerAttr loop_control) {
  odsState.addAttribute("loop_control", loop_control);
  (void)odsState.addRegion();
}

void LoopOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, IntegerAttr loop_control) {
  odsState.addAttribute("loop_control", loop_control);
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LoopOp::build(OpBuilder &odsBuilder, OperationState &odsState, ::mlir::spirv::LoopControl loop_control) {
  odsState.addAttribute("loop_control", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(loop_control)));
  (void)odsState.addRegion();
}

void LoopOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ::mlir::spirv::LoopControl loop_control) {
  odsState.addAttribute("loop_control", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(loop_control)));
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LoopOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult LoopOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLoopOp(parser, result);
}

void LoopOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult LoopOp::verify() {
  if (failed(LoopOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
  }
  if (!((isNestedInFunctionLikeOp((*this->getOperation()).getParentOp()))))
    return emitOpError("failed to verify that op must appear in a function-like op's block");
{
    unsigned index = 0; (void)index;
    for (Region &region : MutableArrayRef<Region>(this->getOperation()->getRegion(0))) {
      (void)region;
      if (!((true))) {
        return emitOpError("region #") << index << " ('body') failed to verify constraint: any region";
      }
      ++index;
    }
  }
  return ::verify(*this);
}










//===----------------------------------------------------------------------===//
// spirv::MatrixTimesScalarOp definitions
//===----------------------------------------------------------------------===//

MatrixTimesScalarOpAdaptor::MatrixTimesScalarOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

MatrixTimesScalarOpAdaptor::MatrixTimesScalarOpAdaptor(MatrixTimesScalarOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> MatrixTimesScalarOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange MatrixTimesScalarOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value MatrixTimesScalarOpAdaptor::matrix() {
  return *getODSOperands(0).begin();
}

Value MatrixTimesScalarOpAdaptor::scalar() {
  return *getODSOperands(1).begin();
}

LogicalResult MatrixTimesScalarOpAdaptor::verify(Location loc) {
  return success();
}

StringRef MatrixTimesScalarOp::getOperationName() {
  return "spv.MatrixTimesScalar";
}

std::pair<unsigned, unsigned> MatrixTimesScalarOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range MatrixTimesScalarOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value MatrixTimesScalarOp::matrix() {
  return *getODSOperands(0).begin();
}

Value MatrixTimesScalarOp::scalar() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange MatrixTimesScalarOp::matrixMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange MatrixTimesScalarOp::scalarMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> MatrixTimesScalarOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range MatrixTimesScalarOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value MatrixTimesScalarOp::result() {
  return *getODSResults(0).begin();
}

void MatrixTimesScalarOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value matrix, Value scalar) {
  odsState.addOperands(matrix);
  odsState.addOperands(scalar);
  odsState.addTypes(result);
}

void MatrixTimesScalarOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value matrix, Value scalar) {
  odsState.addOperands(matrix);
  odsState.addOperands(scalar);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MatrixTimesScalarOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LogicalResult MatrixTimesScalarOp::verify() {
  if (failed(MatrixTimesScalarOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::MatrixType>()))) {
        return emitOpError("operand #") << index << " must be any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!(((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64())))) {
        return emitOpError("operand #") << index << " must be 16/32/64-bit float, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((v.getType().isa<::mlir::spirv::MatrixType>()))) {
        return emitOpError("result #") << index << " must be any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  return verifyMatrixTimesScalar(*this);
}









ParseResult MatrixTimesScalarOp::parse(OpAsmParser &parser, OperationState &result) {
  Type matrixRawTypes[1];
  ArrayRef<Type> matrixTypes(matrixRawTypes);
  Type scalarRawTypes[1];
  ArrayRef<Type> scalarTypes(scalarRawTypes);
  Type resultRawTypes[1];
  ArrayRef<Type> resultTypes(resultRawTypes);
  llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  SmallVector<OpAsmParser::OperandType, 4> allOperands;
  if (parser.parseOperandList(allOperands))
    return failure();
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  if (parser.parseColon())
    return failure();

  if (parser.parseType(matrixRawTypes[0]))
    return failure();
  if (parser.parseComma())
    return failure();

  if (parser.parseType(scalarRawTypes[0]))
    return failure();
  if (parser.parseArrow())
    return failure();

  if (parser.parseType(resultRawTypes[0]))
    return failure();
  result.addTypes(resultTypes);
  if (parser.resolveOperands(allOperands, llvm::concat<const Type>(ArrayRef<Type>(matrixTypes), ArrayRef<Type>(scalarTypes)), allOperandLoc, result.operands))
    return failure();
  return success();
}

void MatrixTimesScalarOp::print(OpAsmPrinter &p) {
  p << "spv.MatrixTimesScalar";
  p << " ";
  p << getOperation()->getOperands();
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{});
  p << " " << ":";
  p << " ";
  p << ArrayRef<Type>(matrix().getType());
  p << ",";
  p << " ";
  p << ArrayRef<Type>(scalar().getType());
  p << " " << "->";
  p << " ";
  p << ArrayRef<Type>(result().getType());
}


//===----------------------------------------------------------------------===//
// spirv::MemoryBarrierOp definitions
//===----------------------------------------------------------------------===//

MemoryBarrierOpAdaptor::MemoryBarrierOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

MemoryBarrierOpAdaptor::MemoryBarrierOpAdaptor(MemoryBarrierOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> MemoryBarrierOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange MemoryBarrierOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

IntegerAttr MemoryBarrierOpAdaptor::memory_scope() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_scope").cast<IntegerAttr>();
  return attr;
}

IntegerAttr MemoryBarrierOpAdaptor::memory_semantics() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_semantics").cast<IntegerAttr>();
  return attr;
}

LogicalResult MemoryBarrierOpAdaptor::verify(Location loc) {
  {
  auto tblgen_memory_scope = odsAttrs.get("memory_scope");
  if (!tblgen_memory_scope) return emitError(loc, "'spv.MemoryBarrier' op ""requires attribute 'memory_scope'");
    if (!((((tblgen_memory_scope.isa<IntegerAttr>())) && ((tblgen_memory_scope.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeScope(tblgen_memory_scope.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.MemoryBarrier' op ""attribute 'memory_scope' failed to satisfy constraint: valid SPIR-V Scope");
  }
  {
  auto tblgen_memory_semantics = odsAttrs.get("memory_semantics");
  if (!tblgen_memory_semantics) return emitError(loc, "'spv.MemoryBarrier' op ""requires attribute 'memory_semantics'");
    if (!((((tblgen_memory_semantics.isa<IntegerAttr>())) && ((tblgen_memory_semantics.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemorySemantics(tblgen_memory_semantics.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.MemoryBarrier' op ""attribute 'memory_semantics' failed to satisfy constraint: valid SPIR-V MemorySemantics");
  }
  return success();
}

StringRef MemoryBarrierOp::getOperationName() {
  return "spv.MemoryBarrier";
}

std::pair<unsigned, unsigned> MemoryBarrierOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range MemoryBarrierOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> MemoryBarrierOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range MemoryBarrierOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

IntegerAttr MemoryBarrierOp::memory_scopeAttr() {
  return this->getAttr("memory_scope").cast<IntegerAttr>();
}

::mlir::spirv::Scope MemoryBarrierOp::memory_scope() {
  auto attr = memory_scopeAttr();
  return static_cast<::mlir::spirv::Scope>(attr.getInt());
}

IntegerAttr MemoryBarrierOp::memory_semanticsAttr() {
  return this->getAttr("memory_semantics").cast<IntegerAttr>();
}

::mlir::spirv::MemorySemantics MemoryBarrierOp::memory_semantics() {
  auto attr = memory_semanticsAttr();
  return static_cast<::mlir::spirv::MemorySemantics>(attr.getInt());
}

void MemoryBarrierOp::memory_scopeAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_scope", attr);
}

void MemoryBarrierOp::memory_semanticsAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_semantics", attr);
}

void MemoryBarrierOp::build(OpBuilder &odsBuilder, OperationState &odsState, IntegerAttr memory_scope, IntegerAttr memory_semantics) {
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("memory_semantics", memory_semantics);
}

void MemoryBarrierOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, IntegerAttr memory_scope, IntegerAttr memory_semantics) {
  odsState.addAttribute("memory_scope", memory_scope);
  odsState.addAttribute("memory_semantics", memory_semantics);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MemoryBarrierOp::build(OpBuilder &odsBuilder, OperationState &odsState, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics memory_semantics) {
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("memory_semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_semantics)));
}

void MemoryBarrierOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ::mlir::spirv::Scope memory_scope, ::mlir::spirv::MemorySemantics memory_semantics) {
  odsState.addAttribute("memory_scope", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_scope)));
  odsState.addAttribute("memory_semantics", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(memory_semantics)));
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MemoryBarrierOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LogicalResult MemoryBarrierOp::verify() {
  if (failed(MemoryBarrierOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
  }
  return verifyMemorySemantics(*this);
}









ParseResult MemoryBarrierOp::parse(OpAsmParser &parser, OperationState &result) {
  {
    StringAttr attrVal;
    NamedAttrList attrStorage;
    auto loc = parser.getCurrentLocation();
    if (parser.parseAttribute(attrVal, parser.getBuilder().getNoneType(),
                              "memory_scope", attrStorage))
      return failure();

    auto attrOptional = ::mlir::spirv::symbolizeScope(attrVal.getValue());
    if (!attrOptional)
      return parser.emitError(loc, "invalid ")
             << "memory_scope attribute specification: " << attrVal;

    result.addAttribute("memory_scope", parser.getBuilder().getI32IntegerAttr(static_cast<int32_t>(attrOptional.getValue())));
  }
  if (parser.parseComma())
    return failure();

  {
    StringAttr attrVal;
    NamedAttrList attrStorage;
    auto loc = parser.getCurrentLocation();
    if (parser.parseAttribute(attrVal, parser.getBuilder().getNoneType(),
                              "memory_semantics", attrStorage))
      return failure();

    auto attrOptional = ::mlir::spirv::symbolizeMemorySemantics(attrVal.getValue());
    if (!attrOptional)
      return parser.emitError(loc, "invalid ")
             << "memory_semantics attribute specification: " << attrVal;

    result.addAttribute("memory_semantics", parser.getBuilder().getI32IntegerAttr(static_cast<int32_t>(attrOptional.getValue())));
  }
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  return success();
}

void MemoryBarrierOp::print(OpAsmPrinter &p) {
  p << "spv.MemoryBarrier";
  p << " ";
  p << "\"" << stringifyScope(memory_scope()) << "\"";
  p << ",";
  p << " ";
  p << "\"" << stringifyMemorySemantics(memory_semantics()) << "\"";
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{"memory_scope", "memory_semantics"});
}


//===----------------------------------------------------------------------===//
// spirv::MergeOp definitions
//===----------------------------------------------------------------------===//

MergeOpAdaptor::MergeOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

MergeOpAdaptor::MergeOpAdaptor(MergeOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> MergeOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange MergeOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

LogicalResult MergeOpAdaptor::verify(Location loc) {
  return success();
}

StringRef MergeOp::getOperationName() {
  return "spv._merge";
}

std::pair<unsigned, unsigned> MergeOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range MergeOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> MergeOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range MergeOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

void MergeOp::build(OpBuilder &odsBuilder, OperationState &odsState) {

}

void MergeOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes) {
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MergeOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LogicalResult MergeOp::verify() {
  if (failed(MergeOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
  }
  return ::verify(*this);
}









ParseResult MergeOp::parse(OpAsmParser &parser, OperationState &result) {
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  return success();
}

void MergeOp::print(OpAsmPrinter &p) {
  p << "spv._merge";
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{});
}

void MergeOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::ModuleEndOp definitions
//===----------------------------------------------------------------------===//

ModuleEndOpAdaptor::ModuleEndOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

ModuleEndOpAdaptor::ModuleEndOpAdaptor(ModuleEndOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> ModuleEndOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange ModuleEndOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

LogicalResult ModuleEndOpAdaptor::verify(Location loc) {
  return success();
}

StringRef ModuleEndOp::getOperationName() {
  return "spv._module_end";
}

std::pair<unsigned, unsigned> ModuleEndOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range ModuleEndOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> ModuleEndOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range ModuleEndOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

void ModuleEndOp::build(OpBuilder &odsBuilder, OperationState &odsState) {

}

void ModuleEndOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes) {
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ModuleEndOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LogicalResult ModuleEndOp::verify() {
  if (failed(ModuleEndOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
  }
  if (!((isDirectInModuleLikeOp((*this->getOperation()).getParentOp()))))
    return emitOpError("failed to verify that op must appear in a module-like op's block");
  return success();
}









ParseResult ModuleEndOp::parse(OpAsmParser &parser, OperationState &result) {
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  return success();
}

void ModuleEndOp::print(OpAsmPrinter &p) {
  p << "spv._module_end";
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{});
}


//===----------------------------------------------------------------------===//
// spirv::ModuleOp definitions
//===----------------------------------------------------------------------===//

ModuleOpAdaptor::ModuleOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

ModuleOpAdaptor::ModuleOpAdaptor(ModuleOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> ModuleOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange ModuleOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

IntegerAttr ModuleOpAdaptor::addressing_model() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("addressing_model").cast<IntegerAttr>();
  return attr;
}

IntegerAttr ModuleOpAdaptor::memory_model() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_model").cast<IntegerAttr>();
  return attr;
}

::mlir::spirv::VerCapExtAttr ModuleOpAdaptor::vce_triple() {
  assert(odsAttrs && "no attributes when constructing adapter");
  ::mlir::spirv::VerCapExtAttr attr = odsAttrs.get("vce_triple").dyn_cast_or_null<::mlir::spirv::VerCapExtAttr>();
  return attr;
}

LogicalResult ModuleOpAdaptor::verify(Location loc) {
  {
  auto tblgen_addressing_model = odsAttrs.get("addressing_model");
  if (!tblgen_addressing_model) return emitError(loc, "'spv.module' op ""requires attribute 'addressing_model'");
    if (!((((tblgen_addressing_model.isa<IntegerAttr>())) && ((tblgen_addressing_model.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeAddressingModel(tblgen_addressing_model.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.module' op ""attribute 'addressing_model' failed to satisfy constraint: valid SPIR-V AddressingModel");
  }
  {
  auto tblgen_memory_model = odsAttrs.get("memory_model");
  if (!tblgen_memory_model) return emitError(loc, "'spv.module' op ""requires attribute 'memory_model'");
    if (!((((tblgen_memory_model.isa<IntegerAttr>())) && ((tblgen_memory_model.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemoryModel(tblgen_memory_model.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.module' op ""attribute 'memory_model' failed to satisfy constraint: valid SPIR-V MemoryModel");
  }
  {
  auto tblgen_vce_triple = odsAttrs.get("vce_triple");
  if (tblgen_vce_triple) {
    if (!((tblgen_vce_triple.isa<::mlir::spirv::VerCapExtAttr>()))) return emitError(loc, "'spv.module' op ""attribute 'vce_triple' failed to satisfy constraint: version-capability-extension attribute");
  }
  }
  return success();
}

StringRef ModuleOp::getOperationName() {
  return "spv.module";
}

std::pair<unsigned, unsigned> ModuleOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range ModuleOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> ModuleOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range ModuleOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Region &ModuleOp::body() {
  return this->getOperation()->getRegion(0);
}

IntegerAttr ModuleOp::addressing_modelAttr() {
  return this->getAttr("addressing_model").cast<IntegerAttr>();
}

::mlir::spirv::AddressingModel ModuleOp::addressing_model() {
  auto attr = addressing_modelAttr();
  return static_cast<::mlir::spirv::AddressingModel>(attr.getInt());
}

IntegerAttr ModuleOp::memory_modelAttr() {
  return this->getAttr("memory_model").cast<IntegerAttr>();
}

::mlir::spirv::MemoryModel ModuleOp::memory_model() {
  auto attr = memory_modelAttr();
  return static_cast<::mlir::spirv::MemoryModel>(attr.getInt());
}

::mlir::spirv::VerCapExtAttr ModuleOp::vce_tripleAttr() {
  return this->getAttr("vce_triple").dyn_cast_or_null<::mlir::spirv::VerCapExtAttr>();
}

Optional<::mlir::spirv::VerCapExtAttr> ModuleOp::vce_triple() {
  auto attr = vce_tripleAttr();
  return attr ? Optional<::mlir::spirv::VerCapExtAttr>(attr) : (llvm::None);
}

void ModuleOp::addressing_modelAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("addressing_model", attr);
}

void ModuleOp::memory_modelAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("memory_model", attr);
}

void ModuleOp::vce_tripleAttr(::mlir::spirv::VerCapExtAttr attr) {
  this->getOperation()->setAttr("vce_triple", attr);
}





ParseResult ModuleOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseModuleOp(parser, result);
}

void ModuleOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult ModuleOp::verify() {
  if (failed(ModuleOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
  }
{
    unsigned index = 0; (void)index;
    for (Region &region : MutableArrayRef<Region>(this->getOperation()->getRegion(0))) {
      (void)region;
      if (!((region.getBlocks().size() == 1))) {
        return emitOpError("region #") << index << " ('body') failed to verify constraint: region with 1 blocks";
      }
      ++index;
    }
  }
  return ::verify(*this);
}










//===----------------------------------------------------------------------===//
// spirv::NotOp definitions
//===----------------------------------------------------------------------===//

NotOpAdaptor::NotOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

NotOpAdaptor::NotOpAdaptor(NotOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> NotOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange NotOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value NotOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult NotOpAdaptor::verify(Location loc) {
  return success();
}

StringRef NotOp::getOperationName() {
  return "spv.Not";
}

std::pair<unsigned, unsigned> NotOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range NotOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value NotOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange NotOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> NotOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range NotOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value NotOp::result() {
  return *getODSResults(0).begin();
}

void NotOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void NotOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void NotOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void NotOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes({operand.getType()});

}

void NotOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult NotOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseUnaryOp(parser, result);
}

void NotOp::print(OpAsmPrinter &p) {
  return ::printUnaryOp(getOperation(), p);
}

LogicalResult NotOp::verify() {
  if (failed(NotOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void NotOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::ReferenceOfOp definitions
//===----------------------------------------------------------------------===//

ReferenceOfOpAdaptor::ReferenceOfOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

ReferenceOfOpAdaptor::ReferenceOfOpAdaptor(ReferenceOfOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> ReferenceOfOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange ReferenceOfOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

FlatSymbolRefAttr ReferenceOfOpAdaptor::spec_const() {
  assert(odsAttrs && "no attributes when constructing adapter");
  FlatSymbolRefAttr attr = odsAttrs.get("spec_const").cast<FlatSymbolRefAttr>();
  return attr;
}

LogicalResult ReferenceOfOpAdaptor::verify(Location loc) {
  {
  auto tblgen_spec_const = odsAttrs.get("spec_const");
  if (!tblgen_spec_const) return emitError(loc, "'spv._reference_of' op ""requires attribute 'spec_const'");
    if (!((tblgen_spec_const.isa<FlatSymbolRefAttr>()))) return emitError(loc, "'spv._reference_of' op ""attribute 'spec_const' failed to satisfy constraint: flat symbol reference attribute");
  }
  return success();
}

StringRef ReferenceOfOp::getOperationName() {
  return "spv._reference_of";
}

std::pair<unsigned, unsigned> ReferenceOfOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range ReferenceOfOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> ReferenceOfOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range ReferenceOfOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value ReferenceOfOp::reference() {
  return *getODSResults(0).begin();
}

FlatSymbolRefAttr ReferenceOfOp::spec_constAttr() {
  return this->getAttr("spec_const").cast<FlatSymbolRefAttr>();
}

StringRef ReferenceOfOp::spec_const() {
  auto attr = spec_constAttr();
  return attr.getValue();
}

void ReferenceOfOp::spec_constAttr(FlatSymbolRefAttr attr) {
  this->getOperation()->setAttr("spec_const", attr);
}

void ReferenceOfOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type reference, FlatSymbolRefAttr spec_const) {
  odsState.addAttribute("spec_const", spec_const);
  odsState.addTypes(reference);
}

void ReferenceOfOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, FlatSymbolRefAttr spec_const) {
  odsState.addAttribute("spec_const", spec_const);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ReferenceOfOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type reference, StringRef spec_const) {
  odsState.addAttribute("spec_const", odsBuilder.getSymbolRefAttr(spec_const));
  odsState.addTypes(reference);
}

void ReferenceOfOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, StringRef spec_const) {
  odsState.addAttribute("spec_const", odsBuilder.getSymbolRefAttr(spec_const));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ReferenceOfOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LogicalResult ReferenceOfOp::verify() {
  if (failed(ReferenceOfOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isa<NoneType>())) || ((v.getType().isSignlessInteger(1))) || (((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || (((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::PointerType>())) || ((v.getType().isa<::mlir::spirv::ArrayType>())) || ((v.getType().isa<::mlir::spirv::RuntimeArrayType>())) || ((v.getType().isa<::mlir::spirv::StructType>())) || ((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) || ((v.getType().isa<::mlir::spirv::MatrixType>())))) {
        return emitOpError("result #") << index << " must be void or bool or 8/16/32/64-bit integer or 16/32/64-bit float or vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V pointer type or any SPIR-V array type or any SPIR-V runtime array type or any SPIR-V struct type or any SPIR-V cooperative matrix type or any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verify(*this);
}









ParseResult ReferenceOfOp::parse(OpAsmParser &parser, OperationState &result) {
  Type referenceRawTypes[1];
  ArrayRef<Type> referenceTypes(referenceRawTypes);

  FlatSymbolRefAttr spec_constAttr;
  if (parser.parseAttribute(spec_constAttr, parser.getBuilder().getType<NoneType>(), "spec_const", result.attributes))
    return failure();
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  if (parser.parseColon())
    return failure();

  if (parser.parseType(referenceRawTypes[0]))
    return failure();
  result.addTypes(referenceTypes);
  return success();
}

void ReferenceOfOp::print(OpAsmPrinter &p) {
  p << "spv._reference_of";
  p << " ";
  p.printAttributeWithoutType(spec_constAttr());
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{"spec_const"});
  p << " " << ":";
  p << " ";
  p << ArrayRef<Type>(reference().getType());
}

void ReferenceOfOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::ReturnOp definitions
//===----------------------------------------------------------------------===//

ReturnOpAdaptor::ReturnOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

ReturnOpAdaptor::ReturnOpAdaptor(ReturnOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> ReturnOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange ReturnOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

LogicalResult ReturnOpAdaptor::verify(Location loc) {
  return success();
}

StringRef ReturnOp::getOperationName() {
  return "spv.Return";
}

std::pair<unsigned, unsigned> ReturnOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range ReturnOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> ReturnOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range ReturnOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

void ReturnOp::build(OpBuilder &odsBuilder, OperationState &odsState) {

}

void ReturnOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes) {
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ReturnOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LogicalResult ReturnOp::verify() {
  if (failed(ReturnOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
  }
  if (!((isNestedInFunctionLikeOp((*this->getOperation()).getParentOp()))))
    return emitOpError("failed to verify that op must appear in a function-like op's block");
  return ::verify(*this);
}









ParseResult ReturnOp::parse(OpAsmParser &parser, OperationState &result) {
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  return success();
}

void ReturnOp::print(OpAsmPrinter &p) {
  p << "spv.Return";
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{});
}

void ReturnOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::ReturnValueOp definitions
//===----------------------------------------------------------------------===//

ReturnValueOpAdaptor::ReturnValueOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

ReturnValueOpAdaptor::ReturnValueOpAdaptor(ReturnValueOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> ReturnValueOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange ReturnValueOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value ReturnValueOpAdaptor::value() {
  return *getODSOperands(0).begin();
}

LogicalResult ReturnValueOpAdaptor::verify(Location loc) {
  return success();
}

StringRef ReturnValueOp::getOperationName() {
  return "spv.ReturnValue";
}

std::pair<unsigned, unsigned> ReturnValueOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range ReturnValueOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value ReturnValueOp::value() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange ReturnValueOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> ReturnValueOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range ReturnValueOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

void ReturnValueOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value value) {
  odsState.addOperands(value);
}

void ReturnValueOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value value) {
  odsState.addOperands(value);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ReturnValueOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LogicalResult ReturnValueOp::verify() {
  if (failed(ReturnValueOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isa<NoneType>())) || ((v.getType().isSignlessInteger(1))) || (((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || (((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64()))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::PointerType>())) || ((v.getType().isa<::mlir::spirv::ArrayType>())) || ((v.getType().isa<::mlir::spirv::RuntimeArrayType>())) || ((v.getType().isa<::mlir::spirv::StructType>())) || ((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) || ((v.getType().isa<::mlir::spirv::MatrixType>())))) {
        return emitOpError("operand #") << index << " must be void or bool or 8/16/32/64-bit integer or 16/32/64-bit float or vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V pointer type or any SPIR-V array type or any SPIR-V runtime array type or any SPIR-V struct type or any SPIR-V cooperative matrix type or any SPIR-V matrix type, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
  }
  if (!((isNestedInFunctionLikeOp((*this->getOperation()).getParentOp()))))
    return emitOpError("failed to verify that op must appear in a function-like op's block");
  return ::verify(*this);
}









ParseResult ReturnValueOp::parse(OpAsmParser &parser, OperationState &result) {
  OpAsmParser::OperandType valueRawOperands[1];
  ArrayRef<OpAsmParser::OperandType> valueOperands(valueRawOperands);  llvm::SMLoc valueOperandsLoc = parser.getCurrentLocation();
  (void)valueOperandsLoc;
  Type valueRawTypes[1];
  ArrayRef<Type> valueTypes(valueRawTypes);

  if (parser.parseOperand(valueRawOperands[0]))
    return failure();
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  if (parser.parseColon())
    return failure();

  if (parser.parseType(valueRawTypes[0]))
    return failure();
  if (parser.resolveOperands(valueOperands, valueTypes, valueOperandsLoc, result.operands))
    return failure();
  return success();
}

void ReturnValueOp::print(OpAsmPrinter &p) {
  p << "spv.ReturnValue";
  p << " ";
  p << value();
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{});
  p << " " << ":";
  p << " ";
  p << ArrayRef<Type>(value().getType());
}

void ReturnValueOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::SConvertOp definitions
//===----------------------------------------------------------------------===//

SConvertOpAdaptor::SConvertOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

SConvertOpAdaptor::SConvertOpAdaptor(SConvertOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> SConvertOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange SConvertOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value SConvertOpAdaptor::operand() {
  return *getODSOperands(0).begin();
}

LogicalResult SConvertOpAdaptor::verify(Location loc) {
  return success();
}

StringRef SConvertOp::getOperationName() {
  return "spv.SConvert";
}

std::pair<unsigned, unsigned> SConvertOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range SConvertOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value SConvertOp::operand() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange SConvertOp::operandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> SConvertOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range SConvertOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value SConvertOp::result() {
  return *getODSResults(0).begin();
}

void SConvertOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(result);
}

void SConvertOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SConvertOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult SConvertOp::parse(OpAsmParser &parser, OperationState &result) {
  return mlir::impl::parseCastOp(parser, result);
}

void SConvertOp::print(OpAsmPrinter &p) {
  mlir::impl::printCastOp(this->getOperation(), p);
}

LogicalResult SConvertOp::verify() {
  if (failed(SConvertOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  return verifyCastOp(this->getOperation(), false);
}









void SConvertOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::SDivOp definitions
//===----------------------------------------------------------------------===//

SDivOpAdaptor::SDivOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

SDivOpAdaptor::SDivOpAdaptor(SDivOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> SDivOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange SDivOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value SDivOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value SDivOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult SDivOpAdaptor::verify(Location loc) {
  return success();
}

StringRef SDivOp::getOperationName() {
  return "spv.SDiv";
}

std::pair<unsigned, unsigned> SDivOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range SDivOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value SDivOp::operand1() {
  return *getODSOperands(0).begin();
}

Value SDivOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange SDivOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange SDivOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> SDivOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range SDivOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value SDivOp::result() {
  return *getODSResults(0).begin();
}

void SDivOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void SDivOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SDivOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void SDivOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes({operand1.getType()});

}

void SDivOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult SDivOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void SDivOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult SDivOp::verify() {
  if (failed(SDivOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void SDivOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::SGreaterThanEqualOp definitions
//===----------------------------------------------------------------------===//

SGreaterThanEqualOpAdaptor::SGreaterThanEqualOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

SGreaterThanEqualOpAdaptor::SGreaterThanEqualOpAdaptor(SGreaterThanEqualOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> SGreaterThanEqualOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange SGreaterThanEqualOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value SGreaterThanEqualOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value SGreaterThanEqualOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult SGreaterThanEqualOpAdaptor::verify(Location loc) {
  return success();
}

StringRef SGreaterThanEqualOp::getOperationName() {
  return "spv.SGreaterThanEqual";
}

std::pair<unsigned, unsigned> SGreaterThanEqualOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range SGreaterThanEqualOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value SGreaterThanEqualOp::operand1() {
  return *getODSOperands(0).begin();
}

Value SGreaterThanEqualOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange SGreaterThanEqualOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange SGreaterThanEqualOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> SGreaterThanEqualOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range SGreaterThanEqualOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value SGreaterThanEqualOp::result() {
  return *getODSResults(0).begin();
}

void SGreaterThanEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void SGreaterThanEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SGreaterThanEqualOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult SGreaterThanEqualOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void SGreaterThanEqualOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult SGreaterThanEqualOp::verify() {
  if (failed(SGreaterThanEqualOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void SGreaterThanEqualOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::SGreaterThanOp definitions
//===----------------------------------------------------------------------===//

SGreaterThanOpAdaptor::SGreaterThanOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

SGreaterThanOpAdaptor::SGreaterThanOpAdaptor(SGreaterThanOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> SGreaterThanOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange SGreaterThanOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value SGreaterThanOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value SGreaterThanOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult SGreaterThanOpAdaptor::verify(Location loc) {
  return success();
}

StringRef SGreaterThanOp::getOperationName() {
  return "spv.SGreaterThan";
}

std::pair<unsigned, unsigned> SGreaterThanOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range SGreaterThanOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value SGreaterThanOp::operand1() {
  return *getODSOperands(0).begin();
}

Value SGreaterThanOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange SGreaterThanOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange SGreaterThanOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> SGreaterThanOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range SGreaterThanOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value SGreaterThanOp::result() {
  return *getODSResults(0).begin();
}

void SGreaterThanOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void SGreaterThanOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SGreaterThanOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult SGreaterThanOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void SGreaterThanOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult SGreaterThanOp::verify() {
  if (failed(SGreaterThanOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void SGreaterThanOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::SLessThanEqualOp definitions
//===----------------------------------------------------------------------===//

SLessThanEqualOpAdaptor::SLessThanEqualOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

SLessThanEqualOpAdaptor::SLessThanEqualOpAdaptor(SLessThanEqualOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> SLessThanEqualOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange SLessThanEqualOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value SLessThanEqualOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value SLessThanEqualOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult SLessThanEqualOpAdaptor::verify(Location loc) {
  return success();
}

StringRef SLessThanEqualOp::getOperationName() {
  return "spv.SLessThanEqual";
}

std::pair<unsigned, unsigned> SLessThanEqualOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range SLessThanEqualOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value SLessThanEqualOp::operand1() {
  return *getODSOperands(0).begin();
}

Value SLessThanEqualOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange SLessThanEqualOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange SLessThanEqualOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> SLessThanEqualOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range SLessThanEqualOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value SLessThanEqualOp::result() {
  return *getODSResults(0).begin();
}

void SLessThanEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void SLessThanEqualOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SLessThanEqualOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult SLessThanEqualOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void SLessThanEqualOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult SLessThanEqualOp::verify() {
  if (failed(SLessThanEqualOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void SLessThanEqualOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::SLessThanOp definitions
//===----------------------------------------------------------------------===//

SLessThanOpAdaptor::SLessThanOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

SLessThanOpAdaptor::SLessThanOpAdaptor(SLessThanOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> SLessThanOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange SLessThanOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value SLessThanOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value SLessThanOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult SLessThanOpAdaptor::verify(Location loc) {
  return success();
}

StringRef SLessThanOp::getOperationName() {
  return "spv.SLessThan";
}

std::pair<unsigned, unsigned> SLessThanOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range SLessThanOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value SLessThanOp::operand1() {
  return *getODSOperands(0).begin();
}

Value SLessThanOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange SLessThanOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange SLessThanOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> SLessThanOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range SLessThanOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value SLessThanOp::result() {
  return *getODSResults(0).begin();
}

void SLessThanOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void SLessThanOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SLessThanOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult SLessThanOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseLogicalBinaryOp(parser, result);
}

void SLessThanOp::print(OpAsmPrinter &p) {
  return ::printLogicalOp(getOperation(), p);
}

LogicalResult SLessThanOp::verify() {
  if (failed(SLessThanOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void SLessThanOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::SModOp definitions
//===----------------------------------------------------------------------===//

SModOpAdaptor::SModOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

SModOpAdaptor::SModOpAdaptor(SModOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> SModOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange SModOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value SModOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value SModOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult SModOpAdaptor::verify(Location loc) {
  return success();
}

StringRef SModOp::getOperationName() {
  return "spv.SMod";
}

std::pair<unsigned, unsigned> SModOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range SModOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value SModOp::operand1() {
  return *getODSOperands(0).begin();
}

Value SModOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange SModOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange SModOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> SModOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range SModOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value SModOp::result() {
  return *getODSResults(0).begin();
}

void SModOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void SModOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SModOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void SModOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes({operand1.getType()});

}

void SModOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult SModOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void SModOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult SModOp::verify() {
  if (failed(SModOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void SModOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::SRemOp definitions
//===----------------------------------------------------------------------===//

SRemOpAdaptor::SRemOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

SRemOpAdaptor::SRemOpAdaptor(SRemOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> SRemOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange SRemOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value SRemOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value SRemOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult SRemOpAdaptor::verify(Location loc) {
  return success();
}

StringRef SRemOp::getOperationName() {
  return "spv.SRem";
}

std::pair<unsigned, unsigned> SRemOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range SRemOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value SRemOp::operand1() {
  return *getODSOperands(0).begin();
}

Value SRemOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange SRemOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange SRemOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> SRemOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range SRemOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value SRemOp::result() {
  return *getODSResults(0).begin();
}

void SRemOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void SRemOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SRemOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void SRemOp::build(OpBuilder &odsBuilder, OperationState &odsState, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes({operand1.getType()});

}

void SRemOp::build(OpBuilder &odsBuilder, OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes({operands[0].getType()});

}

ParseResult SRemOp::parse(OpAsmParser &parser, OperationState &result) {
  return impl::parseOneResultSameOperandTypeOp(parser, result);
}

void SRemOp::print(OpAsmPrinter &p) {
  return impl::printOneResultOp(getOperation(), p);
}

LogicalResult SRemOp::verify() {
  if (failed(SRemOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || (((v.getType().isa<::mlir::spirv::CooperativeMatrixNVType>())) && (((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(8))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(16))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(32))) || ((v.getType().cast<::mlir::spirv::CooperativeMatrixNVType>().getElementType().isInteger(64))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4 or Cooperative Matrix of 8/16/32/64-bit integer values, but got " << v.getType();
      }
      ++index;
    }
  }
  return success();
}









void SRemOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::SelectOp definitions
//===----------------------------------------------------------------------===//

SelectOpAdaptor::SelectOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

SelectOpAdaptor::SelectOpAdaptor(SelectOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> SelectOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange SelectOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value SelectOpAdaptor::condition() {
  return *getODSOperands(0).begin();
}

Value SelectOpAdaptor::true_value() {
  return *getODSOperands(1).begin();
}

Value SelectOpAdaptor::false_value() {
  return *getODSOperands(2).begin();
}

LogicalResult SelectOpAdaptor::verify(Location loc) {
  return success();
}

StringRef SelectOp::getOperationName() {
  return "spv.Select";
}

std::pair<unsigned, unsigned> SelectOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range SelectOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value SelectOp::condition() {
  return *getODSOperands(0).begin();
}

Value SelectOp::true_value() {
  return *getODSOperands(1).begin();
}

Value SelectOp::false_value() {
  return *getODSOperands(2).begin();
}

::mlir::MutableOperandRange SelectOp::conditionMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange SelectOp::true_valueMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange SelectOp::false_valueMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> SelectOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range SelectOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value SelectOp::result() {
  return *getODSResults(0).begin();
}



void SelectOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value condition, Value true_value, Value false_value) {
  odsState.addOperands(condition);
  odsState.addOperands(true_value);
  odsState.addOperands(false_value);
  odsState.addTypes(result);
}

void SelectOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value condition, Value true_value, Value false_value) {
  odsState.addOperands(condition);
  odsState.addOperands(true_value);
  odsState.addOperands(false_value);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SelectOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LogicalResult SelectOp::verify() {
  if (failed(SelectOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!(((v.getType().isSignlessInteger(1))) || ((((v.getType().isa<VectorType>())) && ((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1)))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be bool or vector of bool values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || (((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64())))) || ((v.getType().isSignlessInteger(1)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::PointerType>())))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or 16/32/64-bit float or bool or vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup2 = getODSOperands(2);
    for (Value v : valueGroup2) {
      (void)v;
      if (!((((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || (((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64())))) || ((v.getType().isSignlessInteger(1)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::PointerType>())))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or 16/32/64-bit float or bool or vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || (((v.getType().isF16())) || ((v.getType().isF32())) || ((v.getType().isF64())))) || ((v.getType().isSignlessInteger(1)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isSignlessInteger(1))) || (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64)))) || (((v.getType().cast<ShapedType>().getElementType().isF16())) || ((v.getType().cast<ShapedType>().getElementType().isF32())) || ((v.getType().cast<ShapedType>().getElementType().isF64()))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))) || ((v.getType().isa<::mlir::spirv::PointerType>())))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or 16/32/64-bit float or bool or vector of bool or 8/16/32/64-bit integer or 16/32/64-bit float values of length 2/3/4 or any SPIR-V pointer type, but got " << v.getType();
      }
      ++index;
    }
  }
  if (!((llvm::is_splat(llvm::makeArrayRef({(*this->getODSOperands(1).begin()).getType(), (*this->getODSOperands(2).begin()).getType(), (*this->getODSResults(0).begin()).getType()})))))
    return emitOpError("failed to verify that all of {true_value, false_value, result} have same type");
  return ::verify(*this);
}









ParseResult SelectOp::parse(OpAsmParser &parser, OperationState &result) {
  Type conditionRawTypes[1];
  ArrayRef<Type> conditionTypes(conditionRawTypes);
  Type resultRawTypes[1];
  ArrayRef<Type> resultTypes(resultRawTypes);
  llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  SmallVector<OpAsmParser::OperandType, 4> allOperands;
  if (parser.parseOperandList(allOperands))
    return failure();
  if (parser.parseOptionalAttrDict(result.attributes))
    return failure();
  if (parser.parseColon())
    return failure();

  if (parser.parseType(conditionRawTypes[0]))
    return failure();
  if (parser.parseComma())
    return failure();

  if (parser.parseType(resultRawTypes[0]))
    return failure();
  result.addTypes(resultTypes);
  if (parser.resolveOperands(allOperands, llvm::concat<const Type>(ArrayRef<Type>(conditionTypes), ArrayRef<Type>(resultTypes), ArrayRef<Type>(resultTypes)), allOperandLoc, result.operands))
    return failure();
  return success();
}

void SelectOp::print(OpAsmPrinter &p) {
  p << "spv.Select";
  p << " ";
  p << getOperation()->getOperands();
  p.printOptionalAttrDict(getAttrs(), /*elidedAttrs=*/{});
  p << " " << ":";
  p << " ";
  p << ArrayRef<Type>(condition().getType());
  p << ",";
  p << " ";
  p << ArrayRef<Type>(result().getType());
}

void SelectOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::SelectionOp definitions
//===----------------------------------------------------------------------===//

SelectionOpAdaptor::SelectionOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

SelectionOpAdaptor::SelectionOpAdaptor(SelectionOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> SelectionOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange SelectionOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

IntegerAttr SelectionOpAdaptor::selection_control() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("selection_control").cast<IntegerAttr>();
  return attr;
}

LogicalResult SelectionOpAdaptor::verify(Location loc) {
  {
  auto tblgen_selection_control = odsAttrs.get("selection_control");
  if (!tblgen_selection_control) return emitError(loc, "'spv.selection' op ""requires attribute 'selection_control'");
    if (!((((tblgen_selection_control.isa<IntegerAttr>())) && ((tblgen_selection_control.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeSelectionControl(tblgen_selection_control.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.selection' op ""attribute 'selection_control' failed to satisfy constraint: valid SPIR-V SelectionControl");
  }
  return success();
}

StringRef SelectionOp::getOperationName() {
  return "spv.selection";
}

std::pair<unsigned, unsigned> SelectionOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range SelectionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> SelectionOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range SelectionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Region &SelectionOp::body() {
  return this->getOperation()->getRegion(0);
}

IntegerAttr SelectionOp::selection_controlAttr() {
  return this->getAttr("selection_control").cast<IntegerAttr>();
}

::mlir::spirv::SelectionControl SelectionOp::selection_control() {
  auto attr = selection_controlAttr();
  return static_cast<::mlir::spirv::SelectionControl>(attr.getInt());
}

void SelectionOp::selection_controlAttr(IntegerAttr attr) {
  this->getOperation()->setAttr("selection_control", attr);
}

void SelectionOp::build(OpBuilder &odsBuilder, OperationState &odsState, IntegerAttr selection_control) {
  odsState.addAttribute("selection_control", selection_control);
  (void)odsState.addRegion();
}

void SelectionOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, IntegerAttr selection_control) {
  odsState.addAttribute("selection_control", selection_control);
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SelectionOp::build(OpBuilder &odsBuilder, OperationState &odsState, ::mlir::spirv::SelectionControl selection_control) {
  odsState.addAttribute("selection_control", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(selection_control)));
  (void)odsState.addRegion();
}

void SelectionOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, ::mlir::spirv::SelectionControl selection_control) {
  odsState.addAttribute("selection_control", odsBuilder.getI32IntegerAttr(static_cast<int32_t>(selection_control)));
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SelectionOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult SelectionOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseSelectionOp(parser, result);
}

void SelectionOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult SelectionOp::verify() {
  if (failed(SelectionOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
  }
  if (!((isNestedInFunctionLikeOp((*this->getOperation()).getParentOp()))))
    return emitOpError("failed to verify that op must appear in a function-like op's block");
{
    unsigned index = 0; (void)index;
    for (Region &region : MutableArrayRef<Region>(this->getOperation()->getRegion(0))) {
      (void)region;
      if (!((true))) {
        return emitOpError("region #") << index << " ('body') failed to verify constraint: any region";
      }
      ++index;
    }
  }
  return ::verify(*this);
}












//===----------------------------------------------------------------------===//
// spirv::ShiftLeftLogicalOp definitions
//===----------------------------------------------------------------------===//

ShiftLeftLogicalOpAdaptor::ShiftLeftLogicalOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

ShiftLeftLogicalOpAdaptor::ShiftLeftLogicalOpAdaptor(ShiftLeftLogicalOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> ShiftLeftLogicalOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange ShiftLeftLogicalOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value ShiftLeftLogicalOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value ShiftLeftLogicalOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult ShiftLeftLogicalOpAdaptor::verify(Location loc) {
  return success();
}

StringRef ShiftLeftLogicalOp::getOperationName() {
  return "spv.ShiftLeftLogical";
}

std::pair<unsigned, unsigned> ShiftLeftLogicalOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range ShiftLeftLogicalOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value ShiftLeftLogicalOp::operand1() {
  return *getODSOperands(0).begin();
}

Value ShiftLeftLogicalOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange ShiftLeftLogicalOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange ShiftLeftLogicalOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> ShiftLeftLogicalOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range ShiftLeftLogicalOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value ShiftLeftLogicalOp::result() {
  return *getODSResults(0).begin();
}

void ShiftLeftLogicalOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void ShiftLeftLogicalOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ShiftLeftLogicalOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult ShiftLeftLogicalOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseShiftOp(parser, result);
}

void ShiftLeftLogicalOp::print(OpAsmPrinter &p) {
  ::printShiftOp(this->getOperation(), p);
}

LogicalResult ShiftLeftLogicalOp::verify() {
  if (failed(ShiftLeftLogicalOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyShiftOp(this->getOperation());
}









void ShiftLeftLogicalOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::ShiftRightArithmeticOp definitions
//===----------------------------------------------------------------------===//

ShiftRightArithmeticOpAdaptor::ShiftRightArithmeticOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

ShiftRightArithmeticOpAdaptor::ShiftRightArithmeticOpAdaptor(ShiftRightArithmeticOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> ShiftRightArithmeticOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange ShiftRightArithmeticOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value ShiftRightArithmeticOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value ShiftRightArithmeticOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult ShiftRightArithmeticOpAdaptor::verify(Location loc) {
  return success();
}

StringRef ShiftRightArithmeticOp::getOperationName() {
  return "spv.ShiftRightArithmetic";
}

std::pair<unsigned, unsigned> ShiftRightArithmeticOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range ShiftRightArithmeticOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value ShiftRightArithmeticOp::operand1() {
  return *getODSOperands(0).begin();
}

Value ShiftRightArithmeticOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange ShiftRightArithmeticOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange ShiftRightArithmeticOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> ShiftRightArithmeticOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range ShiftRightArithmeticOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value ShiftRightArithmeticOp::result() {
  return *getODSResults(0).begin();
}

void ShiftRightArithmeticOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void ShiftRightArithmeticOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ShiftRightArithmeticOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult ShiftRightArithmeticOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseShiftOp(parser, result);
}

void ShiftRightArithmeticOp::print(OpAsmPrinter &p) {
  ::printShiftOp(this->getOperation(), p);
}

LogicalResult ShiftRightArithmeticOp::verify() {
  if (failed(ShiftRightArithmeticOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyShiftOp(this->getOperation());
}









void ShiftRightArithmeticOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::ShiftRightLogicalOp definitions
//===----------------------------------------------------------------------===//

ShiftRightLogicalOpAdaptor::ShiftRightLogicalOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

ShiftRightLogicalOpAdaptor::ShiftRightLogicalOpAdaptor(ShiftRightLogicalOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> ShiftRightLogicalOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange ShiftRightLogicalOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value ShiftRightLogicalOpAdaptor::operand1() {
  return *getODSOperands(0).begin();
}

Value ShiftRightLogicalOpAdaptor::operand2() {
  return *getODSOperands(1).begin();
}

LogicalResult ShiftRightLogicalOpAdaptor::verify(Location loc) {
  return success();
}

StringRef ShiftRightLogicalOp::getOperationName() {
  return "spv.ShiftRightLogical";
}

std::pair<unsigned, unsigned> ShiftRightLogicalOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range ShiftRightLogicalOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value ShiftRightLogicalOp::operand1() {
  return *getODSOperands(0).begin();
}

Value ShiftRightLogicalOp::operand2() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange ShiftRightLogicalOp::operand1Mutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange ShiftRightLogicalOp::operand2Mutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> ShiftRightLogicalOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range ShiftRightLogicalOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

Value ShiftRightLogicalOp::result() {
  return *getODSResults(0).begin();
}

void ShiftRightLogicalOp::build(OpBuilder &odsBuilder, OperationState &odsState, Type result, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  odsState.addTypes(result);
}

void ShiftRightLogicalOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, Value operand1, Value operand2) {
  odsState.addOperands(operand1);
  odsState.addOperands(operand2);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ShiftRightLogicalOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult ShiftRightLogicalOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseShiftOp(parser, result);
}

void ShiftRightLogicalOp::print(OpAsmPrinter &p) {
  ::printShiftOp(this->getOperation(), p);
}

LogicalResult ShiftRightLogicalOp::verify() {
  if (failed(ShiftRightLogicalOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
    auto valueGroup1 = getODSOperands(1);
    for (Value v : valueGroup1) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("operand #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);
    for (Value v : valueGroup0) {
      (void)v;
      if (!((((v.getType().isInteger(8))) || ((v.getType().isInteger(16))) || ((v.getType().isInteger(32))) || ((v.getType().isInteger(64)))) || ((((v.getType().isa<VectorType>())) && (((v.getType().cast<ShapedType>().getElementType().isInteger(8))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(16))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(32))) || ((v.getType().cast<ShapedType>().getElementType().isInteger(64))))) && (((v.getType().isa<VectorType>())) && (((v.getType().cast<VectorType>().getNumElements()
                           == 2)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 3)) || ((v.getType().cast<VectorType>().getNumElements()
                           == 4))))))) {
        return emitOpError("result #") << index << " must be 8/16/32/64-bit integer or vector of 8/16/32/64-bit integer values of length 2/3/4, but got " << v.getType();
      }
      ++index;
    }
  }
  return ::verifyShiftOp(this->getOperation());
}









void ShiftRightLogicalOp::getEffects(SmallVectorImpl<SideEffects::EffectInstance<MemoryEffects::Effect>> &effects) {

}


//===----------------------------------------------------------------------===//
// spirv::SpecConstantOp definitions
//===----------------------------------------------------------------------===//

SpecConstantOpAdaptor::SpecConstantOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

SpecConstantOpAdaptor::SpecConstantOpAdaptor(SpecConstantOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> SpecConstantOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange SpecConstantOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

StringAttr SpecConstantOpAdaptor::sym_name() {
  assert(odsAttrs && "no attributes when constructing adapter");
  StringAttr attr = odsAttrs.get("sym_name").cast<StringAttr>();
  return attr;
}

Attribute SpecConstantOpAdaptor::default_value() {
  assert(odsAttrs && "no attributes when constructing adapter");
  Attribute attr = odsAttrs.get("default_value").cast<Attribute>();
  return attr;
}

LogicalResult SpecConstantOpAdaptor::verify(Location loc) {
  {
  auto tblgen_sym_name = odsAttrs.get("sym_name");
  if (!tblgen_sym_name) return emitError(loc, "'spv.specConstant' op ""requires attribute 'sym_name'");
    if (!((tblgen_sym_name.isa<StringAttr>()))) return emitError(loc, "'spv.specConstant' op ""attribute 'sym_name' failed to satisfy constraint: string attribute");
  }
  {
  auto tblgen_default_value = odsAttrs.get("default_value");
  if (!tblgen_default_value) return emitError(loc, "'spv.specConstant' op ""requires attribute 'default_value'");
    if (!((true))) return emitError(loc, "'spv.specConstant' op ""attribute 'default_value' failed to satisfy constraint: any attribute");
  }
  return success();
}

StringRef SpecConstantOp::getOperationName() {
  return "spv.specConstant";
}

std::pair<unsigned, unsigned> SpecConstantOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range SpecConstantOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> SpecConstantOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range SpecConstantOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

StringAttr SpecConstantOp::sym_nameAttr() {
  return this->getAttr("sym_name").cast<StringAttr>();
}

StringRef SpecConstantOp::sym_name() {
  auto attr = sym_nameAttr();
  return attr.getValue();
}

Attribute SpecConstantOp::default_valueAttr() {
  return this->getAttr("default_value").cast<Attribute>();
}

Attribute SpecConstantOp::default_value() {
  auto attr = default_valueAttr();
  return attr;
}

void SpecConstantOp::sym_nameAttr(StringAttr attr) {
  this->getOperation()->setAttr("sym_name", attr);
}

void SpecConstantOp::default_valueAttr(Attribute attr) {
  this->getOperation()->setAttr("default_value", attr);
}

void SpecConstantOp::build(OpBuilder &odsBuilder, OperationState &odsState, StringAttr sym_name, Attribute default_value) {
  odsState.addAttribute("sym_name", sym_name);
  odsState.addAttribute("default_value", default_value);
}

void SpecConstantOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, StringAttr sym_name, Attribute default_value) {
  odsState.addAttribute("sym_name", sym_name);
  odsState.addAttribute("default_value", default_value);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SpecConstantOp::build(OpBuilder &odsBuilder, OperationState &odsState, StringRef sym_name, Attribute default_value) {
  odsState.addAttribute("sym_name", odsBuilder.getStringAttr(sym_name));
  odsState.addAttribute("default_value", default_value);
}

void SpecConstantOp::build(OpBuilder &odsBuilder, OperationState &odsState, ArrayRef<Type> resultTypes, StringRef sym_name, Attribute default_value) {
  odsState.addAttribute("sym_name", odsBuilder.getStringAttr(sym_name));
  odsState.addAttribute("default_value", default_value);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SpecConstantOp::build(OpBuilder &, OperationState &odsState, ArrayRef<Type> resultTypes, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ParseResult SpecConstantOp::parse(OpAsmParser &parser, OperationState &result) {
  return ::parseSpecConstantOp(parser, result);
}

void SpecConstantOp::print(OpAsmPrinter &p) {
  return ::print(*this, p);
}

LogicalResult SpecConstantOp::verify() {
  if (failed(SpecConstantOpAdaptor(*this).verify(this->getLoc()))) return failure();
  {
    unsigned index = 0; (void)index;
  }
  {
    unsigned index = 0; (void)index;
  }
  if (!((isDirectInModuleLikeOp((*this->getOperation()).getParentOp()))))
    return emitOpError("failed to verify that op must appear in a module-like op's block");
  return ::verify(*this);
}










//===----------------------------------------------------------------------===//
// spirv::StoreOp definitions
//===----------------------------------------------------------------------===//

StoreOpAdaptor::StoreOpAdaptor(ValueRange values, DictionaryAttr attrs )  : odsOperands(values), odsAttrs(attrs) {

}

StoreOpAdaptor::StoreOpAdaptor(StoreOp& op)  : odsOperands(op.getOperation()->getOperands()), odsAttrs(op.getOperation()->getAttrDictionary()) {

}

std::pair<unsigned, unsigned> StoreOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

ValueRange StoreOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

Value StoreOpAdaptor::ptr() {
  return *getODSOperands(0).begin();
}

Value StoreOpAdaptor::value() {
  return *getODSOperands(1).begin();
}

IntegerAttr StoreOpAdaptor::memory_access() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("memory_access").dyn_cast_or_null<IntegerAttr>();
  return attr;
}

IntegerAttr StoreOpAdaptor::alignment() {
  assert(odsAttrs && "no attributes when constructing adapter");
  IntegerAttr attr = odsAttrs.get("alignment").dyn_cast_or_null<IntegerAttr>();
  return attr;
}

LogicalResult StoreOpAdaptor::verify(Location loc) {
  {
  auto tblgen_memory_access = odsAttrs.get("memory_access");
  if (tblgen_memory_access) {
    if (!((((tblgen_memory_access.isa<IntegerAttr>())) && ((tblgen_memory_access.cast<IntegerAttr>().getType().isSignlessInteger(32)))) && ((::mlir::spirv::symbolizeMemoryAccess(tblgen_memory_access.cast<IntegerAttr>().getValue().getZExtValue()).hasValue())))) return emitError(loc, "'spv.Store' op ""attribute 'memory_access' failed to satisfy constraint: valid SPIR-V MemoryAccess");
  }
  }
  {
  auto tblgen_alignment = odsAttrs.get("alignment");
  if (tblgen_alignment) {
    if (!(((tblgen_alignment.isa<IntegerAttr>())) && ((tblgen_alignment.cast<IntegerAttr>().getType().isSignlessInteger(32))))) return emitError(loc, "'spv.Store' op ""attribute 'alignment' failed to satisfy constraint: 32-bit signless integer attribute");
  }
  }
  return success();
}

StringRef StoreOp::getOperationName() {
  return "spv.Store";
}

std::pair<unsigned, unsigned> StoreOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::operand_range StoreOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

Value StoreOp::ptr() {
  return *getODSOperands(0).begin();
}

Value StoreOp::value() {
  return *getODSOperands(1).begin();
}

::mlir::MutableOperandRange StoreOp::ptrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

::mlir::MutableOperandRange StoreOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
}

std::pair<unsigned, unsigned> StoreOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

Operation::result_range Stor