/* Autogenerated by mlir-tblgen; don't manually edit */
#ifdef GEN_PASS_CLASSES

//===----------------------------------------------------------------------===//
// ConvertAVX512ToLLVM
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertAVX512ToLLVMBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertAVX512ToLLVMBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertAVX512ToLLVMBase(const ConvertAVX512ToLLVMBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-avx512-to-llvm"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertAVX512ToLLVM"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertAffineForToGPU
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertAffineForToGPUBase : public ::mlir::FunctionPass {
public:
  ConvertAffineForToGPUBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  ConvertAffineForToGPUBase(const ConvertAffineForToGPUBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-affine-for-to-gpu"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertAffineForToGPU"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
  Pass::Option<unsigned> numBlockDims{*this, "gpu-block-dims", llvm::cl::desc("Number of GPU block dimensions for mapping"), llvm::cl::init(1u)};
  Pass::Option<unsigned> numThreadDims{*this, "gpu-thread-dims", llvm::cl::desc("Number of GPU thread dimensions for mapping"), llvm::cl::init(1u)};
};

//===----------------------------------------------------------------------===//
// ConvertAffineToStandard
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertAffineToStandardBase : public ::mlir::FunctionPass {
public:
  ConvertAffineToStandardBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  ConvertAffineToStandardBase(const ConvertAffineToStandardBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "lower-affine"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertAffineToStandard"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertGPUToSPIRV
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertGPUToSPIRVBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertGPUToSPIRVBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertGPUToSPIRVBase(const ConvertGPUToSPIRVBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-gpu-to-spirv"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertGPUToSPIRV"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertGpuLaunchFuncToGpuRuntimeCalls
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertGpuLaunchFuncToGpuRuntimeCallsBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertGpuLaunchFuncToGpuRuntimeCallsBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertGpuLaunchFuncToGpuRuntimeCallsBase(const ConvertGpuLaunchFuncToGpuRuntimeCallsBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "launch-func-to-gpu-runtime"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertGpuLaunchFuncToGpuRuntimeCalls"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
  Pass::Option<std::string> gpuBinaryAnnotation{*this, "gpu-binary-annotation", llvm::cl::desc("Annotation attribute string for GPU binary"), llvm::cl::init("nvvm.cubin")};
};

//===----------------------------------------------------------------------===//
// ConvertGpuLaunchFuncToVulkanLaunchFunc
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertGpuLaunchFuncToVulkanLaunchFuncBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertGpuLaunchFuncToVulkanLaunchFuncBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertGpuLaunchFuncToVulkanLaunchFuncBase(const ConvertGpuLaunchFuncToVulkanLaunchFuncBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-gpu-launch-to-vulkan-launch"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertGpuLaunchFuncToVulkanLaunchFunc"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertGpuOpsToNVVMOps
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertGpuOpsToNVVMOpsBase : public ::mlir::OperationPass<gpu::GPUModuleOp> {
public:
  ConvertGpuOpsToNVVMOpsBase() : ::mlir::OperationPass<gpu::GPUModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertGpuOpsToNVVMOpsBase(const ConvertGpuOpsToNVVMOpsBase &) : ::mlir::OperationPass<gpu::GPUModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-gpu-to-nvvm"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertGpuOpsToNVVMOps"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertGpuOpsToROCDLOps
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertGpuOpsToROCDLOpsBase : public ::mlir::OperationPass<gpu::GPUModuleOp> {
public:
  ConvertGpuOpsToROCDLOpsBase() : ::mlir::OperationPass<gpu::GPUModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertGpuOpsToROCDLOpsBase(const ConvertGpuOpsToROCDLOpsBase &) : ::mlir::OperationPass<gpu::GPUModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-gpu-to-rocdl"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertGpuOpsToROCDLOps"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertLinalgToLLVM
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertLinalgToLLVMBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertLinalgToLLVMBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertLinalgToLLVMBase(const ConvertLinalgToLLVMBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-linalg-to-llvm"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertLinalgToLLVM"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertLinalgToSPIRV
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertLinalgToSPIRVBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertLinalgToSPIRVBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertLinalgToSPIRVBase(const ConvertLinalgToSPIRVBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-linalg-to-spirv"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertLinalgToSPIRV"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertLinalgToStandard
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertLinalgToStandardBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertLinalgToStandardBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertLinalgToStandardBase(const ConvertLinalgToStandardBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-linalg-to-std"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertLinalgToStandard"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertParallelLoopToGpu
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertParallelLoopToGpuBase : public ::mlir::OperationPass<> {
public:
  ConvertParallelLoopToGpuBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertParallelLoopToGpuBase(const ConvertParallelLoopToGpuBase &) : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-parallel-loops-to-gpu"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertParallelLoopToGpu"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertSPIRVToLLVM
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertSPIRVToLLVMBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertSPIRVToLLVMBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertSPIRVToLLVMBase(const ConvertSPIRVToLLVMBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-spirv-to-llvm"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertSPIRVToLLVM"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertShapeToSCF
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertShapeToSCFBase : public ::mlir::FunctionPass {
public:
  ConvertShapeToSCFBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  ConvertShapeToSCFBase(const ConvertShapeToSCFBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-shape-to-scf"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertShapeToSCF"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertShapeToStandard
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertShapeToStandardBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertShapeToStandardBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertShapeToStandardBase(const ConvertShapeToStandardBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-shape-to-std"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertShapeToStandard"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertStandardToLLVM
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertStandardToLLVMBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertStandardToLLVMBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertStandardToLLVMBase(const ConvertStandardToLLVMBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-std-to-llvm"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertStandardToLLVM"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
  Pass::Option<bool> useAlignedAlloc{*this, "use-aligned-alloc", llvm::cl::desc("Use aligned_alloc in place of malloc for heap allocations"), llvm::cl::init(false)};
  Pass::Option<bool> useBarePtrCallConv{*this, "use-bare-ptr-memref-call-conv", llvm::cl::desc("Replace FuncOp's MemRef arguments with bare pointers to the MemRef element types"), llvm::cl::init(false)};
  Pass::Option<bool> emitCWrappers{*this, "emit-c-wrappers", llvm::cl::desc("Emit wrappers for C-compatible pointer-to-struct memref descriptors"), llvm::cl::init(false)};
  Pass::Option<unsigned> indexBitwidth{*this, "index-bitwidth", llvm::cl::desc("Bitwidth of the index type, 0 to use size of machine word"), llvm::cl::init(0)};
};

//===----------------------------------------------------------------------===//
// ConvertStandardToSPIRV
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertStandardToSPIRVBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertStandardToSPIRVBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertStandardToSPIRVBase(const ConvertStandardToSPIRVBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-std-to-spirv"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertStandardToSPIRV"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertVectorToLLVM
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertVectorToLLVMBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertVectorToLLVMBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertVectorToLLVMBase(const ConvertVectorToLLVMBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-vector-to-llvm"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertVectorToLLVM"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertVectorToROCDL
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertVectorToROCDLBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertVectorToROCDLBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertVectorToROCDLBase(const ConvertVectorToROCDLBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-vector-to-rocdl"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertVectorToROCDL"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertVectorToSCF
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertVectorToSCFBase : public ::mlir::FunctionPass {
public:
  ConvertVectorToSCFBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  ConvertVectorToSCFBase(const ConvertVectorToSCFBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-vector-to-scf"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertVectorToSCF"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
  Pass::Option<bool> fullUnroll{*this, "full-unroll", llvm::cl::desc("Perform full unrolling when converting vector transfers to SCF"), llvm::cl::init(false)};
};

//===----------------------------------------------------------------------===//
// ConvertVulkanLaunchFuncToVulkanCalls
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertVulkanLaunchFuncToVulkanCallsBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertVulkanLaunchFuncToVulkanCallsBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertVulkanLaunchFuncToVulkanCallsBase(const ConvertVulkanLaunchFuncToVulkanCallsBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "launch-func-to-vulkan"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "ConvertVulkanLaunchFuncToVulkanCalls"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// LegalizeStandardForSPIRV
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LegalizeStandardForSPIRVBase : public ::mlir::OperationPass<> {
public:
  LegalizeStandardForSPIRVBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  LegalizeStandardForSPIRVBase(const LegalizeStandardForSPIRVBase &) : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "legalize-std-for-spirv"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "LegalizeStandardForSPIRV"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};

//===----------------------------------------------------------------------===//
// SCFToStandard
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class SCFToStandardBase : public ::mlir::OperationPass<> {
public:
  SCFToStandardBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  SCFToStandardBase(const SCFToStandardBase &) : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  llvm::StringRef getArgument() const override { return "convert-scf-to-std"; }

  /// Returns the derived pass name.
  llvm::StringRef getName() const override { return "SCFToStandard"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

protected:
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
#ifdef GEN_PASS_REGISTRATION
#define GEN_PASS_REGISTRATION_ConvertAVX512ToLLVM
#define GEN_PASS_REGISTRATION_ConvertAffineForToGPU
#define GEN_PASS_REGISTRATION_ConvertAffineToStandard
#define GEN_PASS_REGISTRATION_ConvertGPUToSPIRV
#define GEN_PASS_REGISTRATION_ConvertGpuLaunchFuncToGpuRuntimeCalls
#define GEN_PASS_REGISTRATION_ConvertGpuLaunchFuncToVulkanLaunchFunc
#define GEN_PASS_REGISTRATION_ConvertGpuOpsToNVVMOps
#define GEN_PASS_REGISTRATION_ConvertGpuOpsToROCDLOps
#define GEN_PASS_REGISTRATION_ConvertLinalgToLLVM
#define GEN_PASS_REGISTRATION_ConvertLinalgToSPIRV
#define GEN_PASS_REGISTRATION_ConvertLinalgToStandard
#define GEN_PASS_REGISTRATION_ConvertParallelLoopToGpu
#define GEN_PASS_REGISTRATION_ConvertSPIRVToLLVM
#define GEN_PASS_REGISTRATION_ConvertShapeToSCF
#define GEN_PASS_REGISTRATION_ConvertShapeToStandard
#define GEN_PASS_REGISTRATION_ConvertStandardToLLVM
#define GEN_PASS_REGISTRATION_ConvertStandardToSPIRV
#define GEN_PASS_REGISTRATION_ConvertVectorToLLVM
#define GEN_PASS_REGISTRATION_ConvertVectorToROCDL
#define GEN_PASS_REGISTRATION_ConvertVectorToSCF
#define GEN_PASS_REGISTRATION_ConvertVulkanLaunchFuncToVulkanCalls
#define GEN_PASS_REGISTRATION_LegalizeStandardForSPIRV
#define GEN_PASS_REGISTRATION_SCFToStandard
#endif // GEN_PASS_REGISTRATION
#ifdef GEN_PASS_REGISTRATION_ConvertAVX512ToLLVM
::mlir::registerPass("convert-avx512-to-llvm", "Convert the operations from the avx512 dialect into the LLVM dialect", []() -> std::unique_ptr<Pass> { return mlir::createConvertAVX512ToLLVMPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertAVX512ToLLVM
#undef GEN_PASS_REGISTRATION_ConvertAVX512ToLLVM
#ifdef GEN_PASS_REGISTRATION_ConvertAffineForToGPU
::mlir::registerPass("convert-affine-for-to-gpu", "Convert top-level AffineFor Ops to GPU kernels", []() -> std::unique_ptr<Pass> { return mlir::createAffineForToGPUPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertAffineForToGPU
#undef GEN_PASS_REGISTRATION_ConvertAffineForToGPU
#ifdef GEN_PASS_REGISTRATION_ConvertAffineToStandard
::mlir::registerPass("lower-affine", "Lower Affine operations to a combination of Standard and SCF operations", []() -> std::unique_ptr<Pass> { return mlir::createLowerAffinePass(); });
#endif // GEN_PASS_REGISTRATION_ConvertAffineToStandard
#undef GEN_PASS_REGISTRATION_ConvertAffineToStandard
#ifdef GEN_PASS_REGISTRATION_ConvertGPUToSPIRV
::mlir::registerPass("convert-gpu-to-spirv", "Convert GPU dialect to SPIR-V dialect", []() -> std::unique_ptr<Pass> { return mlir::createConvertGPUToSPIRVPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertGPUToSPIRV
#undef GEN_PASS_REGISTRATION_ConvertGPUToSPIRV
#ifdef GEN_PASS_REGISTRATION_ConvertGpuLaunchFuncToGpuRuntimeCalls
::mlir::registerPass("launch-func-to-gpu-runtime", "Convert all launch_func ops to GPU runtime calls", []() -> std::unique_ptr<Pass> { return mlir::createConvertGpuLaunchFuncToGpuRuntimeCallsPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertGpuLaunchFuncToGpuRuntimeCalls
#undef GEN_PASS_REGISTRATION_ConvertGpuLaunchFuncToGpuRuntimeCalls
#ifdef GEN_PASS_REGISTRATION_ConvertGpuLaunchFuncToVulkanLaunchFunc
::mlir::registerPass("convert-gpu-launch-to-vulkan-launch", "Convert gpu.launch_func to vulkanLaunch external call", []() -> std::unique_ptr<Pass> { return mlir::createConvertGpuLaunchFuncToVulkanLaunchFuncPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertGpuLaunchFuncToVulkanLaunchFunc
#undef GEN_PASS_REGISTRATION_ConvertGpuLaunchFuncToVulkanLaunchFunc
#ifdef GEN_PASS_REGISTRATION_ConvertGpuOpsToNVVMOps
::mlir::registerPass("convert-gpu-to-nvvm", "Generate NVVM operations for gpu operations", []() -> std::unique_ptr<Pass> { return mlir::createLowerGpuOpsToNVVMOpsPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertGpuOpsToNVVMOps
#undef GEN_PASS_REGISTRATION_ConvertGpuOpsToNVVMOps
#ifdef GEN_PASS_REGISTRATION_ConvertGpuOpsToROCDLOps
::mlir::registerPass("convert-gpu-to-rocdl", "Generate ROCDL operations for gpu operations", []() -> std::unique_ptr<Pass> { return mlir::createLowerGpuOpsToROCDLOpsPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertGpuOpsToROCDLOps
#undef GEN_PASS_REGISTRATION_ConvertGpuOpsToROCDLOps
#ifdef GEN_PASS_REGISTRATION_ConvertLinalgToLLVM
::mlir::registerPass("convert-linalg-to-llvm", "Convert the operations from the linalg dialect into the LLVM dialect", []() -> std::unique_ptr<Pass> { return mlir::createConvertLinalgToLLVMPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertLinalgToLLVM
#undef GEN_PASS_REGISTRATION_ConvertLinalgToLLVM
#ifdef GEN_PASS_REGISTRATION_ConvertLinalgToSPIRV
::mlir::registerPass("convert-linalg-to-spirv", "Convert Linalg ops to SPIR-V ops", []() -> std::unique_ptr<Pass> { return mlir::createLinalgToSPIRVPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertLinalgToSPIRV
#undef GEN_PASS_REGISTRATION_ConvertLinalgToSPIRV
#ifdef GEN_PASS_REGISTRATION_ConvertLinalgToStandard
::mlir::registerPass("convert-linalg-to-std", "Convert the operations from the linalg dialect into the Standard dialect", []() -> std::unique_ptr<Pass> { return mlir::createConvertLinalgToStandardPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertLinalgToStandard
#undef GEN_PASS_REGISTRATION_ConvertLinalgToStandard
#ifdef GEN_PASS_REGISTRATION_ConvertParallelLoopToGpu
::mlir::registerPass("convert-parallel-loops-to-gpu", "Convert mapped scf.parallel ops to gpu launch operations", []() -> std::unique_ptr<Pass> { return mlir::createParallelLoopToGpuPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertParallelLoopToGpu
#undef GEN_PASS_REGISTRATION_ConvertParallelLoopToGpu
#ifdef GEN_PASS_REGISTRATION_ConvertSPIRVToLLVM
::mlir::registerPass("convert-spirv-to-llvm", "Convert SPIR-V dialect to LLVM dialect", []() -> std::unique_ptr<Pass> { return mlir::createConvertSPIRVToLLVMPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertSPIRVToLLVM
#undef GEN_PASS_REGISTRATION_ConvertSPIRVToLLVM
#ifdef GEN_PASS_REGISTRATION_ConvertShapeToSCF
::mlir::registerPass("convert-shape-to-scf", "Convert operations from the shape dialect to the SCF dialect", []() -> std::unique_ptr<Pass> { return mlir::createConvertShapeToSCFPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertShapeToSCF
#undef GEN_PASS_REGISTRATION_ConvertShapeToSCF
#ifdef GEN_PASS_REGISTRATION_ConvertShapeToStandard
::mlir::registerPass("convert-shape-to-std", "Convert operations from the shape dialect into the standard dialect", []() -> std::unique_ptr<Pass> { return mlir::createConvertShapeToStandardPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertShapeToStandard
#undef GEN_PASS_REGISTRATION_ConvertShapeToStandard
#ifdef GEN_PASS_REGISTRATION_ConvertStandardToLLVM
::mlir::registerPass("convert-std-to-llvm", "Convert scalar and vector operations from the Standard to the LLVM dialect", []() -> std::unique_ptr<Pass> { return mlir::createLowerToLLVMPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertStandardToLLVM
#undef GEN_PASS_REGISTRATION_ConvertStandardToLLVM
#ifdef GEN_PASS_REGISTRATION_ConvertStandardToSPIRV
::mlir::registerPass("convert-std-to-spirv", "Convert Standard Ops to SPIR-V dialect", []() -> std::unique_ptr<Pass> { return mlir::createConvertStandardToSPIRVPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertStandardToSPIRV
#undef GEN_PASS_REGISTRATION_ConvertStandardToSPIRV
#ifdef GEN_PASS_REGISTRATION_ConvertVectorToLLVM
::mlir::registerPass("convert-vector-to-llvm", "Lower the operations from the vector dialect into the LLVM dialect", []() -> std::unique_ptr<Pass> { return mlir::createConvertVectorToLLVMPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertVectorToLLVM
#undef GEN_PASS_REGISTRATION_ConvertVectorToLLVM
#ifdef GEN_PASS_REGISTRATION_ConvertVectorToROCDL
::mlir::registerPass("convert-vector-to-rocdl", "Lower the operations from the vector dialect into the ROCDL dialect", []() -> std::unique_ptr<Pass> { return mlir::createConvertVectorToROCDLPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertVectorToROCDL
#undef GEN_PASS_REGISTRATION_ConvertVectorToROCDL
#ifdef GEN_PASS_REGISTRATION_ConvertVectorToSCF
::mlir::registerPass("convert-vector-to-scf", "Lower the operations from the vector dialect into the SCF dialect", []() -> std::unique_ptr<Pass> { return mlir::createConvertVectorToSCFPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertVectorToSCF
#undef GEN_PASS_REGISTRATION_ConvertVectorToSCF
#ifdef GEN_PASS_REGISTRATION_ConvertVulkanLaunchFuncToVulkanCalls
::mlir::registerPass("launch-func-to-vulkan", "Convert vulkanLaunch external call to Vulkan runtime external calls", []() -> std::unique_ptr<Pass> { return mlir::createConvertVulkanLaunchFuncToVulkanCallsPass(); });
#endif // GEN_PASS_REGISTRATION_ConvertVulkanLaunchFuncToVulkanCalls
#undef GEN_PASS_REGISTRATION_ConvertVulkanLaunchFuncToVulkanCalls
#ifdef GEN_PASS_REGISTRATION_LegalizeStandardForSPIRV
::mlir::registerPass("legalize-std-for-spirv", "Legalize standard ops for SPIR-V lowering", []() -> std::unique_ptr<Pass> { return mlir::createLegalizeStdOpsForSPIRVLoweringPass(); });
#endif // GEN_PASS_REGISTRATION_LegalizeStandardForSPIRV
#undef GEN_PASS_REGISTRATION_LegalizeStandardForSPIRV
#ifdef GEN_PASS_REGISTRATION_SCFToStandard
::mlir::registerPass("convert-scf-to-std", "Convert SCF dialect to Standard dialect, replacing structured control flow with a CFG", []() -> std::unique_ptr<Pass> { return mlir::createLowerToCFGPass(); });
#endif // GEN_PASS_REGISTRATION_SCFToStandard
#undef GEN_PASS_REGISTRATION_SCFToStandard
#ifdef GEN_PASS_REGISTRATION
#undef GEN_PASS_REGISTRATION_ConvertAVX512ToLLVM
#undef GEN_PASS_REGISTRATION_ConvertAffineForToGPU
#undef GEN_PASS_REGISTRATION_ConvertAffineToStandard
#undef GEN_PASS_REGISTRATION_ConvertGPUToSPIRV
#undef GEN_PASS_REGISTRATION_ConvertGpuLaunchFuncToGpuRuntimeCalls
#undef GEN_PASS_REGISTRATION_ConvertGpuLaunchFuncToVulkanLaunchFunc
#undef GEN_PASS_REGISTRATION_ConvertGpuOpsToNVVMOps
#undef GEN_PASS_REGISTRATION_ConvertGpuOpsToROCDLOps
#undef GEN_PASS_REGISTRATION_ConvertLinalgToLLVM
#undef GEN_PASS_REGISTRATION_ConvertLinalgToSPIRV
#undef GEN_PASS_REGISTRATION_ConvertLinalgToStandard
#undef GEN_PASS_REGISTRATION_ConvertParallelLoopToGpu
#undef GEN_PASS_REGISTRATION_ConvertSPIRVToLLVM
#undef GEN_PASS_REGISTRATION_ConvertShapeToSCF
#undef GEN_PASS_REGISTRATION_ConvertShapeToStandard
#undef GEN_PASS_REGISTRATION_ConvertStandardToLLVM
#undef GEN_PASS_REGISTRATION_ConvertStandardToSPIRV
#undef GEN_PASS_REGISTRATION_ConvertVectorToLLVM
#undef GEN_PASS_REGISTRATION_ConvertVectorToROCDL
#undef GEN_PASS_REGISTRATION_ConvertVectorToSCF
#undef GEN_PASS_REGISTRATION_ConvertVulkanLaunchFuncToVulkanCalls
#undef GEN_PASS_REGISTRATION_LegalizeStandardForSPIRV
#undef GEN_PASS_REGISTRATION_SCFToStandard
#endif // GEN_PASS_REGISTRATION
#undef GEN_PASS_REGISTRATION
