"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.flinkApplicationConfiguration = flinkApplicationConfiguration;
/**
 * Build the nested Cfn FlinkApplicationConfiguration object. This function
 * doesn't return empty config objects, returning the minimal config needed to
 * express the supplied properties.
 *
 * This function also handles the quirky configType: 'CUSTOM' setting required
 * whenever config in one of the nested groupings.
 */
function flinkApplicationConfiguration(config) {
    const checkpointConfiguration = configFor({
        checkpointingEnabled: config.checkpointingEnabled,
        checkpointInterval: config.checkpointInterval?.toMilliseconds(),
        minPauseBetweenCheckpoints: config.minPauseBetweenCheckpoints?.toMilliseconds(),
    });
    const monitoringConfiguration = configFor({
        logLevel: config.logLevel,
        metricsLevel: config.metricsLevel,
    });
    const parallelismConfiguration = configFor({
        autoScalingEnabled: config.autoScalingEnabled,
        parallelism: config.parallelism,
        parallelismPerKpu: config.parallelismPerKpu,
    });
    const applicationConfiguration = {
        checkpointConfiguration,
        monitoringConfiguration,
        parallelismConfiguration,
    };
    if (isEmptyObj(applicationConfiguration)) {
        return;
    }
    return applicationConfiguration;
}
function configFor(config) {
    if (isEmptyObj(config)) {
        return;
    }
    return {
        ...config,
        configurationType: 'CUSTOM',
    };
}
function isEmptyObj(obj) {
    return Object.values(obj).every(v => v === undefined);
}
//# sourceMappingURL=data:application/json;base64,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