# coding: utf-8

"""
    FINBOURNE Scheduler API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 0.0.615
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from lusid_scheduler.configuration import Configuration


class UploadImageRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
      required_map (dict): The key is attribute name
                           and the value is whether it is 'required' or 'optional'.
    """
    openapi_types = {
        'image_name': 'str'
    }

    attribute_map = {
        'image_name': 'imageName'
    }

    required_map = {
        'image_name': 'required'
    }

    def __init__(self, image_name=None, local_vars_configuration=None):  # noqa: E501
        """UploadImageRequest - a model defined in OpenAPI"
        
        :param image_name:  Name of the image to be uploaded (required)
        :type image_name: str

        """  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._image_name = None
        self.discriminator = None

        self.image_name = image_name

    @property
    def image_name(self):
        """Gets the image_name of this UploadImageRequest.  # noqa: E501

        Name of the image to be uploaded  # noqa: E501

        :return: The image_name of this UploadImageRequest.  # noqa: E501
        :rtype: str
        """
        return self._image_name

    @image_name.setter
    def image_name(self, image_name):
        """Sets the image_name of this UploadImageRequest.

        Name of the image to be uploaded  # noqa: E501

        :param image_name: The image_name of this UploadImageRequest.  # noqa: E501
        :type image_name: str
        """
        if self.local_vars_configuration.client_side_validation and image_name is None:  # noqa: E501
            raise ValueError("Invalid value for `image_name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                image_name is not None and len(image_name) > 256):
            raise ValueError("Invalid value for `image_name`, length must be less than or equal to `256`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                image_name is not None and len(image_name) < 1):
            raise ValueError("Invalid value for `image_name`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                image_name is not None and not re.search(r'^[a-z\d]+((([.]{1}|[_]{1,2}|[-])+)([a-z\d]+))*:[a-z\d]+((([.]{1}|[_]{1,2}|[-])+)([a-z\d]+))*$', image_name)):  # noqa: E501
            raise ValueError(r"Invalid value for `image_name`, must be a follow pattern or equal to `/^[a-z\d]+((([.]{1}|[_]{1,2}|[-])+)([a-z\d]+))*:[a-z\d]+((([.]{1}|[_]{1,2}|[-])+)([a-z\d]+))*$/`")  # noqa: E501

        self._image_name = image_name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UploadImageRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UploadImageRequest):
            return True

        return self.to_dict() != other.to_dict()
