/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.cmd;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.siemens.ct.exi.main.cmd.BuiltInSchema;
import com.siemens.ct.exi.main.cmd.DocumentSource;
import com.siemens.ct.exi.main.messages.iso15118_2.V2G_Message;
import java.util.HashSet;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONConformance {
    private static final JSONConformance instance = new JSONConformance();
    private HashSet<String> nonConformantMessages_15118_2_Encoding;
    private HashSet<String> nonConformantMessages_15118_2_Decoding;
    private HashSet<String> nonConformantHeader_15118_2_Encoding;
    private HashSet<String> nonConformantHeader_15118_2_Decoding;
    private HashSet<String> nonConformant_15118_20_Encoding;
    private HashSet<String> nonConformant_15118_20_Decoding;
    private ObjectMapper mapper = new ObjectMapper();
    private String supportedAppProtocolReqMessage = "supportedAppProtocolReq";
    private String supportedAppProtocolResMessage = "supportedAppProtocolRes";
    private String encodeConformPackage = "com.siemens.ct.exi.main.conformhelpers.encode.";
    private String decodeConformPackage = "com.siemens.ct.exi.main.conformhelpers.decode.";
    private String encodeConformPackage_20 = "com.siemens.ct.exi.main.conformhelpers.encode_20.";
    private String decodeConformPackage_20 = "com.siemens.ct.exi.main.conformhelpers.decode_20.";

    public static JSONConformance getInstance() {
        return instance;
    }

    private JSONConformance() {
        this.nonConformantMessages_15118_2_Encoding = new HashSet();
        this.nonConformantMessages_15118_2_Encoding.add("ServiceDiscoveryRes");
        this.nonConformantMessages_15118_2_Encoding.add("ChargeParameterDiscoveryRes");
        this.nonConformantMessages_15118_2_Encoding.add("PowerDeliveryReq");
        this.nonConformantMessages_15118_2_Encoding.add("PaymentDetailsReq");
        this.nonConformantMessages_15118_2_Encoding.add("SignedInfo");
        this.nonConformantMessages_15118_2_Encoding.add("CertificateInstallationRes");
        this.nonConformantMessages_15118_2_Encoding.add("CertificateInstallationReq");
        this.nonConformantMessages_15118_2_Decoding = new HashSet();
        this.nonConformantMessages_15118_2_Decoding.add("ServiceDiscoveryRes");
        this.nonConformantMessages_15118_2_Decoding.add("ChargeParameterDiscoveryRes");
        this.nonConformantMessages_15118_2_Decoding.add("PowerDeliveryReq");
        this.nonConformantMessages_15118_2_Decoding.add("PaymentDetailsReq");
        this.nonConformantMessages_15118_2_Decoding.add("SignedInfo");
        this.nonConformantMessages_15118_2_Decoding.add("CertificateInstallationRes");
        this.nonConformantMessages_15118_2_Decoding.add("CertificateInstallationReq");
        this.nonConformantHeader_15118_2_Encoding = new HashSet();
        this.nonConformantHeader_15118_2_Encoding.add("AuthorizationReq");
        this.nonConformantHeader_15118_2_Encoding.add("CertificateInstallationRes");
        this.nonConformantHeader_15118_2_Encoding.add("CertificateInstallationReq");
        this.nonConformantHeader_15118_2_Encoding.add("ChargeParameterDiscoveryRes");
        this.nonConformantHeader_15118_2_Encoding.add("MeteringReceiptReq");
        this.nonConformantHeader_15118_2_Decoding = new HashSet();
        this.nonConformantHeader_15118_2_Decoding.add("AuthorizationReq");
        this.nonConformantHeader_15118_2_Decoding.add("CertificateInstallationRes");
        this.nonConformantHeader_15118_2_Decoding.add("CertificateInstallationReq");
        this.nonConformantHeader_15118_2_Decoding.add("ChargeParameterDiscoveryRes");
        this.nonConformantHeader_15118_2_Decoding.add("MeteringReceiptReq");
        this.nonConformant_15118_20_Encoding = new HashSet();
        this.nonConformant_15118_20_Encoding.add("CertificateInstallationReq");
        this.nonConformant_15118_20_Encoding.add("CertificateInstallationRes");
        this.nonConformant_15118_20_Decoding = new HashSet();
        this.nonConformant_15118_20_Decoding.add("CertificateInstallationReq");
        this.nonConformant_15118_20_Decoding.add("CertificateInstallationRes");
        this.mapper = new ObjectMapper();
    }

    public String GetModifiedSignedInfo(String json, DocumentSource jsonSource) throws ClassNotFoundException, JsonMappingException, JsonProcessingException {
        String messageType = "SignedInfo";
        if (jsonSource == DocumentSource.BeforeEncode) {
            if (this.nonConformantMessages_15118_2_Encoding.contains(messageType)) {
                Class<?> classObj = Class.forName(String.valueOf(this.encodeConformPackage) + messageType);
                Object object = this.mapper.readValue(json.toString(), classObj);
                String modifiedSignedInfo = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
                return modifiedSignedInfo;
            }
        } else if (this.nonConformantMessages_15118_2_Decoding.contains(messageType)) {
            Class<?> classObj = Class.forName(String.valueOf(this.decodeConformPackage) + messageType);
            Object object = this.mapper.readValue(json.toString(), classObj);
            String modifiedSignedInfo = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
            return modifiedSignedInfo;
        }
        return json;
    }

    public String checkConformance(String json, BuiltInSchema schema, DocumentSource jsonSource) throws ClassNotFoundException, JsonMappingException, JsonProcessingException {
        String messageType = this.GetMessageType(json);
        if (messageType.equals("SignedInfo")) {
            return this.GetModifiedSignedInfo(json, jsonSource);
        }
        if (messageType.equals(this.supportedAppProtocolReqMessage) || messageType.equals(this.supportedAppProtocolResMessage)) {
            return json;
        }
        if (jsonSource == DocumentSource.BeforeEncode) {
            if (schema == BuiltInSchema.ISO15118_2) {
                if (this.IsV2GMessage(json)) {
                    if (this.nonConformantHeader_15118_2_Encoding.contains(messageType)) {
                        json = this.GetModifiedHeader(json, DocumentSource.BeforeEncode);
                    }
                    if (this.nonConformantMessages_15118_2_Encoding.contains(messageType)) {
                        Class<?> classObj = Class.forName(String.valueOf(this.encodeConformPackage) + messageType);
                        json = this.GetModifiedPayload(classObj, json, DocumentSource.BeforeEncode);
                    }
                } else if (this.nonConformantMessages_15118_2_Encoding.contains(messageType)) {
                    Class<?> classObj = Class.forName(String.valueOf(this.encodeConformPackage) + messageType);
                    JSONObject obj = new JSONObject(json);
                    json = this.GetModifiedContent(classObj, obj.getJSONObject(messageType).toString());
                    json = obj.put(messageType, new JSONObject(json)).toString();
                }
            } else if (this.nonConformant_15118_20_Encoding.contains(messageType)) {
                Class<?> classObj = Class.forName(String.valueOf(this.encodeConformPackage_20) + messageType);
                json = this.GetModified_ISO15118_20_JSON(classObj, json, messageType, DocumentSource.BeforeEncode);
            }
        } else if (jsonSource == DocumentSource.AfterDecode) {
            if (schema == BuiltInSchema.ISO15118_2) {
                if (this.IsV2GMessage(json)) {
                    if (this.nonConformantHeader_15118_2_Decoding.contains(messageType)) {
                        json = this.GetModifiedHeader(json, DocumentSource.AfterDecode);
                    }
                    if (this.nonConformantMessages_15118_2_Decoding.contains(messageType)) {
                        Class<?> classObj = Class.forName(String.valueOf(this.decodeConformPackage) + messageType);
                        json = this.GetModifiedPayload(classObj, json, DocumentSource.AfterDecode);
                    }
                } else if (this.nonConformantMessages_15118_2_Decoding.contains(messageType)) {
                    Class<?> classObj = Class.forName(String.valueOf(this.decodeConformPackage) + messageType);
                    JSONObject obj = new JSONObject(json);
                    json = this.GetModifiedContent(classObj, obj.getJSONObject(messageType).toString());
                    json = obj.put(messageType, new JSONObject(json)).toString();
                }
            } else {
                if (this.nonConformant_15118_20_Decoding.contains(messageType)) {
                    Class<?> classObj = Class.forName(String.valueOf(this.decodeConformPackage_20) + messageType);
                    json = this.GetModified_ISO15118_20_JSON(classObj, json, messageType, DocumentSource.AfterDecode);
                }
                json = this.confirmHeaderCompatibility_15118_20(json, messageType);
            }
        }
        return json;
    }

    private String GetModified_ISO15118_20_JSON(Class<?> classObj, String json, String messageType, DocumentSource jsonSource) throws JsonMappingException, JsonProcessingException, JSONException, ClassNotFoundException {
        Object object = this.mapper.readValue(json, classObj);
        String modifiedContent = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        JSONObject jo = new JSONObject();
        jo.put(messageType, new JSONObject(modifiedContent));
        return jo.toString();
    }

    private String confirmHeaderCompatibility_15118_20(String json, String messageType) throws JsonMappingException, JsonProcessingException {
        JsonNode full_message = new ObjectMapper().readTree(json);
        if (full_message.has(messageType)) {
            JsonNode signedInfo;
            JsonNode signature;
            JsonNode header;
            JsonNode messageBody = full_message.get(messageType);
            if (messageBody.has("Header") && (header = messageBody.get("Header")).has("Signature") && (signature = header.get("Signature")).has("SignedInfo") && (signedInfo = signature.get("SignedInfo")).has("Reference")) {
                JsonNode referenceArr = signedInfo.get("Reference");
                for (JsonNode ref : referenceArr) {
                    JsonNode transforms;
                    if (!((ObjectNode)ref).has("Transforms") || !(transforms = ((ObjectNode)ref).get("Transforms")).has("Transform")) continue;
                    JsonNode transformArr = ((ObjectNode)transforms).get("Transform");
                    ObjectMapper om = new ObjectMapper();
                    ObjectNode on = om.createObjectNode();
                    ArrayNode an = on.arrayNode();
                    for (JsonNode transform : transformArr) {
                        ObjectNode jo = om.createObjectNode();
                        jo.replace("Transform", transform);
                        an.add(jo);
                    }
                    ((ObjectNode)ref).replace("Transforms", an);
                }
                ((ObjectNode)signedInfo).replace("Reference", referenceArr);
            }
            json = full_message.toString();
        }
        return json;
    }

    private String GetModifiedContent(Class<?> classObj, String json) throws JsonMappingException, JsonProcessingException, JSONException, ClassNotFoundException {
        Object object = this.mapper.readValue(json, classObj);
        String modifiedBodyContent = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        return modifiedBodyContent;
    }

    private String GetModifiedPayload(Class<?> classObj, String json, DocumentSource jsonSource) throws JsonMappingException, JsonProcessingException, JSONException, ClassNotFoundException {
        JSONObject messageContent = this.ExtractBodyContent(json);
        String modifiedBodyContent = this.GetModifiedContent(classObj, messageContent.toString());
        String modifiedPayload = this.ReplaceBodyContent(json, new JSONObject(modifiedBodyContent));
        return modifiedPayload;
    }

    private String GetMessageType(String json) {
        JSONObject jsonobj;
        try {
            jsonobj = new JSONObject(json);
            if (jsonobj.has("SignedInfo")) {
                return "SignedInfo";
            }
        }
        catch (Exception ae) {
            return json;
        }
        try {
            jsonobj = new JSONObject(json);
            if (jsonobj.has(V2G_Message.class.getSimpleName())) {
                JSONObject jo = this.GetMessageBody(json);
                return jo.names().getString(0);
            }
        }
        catch (Exception ae) {
            return json;
        }
        try {
            jsonobj = new JSONObject(json);
            return jsonobj.names().getString(0);
        }
        catch (Exception ae) {
            return json;
        }
    }

    private boolean IsV2GMessage(String json) {
        try {
            JSONObject jsonobj = new JSONObject(json);
            return jsonobj.has(V2G_Message.class.getSimpleName());
        }
        catch (Exception ae) {
            return false;
        }
    }

    private JSONObject GetMessageHeader(String json, DocumentSource jsonSource) throws ClassNotFoundException, JsonMappingException, JsonProcessingException {
        JSONObject jo = new JSONObject(json);
        JSONObject header = new JSONObject();
        if (jo.has(V2G_Message.class.getSimpleName())) {
            JSONObject fullMessage = jo.getJSONObject(V2G_Message.class.getSimpleName());
            header = fullMessage.getJSONObject("Header");
            String messageType = this.GetMessageType(json);
            if (jsonSource == DocumentSource.BeforeEncode) {
                if (this.nonConformantHeader_15118_2_Encoding.contains(messageType) && header.has("Signature")) {
                    JSONObject signedInfo = header.getJSONObject("Signature");
                    Class<?> classObj = Class.forName(String.valueOf(this.encodeConformPackage) + "SignedInfo");
                    Object object = this.mapper.readValue(signedInfo.toString(), classObj);
                    String modifiedSignedInfo = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
                    JSONObject moddSignedInfo = new JSONObject(modifiedSignedInfo);
                    signedInfo.put("SignedInfo", moddSignedInfo.get("SignedInfo"));
                    header.put("Signature", signedInfo);
                }
            } else if (jsonSource == DocumentSource.AfterDecode && this.nonConformantHeader_15118_2_Decoding.contains(messageType) && header.has("Signature")) {
                JSONObject signedInfo = header.getJSONObject("Signature");
                Class<?> classObj = Class.forName(String.valueOf(this.decodeConformPackage) + "SignedInfo");
                Object object = this.mapper.readValue(signedInfo.toString(), classObj);
                String modifiedSignedInfo = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
                JSONObject moddSignedInfo = new JSONObject(modifiedSignedInfo);
                signedInfo.put("SignedInfo", moddSignedInfo.get("SignedInfo"));
                header.put("Signature", signedInfo);
            }
        }
        return header;
    }

    private JSONObject GetMessageBody(String json) {
        JSONObject jo = new JSONObject(json);
        JSONObject body = new JSONObject();
        if (jo.has(V2G_Message.class.getSimpleName())) {
            JSONObject fullMessage = jo.getJSONObject(V2G_Message.class.getSimpleName());
            body = fullMessage.getJSONObject("Body");
        }
        return body;
    }

    private JSONObject ExtractBodyContent(String json) {
        JSONObject body = this.GetMessageBody(json);
        String messageType = this.GetMessageType(json);
        return body.getJSONObject(messageType);
    }

    private JSONObject GetCurrentHeader(String json) {
        JSONObject full_message = new JSONObject(json);
        JSONObject v2g_message = full_message.getJSONObject(V2G_Message.class.getSimpleName());
        return v2g_message.getJSONObject("Header");
    }

    private String ReplaceBodyContent(String json, JSONObject modifiedBodyContent) throws JsonMappingException, JSONException, ClassNotFoundException, JsonProcessingException {
        JSONObject header_body = new JSONObject();
        JSONObject jo = new JSONObject();
        String messageType = this.GetMessageType(json);
        jo = jo.put(messageType, modifiedBodyContent);
        header_body.put("Header", this.GetCurrentHeader(json));
        header_body.put("Body", jo);
        JSONObject full_message = new JSONObject();
        full_message.put(V2G_Message.class.getSimpleName(), header_body);
        return full_message.toString();
    }

    private String GetModifiedHeader(String json, DocumentSource jsonSource) throws JsonMappingException, JSONException, ClassNotFoundException, JsonProcessingException {
        JSONObject header_body = new JSONObject();
        header_body.put("Body", this.GetMessageBody(json));
        header_body.put("Header", this.GetMessageHeader(json, jsonSource));
        JSONObject full_message = new JSONObject();
        full_message.put(V2G_Message.class.getSimpleName(), header_body);
        return full_message.toString();
    }
}

