# coding: utf-8

"""
    Street Manager API

    See API specification Resource Guide > Work API for more information on endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ..api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def acknowledge_hs2_permit(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """acknowledge_hs2_permit  # noqa: E501

        Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.acknowledge_hs2_permit(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HS2AcknowledgementRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.acknowledge_hs2_permit_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.acknowledge_hs2_permit_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
            return data

    def acknowledge_hs2_permit_with_http_info(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """acknowledge_hs2_permit  # noqa: E501

        Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.acknowledge_hs2_permit_with_http_info(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HS2AcknowledgementRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method acknowledge_hs2_permit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `acknowledge_hs2_permit`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `acknowledge_hs2_permit`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `acknowledge_hs2_permit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/hs2_acknowledgement', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_file_to_work(self, body, work_reference_number, **kwargs):  # noqa: E501
        """add_file_to_work  # noqa: E501

        See API specification Resource Guide > Works API > File upload for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_file_to_work(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddFileToWorkRequest body: (required)
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_file_to_work_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.add_file_to_work_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
            return data

    def add_file_to_work_with_http_info(self, body, work_reference_number, **kwargs):  # noqa: E501
        """add_file_to_work  # noqa: E501

        See API specification Resource Guide > Works API > File upload for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_file_to_work_with_http_info(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddFileToWorkRequest body: (required)
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_file_to_work" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_file_to_work`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `add_file_to_work`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/files', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def authenticate(self, body, **kwargs):  # noqa: E501
        """authenticate  # noqa: E501

        If authenticating for the first time with a temporary password, a 307 Temporary Redirect to `/authenticate/initial` will be returned, which can be called with the same request body.  A sessionToken property may be returned from this redirect endpoint, which can be used to set a permanent password with the `/set-password` endpoint on the Party API.  See API specification Security section for more information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.authenticate(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthenticationRequest body: (required)
        :return: AuthenticationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.authenticate_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.authenticate_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def authenticate_with_http_info(self, body, **kwargs):  # noqa: E501
        """authenticate  # noqa: E501

        If authenticating for the first time with a temporary password, a 307 Temporary Redirect to `/authenticate/initial` will be returned, which can be called with the same request body.  A sessionToken property may be returned from this redirect endpoint, which can be used to set a permanent password with the `/set-password` endpoint on the Party API.  See API specification Security section for more information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.authenticate_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthenticationRequest body: (required)
        :return: AuthenticationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method authenticate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `authenticate`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/authenticate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthenticationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def calculate_duration(self, **kwargs):  # noqa: E501
        """calculate_duration  # noqa: E501

        See business rules section 1.2 - Dates and times See glossary - Working day Utility endpoint. Can be used to check what durations will be assigned to a work/permit based on start and end date Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calculate_duration(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param datetime start_date:
        :param datetime end_date:
        :return: DurationCalculationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.calculate_duration_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.calculate_duration_with_http_info(**kwargs)  # noqa: E501
            return data

    def calculate_duration_with_http_info(self, **kwargs):  # noqa: E501
        """calculate_duration  # noqa: E501

        See business rules section 1.2 - Dates and times See glossary - Working day Utility endpoint. Can be used to check what durations will be assigned to a work/permit based on start and end date Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calculate_duration_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param datetime start_date:
        :param datetime end_date:
        :return: DurationCalculationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['start_date', 'end_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method calculate_duration" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('endDate', params['end_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/duration', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DurationCalculationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_activity(self, body, activity_reference_number, **kwargs):  # noqa: E501
        """cancel_activity  # noqa: E501

        Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_activity(body, activity_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityCancelRequest body: (required)
        :param str activity_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_activity_with_http_info(body, activity_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_activity_with_http_info(body, activity_reference_number, **kwargs)  # noqa: E501
            return data

    def cancel_activity_with_http_info(self, body, activity_reference_number, **kwargs):  # noqa: E501
        """cancel_activity  # noqa: E501

        Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_activity_with_http_info(body, activity_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityCancelRequest body: (required)
        :param str activity_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'activity_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_activity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `cancel_activity`")  # noqa: E501
        # verify the required parameter 'activity_reference_number' is set
        if ('activity_reference_number' not in params or
                params['activity_reference_number'] is None):
            raise ValueError("Missing the required parameter `activity_reference_number` when calling `cancel_activity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_reference_number' in params:
            path_params['activityReferenceNumber'] = params['activity_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/activity/{activityReferenceNumber}/cancel', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_forward_plan(self, body, work_reference_number, forward_plan_reference_number, **kwargs):  # noqa: E501
        """cancel_forward_plan  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_forward_plan(body, work_reference_number, forward_plan_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ForwardPlanCancelRequest body: (required)
        :param str work_reference_number: (required)
        :param str forward_plan_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_forward_plan_with_http_info(body, work_reference_number, forward_plan_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_forward_plan_with_http_info(body, work_reference_number, forward_plan_reference_number, **kwargs)  # noqa: E501
            return data

    def cancel_forward_plan_with_http_info(self, body, work_reference_number, forward_plan_reference_number, **kwargs):  # noqa: E501
        """cancel_forward_plan  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_forward_plan_with_http_info(body, work_reference_number, forward_plan_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ForwardPlanCancelRequest body: (required)
        :param str work_reference_number: (required)
        :param str forward_plan_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'forward_plan_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_forward_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `cancel_forward_plan`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `cancel_forward_plan`")  # noqa: E501
        # verify the required parameter 'forward_plan_reference_number' is set
        if ('forward_plan_reference_number' not in params or
                params['forward_plan_reference_number'] is None):
            raise ValueError("Missing the required parameter `forward_plan_reference_number` when calling `cancel_forward_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'forward_plan_reference_number' in params:
            path_params['forwardPlanReferenceNumber'] = params['forward_plan_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/forward-plans/{forwardPlanReferenceNumber}/cancel', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_private_street_notice(self, body, work_reference_number, private_street_reference_number, **kwargs):  # noqa: E501
        """cancel_private_street_notice  # noqa: E501

        See business rules section 2.1.7 - Works on private streets Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_private_street_notice(body, work_reference_number, private_street_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PrivateStreetNoticeCancelRequest body: (required)
        :param str work_reference_number: (required)
        :param str private_street_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_private_street_notice_with_http_info(body, work_reference_number, private_street_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_private_street_notice_with_http_info(body, work_reference_number, private_street_reference_number, **kwargs)  # noqa: E501
            return data

    def cancel_private_street_notice_with_http_info(self, body, work_reference_number, private_street_reference_number, **kwargs):  # noqa: E501
        """cancel_private_street_notice  # noqa: E501

        See business rules section 2.1.7 - Works on private streets Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_private_street_notice_with_http_info(body, work_reference_number, private_street_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PrivateStreetNoticeCancelRequest body: (required)
        :param str work_reference_number: (required)
        :param str private_street_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'private_street_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_private_street_notice" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `cancel_private_street_notice`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `cancel_private_street_notice`")  # noqa: E501
        # verify the required parameter 'private_street_reference_number' is set
        if ('private_street_reference_number' not in params or
                params['private_street_reference_number'] is None):
            raise ValueError("Missing the required parameter `private_street_reference_number` when calling `cancel_private_street_notice`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'private_street_reference_number' in params:
            path_params['privateStreetReferenceNumber'] = params['private_street_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/private-street-notices/{privateStreetReferenceNumber}/cancel', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_activity(self, body, **kwargs):  # noqa: E501
        """create_activity  # noqa: E501

        See business rules section 9 - Activities Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_activity(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityCreateRequest body: (required)
        :return: ActivityCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_activity_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_activity_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_activity_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_activity  # noqa: E501

        See business rules section 9 - Activities Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_activity_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityCreateRequest body: (required)
        :return: ActivityCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_activity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_activity`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/activity', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ancillary_info(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """create_ancillary_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ancillary_info(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateAncillaryInfoRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: CreateAncillaryInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ancillary_info_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ancillary_info_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
            return data

    def create_ancillary_info_with_http_info(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """create_ancillary_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ancillary_info_with_http_info(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateAncillaryInfoRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: CreateAncillaryInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ancillary_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_ancillary_info`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `create_ancillary_info`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `create_ancillary_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/ancillary-informations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateAncillaryInfoResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_forward_plan(self, body, **kwargs):  # noqa: E501
        """create_forward_plan  # noqa: E501

        See business rules section 3.3 - Forward plans Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_forward_plan(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ForwardPlanCreateRequest body: (required)
        :return: ForwardPlanCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_forward_plan_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_forward_plan_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_forward_plan_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_forward_plan  # noqa: E501

        See business rules section 3.3 - Forward plans Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_forward_plan_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ForwardPlanCreateRequest body: (required)
        :return: ForwardPlanCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_forward_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_forward_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/forward-plans', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ForwardPlanCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_fpn(self, body, work_reference_number, **kwargs):  # noqa: E501
        """create_fpn  # noqa: E501

        See business rules section 11 - Fixed penalty notice (FPN) Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_fpn(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FPNCreateRequest body: (required)
        :param str work_reference_number: (required)
        :return: FPNCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_fpn_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.create_fpn_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
            return data

    def create_fpn_with_http_info(self, body, work_reference_number, **kwargs):  # noqa: E501
        """create_fpn  # noqa: E501

        See business rules section 11 - Fixed penalty notice (FPN) Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_fpn_with_http_info(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FPNCreateRequest body: (required)
        :param str work_reference_number: (required)
        :return: FPNCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_fpn" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_fpn`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `create_fpn`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/fixed-penalty-notices', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FPNCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_geographical_area(self, file, internal_user_identifier, internal_user_name, **kwargs):  # noqa: E501
        """create_geographical_area  # noqa: E501

        See API specification Resource Guide > Works API > Geographical Areas for more information Authenticated user must have one of the following roles: HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_geographical_area(file, internal_user_identifier, internal_user_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file: (required)
        :param str internal_user_identifier: (required)
        :param str internal_user_name: (required)
        :return: GeographicalAreaCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_geographical_area_with_http_info(file, internal_user_identifier, internal_user_name, **kwargs)  # noqa: E501
        else:
            (data) = self.create_geographical_area_with_http_info(file, internal_user_identifier, internal_user_name, **kwargs)  # noqa: E501
            return data

    def create_geographical_area_with_http_info(self, file, internal_user_identifier, internal_user_name, **kwargs):  # noqa: E501
        """create_geographical_area  # noqa: E501

        See API specification Resource Guide > Works API > Geographical Areas for more information Authenticated user must have one of the following roles: HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_geographical_area_with_http_info(file, internal_user_identifier, internal_user_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file: (required)
        :param str internal_user_identifier: (required)
        :param str internal_user_name: (required)
        :return: GeographicalAreaCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file', 'internal_user_identifier', 'internal_user_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_geographical_area" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `create_geographical_area`")  # noqa: E501
        # verify the required parameter 'internal_user_identifier' is set
        if ('internal_user_identifier' not in params or
                params['internal_user_identifier'] is None):
            raise ValueError("Missing the required parameter `internal_user_identifier` when calling `create_geographical_area`")  # noqa: E501
        # verify the required parameter 'internal_user_name' is set
        if ('internal_user_name' not in params or
                params['internal_user_name'] is None):
            raise ValueError("Missing the required parameter `internal_user_name` when calling `create_geographical_area`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501
        if 'internal_user_identifier' in params:
            form_params.append(('internalUserIdentifier', params['internal_user_identifier']))  # noqa: E501
        if 'internal_user_name' in params:
            form_params.append(('internalUserName', params['internal_user_name']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/geographical-areas', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GeographicalAreaCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_historic_fpn(self, body, **kwargs):  # noqa: E501
        """create_historic_fpn  # noqa: E501

        See business rules section 15 - Historical works See business rules section 11.2 - FPN statuses Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_historic_fpn(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HistoricFPNCreateRequest body: (required)
        :return: HistoricFPNCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_historic_fpn_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_historic_fpn_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_historic_fpn_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_historic_fpn  # noqa: E501

        See business rules section 15 - Historical works See business rules section 11.2 - FPN statuses Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_historic_fpn_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HistoricFPNCreateRequest body: (required)
        :return: HistoricFPNCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_historic_fpn" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_historic_fpn`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/historic-works/fixed-penalty-notices', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoricFPNCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_historic_inspection(self, body, **kwargs):  # noqa: E501
        """create_historic_inspection  # noqa: E501

        See business rules section 15 - Historical works See business rules section 10 - Inspections and non-compliance Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_historic_inspection(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HistoricInspectionCreateRequest body: (required)
        :return: HistoricInspectionCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_historic_inspection_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_historic_inspection_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_historic_inspection_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_historic_inspection  # noqa: E501

        See business rules section 15 - Historical works See business rules section 10 - Inspections and non-compliance Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_historic_inspection_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HistoricInspectionCreateRequest body: (required)
        :return: HistoricInspectionCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_historic_inspection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_historic_inspection`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/historic-works/inspections', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoricInspectionCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_inspection(self, body, work_reference_number, **kwargs):  # noqa: E501
        """create_inspection  # noqa: E501

        See business rules section 10 - Inspections and non-compliance Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_inspection(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InspectionCreateRequest body: (required)
        :param str work_reference_number: (required)
        :return: InspectionCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_inspection_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.create_inspection_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
            return data

    def create_inspection_with_http_info(self, body, work_reference_number, **kwargs):  # noqa: E501
        """create_inspection  # noqa: E501

        See business rules section 10 - Inspections and non-compliance Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_inspection_with_http_info(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InspectionCreateRequest body: (required)
        :param str work_reference_number: (required)
        :return: InspectionCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_inspection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_inspection`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `create_inspection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/inspections', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InspectionCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_materials_classification(self, body, **kwargs):  # noqa: E501
        """create_materials_classification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_materials_classification(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MaterialClassificationCreateRequest body: (required)
        :return: MaterialClassificationCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_materials_classification_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_materials_classification_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_materials_classification_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_materials_classification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_materials_classification_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MaterialClassificationCreateRequest body: (required)
        :return: MaterialClassificationCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_materials_classification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_materials_classification`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/material-classifications', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MaterialClassificationCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_non_notifiable_site(self, body, **kwargs):  # noqa: E501
        """create_non_notifiable_site  # noqa: E501

        See business rules section 8 - Sites and reinstatements Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_non_notifiable_site(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NonNotifiableSiteCreateRequest body: (required)
        :return: NonNotifiableSiteCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_non_notifiable_site_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_non_notifiable_site_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_non_notifiable_site_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_non_notifiable_site  # noqa: E501

        See business rules section 8 - Sites and reinstatements Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_non_notifiable_site_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NonNotifiableSiteCreateRequest body: (required)
        :return: NonNotifiableSiteCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_non_notifiable_site" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_non_notifiable_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/non-notifiable-works/sites', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NonNotifiableSiteCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_permit(self, body, work_reference_number, **kwargs):  # noqa: E501
        """create_permit  # noqa: E501

        See business rules section 3.4 - PAA and permit applications (PA) Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_permit(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitCreateRequest body: (required)
        :param str work_reference_number: (required)
        :return: PermitCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_permit_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.create_permit_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
            return data

    def create_permit_with_http_info(self, body, work_reference_number, **kwargs):  # noqa: E501
        """create_permit  # noqa: E501

        See business rules section 3.4 - PAA and permit applications (PA) Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_permit_with_http_info(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitCreateRequest body: (required)
        :param str work_reference_number: (required)
        :return: PermitCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_permit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_permit`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `create_permit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermitCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_permit_alteration(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """create_permit_alteration  # noqa: E501

        See business rules section 4 - Change requests (CR) Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_permit_alteration(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitAlterationCreateRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: PermitAlterationCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_permit_alteration_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.create_permit_alteration_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
            return data

    def create_permit_alteration_with_http_info(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """create_permit_alteration  # noqa: E501

        See business rules section 4 - Change requests (CR) Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_permit_alteration_with_http_info(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitAlterationCreateRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: PermitAlterationCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_permit_alteration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_permit_alteration`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `create_permit_alteration`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `create_permit_alteration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/alterations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermitAlterationCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_private_street_notice(self, body, **kwargs):  # noqa: E501
        """create_private_street_notice  # noqa: E501

        See business rules section 2.1.7 - Works on private streets Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_private_street_notice(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PrivateStreetNoticeCreateRequest body: (required)
        :return: PrivateStreetNoticeCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_private_street_notice_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_private_street_notice_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_private_street_notice_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_private_street_notice  # noqa: E501

        See business rules section 2.1.7 - Works on private streets Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_private_street_notice_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PrivateStreetNoticeCreateRequest body: (required)
        :return: PrivateStreetNoticeCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_private_street_notice" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_private_street_notice`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/private-street-notices', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PrivateStreetNoticeCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_reinstatement(self, body, work_reference_number, site_reference_number, **kwargs):  # noqa: E501
        """create_reinstatement  # noqa: E501

        See business rules section 8 - Sites and reinstatements Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_reinstatement(body, work_reference_number, site_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReinstatementCreateRequest body: (required)
        :param str work_reference_number: (required)
        :param str site_reference_number: (required)
        :return: ReinstatementCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_reinstatement_with_http_info(body, work_reference_number, site_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.create_reinstatement_with_http_info(body, work_reference_number, site_reference_number, **kwargs)  # noqa: E501
            return data

    def create_reinstatement_with_http_info(self, body, work_reference_number, site_reference_number, **kwargs):  # noqa: E501
        """create_reinstatement  # noqa: E501

        See business rules section 8 - Sites and reinstatements Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_reinstatement_with_http_info(body, work_reference_number, site_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReinstatementCreateRequest body: (required)
        :param str work_reference_number: (required)
        :param str site_reference_number: (required)
        :return: ReinstatementCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'site_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_reinstatement" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_reinstatement`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `create_reinstatement`")  # noqa: E501
        # verify the required parameter 'site_reference_number' is set
        if ('site_reference_number' not in params or
                params['site_reference_number'] is None):
            raise ValueError("Missing the required parameter `site_reference_number` when calling `create_reinstatement`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'site_reference_number' in params:
            path_params['siteReferenceNumber'] = params['site_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/sites/{siteReferenceNumber}/reinstatements', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReinstatementCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_scheduled_inspection(self, body, work_reference_number, **kwargs):  # noqa: E501
        """create_scheduled_inspection  # noqa: E501

        See business rules section 10.4 - Scheduling inspections Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_scheduled_inspection(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScheduledInspectionCreateRequest body: (required)
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_scheduled_inspection_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.create_scheduled_inspection_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
            return data

    def create_scheduled_inspection_with_http_info(self, body, work_reference_number, **kwargs):  # noqa: E501
        """create_scheduled_inspection  # noqa: E501

        See business rules section 10.4 - Scheduling inspections Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_scheduled_inspection_with_http_info(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScheduledInspectionCreateRequest body: (required)
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_scheduled_inspection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_scheduled_inspection`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `create_scheduled_inspection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/scheduled-inspections', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_section58(self, body, **kwargs):  # noqa: E501
        """create_section58  # noqa: E501

        See business rules section 22 - Section 58s Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_section58(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Section58CreateRequest body: (required)
        :return: Section58CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_section58_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_section58_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_section58_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_section58  # noqa: E501

        See business rules section 22 - Section 58s Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_section58_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Section58CreateRequest body: (required)
        :return: Section58CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_section58" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_section58`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/section-58s', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Section58CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_section74(self, body, work_reference_number, **kwargs):  # noqa: E501
        """create_section74  # noqa: E501

        See business rules section 20 - Section 74s Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_section74(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Section74CreateRequest body: (required)
        :param str work_reference_number: (required)
        :return: Section74CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_section74_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.create_section74_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
            return data

    def create_section74_with_http_info(self, body, work_reference_number, **kwargs):  # noqa: E501
        """create_section74  # noqa: E501

        See business rules section 20 - Section 74s Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_section74_with_http_info(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Section74CreateRequest body: (required)
        :param str work_reference_number: (required)
        :return: Section74CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_section74" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_section74`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `create_section74`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/section-74s', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Section74CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_section81(self, body, **kwargs):  # noqa: E501
        """create_section81  # noqa: E501

        See business rules section 14.3 - Adding S81s Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_section81(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Section81CreateRequest body: (required)
        :return: Section81CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_section81_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_section81_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_section81_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_section81  # noqa: E501

        See business rules section 14.3 - Adding S81s Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_section81_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Section81CreateRequest body: (required)
        :return: Section81CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_section81" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_section81`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/section-81-works/section-81s', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Section81CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_site(self, body, work_reference_number, **kwargs):  # noqa: E501
        """create_site  # noqa: E501

        See business rules section 8 - Sites and reinstatements Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_site(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SiteCreateRequest body: (required)
        :param str work_reference_number: (required)
        :return: SiteCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_site_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.create_site_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
            return data

    def create_site_with_http_info(self, body, work_reference_number, **kwargs):  # noqa: E501
        """create_site  # noqa: E501

        See business rules section 8 - Sites and reinstatements Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_site_with_http_info(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SiteCreateRequest body: (required)
        :param str work_reference_number: (required)
        :return: SiteCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_site" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_site`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `create_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/sites', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SiteCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_work(self, body, **kwargs):  # noqa: E501
        """create_work  # noqa: E501

        See business rules section 3 - Works submissions and applications Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_work(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkCreateRequest body: (required)
        :return: WorkCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_work_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_work_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_work_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_work  # noqa: E501

        See business rules section 3 - Works submissions and applications Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_work_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkCreateRequest body: (required)
        :return: WorkCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_work" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_work`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_file(self, file_id, **kwargs):  # noqa: E501
        """delete_file  # noqa: E501

        See API specification Resource Guide > Works API > File upload for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float file_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_file_with_http_info(file_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_file_with_http_info(file_id, **kwargs)  # noqa: E501
            return data

    def delete_file_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """delete_file  # noqa: E501

        See API specification Resource Guide > Works API > File upload for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float file_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params or
                params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `delete_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in params:
            path_params['fileId'] = params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/files/{fileId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_fpn(self, work_reference_number, fpn_reference_number, **kwargs):  # noqa: E501
        """delete_fpn  # noqa: E501

        See business rules section 11 - Fixed penalty notice (FPN) Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_fpn(work_reference_number, fpn_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str fpn_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_fpn_with_http_info(work_reference_number, fpn_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_fpn_with_http_info(work_reference_number, fpn_reference_number, **kwargs)  # noqa: E501
            return data

    def delete_fpn_with_http_info(self, work_reference_number, fpn_reference_number, **kwargs):  # noqa: E501
        """delete_fpn  # noqa: E501

        See business rules section 11 - Fixed penalty notice (FPN) Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_fpn_with_http_info(work_reference_number, fpn_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str fpn_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'fpn_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_fpn" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `delete_fpn`")  # noqa: E501
        # verify the required parameter 'fpn_reference_number' is set
        if ('fpn_reference_number' not in params or
                params['fpn_reference_number'] is None):
            raise ValueError("Missing the required parameter `fpn_reference_number` when calling `delete_fpn`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'fpn_reference_number' in params:
            path_params['fpnReferenceNumber'] = params['fpn_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/fixed-penalty-notices/{fpnReferenceNumber}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_inspection(self, work_reference_number, inspection_reference_number, **kwargs):  # noqa: E501
        """delete_inspection  # noqa: E501

        Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_inspection(work_reference_number, inspection_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str inspection_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_inspection_with_http_info(work_reference_number, inspection_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_inspection_with_http_info(work_reference_number, inspection_reference_number, **kwargs)  # noqa: E501
            return data

    def delete_inspection_with_http_info(self, work_reference_number, inspection_reference_number, **kwargs):  # noqa: E501
        """delete_inspection  # noqa: E501

        Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_inspection_with_http_info(work_reference_number, inspection_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str inspection_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'inspection_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_inspection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `delete_inspection`")  # noqa: E501
        # verify the required parameter 'inspection_reference_number' is set
        if ('inspection_reference_number' not in params or
                params['inspection_reference_number'] is None):
            raise ValueError("Missing the required parameter `inspection_reference_number` when calling `delete_inspection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'inspection_reference_number' in params:
            path_params['inspectionReferenceNumber'] = params['inspection_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/inspections/{inspectionReferenceNumber}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_reinstatement(self, work_reference_number, site_reference_number, reinstatement_reference_number, **kwargs):  # noqa: E501
        """delete_reinstatement  # noqa: E501

        See business rules section 8 - Sites and reinstatements Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_reinstatement(work_reference_number, site_reference_number, reinstatement_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str site_reference_number: (required)
        :param str reinstatement_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_reinstatement_with_http_info(work_reference_number, site_reference_number, reinstatement_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_reinstatement_with_http_info(work_reference_number, site_reference_number, reinstatement_reference_number, **kwargs)  # noqa: E501
            return data

    def delete_reinstatement_with_http_info(self, work_reference_number, site_reference_number, reinstatement_reference_number, **kwargs):  # noqa: E501
        """delete_reinstatement  # noqa: E501

        See business rules section 8 - Sites and reinstatements Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_reinstatement_with_http_info(work_reference_number, site_reference_number, reinstatement_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str site_reference_number: (required)
        :param str reinstatement_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'site_reference_number', 'reinstatement_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_reinstatement" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `delete_reinstatement`")  # noqa: E501
        # verify the required parameter 'site_reference_number' is set
        if ('site_reference_number' not in params or
                params['site_reference_number'] is None):
            raise ValueError("Missing the required parameter `site_reference_number` when calling `delete_reinstatement`")  # noqa: E501
        # verify the required parameter 'reinstatement_reference_number' is set
        if ('reinstatement_reference_number' not in params or
                params['reinstatement_reference_number'] is None):
            raise ValueError("Missing the required parameter `reinstatement_reference_number` when calling `delete_reinstatement`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'site_reference_number' in params:
            path_params['siteReferenceNumber'] = params['site_reference_number']  # noqa: E501
        if 'reinstatement_reference_number' in params:
            path_params['reinstatementReferenceNumber'] = params['reinstatement_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/sites/{siteReferenceNumber}/reinstatements/{reinstatementReferenceNumber}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_scheduled_inspection(self, work_reference_number, **kwargs):  # noqa: E501
        """delete_scheduled_inspection  # noqa: E501

        Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scheduled_inspection(work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_scheduled_inspection_with_http_info(work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_scheduled_inspection_with_http_info(work_reference_number, **kwargs)  # noqa: E501
            return data

    def delete_scheduled_inspection_with_http_info(self, work_reference_number, **kwargs):  # noqa: E501
        """delete_scheduled_inspection  # noqa: E501

        Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scheduled_inspection_with_http_info(work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_scheduled_inspection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `delete_scheduled_inspection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/scheduled-inspections', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def duration_challenge_non_acceptance_response(self, body, work_reference_number, permit_reference_number, permit_alteration_reference_number, **kwargs):  # noqa: E501
        """duration_challenge_non_acceptance_response  # noqa: E501

        See business rules section 21.2 - Duration challenge non acceptance response Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.duration_challenge_non_acceptance_response(body, work_reference_number, permit_reference_number, permit_alteration_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitAlterationDurationChallengeNonAcceptanceResponseRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :param str permit_alteration_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.duration_challenge_non_acceptance_response_with_http_info(body, work_reference_number, permit_reference_number, permit_alteration_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.duration_challenge_non_acceptance_response_with_http_info(body, work_reference_number, permit_reference_number, permit_alteration_reference_number, **kwargs)  # noqa: E501
            return data

    def duration_challenge_non_acceptance_response_with_http_info(self, body, work_reference_number, permit_reference_number, permit_alteration_reference_number, **kwargs):  # noqa: E501
        """duration_challenge_non_acceptance_response  # noqa: E501

        See business rules section 21.2 - Duration challenge non acceptance response Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.duration_challenge_non_acceptance_response_with_http_info(body, work_reference_number, permit_reference_number, permit_alteration_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitAlterationDurationChallengeNonAcceptanceResponseRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :param str permit_alteration_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number', 'permit_alteration_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method duration_challenge_non_acceptance_response" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `duration_challenge_non_acceptance_response`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `duration_challenge_non_acceptance_response`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `duration_challenge_non_acceptance_response`")  # noqa: E501
        # verify the required parameter 'permit_alteration_reference_number' is set
        if ('permit_alteration_reference_number' not in params or
                params['permit_alteration_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_alteration_reference_number` when calling `duration_challenge_non_acceptance_response`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501
        if 'permit_alteration_reference_number' in params:
            path_params['permitAlterationReferenceNumber'] = params['permit_alteration_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/alterations/{permitAlterationReferenceNumber}/duration-challenge-non-acceptance-response', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def duration_challenge_review(self, body, work_reference_number, permit_reference_number, permit_alteration_reference_number, **kwargs):  # noqa: E501
        """duration_challenge_review  # noqa: E501

        See business rules section 21.1 - Duration challenge review Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.duration_challenge_review(body, work_reference_number, permit_reference_number, permit_alteration_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitAlterationDurationChallengeReviewRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :param str permit_alteration_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.duration_challenge_review_with_http_info(body, work_reference_number, permit_reference_number, permit_alteration_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.duration_challenge_review_with_http_info(body, work_reference_number, permit_reference_number, permit_alteration_reference_number, **kwargs)  # noqa: E501
            return data

    def duration_challenge_review_with_http_info(self, body, work_reference_number, permit_reference_number, permit_alteration_reference_number, **kwargs):  # noqa: E501
        """duration_challenge_review  # noqa: E501

        See business rules section 21.1 - Duration challenge review Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.duration_challenge_review_with_http_info(body, work_reference_number, permit_reference_number, permit_alteration_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitAlterationDurationChallengeReviewRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :param str permit_alteration_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number', 'permit_alteration_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method duration_challenge_review" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `duration_challenge_review`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `duration_challenge_review`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `duration_challenge_review`")  # noqa: E501
        # verify the required parameter 'permit_alteration_reference_number' is set
        if ('permit_alteration_reference_number' not in params or
                params['permit_alteration_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_alteration_reference_number` when calling `duration_challenge_review`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501
        if 'permit_alteration_reference_number' in params:
            path_params['permitAlterationReferenceNumber'] = params['permit_alteration_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/alterations/{permitAlterationReferenceNumber}/duration-challenge-review', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity(self, activity_reference_number, **kwargs):  # noqa: E501
        """get_activity  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity(activity_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_reference_number: (required)
        :return: ActivityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activity_with_http_info(activity_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_activity_with_http_info(activity_reference_number, **kwargs)  # noqa: E501
            return data

    def get_activity_with_http_info(self, activity_reference_number, **kwargs):  # noqa: E501
        """get_activity  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_with_http_info(activity_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_reference_number: (required)
        :return: ActivityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_reference_number' is set
        if ('activity_reference_number' not in params or
                params['activity_reference_number'] is None):
            raise ValueError("Missing the required parameter `activity_reference_number` when calling `get_activity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_reference_number' in params:
            path_params['activityReferenceNumber'] = params['activity_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/activity/{activityReferenceNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ancillary_info(self, work_reference_number, permit_reference_number, ancillary_information_reference_number, **kwargs):  # noqa: E501
        """get_ancillary_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ancillary_info(work_reference_number, permit_reference_number, ancillary_information_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :param str ancillary_information_reference_number: (required)
        :return: AncillaryInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ancillary_info_with_http_info(work_reference_number, permit_reference_number, ancillary_information_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ancillary_info_with_http_info(work_reference_number, permit_reference_number, ancillary_information_reference_number, **kwargs)  # noqa: E501
            return data

    def get_ancillary_info_with_http_info(self, work_reference_number, permit_reference_number, ancillary_information_reference_number, **kwargs):  # noqa: E501
        """get_ancillary_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ancillary_info_with_http_info(work_reference_number, permit_reference_number, ancillary_information_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :param str ancillary_information_reference_number: (required)
        :return: AncillaryInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'permit_reference_number', 'ancillary_information_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ancillary_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `get_ancillary_info`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `get_ancillary_info`")  # noqa: E501
        # verify the required parameter 'ancillary_information_reference_number' is set
        if ('ancillary_information_reference_number' not in params or
                params['ancillary_information_reference_number'] is None):
            raise ValueError("Missing the required parameter `ancillary_information_reference_number` when calling `get_ancillary_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501
        if 'ancillary_information_reference_number' in params:
            path_params['ancillaryInformationReferenceNumber'] = params['ancillary_information_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/ancillary-informations/{ancillaryInformationReferenceNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AncillaryInfoResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_comment(self, work_reference_number, comment_reference_number, **kwargs):  # noqa: E501
        """get_comment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_comment(work_reference_number, comment_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str comment_reference_number: (required)
        :return: CommentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_comment_with_http_info(work_reference_number, comment_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_comment_with_http_info(work_reference_number, comment_reference_number, **kwargs)  # noqa: E501
            return data

    def get_comment_with_http_info(self, work_reference_number, comment_reference_number, **kwargs):  # noqa: E501
        """get_comment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_comment_with_http_info(work_reference_number, comment_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str comment_reference_number: (required)
        :return: CommentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'comment_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_comment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `get_comment`")  # noqa: E501
        # verify the required parameter 'comment_reference_number' is set
        if ('comment_reference_number' not in params or
                params['comment_reference_number'] is None):
            raise ValueError("Missing the required parameter `comment_reference_number` when calling `get_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'comment_reference_number' in params:
            path_params['commentReferenceNumber'] = params['comment_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/comments/{commentReferenceNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_earliest_permit(self, work_reference_number, **kwargs):  # noqa: E501
        """get_earliest_permit  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_earliest_permit(work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :return: PermitSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_earliest_permit_with_http_info(work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_earliest_permit_with_http_info(work_reference_number, **kwargs)  # noqa: E501
            return data

    def get_earliest_permit_with_http_info(self, work_reference_number, **kwargs):  # noqa: E501
        """get_earliest_permit  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_earliest_permit_with_http_info(work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :return: PermitSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_earliest_permit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `get_earliest_permit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/earliest-permit', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermitSummaryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_fee_matrix(self, organisation_reference, **kwargs):  # noqa: E501
        """get_fee_matrix  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fee_matrix(organisation_reference, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organisation_reference: (required)
        :return: FeeMatrixResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_fee_matrix_with_http_info(organisation_reference, **kwargs)  # noqa: E501
        else:
            (data) = self.get_fee_matrix_with_http_info(organisation_reference, **kwargs)  # noqa: E501
            return data

    def get_fee_matrix_with_http_info(self, organisation_reference, **kwargs):  # noqa: E501
        """get_fee_matrix  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fee_matrix_with_http_info(organisation_reference, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organisation_reference: (required)
        :return: FeeMatrixResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organisation_reference']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fee_matrix" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organisation_reference' is set
        if ('organisation_reference' not in params or
                params['organisation_reference'] is None):
            raise ValueError("Missing the required parameter `organisation_reference` when calling `get_fee_matrix`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organisation_reference' in params:
            path_params['organisationReference'] = params['organisation_reference']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/fee-matrix/{organisationReference}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FeeMatrixResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file(self, file_id, **kwargs):  # noqa: E501
        """get_file  # noqa: E501

        See API specification Resource Guide > Works API > File upload for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int file_id: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_with_http_info(file_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_with_http_info(file_id, **kwargs)  # noqa: E501
            return data

    def get_file_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """get_file  # noqa: E501

        See API specification Resource Guide > Works API > File upload for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int file_id: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params or
                params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `get_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in params:
            path_params['fileId'] = params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.msword', 'application/pdf', 'image/png', 'image/jpeg', 'image/tiff', 'image/bmp'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/files/{fileId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_forward_plan(self, work_reference_number, forward_plan_reference_number, **kwargs):  # noqa: E501
        """get_forward_plan  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_forward_plan(work_reference_number, forward_plan_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str forward_plan_reference_number: (required)
        :return: ForwardPlanResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_forward_plan_with_http_info(work_reference_number, forward_plan_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_forward_plan_with_http_info(work_reference_number, forward_plan_reference_number, **kwargs)  # noqa: E501
            return data

    def get_forward_plan_with_http_info(self, work_reference_number, forward_plan_reference_number, **kwargs):  # noqa: E501
        """get_forward_plan  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_forward_plan_with_http_info(work_reference_number, forward_plan_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str forward_plan_reference_number: (required)
        :return: ForwardPlanResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'forward_plan_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_forward_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `get_forward_plan`")  # noqa: E501
        # verify the required parameter 'forward_plan_reference_number' is set
        if ('forward_plan_reference_number' not in params or
                params['forward_plan_reference_number'] is None):
            raise ValueError("Missing the required parameter `forward_plan_reference_number` when calling `get_forward_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'forward_plan_reference_number' in params:
            path_params['forwardPlanReferenceNumber'] = params['forward_plan_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/forward-plans/{forwardPlanReferenceNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ForwardPlanResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_fpn(self, work_reference_number, fpn_reference_number, **kwargs):  # noqa: E501
        """get_fpn  # noqa: E501

        See business rules section 11 - Fixed penalty notice (FPN) Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fpn(work_reference_number, fpn_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str fpn_reference_number: (required)
        :return: FPNResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_fpn_with_http_info(work_reference_number, fpn_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_fpn_with_http_info(work_reference_number, fpn_reference_number, **kwargs)  # noqa: E501
            return data

    def get_fpn_with_http_info(self, work_reference_number, fpn_reference_number, **kwargs):  # noqa: E501
        """get_fpn  # noqa: E501

        See business rules section 11 - Fixed penalty notice (FPN) Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fpn_with_http_info(work_reference_number, fpn_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str fpn_reference_number: (required)
        :return: FPNResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'fpn_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fpn" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `get_fpn`")  # noqa: E501
        # verify the required parameter 'fpn_reference_number' is set
        if ('fpn_reference_number' not in params or
                params['fpn_reference_number'] is None):
            raise ValueError("Missing the required parameter `fpn_reference_number` when calling `get_fpn`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'fpn_reference_number' in params:
            path_params['fpnReferenceNumber'] = params['fpn_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/fixed-penalty-notices/{fpnReferenceNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FPNResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_inspection(self, work_reference_number, inspection_reference_number, **kwargs):  # noqa: E501
        """get_inspection  # noqa: E501

        See business rules section 10 - Inspections and non-compliance Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inspection(work_reference_number, inspection_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str inspection_reference_number: (required)
        :return: InspectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_inspection_with_http_info(work_reference_number, inspection_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_inspection_with_http_info(work_reference_number, inspection_reference_number, **kwargs)  # noqa: E501
            return data

    def get_inspection_with_http_info(self, work_reference_number, inspection_reference_number, **kwargs):  # noqa: E501
        """get_inspection  # noqa: E501

        See business rules section 10 - Inspections and non-compliance Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inspection_with_http_info(work_reference_number, inspection_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str inspection_reference_number: (required)
        :return: InspectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'inspection_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inspection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `get_inspection`")  # noqa: E501
        # verify the required parameter 'inspection_reference_number' is set
        if ('inspection_reference_number' not in params or
                params['inspection_reference_number'] is None):
            raise ValueError("Missing the required parameter `inspection_reference_number` when calling `get_inspection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'inspection_reference_number' in params:
            path_params['inspectionReferenceNumber'] = params['inspection_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/inspections/{inspectionReferenceNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InspectionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_material_classification(self, material_classification_reference_number, **kwargs):  # noqa: E501
        """get_material_classification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_material_classification(material_classification_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str material_classification_reference_number: (required)
        :return: MaterialClassificationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_material_classification_with_http_info(material_classification_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_material_classification_with_http_info(material_classification_reference_number, **kwargs)  # noqa: E501
            return data

    def get_material_classification_with_http_info(self, material_classification_reference_number, **kwargs):  # noqa: E501
        """get_material_classification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_material_classification_with_http_info(material_classification_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str material_classification_reference_number: (required)
        :return: MaterialClassificationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['material_classification_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_material_classification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'material_classification_reference_number' is set
        if ('material_classification_reference_number' not in params or
                params['material_classification_reference_number'] is None):
            raise ValueError("Missing the required parameter `material_classification_reference_number` when calling `get_material_classification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'material_classification_reference_number' in params:
            path_params['materialClassificationReferenceNumber'] = params['material_classification_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/material-classifications/{materialClassificationReferenceNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MaterialClassificationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_non_compliance(self, work_reference_number, non_compliance_reference_number, **kwargs):  # noqa: E501
        """get_non_compliance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_non_compliance(work_reference_number, non_compliance_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str non_compliance_reference_number: (required)
        :return: NonComplianceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_non_compliance_with_http_info(work_reference_number, non_compliance_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_non_compliance_with_http_info(work_reference_number, non_compliance_reference_number, **kwargs)  # noqa: E501
            return data

    def get_non_compliance_with_http_info(self, work_reference_number, non_compliance_reference_number, **kwargs):  # noqa: E501
        """get_non_compliance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_non_compliance_with_http_info(work_reference_number, non_compliance_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str non_compliance_reference_number: (required)
        :return: NonComplianceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'non_compliance_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_non_compliance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `get_non_compliance`")  # noqa: E501
        # verify the required parameter 'non_compliance_reference_number' is set
        if ('non_compliance_reference_number' not in params or
                params['non_compliance_reference_number'] is None):
            raise ValueError("Missing the required parameter `non_compliance_reference_number` when calling `get_non_compliance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'non_compliance_reference_number' in params:
            path_params['nonComplianceReferenceNumber'] = params['non_compliance_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/non-compliances/{nonComplianceReferenceNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NonComplianceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_permit(self, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """get_permit  # noqa: E501

        See business rules section 3.4 - PAA and permit applications (PA) Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_permit(work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: PermitResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_permit_with_http_info(work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_permit_with_http_info(work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
            return data

    def get_permit_with_http_info(self, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """get_permit  # noqa: E501

        See business rules section 3.4 - PAA and permit applications (PA) Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_permit_with_http_info(work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: PermitResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'permit_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_permit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `get_permit`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `get_permit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermitResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_permit_alteration(self, work_reference_number, permit_reference_number, permit_alteration_reference_number, **kwargs):  # noqa: E501
        """get_permit_alteration  # noqa: E501

        See business rules section 4 - Change requests (CR) Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_permit_alteration(work_reference_number, permit_reference_number, permit_alteration_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :param str permit_alteration_reference_number: (required)
        :return: PermitAlterationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_permit_alteration_with_http_info(work_reference_number, permit_reference_number, permit_alteration_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_permit_alteration_with_http_info(work_reference_number, permit_reference_number, permit_alteration_reference_number, **kwargs)  # noqa: E501
            return data

    def get_permit_alteration_with_http_info(self, work_reference_number, permit_reference_number, permit_alteration_reference_number, **kwargs):  # noqa: E501
        """get_permit_alteration  # noqa: E501

        See business rules section 4 - Change requests (CR) Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_permit_alteration_with_http_info(work_reference_number, permit_reference_number, permit_alteration_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :param str permit_alteration_reference_number: (required)
        :return: PermitAlterationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'permit_reference_number', 'permit_alteration_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_permit_alteration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `get_permit_alteration`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `get_permit_alteration`")  # noqa: E501
        # verify the required parameter 'permit_alteration_reference_number' is set
        if ('permit_alteration_reference_number' not in params or
                params['permit_alteration_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_alteration_reference_number` when calling `get_permit_alteration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501
        if 'permit_alteration_reference_number' in params:
            path_params['permitAlterationReferenceNumber'] = params['permit_alteration_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/alterations/{permitAlterationReferenceNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermitAlterationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_private_street_notice(self, work_reference_number, private_street_reference_number, **kwargs):  # noqa: E501
        """get_private_street_notice  # noqa: E501

        See business rules section 2.1.7 - Works on private streets Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_private_street_notice(work_reference_number, private_street_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str private_street_reference_number: (required)
        :return: PrivateStreetNoticeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_private_street_notice_with_http_info(work_reference_number, private_street_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_private_street_notice_with_http_info(work_reference_number, private_street_reference_number, **kwargs)  # noqa: E501
            return data

    def get_private_street_notice_with_http_info(self, work_reference_number, private_street_reference_number, **kwargs):  # noqa: E501
        """get_private_street_notice  # noqa: E501

        See business rules section 2.1.7 - Works on private streets Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_private_street_notice_with_http_info(work_reference_number, private_street_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str private_street_reference_number: (required)
        :return: PrivateStreetNoticeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'private_street_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_private_street_notice" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `get_private_street_notice`")  # noqa: E501
        # verify the required parameter 'private_street_reference_number' is set
        if ('private_street_reference_number' not in params or
                params['private_street_reference_number'] is None):
            raise ValueError("Missing the required parameter `private_street_reference_number` when calling `get_private_street_notice`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'private_street_reference_number' in params:
            path_params['privateStreetReferenceNumber'] = params['private_street_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/private-street-notices/{privateStreetReferenceNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PrivateStreetNoticeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_section58(self, section58_reference_number, **kwargs):  # noqa: E501
        """get_section58  # noqa: E501

        See business rules section 22 - Section 58s Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section58(section58_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str section58_reference_number: (required)
        :return: Section58Response
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_section58_with_http_info(section58_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_section58_with_http_info(section58_reference_number, **kwargs)  # noqa: E501
            return data

    def get_section58_with_http_info(self, section58_reference_number, **kwargs):  # noqa: E501
        """get_section58  # noqa: E501

        See business rules section 22 - Section 58s Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section58_with_http_info(section58_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str section58_reference_number: (required)
        :return: Section58Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section58_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_section58" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'section58_reference_number' is set
        if ('section58_reference_number' not in params or
                params['section58_reference_number'] is None):
            raise ValueError("Missing the required parameter `section58_reference_number` when calling `get_section58`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'section58_reference_number' in params:
            path_params['section58ReferenceNumber'] = params['section58_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/section-58s/{section58ReferenceNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Section58Response',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_section74(self, work_reference_number, section74_reference_number, **kwargs):  # noqa: E501
        """get_section74  # noqa: E501

        See business rules section 20 - Section 74s Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section74(work_reference_number, section74_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str section74_reference_number: (required)
        :return: Section74Response
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_section74_with_http_info(work_reference_number, section74_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_section74_with_http_info(work_reference_number, section74_reference_number, **kwargs)  # noqa: E501
            return data

    def get_section74_with_http_info(self, work_reference_number, section74_reference_number, **kwargs):  # noqa: E501
        """get_section74  # noqa: E501

        See business rules section 20 - Section 74s Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section74_with_http_info(work_reference_number, section74_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str section74_reference_number: (required)
        :return: Section74Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'section74_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_section74" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `get_section74`")  # noqa: E501
        # verify the required parameter 'section74_reference_number' is set
        if ('section74_reference_number' not in params or
                params['section74_reference_number'] is None):
            raise ValueError("Missing the required parameter `section74_reference_number` when calling `get_section74`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'section74_reference_number' in params:
            path_params['section74ReferenceNumber'] = params['section74_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/section-74s/{section74ReferenceNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Section74Response',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_section81(self, work_reference_number, section81_reference_number, **kwargs):  # noqa: E501
        """get_section81  # noqa: E501

        See business rules section 14 - Section 81 (S81) Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section81(work_reference_number, section81_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str section81_reference_number: (required)
        :return: Section81Response
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_section81_with_http_info(work_reference_number, section81_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_section81_with_http_info(work_reference_number, section81_reference_number, **kwargs)  # noqa: E501
            return data

    def get_section81_with_http_info(self, work_reference_number, section81_reference_number, **kwargs):  # noqa: E501
        """get_section81  # noqa: E501

        See business rules section 14 - Section 81 (S81) Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section81_with_http_info(work_reference_number, section81_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str section81_reference_number: (required)
        :return: Section81Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'section81_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_section81" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `get_section81`")  # noqa: E501
        # verify the required parameter 'section81_reference_number' is set
        if ('section81_reference_number' not in params or
                params['section81_reference_number'] is None):
            raise ValueError("Missing the required parameter `section81_reference_number` when calling `get_section81`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'section81_reference_number' in params:
            path_params['section81ReferenceNumber'] = params['section81_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/section-81s/{section81ReferenceNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Section81Response',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_site(self, work_reference_number, site_reference_number, **kwargs):  # noqa: E501
        """get_site  # noqa: E501

        See business rules section 8 - Sites and reinstatements Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_site(work_reference_number, site_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str site_reference_number: (required)
        :return: SiteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_site_with_http_info(work_reference_number, site_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_site_with_http_info(work_reference_number, site_reference_number, **kwargs)  # noqa: E501
            return data

    def get_site_with_http_info(self, work_reference_number, site_reference_number, **kwargs):  # noqa: E501
        """get_site  # noqa: E501

        See business rules section 8 - Sites and reinstatements Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_site_with_http_info(work_reference_number, site_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str site_reference_number: (required)
        :return: SiteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'site_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_site" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `get_site`")  # noqa: E501
        # verify the required parameter 'site_reference_number' is set
        if ('site_reference_number' not in params or
                params['site_reference_number'] is None):
            raise ValueError("Missing the required parameter `site_reference_number` when calling `get_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'site_reference_number' in params:
            path_params['siteReferenceNumber'] = params['site_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/sites/{siteReferenceNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SiteResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_work(self, work_reference_number, **kwargs):  # noqa: E501
        """get_work  # noqa: E501

        See business rules section 3 - Works submissions and applications Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work(work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :return: WorkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_work_with_http_info(work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_work_with_http_info(work_reference_number, **kwargs)  # noqa: E501
            return data

    def get_work_with_http_info(self, work_reference_number, **kwargs):  # noqa: E501
        """get_work  # noqa: E501

        See business rules section 3 - Works submissions and applications Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_with_http_info(work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :return: WorkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_work" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `get_work`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_work_category(self, work_type, **kwargs):  # noqa: E501
        """get_work_category  # noqa: E501

        See business rules section 3.4.3 - Works categories Utility endpoint. Can be used to check what category will be assigned to a permit Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_category(work_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkType work_type: (required)
        :param datetime proposed_start_date:
        :param datetime proposed_end_date:
        :param bool is_ttro_required:
        :param bool immediate_risk:
        :param str work_reference_number:
        :param ActivityType activity_type:
        :return: WorkCategoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_work_category_with_http_info(work_type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_work_category_with_http_info(work_type, **kwargs)  # noqa: E501
            return data

    def get_work_category_with_http_info(self, work_type, **kwargs):  # noqa: E501
        """get_work_category  # noqa: E501

        See business rules section 3.4.3 - Works categories Utility endpoint. Can be used to check what category will be assigned to a permit Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_category_with_http_info(work_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkType work_type: (required)
        :param datetime proposed_start_date:
        :param datetime proposed_end_date:
        :param bool is_ttro_required:
        :param bool immediate_risk:
        :param str work_reference_number:
        :param ActivityType activity_type:
        :return: WorkCategoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_type', 'proposed_start_date', 'proposed_end_date', 'is_ttro_required', 'immediate_risk', 'work_reference_number', 'activity_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_work_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_type' is set
        if ('work_type' not in params or
                params['work_type'] is None):
            raise ValueError("Missing the required parameter `work_type` when calling `get_work_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'work_type' in params:
            query_params.append(('work_type', params['work_type']))  # noqa: E501
        if 'proposed_start_date' in params:
            query_params.append(('proposed_start_date', params['proposed_start_date']))  # noqa: E501
        if 'proposed_end_date' in params:
            query_params.append(('proposed_end_date', params['proposed_end_date']))  # noqa: E501
        if 'is_ttro_required' in params:
            query_params.append(('is_ttro_required', params['is_ttro_required']))  # noqa: E501
        if 'immediate_risk' in params:
            query_params.append(('immediate_risk', params['immediate_risk']))  # noqa: E501
        if 'work_reference_number' in params:
            query_params.append(('work_reference_number', params['work_reference_number']))  # noqa: E501
        if 'activity_type' in params:
            query_params.append(('activity_type', params['activity_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/permits/category', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkCategoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_work_history(self, work_reference_number, **kwargs):  # noqa: E501
        """get_work_history  # noqa: E501

        See business rules section 7.2 - Works history Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_history(work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param float offset:
        :return: WorkHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_work_history_with_http_info(work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_work_history_with_http_info(work_reference_number, **kwargs)  # noqa: E501
            return data

    def get_work_history_with_http_info(self, work_reference_number, **kwargs):  # noqa: E501
        """get_work_history  # noqa: E501

        See business rules section 7.2 - Works history Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_history_with_http_info(work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param float offset:
        :return: WorkHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_work_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `get_work_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkHistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def impose_change(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """impose_change  # noqa: E501

        See business rules section 4 - Change requests (CR) Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.impose_change(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImposeChangeRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: ImposeChangeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.impose_change_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.impose_change_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
            return data

    def impose_change_with_http_info(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """impose_change  # noqa: E501

        See business rules section 4 - Change requests (CR) Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.impose_change_with_http_info(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImposeChangeRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: ImposeChangeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method impose_change" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `impose_change`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `impose_change`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `impose_change`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/alterations/impose', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImposeChangeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def link_permit_to_non_compliance(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """link_permit_to_non_compliance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.link_permit_to_non_compliance(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitNonComplianceLinkRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.link_permit_to_non_compliance_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.link_permit_to_non_compliance_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
            return data

    def link_permit_to_non_compliance_with_http_info(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """link_permit_to_non_compliance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.link_permit_to_non_compliance_with_http_info(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitNonComplianceLinkRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method link_permit_to_non_compliance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `link_permit_to_non_compliance`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `link_permit_to_non_compliance`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `link_permit_to_non_compliance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/link-non-compliance', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def link_section81_to_permit(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """link_section81_to_permit  # noqa: E501

        Creates a link between a Permit and a Section 81 Authenticated user must have one of the following roles: Planner, Contractor The Permit and Section 81 must both exist already, not have any existing links created, and the authenticated user must have write access to the associated workstreams for both.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.link_section81_to_permit(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LinkSection81ToPermitRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: LinkSection81ToPermitResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.link_section81_to_permit_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.link_section81_to_permit_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
            return data

    def link_section81_to_permit_with_http_info(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """link_section81_to_permit  # noqa: E501

        Creates a link between a Permit and a Section 81 Authenticated user must have one of the following roles: Planner, Contractor The Permit and Section 81 must both exist already, not have any existing links created, and the authenticated user must have write access to the associated workstreams for both.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.link_section81_to_permit_with_http_info(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LinkSection81ToPermitRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: LinkSection81ToPermitResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method link_section81_to_permit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `link_section81_to_permit`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `link_section81_to_permit`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `link_section81_to_permit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/link-section-81', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LinkSection81ToPermitResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def mark_comment_as_read(self, body, work_reference_number, comment_reference_number, **kwargs):  # noqa: E501
        """mark_comment_as_read  # noqa: E501

        See business rules section 7.1 - Commenting on a works record Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mark_comment_as_read(body, work_reference_number, comment_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CommentReadRequest body: (required)
        :param str work_reference_number: (required)
        :param str comment_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.mark_comment_as_read_with_http_info(body, work_reference_number, comment_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.mark_comment_as_read_with_http_info(body, work_reference_number, comment_reference_number, **kwargs)  # noqa: E501
            return data

    def mark_comment_as_read_with_http_info(self, body, work_reference_number, comment_reference_number, **kwargs):  # noqa: E501
        """mark_comment_as_read  # noqa: E501

        See business rules section 7.1 - Commenting on a works record Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mark_comment_as_read_with_http_info(body, work_reference_number, comment_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CommentReadRequest body: (required)
        :param str work_reference_number: (required)
        :param str comment_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'comment_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_comment_as_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `mark_comment_as_read`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `mark_comment_as_read`")  # noqa: E501
        # verify the required parameter 'comment_reference_number' is set
        if ('comment_reference_number' not in params or
                params['comment_reference_number'] is None):
            raise ValueError("Missing the required parameter `comment_reference_number` when calling `mark_comment_as_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'comment_reference_number' in params:
            path_params['commentReferenceNumber'] = params['comment_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/comments/{commentReferenceNumber}/read', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def mark_permit_as_under_assessment(self, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """mark_permit_as_under_assessment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mark_permit_as_under_assessment(work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :param MarkPermitAsUnderAssessmentRequest body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.mark_permit_as_under_assessment_with_http_info(work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.mark_permit_as_under_assessment_with_http_info(work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
            return data

    def mark_permit_as_under_assessment_with_http_info(self, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """mark_permit_as_under_assessment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mark_permit_as_under_assessment_with_http_info(work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :param MarkPermitAsUnderAssessmentRequest body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'permit_reference_number', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_permit_as_under_assessment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `mark_permit_as_under_assessment`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `mark_permit_as_under_assessment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/under-assessment', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_comment(self, body, work_reference_number, **kwargs):  # noqa: E501
        """post_comment  # noqa: E501

        See business rules section 7.1 - Commenting on a works record Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_comment(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CommentCreateRequest body: (required)
        :param str work_reference_number: (required)
        :return: CommentCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_comment_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.post_comment_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
            return data

    def post_comment_with_http_info(self, body, work_reference_number, **kwargs):  # noqa: E501
        """post_comment  # noqa: E501

        See business rules section 7.1 - Commenting on a works record Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_comment_with_http_info(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CommentCreateRequest body: (required)
        :param str work_reference_number: (required)
        :return: CommentCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_comment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_comment`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `post_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/comments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommentCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reassign_section81(self, body, work_reference_number, section81_reference_number, **kwargs):  # noqa: E501
        """reassign_section81  # noqa: E501

        See business rules section 14 - Section 81 Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reassign_section81(body, work_reference_number, section81_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReassignSection81Request body: (required)
        :param str work_reference_number: (required)
        :param str section81_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reassign_section81_with_http_info(body, work_reference_number, section81_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.reassign_section81_with_http_info(body, work_reference_number, section81_reference_number, **kwargs)  # noqa: E501
            return data

    def reassign_section81_with_http_info(self, body, work_reference_number, section81_reference_number, **kwargs):  # noqa: E501
        """reassign_section81  # noqa: E501

        See business rules section 14 - Section 81 Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reassign_section81_with_http_info(body, work_reference_number, section81_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReassignSection81Request body: (required)
        :param str work_reference_number: (required)
        :param str section81_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'section81_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reassign_section81" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `reassign_section81`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `reassign_section81`")  # noqa: E501
        # verify the required parameter 'section81_reference_number' is set
        if ('section81_reference_number' not in params or
                params['section81_reference_number'] is None):
            raise ValueError("Missing the required parameter `section81_reference_number` when calling `reassign_section81`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'section81_reference_number' in params:
            path_params['section81ReferenceNumber'] = params['section81_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/section-81s/{section81ReferenceNumber}/reassign-section-81', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_ancillary_info(self, body, work_reference_number, permit_reference_number, ancillary_information_reference_number, **kwargs):  # noqa: E501
        """remove_ancillary_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_ancillary_info(body, work_reference_number, permit_reference_number, ancillary_information_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RemoveAncillaryInfoRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :param str ancillary_information_reference_number: (required)
        :return: RemoveAncillaryInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_ancillary_info_with_http_info(body, work_reference_number, permit_reference_number, ancillary_information_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_ancillary_info_with_http_info(body, work_reference_number, permit_reference_number, ancillary_information_reference_number, **kwargs)  # noqa: E501
            return data

    def remove_ancillary_info_with_http_info(self, body, work_reference_number, permit_reference_number, ancillary_information_reference_number, **kwargs):  # noqa: E501
        """remove_ancillary_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_ancillary_info_with_http_info(body, work_reference_number, permit_reference_number, ancillary_information_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RemoveAncillaryInfoRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :param str ancillary_information_reference_number: (required)
        :return: RemoveAncillaryInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number', 'ancillary_information_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_ancillary_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_ancillary_info`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `remove_ancillary_info`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `remove_ancillary_info`")  # noqa: E501
        # verify the required parameter 'ancillary_information_reference_number' is set
        if ('ancillary_information_reference_number' not in params or
                params['ancillary_information_reference_number'] is None):
            raise ValueError("Missing the required parameter `ancillary_information_reference_number` when calling `remove_ancillary_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501
        if 'ancillary_information_reference_number' in params:
            path_params['ancillaryInformationReferenceNumber'] = params['ancillary_information_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/ancillary-informations/{ancillaryInformationReferenceNumber}/remove', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RemoveAncillaryInfoResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revert_actual_start_date(self, body, work_reference_number, **kwargs):  # noqa: E501
        """revert_actual_start_date  # noqa: E501

        See business rules section 6.2 - Reverting works start Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revert_actual_start_date(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkStartRevertRequest body: (required)
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.revert_actual_start_date_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.revert_actual_start_date_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
            return data

    def revert_actual_start_date_with_http_info(self, body, work_reference_number, **kwargs):  # noqa: E501
        """revert_actual_start_date  # noqa: E501

        See business rules section 6.2 - Reverting works start Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revert_actual_start_date_with_http_info(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkStartRevertRequest body: (required)
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revert_actual_start_date" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `revert_actual_start_date`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `revert_actual_start_date`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/revert-start', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revert_actual_stop_date(self, body, work_reference_number, **kwargs):  # noqa: E501
        """revert_actual_stop_date  # noqa: E501

        See business rules section 6.4 - Reverting works stop Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revert_actual_stop_date(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkStopRevertRequest body: (required)
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.revert_actual_stop_date_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.revert_actual_stop_date_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
            return data

    def revert_actual_stop_date_with_http_info(self, body, work_reference_number, **kwargs):  # noqa: E501
        """revert_actual_stop_date  # noqa: E501

        See business rules section 6.4 - Reverting works stop Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revert_actual_stop_date_with_http_info(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkStopRevertRequest body: (required)
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revert_actual_stop_date" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `revert_actual_stop_date`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `revert_actual_stop_date`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/revert-stop', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def subsume_site(self, body, work_reference_number, site_reference_number, **kwargs):  # noqa: E501
        """subsume_site  # noqa: E501

        See business rules section 8 - Sites and reinstatements Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subsume_site(body, work_reference_number, site_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubsumeSiteRequest body: (required)
        :param str work_reference_number: (required)
        :param str site_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.subsume_site_with_http_info(body, work_reference_number, site_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.subsume_site_with_http_info(body, work_reference_number, site_reference_number, **kwargs)  # noqa: E501
            return data

    def subsume_site_with_http_info(self, body, work_reference_number, site_reference_number, **kwargs):  # noqa: E501
        """subsume_site  # noqa: E501

        See business rules section 8 - Sites and reinstatements Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subsume_site_with_http_info(body, work_reference_number, site_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubsumeSiteRequest body: (required)
        :param str work_reference_number: (required)
        :param str site_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'site_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subsume_site" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `subsume_site`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `subsume_site`")  # noqa: E501
        # verify the required parameter 'site_reference_number' is set
        if ('site_reference_number' not in params or
                params['site_reference_number'] is None):
            raise ValueError("Missing the required parameter `site_reference_number` when calling `subsume_site`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'site_reference_number' in params:
            path_params['siteReferenceNumber'] = params['site_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/sites/{siteReferenceNumber}/subsume', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unlink_section81_from_permit(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """unlink_section81_from_permit  # noqa: E501

        Removes a link between a Permit and a Section 81 Authenticated user must have one of the following roles: Planner, Contractor The Permit and Section 81 must both exist already, have a link created between them, and the authenticated user must have write access to the associated workstreams for both.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unlink_section81_from_permit(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UnlinkSection81FromPermitRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.unlink_section81_from_permit_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.unlink_section81_from_permit_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
            return data

    def unlink_section81_from_permit_with_http_info(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """unlink_section81_from_permit  # noqa: E501

        Removes a link between a Permit and a Section 81 Authenticated user must have one of the following roles: Planner, Contractor The Permit and Section 81 must both exist already, have a link created between them, and the authenticated user must have write access to the associated workstreams for both.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unlink_section81_from_permit_with_http_info(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UnlinkSection81FromPermitRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unlink_section81_from_permit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `unlink_section81_from_permit`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `unlink_section81_from_permit`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `unlink_section81_from_permit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/unlink-section-81', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_activity(self, body, activity_reference_number, **kwargs):  # noqa: E501
        """update_activity  # noqa: E501

        Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_activity(body, activity_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityUpdateRequest body: (required)
        :param str activity_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_activity_with_http_info(body, activity_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_activity_with_http_info(body, activity_reference_number, **kwargs)  # noqa: E501
            return data

    def update_activity_with_http_info(self, body, activity_reference_number, **kwargs):  # noqa: E501
        """update_activity  # noqa: E501

        Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_activity_with_http_info(body, activity_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityUpdateRequest body: (required)
        :param str activity_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'activity_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_activity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_activity`")  # noqa: E501
        # verify the required parameter 'activity_reference_number' is set
        if ('activity_reference_number' not in params or
                params['activity_reference_number'] is None):
            raise ValueError("Missing the required parameter `activity_reference_number` when calling `update_activity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_reference_number' in params:
            path_params['activityReferenceNumber'] = params['activity_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/activity/{activityReferenceNumber}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_actual_start_date(self, body, work_reference_number, **kwargs):  # noqa: E501
        """update_actual_start_date  # noqa: E501

        See business rules section 6.1 - Logging works start Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_actual_start_date(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkStartUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_actual_start_date_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_actual_start_date_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
            return data

    def update_actual_start_date_with_http_info(self, body, work_reference_number, **kwargs):  # noqa: E501
        """update_actual_start_date  # noqa: E501

        See business rules section 6.1 - Logging works start Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_actual_start_date_with_http_info(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkStartUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_actual_start_date" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_actual_start_date`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_actual_start_date`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/start', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_actual_stop_date(self, body, work_reference_number, **kwargs):  # noqa: E501
        """update_actual_stop_date  # noqa: E501

        See business rules section 6.3 - Logging works stop Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_actual_stop_date(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkStopUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_actual_stop_date_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_actual_stop_date_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
            return data

    def update_actual_stop_date_with_http_info(self, body, work_reference_number, **kwargs):  # noqa: E501
        """update_actual_stop_date  # noqa: E501

        See business rules section 6.3 - Logging works stop Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_actual_stop_date_with_http_info(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkStopUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_actual_stop_date" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_actual_stop_date`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_actual_stop_date`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/stop', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_assessment_status(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """update_assessment_status  # noqa: E501

        See business rule section 5 - Revoking a PA See business rule section 3.4.7 - PAA & PA assessment decision options Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_assessment_status(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitAssessmentUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_assessment_status_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_assessment_status_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
            return data

    def update_assessment_status_with_http_info(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """update_assessment_status  # noqa: E501

        See business rule section 5 - Revoking a PA See business rule section 3.4.7 - PAA & PA assessment decision options Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_assessment_status_with_http_info(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitAssessmentUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_assessment_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_assessment_status`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_assessment_status`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `update_assessment_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/assessment', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_current_traffic_management_type(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """update_current_traffic_management_type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_current_traffic_management_type(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CurrentTrafficManagementTypeRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_current_traffic_management_type_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_current_traffic_management_type_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
            return data

    def update_current_traffic_management_type_with_http_info(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """update_current_traffic_management_type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_current_traffic_management_type_with_http_info(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CurrentTrafficManagementTypeRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_current_traffic_management_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_current_traffic_management_type`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_current_traffic_management_type`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `update_current_traffic_management_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/current-traffic-management-type', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_excavation_carried_out(self, body, work_reference_number, **kwargs):  # noqa: E501
        """update_excavation_carried_out  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_excavation_carried_out(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ExcavationCarriedOutUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_excavation_carried_out_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_excavation_carried_out_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
            return data

    def update_excavation_carried_out_with_http_info(self, body, work_reference_number, **kwargs):  # noqa: E501
        """update_excavation_carried_out  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_excavation_carried_out_with_http_info(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ExcavationCarriedOutUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_excavation_carried_out" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_excavation_carried_out`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_excavation_carried_out`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/excavation-carried-out', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_final_reinstatement(self, body, work_reference_number, **kwargs):  # noqa: E501
        """update_final_reinstatement  # noqa: E501

        See business rules section 8.3 - Adding reinstatements  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_final_reinstatement(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FinalReinstatementUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_final_reinstatement_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_final_reinstatement_with_http_info(body, work_reference_number, **kwargs)  # noqa: E501
            return data

    def update_final_reinstatement_with_http_info(self, body, work_reference_number, **kwargs):  # noqa: E501
        """update_final_reinstatement  # noqa: E501

        See business rules section 8.3 - Adding reinstatements  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_final_reinstatement_with_http_info(body, work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FinalReinstatementUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_final_reinstatement" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_final_reinstatement`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_final_reinstatement`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/final-reinstatement', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_forward_plan(self, body, work_reference_number, forward_plan_reference_number, **kwargs):  # noqa: E501
        """update_forward_plan  # noqa: E501

        See business rules section 3.3 - Forward plans Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_forward_plan(body, work_reference_number, forward_plan_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ForwardPlanUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :param str forward_plan_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_forward_plan_with_http_info(body, work_reference_number, forward_plan_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_forward_plan_with_http_info(body, work_reference_number, forward_plan_reference_number, **kwargs)  # noqa: E501
            return data

    def update_forward_plan_with_http_info(self, body, work_reference_number, forward_plan_reference_number, **kwargs):  # noqa: E501
        """update_forward_plan  # noqa: E501

        See business rules section 3.3 - Forward plans Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_forward_plan_with_http_info(body, work_reference_number, forward_plan_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ForwardPlanUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :param str forward_plan_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'forward_plan_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_forward_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_forward_plan`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_forward_plan`")  # noqa: E501
        # verify the required parameter 'forward_plan_reference_number' is set
        if ('forward_plan_reference_number' not in params or
                params['forward_plan_reference_number'] is None):
            raise ValueError("Missing the required parameter `forward_plan_reference_number` when calling `update_forward_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'forward_plan_reference_number' in params:
            path_params['forwardPlanReferenceNumber'] = params['forward_plan_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/forward-plans/{forwardPlanReferenceNumber}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_fpn_status(self, body, work_reference_number, fpn_reference_number, **kwargs):  # noqa: E501
        """update_fpn_status  # noqa: E501

        See business rules section 11.2 - FPN statuses Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_fpn_status(body, work_reference_number, fpn_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FPNStatusUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :param str fpn_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_fpn_status_with_http_info(body, work_reference_number, fpn_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_fpn_status_with_http_info(body, work_reference_number, fpn_reference_number, **kwargs)  # noqa: E501
            return data

    def update_fpn_status_with_http_info(self, body, work_reference_number, fpn_reference_number, **kwargs):  # noqa: E501
        """update_fpn_status  # noqa: E501

        See business rules section 11.2 - FPN statuses Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_fpn_status_with_http_info(body, work_reference_number, fpn_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FPNStatusUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :param str fpn_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'fpn_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_fpn_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_fpn_status`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_fpn_status`")  # noqa: E501
        # verify the required parameter 'fpn_reference_number' is set
        if ('fpn_reference_number' not in params or
                params['fpn_reference_number'] is None):
            raise ValueError("Missing the required parameter `fpn_reference_number` when calling `update_fpn_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'fpn_reference_number' in params:
            path_params['fpnReferenceNumber'] = params['fpn_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/fixed-penalty-notices/{fpnReferenceNumber}/status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_geographical_area(self, file, geographical_area_reference_number2, internal_user_identifier, internal_user_name, geographical_area_reference_number, **kwargs):  # noqa: E501
        """update_geographical_area  # noqa: E501

        See API specification Resource Guide > Works API > Geographical Areas for more information Authenticated user must have one of the following roles: HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_geographical_area(file, geographical_area_reference_number2, internal_user_identifier, internal_user_name, geographical_area_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file: (required)
        :param str geographical_area_reference_number2: (required)
        :param str internal_user_identifier: (required)
        :param str internal_user_name: (required)
        :param str geographical_area_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_geographical_area_with_http_info(file, geographical_area_reference_number2, internal_user_identifier, internal_user_name, geographical_area_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_geographical_area_with_http_info(file, geographical_area_reference_number2, internal_user_identifier, internal_user_name, geographical_area_reference_number, **kwargs)  # noqa: E501
            return data

    def update_geographical_area_with_http_info(self, file, geographical_area_reference_number2, internal_user_identifier, internal_user_name, geographical_area_reference_number, **kwargs):  # noqa: E501
        """update_geographical_area  # noqa: E501

        See API specification Resource Guide > Works API > Geographical Areas for more information Authenticated user must have one of the following roles: HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_geographical_area_with_http_info(file, geographical_area_reference_number2, internal_user_identifier, internal_user_name, geographical_area_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file: (required)
        :param str geographical_area_reference_number2: (required)
        :param str internal_user_identifier: (required)
        :param str internal_user_name: (required)
        :param str geographical_area_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file', 'geographical_area_reference_number2', 'internal_user_identifier', 'internal_user_name', 'geographical_area_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_geographical_area" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `update_geographical_area`")  # noqa: E501
        # verify the required parameter 'geographical_area_reference_number2' is set
        if ('geographical_area_reference_number2' not in params or
                params['geographical_area_reference_number2'] is None):
            raise ValueError("Missing the required parameter `geographical_area_reference_number2` when calling `update_geographical_area`")  # noqa: E501
        # verify the required parameter 'internal_user_identifier' is set
        if ('internal_user_identifier' not in params or
                params['internal_user_identifier'] is None):
            raise ValueError("Missing the required parameter `internal_user_identifier` when calling `update_geographical_area`")  # noqa: E501
        # verify the required parameter 'internal_user_name' is set
        if ('internal_user_name' not in params or
                params['internal_user_name'] is None):
            raise ValueError("Missing the required parameter `internal_user_name` when calling `update_geographical_area`")  # noqa: E501
        # verify the required parameter 'geographical_area_reference_number' is set
        if ('geographical_area_reference_number' not in params or
                params['geographical_area_reference_number'] is None):
            raise ValueError("Missing the required parameter `geographical_area_reference_number` when calling `update_geographical_area`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'geographical_area_reference_number' in params:
            path_params['geographicalAreaReferenceNumber'] = params['geographical_area_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501
        if 'geographical_area_reference_number' in params:
            form_params.append(('geographicalAreaReferenceNumber', params['geographical_area_reference_number']))  # noqa: E501
        if 'internal_user_identifier' in params:
            form_params.append(('internalUserIdentifier', params['internal_user_identifier']))  # noqa: E501
        if 'internal_user_name' in params:
            form_params.append(('internalUserName', params['internal_user_name']))  # noqa: E501

        body_params = None
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/geographical-areas/{geographicalAreaReferenceNumber}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_inspection_outcome_status(self, body, work_reference_number, inspection_reference_number, **kwargs):  # noqa: E501
        """update_inspection_outcome_status  # noqa: E501

        See business rules section 10 - Inspections and non-compliance Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_inspection_outcome_status(body, work_reference_number, inspection_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InspectionOutcomeStatusRequest body: (required)
        :param str work_reference_number: (required)
        :param str inspection_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_inspection_outcome_status_with_http_info(body, work_reference_number, inspection_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_inspection_outcome_status_with_http_info(body, work_reference_number, inspection_reference_number, **kwargs)  # noqa: E501
            return data

    def update_inspection_outcome_status_with_http_info(self, body, work_reference_number, inspection_reference_number, **kwargs):  # noqa: E501
        """update_inspection_outcome_status  # noqa: E501

        See business rules section 10 - Inspections and non-compliance Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_inspection_outcome_status_with_http_info(body, work_reference_number, inspection_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InspectionOutcomeStatusRequest body: (required)
        :param str work_reference_number: (required)
        :param str inspection_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'inspection_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_inspection_outcome_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_inspection_outcome_status`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_inspection_outcome_status`")  # noqa: E501
        # verify the required parameter 'inspection_reference_number' is set
        if ('inspection_reference_number' not in params or
                params['inspection_reference_number'] is None):
            raise ValueError("Missing the required parameter `inspection_reference_number` when calling `update_inspection_outcome_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'inspection_reference_number' in params:
            path_params['inspectionReferenceNumber'] = params['inspection_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/inspections/{inspectionReferenceNumber}/status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_non_compliance_status(self, body, work_reference_number, non_compliance_reference_number, **kwargs):  # noqa: E501
        """update_non_compliance_status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_non_compliance_status(body, work_reference_number, non_compliance_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NonComplianceResponseStatusRequest body: (required)
        :param str work_reference_number: (required)
        :param str non_compliance_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_non_compliance_status_with_http_info(body, work_reference_number, non_compliance_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_non_compliance_status_with_http_info(body, work_reference_number, non_compliance_reference_number, **kwargs)  # noqa: E501
            return data

    def update_non_compliance_status_with_http_info(self, body, work_reference_number, non_compliance_reference_number, **kwargs):  # noqa: E501
        """update_non_compliance_status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_non_compliance_status_with_http_info(body, work_reference_number, non_compliance_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NonComplianceResponseStatusRequest body: (required)
        :param str work_reference_number: (required)
        :param str non_compliance_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'non_compliance_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_non_compliance_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_non_compliance_status`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_non_compliance_status`")  # noqa: E501
        # verify the required parameter 'non_compliance_reference_number' is set
        if ('non_compliance_reference_number' not in params or
                params['non_compliance_reference_number'] is None):
            raise ValueError("Missing the required parameter `non_compliance_reference_number` when calling `update_non_compliance_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'non_compliance_reference_number' in params:
            path_params['nonComplianceReferenceNumber'] = params['non_compliance_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/non-compliances/{nonComplianceReferenceNumber}/status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_permit_alteration_status(self, body, work_reference_number, permit_reference_number, permit_alteration_reference_number, **kwargs):  # noqa: E501
        """update_permit_alteration_status  # noqa: E501

        See business rules section 4.7 - Change request statuses Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_permit_alteration_status(body, work_reference_number, permit_reference_number, permit_alteration_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitAlterationStatusUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :param str permit_alteration_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_permit_alteration_status_with_http_info(body, work_reference_number, permit_reference_number, permit_alteration_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_permit_alteration_status_with_http_info(body, work_reference_number, permit_reference_number, permit_alteration_reference_number, **kwargs)  # noqa: E501
            return data

    def update_permit_alteration_status_with_http_info(self, body, work_reference_number, permit_reference_number, permit_alteration_reference_number, **kwargs):  # noqa: E501
        """update_permit_alteration_status  # noqa: E501

        See business rules section 4.7 - Change request statuses Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_permit_alteration_status_with_http_info(body, work_reference_number, permit_reference_number, permit_alteration_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitAlterationStatusUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :param str permit_alteration_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number', 'permit_alteration_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_permit_alteration_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_permit_alteration_status`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_permit_alteration_status`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `update_permit_alteration_status`")  # noqa: E501
        # verify the required parameter 'permit_alteration_reference_number' is set
        if ('permit_alteration_reference_number' not in params or
                params['permit_alteration_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_alteration_reference_number` when calling `update_permit_alteration_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501
        if 'permit_alteration_reference_number' in params:
            path_params['permitAlterationReferenceNumber'] = params['permit_alteration_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/alterations/{permitAlterationReferenceNumber}/status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_permit_discount(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """update_permit_discount  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_permit_discount(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitDiscountUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_permit_discount_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_permit_discount_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
            return data

    def update_permit_discount_with_http_info(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """update_permit_discount  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_permit_discount_with_http_info(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitDiscountUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_permit_discount" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_permit_discount`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_permit_discount`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `update_permit_discount`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/permit-discount', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_permit_duration_challenge_non_acceptance_response(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """update_permit_duration_challenge_non_acceptance_response  # noqa: E501

        See business rules section 21.1 - Duration challenge review Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_permit_duration_challenge_non_acceptance_response(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitDurationChallengeNonAcceptanceResponseRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_permit_duration_challenge_non_acceptance_response_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_permit_duration_challenge_non_acceptance_response_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
            return data

    def update_permit_duration_challenge_non_acceptance_response_with_http_info(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """update_permit_duration_challenge_non_acceptance_response  # noqa: E501

        See business rules section 21.1 - Duration challenge review Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_permit_duration_challenge_non_acceptance_response_with_http_info(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitDurationChallengeNonAcceptanceResponseRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_permit_duration_challenge_non_acceptance_response" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_permit_duration_challenge_non_acceptance_response`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_permit_duration_challenge_non_acceptance_response`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `update_permit_duration_challenge_non_acceptance_response`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/duration-challenge-non-acceptance-response', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_permit_duration_challenge_review(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """update_permit_duration_challenge_review  # noqa: E501

        See business rules section 21.1 - Duration challenge review Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_permit_duration_challenge_review(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitDurationChallengeReviewRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_permit_duration_challenge_review_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_permit_duration_challenge_review_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
            return data

    def update_permit_duration_challenge_review_with_http_info(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """update_permit_duration_challenge_review  # noqa: E501

        See business rules section 21.1 - Duration challenge review Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_permit_duration_challenge_review_with_http_info(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitDurationChallengeReviewRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_permit_duration_challenge_review" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_permit_duration_challenge_review`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_permit_duration_challenge_review`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `update_permit_duration_challenge_review`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/duration-challenge-review', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_permit_lane_rental_assessment(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """update_permit_lane_rental_assessment  # noqa: E501

        See business rule section 12.2 - Adding a lane rental assessment to a PA Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_permit_lane_rental_assessment(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitLaneRentalAssessmentUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_permit_lane_rental_assessment_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_permit_lane_rental_assessment_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
            return data

    def update_permit_lane_rental_assessment_with_http_info(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """update_permit_lane_rental_assessment  # noqa: E501

        See business rule section 12.2 - Adding a lane rental assessment to a PA Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_permit_lane_rental_assessment_with_http_info(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitLaneRentalAssessmentUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_permit_lane_rental_assessment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_permit_lane_rental_assessment`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_permit_lane_rental_assessment`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `update_permit_lane_rental_assessment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/lane-rental-assessments', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_permit_status(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """update_permit_status  # noqa: E501

        See business rules section 3.4.9 - Cancelling PAA & PA Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_permit_status(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitStatusUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_permit_status_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_permit_status_with_http_info(body, work_reference_number, permit_reference_number, **kwargs)  # noqa: E501
            return data

    def update_permit_status_with_http_info(self, body, work_reference_number, permit_reference_number, **kwargs):  # noqa: E501
        """update_permit_status  # noqa: E501

        See business rules section 3.4.9 - Cancelling PAA & PA Authenticated user must have one of the following roles: Planner, Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_permit_status_with_http_info(body, work_reference_number, permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermitStatusUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :param str permit_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'permit_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_permit_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_permit_status`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_permit_status`")  # noqa: E501
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `update_permit_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'permit_reference_number' in params:
            path_params['permitReferenceNumber'] = params['permit_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/permits/{permitReferenceNumber}/status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_section58_status(self, body, section58_reference_number, **kwargs):  # noqa: E501
        """update_section58_status  # noqa: E501

        See business rules section 22 - Section 58s Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_section58_status(body, section58_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Section58UpdateStatusRequest body: (required)
        :param str section58_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_section58_status_with_http_info(body, section58_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_section58_status_with_http_info(body, section58_reference_number, **kwargs)  # noqa: E501
            return data

    def update_section58_status_with_http_info(self, body, section58_reference_number, **kwargs):  # noqa: E501
        """update_section58_status  # noqa: E501

        See business rules section 22 - Section 58s Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_section58_status_with_http_info(body, section58_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Section58UpdateStatusRequest body: (required)
        :param str section58_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'section58_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_section58_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_section58_status`")  # noqa: E501
        # verify the required parameter 'section58_reference_number' is set
        if ('section58_reference_number' not in params or
                params['section58_reference_number'] is None):
            raise ValueError("Missing the required parameter `section58_reference_number` when calling `update_section58_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'section58_reference_number' in params:
            path_params['section58ReferenceNumber'] = params['section58_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/section-58s/{section58ReferenceNumber}/status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_section74_ha_status(self, body, work_reference_number, section74_reference_number, **kwargs):  # noqa: E501
        """update_section74_ha_status  # noqa: E501

        See business rules section 20 - Section 74s Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_section74_ha_status(body, work_reference_number, section74_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Section74UpdateHAStatusRequest body: (required)
        :param str work_reference_number: (required)
        :param str section74_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_section74_ha_status_with_http_info(body, work_reference_number, section74_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_section74_ha_status_with_http_info(body, work_reference_number, section74_reference_number, **kwargs)  # noqa: E501
            return data

    def update_section74_ha_status_with_http_info(self, body, work_reference_number, section74_reference_number, **kwargs):  # noqa: E501
        """update_section74_ha_status  # noqa: E501

        See business rules section 20 - Section 74s Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_section74_ha_status_with_http_info(body, work_reference_number, section74_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Section74UpdateHAStatusRequest body: (required)
        :param str work_reference_number: (required)
        :param str section74_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'section74_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_section74_ha_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_section74_ha_status`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_section74_ha_status`")  # noqa: E501
        # verify the required parameter 'section74_reference_number' is set
        if ('section74_reference_number' not in params or
                params['section74_reference_number'] is None):
            raise ValueError("Missing the required parameter `section74_reference_number` when calling `update_section74_ha_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'section74_reference_number' in params:
            path_params['section74ReferenceNumber'] = params['section74_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/section-74s/{section74ReferenceNumber}/highway-authority-status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_section74_promoter_status(self, body, work_reference_number, section74_reference_number, **kwargs):  # noqa: E501
        """update_section74_promoter_status  # noqa: E501

        See business rules section 20 - Section 74s Authenticated user must have one of the following roles: Planner or Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_section74_promoter_status(body, work_reference_number, section74_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Section74UpdatePromoterStatusRequest body: (required)
        :param str work_reference_number: (required)
        :param str section74_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_section74_promoter_status_with_http_info(body, work_reference_number, section74_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_section74_promoter_status_with_http_info(body, work_reference_number, section74_reference_number, **kwargs)  # noqa: E501
            return data

    def update_section74_promoter_status_with_http_info(self, body, work_reference_number, section74_reference_number, **kwargs):  # noqa: E501
        """update_section74_promoter_status  # noqa: E501

        See business rules section 20 - Section 74s Authenticated user must have one of the following roles: Planner or Contractor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_section74_promoter_status_with_http_info(body, work_reference_number, section74_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Section74UpdatePromoterStatusRequest body: (required)
        :param str work_reference_number: (required)
        :param str section74_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'section74_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_section74_promoter_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_section74_promoter_status`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_section74_promoter_status`")  # noqa: E501
        # verify the required parameter 'section74_reference_number' is set
        if ('section74_reference_number' not in params or
                params['section74_reference_number'] is None):
            raise ValueError("Missing the required parameter `section74_reference_number` when calling `update_section74_promoter_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'section74_reference_number' in params:
            path_params['section74ReferenceNumber'] = params['section74_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/section-74s/{section74ReferenceNumber}/promoter-status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_section81_status(self, body, work_reference_number, section81_reference_number, **kwargs):  # noqa: E501
        """update_section81_status  # noqa: E501

        See business rules section 14.5 - S81 statuses Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_section81_status(body, work_reference_number, section81_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Section81StatusUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :param str section81_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_section81_status_with_http_info(body, work_reference_number, section81_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.update_section81_status_with_http_info(body, work_reference_number, section81_reference_number, **kwargs)  # noqa: E501
            return data

    def update_section81_status_with_http_info(self, body, work_reference_number, section81_reference_number, **kwargs):  # noqa: E501
        """update_section81_status  # noqa: E501

        See business rules section 14.5 - S81 statuses Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_section81_status_with_http_info(body, work_reference_number, section81_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Section81StatusUpdateRequest body: (required)
        :param str work_reference_number: (required)
        :param str section81_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'section81_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_section81_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_section81_status`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `update_section81_status`")  # noqa: E501
        # verify the required parameter 'section81_reference_number' is set
        if ('section81_reference_number' not in params or
                params['section81_reference_number'] is None):
            raise ValueError("Missing the required parameter `section81_reference_number` when calling `update_section81_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'section81_reference_number' in params:
            path_params['section81ReferenceNumber'] = params['section81_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/section-81s/{section81ReferenceNumber}/status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_file(self, file, **kwargs):  # noqa: E501
        """upload_file  # noqa: E501

        See API specification Resource Guide > Works API > File upload for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_file(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file: (required)
        :param str swa_code:
        :return: FileSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_file_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_file_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def upload_file_with_http_info(self, file, **kwargs):  # noqa: E501
        """upload_file  # noqa: E501

        See API specification Resource Guide > Works API > File upload for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_file_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file: (required)
        :param str swa_code:
        :return: FileSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file', 'swa_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `upload_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'swa_code' in params:
            query_params.append(('swaCode', params['swa_code']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/files', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileSummaryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def withdraw_inspection(self, body, work_reference_number, inspection_reference_number, **kwargs):  # noqa: E501
        """withdraw_inspection  # noqa: E501

        See business rules section 10 - Inspections and non-compliance Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.withdraw_inspection(body, work_reference_number, inspection_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InspectionWithdrawRequest body: (required)
        :param str work_reference_number: (required)
        :param str inspection_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.withdraw_inspection_with_http_info(body, work_reference_number, inspection_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.withdraw_inspection_with_http_info(body, work_reference_number, inspection_reference_number, **kwargs)  # noqa: E501
            return data

    def withdraw_inspection_with_http_info(self, body, work_reference_number, inspection_reference_number, **kwargs):  # noqa: E501
        """withdraw_inspection  # noqa: E501

        See business rules section 10 - Inspections and non-compliance Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.withdraw_inspection_with_http_info(body, work_reference_number, inspection_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InspectionWithdrawRequest body: (required)
        :param str work_reference_number: (required)
        :param str inspection_reference_number: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'work_reference_number', 'inspection_reference_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method withdraw_inspection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `withdraw_inspection`")  # noqa: E501
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `withdraw_inspection`")  # noqa: E501
        # verify the required parameter 'inspection_reference_number' is set
        if ('inspection_reference_number' not in params or
                params['inspection_reference_number'] is None):
            raise ValueError("Missing the required parameter `inspection_reference_number` when calling `withdraw_inspection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'work_reference_number' in params:
            path_params['workReferenceNumber'] = params['work_reference_number']  # noqa: E501
        if 'inspection_reference_number' in params:
            path_params['inspectionReferenceNumber'] = params['inspection_reference_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/{workReferenceNumber}/inspections/{inspectionReferenceNumber}/withdraw', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
