# swagger-client
See API specification Resource Guide > Street Lookup API for more information on endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.StreetsRequest() # StreetsRequest | 

try:
    api_response = api_instance.get_streets(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_streets: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
query = 'query_example' # str | 

try:
    api_response = api_instance.get_streets_by_query(query)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_streets_by_query: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
usrn = 1.2 # float | 

try:
    api_response = api_instance.get_streets_by_usrn(usrn)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_streets_by_usrn: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://department-for-transport-streetmanager.github.io/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**get_streets**](docs/DefaultApi.md#get_streets) | **POST** /nsg/streets/search | 
*DefaultApi* | [**get_streets_by_query**](docs/DefaultApi.md#get_streets_by_query) | **GET** /nsg/search | 
*DefaultApi* | [**get_streets_by_usrn**](docs/DefaultApi.md#get_streets_by_usrn) | **GET** /nsg/streets/{usrn} | 

## Documentation For Models

 - [AdditionalSpecialDesignationCodeResponse](docs/AdditionalSpecialDesignationCodeResponse.md)
 - [AdditionalSpecialDesignationsPeriodicityCodeResponse](docs/AdditionalSpecialDesignationsPeriodicityCodeResponse.md)
 - [AdditionalSpecialDesignationsResponse](docs/AdditionalSpecialDesignationsResponse.md)
 - [AllOfAdditionalSpecialDesignationsResponseAsdCoordinateGeometry](docs/AllOfAdditionalSpecialDesignationsResponseAsdCoordinateGeometry.md)
 - [AllOfAdditionalSpecialDesignationsResponseSpecialDesigPeriodicityCode](docs/AllOfAdditionalSpecialDesignationsResponseSpecialDesigPeriodicityCode.md)
 - [AllOfStreetResponseStreetCentrePoint](docs/AllOfStreetResponseStreetCentrePoint.md)
 - [AllOfStreetResponseStreetLine](docs/AllOfStreetResponseStreetLine.md)
 - [Coordinates](docs/Coordinates.md)
 - [GeoJSONCentrePoint](docs/GeoJSONCentrePoint.md)
 - [GeoJSONCentrePointType](docs/GeoJSONCentrePointType.md)
 - [GeoJSONFeatureTypeResponse](docs/GeoJSONFeatureTypeResponse.md)
 - [GeoJSONGeometry](docs/GeoJSONGeometry.md)
 - [GeoJSONMultiLineString](docs/GeoJSONMultiLineString.md)
 - [GeoJSONMultiLineStringType](docs/GeoJSONMultiLineStringType.md)
 - [InterestAuthority](docs/InterestAuthority.md)
 - [PrimaryNoticeAuthority](docs/PrimaryNoticeAuthority.md)
 - [ReinstatementTypeCodeResponse](docs/ReinstatementTypeCodeResponse.md)
 - [ReinstatementTypeDetails](docs/ReinstatementTypeDetails.md)
 - [StreetResponse](docs/StreetResponse.md)
 - [StreetSummaryResponse](docs/StreetSummaryResponse.md)
 - [StreetsRequest](docs/StreetsRequest.md)
 - [UsrnStreetRequest](docs/UsrnStreetRequest.md)

## Documentation For Authorization


## token

- **Type**: API key
- **API key parameter name**: token
- **Location**: HTTP header


## Author


