# swagger-client
See API specification Resource Guide > Work API for more information on endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.HS2AcknowledgementRequest() # HS2AcknowledgementRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 

try:
    api_instance.acknowledge_hs2_permit(body, work_reference_number, permit_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->acknowledge_hs2_permit: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.AddFileToWorkRequest() # AddFileToWorkRequest | 
work_reference_number = 'work_reference_number_example' # str | 

try:
    api_instance.add_file_to_work(body, work_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->add_file_to_work: %s\n" % e)

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.AuthenticationRequest() # AuthenticationRequest | 

try:
    api_response = api_instance.authenticate(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->authenticate: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
start_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)

try:
    api_response = api_instance.calculate_duration(start_date=start_date, end_date=end_date)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->calculate_duration: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.ActivityCancelRequest() # ActivityCancelRequest | 
activity_reference_number = 'activity_reference_number_example' # str | 

try:
    api_instance.cancel_activity(body, activity_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->cancel_activity: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.ForwardPlanCancelRequest() # ForwardPlanCancelRequest | 
work_reference_number = 'work_reference_number_example' # str | 
forward_plan_reference_number = 'forward_plan_reference_number_example' # str | 

try:
    api_instance.cancel_forward_plan(body, work_reference_number, forward_plan_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->cancel_forward_plan: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PrivateStreetNoticeCancelRequest() # PrivateStreetNoticeCancelRequest | 
work_reference_number = 'work_reference_number_example' # str | 
private_street_reference_number = 'private_street_reference_number_example' # str | 

try:
    api_instance.cancel_private_street_notice(body, work_reference_number, private_street_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->cancel_private_street_notice: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.ActivityCreateRequest() # ActivityCreateRequest | 

try:
    api_response = api_instance.create_activity(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_activity: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.CreateAncillaryInfoRequest() # CreateAncillaryInfoRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 

try:
    api_response = api_instance.create_ancillary_info(body, work_reference_number, permit_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_ancillary_info: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.ForwardPlanCreateRequest() # ForwardPlanCreateRequest | 

try:
    api_response = api_instance.create_forward_plan(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_forward_plan: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.FPNCreateRequest() # FPNCreateRequest | 
work_reference_number = 'work_reference_number_example' # str | 

try:
    api_response = api_instance.create_fpn(body, work_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_fpn: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
file = 'file_example' # str | 
internal_user_identifier = 'internal_user_identifier_example' # str | 
internal_user_name = 'internal_user_name_example' # str | 

try:
    api_response = api_instance.create_geographical_area(file, internal_user_identifier, internal_user_name)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_geographical_area: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.HistoricFPNCreateRequest() # HistoricFPNCreateRequest | 

try:
    api_response = api_instance.create_historic_fpn(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_historic_fpn: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.HistoricInspectionCreateRequest() # HistoricInspectionCreateRequest | 

try:
    api_response = api_instance.create_historic_inspection(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_historic_inspection: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.InspectionCreateRequest() # InspectionCreateRequest | 
work_reference_number = 'work_reference_number_example' # str | 

try:
    api_response = api_instance.create_inspection(body, work_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_inspection: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.MaterialClassificationCreateRequest() # MaterialClassificationCreateRequest | 

try:
    api_response = api_instance.create_materials_classification(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_materials_classification: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.NonNotifiableSiteCreateRequest() # NonNotifiableSiteCreateRequest | 

try:
    api_response = api_instance.create_non_notifiable_site(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_non_notifiable_site: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PermitCreateRequest() # PermitCreateRequest | 
work_reference_number = 'work_reference_number_example' # str | 

try:
    api_response = api_instance.create_permit(body, work_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_permit: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PermitAlterationCreateRequest() # PermitAlterationCreateRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 

try:
    api_response = api_instance.create_permit_alteration(body, work_reference_number, permit_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_permit_alteration: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PrivateStreetNoticeCreateRequest() # PrivateStreetNoticeCreateRequest | 

try:
    api_response = api_instance.create_private_street_notice(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_private_street_notice: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.ReinstatementCreateRequest() # ReinstatementCreateRequest | 
work_reference_number = 'work_reference_number_example' # str | 
site_reference_number = 'site_reference_number_example' # str | 

try:
    api_response = api_instance.create_reinstatement(body, work_reference_number, site_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_reinstatement: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.ScheduledInspectionCreateRequest() # ScheduledInspectionCreateRequest | 
work_reference_number = 'work_reference_number_example' # str | 

try:
    api_instance.create_scheduled_inspection(body, work_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->create_scheduled_inspection: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.Section58CreateRequest() # Section58CreateRequest | 

try:
    api_response = api_instance.create_section58(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_section58: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.Section74CreateRequest() # Section74CreateRequest | 
work_reference_number = 'work_reference_number_example' # str | 

try:
    api_response = api_instance.create_section74(body, work_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_section74: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.Section81CreateRequest() # Section81CreateRequest | 

try:
    api_response = api_instance.create_section81(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_section81: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.SiteCreateRequest() # SiteCreateRequest | 
work_reference_number = 'work_reference_number_example' # str | 

try:
    api_response = api_instance.create_site(body, work_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_site: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.WorkCreateRequest() # WorkCreateRequest | 

try:
    api_response = api_instance.create_work(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_work: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
file_id = 1.2 # float | 

try:
    api_instance.delete_file(file_id)
except ApiException as e:
    print("Exception when calling DefaultApi->delete_file: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
fpn_reference_number = 'fpn_reference_number_example' # str | 

try:
    api_instance.delete_fpn(work_reference_number, fpn_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->delete_fpn: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
inspection_reference_number = 'inspection_reference_number_example' # str | 

try:
    api_instance.delete_inspection(work_reference_number, inspection_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->delete_inspection: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
site_reference_number = 'site_reference_number_example' # str | 
reinstatement_reference_number = 'reinstatement_reference_number_example' # str | 

try:
    api_instance.delete_reinstatement(work_reference_number, site_reference_number, reinstatement_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->delete_reinstatement: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 

try:
    api_instance.delete_scheduled_inspection(work_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->delete_scheduled_inspection: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PermitAlterationDurationChallengeNonAcceptanceResponseRequest() # PermitAlterationDurationChallengeNonAcceptanceResponseRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 
permit_alteration_reference_number = 'permit_alteration_reference_number_example' # str | 

try:
    api_instance.duration_challenge_non_acceptance_response(body, work_reference_number, permit_reference_number, permit_alteration_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->duration_challenge_non_acceptance_response: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PermitAlterationDurationChallengeReviewRequest() # PermitAlterationDurationChallengeReviewRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 
permit_alteration_reference_number = 'permit_alteration_reference_number_example' # str | 

try:
    api_instance.duration_challenge_review(body, work_reference_number, permit_reference_number, permit_alteration_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->duration_challenge_review: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
activity_reference_number = 'activity_reference_number_example' # str | 

try:
    api_response = api_instance.get_activity(activity_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_activity: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 
ancillary_information_reference_number = 'ancillary_information_reference_number_example' # str | 

try:
    api_response = api_instance.get_ancillary_info(work_reference_number, permit_reference_number, ancillary_information_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_ancillary_info: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
comment_reference_number = 'comment_reference_number_example' # str | 

try:
    api_response = api_instance.get_comment(work_reference_number, comment_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_comment: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 

try:
    api_response = api_instance.get_earliest_permit(work_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_earliest_permit: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
organisation_reference = 'organisation_reference_example' # str | 

try:
    api_response = api_instance.get_fee_matrix(organisation_reference)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_fee_matrix: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
file_id = 56 # int | 

try:
    api_response = api_instance.get_file(file_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_file: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
forward_plan_reference_number = 'forward_plan_reference_number_example' # str | 

try:
    api_response = api_instance.get_forward_plan(work_reference_number, forward_plan_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_forward_plan: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
fpn_reference_number = 'fpn_reference_number_example' # str | 

try:
    api_response = api_instance.get_fpn(work_reference_number, fpn_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_fpn: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
inspection_reference_number = 'inspection_reference_number_example' # str | 

try:
    api_response = api_instance.get_inspection(work_reference_number, inspection_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_inspection: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
material_classification_reference_number = 'material_classification_reference_number_example' # str | 

try:
    api_response = api_instance.get_material_classification(material_classification_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_material_classification: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
non_compliance_reference_number = 'non_compliance_reference_number_example' # str | 

try:
    api_response = api_instance.get_non_compliance(work_reference_number, non_compliance_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_non_compliance: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 

try:
    api_response = api_instance.get_permit(work_reference_number, permit_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_permit: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 
permit_alteration_reference_number = 'permit_alteration_reference_number_example' # str | 

try:
    api_response = api_instance.get_permit_alteration(work_reference_number, permit_reference_number, permit_alteration_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_permit_alteration: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
private_street_reference_number = 'private_street_reference_number_example' # str | 

try:
    api_response = api_instance.get_private_street_notice(work_reference_number, private_street_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_private_street_notice: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
section58_reference_number = 'section58_reference_number_example' # str | 

try:
    api_response = api_instance.get_section58(section58_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_section58: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
section74_reference_number = 'section74_reference_number_example' # str | 

try:
    api_response = api_instance.get_section74(work_reference_number, section74_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_section74: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
section81_reference_number = 'section81_reference_number_example' # str | 

try:
    api_response = api_instance.get_section81(work_reference_number, section81_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_section81: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
site_reference_number = 'site_reference_number_example' # str | 

try:
    api_response = api_instance.get_site(work_reference_number, site_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_site: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 

try:
    api_response = api_instance.get_work(work_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_work: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_type = swagger_client.WorkType() # WorkType | 
proposed_start_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
proposed_end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
is_ttro_required = true # bool |  (optional)
immediate_risk = true # bool |  (optional)
work_reference_number = 'work_reference_number_example' # str |  (optional)
activity_type = swagger_client.ActivityType() # ActivityType |  (optional)

try:
    api_response = api_instance.get_work_category(work_type, proposed_start_date=proposed_start_date, proposed_end_date=proposed_end_date, is_ttro_required=is_ttro_required, immediate_risk=immediate_risk, work_reference_number=work_reference_number, activity_type=activity_type)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_work_category: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
offset = 1.2 # float |  (optional)

try:
    api_response = api_instance.get_work_history(work_reference_number, offset=offset)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_work_history: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.ImposeChangeRequest() # ImposeChangeRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 

try:
    api_response = api_instance.impose_change(body, work_reference_number, permit_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->impose_change: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PermitNonComplianceLinkRequest() # PermitNonComplianceLinkRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 

try:
    api_instance.link_permit_to_non_compliance(body, work_reference_number, permit_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->link_permit_to_non_compliance: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.LinkSection81ToPermitRequest() # LinkSection81ToPermitRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 

try:
    api_response = api_instance.link_section81_to_permit(body, work_reference_number, permit_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->link_section81_to_permit: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.CommentReadRequest() # CommentReadRequest | 
work_reference_number = 'work_reference_number_example' # str | 
comment_reference_number = 'comment_reference_number_example' # str | 

try:
    api_instance.mark_comment_as_read(body, work_reference_number, comment_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->mark_comment_as_read: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 
body = swagger_client.MarkPermitAsUnderAssessmentRequest() # MarkPermitAsUnderAssessmentRequest |  (optional)

try:
    api_instance.mark_permit_as_under_assessment(work_reference_number, permit_reference_number, body=body)
except ApiException as e:
    print("Exception when calling DefaultApi->mark_permit_as_under_assessment: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.CommentCreateRequest() # CommentCreateRequest | 
work_reference_number = 'work_reference_number_example' # str | 

try:
    api_response = api_instance.post_comment(body, work_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->post_comment: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.ReassignSection81Request() # ReassignSection81Request | 
work_reference_number = 'work_reference_number_example' # str | 
section81_reference_number = 'section81_reference_number_example' # str | 

try:
    api_instance.reassign_section81(body, work_reference_number, section81_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->reassign_section81: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.RemoveAncillaryInfoRequest() # RemoveAncillaryInfoRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 
ancillary_information_reference_number = 'ancillary_information_reference_number_example' # str | 

try:
    api_response = api_instance.remove_ancillary_info(body, work_reference_number, permit_reference_number, ancillary_information_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->remove_ancillary_info: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.WorkStartRevertRequest() # WorkStartRevertRequest | 
work_reference_number = 'work_reference_number_example' # str | 

try:
    api_instance.revert_actual_start_date(body, work_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->revert_actual_start_date: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.WorkStopRevertRequest() # WorkStopRevertRequest | 
work_reference_number = 'work_reference_number_example' # str | 

try:
    api_instance.revert_actual_stop_date(body, work_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->revert_actual_stop_date: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.SubsumeSiteRequest() # SubsumeSiteRequest | 
work_reference_number = 'work_reference_number_example' # str | 
site_reference_number = 'site_reference_number_example' # str | 

try:
    api_instance.subsume_site(body, work_reference_number, site_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->subsume_site: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.UnlinkSection81FromPermitRequest() # UnlinkSection81FromPermitRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 

try:
    api_instance.unlink_section81_from_permit(body, work_reference_number, permit_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->unlink_section81_from_permit: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.ActivityUpdateRequest() # ActivityUpdateRequest | 
activity_reference_number = 'activity_reference_number_example' # str | 

try:
    api_instance.update_activity(body, activity_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_activity: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.WorkStartUpdateRequest() # WorkStartUpdateRequest | 
work_reference_number = 'work_reference_number_example' # str | 

try:
    api_instance.update_actual_start_date(body, work_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_actual_start_date: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.WorkStopUpdateRequest() # WorkStopUpdateRequest | 
work_reference_number = 'work_reference_number_example' # str | 

try:
    api_instance.update_actual_stop_date(body, work_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_actual_stop_date: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PermitAssessmentUpdateRequest() # PermitAssessmentUpdateRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 

try:
    api_instance.update_assessment_status(body, work_reference_number, permit_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_assessment_status: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.CurrentTrafficManagementTypeRequest() # CurrentTrafficManagementTypeRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 

try:
    api_instance.update_current_traffic_management_type(body, work_reference_number, permit_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_current_traffic_management_type: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.ExcavationCarriedOutUpdateRequest() # ExcavationCarriedOutUpdateRequest | 
work_reference_number = 'work_reference_number_example' # str | 

try:
    api_instance.update_excavation_carried_out(body, work_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_excavation_carried_out: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.FinalReinstatementUpdateRequest() # FinalReinstatementUpdateRequest | 
work_reference_number = 'work_reference_number_example' # str | 

try:
    api_instance.update_final_reinstatement(body, work_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_final_reinstatement: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.ForwardPlanUpdateRequest() # ForwardPlanUpdateRequest | 
work_reference_number = 'work_reference_number_example' # str | 
forward_plan_reference_number = 'forward_plan_reference_number_example' # str | 

try:
    api_instance.update_forward_plan(body, work_reference_number, forward_plan_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_forward_plan: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.FPNStatusUpdateRequest() # FPNStatusUpdateRequest | 
work_reference_number = 'work_reference_number_example' # str | 
fpn_reference_number = 'fpn_reference_number_example' # str | 

try:
    api_instance.update_fpn_status(body, work_reference_number, fpn_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_fpn_status: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
file = 'file_example' # str | 
geographical_area_reference_number2 = 'geographical_area_reference_number_example' # str | 
internal_user_identifier = 'internal_user_identifier_example' # str | 
internal_user_name = 'internal_user_name_example' # str | 
geographical_area_reference_number = 'geographical_area_reference_number_example' # str | 

try:
    api_instance.update_geographical_area(file, geographical_area_reference_number2, internal_user_identifier, internal_user_name, geographical_area_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_geographical_area: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.InspectionOutcomeStatusRequest() # InspectionOutcomeStatusRequest | 
work_reference_number = 'work_reference_number_example' # str | 
inspection_reference_number = 'inspection_reference_number_example' # str | 

try:
    api_instance.update_inspection_outcome_status(body, work_reference_number, inspection_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_inspection_outcome_status: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.NonComplianceResponseStatusRequest() # NonComplianceResponseStatusRequest | 
work_reference_number = 'work_reference_number_example' # str | 
non_compliance_reference_number = 'non_compliance_reference_number_example' # str | 

try:
    api_instance.update_non_compliance_status(body, work_reference_number, non_compliance_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_non_compliance_status: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PermitAlterationStatusUpdateRequest() # PermitAlterationStatusUpdateRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 
permit_alteration_reference_number = 'permit_alteration_reference_number_example' # str | 

try:
    api_instance.update_permit_alteration_status(body, work_reference_number, permit_reference_number, permit_alteration_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_permit_alteration_status: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PermitDiscountUpdateRequest() # PermitDiscountUpdateRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 

try:
    api_instance.update_permit_discount(body, work_reference_number, permit_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_permit_discount: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PermitDurationChallengeNonAcceptanceResponseRequest() # PermitDurationChallengeNonAcceptanceResponseRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 

try:
    api_instance.update_permit_duration_challenge_non_acceptance_response(body, work_reference_number, permit_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_permit_duration_challenge_non_acceptance_response: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PermitDurationChallengeReviewRequest() # PermitDurationChallengeReviewRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 

try:
    api_instance.update_permit_duration_challenge_review(body, work_reference_number, permit_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_permit_duration_challenge_review: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PermitLaneRentalAssessmentUpdateRequest() # PermitLaneRentalAssessmentUpdateRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 

try:
    api_instance.update_permit_lane_rental_assessment(body, work_reference_number, permit_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_permit_lane_rental_assessment: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PermitStatusUpdateRequest() # PermitStatusUpdateRequest | 
work_reference_number = 'work_reference_number_example' # str | 
permit_reference_number = 'permit_reference_number_example' # str | 

try:
    api_instance.update_permit_status(body, work_reference_number, permit_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_permit_status: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.Section58UpdateStatusRequest() # Section58UpdateStatusRequest | 
section58_reference_number = 'section58_reference_number_example' # str | 

try:
    api_instance.update_section58_status(body, section58_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_section58_status: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.Section74UpdateHAStatusRequest() # Section74UpdateHAStatusRequest | 
work_reference_number = 'work_reference_number_example' # str | 
section74_reference_number = 'section74_reference_number_example' # str | 

try:
    api_instance.update_section74_ha_status(body, work_reference_number, section74_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_section74_ha_status: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.Section74UpdatePromoterStatusRequest() # Section74UpdatePromoterStatusRequest | 
work_reference_number = 'work_reference_number_example' # str | 
section74_reference_number = 'section74_reference_number_example' # str | 

try:
    api_instance.update_section74_promoter_status(body, work_reference_number, section74_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_section74_promoter_status: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.Section81StatusUpdateRequest() # Section81StatusUpdateRequest | 
work_reference_number = 'work_reference_number_example' # str | 
section81_reference_number = 'section81_reference_number_example' # str | 

try:
    api_instance.update_section81_status(body, work_reference_number, section81_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_section81_status: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
file = 'file_example' # str | 
swa_code = 'swa_code_example' # str |  (optional)

try:
    api_response = api_instance.upload_file(file, swa_code=swa_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->upload_file: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.InspectionWithdrawRequest() # InspectionWithdrawRequest | 
work_reference_number = 'work_reference_number_example' # str | 
inspection_reference_number = 'inspection_reference_number_example' # str | 

try:
    api_instance.withdraw_inspection(body, work_reference_number, inspection_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->withdraw_inspection: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://department-for-transport-streetmanager.github.io/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**acknowledge_hs2_permit**](docs/DefaultApi.md#acknowledge_hs2_permit) | **PUT** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/hs2_acknowledgement | 
*DefaultApi* | [**add_file_to_work**](docs/DefaultApi.md#add_file_to_work) | **POST** /works/{workReferenceNumber}/files | 
*DefaultApi* | [**authenticate**](docs/DefaultApi.md#authenticate) | **POST** /authenticate | 
*DefaultApi* | [**calculate_duration**](docs/DefaultApi.md#calculate_duration) | **GET** /duration | 
*DefaultApi* | [**cancel_activity**](docs/DefaultApi.md#cancel_activity) | **PUT** /activity/{activityReferenceNumber}/cancel | 
*DefaultApi* | [**cancel_forward_plan**](docs/DefaultApi.md#cancel_forward_plan) | **PUT** /works/{workReferenceNumber}/forward-plans/{forwardPlanReferenceNumber}/cancel | 
*DefaultApi* | [**cancel_private_street_notice**](docs/DefaultApi.md#cancel_private_street_notice) | **PUT** /works/{workReferenceNumber}/private-street-notices/{privateStreetReferenceNumber}/cancel | 
*DefaultApi* | [**create_activity**](docs/DefaultApi.md#create_activity) | **POST** /activity | 
*DefaultApi* | [**create_ancillary_info**](docs/DefaultApi.md#create_ancillary_info) | **POST** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/ancillary-informations | 
*DefaultApi* | [**create_forward_plan**](docs/DefaultApi.md#create_forward_plan) | **POST** /forward-plans | 
*DefaultApi* | [**create_fpn**](docs/DefaultApi.md#create_fpn) | **POST** /works/{workReferenceNumber}/fixed-penalty-notices | 
*DefaultApi* | [**create_geographical_area**](docs/DefaultApi.md#create_geographical_area) | **POST** /geographical-areas | 
*DefaultApi* | [**create_historic_fpn**](docs/DefaultApi.md#create_historic_fpn) | **POST** /historic-works/fixed-penalty-notices | 
*DefaultApi* | [**create_historic_inspection**](docs/DefaultApi.md#create_historic_inspection) | **POST** /historic-works/inspections | 
*DefaultApi* | [**create_inspection**](docs/DefaultApi.md#create_inspection) | **POST** /works/{workReferenceNumber}/inspections | 
*DefaultApi* | [**create_materials_classification**](docs/DefaultApi.md#create_materials_classification) | **POST** /material-classifications | 
*DefaultApi* | [**create_non_notifiable_site**](docs/DefaultApi.md#create_non_notifiable_site) | **POST** /non-notifiable-works/sites | 
*DefaultApi* | [**create_permit**](docs/DefaultApi.md#create_permit) | **POST** /works/{workReferenceNumber}/permits | 
*DefaultApi* | [**create_permit_alteration**](docs/DefaultApi.md#create_permit_alteration) | **POST** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/alterations | 
*DefaultApi* | [**create_private_street_notice**](docs/DefaultApi.md#create_private_street_notice) | **POST** /private-street-notices | 
*DefaultApi* | [**create_reinstatement**](docs/DefaultApi.md#create_reinstatement) | **POST** /works/{workReferenceNumber}/sites/{siteReferenceNumber}/reinstatements | 
*DefaultApi* | [**create_scheduled_inspection**](docs/DefaultApi.md#create_scheduled_inspection) | **POST** /works/{workReferenceNumber}/scheduled-inspections | 
*DefaultApi* | [**create_section58**](docs/DefaultApi.md#create_section58) | **POST** /section-58s | 
*DefaultApi* | [**create_section74**](docs/DefaultApi.md#create_section74) | **POST** /works/{workReferenceNumber}/section-74s | 
*DefaultApi* | [**create_section81**](docs/DefaultApi.md#create_section81) | **POST** /section-81-works/section-81s | 
*DefaultApi* | [**create_site**](docs/DefaultApi.md#create_site) | **POST** /works/{workReferenceNumber}/sites | 
*DefaultApi* | [**create_work**](docs/DefaultApi.md#create_work) | **POST** /works | 
*DefaultApi* | [**delete_file**](docs/DefaultApi.md#delete_file) | **DELETE** /files/{fileId} | 
*DefaultApi* | [**delete_fpn**](docs/DefaultApi.md#delete_fpn) | **DELETE** /works/{workReferenceNumber}/fixed-penalty-notices/{fpnReferenceNumber} | 
*DefaultApi* | [**delete_inspection**](docs/DefaultApi.md#delete_inspection) | **DELETE** /works/{workReferenceNumber}/inspections/{inspectionReferenceNumber} | 
*DefaultApi* | [**delete_reinstatement**](docs/DefaultApi.md#delete_reinstatement) | **DELETE** /works/{workReferenceNumber}/sites/{siteReferenceNumber}/reinstatements/{reinstatementReferenceNumber} | 
*DefaultApi* | [**delete_scheduled_inspection**](docs/DefaultApi.md#delete_scheduled_inspection) | **DELETE** /works/{workReferenceNumber}/scheduled-inspections | 
*DefaultApi* | [**duration_challenge_non_acceptance_response**](docs/DefaultApi.md#duration_challenge_non_acceptance_response) | **PUT** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/alterations/{permitAlterationReferenceNumber}/duration-challenge-non-acceptance-response | 
*DefaultApi* | [**duration_challenge_review**](docs/DefaultApi.md#duration_challenge_review) | **PUT** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/alterations/{permitAlterationReferenceNumber}/duration-challenge-review | 
*DefaultApi* | [**get_activity**](docs/DefaultApi.md#get_activity) | **GET** /activity/{activityReferenceNumber} | 
*DefaultApi* | [**get_ancillary_info**](docs/DefaultApi.md#get_ancillary_info) | **GET** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/ancillary-informations/{ancillaryInformationReferenceNumber} | 
*DefaultApi* | [**get_comment**](docs/DefaultApi.md#get_comment) | **GET** /works/{workReferenceNumber}/comments/{commentReferenceNumber} | 
*DefaultApi* | [**get_earliest_permit**](docs/DefaultApi.md#get_earliest_permit) | **GET** /works/{workReferenceNumber}/earliest-permit | 
*DefaultApi* | [**get_fee_matrix**](docs/DefaultApi.md#get_fee_matrix) | **GET** /fee-matrix/{organisationReference} | 
*DefaultApi* | [**get_file**](docs/DefaultApi.md#get_file) | **GET** /files/{fileId} | 
*DefaultApi* | [**get_forward_plan**](docs/DefaultApi.md#get_forward_plan) | **GET** /works/{workReferenceNumber}/forward-plans/{forwardPlanReferenceNumber} | 
*DefaultApi* | [**get_fpn**](docs/DefaultApi.md#get_fpn) | **GET** /works/{workReferenceNumber}/fixed-penalty-notices/{fpnReferenceNumber} | 
*DefaultApi* | [**get_inspection**](docs/DefaultApi.md#get_inspection) | **GET** /works/{workReferenceNumber}/inspections/{inspectionReferenceNumber} | 
*DefaultApi* | [**get_material_classification**](docs/DefaultApi.md#get_material_classification) | **GET** /material-classifications/{materialClassificationReferenceNumber} | 
*DefaultApi* | [**get_non_compliance**](docs/DefaultApi.md#get_non_compliance) | **GET** /works/{workReferenceNumber}/non-compliances/{nonComplianceReferenceNumber} | 
*DefaultApi* | [**get_permit**](docs/DefaultApi.md#get_permit) | **GET** /works/{workReferenceNumber}/permits/{permitReferenceNumber} | 
*DefaultApi* | [**get_permit_alteration**](docs/DefaultApi.md#get_permit_alteration) | **GET** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/alterations/{permitAlterationReferenceNumber} | 
*DefaultApi* | [**get_private_street_notice**](docs/DefaultApi.md#get_private_street_notice) | **GET** /works/{workReferenceNumber}/private-street-notices/{privateStreetReferenceNumber} | 
*DefaultApi* | [**get_section58**](docs/DefaultApi.md#get_section58) | **GET** /section-58s/{section58ReferenceNumber} | 
*DefaultApi* | [**get_section74**](docs/DefaultApi.md#get_section74) | **GET** /works/{workReferenceNumber}/section-74s/{section74ReferenceNumber} | 
*DefaultApi* | [**get_section81**](docs/DefaultApi.md#get_section81) | **GET** /works/{workReferenceNumber}/section-81s/{section81ReferenceNumber} | 
*DefaultApi* | [**get_site**](docs/DefaultApi.md#get_site) | **GET** /works/{workReferenceNumber}/sites/{siteReferenceNumber} | 
*DefaultApi* | [**get_work**](docs/DefaultApi.md#get_work) | **GET** /works/{workReferenceNumber} | 
*DefaultApi* | [**get_work_category**](docs/DefaultApi.md#get_work_category) | **GET** /permits/category | 
*DefaultApi* | [**get_work_history**](docs/DefaultApi.md#get_work_history) | **GET** /works/{workReferenceNumber}/history | 
*DefaultApi* | [**impose_change**](docs/DefaultApi.md#impose_change) | **POST** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/alterations/impose | 
*DefaultApi* | [**link_permit_to_non_compliance**](docs/DefaultApi.md#link_permit_to_non_compliance) | **PUT** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/link-non-compliance | 
*DefaultApi* | [**link_section81_to_permit**](docs/DefaultApi.md#link_section81_to_permit) | **POST** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/link-section-81 | 
*DefaultApi* | [**mark_comment_as_read**](docs/DefaultApi.md#mark_comment_as_read) | **PUT** /works/{workReferenceNumber}/comments/{commentReferenceNumber}/read | 
*DefaultApi* | [**mark_permit_as_under_assessment**](docs/DefaultApi.md#mark_permit_as_under_assessment) | **PUT** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/under-assessment | 
*DefaultApi* | [**post_comment**](docs/DefaultApi.md#post_comment) | **POST** /works/{workReferenceNumber}/comments | 
*DefaultApi* | [**reassign_section81**](docs/DefaultApi.md#reassign_section81) | **PUT** /works/{workReferenceNumber}/section-81s/{section81ReferenceNumber}/reassign-section-81 | 
*DefaultApi* | [**remove_ancillary_info**](docs/DefaultApi.md#remove_ancillary_info) | **PUT** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/ancillary-informations/{ancillaryInformationReferenceNumber}/remove | 
*DefaultApi* | [**revert_actual_start_date**](docs/DefaultApi.md#revert_actual_start_date) | **PUT** /works/{workReferenceNumber}/revert-start | 
*DefaultApi* | [**revert_actual_stop_date**](docs/DefaultApi.md#revert_actual_stop_date) | **PUT** /works/{workReferenceNumber}/revert-stop | 
*DefaultApi* | [**subsume_site**](docs/DefaultApi.md#subsume_site) | **PUT** /works/{workReferenceNumber}/sites/{siteReferenceNumber}/subsume | 
*DefaultApi* | [**unlink_section81_from_permit**](docs/DefaultApi.md#unlink_section81_from_permit) | **POST** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/unlink-section-81 | 
*DefaultApi* | [**update_activity**](docs/DefaultApi.md#update_activity) | **PUT** /activity/{activityReferenceNumber} | 
*DefaultApi* | [**update_actual_start_date**](docs/DefaultApi.md#update_actual_start_date) | **PUT** /works/{workReferenceNumber}/start | 
*DefaultApi* | [**update_actual_stop_date**](docs/DefaultApi.md#update_actual_stop_date) | **PUT** /works/{workReferenceNumber}/stop | 
*DefaultApi* | [**update_assessment_status**](docs/DefaultApi.md#update_assessment_status) | **PUT** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/assessment | 
*DefaultApi* | [**update_current_traffic_management_type**](docs/DefaultApi.md#update_current_traffic_management_type) | **PUT** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/current-traffic-management-type | 
*DefaultApi* | [**update_excavation_carried_out**](docs/DefaultApi.md#update_excavation_carried_out) | **PUT** /works/{workReferenceNumber}/excavation-carried-out | 
*DefaultApi* | [**update_final_reinstatement**](docs/DefaultApi.md#update_final_reinstatement) | **PUT** /works/{workReferenceNumber}/final-reinstatement | 
*DefaultApi* | [**update_forward_plan**](docs/DefaultApi.md#update_forward_plan) | **PUT** /works/{workReferenceNumber}/forward-plans/{forwardPlanReferenceNumber} | 
*DefaultApi* | [**update_fpn_status**](docs/DefaultApi.md#update_fpn_status) | **PUT** /works/{workReferenceNumber}/fixed-penalty-notices/{fpnReferenceNumber}/status | 
*DefaultApi* | [**update_geographical_area**](docs/DefaultApi.md#update_geographical_area) | **PUT** /geographical-areas/{geographicalAreaReferenceNumber} | 
*DefaultApi* | [**update_inspection_outcome_status**](docs/DefaultApi.md#update_inspection_outcome_status) | **PUT** /works/{workReferenceNumber}/inspections/{inspectionReferenceNumber}/status | 
*DefaultApi* | [**update_non_compliance_status**](docs/DefaultApi.md#update_non_compliance_status) | **PUT** /works/{workReferenceNumber}/non-compliances/{nonComplianceReferenceNumber}/status | 
*DefaultApi* | [**update_permit_alteration_status**](docs/DefaultApi.md#update_permit_alteration_status) | **PUT** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/alterations/{permitAlterationReferenceNumber}/status | 
*DefaultApi* | [**update_permit_discount**](docs/DefaultApi.md#update_permit_discount) | **PUT** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/permit-discount | 
*DefaultApi* | [**update_permit_duration_challenge_non_acceptance_response**](docs/DefaultApi.md#update_permit_duration_challenge_non_acceptance_response) | **PUT** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/duration-challenge-non-acceptance-response | 
*DefaultApi* | [**update_permit_duration_challenge_review**](docs/DefaultApi.md#update_permit_duration_challenge_review) | **PUT** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/duration-challenge-review | 
*DefaultApi* | [**update_permit_lane_rental_assessment**](docs/DefaultApi.md#update_permit_lane_rental_assessment) | **PUT** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/lane-rental-assessments | 
*DefaultApi* | [**update_permit_status**](docs/DefaultApi.md#update_permit_status) | **PUT** /works/{workReferenceNumber}/permits/{permitReferenceNumber}/status | 
*DefaultApi* | [**update_section58_status**](docs/DefaultApi.md#update_section58_status) | **PUT** /section-58s/{section58ReferenceNumber}/status | 
*DefaultApi* | [**update_section74_ha_status**](docs/DefaultApi.md#update_section74_ha_status) | **PUT** /works/{workReferenceNumber}/section-74s/{section74ReferenceNumber}/highway-authority-status | 
*DefaultApi* | [**update_section74_promoter_status**](docs/DefaultApi.md#update_section74_promoter_status) | **PUT** /works/{workReferenceNumber}/section-74s/{section74ReferenceNumber}/promoter-status | 
*DefaultApi* | [**update_section81_status**](docs/DefaultApi.md#update_section81_status) | **PUT** /works/{workReferenceNumber}/section-81s/{section81ReferenceNumber}/status | 
*DefaultApi* | [**upload_file**](docs/DefaultApi.md#upload_file) | **POST** /files | 
*DefaultApi* | [**withdraw_inspection**](docs/DefaultApi.md#withdraw_inspection) | **PUT** /works/{workReferenceNumber}/inspections/{inspectionReferenceNumber}/withdraw | 

## Documentation For Models

 - [ASDCode](docs/ASDCode.md)
 - [ASDCodeResponse](docs/ASDCodeResponse.md)
 - [ASDPeriodicityCode](docs/ASDPeriodicityCode.md)
 - [ASDPeriodicityCodeResponse](docs/ASDPeriodicityCodeResponse.md)
 - [ActivityActivityType](docs/ActivityActivityType.md)
 - [ActivityActivityTypeResponse](docs/ActivityActivityTypeResponse.md)
 - [ActivityCancelRequest](docs/ActivityCancelRequest.md)
 - [ActivityCreateRequest](docs/ActivityCreateRequest.md)
 - [ActivityCreateResponse](docs/ActivityCreateResponse.md)
 - [ActivityResponse](docs/ActivityResponse.md)
 - [ActivityType](docs/ActivityType.md)
 - [ActivityTypeResponse](docs/ActivityTypeResponse.md)
 - [ActivityUpdateRequest](docs/ActivityUpdateRequest.md)
 - [AddFileToWorkRequest](docs/AddFileToWorkRequest.md)
 - [AllOfForwardPlanCreateRequestHs2HighwayExemption](docs/AllOfForwardPlanCreateRequestHs2HighwayExemption.md)
 - [AllOfForwardPlanCreateRequestHs2WorkType](docs/AllOfForwardPlanCreateRequestHs2WorkType.md)
 - [AllOfForwardPlanCreateRequestTrafficManagementType](docs/AllOfForwardPlanCreateRequestTrafficManagementType.md)
 - [AllOfForwardPlanResponseHs2HighwayExemption](docs/AllOfForwardPlanResponseHs2HighwayExemption.md)
 - [AllOfForwardPlanResponseHs2WorksType](docs/AllOfForwardPlanResponseHs2WorksType.md)
 - [AllOfForwardPlanResponseTrafficManagementType](docs/AllOfForwardPlanResponseTrafficManagementType.md)
 - [AllOfForwardPlanUpdateRequestTrafficManagementType](docs/AllOfForwardPlanUpdateRequestTrafficManagementType.md)
 - [AllOfHistoricInspectionCreateRequestDefectFixedOnSite](docs/AllOfHistoricInspectionCreateRequestDefectFixedOnSite.md)
 - [AllOfHistoricInspectionCreateRequestInspectionCategory](docs/AllOfHistoricInspectionCreateRequestInspectionCategory.md)
 - [AllOfHistoricInspectionCreateRequestReinspectionCategory](docs/AllOfHistoricInspectionCreateRequestReinspectionCategory.md)
 - [AllOfHistoricInspectionCreateRequestReinspectionType](docs/AllOfHistoricInspectionCreateRequestReinspectionType.md)
 - [AllOfInspectionCreateRequestDefectFixedOnSite](docs/AllOfInspectionCreateRequestDefectFixedOnSite.md)
 - [AllOfInspectionCreateRequestInspectionCategory](docs/AllOfInspectionCreateRequestInspectionCategory.md)
 - [AllOfInspectionCreateRequestReinspectionCategory](docs/AllOfInspectionCreateRequestReinspectionCategory.md)
 - [AllOfInspectionCreateRequestReinspectionType](docs/AllOfInspectionCreateRequestReinspectionType.md)
 - [AllOfInspectionResponseDefectFixedOnSite](docs/AllOfInspectionResponseDefectFixedOnSite.md)
 - [AllOfInspectionResponseHaResponseStatus](docs/AllOfInspectionResponseHaResponseStatus.md)
 - [AllOfInspectionResponseInspectionCategory](docs/AllOfInspectionResponseInspectionCategory.md)
 - [AllOfInspectionResponseInspectionReasonForWithdrawal](docs/AllOfInspectionResponseInspectionReasonForWithdrawal.md)
 - [AllOfInspectionResponsePromoterResponseStatus](docs/AllOfInspectionResponsePromoterResponseStatus.md)
 - [AllOfInspectionSummaryResponseInspectionCategory](docs/AllOfInspectionSummaryResponseInspectionCategory.md)
 - [AllOfInspectionSummaryResponseInspectionOutcome](docs/AllOfInspectionSummaryResponseInspectionOutcome.md)
 - [AllOfMaterialClassificationResponseFile](docs/AllOfMaterialClassificationResponseFile.md)
 - [AllOfNonComplianceResponseJsmStatus](docs/AllOfNonComplianceResponseJsmStatus.md)
 - [AllOfNonComplianceResponsePromoterResponseStatus](docs/AllOfNonComplianceResponsePromoterResponseStatus.md)
 - [AllOfPermitASDResponseSpecialDesigPeriodicityCode](docs/AllOfPermitASDResponseSpecialDesigPeriodicityCode.md)
 - [AllOfPermitASDSpecialDesigPeriodicityCode](docs/AllOfPermitASDSpecialDesigPeriodicityCode.md)
 - [AllOfPermitAlterationCreateRequestCollaborationType](docs/AllOfPermitAlterationCreateRequestCollaborationType.md)
 - [AllOfPermitAlterationResponseDurationChallengeNonAcceptanceResponseStatus](docs/AllOfPermitAlterationResponseDurationChallengeNonAcceptanceResponseStatus.md)
 - [AllOfPermitAlterationResponseDurationChallengeReviewStatus](docs/AllOfPermitAlterationResponseDurationChallengeReviewStatus.md)
 - [AllOfPermitAlterationResponsePermitStatus](docs/AllOfPermitAlterationResponsePermitStatus.md)
 - [AllOfPermitCreateRequestCollaborationType](docs/AllOfPermitCreateRequestCollaborationType.md)
 - [AllOfPermitCreateRequestHs2HighwayExemption](docs/AllOfPermitCreateRequestHs2HighwayExemption.md)
 - [AllOfPermitLaneRentalAssessmentUpdateRequestChargeBand](docs/AllOfPermitLaneRentalAssessmentUpdateRequestChargeBand.md)
 - [AllOfPermitResponseAssessmentStatus](docs/AllOfPermitResponseAssessmentStatus.md)
 - [AllOfPermitResponseCollaborationType](docs/AllOfPermitResponseCollaborationType.md)
 - [AllOfPermitResponseCurrentTrafficManagementType](docs/AllOfPermitResponseCurrentTrafficManagementType.md)
 - [AllOfPermitResponseDurationChallengeNonAcceptanceResponseStatus](docs/AllOfPermitResponseDurationChallengeNonAcceptanceResponseStatus.md)
 - [AllOfPermitResponseDurationChallengeReviewStatus](docs/AllOfPermitResponseDurationChallengeReviewStatus.md)
 - [AllOfPermitResponseHs2HighwayExemption](docs/AllOfPermitResponseHs2HighwayExemption.md)
 - [AllOfPermitResponseLaneRentalAssessmentChargeBand](docs/AllOfPermitResponseLaneRentalAssessmentChargeBand.md)
 - [AllOfPermitResponseLaneRentalAssessmentOutcome](docs/AllOfPermitResponseLaneRentalAssessmentOutcome.md)
 - [AllOfPermitResponseLinkedSection81](docs/AllOfPermitResponseLinkedSection81.md)
 - [AllOfPermitResponsePermitCancellationReason](docs/AllOfPermitResponsePermitCancellationReason.md)
 - [AllOfPermitStatusUpdateRequestPermitCancellationReason](docs/AllOfPermitStatusUpdateRequestPermitCancellationReason.md)
 - [AllOfScheduledInspectionCreateRequestScheduledInspectionCategory](docs/AllOfScheduledInspectionCreateRequestScheduledInspectionCategory.md)
 - [AllOfSection74ResponsePromoterStatus](docs/AllOfSection74ResponsePromoterStatus.md)
 - [AllOfSection81CreateRequestSection81Severity](docs/AllOfSection81CreateRequestSection81Severity.md)
 - [AllOfSection81ResponseLinkedPermit](docs/AllOfSection81ResponseLinkedPermit.md)
 - [AllOfSection81ResponsePromoterStatus](docs/AllOfSection81ResponsePromoterStatus.md)
 - [AllOfSection81ResponseSection81WorkType](docs/AllOfSection81ResponseSection81WorkType.md)
 - [AllOfSection81StatusUpdateRequestWorkType](docs/AllOfSection81StatusUpdateRequestWorkType.md)
 - [AllOfWorkCreateRequestCollaborationType](docs/AllOfWorkCreateRequestCollaborationType.md)
 - [AllOfWorkCreateRequestHs2HighwayExemption](docs/AllOfWorkCreateRequestHs2HighwayExemption.md)
 - [AllOfWorkResponseActivePermit](docs/AllOfWorkResponseActivePermit.md)
 - [AllOfWorkResponseForwardPlan](docs/AllOfWorkResponseForwardPlan.md)
 - [AllOfWorkResponsePrivateStreetNotice](docs/AllOfWorkResponsePrivateStreetNotice.md)
 - [AllOfWorkResponsePromoterOrganisationIndustryType](docs/AllOfWorkResponsePromoterOrganisationIndustryType.md)
 - [AllOfWorkResponseSection81](docs/AllOfWorkResponseSection81.md)
 - [AlterationStatus](docs/AlterationStatus.md)
 - [AlterationStatusResponse](docs/AlterationStatusResponse.md)
 - [AlterationTypeResponse](docs/AlterationTypeResponse.md)
 - [AncillaryInfoResponse](docs/AncillaryInfoResponse.md)
 - [AncillaryInfoStatusResponse](docs/AncillaryInfoStatusResponse.md)
 - [AncillaryInfoSummaryResponse](docs/AncillaryInfoSummaryResponse.md)
 - [AncillaryInfoType](docs/AncillaryInfoType.md)
 - [AncillaryInfoTypeResponse](docs/AncillaryInfoTypeResponse.md)
 - [ApplicationType](docs/ApplicationType.md)
 - [ApplicationTypeResponse](docs/ApplicationTypeResponse.md)
 - [AssessmentStatus](docs/AssessmentStatus.md)
 - [AssessmentStatusResponse](docs/AssessmentStatusResponse.md)
 - [AuditEvent](docs/AuditEvent.md)
 - [AuthenticationRequest](docs/AuthenticationRequest.md)
 - [AuthenticationResponse](docs/AuthenticationResponse.md)
 - [CloseFootpath](docs/CloseFootpath.md)
 - [CloseFootpathResponse](docs/CloseFootpathResponse.md)
 - [CloseFootway](docs/CloseFootway.md)
 - [CloseFootwayResponse](docs/CloseFootwayResponse.md)
 - [CollaborationType](docs/CollaborationType.md)
 - [CollaborationTypeResponse](docs/CollaborationTypeResponse.md)
 - [CommentCreateRequest](docs/CommentCreateRequest.md)
 - [CommentCreateResponse](docs/CommentCreateResponse.md)
 - [CommentReadRequest](docs/CommentReadRequest.md)
 - [CommentResponse](docs/CommentResponse.md)
 - [CommentTopic](docs/CommentTopic.md)
 - [CommentTopicResponse](docs/CommentTopicResponse.md)
 - [CreateAncillaryInfoRequest](docs/CreateAncillaryInfoRequest.md)
 - [CreateAncillaryInfoResponse](docs/CreateAncillaryInfoResponse.md)
 - [CurrentTrafficManagementTypeRequest](docs/CurrentTrafficManagementTypeRequest.md)
 - [DefectFixedOnsite](docs/DefectFixedOnsite.md)
 - [DefectFixedOnsiteResponse](docs/DefectFixedOnsiteResponse.md)
 - [DurationCalculationResponse](docs/DurationCalculationResponse.md)
 - [DurationChallengeNonAcceptanceResponseStatus](docs/DurationChallengeNonAcceptanceResponseStatus.md)
 - [DurationChallengeNonAcceptanceResponseStatusResponse](docs/DurationChallengeNonAcceptanceResponseStatusResponse.md)
 - [DurationChallengeReviewStatus](docs/DurationChallengeReviewStatus.md)
 - [DurationChallengeReviewStatusResponse](docs/DurationChallengeReviewStatusResponse.md)
 - [ExcavationCarriedOutUpdateRequest](docs/ExcavationCarriedOutUpdateRequest.md)
 - [FPNCreateRequest](docs/FPNCreateRequest.md)
 - [FPNCreateResponse](docs/FPNCreateResponse.md)
 - [FPNResponse](docs/FPNResponse.md)
 - [FPNStatus](docs/FPNStatus.md)
 - [FPNStatusResponse](docs/FPNStatusResponse.md)
 - [FPNStatusUpdateRequest](docs/FPNStatusUpdateRequest.md)
 - [FPNSummaryResponse](docs/FPNSummaryResponse.md)
 - [FailureReason](docs/FailureReason.md)
 - [FailureReasonDetails](docs/FailureReasonDetails.md)
 - [FailureReasonDetailsResponse](docs/FailureReasonDetailsResponse.md)
 - [FailureReasonResponse](docs/FailureReasonResponse.md)
 - [FeeMatrixRequest](docs/FeeMatrixRequest.md)
 - [FeeMatrixResponse](docs/FeeMatrixResponse.md)
 - [FileResponse](docs/FileResponse.md)
 - [FileSummaryResponse](docs/FileSummaryResponse.md)
 - [FilesBody](docs/FilesBody.md)
 - [FinalReinstatementUpdateRequest](docs/FinalReinstatementUpdateRequest.md)
 - [ForwardPlanCancelRequest](docs/ForwardPlanCancelRequest.md)
 - [ForwardPlanCreateRequest](docs/ForwardPlanCreateRequest.md)
 - [ForwardPlanCreateResponse](docs/ForwardPlanCreateResponse.md)
 - [ForwardPlanResponse](docs/ForwardPlanResponse.md)
 - [ForwardPlanStatusResponse](docs/ForwardPlanStatusResponse.md)
 - [ForwardPlanSummaryResponse](docs/ForwardPlanSummaryResponse.md)
 - [ForwardPlanUpdateRequest](docs/ForwardPlanUpdateRequest.md)
 - [ForwardPlanWorkType](docs/ForwardPlanWorkType.md)
 - [ForwardPlanWorkTypeResponse](docs/ForwardPlanWorkTypeResponse.md)
 - [GeographicalAreaCreateResponse](docs/GeographicalAreaCreateResponse.md)
 - [GeographicalareasBody](docs/GeographicalareasBody.md)
 - [GeographicalareasGeographicalAreaReferenceNumberBody](docs/GeographicalareasGeographicalAreaReferenceNumberBody.md)
 - [HS2AcknowledgementRequest](docs/HS2AcknowledgementRequest.md)
 - [HS2HighwayExemption](docs/HS2HighwayExemption.md)
 - [HS2HighwayExemptionResponse](docs/HS2HighwayExemptionResponse.md)
 - [HazardousMaterialType](docs/HazardousMaterialType.md)
 - [HazardousMaterialTypeResponse](docs/HazardousMaterialTypeResponse.md)
 - [HistoricFPNCreateRequest](docs/HistoricFPNCreateRequest.md)
 - [HistoricFPNCreateResponse](docs/HistoricFPNCreateResponse.md)
 - [HistoricFailureReasonDetails](docs/HistoricFailureReasonDetails.md)
 - [HistoricInspectionCreateRequest](docs/HistoricInspectionCreateRequest.md)
 - [HistoricInspectionCreateResponse](docs/HistoricInspectionCreateResponse.md)
 - [ImposeChangeRequest](docs/ImposeChangeRequest.md)
 - [ImposeChangeResponse](docs/ImposeChangeResponse.md)
 - [IndustrySectorResponse](docs/IndustrySectorResponse.md)
 - [InitialAuthenticationResponse](docs/InitialAuthenticationResponse.md)
 - [InspectionCategory](docs/InspectionCategory.md)
 - [InspectionCategoryResponse](docs/InspectionCategoryResponse.md)
 - [InspectionCreateRequest](docs/InspectionCreateRequest.md)
 - [InspectionCreateResponse](docs/InspectionCreateResponse.md)
 - [InspectionOutcome](docs/InspectionOutcome.md)
 - [InspectionOutcomeResponse](docs/InspectionOutcomeResponse.md)
 - [InspectionOutcomeStatusRequest](docs/InspectionOutcomeStatusRequest.md)
 - [InspectionOutcomeStatusType](docs/InspectionOutcomeStatusType.md)
 - [InspectionOutcomeStatusTypeResponse](docs/InspectionOutcomeStatusTypeResponse.md)
 - [InspectionReasonForWithdrawal](docs/InspectionReasonForWithdrawal.md)
 - [InspectionReasonForWithdrawalResponse](docs/InspectionReasonForWithdrawalResponse.md)
 - [InspectionResponse](docs/InspectionResponse.md)
 - [InspectionResponseTypeResponse](docs/InspectionResponseTypeResponse.md)
 - [InspectionStatusResponse](docs/InspectionStatusResponse.md)
 - [InspectionSummaryResponse](docs/InspectionSummaryResponse.md)
 - [InspectionType](docs/InspectionType.md)
 - [InspectionTypeResponse](docs/InspectionTypeResponse.md)
 - [InspectionWithdrawRequest](docs/InspectionWithdrawRequest.md)
 - [InterestedParty](docs/InterestedParty.md)
 - [JsmStatusResponse](docs/JsmStatusResponse.md)
 - [LaneRentalAssessmentChargeBand](docs/LaneRentalAssessmentChargeBand.md)
 - [LaneRentalAssessmentChargeBandResponse](docs/LaneRentalAssessmentChargeBandResponse.md)
 - [LaneRentalAssessmentOutcome](docs/LaneRentalAssessmentOutcome.md)
 - [LaneRentalAssessmentOutcomeResponse](docs/LaneRentalAssessmentOutcomeResponse.md)
 - [LayerAffected](docs/LayerAffected.md)
 - [LayerAffectedResponse](docs/LayerAffectedResponse.md)
 - [LinkSection81ToPermitRequest](docs/LinkSection81ToPermitRequest.md)
 - [LinkSection81ToPermitResponse](docs/LinkSection81ToPermitResponse.md)
 - [LinkedPermit](docs/LinkedPermit.md)
 - [LinkedSection81](docs/LinkedSection81.md)
 - [LocationType](docs/LocationType.md)
 - [LocationTypeResponse](docs/LocationTypeResponse.md)
 - [MarkPermitAsUnderAssessmentRequest](docs/MarkPermitAsUnderAssessmentRequest.md)
 - [MaterialClassificationClassification](docs/MaterialClassificationClassification.md)
 - [MaterialClassificationClassificationResponse](docs/MaterialClassificationClassificationResponse.md)
 - [MaterialClassificationCreateRequest](docs/MaterialClassificationCreateRequest.md)
 - [MaterialClassificationCreateResponse](docs/MaterialClassificationCreateResponse.md)
 - [MaterialClassificationResponse](docs/MaterialClassificationResponse.md)
 - [NonComplianceResponse](docs/NonComplianceResponse.md)
 - [NonComplianceResponseStatus](docs/NonComplianceResponseStatus.md)
 - [NonComplianceResponseStatusRequest](docs/NonComplianceResponseStatusRequest.md)
 - [NonComplianceResponseStatusResponse](docs/NonComplianceResponseStatusResponse.md)
 - [NonComplianceStatusResponse](docs/NonComplianceStatusResponse.md)
 - [NonComplianceSummaryResponse](docs/NonComplianceSummaryResponse.md)
 - [NonNotifiableSiteCreateRequest](docs/NonNotifiableSiteCreateRequest.md)
 - [NonNotifiableSiteCreateResponse](docs/NonNotifiableSiteCreateResponse.md)
 - [OffenceCode](docs/OffenceCode.md)
 - [OffenceCodeResponse](docs/OffenceCodeResponse.md)
 - [OverrunWarningReason](docs/OverrunWarningReason.md)
 - [OverrunWarningReasonResponse](docs/OverrunWarningReasonResponse.md)
 - [PaginationDetails](docs/PaginationDetails.md)
 - [PaymentMethod](docs/PaymentMethod.md)
 - [PaymentMethodResponse](docs/PaymentMethodResponse.md)
 - [PbiSampleInspectionSummaryResponse](docs/PbiSampleInspectionSummaryResponse.md)
 - [PermitASD](docs/PermitASD.md)
 - [PermitASDResponse](docs/PermitASDResponse.md)
 - [PermitAlterationCreateRequest](docs/PermitAlterationCreateRequest.md)
 - [PermitAlterationCreateResponse](docs/PermitAlterationCreateResponse.md)
 - [PermitAlterationDurationChallengeNonAcceptanceResponseRequest](docs/PermitAlterationDurationChallengeNonAcceptanceResponseRequest.md)
 - [PermitAlterationDurationChallengeReviewRequest](docs/PermitAlterationDurationChallengeReviewRequest.md)
 - [PermitAlterationResponse](docs/PermitAlterationResponse.md)
 - [PermitAlterationStatusUpdateRequest](docs/PermitAlterationStatusUpdateRequest.md)
 - [PermitAlterationSummaryResponse](docs/PermitAlterationSummaryResponse.md)
 - [PermitAssessmentUpdateRequest](docs/PermitAssessmentUpdateRequest.md)
 - [PermitCancellationReason](docs/PermitCancellationReason.md)
 - [PermitCancellationReasonResponse](docs/PermitCancellationReasonResponse.md)
 - [PermitCondition](docs/PermitCondition.md)
 - [PermitConditionResponse](docs/PermitConditionResponse.md)
 - [PermitConditionType](docs/PermitConditionType.md)
 - [PermitConditionTypeResponse](docs/PermitConditionTypeResponse.md)
 - [PermitCreateRequest](docs/PermitCreateRequest.md)
 - [PermitCreateResponse](docs/PermitCreateResponse.md)
 - [PermitDiscountUpdateRequest](docs/PermitDiscountUpdateRequest.md)
 - [PermitDurationChallengeNonAcceptanceResponseRequest](docs/PermitDurationChallengeNonAcceptanceResponseRequest.md)
 - [PermitDurationChallengeReviewRequest](docs/PermitDurationChallengeReviewRequest.md)
 - [PermitLaneRentalAssessmentUpdateRequest](docs/PermitLaneRentalAssessmentUpdateRequest.md)
 - [PermitNonComplianceLinkRequest](docs/PermitNonComplianceLinkRequest.md)
 - [PermitResponse](docs/PermitResponse.md)
 - [PermitStatus](docs/PermitStatus.md)
 - [PermitStatusResponse](docs/PermitStatusResponse.md)
 - [PermitStatusUpdateRequest](docs/PermitStatusUpdateRequest.md)
 - [PermitSummaryResponse](docs/PermitSummaryResponse.md)
 - [PrivateStreetNoticeCancelRequest](docs/PrivateStreetNoticeCancelRequest.md)
 - [PrivateStreetNoticeCreateRequest](docs/PrivateStreetNoticeCreateRequest.md)
 - [PrivateStreetNoticeCreateResponse](docs/PrivateStreetNoticeCreateResponse.md)
 - [PrivateStreetNoticeResponse](docs/PrivateStreetNoticeResponse.md)
 - [PrivateStreetStatusResponse](docs/PrivateStreetStatusResponse.md)
 - [PrivateStreetSummaryResponse](docs/PrivateStreetSummaryResponse.md)
 - [ReasonForRefusal](docs/ReasonForRefusal.md)
 - [ReasonForRefusalResponse](docs/ReasonForRefusalResponse.md)
 - [ReassignSection81Request](docs/ReassignSection81Request.md)
 - [ReinstatementCreateRequest](docs/ReinstatementCreateRequest.md)
 - [ReinstatementCreateResponse](docs/ReinstatementCreateResponse.md)
 - [ReinstatementResponse](docs/ReinstatementResponse.md)
 - [ReinstatementStatus](docs/ReinstatementStatus.md)
 - [ReinstatementStatusResponse](docs/ReinstatementStatusResponse.md)
 - [ReinstatementType](docs/ReinstatementType.md)
 - [ReinstatementTypeResponse](docs/ReinstatementTypeResponse.md)
 - [RemoveAncillaryInfoRequest](docs/RemoveAncillaryInfoRequest.md)
 - [RemoveAncillaryInfoResponse](docs/RemoveAncillaryInfoResponse.md)
 - [ScheduledInspectionCreateRequest](docs/ScheduledInspectionCreateRequest.md)
 - [Section58CreateRequest](docs/Section58CreateRequest.md)
 - [Section58CreateResponse](docs/Section58CreateResponse.md)
 - [Section58Duration](docs/Section58Duration.md)
 - [Section58DurationResponse](docs/Section58DurationResponse.md)
 - [Section58Extent](docs/Section58Extent.md)
 - [Section58ExtentResponse](docs/Section58ExtentResponse.md)
 - [Section58Response](docs/Section58Response.md)
 - [Section58Status](docs/Section58Status.md)
 - [Section58StatusResponse](docs/Section58StatusResponse.md)
 - [Section58UpdateStatusRequest](docs/Section58UpdateStatusRequest.md)
 - [Section74CreateRequest](docs/Section74CreateRequest.md)
 - [Section74CreateResponse](docs/Section74CreateResponse.md)
 - [Section74HAStatus](docs/Section74HAStatus.md)
 - [Section74HAStatusResponse](docs/Section74HAStatusResponse.md)
 - [Section74PromoterStatus](docs/Section74PromoterStatus.md)
 - [Section74PromoterStatusResponse](docs/Section74PromoterStatusResponse.md)
 - [Section74Response](docs/Section74Response.md)
 - [Section74SummaryResponse](docs/Section74SummaryResponse.md)
 - [Section74UpdateHAStatusRequest](docs/Section74UpdateHAStatusRequest.md)
 - [Section74UpdatePromoterStatusRequest](docs/Section74UpdatePromoterStatusRequest.md)
 - [Section81CreateRequest](docs/Section81CreateRequest.md)
 - [Section81CreateResponse](docs/Section81CreateResponse.md)
 - [Section81Response](docs/Section81Response.md)
 - [Section81Severity](docs/Section81Severity.md)
 - [Section81SeverityResponse](docs/Section81SeverityResponse.md)
 - [Section81Status](docs/Section81Status.md)
 - [Section81StatusResponse](docs/Section81StatusResponse.md)
 - [Section81StatusUpdateRequest](docs/Section81StatusUpdateRequest.md)
 - [Section81SummaryResponse](docs/Section81SummaryResponse.md)
 - [Section81Type](docs/Section81Type.md)
 - [Section81TypeResponse](docs/Section81TypeResponse.md)
 - [Section81WorkType](docs/Section81WorkType.md)
 - [Section81WorkTypeResponse](docs/Section81WorkTypeResponse.md)
 - [SiteCreateRequest](docs/SiteCreateRequest.md)
 - [SiteCreateResponse](docs/SiteCreateResponse.md)
 - [SiteDetails](docs/SiteDetails.md)
 - [SiteResponse](docs/SiteResponse.md)
 - [SiteSummaryResponse](docs/SiteSummaryResponse.md)
 - [SubsumeSiteRequest](docs/SubsumeSiteRequest.md)
 - [TrafficManagementType](docs/TrafficManagementType.md)
 - [TrafficManagementTypeResponse](docs/TrafficManagementTypeResponse.md)
 - [UnlinkSection81FromPermitRequest](docs/UnlinkSection81FromPermitRequest.md)
 - [WorkCategoryResponse](docs/WorkCategoryResponse.md)
 - [WorkCategoryResponseEnum](docs/WorkCategoryResponseEnum.md)
 - [WorkCreateRequest](docs/WorkCreateRequest.md)
 - [WorkCreateResponse](docs/WorkCreateResponse.md)
 - [WorkHistoryResponse](docs/WorkHistoryResponse.md)
 - [WorkHistorySummaryResponse](docs/WorkHistorySummaryResponse.md)
 - [WorkResponse](docs/WorkResponse.md)
 - [WorkStartRevertRequest](docs/WorkStartRevertRequest.md)
 - [WorkStartUpdateRequest](docs/WorkStartUpdateRequest.md)
 - [WorkStatusResponse](docs/WorkStatusResponse.md)
 - [WorkStopRevertRequest](docs/WorkStopRevertRequest.md)
 - [WorkStopUpdateRequest](docs/WorkStopUpdateRequest.md)
 - [WorkType](docs/WorkType.md)
 - [WorkTypeResponse](docs/WorkTypeResponse.md)

## Documentation For Authorization


## token

- **Type**: API key
- **API key parameter name**: token
- **Location**: HTTP header


## Author


